/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.service;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.extra.service.GTSServiceRequest;
import org.opengts.extra.service.ServiceXML;
import org.opengts.util.DateTime;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.SendMail;
import org.opengts.util.ServiceRequest;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceClient
implements ServiceXML {
    private static final String[] ARG_HELP = new String[]{"help", "h"};
    private static final String[] ARG_VERSBOSE = new String[]{"verbose", "v"};
    private static final String[] ARG_QUIET = new String[]{"quiet", "q"};
    private static final String[] ARG_NOEMAIL = new String[]{"noemail", "debug"};
    private static final String[] ARG_FILE = new String[]{"file", "xml"};
    private static final String[] ARG_REPORTJOB = new String[]{"reportJob", "report"};
    private static final String[] ARG_MISC_ARG = new String[]{"arg"};
    private static final String[] ARG_TABLE = new String[]{"table"};
    private static final String[] ARG_COMMAND = new String[]{"command", "c"};
    private static final String[] ARG_URL = new String[]{"url", "SERVICE_URL", "GTSRequest.url"};
    private static final String[] ARG_ACCOUNT = new String[]{"account", "a", "SERVICE_ACCOUNT"};
    private static final String[] ARG_DEVICE = new String[]{"device", "d", "SERVICE_DEVICE"};
    private static final String[] ARG_USER = new String[]{"user", "u", "SERVICE_USER"};
    private static final String[] ARG_PASSWORD = new String[]{"password", "p", "SERVICE_PASSWORD"};

    private static void listAccounts(GTSServiceRequest servReq) {
    }

    private static void usage_exit(int exitCode) {
        Print.sysPrintln((String)"Description:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  Web-service client tool.", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + ServiceClient.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -url=<url>      Service URL", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>   Account ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -user=<id>      User ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -password=<pwd> Password", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"File Command Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -file=<file>    Load request from specified XML file", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Command-Line Command Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -device=<id>    Device ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -command=<cmd>  Command [login|logout|dbschema|dbget|dbput|dbdel|propget|report|mapdata|pushpins|messages|commands]", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -arg=<arg>      Command argument", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -table=<table>  Table name", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Example Env Vars:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  export SERVICE_URL=http://localhost:8080/track/Service", (Object[])new Object[0]);
        Print.sysPrintln((String)"  export SERVICE_ACCOUNT=demo", (Object[])new Object[0]);
        Print.sysPrintln((String)"  export SERVICE_USER=user", (Object[])new Object[0]);
        Print.sysPrintln((String)"  export SERVICE_PASSWORD=", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        System.exit(exitCode);
    }

    public static int cron(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        boolean verbose = true;
        if (RTConfig.hasProperty((String[])ARG_VERSBOSE)) {
            verbose = RTConfig.getBoolean((String[])ARG_VERSBOSE, (boolean)true);
        } else if (RTConfig.hasProperty((String[])ARG_QUIET)) {
            boolean bl = verbose = !RTConfig.getBoolean((String[])ARG_QUIET, (boolean)false);
        }
        if (RTConfig.getBoolean((String[])ARG_NOEMAIL, (boolean)false)) {
            SendMail.SetThreadModel((String)"none");
        } else {
            SendMail.SetThreadModel((String)"current");
        }
        String urlStr = RTConfig.getString((String[])ARG_URL, (String)"");
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String userID = RTConfig.getString((String[])ARG_USER, (String)"");
        String passwd = RTConfig.getString((String[])ARG_PASSWORD, (String)"");
        GTSServiceRequest servReq = null;
        try {
            if (StringTools.isBlank((String)urlStr)) {
                Print.logError((String)"GTSRequest URL not specified", (Object[])new Object[0]);
                return 1;
            }
            servReq = new GTSServiceRequest(urlStr);
            servReq.setAuthorization(acctID, userID, passwd);
        }
        catch (MalformedURLException mue) {
            Print.logException((String)"Error", (Throwable)mue);
            return 1;
        }
        if (RTConfig.hasProperty((String[])ARG_FILE)) {
            File file = RTConfig.getFile((String[])ARG_FILE, null);
            if (file == null) {
                Print.sysPrintln((String)"Warning] GTSRequest file not specified.", (Object[])new Object[0]);
            } else if (!file.isFile()) {
                Print.sysPrintln((String)("ERROR] GTSRequest file does not exist: " + file), (Object[])new Object[0]);
            } else {
                Document xmlDoc = null;
                try {
                    xmlDoc = servReq.sendRequest(file);
                    if (xmlDoc == null) {
                        Print.logError((String)"Request error ...", (Object[])new Object[0]);
                        return 99;
                    }
                    if (verbose) {
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                        Print.sysPrintln((String)"Response:", (Object[])new Object[0]);
                        Print.sysPrintln((String)XMLTools.nodeToString((Node)xmlDoc), (Object[])new Object[0]);
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                    }
                }
                catch (IOException ioe) {
                    Print.logException((String)"Error", (Throwable)ioe);
                    return 99;
                }
            }
            return 0;
        }
        if (RTConfig.hasProperty((String[])ARG_REPORTJOB)) {
            String cronTag = RTConfig.getString((String[])ARG_REPORTJOB, (String)"");
        }
        return 1;
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        boolean verbose = true;
        if (RTConfig.hasProperty((String[])ARG_VERSBOSE)) {
            verbose = RTConfig.getBoolean((String[])ARG_VERSBOSE, (boolean)true);
        } else if (RTConfig.hasProperty((String[])ARG_QUIET)) {
            boolean bl = verbose = !RTConfig.getBoolean((String[])ARG_QUIET, (boolean)false);
        }
        if (RTConfig.hasProperty((String[])ARG_HELP)) {
            ServiceClient.usage_exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_FILE)) {
            int exitCode = ServiceClient.cron(args);
            if (exitCode == 1) {
                ServiceClient.usage_exit(exitCode);
            }
            System.exit(exitCode);
        }
        String urlStr = RTConfig.getString((String[])ARG_URL, (String)"");
        final String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String userID = RTConfig.getString((String[])ARG_USER, (String)"");
        String passwd = RTConfig.getString((String[])ARG_PASSWORD, (String)"");
        GTSServiceRequest servReq = null;
        try {
            servReq = new GTSServiceRequest(urlStr);
            servReq.setAuthorization(acctID, userID, passwd);
        }
        catch (MalformedURLException mue) {
            Print.logException((String)"Error", (Throwable)mue);
            System.exit(99);
        }
        String command = RTConfig.getString((String[])ARG_COMMAND, (String)"");
        final String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (command.equalsIgnoreCase("version")) {
            try {
                String version = servReq.getVersion();
                Print.sysPrintln((String)("Version: " + version), (Object[])new Object[0]);
            }
            catch (Throwable th) {
                Print.logException((String)"Error", (Throwable)th);
            }
            System.exit(0);
        } else if (command.equalsIgnoreCase("dbschema")) {
            try {
                String tableName = RTConfig.getString((String[])ARG_TABLE, (String)"");
                Document xmlDoc = servReq.getTableSchema_Document(tableName);
            }
            catch (Throwable th) {
                Print.logException((String)"Error", (Throwable)th);
            }
            System.exit(0);
        } else if (command.equalsIgnoreCase("mapdata")) {
            try {
                DateTime frDT = new DateTime(null, 2007, 3, 13, 0, 0, 0);
                DateTime toDT = new DateTime(null, 2007, 3, 13, 23, 59, 59);
                Document xmlDoc = servReq.getMapDataDevice_Document(devID, frDT, toDT);
            }
            catch (Throwable th) {
                Print.logException((String)"Error", (Throwable)th);
            }
            System.exit(0);
        } else if (command.equalsIgnoreCase("report")) {
            try {
                String rtpName = RTConfig.getString((String[])ARG_MISC_ARG, (String)"EventDetail");
                DateTime frDT = new DateTime(null, 2007, 3, 13, 0, 0, 0);
                DateTime toDT = new DateTime(null, 2007, 3, 13, 23, 59, 59);
                Document xmlDoc = servReq.getReportDevice_Document(rtpName, devID, frDT, toDT);
            }
            catch (Throwable th) {
                Print.logException((String)"Error", (Throwable)th);
            }
            System.exit(0);
        } else if (command.equalsIgnoreCase("reportJob")) {
            try {
                String rtpGrpTag = RTConfig.getString((String[])ARG_MISC_ARG, (String)"");
                Document xmlDoc = servReq.getReportJob_Document(rtpGrpTag);
            }
            catch (Throwable th) {
                Print.logException((String)"Error", (Throwable)th);
            }
            System.exit(0);
        } else if (command.equalsIgnoreCase("getAccount")) {
            try {
                Account account = servReq.getAccount(acctID);
            }
            catch (DBException dbe) {
                Print.logException((String)"Account", (Throwable)dbe);
            }
            System.exit(0);
        } else if (command.equalsIgnoreCase("getAccounts")) {
            try {
                String[] acctIDList = servReq.getAccountIDs();
                for (int i = 0; i < acctIDList.length; ++i) {
                    String virtAcctID = acctIDList[i];
                    try {
                        Print.sysPrintln((String)(" " + (i + 1) + ": " + virtAcctID), (Object[])new Object[0]);
                        Account acct = servReq.getAccount(virtAcctID);
                        Print.sysPrintln((String)("Account: " + acct), (Object[])new Object[0]);
                        continue;
                    }
                    catch (DBException dbe) {
                        Print.logException((String)("Account error: " + virtAcctID), (Throwable)dbe);
                    }
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Account List", (Throwable)dbe);
            }
            System.exit(0);
        } else if (command.equalsIgnoreCase("getDevice")) {
            try {
                Device device = servReq.getDevice(acctID, devID);
            }
            catch (DBException dbe) {
                Print.logException((String)"Device", (Throwable)dbe);
            }
            System.exit(0);
        } else if (command.equalsIgnoreCase("getUser")) {
            try {
                User user = servReq.getUser(acctID, userID);
            }
            catch (DBException dbe) {
                Print.logException((String)"User", (Throwable)dbe);
            }
            System.exit(0);
        }
        Object reqBody = null;
        if (command.equalsIgnoreCase("dbget")) {
            boolean rcdType = RTConfig.getString((String[])ARG_MISC_ARG, (String)"").equalsIgnoreCase("rcd");
            final String tagName = rcdType ? "Record" : "RecordKey";
            final String tableName = RTConfig.getString((String[])ARG_TABLE, (String)"Device");
            reqBody = new ServiceRequest.RequestBody(){

                public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                    sb.append("   <" + tagName + " table=\"" + tableName + "\" " + "partial" + "=\"true\">\n");
                    sb.append("      <Field name=\"accountID\">" + acctID + "</Field>\n");
                    sb.append("      <Field name=\"description\"/>\n");
                    sb.append("   </" + tagName + ">\n");
                    return sb;
                }
            };
        } else if (command.equalsIgnoreCase("dbput")) {
            final String desc = RTConfig.getString((String[])ARG_MISC_ARG, (String)"");
            final String tableName = RTConfig.getString((String[])ARG_TABLE, (String)"Device");
            reqBody = new ServiceRequest.RequestBody(){

                public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                    sb.append("   <Record table=\"" + tableName + "\">\n");
                    sb.append("      <Field name=\"accountID\">" + acctID + "</Field>\n");
                    sb.append("      <Field name=\"deviceID\">" + devID + "</Field>\n");
                    sb.append("      <Field name=\"description\">" + desc + "</Field>\n");
                    sb.append("   </Record>\n");
                    return sb;
                }
            };
        } else if (!command.equalsIgnoreCase("commands")) {
            Print.sysPrintln((String)("Unrecognized command: " + command), (Object[])new Object[0]);
            ServiceClient.usage_exit(1);
        }
        Document xmlDoc = null;
        try {
            xmlDoc = servReq.sendRequest(command, (ServiceRequest.RequestBody)reqBody);
        }
        catch (IOException ioe) {
            Print.logException((String)"Error", (Throwable)ioe);
        }
    }
}

