/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.service;

import java.io.IOException;
import java.net.MalformedURLException;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBRecord;
import org.opengts.extra.service.ServiceXML;
import org.opengts.util.DateTime;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.ServiceRequest;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GTSServiceRequest
extends ServiceRequest
implements ServiceXML {
    public static boolean isGTSResponse(Document gtsRespDoc) {
        if (gtsRespDoc == null) {
            return false;
        }
        Element gtsResp = gtsRespDoc.getDocumentElement();
        String gtsRespTag = gtsResp.getTagName();
        return gtsRespTag.equalsIgnoreCase("GTSResponse");
    }

    public static String getGTSReportsResult(Document gtsRespDoc) {
        if (!GTSServiceRequest.isGTSResponse(gtsRespDoc)) {
            return null;
        }
        Element gtsResp = gtsRespDoc.getDocumentElement();
        return XMLTools.getAttribute((Element)gtsResp, (String)"result", (String)"", (boolean)false);
    }

    public static boolean isGTSResponseError(Document gtsRespDoc) {
        String result = GTSServiceRequest.getGTSReportsResult(gtsRespDoc);
        if (result == null) {
            return false;
        }
        if (StringTools.isBlank((String)result)) {
            return false;
        }
        return result.equalsIgnoreCase("error");
    }

    public static String getGTSResponse_Message_code(Document gtsRespDoc) {
        if (!GTSServiceRequest.isGTSResponse(gtsRespDoc)) {
            return null;
        }
        NodeList msgList = XMLTools.getChildElements((Node)gtsRespDoc, (String)"Message");
        if (msgList.getLength() <= 0) {
            return "";
        }
        Element msgElem = (Element)msgList.item(0);
        return XMLTools.getAttribute((Element)msgElem, (String)"code", (String)"", (boolean)false);
    }

    public GTSServiceRequest(String url) throws MalformedURLException {
        super(url);
        this.setJMXObjectName("org.opengts.extra.war.service:type=ServiceProxy");
    }

    public Document getCommandOnly_Document(String command) throws IOException {
        return this.sendRequest(command, new ServiceRequest.RequestBody(){

            public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                return sb;
            }
        });
    }

    protected StringBuffer formatTime(StringBuffer sb, String pfx, DateTime dt, boolean isTimeTo) {
        if (dt != null) {
            String tag = isTimeTo ? "TimeTo" : "TimeFrom";
            sb.append(pfx);
            sb.append("<" + tag);
            sb.append(" timezone=\"" + dt.getTimeZoneShortName() + "\"");
            sb.append(">");
            sb.append(dt.format("yyyy/MM/dd,HH:mm:ss"));
            sb.append("</" + tag + ">\n");
        }
        return sb;
    }

    protected NodeList getResponseNodeList(Document respDoc, String tag) {
        if (respDoc == null || StringTools.isBlank((String)tag)) {
            return null;
        }
        Element gtsResponse = respDoc.getDocumentElement();
        if (!gtsResponse.getTagName().equalsIgnoreCase("GTSResponse")) {
            return null;
        }
        String result = XMLTools.getAttribute((Element)gtsResponse, (String)"result", (String)"", (boolean)false);
        if (result.equalsIgnoreCase("success")) {
            return null;
        }
        NodeList nodeList = XMLTools.getChildElements((Node)gtsResponse, (String)tag);
        return nodeList.getLength() > 0 ? nodeList : null;
    }

    public Document getVersion_Document() throws IOException {
        return this.getCommandOnly_Document("version");
    }

    public String getVersion() throws IOException {
        NodeList versList = this.getResponseNodeList(this.getVersion_Document(), "Version");
        if (versList != null) {
            Element versElem = (Element)versList.item(0);
            String version = XMLTools.getNodeText((Node)versElem, (String)" ", (boolean)false);
            return version;
        }
        return null;
    }

    public Document getProperty_Document(final String propKey) throws IOException {
        return this.sendRequest("propget", new ServiceRequest.RequestBody(){

            public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                String pfx1 = StringTools.replicateString((String)" ", (int)indent);
                sb.append(pfx1).append("<Property key=\"" + propKey + "\"/>\n");
                return sb;
            }
        });
    }

    public String getProperty(String propKey) throws IOException {
        NodeList propList = this.getResponseNodeList(this.getProperty_Document(propKey), "Property");
        if (propList != null) {
            Element propElem = (Element)propList.item(0);
            String propVal = XMLTools.getNodeText((Node)propElem, (String)"\n", (boolean)false);
            return propVal;
        }
        return null;
    }

    public Document getTableSchema_Document(final String tableName) throws IOException {
        return this.sendRequest("dbschema", new ServiceRequest.RequestBody(){

            public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                String pfx1 = StringTools.replicateString((String)" ", (int)indent);
                sb.append(pfx1).append("<TableSchema table=\"" + tableName + "\"/>\n");
                return sb;
            }
        });
    }

    public Document getMapDataDevice_Document(final String deviceID, final DateTime frDT, final DateTime toDT) throws IOException {
        return this.sendRequest("mapdata", new ServiceRequest.RequestBody(){

            public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                String pfx1 = StringTools.replicateString((String)" ", (int)indent);
                String pfx2 = StringTools.replicateString((String)" ", (int)(indent * 2));
                sb.append(pfx1).append("<MapData>\n");
                sb.append(pfx2).append("<Device>" + deviceID + "</" + "Device" + ">\n");
                GTSServiceRequest.this.formatTime(sb, pfx2, frDT, false);
                GTSServiceRequest.this.formatTime(sb, pfx2, toDT, true);
                sb.append(pfx1).append("</MapData>\n");
                return sb;
            }
        });
    }

    public Document getMapDataGroup_Document(final String groupID, final DateTime frDT, final DateTime toDT) throws IOException {
        return this.sendRequest("mapdata", new ServiceRequest.RequestBody(){

            public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                String pfx1 = StringTools.replicateString((String)" ", (int)indent);
                String pfx2 = StringTools.replicateString((String)" ", (int)(indent * 2));
                sb.append(pfx1).append("<MapData>\n");
                sb.append(pfx2).append("<DeviceGroup>" + groupID + "</" + "DeviceGroup" + ">\n");
                GTSServiceRequest.this.formatTime(sb, pfx2, frDT, false);
                GTSServiceRequest.this.formatTime(sb, pfx2, toDT, true);
                sb.append(pfx1).append("</MapData>\n");
                return sb;
            }
        });
    }

    public Document getReportDevice_Document(final String reportName, final String deviceID, final DateTime frDT, final DateTime toDT) throws IOException {
        return this.sendRequest("report", new ServiceRequest.RequestBody(){

            public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                String pfx1 = StringTools.replicateString((String)" ", (int)indent);
                String pfx2 = StringTools.replicateString((String)" ", (int)(indent * 2));
                sb.append(pfx1).append("<Report name=\"" + reportName + "\">\n");
                sb.append(pfx2).append("<Device>" + deviceID + "</" + "Device" + ">\n");
                GTSServiceRequest.this.formatTime(sb, pfx2, frDT, false);
                GTSServiceRequest.this.formatTime(sb, pfx2, toDT, true);
                sb.append(pfx1).append("</Report>\n");
                return sb;
            }
        });
    }

    public Document getReportGroup_Document(final String reportName, final String groupID, final DateTime frDT, final DateTime toDT) throws IOException {
        return this.sendRequest("mapdata", new ServiceRequest.RequestBody(){

            public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                String pfx1 = StringTools.replicateString((String)"", (int)indent);
                String pfx2 = StringTools.replicateString((String)"", (int)(indent * 2));
                sb.append(pfx1).append("<Report name=\"" + reportName + "\">\n");
                sb.append(pfx2).append("<DeviceGroup>" + groupID + "</" + "DeviceGroup" + ">\n");
                GTSServiceRequest.this.formatTime(sb, pfx2, frDT, false);
                GTSServiceRequest.this.formatTime(sb, pfx2, toDT, true);
                sb.append(pfx1).append("</Report>\n");
                return sb;
            }
        });
    }

    public Document getReportJob_Document(final String reportGroupTag) throws IOException {
        return this.sendRequest("report", new ServiceRequest.RequestBody(){

            public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                String pfx1 = StringTools.replicateString((String)" ", (int)indent);
                sb.append(pfx1).append("<ReportJob reportGroupTag=\"" + reportGroupTag + "\"/>\n");
                return sb;
            }
        });
    }

    protected void printDBRecordInfo(DBRecord dbr) {
        Print.sysPrintln((String)"\n", (Object[])new Object[0]);
        Print.sysPrintln((String)("Retrieved Table: [" + StringTools.className((Object)dbr) + "] " + dbr.getRecordKey()), (Object[])new Object[0]);
        Print.sysPrintln((String)("  Description  : " + dbr.getDescription()), (Object[])new Object[0]);
        Print.sysPrintln((String)"\n", (Object[])new Object[0]);
    }

    public Account getAccount(String acctID) throws DBException {
        Account.Key rcdKey = new Account.Key(acctID);
        DBRecord dbr = rcdKey.getVirtualDBRecord(this);
        if (RTConfig.isDebugMode()) {
            this.printDBRecordInfo(dbr);
        }
        return (Account)dbr;
    }

    public String[] getAccountIDs() throws DBException {
        boolean isSoapReq = false;
        String CMD_dbget = "dbget";
        String TAG_Response = this.getTagResponse();
        String TAG_RecordKey = "RecordKey";
        String ATTR_command = this.getAttrCommand();
        String ATTR_result = this.getAttrResult();
        Document xmlDoc = null;
        try {
            xmlDoc = this.sendRequest(CMD_dbget, new ServiceRequest.RequestBody(){

                public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                    String tableName = Account.TABLE_NAME();
                    String PFX1 = XMLTools.PREFIX((boolean)false, (int)indent);
                    sb.append(PFX1);
                    sb.append(XMLTools.startTAG((boolean)false, (String)"RecordKey", (String)(XMLTools.ATTR((String)"table", (String)tableName) + XMLTools.ATTR((String)"partial", (String)"all")), (boolean)false, (boolean)true));
                    sb.append(PFX1);
                    sb.append(XMLTools.endTAG((boolean)false, (String)"RecordKey", (boolean)true));
                    return sb;
                }
            });
        }
        catch (IOException ioe) {
            Print.logException((String)"Error", (Throwable)ioe);
            throw new DBException("Request read error", (Throwable)ioe);
        }
        Element gtsResponse = xmlDoc.getDocumentElement();
        if (!gtsResponse.getTagName().equalsIgnoreCase(TAG_Response)) {
            Print.logError((String)"Request XML does not start with '%s'", (Object[])new Object[]{TAG_Response});
            throw new DBException("Response XML does not begin with '" + TAG_Response + "'");
        }
        String result = XMLTools.getAttribute((Element)gtsResponse, (String)ATTR_result, (String)"error", (boolean)false);
        if (!result.equals("success")) {
            Print.logError((String)"GTSResponse error", (Object[])new Object[0]);
            throw new DBException("GTSResponse error");
        }
        NodeList keyList = XMLTools.getChildElements((Node)gtsResponse, (String)TAG_RecordKey);
        if (keyList.getLength() <= 0) {
            Print.logError((String)"No 'RecordKey' tags", (Object[])new Object[0]);
            throw new DBException("GTSResponse does not contain any 'RecordKey' tags");
        }
        String[] acctIDs = new String[keyList.getLength()];
        for (int k = 0; k < keyList.getLength(); ++k) {
            Element keyElem = (Element)keyList.item(k);
            Account.Key acctKey = (Account.Key)DBFactory.parseXML_DBRecordKey((Element)keyElem);
            acctIDs[k] = (String)acctKey.getFieldValue("accountID");
        }
        return acctIDs;
    }

    public User getUser(String acctID, String userID) throws DBException {
        User.Key rcdKey = new User.Key(acctID, userID);
        DBRecord dbr = rcdKey.getVirtualDBRecord(this);
        this.printDBRecordInfo(dbr);
        return (User)dbr;
    }

    public Device getDevice(String acctID, String devID) throws DBException {
        Device.Key rcdKey = new Device.Key(acctID, devID);
        DBRecord dbr = rcdKey.getVirtualDBRecord(this);
        this.printDBRecordInfo(dbr);
        return (Device)dbr;
    }

    public String getTagResponse() {
        return "GTSResponse";
    }

    public String getTagRequest() {
        return "GTSRequest";
    }
}

