/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.rule;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.RuleFactory;
import org.opengts.db.RuleFactoryAdapter;
import org.opengts.db.SMSOutboundGateway;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class RuleFactoryLite
extends RuleFactoryAdapter {
    private static final String VERSION = "0.1.2";
    private static final String SELECT_ALL = "ALL";
    private static final String SELECT_NONE = "NONE";
    private static final String START_DELIM = "${";
    private static final String END_DELIM = "}";
    private static final String DFT_DELIM = "=";
    private static final String[] KEY_RULENAME = new String[]{"rule", "ruleName"};
    private static final String[] KEY_SUBJECT = new String[]{"subject", "ruleSubject"};
    private static final String[] KEY_MESSAGE = new String[]{"message", "ruleMessage"};
    private static final String DEFAULT_SUBJECT = "Device ${device}: [${statuscode}] ${status}";
    private static final String DEFAULT_BODY = "Rule      : ${ruleName}\nAccount   : [${accountid}] ${account}\nDevice    : [${deviceid}] ${device}\nDate/Time : ${datetime}\nStatus    : [${statuscode}] ${status}\nLocation  : ${geopoint}\nAddress   : ${address}\nSpeed     : ${speed}  ${direction}\nAltitude  : ${altitude}\n\n";
    public static final String PROP_RuleFactoryLite_emailEnabled = "RuleFactoryLite.emailEnabled";
    private static int SEND_NOTIFICATION = -1;
    private static String SEL_CRON = "cron";
    private static String SEL_REMINDER = "reminder";
    private static String SEL_MAINTKM = "maintkm";
    private static String SEL_TRUE = "true";
    private static String SEL_FALSE = "false";
    private static String SEL_ARRIVE = "arrive";
    private static String SEL_DEPART = "depart";
    private static String SEL_SPEED = "speed";
    private static String SEL_SPEEDMPH = "speedmph";
    private static String SEL_CODE = "code";
    private static String SEL_PANIC = "panic";
    private static String[] RULE_FUNCTIONS = new String[]{SEL_TRUE, SEL_FALSE, SEL_ARRIVE, SEL_DEPART, SEL_SPEED, SEL_SPEEDMPH, SEL_CODE, SEL_PANIC};
    private static String[] ARG_SEPARATOR = new String[]{"(", ")"};
    private static char SELECTOR_SEPARATOR_CHAR = (char)44;
    private Map<String, RuleFunction> ftnMap = new HashMap<String, RuleFunction>();
    private static final String[] CRON_noemail = new String[]{"noemail", "debug"};
    private static final String[] CRON_account = new String[]{"account", "acct"};
    private static final String[] CRON_selector = new String[]{"selector"};
    private static final String[] CRON_emailTo = new String[]{"emailTo"};
    private static final String[] CRON_emailSubj = new String[]{"emailSubj"};
    private static final String[] CRON_emailBody = new String[]{"emailBody"};
    private static RuleFactoryLite CronRuleFactInstance = null;

    public static void DebugSetSendNotification(boolean send) {
        SEND_NOTIFICATION = send ? 1 : 0;
    }

    public static boolean SendNotification() {
        if (SEND_NOTIFICATION < 0) {
            SEND_NOTIFICATION = RTConfig.getBoolean((String)PROP_RuleFactoryLite_emailEnabled, (boolean)true) ? 1 : 0;
        }
        return SEND_NOTIFICATION == 1;
    }

    public RuleFactoryLite() {
        this.ftnMap.put(SEL_TRUE, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                return Boolean.TRUE;
            }

            @Override
            public String getUsage() {
                return SEL_TRUE;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.true", "True");
            }

            @Override
            public String getDescription() {
                return "True";
            }

            @Override
            public String _convertToENRE(String arg) {
                return "true";
            }
        });
        this.ftnMap.put(SEL_FALSE, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_FALSE;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.false", "False");
            }

            @Override
            public String getDescription() {
                return "False";
            }

            @Override
            public String _convertToENRE(String arg) {
                return "false";
            }
        });
        this.ftnMap.put(SEL_ARRIVE, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                if (ev.getStatusCode() == 61968) {
                    String gzID = ev.getGeozoneID();
                    if (StringTools.isBlank((String)arg) || StringTools.isBlank((String)gzID)) {
                        return Boolean.TRUE;
                    }
                    if (ListTools.contains((Object[])StringTools.split((String)arg, (char)'|'), (Object)gzID)) {
                        return Boolean.TRUE;
                    }
                }
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_ARRIVE;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.geozoneArrive", "Geozone Arrive");
            }

            @Override
            public String getDescription() {
                return "True if Event code is STATUS_GEOFENCE_ARRIVE";
            }

            @Override
            public String _convertToENRE(String arg) {
                if (StringTools.isBlank((String)arg)) {
                    return "$ARRIVE";
                }
                StringBuffer sb = new StringBuffer();
                String[] gz = StringTools.split((String)arg, (char)'|');
                for (int i = 0; i < gz.length; ++i) {
                    if (StringTools.isBlank((String)gz[i])) continue;
                    if (sb.length() > 0) {
                        sb.append("||");
                    }
                    sb.append("$ARRIVE(\"").append(gz[i]).append("\")");
                }
                if (sb.length() > 0) {
                    return "(" + sb + ")";
                }
                return "$ARRIVE";
            }
        });
        this.ftnMap.put(SEL_DEPART, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                if (ev.getStatusCode() == 62000) {
                    String gzID = ev.getGeozoneID();
                    if (StringTools.isBlank((String)arg) || StringTools.isBlank((String)gzID)) {
                        return Boolean.TRUE;
                    }
                    if (ListTools.contains((Object[])StringTools.split((String)arg, (char)'|'), (Object)gzID)) {
                        return Boolean.TRUE;
                    }
                }
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_DEPART;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.geozoneDepart", "Geozone Depart");
            }

            @Override
            public String getDescription() {
                return "True if Event code is STATUS_GEOFENCE_DEPART";
            }

            @Override
            public String _convertToENRE(String arg) {
                if (StringTools.isBlank((String)arg)) {
                    return "$DEPART";
                }
                StringBuffer sb = new StringBuffer();
                String[] gz = StringTools.split((String)arg, (char)'|');
                for (int i = 0; i < gz.length; ++i) {
                    if (StringTools.isBlank((String)gz[i])) continue;
                    if (sb.length() > 0) {
                        sb.append("||");
                    }
                    sb.append("$DEPART(\"").append(gz[i]).append("\")");
                }
                if (sb.length() > 0) {
                    return "(" + sb + ")";
                }
                return "$DEPART";
            }
        });
        this.ftnMap.put(SEL_SPEED, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                double evSpeedLimKPH;
                double devSpeedLimKPH;
                double evSpeedKPH = ev.getSpeedKPH();
                Device dev = ev.getDevice();
                if (dev != null && (devSpeedLimKPH = dev.getSpeedLimitKPH()) > 0.0 && evSpeedKPH > devSpeedLimKPH) {
                    return Boolean.TRUE;
                }
                if (ev.hasGeozone()) {
                    double gzSpeedLimKPH;
                    Geozone gz = ev.getGeozone();
                    double d = gzSpeedLimKPH = gz != null ? gz.getSpeedLimitKPH() : 0.0;
                    if (gzSpeedLimKPH > 0.0 && evSpeedKPH > gzSpeedLimKPH) {
                        return Boolean.TRUE;
                    }
                }
                if ((evSpeedLimKPH = ev.getSpeedLimitKPH()) > 0.0 && evSpeedKPH > evSpeedLimKPH) {
                    return Boolean.TRUE;
                }
                double dftSpeedLimKPH = StringTools.parseDouble((String)arg, (double)0.0);
                if (dftSpeedLimKPH > 0.0 && evSpeedKPH > dftSpeedLimKPH) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_SPEED;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.excessSpeedKPH", "Excess Speed (km/h)");
            }

            @Override
            public String getDescription() {
                return "True if Event speed km/h is greater than the specified parameter";
            }

            @Override
            public String _convertToENRE(String arg) {
                double dftKPH = StringTools.parseDouble((String)arg, (double)0.0);
                return dftKPH > 0.0 ? "$SPEEDING(" + StringTools.format((double)dftKPH, (String)"0.0") + ")" : "$SPEEDING";
            }
        });
        this.ftnMap.put(SEL_SPEEDMPH, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                double devSpeedKPH;
                double evSpeedKPH = ev.getSpeedKPH();
                Device dev = ev.getDevice();
                if (dev != null && (devSpeedKPH = dev.getSpeedLimitKPH()) > 0.0 && evSpeedKPH > devSpeedKPH) {
                    return Boolean.TRUE;
                }
                double dftSpeedKPH = StringTools.parseDouble((String)arg, (double)0.0) * 1.609344;
                if (dftSpeedKPH > 0.0 && evSpeedKPH > dftSpeedKPH) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_SPEEDMPH;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.excessSpeedMPH", "Excess Speed (mph)");
            }

            @Override
            public String getDescription() {
                return "True if Event speed mph is greater than the specified parameter";
            }

            @Override
            public String _convertToENRE(String arg) {
                double dftKPH = StringTools.parseDouble((String)arg, (double)0.0) * 1.609344;
                return dftKPH > 0.0 ? "$SPEEDING(" + StringTools.format((double)dftKPH, (String)"0.0") + ")" : "$SPEEDING";
            }
        });
        this.ftnMap.put(SEL_CODE, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                int statusCode = StringTools.parseInt((String)arg, (int)0);
                if (ev.getStatusCode() == statusCode) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_CODE;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.statusCode", "Status Code");
            }

            @Override
            public String getDescription() {
                return "True if Event status code matches the specified parameter";
            }

            @Override
            public String _convertToENRE(String arg) {
                int statusCode = StringTools.parseInt((String)arg, (int)0);
                return "(statusCode==0x" + StringTools.toHexString((long)statusCode, (int)16) + ")";
            }
        });
        this.ftnMap.put(SEL_PANIC, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                int statusCode = StringTools.parseInt((String)arg, (int)63553);
                if (ev.getStatusCode() == statusCode) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_PANIC;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.panicCode", "Panic");
            }

            @Override
            public String getDescription() {
                return "True if Event status code matches StatusCodes.STATUS_PANIC_ON";
            }

            @Override
            public String _convertToENRE(String arg) {
                int statusCode = StringTools.parseInt((String)arg, (int)63553);
                return "(statusCode==0x" + StringTools.toHexString((long)statusCode, (int)16) + ")";
            }
        });
        this.ftnMap.put(SEL_CRON, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                Print.logInfo((String)"'Cron' test default returns FALSE", (Object[])new Object[0]);
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_CRON;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.cronTest", "Cron Test");
            }

            @Override
            public String getDescription() {
                return "True if the implemented Cron test returns True";
            }
        });
        this.ftnMap.put(SEL_MAINTKM, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                Account acct = ev != null ? ev.getAccount() : null;
                Device dev = ev != null ? ev.getDevice() : null;
                String devID = ev != null ? ev.getDeviceID() : "?";
                int maintNdx = StringTools.parseInt((String)arg, (int)-1);
                if (dev == null) {
                    return Boolean.FALSE;
                }
                double odomKM = dev.getLastOdometerKM();
                if (odomKM <= 0.0) {
                    return Boolean.FALSE;
                }
                if (maintNdx >= 0) {
                    double maintKM;
                    double intervKM = dev.getMaintIntervalKM(maintNdx);
                    if (intervKM > 0.0 && odomKM >= (maintKM = dev.getMaintOdometerKM(maintNdx)) + intervKM) {
                        return Boolean.TRUE;
                    }
                } else {
                    for (int ndx = 0; ndx < dev.getPeriodicMaintOdometerCount(); ++ndx) {
                        double maintKM;
                        double intervKM = dev.getMaintIntervalKM(ndx);
                        if (!(intervKM > 0.0) || !(odomKM >= (maintKM = dev.getMaintOdometerKM(ndx)) + intervKM)) continue;
                        return Boolean.TRUE;
                    }
                }
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_MAINTKM;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.maintenanceTest", "Maintenance Test");
            }

            @Override
            public String getDescription() {
                return "True if the implemented Maintenance test returns True";
            }
        });
        this.ftnMap.put(SEL_REMINDER, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                TimeZone tmz;
                Account acct = ev != null ? ev.getAccount() : null;
                Device dev = ev != null ? ev.getDevice() : null;
                TimeZone timeZone = tmz = acct != null ? acct.getTimeZone(null) : null;
                if (dev != null && dev.isReminderExpired(tmz)) {
                    boolean reset = StringTools.parseBoolean((String)arg, (boolean)true);
                    if (reset) {
                        try {
                            dev.resetReminder();
                            dev.setReminderTime(DateTime.getCurrentTimeSec());
                            dev.update(new String[]{"reminderTime"});
                        }
                        catch (DBException dbe) {
                            Print.logError((String)("DB Error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                        }
                    }
                    Print.logInfo((String)"'Reminder' test returns TRUE", (Object[])new Object[0]);
                    return Boolean.TRUE;
                }
                Print.logInfo((String)"'Reminder' test default returns FALSE", (Object[])new Object[0]);
                return Boolean.FALSE;
            }

            @Override
            public String getUsage() {
                return SEL_REMINDER;
            }

            @Override
            public String getName(Locale locale) {
                I18N i18n = I18N.getI18N(RuleFactoryLite.class, (Locale)locale);
                return i18n.getString("RuleFactoryLite.function.reminderTest", "Reminder Test");
            }

            @Override
            public String getDescription() {
                return "True if the implemented Reminder test returns True";
            }
        });
    }

    @Override
    public String getName() {
        return "RuleFactoryLite";
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public boolean checkRuntime() {
        return true;
    }

    @Override
    public List<String> getIdentifierNames() {
        return new Vector<String>();
    }

    @Override
    public String getIdentifierDescription(String idName) {
        return null;
    }

    @Override
    public List<String> getFunctionNames() {
        return ListTools.toList((Object[])RULE_FUNCTIONS);
    }

    @Override
    public String getFunctionUsage(String ftnName) {
        RuleFunction ruleFtn = this.getFunction(ftnName);
        return ruleFtn != null ? ruleFtn.getUsage() : "";
    }

    @Override
    public String getFunctionDescription(String ftnName) {
        RuleFunction ruleFtn = this.getFunction(ftnName);
        return ruleFtn != null ? ruleFtn.getDescription() : "";
    }

    private RuleFunction getFunction(String selItem) {
        if (StringTools.isBlank((String)selItem)) {
            return null;
        }
        int p = selItem.indexOf(ARG_SEPARATOR[0]);
        String selFtn = p >= 0 ? selItem.substring(0, p) : selItem;
        RuleFunction ftn = this.ftnMap.get(selFtn);
        if (ftn == null) {
            Print.logWarn((String)("Function for selector not found: " + selItem), (Object[])new Object[0]);
        }
        return ftn;
    }

    private String getArgument(String selector) {
        if (StringTools.isBlank((String)selector)) {
            return null;
        }
        int p = selector.indexOf(ARG_SEPARATOR[0]);
        if (p < 0) {
            return null;
        }
        String a = selector.substring(p + ARG_SEPARATOR[0].length());
        if (a.endsWith(ARG_SEPARATOR[1])) {
            a = a.substring(0, a.length() - ARG_SEPARATOR[1].length());
        }
        return a;
    }

    @Override
    public String[] getRuleIDs(Account account) {
        return null;
    }

    @Override
    public String getRuleSelector(Account account, String ruleID) {
        return null;
    }

    @Override
    public String getRuleNotifyEmail(Account account, String ruleID) {
        return null;
    }

    @Override
    public boolean checkSelectorSyntax(String selector) {
        if (StringTools.isBlank((String)selector)) {
            return true;
        }
        String[] sel = StringTools.split((String)selector, (char)SELECTOR_SEPARATOR_CHAR);
        for (int i = 0; i < sel.length; ++i) {
            if (this._checkSelectorSyntax(sel[i])) continue;
            return false;
        }
        return true;
    }

    private boolean _checkSelectorSyntax(String selItem) {
        if (StringTools.isBlank((String)selItem)) {
            return true;
        }
        int p = selItem.indexOf(ARG_SEPARATOR[0]);
        String selFtn = p < 0 ? selItem : selItem.substring(0, p);
        return this.ftnMap.containsKey(selFtn);
    }

    @Override
    public boolean isSelectorMatch(String selector, EventData event) {
        if (event != null && !StringTools.isBlank((String)selector)) {
            String[] sel = StringTools.split((String)selector, (char)SELECTOR_SEPARATOR_CHAR);
            RuleFunction ftn = this._getSelectorMatch(sel, event);
            return ftn != null;
        }
        return false;
    }

    private RuleFunction _isSelectorMatch(String selector, EventData event) {
        if (event != null && !StringTools.isBlank((String)selector)) {
            String[] sel = StringTools.split((String)selector, (char)SELECTOR_SEPARATOR_CHAR);
            RuleFunction ftn = this._getSelectorMatch(sel, event);
            return ftn;
        }
        return null;
    }

    private RuleFunction _getSelectorMatch(String[] sel, EventData event) {
        if (event != null && !ListTools.isEmpty((Object[])sel)) {
            for (int i = 0; i < sel.length; ++i) {
                RuleFunction ftn = this._getSelectorMatch(sel[i], event);
                if (ftn == null) continue;
                return ftn;
            }
        }
        return null;
    }

    private RuleFunction _getSelectorMatch(String sel, EventData event) {
        if (StringTools.isBlank((String)sel)) {
            return null;
        }
        RuleFunction ftn = this.getFunction(sel);
        if (ftn == null) {
            return null;
        }
        String arg = this.getArgument(sel);
        Object eval = ftn.evaluate(event, arg);
        if (eval == null) {
            return null;
        }
        if (eval instanceof Boolean) {
            return (Boolean)eval != false ? ftn : null;
        }
        if (eval instanceof Number) {
            return ((Number)eval).longValue() != 0L ? ftn : null;
        }
        return ftn;
    }

    public boolean isSelectorMatch(String selector, Account account) {
        return false;
    }

    public String convertToENRE(String selector) {
        String[] sel = StringTools.split((String)selector, (char)SELECTOR_SEPARATOR_CHAR);
        StringBuffer enre = new StringBuffer();
        boolean compoundSel = false;
        for (int i = 0; i < sel.length; ++i) {
            String arg;
            String rf;
            RuleFunction ftn = this.getFunction(sel[i]);
            if (ftn == null || StringTools.isBlank((String)(rf = ftn._convertToENRE(arg = this.getArgument(sel[i]))))) continue;
            if (enre.length() > 0) {
                enre.append("||");
                compoundSel = true;
            }
            enre.append(rf);
        }
        String enreStr = StringTools.blankDefault((String)enre.toString().trim(), (String)"false");
        if (enreStr.startsWith("(") && enreStr.endsWith(")")) {
            return enreStr;
        }
        return "(" + enreStr + ")";
    }

    @Override
    public Object evaluateSelector(String selector, EventData event) {
        String[] sel = StringTools.split((String)selector, (char)SELECTOR_SEPARATOR_CHAR);
        Object eval = null;
        for (int i = 0; i < sel.length; ++i) {
            eval = this._evaluateSelector(sel[i], event);
            if (eval instanceof Boolean && ((Boolean)eval).booleanValue()) {
                return eval;
            }
            if (!(eval instanceof Number) || ((Number)eval).longValue() == 0L) continue;
            return eval;
        }
        return eval;
    }

    private Object _evaluateSelector(String sel, EventData event) {
        RuleFunction ftn = this.getFunction(sel);
        if (ftn == null) {
            return null;
        }
        String arg = this.getArgument(sel);
        return ftn.evaluate(event, arg);
    }

    @Override
    public Object evaluateSelector(String selector, Account account) {
        return Boolean.FALSE;
    }

    @Override
    public int executeSelector(String sel, EventData event) {
        if (event == null) {
            Print.logError((String)"Specified event is null", (Object[])new Object[0]);
            return -1;
        }
        String accountID = event.getAccountID();
        Device device = event.getDevice();
        if (device == null) {
            Print.logError((String)("EventData Device not found: " + accountID + "/" + event.getDeviceID()), (Object[])new Object[0]);
            return -1;
        }
        RuleFunction ftn = this._isSelectorMatch(sel, event);
        if (ftn != null) {
            Print.logInfo((String)("Selector matched: " + sel + " [" + ftn.getName(null) + "]"), (Object[])new Object[0]);
            int actionMask = device.getNotifyAction();
            this._performAction(event, ftn, actionMask, null, null, null);
            return actionMask;
        }
        Print.logDebug((String)("Selector match returned false: " + sel), (Object[])new Object[0]);
        return -1;
    }

    private int _cronExecuteSelector(Device dev, EventData event, String sel, int actionMask, String emailTo, String emailSubj, String emailBody) {
        if (event == null) {
            Print.logError((String)"Specified event is null", (Object[])new Object[0]);
            return -1;
        }
        Device device = null;
        if (dev != null) {
            device = dev;
        } else if (event != null) {
            device = event.getDevice();
        }
        if (device == null) {
            Print.logError((String)"Device is null", (Object[])new Object[0]);
            return -1;
        }
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        RuleFunction ftn = this._isSelectorMatch(sel, event);
        if (ftn != null) {
            Print.logInfo((String)("Selector matched: " + sel + " [" + ftn.getName(null) + "]"), (Object[])new Object[0]);
            this._performAction(event, ftn, actionMask, emailTo, emailSubj, emailBody);
            return actionMask;
        }
        Print.logDebug((String)("Selector match returned false: " + sel), (Object[])new Object[0]);
        return -1;
    }

    @Override
    public int executeRules(EventData event) {
        return -1;
    }

    @Override
    public int executeRule(String ruleID, EventData event) {
        return -1;
    }

    protected boolean _performAction(EventData evdb, RuleFunction ftn, int actionMask, String emailTo, String emailSubj, String emailBody) {
        boolean sent;
        int actCnt = 0;
        if (actionMask < 0 || actionMask == 0) {
            actionMask = 263;
        }
        if ((actionMask & 0xFF) != 0) {
            actionMask |= 0x100;
        }
        if ((actionMask & 0x100) != 0 && (sent = this._sendNotification(evdb, ftn, actionMask, emailTo, emailSubj, emailBody))) {
            ++actCnt;
        }
        return actCnt > 0;
    }

    protected boolean _sendNotification(EventData evdb, RuleFunction ftn, int actionMask, String devEmailTo, String devEmailSubj, String devEmailBody) {
        String ntfyText;
        String ntfySubj;
        String frEmail;
        String email;
        if (evdb == null) {
            Print.logWarn((String)"EventData is null ...", (Object[])new Object[0]);
            return false;
        }
        Account account = evdb.getAccount();
        Device device = evdb.getDevice();
        if (account == null || device == null) {
            Print.logWarn((String)"Account/Device not found ...", (Object[])new Object[0]);
            return false;
        }
        BasicPrivateLabel privLabel = account.getPrivateLabel();
        if (privLabel == null) {
            Print.logWarn((String)("No PrivateLabel found for Account: " + account.getAccountID()), (Object[])new Object[0]);
        }
        HashSet<String> emailTo = new HashSet<String>();
        if ((actionMask & 1) != 0 && !StringTools.isBlank((String)(email = account.getNotifyEmail()))) {
            emailTo.add(email);
        }
        if ((actionMask & 2) != 0 && !StringTools.isBlank((String)(email = StringTools.blankDefault((String)devEmailTo, (String)device.getNotifyEmail(false, true))))) {
            emailTo.add(email);
        }
        StringBuffer toEmailSB = new StringBuffer();
        for (String emailAddr : emailTo) {
            if (toEmailSB.length() > 0) {
                toEmailSB.append(",");
            }
            toEmailSB.append(emailAddr);
        }
        String toSMS = "";
        String toEmail = toEmailSB.toString();
        if (!StringTools.isBlank((String)toEmail)) {
            String[] toArray;
            for (String to : toArray = StringTools.parseStringArray((String)toEmail, (char)',')) {
                if (!SMSOutboundGateway.StartsWithSMS(to)) continue;
                StringBuffer sms = new StringBuffer();
                StringBuffer email2 = new StringBuffer();
                for (String R : toArray) {
                    if (StringTools.isBlank((String)R)) continue;
                    if (SMSOutboundGateway.StartsWithSMS(R)) {
                        if (sms.length() > 0) {
                            sms.append(",");
                        }
                        sms.append(SMSOutboundGateway.RemovePrefixSMS(R));
                        continue;
                    }
                    if (email2.length() > 0) {
                        email2.append(",");
                    }
                    email2.append(R);
                }
                toSMS = sms.toString();
                toEmail = email2.toString();
                break;
            }
        }
        String string = frEmail = privLabel != null ? privLabel.getEventNotificationFrom() : null;
        if (StringTools.isBlank((String)frEmail) || frEmail.endsWith("example.com")) {
            String string2 = frEmail = privLabel != null ? privLabel.getEMailAddress("notify") : null;
            if (StringTools.isBlank((String)frEmail) || frEmail.endsWith("example.com")) {
                frEmail = account.getContactEmail();
            }
        }
        String subjTemplate = null;
        String bodyTemplate = null;
        if (device.getNotifyUseWrapper()) {
            if (privLabel != null) {
                subjTemplate = privLabel.getEventNotificationSubject();
                bodyTemplate = privLabel.getEventNotificationBody();
            }
            if (StringTools.isBlank(subjTemplate)) {
                subjTemplate = DEFAULT_SUBJECT;
            }
            if (StringTools.isBlank(bodyTemplate)) {
                bodyTemplate = DEFAULT_BODY;
            }
        } else {
            subjTemplate = START_DELIM + KEY_SUBJECT[0] + END_DELIM;
            bodyTemplate = START_DELIM + KEY_MESSAGE[0] + END_DELIM;
        }
        if (StringTools.isBlank((String)(ntfySubj = StringTools.blankDefault((String)devEmailSubj, (String)device.getNotifySubject())))) {
            ntfySubj = device.getNotifyDescription();
        }
        if (StringTools.isBlank((String)(ntfyText = StringTools.blankDefault((String)devEmailBody, (String)device.getNotifyText())))) {
            ntfyText = device.getNotifyDescription();
        }
        Locale locale = privLabel != null ? privLabel.getLocale() : null;
        EventDataText edt = new EventDataText(evdb, ftn, ntfySubj, ntfyText, privLabel);
        String subj = edt.toString(subjTemplate);
        String body = edt.toString(bodyTemplate);
        String smsm = null;
        Print.logDebug((String)("From   : " + frEmail), (Object[])new Object[0]);
        Print.logDebug((String)("To     : " + toEmail), (Object[])new Object[0]);
        Print.logDebug((String)("Subject: " + subj), (Object[])new Object[0]);
        Print.logDebug((String)("Body   :\n" + body), (Object[])new Object[0]);
        if (!StringTools.isBlank(smsm)) {
            Print.logDebug((String)("SMS    : " + smsm), (Object[])new Object[0]);
        }
        boolean success = true;
        if (!RuleFactoryLite.SendNotification()) {
            Print.logWarn((String)"EMail notification currently disabled", (Object[])new Object[0]);
            Print.logWarn((String)"(ie. RT Property 'RuleFactoryLite.emailEnabled' is 'false'", (Object[])new Object[0]);
            return success;
        }
        if ((actionMask & 0x100) != 0) {
            if (StringTools.isBlank((String)toEmail) && StringTools.isBlank((String)toSMS)) {
                Print.logWarn((String)"EMail/SMS requested, but no recipients specified", (Object[])new Object[0]);
                success = false;
            } else {
                if (!StringTools.isBlank((String)toEmail)) {
                    if (StringTools.isBlank((String)frEmail)) {
                        Print.logWarn((String)"Cannot determine 'From' email address!!!", (Object[])new Object[0]);
                        success = false;
                    } else {
                        try {
                            Print.logInfo((String)"Sending rule notification email ...", (Object[])new Object[0]);
                            SendMail.SmtpProperties smtpProps = privLabel.getSmtpProperties();
                            SendMail.send((String)frEmail, (String)toEmail, null, null, (String)subj, (String)body, null, (SendMail.SmtpProperties)smtpProps);
                        }
                        catch (Throwable t) {
                            Print.logWarn((String)("SendMail error: " + t), (Object[])new Object[0]);
                            success = false;
                        }
                    }
                }
                if (!StringTools.isBlank((String)toSMS)) {
                    if (account.getSmsEnabled()) {
                        String smsMessage = !StringTools.isBlank(smsm) ? smsm.trim().replace('\n', ' ') : (subj + " " + body).trim().replace('\n', ' ');
                        smsMessage = SMSOutboundGateway.truncateTextMessageToMaximumLength(smsMessage);
                        String smsGatewayName = SMSOutboundGateway.GetDefaultGatewayName();
                        SMSOutboundGateway smsGW = SMSOutboundGateway.GetSMSGateway(smsGatewayName);
                        if (smsGW != null) {
                            String[] smsPhoneList;
                            Print.logInfo((String)("Sending SMS via gateway: " + smsGatewayName), (Object[])new Object[0]);
                            for (String smsPhone : smsPhoneList = StringTools.split((String)toSMS, (char)',')) {
                                if (StringTools.isBlank((String)(smsPhone = SMSOutboundGateway.RemovePrefixSMS(smsPhone)))) continue;
                                Print.logInfo((String)("SMS: " + smsPhone + " --> " + smsMessage), (Object[])new Object[0]);
                                DCServerFactory.ResultCode result = smsGW.sendSMSMessage(account, smsMessage, smsPhone);
                                if (result.isSuccess()) continue;
                                Print.logWarn((String)("SMS error: " + (Object)((Object)result)), (Object[])new Object[0]);
                                success = false;
                            }
                        } else {
                            Print.logWarn((String)("SMS Gateway not found: " + smsGatewayName), (Object[])new Object[0]);
                        }
                    } else {
                        Print.logWarn((String)("SMS notification disabled for account: " + account.getAccountID()), (Object[])new Object[0]);
                    }
                }
            }
        }
        if ((actionMask & 0x400) != 0) {
            // empty if block
        }
        if ((actionMask & 0x200) != 0) {
            // empty if block
        }
        return success;
    }

    public static int cron(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setLogLevel((int)6);
        Print.setLogHeaderLevel((int)6);
        if (RTConfig.getBoolean((String[])CRON_noemail, (boolean)false)) {
            SendMail.SetThreadModel((String)"none");
        } else {
            SendMail.SetThreadModel((String)"current");
        }
        String selector = RTConfig.getString((String[])CRON_selector, null);
        if (StringTools.isBlank((String)selector)) {
            Print.logWarn((String)"Missing Rule Selector specification", (Object[])new Object[0]);
            return 1;
        }
        String accountIDs = RTConfig.getString((String[])CRON_account, (String)"");
        List accountList = null;
        if (accountIDs.equals(SELECT_ALL)) {
            try {
                accountList = Account.getAllAccounts();
            }
            catch (DBException dbe) {
                Print.logException((String)"Error getting list of Accounts", (Throwable)dbe);
                return 99;
            }
        } else {
            accountList = ListTools.toList((Object[])StringTools.split((String)accountIDs, (char)','));
        }
        if (ListTools.isEmpty((Collection)accountList)) {
            Print.logWarn((String)"No Accounts specified, skipping cron selector check ...", (Object[])new Object[0]);
            return 0;
        }
        if (CronRuleFactInstance == null) {
            CronRuleFactInstance = new RuleFactoryLite();
        }
        int actionMask = 263;
        String emailTo = RTConfig.getString((String[])CRON_emailTo, null);
        String emailSubj = RTConfig.getString((String[])CRON_emailSubj, null);
        String emailBody = StringTools.replace((String)RTConfig.getString((String[])CRON_emailBody, null), (String)"\\n", (String)"\n");
        RuleFactoryLite crf = CronRuleFactInstance;
        int rtn = 0;
        for (String aid : accountList) {
            if (StringTools.isBlank((String)aid)) continue;
            Print.logInfo((String)"=============================", (Object[])new Object[0]);
            try {
                Account account = Account.getAccount(aid);
                OrderedSet<String> devIDSet = Device.getDeviceIDsForAccount(aid, null, false);
                for (String devID : devIDSet) {
                    Print.logInfo((String)("Checking cron-rule for " + aid + "/" + devID + " [" + selector + "]"), (Object[])new Object[0]);
                    Device dev = Device.getDevice(account, devID);
                    if (dev != null) {
                        EventData lastEvent = dev.getLastEvent(-1L, false);
                        int am = crf._cronExecuteSelector(dev, lastEvent, selector, actionMask, emailTo, emailSubj, emailBody);
                        continue;
                    }
                    Print.logWarn((String)("Device not found: " + aid + "/" + devID), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Reading Account/Device", (Throwable)dbe);
                rtn = 99;
            }
        }
        return rtn;
    }

    private static void printMatch(RuleFactory ruleFact, EventData event, String sel) {
        Print.logInfo((String)("Match: " + sel + " ==> " + ruleFact.isSelectorMatch(sel, event)), (Object[])new Object[0]);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        RuleFactoryLite ruleFact = new RuleFactoryLite();
        RuleFactoryLite.DebugSetSendNotification(RTConfig.getBoolean((String)"email", (boolean)false));
        if (RTConfig.getBoolean((String)"cron", (boolean)false)) {
            int rtn = RuleFactoryLite.cron(argv);
            Print.logInfo((String)("Cron returned " + rtn), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String)"toenre")) {
            String lite = RTConfig.getString((String)"toenre", (String)"false");
            String enre = ruleFact.convertToENRE(lite);
            Print.sysPrintln((String)"Converting RuleFactoryLite selector to ENRE:", (Object[])new Object[0]);
            Print.sysPrintln((String)("  Lite:  " + lite), (Object[])new Object[0]);
            Print.sysPrintln((String)("  ENRE:  " + enre), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.getBoolean((String)"test", (boolean)false)) {
            int statusCode = 61968;
            EventData.Key evKey = new EventData.Key("demo", "demo", DateTime.getCurrentTimeSec(), statusCode);
            EventData evRcd = (EventData)evKey.getDBRecord();
            evRcd.setAddress("1234 Somewhere Ln, Somewhere CA, 98765");
            evRcd.setGeoPoint(new GeoPoint(35.12345, -142.12345));
            evRcd.setSpeedKPH(105.0);
            evRcd.setHeading(123.0);
            evRcd.setAltitude(457.0);
            evRcd.setOdometerKM(123456.0);
            evRcd.setDistanceKM(3456.0);
            evRcd.setGeozoneID("test");
            RuleFactoryLite.printMatch(ruleFact, evRcd, SEL_ARRIVE + "()");
            RuleFactoryLite.printMatch(ruleFact, evRcd, SEL_ARRIVE + "(test1|test2)");
            RuleFactoryLite.printMatch(ruleFact, evRcd, SEL_ARRIVE + "(test1|test2|test)");
            RuleFactoryLite.printMatch(ruleFact, evRcd, SEL_DEPART + "()");
            RuleFactoryLite.printMatch(ruleFact, evRcd, SEL_DEPART + "(test1|test2)");
            RuleFactoryLite.printMatch(ruleFact, evRcd, SEL_DEPART + "(test1|test2|test)");
            RuleFactoryLite.printMatch(ruleFact, evRcd, SEL_ARRIVE + "(test)," + SEL_DEPART + "(test1)");
            RuleFactoryLite.printMatch(ruleFact, evRcd, SEL_ARRIVE + "(test1)," + SEL_DEPART + "(test)");
            ruleFact.executeSelector(SEL_TRUE, evRcd);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String)"parse")) {
            String sel = RTConfig.getString((String)"parse", (String)"");
            System.exit(0);
        }
        Print.logWarn((String)"Please specify an argument", (Object[])new Object[0]);
    }

    private static class EventDataText
    implements StringTools.KeyValueMap {
        private EventData event = null;
        private RuleFunction function = null;
        private BasicPrivateLabel privLabel = null;
        private String notifySubj = null;
        private String notifyBody = null;

        public EventDataText(EventData event, RuleFunction ftn, String msgSubj, String msgBody, BasicPrivateLabel privLabel) {
            this.event = event;
            this.function = ftn;
            this.privLabel = privLabel;
            this.notifySubj = !StringTools.isBlank((String)msgSubj) ? StringTools.insertKeyValues((String)msgSubj, (String)RuleFactoryLite.START_DELIM, (String)RuleFactoryLite.END_DELIM, (String)RuleFactoryLite.DFT_DELIM, (StringTools.KeyValueMap)this) : null;
            if (!StringTools.isBlank((String)msgBody)) {
                String b = StringTools.insertKeyValues((String)msgBody, (String)RuleFactoryLite.START_DELIM, (String)RuleFactoryLite.END_DELIM, (String)RuleFactoryLite.DFT_DELIM, (StringTools.KeyValueMap)this);
                this.notifyBody = StringTools.replace((String)b, (String)"\\n", (String)"\n");
            } else {
                this.notifyBody = null;
            }
        }

        public String toString(String format) {
            return StringTools.insertKeyValues((String)format, (String)RuleFactoryLite.START_DELIM, (String)RuleFactoryLite.END_DELIM, (String)RuleFactoryLite.DFT_DELIM, (StringTools.KeyValueMap)this);
        }

        public String toString() {
            return this.toString(RuleFactoryLite.DEFAULT_BODY);
        }

        public String getKeyValue(String key, String arg, String dft) {
            if (ListTools.containsIgnoreCase((String[])KEY_RULENAME, (String)key)) {
                if (this.function != null) {
                    Account acct = this.event != null ? this.event.getAccount() : null;
                    Locale locale = acct != null ? acct.getLocale() : null;
                    return this.function.getName(locale);
                }
                return dft;
            }
            if (ListTools.containsIgnoreCase((String[])KEY_SUBJECT, (String)key)) {
                return this.notifySubj != null ? this.notifySubj : dft;
            }
            if (ListTools.containsIgnoreCase((String[])KEY_MESSAGE, (String)key)) {
                return this.notifyBody != null ? this.notifyBody : dft;
            }
            String fldStr = this.event != null ? this.event.getKeyFieldValue(key, arg, this.privLabel) : null;
            return fldStr != null ? fldStr : "(" + key + ")";
        }
    }

    private static abstract class RuleFunction {
        private RuleFunction() {
        }

        public abstract Object evaluate(EventData var1, String var2);

        public abstract String getUsage();

        public abstract String getName(Locale var1);

        public abstract String getDescription();

        public String _convertToENRE(String arg) {
            return "";
        }
    }
}

