/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.geocoder.nacgeo;

import java.io.IOException;
import java.io.InputStream;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.JSON;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class NacGeoService
extends ReverseGeocodeProviderAdapter
implements ReverseGeocodeProvider,
GeocodeProvider {
    protected static final String TAG_GeocodingResult = "GeocodingResult";
    protected static final String TAG_Latitude = "Latitude";
    protected static final String TAG_Longitude = "Longitude";
    protected static final String TAG_FormattedAddress = "FormattedAddress";
    protected static final String TAG_Message = "Message";
    protected static final String TAG_status = "status";
    protected static final String TAG_long_name = "long_name";
    protected static final String TAG_short_name = "short_name";
    protected static final String TAG_types = "types";
    protected static final String TAG_formatted_address = "formatted_address";
    protected static final String TAG_geometry = "geometry";
    protected static final String TAG_bounds = "bounds";
    protected static final String TAG_northeast = "northeast";
    protected static final String TAG_southwest = "southwest";
    protected static final String TAG_location = "location";
    protected static final String TAG_location_type = "location_type";
    protected static final String URL_ReverseGeocode_ = "http://mlbs.net/nacgeoservicesV5.1/Geocoding.aspx?";
    protected static final String URL_Geocode_ = "http://mlbs.net/nacgeoservicesV5.1/Geocoding.aspx?";
    protected static final String PROP_reverseGeocodeURL = "reverseGeocodeURL";
    protected static final String PROP_geocodeURL = "geocodeURL";
    protected static final int TIMEOUT_ReverseGeocode = 2500;
    protected static final int TIMEOUT_Geocode = 5000;
    protected static final String DEFAULT_COUNTRY = "US";
    protected static final String STATUS_UNDEFINED = "?";
    protected static final String STATUS_OK = "OK";
    protected static final String STATUS_LIMIT_EXCEEDED = "620";
    protected static final String STATUS_FORBIDDEN_403 = "403";
    protected static final String STATUS_NOT_FOUND_404 = "404";
    protected static final String STATUS_IP_ADDRESS_ = "IP ";
    protected static final JSON JSON_LIMIT_EXCEEDED = NacGeoService.JSONStatus("620");
    protected static final JSON JSON_FORBIDDEN_403 = NacGeoService.JSONStatus("403");
    protected static final JSON JSON_NOT_FOUND_404 = NacGeoService.JSONStatus("404");
    protected static final boolean FAILOVER_DEBUG = false;
    protected static final String ENCODING_UTF8 = "UTF-8";
    private static final String[] ARG_ACCOUNT = new String[]{"account", "a"};
    private static final String[] ARG_GEOCODE = new String[]{"geocode", "gc"};
    private static final String[] ARG_REVGEOCODE = new String[]{"revgeo", "rg"};

    private static JSON JSONStatus(String status) {
        StringBuffer J = new StringBuffer();
        J.append("{\"").append(TAG_GeocodingResult).append("\":");
        J.append("{\"").append(TAG_Message).append("\":\"").append(status).append("\"}}");
        String j = J.toString();
        try {
            return new JSON(j);
        }
        catch (JSON.JSONParsingException jpe) {
            Print.logError((String)("Invalid JSON: " + J), (Object[])new Object[0]);
            return null;
        }
    }

    public NacGeoService(String name, String key, RTProperties rtProps) {
        super(name, key, rtProps);
    }

    @Override
    public boolean isFastOperation() {
        return super.isFastOperation();
    }

    protected int getGeocodeTimeout() {
        return 5000;
    }

    protected int getReverseGeocodeTimeout() {
        return 2500;
    }

    @Override
    public ReverseGeocode getReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        ReverseGeocode rg = this.getAddressReverseGeocode(gp, localeStr, cache);
        return rg;
    }

    protected String getAddressReverseGeocodeURI() {
        return "http://mlbs.net/nacgeoservicesV5.1/Geocoding.aspx?";
    }

    protected String getAddressReverseGeocodeURL(GeoPoint gp, String localeStr) {
        StringBuffer sb = new StringBuffer();
        String rgURL = this.getProperties().getString(PROP_reverseGeocodeURL, null);
        if (!StringTools.isBlank((String)rgURL)) {
            sb.append(rgURL);
            sb.append("&Query=");
            if (gp != null) {
                String lat = gp.getLatitudeString("5", null);
                String lon = gp.getLongitudeString("5", null);
                sb.append(lat).append(",").append(lon);
            }
            String defURL = sb.toString();
            return defURL;
        }
        sb.append(this.getAddressReverseGeocodeURI());
        String userID = this.getAuthorization();
        if (!StringTools.isBlank((String)userID) && !userID.startsWith("*")) {
            sb.append("&UserID=").append(userID);
        }
        sb.append("&Query=");
        if (gp != null) {
            String lat = gp.getLatitudeString("5", null);
            String lon = gp.getLongitudeString("5", null);
            sb.append(lat).append(",").append(lon);
        }
        sb.append("&Format=JSON");
        String defURL = sb.toString();
        return defURL;
    }

    public ReverseGeocode getAddressReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        if (this.isReverseGeocodeFailoverMode()) {
            ReverseGeocodeProvider frgp = this.getFailoverReverseGeocodeProvider();
            return frgp.getReverseGeocode(gp, localeStr, cache);
        }
        String url = this.getAddressReverseGeocodeURL(gp, localeStr);
        Print.logInfo((String)("NacGeo RG URL: " + url), (Object[])new Object[0]);
        JSON jsonDoc = null;
        JSON._Object jsonObj = null;
        try {
            jsonDoc = NacGeoService.GetJSONDocument(url, this.getReverseGeocodeTimeout());
            JSON._Object _Object2 = jsonObj = jsonDoc != null ? jsonDoc.getObject() : null;
            if (jsonObj == null) {
                return null;
            }
        }
        catch (Throwable th) {
            Print.logException((String)"Error", (Throwable)th);
        }
        String status = STATUS_UNDEFINED;
        String address = null;
        JSON._Object results = jsonObj.getObjectForName(TAG_GeocodingResult, null);
        if (results != null) {
            status = results.getStringForName(TAG_Message, "");
            address = results.getStringForName(TAG_FormattedAddress, null);
        } else {
            Print.logInfo((String)"No address found: null", (Object[])new Object[0]);
        }
        status = StringTools.trim((String)status);
        if (!StringTools.isBlank(address)) {
            Print.logDebug((String)("Address: " + address), (Object[])new Object[0]);
            ReverseGeocode rg = new ReverseGeocode();
            rg.setFullAddress(address);
            return rg;
        }
        if (status.equals(STATUS_OK) || status.equals("")) {
            Print.logDebug((String)("No Address found for location: " + gp), (Object[])new Object[0]);
            ReverseGeocode rg = new ReverseGeocode();
            rg.setFullAddress("");
            return rg;
        }
        boolean failover = false;
        if (status.startsWith(STATUS_IP_ADDRESS_)) {
            Print.logError((String)("NacGeo IP address invalid/expired! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
        } else if (status.equals(STATUS_UNDEFINED)) {
            Print.logError((String)("NacGeo Reverse-Geocode Undefined! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
        } else if (status.equals(STATUS_LIMIT_EXCEEDED)) {
            Print.logError((String)("NacGeo Reverse-Geocode Limit Exceeded! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
        } else if (status.equals(STATUS_FORBIDDEN_403)) {
            Print.logError((String)("NacGeo Reverse-Geocode Not Authorized! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
        } else {
            Print.logError((String)("NacGeo Unrecognized Error! [" + status + "]"), (Object[])new Object[0]);
            failover = false;
        }
        if (failover && this.hasFailoverReverseGeocodeProvider()) {
            this.startReverseGeocodeFailoverMode();
            ReverseGeocodeProvider frgp = this.getFailoverReverseGeocodeProvider();
            Print.logWarn((String)("Failing over to '" + frgp.getName() + "'"), (Object[])new Object[0]);
            return frgp.getReverseGeocode(gp, localeStr, cache);
        }
        return null;
    }

    protected String getGeoPointGeocodeURI() {
        return "http://mlbs.net/nacgeoservicesV5.1/Geocoding.aspx?";
    }

    protected String getGeoPointGeocodeURL(String address, String country) {
        StringBuffer sb = new StringBuffer();
        String gcURL = this.getProperties().getString(PROP_geocodeURL, null);
        if (!StringTools.isBlank((String)gcURL)) {
            sb.append(gcURL);
            sb.append("&Query=").append(URIArg.encodeArg((String)address));
            if (!StringTools.isBlank((String)country)) {
                sb.append("&country=").append(country);
            }
            String defURL = sb.toString();
            return defURL;
        }
        sb.append(this.getGeoPointGeocodeURI());
        String userID = this.getAuthorization();
        if (!StringTools.isBlank((String)userID) && !userID.startsWith("*")) {
            sb.append("&UserID=").append(userID);
        }
        sb.append("&Query=").append(URIArg.encodeArg((String)address));
        if (!StringTools.isBlank((String)country)) {
            sb.append("&country=").append(country);
        }
        sb.append("&Format=JSON");
        String defURL = sb.toString();
        return defURL;
    }

    @Override
    public GeoPoint getGeocode(String address, String country) {
        JSON._Object jsonObj;
        String url = this.getGeoPointGeocodeURL(address, country);
        Print.logDebug((String)("NacGeo GC URL: " + url), (Object[])new Object[0]);
        JSON jsonDoc = NacGeoService.GetJSONDocument(url, this.getReverseGeocodeTimeout());
        JSON._Object _Object2 = jsonObj = jsonDoc != null ? jsonDoc.getObject() : null;
        if (jsonObj == null) {
            return null;
        }
        String status = STATUS_UNDEFINED;
        GeoPoint geoPoint = null;
        JSON._Object results = jsonObj.getObjectForName(TAG_GeocodingResult, null);
        if (results != null) {
            double lon;
            status = StringTools.trim((String)results.getStringForName(TAG_Message, ""));
            double lat = results.getDoubleForName(TAG_Latitude, 0.0);
            if (GeoPoint.isValid((double)lat, (double)(lon = results.getDoubleForName(TAG_Longitude, 0.0)))) {
                geoPoint = new GeoPoint(lat, lon);
            }
        } else {
            Print.logDebug((String)"'GeocodingResult' is null", (Object[])new Object[0]);
        }
        if (geoPoint != null) {
            Print.logDebug((String)("GeoPoint: " + geoPoint), (Object[])new Object[0]);
            return geoPoint;
        }
        if (status.equals(STATUS_OK) || status.equals("")) {
            Print.logDebug((String)("No GeoPoint returned for address: " + address), (Object[])new Object[0]);
            return null;
        }
        if (status.startsWith(STATUS_IP_ADDRESS_)) {
            Print.logError((String)("NacGeo IP address invalid/expired! [" + status + "]"), (Object[])new Object[0]);
        } else if (status.equals(STATUS_UNDEFINED)) {
            Print.logError((String)("NacGeo Geocode Undefined! [" + status + "]"), (Object[])new Object[0]);
        } else if (status.equals(STATUS_LIMIT_EXCEEDED)) {
            Print.logError((String)("NacGeo Geocode Limit Exceeded! [" + status + "]"), (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JSON GetJSONDocument(String url, int timeoutMS) {
        JSON jsonDoc = null;
        HTMLTools.HttpBufferedInputStream input = null;
        try {
            input = HTMLTools.inputStream_GET((String)url, (int)timeoutMS);
            jsonDoc = new JSON((InputStream)input);
        }
        catch (JSON.JSONParsingException jpe) {
            Print.logError((String)("JSON parse error: " + (Object)((Object)jpe)), (Object[])new Object[0]);
        }
        catch (HTMLTools.HttpIOException hioe) {
            int rc = hioe.getResponseCode();
            String rm = hioe.getResponseMessage();
            Print.logError((String)("HttpIOException [" + rc + "-" + rm + "]: " + hioe.getMessage()), (Object[])new Object[0]);
            if (rc == 403) {
                jsonDoc = JSON_FORBIDDEN_403;
            } else if (rc == 404) {
                jsonDoc = JSON_NOT_FOUND_404;
            }
        }
        catch (IOException ioe) {
            Print.logError((String)("IOException: " + ioe.getMessage()), (Object[])new Object[0]);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable th) {}
            }
        }
        return jsonDoc;
    }

    private static String FilterID(String id) {
        if (id == null) {
            return null;
        }
        StringBuffer newID = new StringBuffer();
        boolean st = false;
        for (int i = 0; i < id.length(); ++i) {
            char ch = Character.toLowerCase(id.charAt(i));
            if (Character.isLetterOrDigit(ch)) {
                newID.append(ch);
                st = true;
                continue;
            }
            if (!st) continue;
            newID.append("_");
            st = false;
        }
        while (newID.length() > 0 && newID.charAt(newID.length() - 1) == '_') {
            newID.setLength(newID.length() - 1);
        }
        return newID.toString();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)ENCODING_UTF8);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"demo");
        NacGeoService gn = new NacGeoService("nacgeo", null, null);
        if (RTConfig.hasProperty((String[])ARG_GEOCODE)) {
            String address = RTConfig.getString((String[])ARG_GEOCODE, null);
            if (FileTools.isFile((String)address)) {
                StringBuffer sb = new StringBuffer();
                sb.append("\"accountID\",");
                sb.append("\"geozoneID\",");
                sb.append("\"sortID\",");
                sb.append("\"description\",");
                sb.append("\"radius\",");
                sb.append("\"latitude1\",");
                sb.append("\"longitude1\"");
                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                String[] aList = StringTools.split((String)StringTools.toStringValue((byte[])FileTools.readFile((String)address)), (char)'\n');
                int zoneCnt = 0;
                char[] stipChars = new char[]{'\"'};
                for (String a : aList) {
                    GeoPoint gp;
                    String dftzoneID;
                    String geozoneID = dftzoneID = "zone_" + ++zoneCnt;
                    int sortID = 0;
                    String descr = "";
                    int radiusM = 200;
                    String addr = "";
                    Object[] f = StringTools.split((String)a, (char)'|');
                    if (ListTools.size((Object[])f) == 1) {
                        geozoneID = dftzoneID;
                        descr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                        addr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                    } else if (ListTools.size((Object[])f) >= 3) {
                        geozoneID = StringTools.blankDefault((String)NacGeoService.FilterID((String)f[0]), (String)dftzoneID);
                        descr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                        sortID = 0;
                        radiusM = StringTools.parseInt((String)f[1], (int)200);
                        addr = StringTools.stripChars((String)StringTools.trim((String)f[2]), (char[])stipChars);
                    }
                    if (StringTools.isBlank((String)addr)) continue;
                    int maxLen_geozoneID = 32;
                    if (geozoneID.length() > maxLen_geozoneID && (geozoneID = geozoneID.substring(0, maxLen_geozoneID)).endsWith("_")) {
                        geozoneID = geozoneID.substring(0, geozoneID.length() - 1);
                    }
                    if ((gp = gn.getGeocode(addr, DEFAULT_COUNTRY)) != null && gp.isValid()) {
                        sb.setLength(0);
                        sb.append("\"").append(accountID).append("\",");
                        sb.append("\"").append(geozoneID).append("\",");
                        sb.append("").append(sortID).append(",");
                        sb.append("\"").append(descr).append("\",");
                        sb.append("").append(radiusM).append(",");
                        sb.append("").append(gp.getLatitude()).append(",");
                        sb.append("").append(gp.getLongitude()).append("");
                        Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                        continue;
                    }
                    Print.sysPrintln((String)("// GPS location not found for address: " + addr), (Object[])new Object[0]);
                }
            } else {
                GeoPoint gp = gn.getGeocode(address, DEFAULT_COUNTRY);
                Print.sysPrintln((String)("Location " + gp), (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_REVGEOCODE)) {
            GeoPoint gp = new GeoPoint(RTConfig.getString((String[])ARG_REVGEOCODE, null));
            if (!gp.isValid()) {
                Print.logInfo((String)"Invalid GeoPoint specified", (Object[])new Object[0]);
                System.exit(1);
            }
            Print.logInfo((String)("Reverse-Geocoding GeoPoint: " + gp), (Object[])new Object[0]);
            Print.sysPrintln((String)("RevGeocode = " + gn.getReverseGeocode(gp, null, false)), (Object[])new Object[0]);
            System.exit(0);
        }
        Print.sysPrintln((String)"No options specified", (Object[])new Object[0]);
        System.exit(1);
    }
}

