/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.cellid.ericsson;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.cellid.CellTower;
import org.opengts.cellid.MobileLocation;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.cellid.MobileLocationProviderAdapter;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MobileLocateAPI
extends MobileLocationProviderAdapter
implements MobileLocationProvider {
    private static final String MOBILE_LOCATION_URI = "http://cellid.labs.ericsson.net/xml/lookup";
    private static final String MOBILE_LOCATION_EXENDED_URI = "http://cellid.labs.ericsson.net/xml/elookup";
    private static final String VERSION = "0.1.1";
    private static final String PROP_timeoutMS = "timeoutMS";
    private static final long DefaultServiceTimeout = 5000L;
    private static final String TAG_position = "position";
    private static final String TAG_latitude = "latitude";
    private static final String TAG_longitude = "longitude";
    private static final String TAG_accuracy = "accuracy";
    private static final String TAG_error_message = "error_message";

    private static Document _getMobileLocateXML(String url, long timeoutMS) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            HTMLTools.HttpBufferedInputStream input = HTMLTools.inputStream_GET((String)url, (int)((int)timeoutMS));
            InputStreamReader reader = new InputStreamReader((InputStream)input, "UTF-8");
            InputSource inSrc = new InputSource(reader);
            inSrc.setEncoding("UTF-8");
            return db.parse(inSrc);
        }
        catch (ParserConfigurationException pce) {
            Print.logError((String)("Parse error: " + pce), (Object[])new Object[0]);
            return null;
        }
        catch (SAXException se) {
            Print.logError((String)("Parse error: " + se), (Object[])new Object[0]);
            return null;
        }
        catch (IOException ioe) {
            Print.logError((String)("IO error: " + ioe), (Object[])new Object[0]);
            return null;
        }
    }

    private static String _getCellLocationURL(CellTower servCT, CellTower[] nborCT, String key) {
        if (servCT == null) {
            return null;
        }
        if (StringTools.isBlank((String)key)) {
            Print.logError((String)"Required 'key' is not specified", (Object[])new Object[0]);
            return null;
        }
        if (ListTools.isEmpty((Object[])nborCT)) {
            URIArg url = new URIArg(MOBILE_LOCATION_URI);
            url.addArg("key", key);
            url.addArg("verbose", "true");
            url.addArg("base", 10);
            url.addArg("cellid", servCT.getCellTowerID());
            url.addArg("mnc", servCT.getMobileNetworkCode());
            url.addArg("mcc", servCT.getMobileCountryCode());
            url.addArg("lac", servCT.getLocationAreaCode());
            return url.toString();
        }
        URIArg url = new URIArg(MOBILE_LOCATION_EXENDED_URI);
        url.addArg("key", key);
        url.addArg("verbose", "true");
        url.addArg("base", 10);
        StringBuffer serving = new StringBuffer();
        serving.append(servCT.getRadioAccessTechnologyString());
        serving.append(",");
        serving.append(servCT.getMobileCountryCodeString());
        serving.append(",");
        serving.append(servCT.getMobileNetworkCodeString());
        serving.append(",");
        serving.append(servCT.getLocationAreaCodeString());
        serving.append(",");
        serving.append(servCT.getCellTowerIDString());
        serving.append(",");
        serving.append(servCT.getReceptionLevelString());
        serving.append(",");
        serving.append(servCT.getTimingAdvanceString());
        url.addArg("serving", serving.toString());
        for (int n = 0; n < nborCT.length; ++n) {
            StringBuffer neighbor = new StringBuffer();
            neighbor.append(nborCT[n].getRadioAccessTechnologyString());
            neighbor.append(",");
            neighbor.append(nborCT[n].getMobileCountryCodeString());
            neighbor.append(",");
            neighbor.append(nborCT[n].getMobileNetworkCodeString());
            neighbor.append(",");
            neighbor.append(nborCT[n].getLocationAreaCodeString());
            neighbor.append(",");
            neighbor.append(nborCT[n].getCellTowerIDString());
            neighbor.append(",");
            neighbor.append(nborCT[n].getReceptionLevelString());
            neighbor.append(",");
            neighbor.append(nborCT[n].getTimingAdvanceString());
            url.addArg("neighbor", neighbor.toString());
        }
        return url.toString();
    }

    private static MobileLocation _getMobileLocation(CellTower servCT, CellTower[] nborCT, String key, long timeoutMS) {
        String url = MobileLocateAPI._getCellLocationURL(servCT, nborCT, key);
        if (StringTools.isBlank((String)url)) {
            return null;
        }
        Print.logInfo((String)("Ericsson CelTower URL: " + url), (Object[])new Object[0]);
        Document xmlDoc = MobileLocateAPI._getMobileLocateXML(url, timeoutMS);
        if (xmlDoc == null) {
            return null;
        }
        double latitude = 999.0;
        double longitude = 999.0;
        double accuracyM = 0.0;
        String errMsg = null;
        Element position = xmlDoc.getDocumentElement();
        if (position.getTagName().equalsIgnoreCase(TAG_position)) {
            NodeList nodeList = position.getChildNodes();
            for (int a = 0; a < nodeList.getLength(); ++a) {
                Node node = nodeList.item(a);
                if (!(node instanceof Element)) continue;
                Element elem = (Element)node;
                String name = elem.getNodeName();
                if (name.equalsIgnoreCase(TAG_latitude)) {
                    latitude = StringTools.parseDouble((String)XMLTools.getNodeText((Node)elem, (String)",", (boolean)false), (double)0.0);
                    continue;
                }
                if (name.equalsIgnoreCase(TAG_longitude)) {
                    longitude = StringTools.parseDouble((String)XMLTools.getNodeText((Node)elem, (String)",", (boolean)false), (double)0.0);
                    continue;
                }
                if (name.equalsIgnoreCase(TAG_accuracy)) {
                    accuracyM = StringTools.parseDouble((String)XMLTools.getNodeText((Node)elem, (String)",", (boolean)false), (double)0.0);
                    continue;
                }
                if (!name.equalsIgnoreCase(TAG_error_message)) continue;
                errMsg = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
            }
        }
        if (!StringTools.isBlank(errMsg)) {
            Print.logError((String)("ERROR: " + errMsg), (Object[])new Object[0]);
        }
        if (GeoPoint.isValid((double)latitude, (double)longitude)) {
            return new MobileLocation(latitude, longitude, accuracyM);
        }
        return null;
    }

    public MobileLocateAPI(String name, String key, RTProperties rtProps) {
        super(name, key, rtProps);
    }

    @Override
    public MobileLocation getMobileLocation(CellTower servCT, CellTower[] nborCT) {
        long tmoMS = this.getProperties().getLong(PROP_timeoutMS, 5000L);
        return MobileLocateAPI._getMobileLocation(servCT, nborCT, this.getAuthorization(), tmoMS);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)"UTF-8");
        CellTower ct = new CellTower();
        ct.setCellTowerID(565110);
        ct.setMobileNetworkCode(8);
        ct.setMobileCountryCode(240);
        ct.setLocationAreaCode(318);
        String key = RTConfig.getString((String)"key", (String)"");
        MobileLocateAPI mobLoc = new MobileLocateAPI("ericsson", key, null);
        MobileLocation ml = mobLoc.getMobileLocation(ct, null);
        Print.logInfo((String)("Mobile Location: " + ml), (Object[])new Object[0]);
    }
}

