/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtypes;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.opengts.dbtools.DBFieldType;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class DTTemplate
extends DBFieldType {
    private RTProperties templateProps = null;
    private int fieldCount = -1;
    private static final char FIELD_VALUE_SEPARATOR = '|';

    public DTTemplate() {
        this.templateProps = new RTProperties("");
        this.fieldCount = -1;
    }

    public DTTemplate(String template) {
        super(template);
        this.templateProps = new RTProperties(template != null ? template : "");
        this.fieldCount = -1;
    }

    public DTTemplate(ResultSet rs, String fldName) throws SQLException {
        super(rs, fldName);
        this.templateProps = new RTProperties(rs != null ? rs.getString(fldName) : "");
        this.fieldCount = -1;
    }

    public Object getObject() {
        return this.toString();
    }

    public String toString() {
        return this.templateProps.toString();
    }

    public void clearFields() {
        this.templateProps.clearProperties();
    }

    public Field getField(int ndx) {
        String ftmp = this.templateProps.getString(String.valueOf(ndx), null);
        return ftmp != null && !ftmp.equals("") ? new Field(ftmp) : null;
    }

    public int getFieldCount() {
        if (this.fieldCount < 0) {
            this.fieldCount = 0;
            while (this.getField(this.fieldCount) != null) {
                ++this.fieldCount;
            }
        }
        return this.fieldCount;
    }

    public void setField(int ndx, Field fld) {
        this.templateProps.setString(String.valueOf(ndx), fld.toString());
        this.fieldCount = -1;
    }

    public static class Field {
        private boolean isHiRes = false;
        private int type = -1;
        private int index = 0;
        private int length = 0;
        private boolean isValid = true;

        public Field(int type, boolean hiRes, int ndx, int len) {
            this.isHiRes = hiRes;
            this.type = type;
            this.index = ndx;
            this.length = len;
            this.isValid = this.type >= 0 && this.index >= 0 && this.length > 0;
        }

        public Field(String s) {
            String[] f = StringTools.parseStringArray((String)s, (char)'|');
            if (f.length > 0 && f[0].length() > 0 && Character.isLetter(f[0].charAt(0))) {
                this.isHiRes = f.length > 0 ? f[0].equalsIgnoreCase("H") : false;
                this.type = f.length > 1 ? StringTools.parseInt((String)f[1], (int)-1) : -1;
            } else {
                this.type = f.length > 0 ? StringTools.parseInt((String)f[0], (int)-1) : -1;
                this.isHiRes = f.length > 1 ? f[1].equalsIgnoreCase("H") : false;
            }
            this.index = f.length > 2 ? StringTools.parseInt((String)f[2], (int)0) : 0;
            this.length = f.length > 3 ? StringTools.parseInt((String)f[3], (int)0) : 0;
            this.isValid = f.length == 4 && this.type >= 0 && this.index >= 0 && this.length > 0;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean isHiRes() {
            return this.isHiRes;
        }

        public int getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.isHiRes() ? "H" : "L");
            sb.append('|');
            sb.append(this.getType());
            sb.append('|');
            sb.append(this.getIndex());
            sb.append('|');
            sb.append(this.getLength());
            return sb.toString();
        }

        public boolean equals(Object other) {
            if (other instanceof Field) {
                return this.toString().equals(other.toString());
            }
            return false;
        }
    }
}

