/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtypes;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBFieldType;
import org.opengts.util.StringTools;

public class DTProfileMask
extends DBFieldType {
    private byte[] profileMask = null;

    public DTProfileMask(byte[] profileMask) {
        this.profileMask = profileMask != null ? profileMask : new byte[]{};
    }

    public DTProfileMask(String val) {
        super(val);
        this.profileMask = DBField.parseBlobString((String)val);
    }

    public DTProfileMask(ResultSet rs, String fldName) throws SQLException {
        super(rs, fldName);
        this.profileMask = rs != null ? rs.getBytes(fldName) : new byte[]{};
    }

    public Object getObject() {
        return this.profileMask;
    }

    public String toString() {
        return "0x" + StringTools.toHexString((byte[])this.profileMask);
    }

    public void setLimitTimeInterval(int minutes) {
        int byteLen = (minutes + 7) / 8;
        if (this.profileMask.length != byteLen) {
            byte[] newMask = new byte[byteLen];
            if (newMask.length > 0) {
                int len = this.profileMask.length < byteLen ? this.profileMask.length : byteLen;
                System.arraycopy(this.profileMask, 0, newMask, 0, len);
            }
            this.profileMask = newMask;
        }
    }

    public byte[] getByteMask() {
        return this.profileMask;
    }
}

