/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtypes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.opengts.dbtools.DBFieldType;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class DTOBDFault
extends DBFieldType {
    private static final String PACKAGE_OPENGTS_ = "org.opengts.";
    public static final String PACKAGE_EXTRA_ = "org.opengts.extra.";
    public static final String PACKAGE_EXTRA_DBTOOLS_ = "org.opengts.extra.dbtools.";
    public static final String[] PROP_MIL = new String[]{"mil", "MIL"};
    public static final String[] PROP_TYPE = new String[]{"type", "TYPE"};
    public static final String[] PROP_MID = new String[]{"mid", "MID"};
    public static final String[] PROP_SID = new String[]{"sid", "SID"};
    public static final String[] PROP_PID = new String[]{"pid", "PID"};
    public static final String[] PROP_FMI = new String[]{"fmi", "FMI"};
    public static final String[] PROP_SPN = new String[]{"spn", "SPN"};
    public static final String[] PROP_DTC = new String[]{"dtc", "DTC"};
    public static final String[] PROP_COUNT = new String[]{"count", "COUNT"};
    public static final String[] PROP_ACTIVE = new String[]{"active", "ACTIVE"};
    public static final String NAME_J1708 = "J1708";
    public static final String NAME_J1939 = "J1939";
    public static final String NAME_OBDII = "OBDII";
    public static final String NAME_MID = "MID";
    public static final String NAME_MID_DESC = "MID.desc";
    public static final String NAME_PID = "PID";
    public static final String NAME_PID_DESC = "PID.desc";
    public static final String NAME_SID = "SID";
    public static final String NAME_SID_DESC = "SID.desc";
    public static final String NAME_SPN = "SPN";
    public static final String NAME_FMI = "FMI";
    public static final String NAME_FMI_DESC = "FMI.desc";
    public static final String NAME_DTC = "DTC";
    public static final long TYPE_MASK = 0x7000000000000000L;
    public static final int TYPE_SHIFT = 60;
    public static final long TYPE_J1708 = 0L;
    public static final long TYPE_J1939 = 0x1000000000000000L;
    public static final long TYPE_OBDII = 0x2000000000000000L;
    public static final long ACTIVE_MASK = 0x100000000000000L;
    public static final int ACTIVE_SHIFT = 56;
    public static final long MID_MASK = 0xFFFFFF00000000L;
    public static final int MID_SHIFT = 32;
    public static final long SPID_MASK = 0xFFFF0000L;
    public static final int SPID_SHIFT = 16;
    public static final long SID_MASK = 0x80000000L;
    public static final long FMI_MASK = 65280L;
    public static final int FMI_SHIFT = 8;
    public static final long COUNT_MASK = 255L;
    public static final int COUNT_SHIFT = 0;
    private static boolean j1587DidInit = false;
    private static J1587DescriptionProvider j1587DescProvider = null;
    private static MethodAction j1587GetDescription = null;
    private long faultCode = 0L;

    public static String GetDTCGenericDescrption(String dtc) {
        if (StringTools.isBlank((String)(dtc = StringTools.trim((String)dtc).toUpperCase()))) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        char[] ch = StringTools.getChars((String)dtc);
        switch (ch[0]) {
            case 'P': {
                sb.append("Powertrain");
                break;
            }
            case 'B': {
                sb.append("Body");
                break;
            }
            case 'C': {
                sb.append("Chassis");
                break;
            }
            case 'U': {
                sb.append("Network");
                break;
            }
            default: {
                sb.append("?[" + ch[0] + "]");
            }
        }
        if (ch[0] == 'U') {
            if (!dtc.startsWith("U0")) {
                sb.append(", ");
                sb.append("Manufacturer Specific");
            } else if (dtc.startsWith("U00")) {
                sb.append(", ");
                sb.append("Electrical");
            } else if (dtc.startsWith("U01")) {
                sb.append(", ");
                sb.append("Communication");
            } else if (dtc.startsWith("U02")) {
                sb.append(", ");
                sb.append("Communication");
            } else if (dtc.startsWith("U03")) {
                sb.append(", ");
                sb.append("Software");
            } else if (dtc.startsWith("U04")) {
                sb.append(", ");
                sb.append("Data");
            }
            return sb.toString();
        }
        if (ch.length > 1) {
            sb.append(", ");
            if (ch[1] == '0') {
                sb.append("SAE");
            } else {
                if (ch[1] == '1') {
                    sb.append("Manufacturer Specific");
                    return sb.toString();
                }
                if (ch[1] == '2') {
                    sb.append("SAE");
                } else if (ch[1] == '3') {
                    if (ch.length > 2) {
                        if (ch[2] >= '0' && ch[2] <= '3') {
                            sb.append("Manufacturer Specific");
                            return sb.toString();
                        }
                        sb.append("SAE");
                    } else {
                        sb.append("SAE");
                    }
                } else {
                    sb.append("?[" + ch[1] + "]");
                    return sb.toString();
                }
            }
        }
        if (ch[0] == 'P' && ch.length > 2) {
            sb.append(", ");
            switch (ch[2]) {
                case '0': {
                    sb.append("Fuel/Air Metering and Aux Emissions");
                    break;
                }
                case '1': {
                    sb.append("Fuel/Air Metering");
                    break;
                }
                case '2': {
                    sb.append("Fuel/Air Metering");
                    break;
                }
                case '3': {
                    sb.append("Ignition/Misfire");
                    break;
                }
                case '4': {
                    sb.append("Aux Emissions");
                    break;
                }
                case '5': {
                    sb.append("Speed/Idle/Inputs");
                    break;
                }
                case '6': {
                    sb.append("Computer/Output");
                    break;
                }
                case '7': {
                    sb.append("Transmission");
                    break;
                }
                case '8': {
                    sb.append("Transmission");
                    break;
                }
                case '9': {
                    sb.append("Transmission");
                    break;
                }
                case 'A': {
                    sb.append("Hybrid Propulsion");
                    break;
                }
                case 'B': {
                    sb.append("Reserved");
                    break;
                }
                case 'C': {
                    sb.append("Reserved");
                    break;
                }
                case 'D': {
                    sb.append("Reserved");
                    break;
                }
                case 'E': {
                    sb.append("Reserved");
                    break;
                }
                case 'F': {
                    sb.append("Reserved");
                }
            }
        }
        return sb.toString();
    }

    public static long EncodeActive(boolean active) {
        return active ? 0x100000000000000L : 0L;
    }

    public static boolean DecodeActive(long fault) {
        if (DTOBDFault.IsJ1708(fault)) {
            return (fault & 0x100000000000000L) != 0L;
        }
        return true;
    }

    public static long EncodeSystem(int sys) {
        return (long)sys << 32 & 0xFFFFFF00000000L;
    }

    public static long EncodeSystem(char sys) {
        return (long)sys << 32 & 0xFFFFFF00000000L;
    }

    public static int DecodeSystem(long fault) {
        return (int)((fault & 0xFFFFFF00000000L) >> 32);
    }

    public static long EncodeSPID(int sub) {
        return (long)sub << 16 & 0xFFFF0000L;
    }

    public static int DecodeSPID(long fault) {
        return (int)((fault & 0xFFFF0000L) >> 16);
    }

    public static int DecodePidSid(long fault) {
        return DTOBDFault.DecodeSPID(fault) & 0xFFF;
    }

    public static long EncodeFMI(int fmi) {
        return (long)fmi << 8 & 0xFF00L;
    }

    public static int DecodeFMI(long fault) {
        return (int)((fault & 0xFF00L) >> 8);
    }

    public static long EncodeCount(int count) {
        return (long)count << 0 & 0xFFL;
    }

    public static int DecodeCount(long fault) {
        return (int)((fault & 0xFFL) >> 0);
    }

    public static String GetPropertyString_OBDII(String dtcStr) {
        StringBuffer sb = new StringBuffer();
        sb.append(PROP_TYPE[0]).append("=").append(NAME_OBDII);
        sb.append(" ");
        if (!StringTools.isBlank((String)dtcStr)) {
            sb.append(PROP_MIL[0]).append("=").append("1");
            sb.append(" ");
            sb.append(PROP_DTC[0]).append("=").append(dtcStr);
        } else {
            sb.append(PROP_MIL[0]).append("=").append("0");
        }
        return sb.toString();
    }

    public static String GetPropertyString_OBDII(String[] dtc) {
        String dtcStr = !ListTools.isEmpty((Object[])dtc) ? StringTools.join((String[])dtc, (String)",") : "";
        return DTOBDFault.GetPropertyString_OBDII(dtcStr);
    }

    public static String GetPropertyString_OBDII(List<String> dtc) {
        String dtcStr = !ListTools.isEmpty(dtc) ? StringTools.join(dtc, (String)",") : "";
        return DTOBDFault.GetPropertyString_OBDII(dtcStr);
    }

    public static String GetPropertyString_OBDII(long[] dtcFault) {
        if (ListTools.isEmpty((long[])dtcFault)) {
            return DTOBDFault.GetPropertyString_OBDII("");
        }
        Vector<String> dtc = new Vector<String>();
        for (int i = 0; i < dtcFault.length; ++i) {
            if (dtcFault[i] == 0L) continue;
            dtc.add(DTOBDFault.GetFaultString(dtcFault[i]));
        }
        return DTOBDFault.GetPropertyString_OBDII(dtc);
    }

    public static String GetPropertyString(long fault) {
        StringBuffer sb = new StringBuffer();
        if ((fault & 0x7000000000000000L) == 0L) {
            int mid = DTOBDFault.DecodeSystem(fault);
            int fmi = DTOBDFault.DecodeFMI(fault);
            int count = DTOBDFault.DecodeCount(fault);
            boolean active = DTOBDFault.DecodeActive(fault);
            sb.append(PROP_TYPE[0]).append("=").append(NAME_J1708);
            sb.append(" ");
            sb.append(PROP_MIL[0]).append("=").append(active ? "1" : "0");
            sb.append(" ");
            sb.append(PROP_MID[0]).append("=").append(mid);
            if (DTOBDFault.IsJ1708_SID(fault)) {
                int sid = DTOBDFault.DecodePidSid(fault);
                sb.append(" ");
                sb.append(PROP_SID[0]).append("=").append(sid);
            } else {
                int pid = DTOBDFault.DecodePidSid(fault);
                sb.append(" ");
                sb.append(PROP_PID[0]).append("=").append(pid);
            }
            sb.append(" ").append(PROP_FMI[0]).append("=").append(fmi);
            if (count > 1) {
                sb.append(" ");
                sb.append(PROP_COUNT[0]).append("=" + count);
            }
            if (!active) {
                sb.append(" ");
                sb.append(PROP_ACTIVE[0]).append("=false");
            }
        } else if ((fault & 0x7000000000000000L) == 0x1000000000000000L) {
            int spn = DTOBDFault.DecodeSystem(fault);
            int fmi = DTOBDFault.DecodeFMI(fault);
            int count = DTOBDFault.DecodeCount(fault);
            boolean active = true;
            sb.append(PROP_TYPE[0]).append("=").append(NAME_J1939);
            sb.append(" ");
            sb.append(PROP_MIL[0]).append("=").append(active ? "1" : "0");
            sb.append(" ");
            sb.append(PROP_SPN[0]).append("=").append(spn);
            sb.append(" ");
            sb.append(PROP_FMI[0]).append("=").append(DTOBDFault.DecodeFMI(fault));
            if (count > 1) {
                sb.append(" ");
                sb.append(PROP_COUNT[0]).append("=" + count);
            }
            if (!active) {
                sb.append(" ");
                sb.append(PROP_ACTIVE[0]).append("=false");
            }
        } else if ((fault & 0x7000000000000000L) == 0x2000000000000000L) {
            String dtc = DTOBDFault.GetFaultString(fault);
            sb.append(DTOBDFault.GetPropertyString_OBDII(new String[]{dtc}));
        } else {
            sb.append(PROP_MIL[0]).append("=").append("0");
        }
        return sb.toString();
    }

    public static String GetFaultString(RTProperties fault) {
        if (fault != null) {
            StringBuffer sb = new StringBuffer();
            String type = fault.getString(PROP_TYPE, "");
            if (type.equalsIgnoreCase(NAME_J1708)) {
                boolean active = fault.getBoolean(PROP_ACTIVE, true);
                int mid = fault.getInt(PROP_MID, 0);
                int fmi = fault.getInt(PROP_FMI, 0);
                if (!active) {
                    sb.append("[");
                }
                sb.append(mid);
                sb.append("/");
                if (fault.hasProperty((Object[])PROP_SID)) {
                    int sid = fault.getInt(PROP_SID, 0);
                    sb.append("s").append(sid);
                } else {
                    int pid = fault.getInt(PROP_PID, 0);
                    sb.append(pid);
                }
                sb.append("/");
                sb.append(fmi);
                if (!active) {
                    sb.append("]");
                }
                return sb.toString();
            }
            if (type.equalsIgnoreCase(NAME_J1939)) {
                boolean active = fault.getBoolean(PROP_ACTIVE, true);
                int spn = fault.getInt(PROP_SPN, 0);
                int fmi = fault.getInt(PROP_FMI, 0);
                if (!active) {
                    sb.append("[");
                }
                sb.append(spn);
                sb.append("/");
                sb.append(fmi);
                if (!active) {
                    sb.append("]");
                }
                return sb.toString();
            }
            if (type.equalsIgnoreCase(NAME_OBDII)) {
                boolean active = fault.getBoolean(PROP_ACTIVE, true);
                String dtcStr = fault.getString(PROP_DTC, "");
                if (!StringTools.isBlank((String)dtcStr)) {
                    if (!active) {
                        sb.append("[");
                    }
                    sb.append(dtcStr);
                    if (!active) {
                        sb.append("]");
                    }
                }
                return sb.toString();
            }
        }
        return "";
    }

    public static String GetFaultHeader(RTProperties fault) {
        if (fault != null) {
            String type = fault.getString(PROP_TYPE, "");
            if (type.equalsIgnoreCase(NAME_J1708)) {
                if (fault.hasProperty((Object[])PROP_SID)) {
                    return "MID/SID/FMI";
                }
                return "MID/PID/FMI";
            }
            if (type.equalsIgnoreCase(NAME_J1939)) {
                return "SPN/FMI";
            }
            if (type.equalsIgnoreCase(NAME_OBDII)) {
                return NAME_DTC;
            }
            return "";
        }
        return "";
    }

    public static String GetFaultString(long fault) {
        if (fault > 0L) {
            StringBuffer sb = new StringBuffer();
            if ((fault & 0x7000000000000000L) == 0L) {
                boolean active = DTOBDFault.DecodeActive(fault);
                int mid = DTOBDFault.DecodeSystem(fault);
                int fmi = DTOBDFault.DecodeFMI(fault);
                if (!active) {
                    sb.append("[");
                }
                sb.append(mid);
                sb.append("/");
                if (DTOBDFault.IsJ1708_SID(fault)) {
                    int sid = DTOBDFault.DecodePidSid(fault);
                    sb.append("s").append(sid);
                } else {
                    int pid = DTOBDFault.DecodePidSid(fault);
                    sb.append(pid);
                }
                sb.append("/");
                sb.append(fmi);
                if (!active) {
                    sb.append("]");
                }
                return sb.toString();
            }
            if ((fault & 0x7000000000000000L) == 0x1000000000000000L) {
                boolean active = DTOBDFault.DecodeActive(fault);
                int spn = DTOBDFault.DecodeSystem(fault);
                int fmi = DTOBDFault.DecodeFMI(fault);
                sb.append(spn);
                sb.append("/");
                sb.append(fmi);
                return sb.toString();
            }
            if ((fault & 0x7000000000000000L) == 0x2000000000000000L) {
                boolean active = DTOBDFault.DecodeActive(fault);
                int sysChar = DTOBDFault.DecodeSystem(fault);
                int subSys = DTOBDFault.DecodeSPID(fault);
                if (Character.isLetter((char)sysChar)) {
                    sb.append((char)sysChar);
                } else {
                    sb.append("?");
                }
                sb.append(StringTools.toHexString((long)((long)subSys & 0xFFFFL), (int)16));
                return sb.toString();
            }
        }
        return "";
    }

    public static String GetFaultHeader(long fault) {
        if ((fault & 0x7000000000000000L) == 0L) {
            if (DTOBDFault.IsJ1708_SID(fault)) {
                return "MID/SID/FMI";
            }
            return "MID/PID/FMI";
        }
        if ((fault & 0x7000000000000000L) == 0x1000000000000000L) {
            return "SPN/FMI";
        }
        if ((fault & 0x7000000000000000L) == 0x2000000000000000L) {
            return NAME_DTC;
        }
        return "";
    }

    public static long EncodeFault(String faultProps) {
        if (!StringTools.isBlank((String)faultProps)) {
            return DTOBDFault.EncodeFault(new RTProperties(faultProps));
        }
        return 0L;
    }

    public static long EncodeFault(RTProperties rtp) {
        String type = rtp.getString(PROP_TYPE, "");
        if (type.equalsIgnoreCase(NAME_J1708)) {
            int mid = rtp.getInt(PROP_MID, 0);
            int sid = rtp.getInt(PROP_SID, -1);
            int pid = rtp.getInt(PROP_PID, -1);
            int pidSid = sid >= 0 ? sid : pid;
            int fmi = rtp.getInt(PROP_FMI, 0);
            int count = rtp.getInt(PROP_COUNT, 0);
            boolean active = rtp.getBoolean(PROP_ACTIVE, true);
            return DTOBDFault.EncodeFault_J1708(mid, sid >= 0, pidSid, fmi, count, active);
        }
        if (type.equalsIgnoreCase(NAME_J1939)) {
            int spn = rtp.getInt(PROP_SPN, 0);
            int fmi = rtp.getInt(PROP_FMI, 0);
            int count = rtp.getInt(PROP_COUNT, 0);
            boolean active = rtp.getBoolean(PROP_ACTIVE, true);
            return DTOBDFault.EncodeFault_J1939(spn, fmi, count);
        }
        if (type.equalsIgnoreCase(NAME_OBDII)) {
            String dtc = rtp.getString(PROP_DTC, "");
            return DTOBDFault.EncodeFault_OBDII(dtc);
        }
        return 0L;
    }

    public static long EncodeFault_J1708(int mid, boolean isSID, int pidSid, int fmi, int count, boolean active) {
        int spid = isSID ? pidSid | 0x8000 : pidSid;
        long faultCode = 0L;
        faultCode |= DTOBDFault.EncodeActive(active);
        faultCode |= DTOBDFault.EncodeSystem(mid);
        faultCode |= DTOBDFault.EncodeSPID(spid);
        faultCode |= DTOBDFault.EncodeFMI(fmi);
        return faultCode |= DTOBDFault.EncodeCount(count);
    }

    public static boolean IsJ1708(long fault) {
        return (fault & 0x7000000000000000L) == 0L;
    }

    public static boolean IsJ1708(RTProperties rtpFault) {
        return rtpFault != null && rtpFault.getString(PROP_TYPE, "").equalsIgnoreCase(NAME_J1708);
    }

    public static boolean IsJ1708_SID(long fault) {
        return DTOBDFault.IsJ1708(fault) && (fault & 0x80000000L) != 0L;
    }

    public static boolean IsJ1708_SID(RTProperties rtpFault) {
        return DTOBDFault.IsJ1708(rtpFault) && rtpFault.hasProperty((Object[])PROP_SID);
    }

    public static boolean IsJ1708_PID(long fault) {
        return DTOBDFault.IsJ1708(fault) && (fault & 0x80000000L) == 0L;
    }

    public static boolean IsJ1708_PID(RTProperties rtpFault) {
        return DTOBDFault.IsJ1708(rtpFault) && rtpFault.hasProperty((Object[])PROP_PID);
    }

    public static long EncodeFault_J1939(int spn, int fmi, int count) {
        long faultCode = 0x1000000000000000L;
        faultCode |= DTOBDFault.EncodeActive(true);
        faultCode |= DTOBDFault.EncodeSystem(spn);
        faultCode |= DTOBDFault.EncodeFMI(fmi);
        return faultCode |= DTOBDFault.EncodeCount(count);
    }

    public static boolean IsJ1939(long fault) {
        return (fault & 0x7000000000000000L) == 0x1000000000000000L;
    }

    public static boolean IsJ1939(RTProperties rtpFault) {
        return rtpFault != null && rtpFault.getString(PROP_TYPE, "").equalsIgnoreCase(NAME_J1939);
    }

    public static long EncodeFault_OBDII(String dtcStr) {
        long faultCode = 0x2000000000000000L;
        if ((dtcStr = StringTools.trim((String)dtcStr)).indexOf(",") >= 0) {
            dtcStr = dtcStr.substring(0, dtcStr.indexOf(",")).trim();
        }
        if (dtcStr.equals("")) {
            return faultCode;
        }
        if (dtcStr.length() == 4) {
            dtcStr = "U" + dtcStr;
        } else if (dtcStr.length() != 5) {
            return faultCode;
        }
        faultCode |= DTOBDFault.EncodeActive(true);
        faultCode |= DTOBDFault.EncodeSystem(dtcStr.charAt(0));
        int spid = StringTools.parseHex((String)dtcStr.substring(1, 5), (int)0);
        return faultCode |= DTOBDFault.EncodeSPID(spid);
    }

    public static boolean IsOBDII(long fault) {
        return (fault & 0x7000000000000000L) == 0x2000000000000000L;
    }

    public static boolean IsOBDII(RTProperties rtpFault) {
        return rtpFault != null && rtpFault.getString(PROP_TYPE, "").equalsIgnoreCase(NAME_OBDII);
    }

    public static boolean InitJ1587DescriptionProvider() {
        if (!j1587DidInit) {
            j1587DidInit = true;
            try {
                j1587GetDescription = new MethodAction((Object)"org.opengts.extra.dbtools.J1587", "GetJ1587Description", new Class[]{Properties.class});
                j1587DescProvider = new J1587DescriptionProvider(){

                    @Override
                    public Properties getJ1587Descriptions(long fault) {
                        if (DTOBDFault.IsJ1708(fault)) {
                            int mid = DTOBDFault.DecodeSystem(fault);
                            boolean isSid = DTOBDFault.IsJ1708_SID(fault);
                            int pidSid = DTOBDFault.DecodePidSid(fault);
                            int fmi = DTOBDFault.DecodeFMI(fault);
                            Properties p = new Properties();
                            p.setProperty(DTOBDFault.NAME_MID, String.valueOf(mid));
                            p.setProperty(isSid ? DTOBDFault.NAME_SID : DTOBDFault.NAME_PID, String.valueOf(pidSid));
                            p.setProperty(DTOBDFault.NAME_FMI, String.valueOf(fmi));
                            try {
                                return (Properties)j1587GetDescription.invoke(new Object[]{p});
                            }
                            catch (Throwable th) {
                                return null;
                            }
                        }
                        return null;
                    }
                };
                Print.logDebug((String)"J1587 Description Provider installed ...", (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return j1587DescProvider != null;
    }

    public static boolean HasDescriptionProvider(long fault) {
        if (DTOBDFault.IsJ1708(fault)) {
            return j1587DescProvider != null;
        }
        return false;
    }

    public static String GetFaultDescription(long fault, Locale locale) {
        if (fault != 0L) {
            String fmt = "000";
            StringBuffer sb = new StringBuffer();
            if ((fault & 0x7000000000000000L) == 0L) {
                int mid = DTOBDFault.DecodeSystem(fault);
                boolean isSid = DTOBDFault.IsJ1708_SID(fault);
                int pidSid = DTOBDFault.DecodePidSid(fault);
                int fmi = DTOBDFault.DecodeFMI(fault);
                Properties p = j1587DescProvider != null ? j1587DescProvider.getJ1587Descriptions(fault) : new Properties();
                sb.append("MID(" + StringTools.format((int)mid, (String)fmt) + ") " + p.getProperty(NAME_MID_DESC, "") + "\n");
                if (isSid) {
                    sb.append("SID(" + StringTools.format((int)pidSid, (String)fmt) + ") " + p.getProperty(NAME_SID_DESC, "") + "\n");
                } else {
                    sb.append("PID(" + StringTools.format((int)pidSid, (String)fmt) + ") " + p.getProperty(NAME_PID_DESC, "") + "\n");
                }
                sb.append("FMI(" + StringTools.format((int)fmi, (String)fmt) + ") " + p.getProperty(NAME_FMI_DESC, ""));
                return sb.toString();
            }
            if ((fault & 0x7000000000000000L) == 0x1000000000000000L) {
                int spn = DTOBDFault.DecodeSystem(fault);
                int fmi = DTOBDFault.DecodeFMI(fault);
                Properties p = new Properties();
                sb.append("SPN(" + StringTools.format((int)spn, (String)fmt) + ") " + p.getProperty(NAME_SPN, "") + "\n");
                sb.append("FMI(" + StringTools.format((int)fmi, (String)fmt) + ") " + p.getProperty(NAME_FMI, ""));
                return sb.toString();
            }
            if ((fault & 0x7000000000000000L) == 0x2000000000000000L) {
                String dtc = DTOBDFault.GetFaultString(fault);
                Properties p = new Properties();
                p.put(NAME_DTC, DTOBDFault.GetDTCGenericDescrption(dtc));
                sb.append("DTC(" + dtc + ") " + p.getProperty(NAME_DTC, ""));
                return sb.toString();
            }
        }
        return "";
    }

    public DTOBDFault(int mid, boolean isSid, int pidSid, int fmi, int count, boolean active) {
        this.faultCode = DTOBDFault.EncodeFault_J1708(mid, isSid, pidSid, fmi, count, active);
    }

    public DTOBDFault(int spn, int fmi, int count) {
        this.faultCode = DTOBDFault.EncodeFault_J1939(spn, fmi, count);
    }

    public DTOBDFault(String dtc) {
        this.faultCode = DTOBDFault.EncodeFault_OBDII(dtc);
    }

    public DTOBDFault(long faultCode) {
        this.faultCode = faultCode;
    }

    public DTOBDFault(ResultSet rs, String fldName) throws SQLException {
        super(rs, fldName);
        this.faultCode = rs != null ? rs.getLong(fldName) : 0L;
    }

    public long getFaultCode() {
        return this.faultCode;
    }

    public String getDescription() {
        return DTOBDFault.GetFaultDescription(this.getFaultCode(), null);
    }

    public boolean isJ1708() {
        return DTOBDFault.IsJ1708(this.getFaultCode());
    }

    public boolean isJ1939() {
        return DTOBDFault.IsJ1939(this.getFaultCode());
    }

    public boolean isOBDII() {
        return DTOBDFault.IsOBDII(this.getFaultCode());
    }

    public Object getObject() {
        return new Long(this.getFaultCode());
    }

    public String toString() {
        return "0x" + StringTools.toHexString((long)this.getFaultCode());
    }

    public boolean equals(Object other) {
        if (other instanceof DTOBDFault) {
            DTOBDFault jf = (DTOBDFault)((Object)other);
            return this.getFaultCode() == jf.getFaultCode();
        }
        return false;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        DTOBDFault.InitJ1587DescriptionProvider();
        RTProperties cmdLineProps = RTConfig.getCommandLineProperties();
        long fault = DTOBDFault.EncodeFault(cmdLineProps);
        Print.sysPrintln((String)("Fault : " + fault + " [0x" + StringTools.toHexString((long)fault) + "]"), (Object[])new Object[0]);
        Print.sysPrintln((String)("String: " + DTOBDFault.GetPropertyString(fault)), (Object[])new Object[0]);
        Print.sysPrintln((String)("Desc  : " + DTOBDFault.GetFaultDescription(fault, null)), (Object[])new Object[0]);
    }

    public static interface J1587DescriptionProvider {
        public Properties getJ1587Descriptions(long var1);
    }
}

