/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.UserRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.I18N;
import org.opengts.util.StringTools;

public class UserDevice
extends UserRecord<UserDevice> {
    public static final String _TABLE_NAME = "UserDevice";
    public static final String FLD_deviceID = "deviceID";
    private static DBField[] FieldInfo = new DBField[]{UserDevice.newField_accountID(true), UserDevice.newField_userID(true), new DBField("deviceID", String.class, DBField.TYPE_DEV_ID(), "Device ID", "key=true"), UserDevice.newField_creationTime()};
    private static DBFactory<UserDevice> factory = null;

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<UserDevice> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)UserDevice.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, UserDevice.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(User.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public UserDevice() {
    }

    public UserDevice(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(UserDevice.class, (Locale)loc);
        return i18n.getString("UserDevice.description", "This table defines the list of authorized devices for a User.");
    }

    public String getDeviceID() {
        String v = (String)this.getFieldValue(FLD_deviceID);
        return StringTools.trim((String)v);
    }

    private void setDeviceID(String v) {
        this.setFieldValue(FLD_deviceID, StringTools.trim((String)v));
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getUserID() + "/" + this.getDeviceID();
    }

    public void setCreationDefaultValues() {
    }

    public static boolean exists(String acctID, String userID, String deviceID) throws DBException {
        if (acctID != null && userID != null && deviceID != null) {
            Key usrDevKey = new Key(acctID, userID, deviceID);
            return usrDevKey.exists();
        }
        return false;
    }

    public static boolean rebuildUserDeviceTable(User user) {
        if (user == null) {
            return false;
        }
        String accountID = user.getAccountID();
        String userID = user.getUserID();
        return true;
    }

    public static UserDevice getUserDevice(User user, String deviceID, boolean createOK) throws DBException {
        if (user == null) {
            throw new DBException("User not specified.");
        }
        String accountID = user.getAccountID();
        String userID = user.getUserID();
        if (StringTools.isBlank((String)deviceID)) {
            throw new DBException("Device ID not specified.");
        }
        if (!Device.exists(accountID, deviceID)) {
            throw new DBException("Device does not exist: " + accountID + "/" + deviceID);
        }
        Key usrDevKey = new Key(accountID, userID, deviceID);
        if (usrDevKey.exists()) {
            UserDevice listItem = (UserDevice)usrDevKey.getDBRecord(true);
            listItem.setUser(user);
            return listItem;
        }
        if (createOK) {
            UserDevice listItem = (UserDevice)usrDevKey.getDBRecord();
            listItem.setCreationDefaultValues();
            listItem.setUser(user);
            return listItem;
        }
        return null;
    }

    protected static DBSelect _getDeviceSelect(String acctId, String userId) {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)userId)) {
            return null;
        }
        DBSelect dsel = new DBSelect(UserDevice.getFactory());
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("userID", (Object)userId))));
        dsel.setOrderByFields(new String[]{FLD_deviceID});
        return dsel;
    }

    public static List<String> getDeviceIDsForUser(String acctId, String userId) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)userId)) {
            return null;
        }
        DBSelect dsel = UserDevice._getDeviceSelect(acctId, userId);
        if (dsel == null) {
            return null;
        }
        Vector<String> devList = new Vector<String>();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String devId = rs.getString(FLD_deviceID);
                devList.add(devId);
            }
        }
        catch (SQLException sqe) {
            try {
                throw new DBException("Get User Devices", (Throwable)sqe);
            }
            catch (Throwable throwable) {
                DBConnection.release((DBConnection)dbc, stmt, rs);
                throw throwable;
            }
        }
        DBConnection.release((DBConnection)dbc, (Statement)stmt, (ResultSet)rs);
        return devList;
    }

    public static class Key
    extends UserRecord.UserKey<UserDevice> {
        public Key() {
        }

        public Key(String accountId, String userId, String deviceId) {
            super.setKeyValue("accountID", (Object)(accountId != null ? accountId.toLowerCase() : ""));
            super.setKeyValue("userID", (Object)(userId != null ? userId.toLowerCase() : ""));
            super.setKeyValue(UserDevice.FLD_deviceID, (Object)(deviceId != null ? deviceId.toLowerCase() : ""));
        }

        public DBFactory<UserDevice> getFactory() {
            return UserDevice.getFactory();
        }
    }
}

