/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import org.opengts.db.AclEntry;
import org.opengts.db.DBConfig;
import org.opengts.db.UserRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class UserAcl
extends UserRecord<UserAcl> {
    public static final String _TABLE_NAME = "UserAcl";
    public static final String FLD_aclID = "aclID";
    public static final String FLD_accessLevel = "accessLevel";
    private static DBField[] FieldInfo = new DBField[]{UserAcl.newField_accountID(true), UserAcl.newField_userID(true), new DBField("aclID", String.class, DBField.TYPE_STRING((int)64), "ACL ID", "key=true"), new DBField("accessLevel", Integer.TYPE, "UINT16", "Access Level", "edit=2 enum=AclEntry$AccessLevel"), UserAcl.newField_description(), UserAcl.newField_lastUpdateTime(), UserAcl.newField_lastUpdateUser((boolean)true), UserAcl.newField_creationTime()};
    private static DBFactory<UserAcl> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_USER = new String[]{"user", "usr"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_ACL = new String[]{"acl"};
    private static final String[] ARG_SET = new String[]{"set"};
    private static final String[] ARG_CREATE = new String[]{"create", "cr"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_DELETE = new String[]{"delete", "purge"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<UserAcl> getFactory() {
        if (factory == null) {
            EnumTools.registerEnumClass(AclEntry.AccessLevel.class);
            factory = DBFactory.createDBFactory((String)UserAcl.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, UserAcl.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(User.TABLE_NAME());
        }
        return factory;
    }

    public UserAcl() {
    }

    public UserAcl(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(UserAcl.class, (Locale)loc);
        return i18n.getString("UserAcl.description", "This table defines User specific Access Control permissions.");
    }

    public String getAclID() {
        String v = (String)this.getFieldValue(FLD_aclID);
        return StringTools.trim((String)v);
    }

    private void setAclID(String v) {
        this.setFieldValue(FLD_aclID, StringTools.trim((String)v));
    }

    public int getAccessLevel() {
        Integer v = (Integer)this.getFieldValue(FLD_accessLevel);
        return v != null ? v : 0;
    }

    public void setAccessLevel(int v) {
        this.setFieldValue(FLD_accessLevel, ((AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (int)v)).getIntValue());
    }

    public void setAccessLevel(String v) {
        this.setFieldValue(FLD_accessLevel, ((AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (String)v)).getIntValue());
    }

    public boolean hasReadAccess() {
        return AclEntry.okRead(this.getAccessLevel());
    }

    public boolean hasWriteAccess() {
        return AclEntry.okWrite(this.getAccessLevel());
    }

    public boolean hasAllAccess() {
        return AclEntry.okAll(this.getAccessLevel());
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getUserID() + "/" + this.getAclID();
    }

    public void setCreationDefaultValues() {
    }

    public static boolean exists(String acctID, String userID, String aclID) throws DBException {
        if (acctID != null && userID != null && aclID != null) {
            Key aclKey = new Key(acctID, userID, aclID);
            return aclKey.exists();
        }
        return false;
    }

    public static AclEntry.AccessLevel getAccessLevel(UserAcl ua) {
        return ua != null ? (AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (int)ua.getAccessLevel()) : (AclEntry.AccessLevel)EnumTools.getDefault(AclEntry.AccessLevel.class);
    }

    public static AclEntry.AccessLevel getAccessLevel(User user, String aclId, AclEntry.AccessLevel dftAccess) {
        if (User.isAdminUser(user)) {
            return AclEntry.AccessLevel.ALL;
        }
        if (user == null) {
            return AclEntry.AccessLevel.NONE;
        }
        int maxAccessLevel = AclEntry.AccessLevel.ALL.getIntValue();
        if (dftAccess != null && dftAccess.getIntValue() > maxAccessLevel) {
            dftAccess = AclEntry.getAccessLevel(maxAccessLevel);
        }
        if (StringTools.isBlank((String)aclId)) {
            return dftAccess;
        }
        try {
            UserAcl userAcl = UserAcl.getUserAcl(user, aclId);
            if (userAcl != null) {
                AclEntry.AccessLevel accLvl = UserAcl.getAccessLevel(userAcl);
                if (accLvl.getIntValue() > maxAccessLevel) {
                    return AclEntry.getAccessLevel(maxAccessLevel);
                }
                return accLvl;
            }
            return dftAccess;
        }
        catch (DBException dbe) {
            return AclEntry.AccessLevel.NONE;
        }
    }

    public static void setAccessLevel(User user, String aclId, AclEntry.AccessLevel level) throws DBException {
        if (user == null) {
            throw new DBException("User not specified.");
        }
        String acctId = user.getAccountID();
        String userId = user.getUserID();
        if (StringTools.isBlank((String)aclId)) {
            throw new DBException("Acl-ID not specified.");
        }
        UserAcl userAcl = null;
        Key aclKey = new Key(acctId, userId, aclId);
        if (aclKey.exists()) {
            userAcl = UserAcl.getUserAcl(user, aclId);
        } else {
            userAcl = (UserAcl)aclKey.getDBRecord();
            userAcl.setUser(user);
        }
        int levelInt = level != null ? level.getIntValue() : AclEntry.AccessLevel.NONE.getIntValue();
        userAcl.setAccessLevel(levelInt);
        userAcl.save();
    }

    public static boolean deleteAccessLevel(User user, String aclId) throws DBException {
        if (user == null) {
            return false;
        }
        String acctId = user.getAccountID();
        String userId = user.getUserID();
        if (StringTools.isBlank((String)aclId)) {
            return false;
        }
        boolean aclExists = UserAcl.exists(acctId, userId, aclId);
        if (!aclExists) {
            return false;
        }
        Key aclKey = new Key(acctId, userId, aclId);
        aclKey.delete(true);
        return true;
    }

    public static UserAcl getUserAcl(User user, String aclId) throws DBException {
        if (user != null && aclId != null) {
            Key aclKey = new Key(user.getAccountID(), user.getUserID(), aclId);
            if (aclKey.exists()) {
                UserAcl userAcl = (UserAcl)aclKey.getDBRecord(true);
                userAcl.setUser(user);
                return userAcl;
            }
            if (user.isAdminUser()) {
                return null;
            }
            return null;
        }
        throw new DBException("User or AclID is null");
    }

    public static UserAcl getUserAcl(User user, String aclId, boolean create) throws DBException {
        if (user == null) {
            throw new DBNotFoundException("User not specified.");
        }
        String acctId = user.getAccountID();
        String userId = user.getUserID();
        if (StringTools.isBlank((String)aclId)) {
            throw new DBNotFoundException("Acl-ID not specified.");
        }
        UserAcl userAcl = null;
        Key aclKey = new Key(acctId, userId, aclId);
        if (!aclKey.exists()) {
            if (create) {
                userAcl = (UserAcl)aclKey.getDBRecord();
                userAcl.setUser(user);
                userAcl.setCreationDefaultValues();
                return userAcl;
            }
            throw new DBNotFoundException("Acl-ID does not exists '" + (Object)((Object)aclKey) + "'");
        }
        if (create) {
            throw new DBAlreadyExistsException("Acl-ID already exists '" + (Object)((Object)aclKey) + "'");
        }
        userAcl = UserAcl.getUserAcl(user, aclId);
        if (userAcl == null) {
            throw new DBException("Unable to read existing User-ID '" + (Object)((Object)aclKey) + "'");
        }
        return userAcl;
    }

    public static UserAcl createNewUserAcl(User user, String aclID) throws DBException {
        UserAcl userAcl = UserAcl.getUserAcl(user, aclID, true);
        if (userAcl != null) {
            userAcl.save();
        }
        return userAcl;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + UserAcl.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Acount ID which owns User", (Object[])new Object[0]);
        Print.logInfo((String)"  -user=<id>      User ID which owns UserAcl", (Object[])new Object[0]);
        Print.logInfo((String)"  -list           List Acls for User", (Object[])new Object[0]);
        Print.logInfo((String)"  -acl=<id>       User ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -set=<val>      UserAcl value (create if necessary)", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new UserAcl", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           Edit an existing (or newly created) UserAcl", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified UserAcl", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String userID = RTConfig.getString((String[])ARG_USER, (String)"");
        String aclID = RTConfig.getString((String[])ARG_ACL, (String)"");
        if (acctID == null || acctID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            UserAcl.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(acctID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                UserAcl.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (userID == null || userID.equals("")) {
            Print.logError((String)"User-ID not specified.", (Object[])new Object[0]);
            UserAcl.usage();
        }
        User user = null;
        try {
            user = User.getUser(acct, userID);
            if (user == null) {
                Print.logError((String)("User-ID does not exist: " + acctID + "/" + userID), (Object[])new Object[0]);
                UserAcl.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading User: " + acctID + "/" + userID), (Throwable)dbe);
            System.exit(99);
        }
        boolean aclExists = false;
        if (aclID != null && !aclID.equals("")) {
            try {
                aclExists = UserAcl.exists(acctID, userID, aclID);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error determining if UserAcl exists: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_LIST, (boolean)false)) {
            ++opts;
            try {
                String[] aclList = user.getAclsForUser();
                for (int i = 0; i < aclList.length; ++i) {
                    AclEntry.AccessLevel level = UserAcl.getAccessLevel(user, aclList[i], AclEntry.AccessLevel.NONE);
                    Print.sysPrintln((String)("  " + aclList[i] + " ==> " + (Object)((Object)level)), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Error getting Acl list: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !acctID.equals("") && !userID.equals("")) {
            ++opts;
            if (!aclExists) {
                Print.logWarn((String)("UserAcl does not exist: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key aclKey = new Key(acctID, userID, aclID);
                aclKey.delete(true);
                Print.logInfo((String)("UserAcl deleted: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting UserAcl: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (aclExists) {
                Print.logWarn((String)("UserAcl already exists: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
            } else {
                try {
                    UserAcl.createNewUserAcl(user, aclID);
                    Print.logInfo((String)("Created UserAcl: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
                    aclExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating UserAcl: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.hasProperty((String[])ARG_SET)) {
            ++opts;
            AclEntry.AccessLevel aclLevel = (AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (int)RTConfig.getInt((String[])ARG_SET, (int)-1));
            try {
                UserAcl.setAccessLevel(user, aclID, aclLevel);
                Print.logInfo((String)("Set UserAcl '" + acctID + "/" + userID + "/" + aclID + "' to level " + (Object)((Object)aclLevel)), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error setting UserAcl: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false)) {
            ++opts;
            if (!aclExists) {
                Print.logError((String)("UserAcl does not exist: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
            } else {
                try {
                    UserAcl userAcl = UserAcl.getUserAcl(user, aclID, false);
                    DBEdit editor = new DBEdit((DBRecord)userAcl);
                    editor.edit();
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing UserAcl: " + acctID + "/" + userID + "/" + aclID), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            UserAcl.usage();
        }
    }

    public static class Key
    extends UserRecord.UserKey<UserAcl> {
        public Key() {
        }

        public Key(String acctId, String userId, String aclId) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("userID", (Object)(userId != null ? userId.toLowerCase() : ""));
            super.setKeyValue(UserAcl.FLD_aclID, (Object)(aclId != null ? aclId.toLowerCase() : ""));
        }

        public DBFactory<UserAcl> getFactory() {
            return UserAcl.getFactory();
        }
    }
}

