/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.AclEntry;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.PasswordHandler;
import org.opengts.db.UserInformation;
import org.opengts.db.UserRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.GroupList;
import org.opengts.db.tables.Role;
import org.opengts.db.tables.UserAcl;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class User
extends UserRecord<User>
implements UserInformation {
    public static final String OPTCOLS_AddressFieldInfo = "startupInit.User.AddressFieldInfo";
    public static final String OPTCOLS_ExtraFieldInfo = "startupInit.User.ExtraFieldInfo";
    public static final String USER_ADMIN = "admin";
    public static final String BLANK_PASSWORD = "*blank*";
    public static final String DEFAULT_TIMEZONE = "GMT";
    public static final String _TABLE_NAME = "User";
    public static final String FLD_userType = "userType";
    public static final String FLD_showMessage = "showMessage";
    public static final String FLD_roleID = "roleID";
    public static final String FLD_password = "password";
    public static final String FLD_gender = "gender";
    public static final String FLD_notifyEmail = "notifyEmail";
    public static final String FLD_contactName = "contactName";
    public static final String FLD_contactPhone = "contactPhone";
    public static final String FLD_contactEmail = "contactEmail";
    public static final String FLD_timeZone = "timeZone";
    public static final String FLD_speedUnits = "speedUnits";
    public static final String FLD_distanceUnits = "distanceUnits";
    public static final String FLD_firstLoginPageID = "firstLoginPageID";
    public static final String FLD_preferredDeviceID = "preferredDeviceID";
    public static final String FLD_maxAccessLevel = "maxAccessLevel";
    public static final String FLD_passwdChangeTime = "passwdChangeTime";
    public static final String FLD_passwdQueryTime = "passwdQueryTime";
    public static final String FLD_lastLoginTime = "lastLoginTime";
    private static DBField[] FieldInfo = new DBField[]{User.newField_accountID(true), User.newField_userID(true), new DBField("userType", Integer.TYPE, "UINT16", "User Type", "edit=2"), new DBField("showMessage", Integer.TYPE, "UINT16", "Show Message", "edit=2"), new DBField("roleID", String.class, DBField.TYPE_ROLE_ID(), "User Role", "edit=2 altkey=role"), new DBField("password", String.class, DBField.TYPE_STRING((int)32), "Password", "edit=2 editor=password"), new DBField("gender", Integer.class, "UINT8", "Gender", "edit=2 enum=User$Gender"), new DBField("notifyEmail", String.class, DBField.TYPE_EMAIL_LIST(), "Notification EMail Address", "edit=2"), new DBField("contactName", String.class, DBField.TYPE_STRING((int)64), "Contact Name", "edit=2 utf8=true"), new DBField("contactPhone", String.class, DBField.TYPE_STRING((int)32), "Contact Phone", "edit=2"), new DBField("contactEmail", String.class, DBField.TYPE_STRING((int)64), "Contact EMail Address", "edit=2 altkey=email"), new DBField("timeZone", String.class, DBField.TYPE_STRING((int)32), "Time Zone", "edit=2 editor=timeZone"), new DBField("firstLoginPageID", String.class, DBField.TYPE_STRING((int)24), "First Login Page ID", "edit=2"), new DBField("preferredDeviceID", String.class, DBField.TYPE_DEV_ID(), "Preferred Device ID", "edit=2"), new DBField("maxAccessLevel", Integer.TYPE, "UINT16", "Maximum Access Level", "edit=2 enum=AclEntry$AccessLevel"), new DBField("passwdChangeTime", Long.TYPE, "UINT32", "Last Password Change Time", "format=time"), new DBField("passwdQueryTime", Long.TYPE, "UINT32", "Last Password Query Time", "format=time"), new DBField("lastLoginTime", Long.TYPE, "UINT32", "Last Login Time", "format=time"), User.newField_isActive(), User.newField_displayName(), User.newField_description(), User.newField_notes(), User.newField_lastUpdateTime(), User.newField_lastUpdateUser((boolean)true), User.newField_creationTime()};
    public static final String FLD_addressLine1 = "addressLine1";
    public static final String FLD_addressLine2 = "addressLine2";
    public static final String FLD_addressLine3 = "addressLine3";
    public static final String FLD_addressCity = "addressCity";
    public static final String FLD_addressState = "addressState";
    public static final String FLD_addressPostalCode = "addressPostalCode";
    public static final String FLD_addressCountry = "addressCountry";
    public static final String FLD_officeLocation = "officeLocation";
    public static final DBField[] AddressFieldInfo = new DBField[]{new DBField("addressLine1", String.class, DBField.TYPE_STRING((int)70), "Address Line 1", "edit=2 utf8=true"), new DBField("addressLine2", String.class, DBField.TYPE_STRING((int)70), "Address Line 2", "edit=2 utf8=true"), new DBField("addressLine3", String.class, DBField.TYPE_STRING((int)70), "Address Line 3", "edit=2 utf8=true"), new DBField("addressCity", String.class, DBField.TYPE_STRING((int)50), "Address City", "edit=2 utf8=true"), new DBField("addressState", String.class, DBField.TYPE_STRING((int)50), "Address State/Province", "edit=2 utf8=true"), new DBField("addressPostalCode", String.class, DBField.TYPE_STRING((int)20), "Address Postal Code", "edit=2 utf8=true"), new DBField("addressCountry", String.class, DBField.TYPE_STRING((int)20), "Address Country", "edit=2 utf8=true"), new DBField("officeLocation", String.class, DBField.TYPE_STRING((int)200), "Office Location", "edit=2 utf8=true")};
    public static final String FLD_customAttributes = "customAttributes";
    public static final DBField[] ExtraFieldInfo = new DBField[]{new DBField("customAttributes", String.class, "TEXT", "Custom Fields", "edit=2 utf8=true")};
    private static DBFactory<User> factory = null;
    private Role userRole = null;
    private TimeZone timeZone = null;
    private RTProperties customAttrRTP = null;
    private Collection<String> customAttrKeys = null;
    private List<String> deviceGroupList = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    private static final String[] ARG_USER = new String[]{"user", "usr", "u"};
    private static final String[] ARG_EMAIL = new String[]{"email"};
    private static final String[] ARG_CREATE = new String[]{"create", "cr"};
    private static final String[] ARG_NOPASS = new String[]{"nopass"};
    private static final String[] ARG_PASSWORD = new String[]{"password", "passwd", "pass"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_EDITALL = new String[]{"editall", "eda"};
    private static final String[] ARG_DELETE = new String[]{"delete", "purge"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_TEST = new String[]{"test"};

    public static String getAdminUserID() {
        return USER_ADMIN;
    }

    public static boolean isAdminUser(String userID) {
        if (StringTools.isBlank((String)userID)) {
            return false;
        }
        return User.getAdminUserID().equals(userID);
    }

    public static boolean isAdminUser(User user) {
        if (user == null) {
            return true;
        }
        return User.getAdminUserID().equalsIgnoreCase(user.getUserID());
    }

    public static String getUserName(User user) {
        if (user == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(user.getAccountID());
        sb.append("/");
        sb.append(user.getUserID());
        sb.append("] ");
        sb.append(user.getDescription());
        return sb.toString().trim();
    }

    public static Gender getGender(User u) {
        return u != null ? (Gender)EnumTools.getValueOf(Gender.class, (int)u.getGender()) : (Gender)EnumTools.getDefault(Gender.class);
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<User> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)User.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, User.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
        }
        return factory;
    }

    public User() {
    }

    public User(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(User.class, (Locale)loc);
        return i18n.getString("User.description", "This table defines Account specific Users.");
    }

    public int getUserType() {
        Integer v = (Integer)this.getFieldValue(FLD_userType);
        return v != null ? v : 0;
    }

    public void setUserType(int v) {
        this.setFieldValue(FLD_userType, v >= 0 ? v : 0);
    }

    public Role getRole() {
        block5: {
            if (this.userRole == null && !StringTools.isBlank((String)this.getRoleID())) {
                try {
                    this.userRole = Role.getRole(this.getAccountID(), this.getRoleID());
                    if (this.userRole != null) {
                        if (this.hasAccount() && !this.userRole.isSystemAdminRole()) {
                            this.userRole.setAccount(this.getAccount());
                        }
                        break block5;
                    }
                    Print.logError((String)"User Role not found: %s/%s [user=%s]", (Object[])new Object[]{this.getAccountID(), this.getRoleID(), this.getUserID()});
                    return null;
                }
                catch (DBException dbe) {
                    Print.logException((String)("Error retrieving User Role: " + this.getAccountID() + "/" + this.getRoleID()), (Throwable)dbe);
                    return null;
                }
            }
        }
        return this.userRole;
    }

    public String getRoleID() {
        String v = (String)this.getFieldValue(FLD_roleID);
        return StringTools.trim((String)v);
    }

    public void setRoleID(String v) {
        this.setFieldValue(FLD_roleID, StringTools.trim((String)v));
        this.userRole = null;
    }

    public String getPassword() {
        String p = (String)this.getFieldValue(FLD_password);
        return p != null ? p : "";
    }

    public void setPassword(String p) {
        this.setFieldValue(FLD_password, p != null ? p : "");
        this.setPasswdChangeTime(DateTime.getCurrentTimeSec());
    }

    @Override
    public String getEncodedPassword() {
        return this.getPassword();
    }

    public void setEncodedPassword(String p) {
        this.setPassword(p);
    }

    public String getDecodedPassword(BasicPrivateLabel bpl) {
        if (bpl == null) {
            bpl = Account.getPrivateLabel(this.getAccount());
        }
        String pass = Account.decodePassword(bpl, this.getEncodedPassword());
        return pass;
    }

    @Override
    public void setDecodedPassword(BasicPrivateLabel bpl, String enteredPass) {
        if (bpl == null) {
            bpl = Account.getPrivateLabel(this.getAccount());
        }
        String pass = Account.encodePassword(bpl, enteredPass);
        if (!this.getEncodedPassword().equals(pass)) {
            this.setEncodedPassword(pass);
        }
    }

    public String resetPassword(BasicPrivateLabel bpl) {
        String pass = Account.createRandomPassword(8);
        this.setDecodedPassword(bpl, pass);
        return pass;
    }

    @Override
    public boolean checkPassword(BasicPrivateLabel bpl, String enteredPass) {
        if (bpl == null) {
            bpl = Account.getPrivateLabel(this.getAccount());
        }
        return Account.checkPassword(bpl, enteredPass, this.getEncodedPassword());
    }

    public int getGender() {
        Integer v = (Integer)this.getFieldValue(FLD_gender);
        return v != null ? v.intValue() : ((Gender)EnumTools.getDefault(Gender.class)).getIntValue();
    }

    public void setGender(int v) {
        this.setFieldValue(FLD_gender, ((Gender)EnumTools.getValueOf(Gender.class, (int)v)).getIntValue());
    }

    public void setGender(Gender v) {
        this.setFieldValue(FLD_gender, ((Gender)EnumTools.getValueOf(Gender.class, (Enum)v)).getIntValue());
    }

    public void setGender(String v, Locale locale) {
        this.setFieldValue(FLD_gender, ((Gender)EnumTools.getValueOf(Gender.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getNotifyEmail() {
        String v = (String)this.getFieldValue(FLD_notifyEmail);
        return StringTools.trim((String)v);
    }

    public void setNotifyEmail(String v) {
        this.setFieldValue(FLD_notifyEmail, StringTools.trim((String)v));
    }

    @Override
    public String getContactName() {
        String v = (String)this.getFieldValue(FLD_contactName);
        return StringTools.trim((String)v);
    }

    @Override
    public void setContactName(String v) {
        this.setFieldValue(FLD_contactName, StringTools.trim((String)v));
    }

    @Override
    public String getContactPhone() {
        String v = (String)this.getFieldValue(FLD_contactPhone);
        return StringTools.trim((String)v);
    }

    @Override
    public void setContactPhone(String v) {
        this.setFieldValue(FLD_contactPhone, StringTools.trim((String)v));
    }

    @Override
    public String getContactEmail() {
        String v = (String)this.getFieldValue(FLD_contactEmail);
        return StringTools.trim((String)v);
    }

    @Override
    public void setContactEmail(String v) {
        this.setFieldValue(FLD_contactEmail, StringTools.trim((String)v));
    }

    public TimeZone getTimeZone(TimeZone dft) {
        if (this.timeZone == null) {
            this.timeZone = DateTime.getTimeZone((String)this.getTimeZone(), null);
            if (this.timeZone == null) {
                this.timeZone = dft != null ? dft : DateTime.getGMTTimeZone();
            }
        }
        return this.timeZone;
    }

    @Override
    public String getTimeZone() {
        String v = (String)this.getFieldValue(FLD_timeZone);
        return StringTools.isBlank((String)v) ? DEFAULT_TIMEZONE : v.trim();
    }

    @Override
    public void setTimeZone(String v) {
        String tz = StringTools.isBlank((String)v) ? DEFAULT_TIMEZONE : v.trim();
        this.setFieldValue(FLD_timeZone, tz);
    }

    public DateTime getCurrentDateTime() {
        return new DateTime(this.getTimeZone(null));
    }

    public int getSpeedUnits() {
        Integer v = (Integer)this.getOptionalFieldValue(FLD_speedUnits);
        return v != null ? v.intValue() : ((Account.SpeedUnits)EnumTools.getDefault(Account.SpeedUnits.class)).getIntValue();
    }

    public void setSpeedUnits(int v) {
        this.setOptionalFieldValue(FLD_speedUnits, ((Account.SpeedUnits)EnumTools.getValueOf(Account.SpeedUnits.class, (int)v)).getIntValue());
    }

    public void setSpeedUnits(Account.SpeedUnits v) {
        this.setOptionalFieldValue(FLD_speedUnits, ((Account.SpeedUnits)EnumTools.getValueOf(Account.SpeedUnits.class, (Enum)v)).getIntValue());
    }

    public void setSpeedUnits(String v, Locale locale) {
        this.setOptionalFieldValue(FLD_speedUnits, ((Account.SpeedUnits)EnumTools.getValueOf(Account.SpeedUnits.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getSpeedString(double speedKPH, boolean inclUnits, Locale locale) {
        return this.getSpeedString(speedKPH, "0", null, inclUnits, locale);
    }

    public String getSpeedString(double speedKPH, String format, boolean inclUnits, Locale locale) {
        return this.getSpeedString(speedKPH, format, null, inclUnits, locale);
    }

    public String getSpeedString(double speedKPH, String format, Account.SpeedUnits speedUnitsEnum, boolean inclUnits, Locale locale) {
        if (speedUnitsEnum == null) {
            speedUnitsEnum = Account.getSpeedUnits(this);
        }
        double speed = speedUnitsEnum.convertFromKPH(speedKPH);
        String speedFmt = StringTools.format((double)speed, (String)format);
        if (speed <= 0.0) {
            return speedFmt;
        }
        if (inclUnits) {
            return speedFmt + " " + speedUnitsEnum.toString(locale);
        }
        return speedFmt;
    }

    public int getDistanceUnits() {
        Integer v = (Integer)this.getOptionalFieldValue(FLD_distanceUnits);
        return v != null ? v.intValue() : ((Account.DistanceUnits)EnumTools.getDefault(Account.DistanceUnits.class)).getIntValue();
    }

    public void setDistanceUnits(int v) {
        this.setOptionalFieldValue(FLD_distanceUnits, ((Account.DistanceUnits)EnumTools.getValueOf(Account.DistanceUnits.class, (int)v)).getIntValue());
    }

    public void setDistanceUnits(Account.DistanceUnits v) {
        this.setOptionalFieldValue(FLD_distanceUnits, ((Account.DistanceUnits)EnumTools.getValueOf(Account.DistanceUnits.class, (Enum)v)).getIntValue());
    }

    public void setDistanceUnits(String v, Locale locale) {
        this.setOptionalFieldValue(FLD_distanceUnits, ((Account.DistanceUnits)EnumTools.getValueOf(Account.DistanceUnits.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getDistanceString(double distKM, boolean inclUnits, Locale locale) {
        Account.DistanceUnits units = Account.getDistanceUnits(this);
        String distUnitsStr = units.toString(locale);
        double dist = units.convertFromKM(distKM);
        String distStr = StringTools.format((double)dist, (String)"0");
        return inclUnits ? distStr + " " + distUnitsStr : distStr;
    }

    public String getFirstLoginPageID() {
        String v = (String)this.getFieldValue(FLD_firstLoginPageID);
        return StringTools.trim((String)v);
    }

    public void setFirstLoginPageID(String v) {
        this.setFieldValue(FLD_firstLoginPageID, StringTools.trim((String)v));
    }

    public boolean hasFirstLoginPageID() {
        return !StringTools.isBlank((String)this.getFirstLoginPageID());
    }

    public String getPreferredDeviceID() {
        String v = (String)this.getFieldValue(FLD_preferredDeviceID);
        return StringTools.trim((String)v);
    }

    public void setPreferredDeviceID(String v) {
        this.setFieldValue(FLD_preferredDeviceID, StringTools.trim((String)v));
    }

    public boolean hasPreferredDeviceID() {
        return !StringTools.isBlank((String)this.getPreferredDeviceID());
    }

    public int getMaxAccessLevel() {
        if (this.isAdminUser()) {
            return AclEntry.AccessLevel.ALL.getIntValue();
        }
        Integer v = (Integer)this.getFieldValue(FLD_maxAccessLevel);
        if (v != null) {
            int aclLevel = v;
            if (aclLevel < 0 || aclLevel == AclEntry.AccessLevel.NONE.getIntValue()) {
                return AclEntry.AccessLevel.ALL.getIntValue();
            }
            if (aclLevel > AclEntry.AccessLevel.ALL.getIntValue()) {
                return AclEntry.AccessLevel.ALL.getIntValue();
            }
            return aclLevel;
        }
        return AclEntry.AccessLevel.ALL.getIntValue();
    }

    public void setMaxAccessLevel(int v) {
        int accessLevel = ((AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (int)v)).getIntValue();
        this.setFieldValue(FLD_maxAccessLevel, accessLevel);
    }

    public void setMaxAccessLevel(String v) {
        int accessLevel = ((AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (String)v)).getIntValue();
        this.setFieldValue(FLD_maxAccessLevel, accessLevel);
    }

    public void setMaxAccessLevel(AclEntry.AccessLevel v) {
        int accessLevel = v != null ? v.getIntValue() : AclEntry.AccessLevel.ALL.getIntValue();
        this.setFieldValue(FLD_maxAccessLevel, accessLevel);
    }

    public long getPasswdChangeTime() {
        Long v = (Long)this.getFieldValue(FLD_passwdChangeTime);
        return v != null ? v : 0L;
    }

    public void setPasswdChangeTime(long v) {
        this.setFieldValue(FLD_passwdChangeTime, v);
    }

    public boolean hasPasswordExpired() {
        BasicPrivateLabel bpl = Account.getPrivateLabel(this.getAccount());
        PasswordHandler pwh = Account.getPasswordHandler(bpl);
        return pwh.hasPasswordExpired(this.getPasswdChangeTime());
    }

    @Override
    public long getPasswdQueryTime() {
        Long v = (Long)this.getFieldValue(FLD_passwdQueryTime);
        return v != null ? v : 0L;
    }

    @Override
    public void setPasswdQueryTime(long v) {
        this.setFieldValue(FLD_passwdQueryTime, v);
    }

    @Override
    public long getLastLoginTime() {
        Long v = (Long)this.getFieldValue(FLD_lastLoginTime);
        return v != null ? v : 0L;
    }

    @Override
    public void setLastLoginTime(long v) {
        this.setFieldValue(FLD_lastLoginTime, v);
    }

    public String getAddressLine1() {
        String v = (String)this.getFieldValue(FLD_addressLine1);
        return StringTools.trim((String)v);
    }

    public String getAddressLine2() {
        String v = (String)this.getFieldValue(FLD_addressLine2);
        return StringTools.trim((String)v);
    }

    public String getAddressLine3() {
        String v = (String)this.getFieldValue(FLD_addressLine3);
        return StringTools.trim((String)v);
    }

    public String[] getAddressLines() {
        return new String[]{this.getAddressLine1(), this.getAddressLine2(), this.getAddressLine3()};
    }

    public String getAddressCity() {
        String v = (String)this.getFieldValue(FLD_addressCity);
        return StringTools.trim((String)v);
    }

    public String getAddressState() {
        String v = (String)this.getFieldValue(FLD_addressState);
        return StringTools.trim((String)v);
    }

    public String getAddressPostalCode() {
        String v = (String)this.getFieldValue(FLD_addressPostalCode);
        return StringTools.trim((String)v);
    }

    public String getAddressCountry() {
        String v = (String)this.getFieldValue(FLD_addressCountry);
        return StringTools.trim((String)v);
    }

    public void setAddressLine1(String v) {
        this.setFieldValue(FLD_addressLine1, StringTools.trim((String)v));
    }

    public void setAddressLine2(String v) {
        this.setFieldValue(FLD_addressLine2, StringTools.trim((String)v));
    }

    public void setAddressLine3(String v) {
        this.setFieldValue(FLD_addressLine3, StringTools.trim((String)v));
    }

    public void setAddressLines(String[] lines) {
        if (lines != null && lines.length > 0) {
            int n;
            for (n = 0; n < lines.length && (lines[n] == null || lines[n].trim().equals("")); ++n) {
            }
            this.setAddressLine1(n < lines.length ? lines[n++].trim() : "");
            while (n < lines.length && (lines[n] == null || lines[n].trim().equals(""))) {
                ++n;
            }
            this.setAddressLine2(n < lines.length ? lines[n++].trim() : "");
            while (n < lines.length && (lines[n] == null || lines[n].trim().equals(""))) {
                ++n;
            }
            this.setAddressLine3(n < lines.length ? lines[n++].trim() : "");
        } else {
            this.setAddressLine1("");
            this.setAddressLine2("");
            this.setAddressLine3("");
        }
    }

    public void setAddressCity(String v) {
        this.setFieldValue(FLD_addressCity, StringTools.trim((String)v));
    }

    public void setAddressState(String v) {
        this.setFieldValue(FLD_addressState, StringTools.trim((String)v));
    }

    public void setAddressPostalCode(String v) {
        this.setFieldValue(FLD_addressPostalCode, StringTools.trim((String)v));
    }

    public void setAddressCountry(String v) {
        this.setFieldValue(FLD_addressCountry, StringTools.trim((String)v));
    }

    public String getOfficeLocation() {
        String v = (String)this.getFieldValue(FLD_officeLocation);
        return StringTools.trim((String)v);
    }

    public void setOfficeLocation(String v) {
        this.setFieldValue(FLD_officeLocation, StringTools.trim((String)v));
    }

    public String getCustomAttributes() {
        String v = (String)this.getOptionalFieldValue(FLD_customAttributes);
        return StringTools.trim((String)v);
    }

    public void setCustomAttributes(String v) {
        this.setOptionalFieldValue(FLD_customAttributes, StringTools.trim((String)v));
        this.customAttrRTP = null;
        this.customAttrKeys = null;
    }

    public RTProperties getCustomAttributesRTP() {
        if (this.customAttrRTP == null) {
            this.customAttrRTP = new RTProperties(this.getCustomAttributes());
        }
        return this.customAttrRTP;
    }

    public Collection<String> getCustomAttributeKeys() {
        if (this.customAttrKeys == null) {
            this.customAttrKeys = this.getCustomAttributesRTP().getPropertyKeys(null);
        }
        return this.customAttrKeys;
    }

    public String getCustomAttribute(String key) {
        return this.getCustomAttributesRTP().getString(key, null);
    }

    public String setCustomAttribute(String key, String value) {
        return this.getCustomAttributesRTP().getString(key, value);
    }

    public int getShowMessage() {
        Integer v = (Integer)this.getFieldValue(FLD_showMessage);
        return v != null ? v : 0;
    }

    public void setShowMessage(int v) {
        this.setFieldValue(FLD_showMessage, v >= 0 ? v : 0);
    }

    public void setCreationDefaultValues() {
        this.setIsActive(true);
        if (this.isAdminUser()) {
            this.setDescription("Administrator");
            this.setShowMessage(0);
            this.setEncodedPassword(this.getAccount().getEncodedPassword());
        } else {
            this.setDescription("Nuevo Usuario");
            this.setShowMessage(0);
        }
        super.setRuntimeDefaultValues();
    }

    public boolean isAdminUser() {
        return User.isAdminUser(this.getUserID());
    }

    public boolean getDefaultDeviceAuthorization() {
        if (this.isAdminUser()) {
            return true;
        }
        return DBConfig.GetDefaultDeviceAuthorization(this.getAccountID());
    }

    protected static DBSelect _getGroupListSelect(String acctId, String userId, long limit) {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)userId)) {
            return null;
        }
        DBSelect dsel = new DBSelect(GroupList.getFactory());
        dsel.setSelectedFields(new String[]{"groupID"});
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("userID", (Object)userId))));
        dsel.setOrderByFields(new String[]{"groupID"});
        dsel.setLimit(limit);
        return dsel;
    }

    public static List<String> getGroupsForUser(String acctId, String userId) throws DBException {
        return User.getGroupsForUser(acctId, userId, -1L);
    }

    public static List<String> getGroupsForUser(String acctId, String userId, long limit) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)userId)) {
            return null;
        }
        DBSelect dsel = User._getGroupListSelect(acctId, userId, limit);
        if (dsel == null) {
            return null;
        }
        Vector<String> grpList = new Vector<String>();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String grpId = rs.getString("groupID");
                grpList.add(grpId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting User DeviceGroup List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return grpList;
    }

    public List<String> getDeviceGroups(boolean refresh) throws DBException {
        if (this.deviceGroupList == null || refresh) {
            this.deviceGroupList = User.getGroupsForUser(this.getAccountID(), this.getUserID(), -1L);
        }
        return this.deviceGroupList;
    }

    public boolean isDeviceGroupAll() throws DBException {
        List<String> groups = this.getDeviceGroups(false);
        if (ListTools.isEmpty(groups)) {
            return this.getDefaultDeviceAuthorization();
        }
        for (String groupID : groups) {
            if (!groupID.equalsIgnoreCase("all")) continue;
            return true;
        }
        return false;
    }

    public boolean setDeviceGroups(String[] groupList) {
        return this._setDeviceGroups(ListTools.toIterator((Object[])groupList));
    }

    public boolean setDeviceGroups(List<String> groupList) {
        return this._setDeviceGroups(ListTools.toIterator(groupList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _setDeviceGroups(Iterator<String> groupListIter) {
        String accountID = this.getAccountID();
        String userID = this.getUserID();
        this.deviceGroupList = null;
        try {
            GroupList.Key grpListKey = new GroupList.Key();
            grpListKey.setFieldValue("accountID", accountID);
            grpListKey.setFieldValue("userID", userID);
            DBDelete ddel = new DBDelete(GroupList.getFactory());
            ddel.setWhere(grpListKey.getWhereClause(DBWhere.KEY_PARTIAL_FIRST));
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                dbc.executeUpdate(ddel.toString());
            }
            finally {
                DBConnection.release((DBConnection)dbc);
            }
        }
        catch (Throwable th) {
            Print.logException((String)"Error deleting existing DeviceGroup entries from the User GroupList table", (Throwable)th);
            return false;
        }
        if (groupListIter != null) {
            boolean all = false;
            int grpCount = 0;
            HashSet<String> addGroups = new HashSet<String>();
            while (groupListIter.hasNext()) {
                String groupID = groupListIter.next();
                if ("all".equalsIgnoreCase(groupID)) {
                    all = true;
                    addGroups.clear();
                    break;
                }
                if ("none".equalsIgnoreCase(groupID) || StringTools.isBlank((String)groupID)) continue;
                try {
                    if (DeviceGroup.exists(accountID, groupID)) {
                        ++grpCount;
                        addGroups.add(groupID);
                        continue;
                    }
                    Print.logError((String)"DeviceGroup does not exist: %s/%s", (Object[])new Object[]{accountID, groupID});
                }
                catch (DBException dbe) {
                    Print.logException((String)"Error creating new DeviceGroup entries in the User GroupList table", (Throwable)dbe);
                    return false;
                }
            }
            if (all) {
                if (!this.getDefaultDeviceAuthorization()) {
                    try {
                        GroupList groupListItem = GroupList.getGroupList(this, "all", true);
                        groupListItem.save();
                    }
                    catch (DBException dbe) {
                        Print.logException((String)"Error creating new DeviceGroup entries in the User GroupList table", (Throwable)dbe);
                        return false;
                    }
                }
            } else if (!ListTools.isEmpty(addGroups)) {
                try {
                    for (String groupID : addGroups) {
                        GroupList groupListItem = GroupList.getGroupList(this, groupID, true);
                        groupListItem.save();
                    }
                }
                catch (DBException dbe) {
                    Print.logException((String)"Error creating new DeviceGroup entries in the User GroupList table", (Throwable)dbe);
                    return false;
                }
            }
        }
        return true;
    }

    public void addDeviceGroup(String groupID) throws DBException {
        if (!StringTools.isBlank((String)groupID)) {
            String accountID = this.getAccountID();
            if (groupID.equalsIgnoreCase("all") || DeviceGroup.exists(accountID, groupID)) {
                this.deviceGroupList = null;
                if (!GroupList.exists(accountID, this.getUserID(), groupID)) {
                    GroupList groupListItem = GroupList.getGroupList(this, groupID, true);
                    groupListItem.save();
                }
            } else {
                Print.logError((String)"DeviceGroup does not exist: %s/%s", (Object[])new Object[]{accountID, groupID});
            }
        }
    }

    public void removeDeviceGroup(String groupID) throws DBException {
        if (!StringTools.isBlank((String)groupID)) {
            this.deviceGroupList = null;
            GroupList.Key grpListKey = new GroupList.Key(this.getAccountID(), this.getUserID(), groupID);
            grpListKey.delete(true);
        }
    }

    public static OrderedSet<String> getAuthorizedDeviceIDs(User user, Account account, boolean inclInactv) throws DBException {
        if (user != null) {
            return user.getAuthorizedDeviceIDs(inclInactv);
        }
        if (account != null) {
            return Device.getDeviceIDsForAccount(account.getAccountID(), null, inclInactv);
        }
        return new OrderedSet();
    }

    public static OrderedSet<String> getAuthorizedDeviceIDs(User user, String accountID, boolean inclInactv) throws DBException {
        if (user != null) {
            return user.getAuthorizedDeviceIDs(inclInactv);
        }
        if (accountID != null) {
            return Device.getDeviceIDsForAccount(accountID, null, inclInactv);
        }
        return new OrderedSet();
    }

    protected OrderedSet<String> getAuthorizedDeviceIDs(boolean inclInactv) throws DBException {
        List<String> groupList = this.getDeviceGroups(true);
        if (!ListTools.isEmpty(groupList)) {
            OrderedSet list = new OrderedSet();
            for (String groupID : groupList) {
                OrderedSet<String> d = DeviceGroup.getDeviceIDsForGroup(this.getAccountID(), groupID, null, inclInactv);
                ListTools.toList(d, (List)list);
            }
            return list;
        }
        if (this.getDefaultDeviceAuthorization()) {
            return Device.getDeviceIDsForAccount(this.getAccountID(), null, inclInactv, -1L);
        }
        return new OrderedSet();
    }

    public boolean isAuthorizedDevice(String deviceID) throws DBException {
        if (this.isAdminUser()) {
            return true;
        }
        if (StringTools.isBlank((String)deviceID)) {
            return false;
        }
        List<String> groupList = this.getDeviceGroups(false);
        if (ListTools.isEmpty(groupList)) {
            return this.getDefaultDeviceAuthorization();
        }
        for (String groupID : groupList) {
            if (groupID.equalsIgnoreCase("all")) {
                return true;
            }
            if (!DeviceGroup.exists(this.getAccountID(), groupID, deviceID)) continue;
            return true;
        }
        Print.logInfo((String)"Not authorized device for user '%s': %s", (Object[])new Object[]{this.getUserID(), deviceID});
        return false;
    }

    public String getDefaultDeviceID(boolean inclInactv) throws DBException {
        List<String> groupList;
        if (this.hasPreferredDeviceID()) {
            String devID = this.getPreferredDeviceID();
            try {
                if (Device.exists(this.getAccountID(), devID) && this.isAuthorizedDevice(devID)) {
                    return devID;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (ListTools.isEmpty(groupList = User.getGroupsForUser(this.getAccountID(), this.getUserID(), 1L))) {
            if (this.getDefaultDeviceAuthorization()) {
                OrderedSet<String> d = Device.getDeviceIDsForAccount(this.getAccountID(), null, inclInactv, 1L);
                return !ListTools.isEmpty(d) ? (String)d.get(0) : null;
            }
            return null;
        }
        String groupID = groupList.get(0);
        OrderedSet<String> d = DeviceGroup.getDeviceIDsForGroup(this.getAccountID(), groupID, null, inclInactv, 1L);
        return !ListTools.isEmpty(d) ? (String)d.get(0) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAclsForUser() throws DBException {
        Statement stmt;
        DBConnection dbc;
        Vector<String> aclList;
        block16: {
            String acctID = this.getAccountID();
            aclList = new Vector<String>();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(UserAcl.getFactory());
                dsel.setSelectedFields(new String[]{"aclID"});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)this.getAccountID()), dwh.EQ("userID", (Object)this.getUserID()))));
                dsel.setOrderByFields(new String[]{"aclID"});
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String aclId = rs.getString("aclID");
                    aclList.add(aclId);
                }
                if (rs == null) break block16;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting User ACL List", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return aclList.toArray(new String[aclList.size()]);
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getUserID();
    }

    public static boolean exists(String acctID, String userID) throws DBException {
        if (acctID != null && userID != null) {
            Key userKey = new Key(acctID, userID);
            return userKey.exists();
        }
        return false;
    }

    public static User getUser(Account account, String userID) throws DBException {
        if (account == null) {
            throw new DBException("Account is null");
        }
        if (userID == null) {
            throw new DBException("UserID is null");
        }
        String acctID = account.getAccountID();
        Key userKey = new Key(acctID, userID);
        if (userKey.exists()) {
            User user = (User)userKey.getDBRecord(true);
            user.setAccount(account);
            return user;
        }
        return null;
    }

    public static User getUser(Account account, String userId, boolean create) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String acctId = account.getAccountID();
        if (userId == null || userId.equals("")) {
            throw new DBNotFoundException("User-ID not specified.");
        }
        User user = null;
        Key userKey = new Key(acctId, userId);
        if (!userKey.exists()) {
            if (create) {
                user = (User)userKey.getDBRecord();
                user.setAccount(account);
                user.setCreationDefaultValues();
                return user;
            }
            throw new DBNotFoundException("User-ID does not exists '" + (Object)((Object)userKey) + "'");
        }
        if (create) {
            throw new DBAlreadyExistsException("User-ID already exists '" + (Object)((Object)userKey) + "'");
        }
        user = User.getUser(account, userId);
        if (user == null) {
            throw new DBException("Unable to read existing User-ID '" + (Object)((Object)userKey) + "'");
        }
        return user;
    }

    public static User createNewUser(Account account, String userID, String contactEmail, String passwd) throws DBException {
        if (account != null && userID != null && !userID.equals("")) {
            User user = User.getUser(account, userID, true);
            if (contactEmail != null) {
                user.setContactEmail(contactEmail);
            }
            if (passwd != null) {
                user.setDecodedPassword(null, passwd);
            }
            user.save();
            return user;
        }
        throw new DBNotFoundException("Invalid Account/UserID specified");
    }

    public static String[] getUsersForAccount(String acctId) throws DBException {
        return User.getUsersForAccount(acctId, -1);
    }

    public static String[] getUsersForAccount(String acctId, int userType) throws DBException {
        if (acctId == null || acctId.equals("")) {
            return new String[0];
        }
        DBSelect dsel = new DBSelect(User.getFactory());
        dsel.setSelectedFields(new String[]{"userID"});
        DBWhere dwh = dsel.createDBWhere();
        dwh.append(dwh.EQ("accountID", (Object)acctId));
        if (userType >= 0) {
            dwh.append(dwh.AND_(dwh.EQ(FLD_userType, userType)));
        }
        dsel.setWhere(dwh.WHERE(dwh.toString()));
        dsel.setOrderByFields(new String[]{"userID"});
        return User.getUserIDs((DBSelect<User>)dsel);
    }

    public static String[] getUserIDs(DBSelect<User> dsel) throws DBException {
        if (dsel == null) {
            return new String[0];
        }
        dsel.setSelectedFields(new String[]{"userID"});
        Vector<String> userList = new Vector<String>();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String userId = rs.getString("userID");
                userList.add(userId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting Account User List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return userList.toArray(new String[userList.size()]);
    }

    public static User getUserForContactEmail(String acctId, String emailAddr) throws DBException {
        List<User> userList = User.getUsersForContactEmail(acctId, emailAddr);
        return !ListTools.isEmpty(userList) ? userList.get(0) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<User> getUsersForContactEmail(String acctId, String emailAddr) throws DBException {
        Statement stmt;
        DBConnection dbc;
        Vector<User> userList;
        block19: {
            userList = new Vector<User>();
            boolean acctIdBlank = StringTools.isBlank((String)acctId);
            if (StringTools.isBlank((String)emailAddr)) {
                return userList;
            }
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(User.getFactory());
                DBWhere dwh = dsel.createDBWhere();
                if (acctIdBlank) {
                    dwh.append(dwh.EQ(FLD_contactEmail, (Object)emailAddr));
                } else {
                    dwh.append(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ(FLD_contactEmail, (Object)emailAddr)));
                }
                dsel.setWhere(dwh.WHERE(dwh.toString()));
                dsel.setOrderByFields(new String[]{"userID"});
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String aid = rs.getString("accountID");
                    String uid = rs.getString("userID");
                    User user = new User(new Key(aid, uid));
                    user.setAllFieldValues(rs);
                    userList.add(user);
                }
                if (rs == null) break block19;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Get User ContactEmail", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return userList;
    }

    protected static DBSelect<User> _getUsersForRoleSelect(String acctID, String roleID, long limit) {
        if (StringTools.isBlank((String)acctID)) {
            return null;
        }
        if (StringTools.isBlank((String)roleID)) {
            return null;
        }
        DBSelect dsel = new DBSelect(User.getFactory());
        dsel.setSelectedFields(new String[]{"accountID", "userID"});
        DBWhere dwh = dsel.createDBWhere();
        dwh.append(dwh.AND(dwh.EQ("accountID", (Object)acctID), dwh.EQ(FLD_roleID, (Object)roleID)));
        dsel.setWhere(dwh.WHERE(dwh.toString()));
        dsel.setOrderByFields(new String[]{"userID"});
        dsel.setLimit(limit);
        return dsel;
    }

    public static boolean hasUserIDsForRole(String acctID, String roleID) throws DBException {
        return !ListTools.isEmpty(User.getUserIDsForRole(acctID, roleID, 1L));
    }

    public static List<String> getUserIDsForRole(String acctID, String roleID) throws DBException {
        return User.getUserIDsForRole(acctID, roleID, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countUserIDsForRole(String acctID, String roleID) throws DBException {
        if (StringTools.isBlank((String)acctID)) {
            return 0L;
        }
        if (StringTools.isBlank((String)roleID)) {
            return 0L;
        }
        DBSelect<User> dsel = User._getUsersForRoleSelect(acctID, roleID, -1L);
        if (dsel == null) {
            return 0L;
        }
        long recordCount = 0L;
        try {
            DBProvider.lockTables((String[])new String[]{User.TABLE_NAME()}, null);
            recordCount = DBRecord.getRecordCount(dsel);
        }
        finally {
            DBProvider.unlockTables();
        }
        return recordCount;
    }

    public static List<String> getUserIDsForRole(String acctID, String roleID, long limit) throws DBException {
        Vector<String> userList = new Vector<String>();
        if (StringTools.isBlank((String)acctID)) {
            return null;
        }
        if (StringTools.isBlank((String)roleID)) {
            return null;
        }
        DBSelect<User> dsel = User._getUsersForRoleSelect(acctID, roleID, limit);
        if (dsel == null) {
            return null;
        }
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String aid = rs.getString("accountID");
                String uid = rs.getString("userID");
                userList.add(uid);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Get Users for Role", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return userList;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + User.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Acount ID which owns User", (Object[])new Object[0]);
        Print.logInfo((String)"  -user=<id>      User ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new User", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           Edit an existing (or newly created) User", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified User", (Object[])new Object[0]);
        Print.logInfo((String)"  -list           List Users for Account", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String userID = RTConfig.getString((String[])ARG_USER, (String)"");
        String contactEmail = RTConfig.getString((String[])ARG_EMAIL, (String)"");
        boolean listUsers = RTConfig.getBoolean((String[])ARG_LIST, (boolean)false);
        int opts = 0;
        if (acctID == null || acctID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            User.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(acctID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                User.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (listUsers) {
            ++opts;
            try {
                Print.logInfo((String)("Account: " + acctID), (Object[])new Object[0]);
                String[] userList = User.getUsersForAccount(acctID);
                for (int i = 0; i < userList.length; ++i) {
                    Print.logInfo((String)("  User: " + userList[i]), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Error listing Users: " + acctID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (userID == null || userID.equals("")) {
            Print.logError((String)"User-ID not specified.", (Object[])new Object[0]);
            User.usage();
        }
        boolean userExists = false;
        try {
            userExists = User.exists(acctID, userID);
        }
        catch (DBException dbe) {
            Print.logError((String)("Error determining if User exists: " + acctID + "," + userID), (Object[])new Object[0]);
            System.exit(99);
        }
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !acctID.equals("") && !userID.equals("")) {
            ++opts;
            if (!userExists) {
                Print.logWarn((String)("User does not exist: " + acctID + "/" + userID), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key userKey = new Key(acctID, userID);
                userKey.delete(true);
                Print.logInfo((String)("User deleted: " + acctID + "/" + userID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting User: " + acctID + "/" + userID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (userExists) {
                Print.logWarn((String)("User already exists: " + acctID + "/" + userID), (Object[])new Object[0]);
            } else {
                try {
                    String passwd = null;
                    if (RTConfig.getBoolean((String[])ARG_NOPASS, (boolean)false)) {
                        passwd = BLANK_PASSWORD;
                    } else if (RTConfig.hasProperty((String[])ARG_PASSWORD)) {
                        passwd = RTConfig.getString((String[])ARG_PASSWORD, (String)"");
                    }
                    User.createNewUser(acct, userID, contactEmail, passwd);
                    Print.logInfo((String)("Created User-ID: " + acctID + "/" + userID), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating User: " + acctID + "/" + userID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false) || RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false)) {
            ++opts;
            if (!userExists) {
                Print.logError((String)("User does not exist: " + acctID + "/" + userID), (Object[])new Object[0]);
            } else {
                try {
                    boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                    User user = User.getUser(acct, userID, false);
                    DBEdit editor = new DBEdit((DBRecord)user);
                    editor.edit(allFlds);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing User: " + acctID + "/" + userID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_TEST)) {
            int test = RTConfig.getInt((String[])ARG_TEST, (int)0);
            ++opts;
            if (!userExists) {
                Print.logError((String)("User does not exist: " + acctID + "/" + userID), (Object[])new Object[0]);
            } else {
                String[] dg = new String[]{"G1", "G2", "G3", "G4", "G5"};
                switch (test) {
                    case 1: {
                        dg = new String[]{"G6", "G7", "G8", "G9", "GA"};
                        break;
                    }
                    case 2: {
                        dg = new String[]{"G4", "G5", "G6", "G7", "G8"};
                    }
                }
                try {
                    User user = User.getUser(acct, userID, false);
                    List<String> groupList = user.getDeviceGroups(true);
                    for (String gid : groupList) {
                        Print.sysPrintln((String)("Old DeviceGroup: " + gid), (Object[])new Object[0]);
                    }
                    user.setDeviceGroups((String[])null);
                    Print.sysPrintln((String)("1) Is 'mobile' Authorized Device?: " + user.isAuthorizedDevice("mobile")), (Object[])new Object[0]);
                    user.setDeviceGroups(dg);
                    groupList = user.getDeviceGroups(true);
                    for (String gid : groupList) {
                        Print.sysPrintln((String)("New DeviceGroup: " + gid), (Object[])new Object[0]);
                    }
                    Print.sysPrintln((String)("2) Is 'mobile' Authorized Device?: " + user.isAuthorizedDevice("mobile")), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error testing User: " + acctID + "/" + userID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            User.usage();
        }
    }

    public static class Key
    extends UserRecord.UserKey<User> {
        public Key() {
        }

        public Key(String acctId, String userId) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("userID", (Object)(userId != null ? userId.toLowerCase() : ""));
        }

        public DBFactory<User> getFactory() {
            return User.getFactory();
        }
    }

    public static enum Gender implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        UNKNOWN(0, I18N.getString(User.class, (String)"User.gender.notSpecified", (String)"n/a")),
        MALE(1, I18N.getString(User.class, (String)"User.gender.male", (String)"Male")),
        FEMALE(2, I18N.getString(User.class, (String)"User.gender.female", (String)"Female"));

        private int vv = 0;
        private I18N.Text aa = null;

        private Gender(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }
    }

    public static enum UserType implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        TYPE_000(0, I18N.getString(User.class, (String)"User.type.type000", (String)"Type000")),
        TYPE_001(1, I18N.getString(User.class, (String)"User.type.type001", (String)"Type001")),
        TYPE_002(2, I18N.getString(User.class, (String)"User.type.type002", (String)"Type002")),
        TYPE_003(3, I18N.getString(User.class, (String)"User.type.type003", (String)"Type003")),
        TYPE_010(10, I18N.getString(User.class, (String)"User.type.type010", (String)"Type010")),
        TYPE_011(11, I18N.getString(User.class, (String)"User.type.type011", (String)"Type011")),
        TYPE_020(20, I18N.getString(User.class, (String)"User.type.type020", (String)"Type020")),
        TYPE_021(21, I18N.getString(User.class, (String)"User.type.type021", (String)"Type021")),
        TYPE_030(30, I18N.getString(User.class, (String)"User.type.type030", (String)"Type030")),
        TYPE_031(31, I18N.getString(User.class, (String)"User.type.type031", (String)"Type031")),
        TEMPORARY(900, I18N.getString(User.class, (String)"User.type.temporary", (String)"Temporary")),
        SYSTEM(999, I18N.getString(User.class, (String)"User.type.system", (String)"System"));

        private int vv = 0;
        private I18N.Text aa = null;

        private UserType(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean isDefault() {
            return this.equals((Object)TYPE_000);
        }

        public boolean isTemporary() {
            return this.equals((Object)TEMPORARY);
        }

        public boolean isSystem() {
            return this.equals((Object)SYSTEM);
        }

        public boolean isType(int type) {
            return this.getIntValue() == type;
        }
    }
}

