/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.util.Locale;
import org.opengts.db.DBConfig;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.util.I18N;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class UniqueXID
extends DBRecord<UniqueXID> {
    private static final String _TABLE_NAME = "UniqueXID";
    public static final String FLD_uniqueID = "uniqueID";
    public static final String FLD_accountID = "accountID";
    public static final String FLD_transportID = "transportID";
    private static DBField[] FieldInfo = new DBField[]{new DBField("uniqueID", String.class, DBField.TYPE_UNIQ_ID(), "Unique ID", "key=true"), new DBField("accountID", String.class, DBField.TYPE_ACCT_ID(), "Account ID", "edit=2"), new DBField("transportID", String.class, DBField.TYPE_XPORT_ID(), "Transport ID", "edit=2")};
    private static DBFactory<UniqueXID> factory = null;

    public static boolean isUniqueQueryEnabled() {
        return RTConfig.getBoolean((String)"UniqueXID.queryEnabled");
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<UniqueXID> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)UniqueXID.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, UniqueXID.class, Key.class, (boolean)false, (boolean)false);
        }
        return factory;
    }

    public UniqueXID() {
    }

    public UniqueXID(Key key) {
        super((DBRecordKey)key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(UniqueXID.class, (Locale)loc);
        return i18n.getString("UniqueXID.description", "This table defines system-wide mapping of Transport Unique-IDs to a specific Account/Transport.");
    }

    public String getUniqueID() {
        String v = (String)this.getFieldValue(FLD_uniqueID);
        return StringTools.trim((String)v);
    }

    private void setUniqueID(String v) {
        this.setFieldValue(FLD_uniqueID, StringTools.trim((String)v));
    }

    public String getAccountID() {
        String v = (String)this.getFieldValue(FLD_accountID);
        return StringTools.trim((String)v);
    }

    private void setAccountID(String v) {
        this.setFieldValue(FLD_accountID, StringTools.trim((String)v));
    }

    public String getTransportID() {
        String v = (String)this.getFieldValue(FLD_transportID);
        return StringTools.trim((String)v);
    }

    private void setTransportID(String v) {
        this.setFieldValue(FLD_transportID, StringTools.trim((String)v));
    }

    public void setCreationDefaultValues() {
    }

    public static UniqueXID getUniqueXID(String uniqueID) throws DBException {
        return UniqueXID.getUniqueXID(uniqueID, false);
    }

    public static UniqueXID getUniqueXID(String uniqueID, boolean create) throws DBException {
        if (uniqueID == null || uniqueID.equals("")) {
            return null;
        }
        Key key = new Key(uniqueID);
        if (key.exists()) {
            return (UniqueXID)key.getDBRecord(true);
        }
        if (create) {
            UniqueXID uniqXport = (UniqueXID)key.getDBRecord();
            uniqXport.setCreationDefaultValues();
            return uniqXport;
        }
        return null;
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
    }

    public static class Key
    extends DBRecordKey<UniqueXID> {
        public Key() {
        }

        public Key(String uniqueId) {
            super.setKeyValue(UniqueXID.FLD_uniqueID, (Object)(uniqueId != null ? uniqueId.toLowerCase() : ""));
        }

        public DBFactory<UniqueXID> getFactory() {
            return UniqueXID.getFactory();
        }
    }
}

