/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.UniqueXID;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.dbtypes.DTIPAddress;
import org.opengts.dbtypes.DTProfileMask;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Transport
extends AccountRecord<Transport>
implements DataTransport {
    public static final int SUPPORTED_ENCODING_BINARY = 1;
    public static final int SUPPORTED_ENCODING_BASE64 = 2;
    public static final int SUPPORTED_ENCODING_HEX = 4;
    public static final int SUPPORTED_ENCODING_CSV = 8;
    public static final String DEFAULT_XPORT_NAME = "New Data Transport";
    public static final int DEFAULT_ENCODING = 7;
    public static final int DEFAULT_UNIT_LIMIT_INTERVAL_MIN = 0;
    public static final int DEFAULT_MAX_ALLOWED_EVENTS = 0;
    public static final int DEFAULT_TOTAL_MAX_CONNECTIONS = 0;
    public static final int DEFAULT_TOTAL_MAX_CONNECTIONS_PER_MIN = 0;
    public static final int DEFAULT_DUPLEX_MAX_CONNECTIONS = 0;
    public static final int DEFAULT_DUPLEX_MAX_CONNECTIONS_PER_MIN = 0;
    public static final int PROP_COMM_MAX_CONNECTIONS = 62225;
    public static final String PROP_COMM_MAX_CONNECTIONS_STR = "com.maxconn";
    public static final int PROP_COMM_MIN_XMIT_DELAY = 62226;
    public static final String PROP_COMM_MIN_XMIT_DELAY_STR = "com.mindelay";
    public static final int PROP_COMM_MIN_XMIT_RATE = 62227;
    public static final String PROP_COMM_MIN_XMIT_RATE_STR = "com.minrate";
    public static final int PROP_COMM_MAX_XMIT_RATE = 62229;
    public static final String PROP_COMM_MAX_XMIT_RATE_STR = "com.maxrate";
    public static final int PROP_COMM_MAX_DUP_EVENTS = 62231;
    public static final String PROP_COMM_MAX_DUP_EVENTS_STR = "com.maxduplex";
    public static final int PROP_COMM_MAX_SIM_EVENTS = 62232;
    public static final String PROP_COMM_MAX_SIM_EVENTS_STR = "com.maxsimplex";
    public static final String _TABLE_NAME = "Transport";
    public static final String FLD_transportID = "transportID";
    public static final String FLD_uniqueID = "uniqueID";
    public static final String FLD_assocAccountID = "assocAccountID";
    public static final String FLD_assocDeviceID = "assocDeviceID";
    public static final String FLD_deviceCode = "deviceCode";
    public static final String FLD_deviceType = "deviceType";
    public static final String FLD_serialNumber = "serialNumber";
    public static final String FLD_simPhoneNumber = "simPhoneNumber";
    public static final String FLD_smsEmail = "smsEmail";
    public static final String FLD_imeiNumber = "imeiNumber";
    public static final String FLD_lastInputState = "lastInputState";
    public static final String FLD_lastOutputState = "lastOutputState";
    public static final String FLD_ignitionIndex = "ignitionIndex";
    public static final String FLD_codeVersion = "codeVersion";
    public static final String FLD_featureSet = "featureSet";
    public static final String FLD_ipAddressValid = "ipAddressValid";
    public static final String FLD_pendingPingCommand = "pendingPingCommand";
    public static final String FLD_lastPingTime = "lastPingTime";
    public static final String FLD_totalPingCount = "totalPingCount";
    public static final String FLD_maxPingCount = "maxPingCount";
    public static final String FLD_expectAck = "expectAck";
    public static final String FLD_lastAckCommand = "lastAckCommand";
    public static final String FLD_lastAckTime = "lastAckTime";
    public static final String FLD_supportsDMTP = "supportsDMTP";
    public static final String FLD_supportedEncodings = "supportedEncodings";
    public static final String FLD_unitLimitInterval = "unitLimitInterval";
    public static final String FLD_maxAllowedEvents = "maxAllowedEvents";
    public static final String FLD_totalProfileMask = "totalProfileMask";
    public static final String FLD_totalMaxConn = "totalMaxConn";
    public static final String FLD_totalMaxConnPerMin = "totalMaxConnPerMin";
    public static final String FLD_duplexProfileMask = "duplexProfileMask";
    public static final String FLD_duplexMaxConn = "duplexMaxConn";
    public static final String FLD_duplexMaxConnPerMin = "duplexMaxConnPerMin";
    public static final String FLD_ipAddressCurrent = "ipAddressCurrent";
    public static final String FLD_remotePortCurrent = "remotePortCurrent";
    public static final String FLD_listenPortCurrent = "listenPortCurrent";
    public static final String FLD_lastTotalConnectTime = "lastTotalConnectTime";
    public static final String FLD_lastDuplexConnectTime = "lastDuplexConnectTime";
    private static DBField[] FieldInfo = new DBField[]{Transport.newField_accountID(true), new DBField("transportID", String.class, DBField.TYPE_XPORT_ID(), "Transport ID", "key=true"), new DBField("assocAccountID", String.class, DBField.TYPE_ACCT_ID(), "Associated Account ID", "edit=2 altkey=device"), new DBField("assocDeviceID", String.class, DBField.TYPE_DEV_ID(), "Associated Device ID", "edit=2 altkey=device"), new DBField("uniqueID", String.class, DBField.TYPE_UNIQ_ID(), "Unique ID", "edit=2 altkey=altIndex"), new DBField("deviceCode", String.class, DBField.TYPE_STRING((int)24), "Device Code", "edit=2"), new DBField("deviceType", String.class, DBField.TYPE_STRING((int)24), "Device Type", "edit=2"), new DBField("serialNumber", String.class, DBField.TYPE_STRING((int)24), "Serial Number", "edit=2"), new DBField("simPhoneNumber", String.class, DBField.TYPE_STRING((int)24), "SIM Phone Number", "edit=2"), new DBField("smsEmail", String.class, DBField.TYPE_STRING((int)64), "SMS EMail Address", "edit=2"), new DBField("imeiNumber", String.class, DBField.TYPE_STRING((int)24), "IMEI Number", "edit=2"), new DBField("lastInputState", Long.TYPE, "UINT32", "Last Input State", ""), new DBField("lastOutputState", Long.TYPE, "UINT32", "Last Output State", ""), new DBField("ignitionIndex", Integer.TYPE, "UINT16", "Ignition I/O Index", "edit=2"), new DBField("codeVersion", String.class, DBField.TYPE_STRING((int)32), "Code Version", ""), new DBField("featureSet", String.class, DBField.TYPE_STRING((int)64), "Feature Set", ""), new DBField("ipAddressValid", DTIPAddrList.class, DBField.TYPE_STRING((int)128), "Valid IP Addresses", "edit=2"), new DBField("ipAddressCurrent", DTIPAddress.class, DBField.TYPE_STRING((int)32), "Current IP Address", ""), new DBField("remotePortCurrent", Integer.TYPE, "UINT16", "Current Remote Port", ""), new DBField("listenPortCurrent", Integer.TYPE, "UINT16", "Current Listen Port", ""), new DBField("pendingPingCommand", String.class, "TEXT", "Pending Ping Command", "edit=2"), new DBField("lastPingTime", Long.TYPE, "UINT32", "Last 'Ping' Time", "format=time"), new DBField("totalPingCount", Integer.TYPE, "UINT16", "Total 'Ping' Count", ""), new DBField("maxPingCount", Integer.TYPE, "UINT16", "Maximum 'Ping' Count", "edit=2"), new DBField("expectAck", Boolean.TYPE, "BOOLEAN", "Expecting an ACK", "edit=2"), new DBField("lastAckCommand", String.class, "TEXT", "Last Command Expecting an ACK", ""), new DBField("lastAckTime", Long.TYPE, "UINT32", "Last Received 'ACK' Time", "format=time"), new DBField("supportsDMTP", Boolean.TYPE, "BOOLEAN", "Supports DMTP", "edit=2"), new DBField("supportedEncodings", Integer.TYPE, "UINT8", "Supported Encodings", "edit=2 format=X1 editor=encodings mask=Transport$Encodings"), new DBField("unitLimitInterval", Integer.TYPE, "UINT16", "Accounting Time Interval Min", "edit=2"), new DBField("maxAllowedEvents", Integer.TYPE, "UINT16", "Max Events per Interval", "edit=2"), new DBField("totalProfileMask", DTProfileMask.class, "BLOB", "Total Profile Mask", ""), new DBField("totalMaxConn", Integer.TYPE, "UINT16", "Max Total Conn per Interval", "edit=2"), new DBField("totalMaxConnPerMin", Integer.TYPE, "UINT16", "Max Total Conn per Minute", "edit=2"), new DBField("duplexProfileMask", DTProfileMask.class, "BLOB", "Duplex Profile Mask", ""), new DBField("duplexMaxConn", Integer.TYPE, "UINT16", "Max Duplex Conn per Interval", "edit=2"), new DBField("duplexMaxConnPerMin", Integer.TYPE, "UINT16", "Max Duplex Conn per Minute", "edit=2"), new DBField("lastTotalConnectTime", Long.TYPE, "UINT32", "Last Total Connect Time", "format=time"), new DBField("lastDuplexConnectTime", Long.TYPE, "UINT32", "Last Duplex Connect Time", "format=time"), Transport.newField_displayName(), Transport.newField_description(), Transport.newField_lastUpdateTime(), Transport.newField_lastUpdateUser((boolean)true), Transport.newField_creationTime()};
    private static DBFactory<Transport> factory = null;
    private Account assocAccount = null;
    private Device assocDevice = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_TRANSPORT = new String[]{"transport", "xport"};
    private static final String[] ARG_UNIQID = new String[]{"uniqueid", "unique", "uid"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_EDITALL = new String[]{"editall", "eda"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_ORPHANS = new String[]{"orphan", "orphans"};

    public static boolean isTransportQueryEnabled() {
        return RTConfig.getBoolean((String)"Transport.queryEnabled");
    }

    public static boolean allowCreateDefaultTransport() {
        return false;
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Transport> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Transport.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Transport.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
        }
        return factory;
    }

    public Transport() {
    }

    public Transport(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Transport.class, (Locale)loc);
        return i18n.getString("Transport.description", "This table defines the data transport specific information for an Asset/Device.  A 'Transport' represents the datapath used to send data to a server.  In some cases a single 'Device' can have more than one such datapath to the server, such as a device that incorporates both GPRS and satellite communications.");
    }

    @Override
    public String getTransportID() {
        String v = (String)this.getFieldValue(FLD_transportID);
        return StringTools.trim((String)v);
    }

    private void setTransportID(String v) {
        this.setFieldValue(FLD_transportID, StringTools.trim((String)v));
    }

    @Override
    public String getUniqueID() {
        String v = (String)this.getFieldValue(FLD_uniqueID);
        return StringTools.trim((String)v);
    }

    public void setUniqueID(String v) {
        this.setFieldValue(FLD_uniqueID, StringTools.trim((String)v));
    }

    public String getTargetAccountID() {
        String assocAccountID = this.getAssocAccountID();
        if (!StringTools.isBlank((String)assocAccountID)) {
            return assocAccountID;
        }
        return this.getAccountID();
    }

    @Override
    public String getAssocAccountID() {
        String v = (String)this.getFieldValue(FLD_assocAccountID);
        return StringTools.trim((String)v);
    }

    public void setAssocAccountID(String v) {
        if ((v = StringTools.trim((String)v)).equals("") || v.equals(this.getAccountID())) {
            this.setFieldValue(FLD_assocAccountID, "");
        } else {
            this.setFieldValue(FLD_assocAccountID, v);
        }
    }

    public String getTargetDeviceID() {
        String assocDeviceID = this.getAssocDeviceID();
        if (!StringTools.isBlank((String)assocDeviceID)) {
            return assocDeviceID;
        }
        return this.getTransportID();
    }

    @Override
    public String getAssocDeviceID() {
        String v = (String)this.getFieldValue(FLD_assocDeviceID);
        return StringTools.trim((String)v);
    }

    public void setAssocDeviceID(String v) {
        if ((v = StringTools.trim((String)v)).equals("") || v.equals(this.getTransportID())) {
            this.setFieldValue(FLD_assocDeviceID, "");
        } else {
            this.setFieldValue(FLD_assocDeviceID, v);
        }
    }

    public boolean isAssocTargetDevice(Device device) {
        if (device == null) {
            return false;
        }
        return this.isAssocTargetDevice(device.getAccountID(), device.getDeviceID());
    }

    public boolean isAssocTargetDevice(String accountID, String deviceID) {
        if (StringTools.isBlank((String)accountID) || !this.getTargetAccountID().equalsIgnoreCase(accountID)) {
            return false;
        }
        return !StringTools.isBlank((String)deviceID) && this.getTargetDeviceID().equalsIgnoreCase(deviceID);
    }

    @Override
    public String getDeviceCode() {
        String v = (String)this.getFieldValue(FLD_deviceCode);
        return StringTools.trim((String)v);
    }

    @Override
    public void setDeviceCode(String v) {
        this.setFieldValue(FLD_deviceCode, StringTools.trim((String)v));
    }

    @Override
    public String getSerialNumber() {
        String v = (String)this.getFieldValue(FLD_serialNumber);
        return StringTools.trim((String)v);
    }

    @Override
    public void setSerialNumber(String v) {
        this.setFieldValue(FLD_serialNumber, StringTools.trim((String)v));
    }

    @Override
    public String getSimPhoneNumber() {
        String v = (String)this.getFieldValue(FLD_simPhoneNumber);
        return StringTools.trim((String)v);
    }

    @Override
    public void setSimPhoneNumber(String v) {
        this.setFieldValue(FLD_simPhoneNumber, StringTools.trim((String)v));
    }

    @Override
    public String getSmsEmail() {
        String v = (String)this.getFieldValue(FLD_smsEmail);
        return StringTools.trim((String)v);
    }

    @Override
    public void setSmsEmail(String v) {
        this.setFieldValue(FLD_smsEmail, StringTools.trim((String)v));
    }

    @Override
    public String getImeiNumber() {
        String v = (String)this.getFieldValue(FLD_imeiNumber);
        return StringTools.trim((String)v);
    }

    @Override
    public void setImeiNumber(String v) {
        this.setFieldValue(FLD_imeiNumber, StringTools.trim((String)v));
    }

    @Override
    public String getDeviceType() {
        String v = (String)this.getFieldValue(FLD_deviceType);
        return StringTools.trim((String)v);
    }

    @Override
    public void setDeviceType(String v) {
        this.setFieldValue(FLD_deviceType, StringTools.trim((String)v));
    }

    @Override
    public long getLastInputState() {
        Long v = (Long)this.getFieldValue(FLD_lastInputState);
        return v != null ? v : 0L;
    }

    @Override
    public void setLastInputState(long v) {
        this.setFieldValue(FLD_lastInputState, v & 0xFFFFFFFFL);
    }

    @Override
    public long getLastOutputState() {
        Long v = (Long)this.getFieldValue(FLD_lastOutputState);
        return v != null ? v : 0L;
    }

    @Override
    public void setLastOutputState(long v) {
        this.setFieldValue(FLD_lastOutputState, v & 0xFFFFFFFFL);
    }

    @Override
    public int getIgnitionIndex() {
        Integer v = (Integer)this.getFieldValue(FLD_ignitionIndex);
        return v != null ? v : -1;
    }

    @Override
    public void setIgnitionIndex(int v) {
        this.setFieldValue(FLD_ignitionIndex, v);
    }

    @Override
    public int[] getIgnitionStatusCodes() {
        int ndx = this.getIgnitionIndex();
        if (ndx >= 0) {
            int scOFF = StatusCodes.GetDigitalInputStatusCode(ndx, false);
            int scON = StatusCodes.GetDigitalInputStatusCode(ndx, true);
            if (scOFF != 0) {
                return new int[]{scOFF, scON};
            }
        }
        return null;
    }

    @Override
    public String getCodeVersion() {
        String v = (String)this.getFieldValue(FLD_codeVersion);
        return StringTools.trim((String)v);
    }

    @Override
    public void setCodeVersion(String v) {
        this.setFieldValue(FLD_codeVersion, StringTools.trim((String)v));
    }

    @Override
    public String getFeatureSet() {
        String v = (String)this.getFieldValue(FLD_featureSet);
        return StringTools.trim((String)v);
    }

    @Override
    public void setFeatureSet(String v) {
        this.setFieldValue(FLD_featureSet, StringTools.trim((String)v));
    }

    @Override
    public DTIPAddrList getIpAddressValid() {
        DTIPAddrList v = (DTIPAddrList)((Object)this.getFieldValue(FLD_ipAddressValid));
        return v;
    }

    @Override
    public void setIpAddressValid(DTIPAddrList v) {
        this.setFieldValue(FLD_ipAddressValid, (Object)v);
    }

    public void setIpAddressValid(String v) {
        this.setIpAddressValid(v != null ? new DTIPAddrList(v) : null);
    }

    @Override
    public boolean isValidIPAddress(String ipAddr) {
        DTIPAddrList ipList = this.getIpAddressValid();
        if (ipList == null || ipList.isEmpty()) {
            return true;
        }
        return ipList.isMatch(ipAddr);
    }

    @Override
    public DTIPAddress getIpAddressCurrent() {
        DTIPAddress v = (DTIPAddress)((Object)this.getFieldValue(FLD_ipAddressCurrent));
        return v;
    }

    public void setIpAddressCurrent(DTIPAddress v) {
        this.setFieldValue(FLD_ipAddressCurrent, (Object)v);
    }

    @Override
    public void setIpAddressCurrent(String v) {
        this.setIpAddressCurrent(v != null ? new DTIPAddress(v) : null);
    }

    @Override
    public int getRemotePortCurrent() {
        Integer v = (Integer)this.getFieldValue(FLD_remotePortCurrent);
        return v != null ? v : 0;
    }

    @Override
    public void setRemotePortCurrent(int v) {
        this.setFieldValue(FLD_remotePortCurrent, v > 0 ? v : 0);
    }

    @Override
    public int getListenPortCurrent() {
        Integer v = (Integer)this.getFieldValue(FLD_listenPortCurrent);
        return v != null ? v : 0;
    }

    @Override
    public void setListenPortCurrent(int v) {
        this.setFieldValue(FLD_listenPortCurrent, v > 0 ? v : 0);
    }

    public String getPendingPingCommand() {
        String v = (String)this.getFieldValue(FLD_pendingPingCommand);
        return StringTools.trim((String)v);
    }

    public void setPendingPingCommand(String v) {
        this.setFieldValue(FLD_pendingPingCommand, StringTools.trim((String)v));
    }

    @Override
    public long getLastPingTime() {
        Long v = (Long)this.getFieldValue(FLD_lastPingTime);
        return v != null ? v : 0L;
    }

    public void _setLastPingTime(long v) {
        this.setFieldValue(FLD_lastPingTime, v);
    }

    public void setLastPingTime(long v) {
        this._setLastPingTime(v);
        if (this.assocDevice != null) {
            this.assocDevice._setLastPingTime(v);
        }
    }

    @Override
    public int getTotalPingCount() {
        Integer v = (Integer)this.getFieldValue(FLD_totalPingCount);
        return v != null ? v : 0;
    }

    public void _setTotalPingCount(int v) {
        this.setFieldValue(FLD_totalPingCount, v);
    }

    public void setTotalPingCount(int v) {
        this._setTotalPingCount(v);
        if (this.assocDevice != null) {
            this.assocDevice._setLastPingTime(v);
        }
    }

    @Override
    public int getMaxPingCount() {
        Integer v = (Integer)this.getFieldValue(FLD_maxPingCount);
        return v != null ? v : 0;
    }

    public void _setMaxPingCount(int v) {
        this.setFieldValue(FLD_maxPingCount, v);
    }

    public void setMaxPingCount(int v) {
        this._setMaxPingCount(v);
        if (this.assocDevice != null) {
            this.assocDevice._setMaxPingCount(v);
        }
    }

    public boolean getExpectAck() {
        Boolean v = (Boolean)this.getFieldValue(FLD_expectAck);
        return v != null ? v : true;
    }

    public void _setExpectAck(boolean v) {
        this.setFieldValue(FLD_expectAck, v);
    }

    public void setExpectAck(boolean v) {
        this._setExpectAck(v);
        if (this.assocDevice != null) {
            this.assocDevice._setExpectAck(v);
        }
    }

    public String getLastAckCommand() {
        String v = (String)this.getFieldValue(FLD_lastAckCommand);
        return StringTools.trim((String)v);
    }

    public void setLastAckCommand(String v) {
        this.setFieldValue(FLD_lastAckCommand, StringTools.trim((String)v));
    }

    public boolean isExpectingCommandAck() {
        return this.getExpectAck() && this.getLastAckTime() <= 0L;
    }

    public long getLastAckTime() {
        Long v = (Long)this.getFieldValue(FLD_lastAckTime);
        return v != null ? v : 0L;
    }

    public void _setLastAckTime(long v) {
        this.setFieldValue(FLD_lastAckTime, v);
    }

    public void setLastAckTime(long v) {
        this._setLastAckTime(v);
        if (this.assocDevice != null) {
            this.assocDevice._setLastAckTime(v);
        }
    }

    @Override
    public boolean getSupportsDMTP() {
        Boolean v = (Boolean)this.getFieldValue(FLD_supportsDMTP);
        return v != null ? v : true;
    }

    @Override
    public void setSupportsDMTP(boolean v) {
        this.setFieldValue(FLD_supportsDMTP, v);
    }

    public boolean supportsDMTP() {
        return this.getSupportsDMTP();
    }

    @Override
    public int getSupportedEncodings() {
        Integer v = (Integer)this.getFieldValue(FLD_supportedEncodings);
        return v != null ? v : (int)Encodings.BINARY.getLongValue();
    }

    @Override
    public void setSupportedEncodings(int v) {
        if ((v &= (int)EnumTools.getValueMask(Encodings.class)) == 0) {
            v = (int)Encodings.BINARY.getLongValue();
        }
        this.setFieldValue(FLD_supportedEncodings, v);
    }

    @Override
    public int getUnitLimitInterval() {
        Integer v = (Integer)this.getFieldValue(FLD_unitLimitInterval);
        return v != null ? v : 0;
    }

    public void setUnitLimitInterval(int v) {
        this.setFieldValue(FLD_unitLimitInterval, v);
    }

    @Override
    public int getMaxAllowedEvents() {
        Integer v = (Integer)this.getFieldValue(FLD_maxAllowedEvents);
        return v != null ? v : 1;
    }

    public void setMaxAllowedEvents(int max) {
        this.setFieldValue(FLD_maxAllowedEvents, max);
    }

    @Override
    public DTProfileMask getTotalProfileMask() {
        DTProfileMask v = (DTProfileMask)((Object)this.getFieldValue(FLD_totalProfileMask));
        return v;
    }

    @Override
    public void setTotalProfileMask(DTProfileMask v) {
        this.setFieldValue(FLD_totalProfileMask, (Object)v);
    }

    @Override
    public int getTotalMaxConn() {
        Integer v = (Integer)this.getFieldValue(FLD_totalMaxConn);
        return v != null ? v : 0;
    }

    public void setTotalMaxConn(int v) {
        this.setFieldValue(FLD_totalMaxConn, v);
    }

    @Override
    public int getTotalMaxConnPerMin() {
        Integer v = (Integer)this.getFieldValue(FLD_totalMaxConnPerMin);
        return v != null ? v : 0;
    }

    public void setTotalMaxConnPerMin(int v) {
        this.setFieldValue(FLD_totalMaxConnPerMin, v);
    }

    @Override
    public DTProfileMask getDuplexProfileMask() {
        DTProfileMask v = (DTProfileMask)((Object)this.getFieldValue(FLD_duplexProfileMask));
        return v;
    }

    @Override
    public void setDuplexProfileMask(DTProfileMask v) {
        this.setFieldValue(FLD_duplexProfileMask, (Object)v);
    }

    @Override
    public int getDuplexMaxConn() {
        Integer v = (Integer)this.getFieldValue(FLD_duplexMaxConn);
        return v != null ? v : 0;
    }

    public void setDuplexMaxConn(int max) {
        this.setFieldValue(FLD_duplexMaxConn, max);
    }

    @Override
    public int getDuplexMaxConnPerMin() {
        Integer v = (Integer)this.getFieldValue(FLD_duplexMaxConnPerMin);
        return v != null ? v : 0;
    }

    public void setDuplexMaxConnPerMin(int max) {
        this.setFieldValue(FLD_duplexMaxConnPerMin, max);
    }

    @Override
    public long getLastTotalConnectTime() {
        Long v = (Long)this.getFieldValue(FLD_lastTotalConnectTime);
        return v != null ? v : 0L;
    }

    public void _setLastTotalConnectTime(long v) {
        this.setFieldValue(FLD_lastTotalConnectTime, v);
    }

    @Override
    public void setLastTotalConnectTime(long v) {
        this._setLastTotalConnectTime(v);
        if (this.assocDevice != null) {
            this.assocDevice._setLastTotalConnectTime(v);
        }
    }

    @Override
    public long getLastDuplexConnectTime() {
        Long v = (Long)this.getFieldValue(FLD_lastDuplexConnectTime);
        return v != null ? v : 0L;
    }

    public void _setLastDuplexConnectTime(long v) {
        this.setFieldValue(FLD_lastDuplexConnectTime, v);
    }

    @Override
    public void setLastDuplexConnectTime(long v) {
        this._setLastDuplexConnectTime(v);
        if (this.assocDevice != null) {
            this.assocDevice._setLastDuplexConnectTime(v);
        }
    }

    public void setCreationDefaultValues() {
        this.setDescription(DEFAULT_XPORT_NAME);
        this.setSupportedEncodings(7);
        this.setTotalMaxConn(0);
        this.setDuplexMaxConn(0);
        this.setUnitLimitInterval(0);
        this.setTotalMaxConnPerMin(0);
        this.setDuplexMaxConnPerMin(0);
        this.setMaxAllowedEvents(0);
        super.setRuntimeDefaultValues();
    }

    protected Account getAssocAccount() {
        if (this.assocAccount == null) {
            String acctID = this.getAssocAccountID();
            if (StringTools.isBlank((String)acctID) || acctID.equals(this.getAccountID())) {
                this.assocAccount = this.getAccount();
            } else {
                try {
                    this.assocAccount = Account.getAccount(acctID);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Associated Account not found: " + acctID), (Object[])new Object[0]);
                    this.assocAccount = null;
                }
            }
        }
        return this.assocAccount;
    }

    public Device getAssocDevice() {
        if (this.assocDevice == null) {
            String devID = this.getAssocDeviceID();
            try {
                if (!StringTools.isBlank((String)devID)) {
                    this.assocDevice = Device.getDevice(this.getAssocAccount(), devID);
                    if (this.assocDevice != null) {
                        this.assocDevice.setTransport(this);
                    } else {
                        Print.logError((String)("**** Transport Device not found: " + this + " ==> " + devID), (Object[])new Object[0]);
                    }
                } else {
                    devID = this.getTransportID();
                    this.assocDevice = Device.getDevice(this.getAssocAccount(), devID);
                    if (this.assocDevice != null) {
                        Print.logWarn((String)("TransportID used for DeviceID: " + devID), (Object[])new Object[0]);
                        this.assocDevice.setTransport(this);
                    } else {
                        Print.logWarn((String)("**** Device not defined for Transport: " + this.getAccountID() + "/" + this.getTransportID()), (Object[])new Object[0]);
                    }
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("**** Error reading Device for Transport: " + this.getAccountID() + "/" + this.getTransportID() + "/" + devID), (Object[])new Object[0]);
                this.assocDevice = null;
            }
        }
        return this.assocDevice;
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getTransportID();
    }

    public static boolean exists(String acctID, String xportID) throws DBException {
        if (acctID != null && xportID != null) {
            Key xportKey = new Key(acctID, xportID);
            return xportKey.exists();
        }
        return false;
    }

    public static boolean exists(String uniqID) throws DBException {
        if (!StringTools.isBlank((String)uniqID)) {
            Transport xport = Transport.getTransportByUniqueID(uniqID);
            return xport != null;
        }
        return false;
    }

    public static boolean exists(String[] prefix, String mobileID) throws DBException {
        if (StringTools.isBlank((String)mobileID)) {
            return false;
        }
        if (ListTools.isEmpty((Object[])prefix)) {
            return Transport.exists(mobileID);
        }
        for (int i = 0; i < prefix.length; ++i) {
            String uniqueID = prefix[i] + mobileID;
            if (!Transport.exists(uniqueID)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Transport getTransportByUniqueID(String uniqId) throws DBException {
        Statement stmt;
        DBConnection dbc;
        Transport xport;
        block18: {
            if (StringTools.isBlank((String)uniqId)) {
                return null;
            }
            xport = null;
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(Transport.getFactory());
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.EQ(FLD_uniqueID, (Object)uniqId)));
                dsel.setLimit(2L);
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                if (rs.next()) {
                    String acctId = rs.getString("accountID");
                    String xportId = rs.getString(FLD_transportID);
                    xport = new Transport(new Key(acctId, xportId));
                    xport.setAllFieldValues(rs);
                    if (rs.next()) {
                        Print.logError((String)("Found multiple occurances of this unique-id: " + uniqId), (Object[])new Object[0]);
                    }
                }
                if (rs == null) break block18;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting Transport for UniqueID", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return xport;
    }

    public static Transport getTransport(Account account, String xportID) throws DBException {
        if (account != null && xportID != null) {
            String acctID = account.getAccountID();
            Key key = new Key(acctID, xportID);
            if (key.exists()) {
                Transport xport = (Transport)key.getDBRecord(true);
                xport.setAccount(account);
                return xport;
            }
            return null;
        }
        return null;
    }

    public static Transport getTransport(Account account, String xportID, boolean create) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String acctID = account.getAccountID();
        if (StringTools.isBlank((String)xportID)) {
            throw new DBNotFoundException("Transport-ID not specified for account: " + acctID);
        }
        Transport xport = null;
        Key xportKey = new Key(acctID, xportID);
        if (!xportKey.exists()) {
            if (create) {
                xport = (Transport)xportKey.getDBRecord();
                xport.setAccount(account);
                xport.setCreationDefaultValues();
                return xport;
            }
            throw new DBNotFoundException("Transport-ID does not exists: " + (Object)((Object)xportKey));
        }
        if (create) {
            throw new DBAlreadyExistsException("Transport-ID already exists '" + (Object)((Object)xportKey) + "'");
        }
        xport = Transport.getTransport(account, xportID);
        if (xport == null) {
            throw new DBException("Unable to read existing Transport: " + (Object)((Object)xportKey));
        }
        return xport;
    }

    public static Transport createNewTransport(Account account, String xportID, String uniqueID) throws DBException {
        if (account != null && xportID != null && !xportID.equals("")) {
            Transport xport = Transport.getTransport(account, xportID, true);
            if (uniqueID != null && !uniqueID.equals("")) {
                xport.setUniqueID(uniqueID);
            }
            xport.save();
            return xport;
        }
        throw new DBException("Invalid Account/TransportID specified");
    }

    public static Transport createNewTransport(Device device) throws DBException {
        if (device == null) {
            throw new DBNotFoundException("Invalid Device specified");
        }
        DataTransport dt = device.getDataTransport();
        if (dt instanceof Transport) {
            throw new DBAlreadyExistsException("Device already has a defined Transport");
        }
        Account account = device.getAccount();
        String xportID = device.getDeviceID();
        Transport xport = Transport.getTransport(account, xportID, true);
        xport.setUniqueID(dt.getUniqueID());
        xport.setAssocAccountID(dt.getAssocAccountID());
        xport.setAssocDeviceID(dt.getAssocDeviceID());
        xport.setDescription(dt.getDescription());
        xport.setDeviceCode(dt.getDeviceCode());
        xport.setSerialNumber(dt.getSerialNumber());
        xport.setSimPhoneNumber(dt.getSimPhoneNumber());
        xport.setImeiNumber(dt.getImeiNumber());
        xport.setDeviceType(dt.getDeviceType());
        xport.setLastInputState(dt.getLastInputState());
        xport.setLastOutputState(dt.getLastOutputState());
        xport.setCodeVersion(dt.getCodeVersion());
        xport.setFeatureSet(dt.getFeatureSet());
        xport.setIpAddressValid(dt.getIpAddressValid());
        xport.setIpAddressCurrent(dt.getIpAddressCurrent());
        xport.setSupportsDMTP(dt.getSupportsDMTP());
        xport.setSupportedEncodings(dt.getSupportedEncodings());
        xport.setUnitLimitInterval(dt.getUnitLimitInterval());
        xport.setMaxAllowedEvents(dt.getMaxAllowedEvents());
        xport.setTotalProfileMask(dt.getTotalProfileMask());
        xport.setTotalMaxConn(dt.getTotalMaxConn());
        xport.setTotalMaxConnPerMin(dt.getTotalMaxConnPerMin());
        xport.setDuplexProfileMask(dt.getDuplexProfileMask());
        xport.setDuplexMaxConn(dt.getDuplexMaxConn());
        xport.setDuplexMaxConnPerMin(dt.getDuplexMaxConnPerMin());
        xport.setLastTotalConnectTime(dt.getLastTotalConnectTime());
        xport.setLastDuplexConnectTime(dt.getLastDuplexConnectTime());
        xport.save();
        device.setTransport(xport);
        return xport;
    }

    public static String[] getTransportsForAccount(String acctId) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            Print.logError((String)"Account not specified!", (Object[])new Object[0]);
            return new String[0];
        }
        DBSelect dsel = new DBSelect(Transport.getFactory());
        dsel.setSelectedFields(new String[]{FLD_transportID});
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE(dwh.EQ("accountID", (Object)acctId)));
        dsel.setOrderByFields(new String[]{FLD_transportID});
        return Transport.getTransports((DBSelect<Transport>)dsel);
    }

    public static String[] getTransports(DBSelect<Transport> dsel) throws DBException {
        if (dsel == null) {
            return new String[0];
        }
        Vector<String> xportList = new Vector<String>();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String xportId = rs.getString(FLD_transportID);
                xportList.add(xportId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting Account Transport List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return xportList.toArray(new String[xportList.size()]);
    }

    public static Device loadDeviceUniqueID(String[] prefix, String modemID) {
        Device device = null;
        String uniqueID = "";
        try {
            if (ListTools.isEmpty((Object[])prefix)) {
                uniqueID = modemID;
                device = Transport.loadDeviceByUniqueID(uniqueID);
            } else {
                uniqueID = prefix[0] + modemID;
                for (int u = 0; u < prefix.length; ++u) {
                    String pfxid = prefix[u] + modemID;
                    device = Transport.loadDeviceByUniqueID(pfxid);
                    if (device == null) continue;
                    uniqueID = pfxid;
                    break;
                }
            }
            if (device == null) {
                Print.logWarn((String)("!!!UniqueID not found!: " + uniqueID), (Object[])new Object[0]);
                return null;
            }
            if (!device.getAccount().isActive() || !device.isActive()) {
                String a = device.getAccountID();
                String d = device.getDeviceID();
                Print.logWarn((String)("Account/Device is inactive: " + a + "/" + d + " [" + uniqueID + "]"), (Object[])new Object[0]);
                return null;
            }
            device.setModemID(modemID);
            return device;
        }
        catch (Throwable dbe) {
            Print.logError((String)("Exception getting Device: " + uniqueID + " [" + dbe + "]"), (Object[])new Object[0]);
            return null;
        }
    }

    public static Device loadDeviceByUniqueID(String uniqId) throws DBException {
        Device device;
        block12: {
            if (StringTools.isBlank((String)uniqId)) {
                Print.logError((String)"Unique-ID is null!", (Object[])new Object[0]);
                return null;
            }
            if (UniqueXID.isUniqueQueryEnabled()) {
                UniqueXID uniqXp = null;
                try {
                    uniqXp = UniqueXID.getUniqueXID(uniqId);
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                if (uniqXp != null) {
                    String a = uniqXp.getAccountID();
                    String t = uniqXp.getTransportID();
                    Print.logDebug((String)("Located Transport '" + a + "/" + t + "' via UniqueXID '" + (Object)((Object)uniqXp) + "'"), (Object[])new Object[0]);
                    return Transport.loadDeviceByTransportID(a, t);
                }
            }
            if (Transport.isTransportQueryEnabled()) {
                try {
                    Transport xport = Transport.getTransportByUniqueID(uniqId);
                    if (xport == null) break block12;
                    Print.logDebug((String)("Located Transport '" + xport + "' via UniqueID '" + uniqId + "'"), (Object[])new Object[0]);
                    try {
                        xport.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
                        xport.update(new String[]{FLD_lastTotalConnectTime});
                    }
                    catch (DBException dbe) {
                        Print.logError((String)("Error updating connect time: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                    }
                    Device dev = xport.getAssocDevice();
                    if (dev != null) {
                        Print.logDebug((String)("Located Device '" + dev + "' (via Transport '" + xport + "')"), (Object[])new Object[0]);
                        return dev;
                    }
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
        }
        if ((device = Device.loadDeviceByUniqueID(uniqId)) != null) {
            Print.logDebug((String)("Located Device '" + device + "' (via Device record)"), (Object[])new Object[0]);
            return device;
        }
        return null;
    }

    public static Device loadDeviceByUniqueID(byte[] uniqID) throws DBException {
        if (uniqID != null) {
            Device dev;
            if (StringTools.isPrintableASCII((byte[])uniqID, (boolean)false) && (dev = Transport.loadDeviceByUniqueID(StringTools.toStringValue((byte[])uniqID))) != null) {
                return dev;
            }
            String hexId = StringTools.toHexString((byte[])uniqID);
            return Transport.loadDeviceByUniqueID(hexId);
        }
        return null;
    }

    public static Device loadDeviceByTransportID(String accountID, String xportID) throws DBException {
        if (accountID == null) {
            Print.logError((String)"Account-ID is null!", (Object[])new Object[0]);
            return null;
        }
        if (xportID == null) {
            Print.logError((String)"Device/Transport-ID is null!", (Object[])new Object[0]);
            return null;
        }
        Account account = Account.getAccount(accountID);
        if (account == null) {
            Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
            return null;
        }
        return Transport.loadDeviceByTransportID(account, xportID);
    }

    public static Device loadDeviceByTransportID(Account account, String xportID) throws DBException {
        Device dev;
        if (account == null) {
            Print.logError((String)"Account is null (not found/defined?)!", (Object[])new Object[0]);
            return null;
        }
        if (xportID == null) {
            Print.logError((String)"Device/Transport-ID is null!", (Object[])new Object[0]);
            return null;
        }
        if (Transport.isTransportQueryEnabled()) {
            try {
                Device dev2;
                Transport xport = Transport.getTransport(account, xportID);
                if (xport != null && (dev2 = xport.getAssocDevice()) != null) {
                    Print.logInfo((String)("Located Device '" + dev2 + "' via Transport '" + xport + "'"), (Object[])new Object[0]);
                    return dev2;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if ((dev = Device.loadDeviceByName(account, xportID)) != null) {
            Print.logInfo((String)("Located Device '" + dev + "' (using default Device transport)"), (Object[])new Object[0]);
            return dev;
        }
        if (account.getAutoAddDevices() && (dev = Device.getDevice(account, xportID, true)) != null) {
            dev.setDescription(account.getNewDeviceDescription(null, "!" + xportID));
            dev.save();
            Print.logInfo((String)("Created new Device '" + dev + "'"), (Object[])new Object[0]);
            return dev;
        }
        Print.logWarn((String)("Device not found: " + account.getAccountID() + "/" + xportID), (Object[])new Object[0]);
        return null;
    }

    public static String getSuggestedDMTPConnectionAttribute(int prop, DataTransport dt) {
        switch (prop) {
            case 62225: {
                int totmax = dt.getTotalMaxConn();
                int dupmax = dt.getDuplexMaxConn();
                int interv = dt.getUnitLimitInterval();
                return "com.maxconn=" + totmax + "," + dupmax + "," + interv;
            }
            case 62226: {
                int interv = (int)DateTime.MinuteSeconds((long)dt.getUnitLimitInterval());
                int dupmax = dt.getDuplexMaxConn();
                int delmin = (int)Math.round((double)interv / (double)dupmax);
                if (delmin < 60) {
                    delmin = 60;
                }
                return "com.mindelay=" + delmin;
            }
            case 62227: {
                int maxTotalConnPerMin = dt.getTotalMaxConnPerMin();
                int maxDuplexConnPerMin = dt.getDuplexMaxConnPerMin();
                int totminrate = (int)Math.round(60.0 / (double)maxTotalConnPerMin);
                int dupminrate = (int)Math.round(60.0 / (double)maxDuplexConnPerMin);
                int minrate = dupminrate > totminrate ? dupminrate : totminrate;
                return "com.minrate=" + minrate;
            }
            case 62229: {
                return "com.maxrate=3600";
            }
            case 62231: {
                return "com.maxduplex=10";
            }
            case 62232: {
                return "com.maxsimplex=2";
            }
        }
        return "";
    }

    private static String _fmtXPortID(String acctID, String xportID) {
        return acctID + "/" + xportID;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + Transport.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Acount ID which owns the Transport", (Object[])new Object[0]);
        Print.logInfo((String)"  -transport=<id> Transport ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -uniqueid=<id>  Unique ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>    Device ID from which the Transport is created", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new Transport", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit[all]      Edit an existing (or newly created) Transport", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified Transport", (Object[])new Object[0]);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        int opts;
        block67: {
            block68: {
                ResultSet rs;
                Statement stmt;
                DBConnection dbc;
                block64: {
                    boolean xportExists;
                    Account acct;
                    String xportID;
                    String acctID;
                    block63: {
                        DBConfig.cmdLineInit(args, true);
                        acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
                        xportID = RTConfig.getString((String[])ARG_TRANSPORT, (String)"");
                        String uniqID = RTConfig.getString((String[])ARG_UNIQID, (String)"");
                        String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
                        if (StringTools.isBlank((String)acctID)) {
                            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
                            Transport.usage();
                        }
                        acct = null;
                        try {
                            acct = Account.getAccount(acctID);
                            if (acct == null) {
                                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                                Transport.usage();
                            }
                        }
                        catch (DBException dbe) {
                            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
                            System.exit(99);
                        }
                        xportExists = false;
                        try {
                            xportExists = StringTools.isBlank((String)xportID) ? false : Transport.exists(acctID, xportID);
                        }
                        catch (DBException dbe) {
                            Print.logError((String)("Error determining if Transport exists: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                            System.exit(99);
                        }
                        opts = 0;
                        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !StringTools.isBlank((String)acctID) && !StringTools.isBlank((String)xportID)) {
                            ++opts;
                            if (!xportExists) {
                                Print.logWarn((String)("Transport does not exist: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
                            }
                            try {
                                Key xportKey = new Key(acctID, xportID);
                                xportKey.delete(true);
                                Print.logInfo((String)("Transport deleted: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                                xportExists = false;
                            }
                            catch (DBException dbe) {
                                Print.logError((String)("Error deleting Transport: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                                dbe.printException();
                                System.exit(99);
                            }
                            System.exit(0);
                        }
                        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
                            ++opts;
                            if (xportExists) {
                                Print.logWarn((String)("Transport already exists: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                            } else if (!StringTools.isBlank((String)devID)) {
                                if (!StringTools.isBlank((String)xportID)) {
                                    Print.logError((String)"Transport-ID must not be specified when Device-ID is specified.", (Object[])new Object[0]);
                                } else {
                                    try {
                                        Device dev = Device.getDevice(acct, devID);
                                        if (dev != null) {
                                            Transport.createNewTransport(dev);
                                            Print.logInfo((String)("Created Transport (from device): " + Transport._fmtXPortID(acctID, devID)), (Object[])new Object[0]);
                                            xportExists = true;
                                            break block63;
                                        }
                                        Print.logError((String)("Device-ID does not exist: " + devID), (Object[])new Object[0]);
                                        System.exit(99);
                                    }
                                    catch (DBException dbe) {
                                        Print.logError((String)("Error creating Transport: " + Transport._fmtXPortID(acctID, devID)), (Object[])new Object[0]);
                                        dbe.printException();
                                        System.exit(99);
                                    }
                                }
                            } else if (StringTools.isBlank((String)xportID)) {
                                Print.logError((String)"Transport-ID not specified.", (Object[])new Object[0]);
                            } else {
                                try {
                                    Transport.createNewTransport(acct, xportID, uniqID);
                                    Print.logInfo((String)("Created Transport: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                                    xportExists = true;
                                }
                                catch (DBException dbe) {
                                    Print.logError((String)("Error creating Transport: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                                    dbe.printException();
                                    System.exit(99);
                                }
                            }
                        }
                    }
                    if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false) || RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false)) {
                        ++opts;
                        if (!xportExists) {
                            Print.logError((String)("Transport does not exist: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                        } else {
                            try {
                                boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                                Transport transport = Transport.getTransport(acct, xportID, false);
                                DBEdit editor = new DBEdit((DBRecord)transport);
                                editor.edit(allFlds);
                            }
                            catch (IOException ioe) {
                                if (ioe instanceof EOFException) {
                                    Print.logError((String)"End of input", (Object[])new Object[0]);
                                } else {
                                    Print.logError((String)"IO Error", (Object[])new Object[0]);
                                }
                            }
                            catch (DBException dbe) {
                                Print.logError((String)("Error editing Transport: " + Transport._fmtXPortID(acctID, xportID)), (Object[])new Object[0]);
                                dbe.printException();
                            }
                        }
                        System.exit(0);
                    }
                    if (!RTConfig.getBoolean((String[])ARG_ORPHANS, (boolean)false)) break block67;
                    ++opts;
                    DBSelect dsel = new DBSelect(Transport.getFactory());
                    DBWhere dwh = dsel.createDBWhere();
                    dsel.setWhere(dwh.WHERE_(dwh.EQ("accountID", (Object)acctID)));
                    dbc = null;
                    stmt = null;
                    rs = null;
                    long rcdCount = 0L;
                    long orphanCount = 0L;
                    Print.sysPrintln((String)"Listing orphaned Transport records:", (Object[])new Object[0]);
                    dbc = DBConnection.getDefaultConnection();
                    stmt = dbc.execute(dsel.toString());
                    rs = stmt.getResultSet();
                    while (rs.next()) {
                        String deviceID;
                        ++rcdCount;
                        String transportID = rs.getString(FLD_transportID);
                        String uniqueID = rs.getString(FLD_uniqueID);
                        String assocAcctID = rs.getString(FLD_assocAccountID);
                        String assocDevID = rs.getString(FLD_assocDeviceID);
                        if (StringTools.isBlank((String)assocAcctID) || assocAcctID.equalsIgnoreCase(acctID)) {
                            assocAcctID = null;
                        }
                        if (StringTools.isBlank((String)assocDevID) || assocDevID.equalsIgnoreCase(transportID)) {
                            assocDevID = null;
                        }
                        boolean isAssoc = StringTools.isBlank((String)assocAcctID) || StringTools.isBlank((String)assocDevID);
                        String accountID = !StringTools.isBlank((String)assocAcctID) ? assocAcctID : acctID;
                        if (Device.exists(accountID, deviceID = !StringTools.isBlank((String)assocDevID) ? assocDevID : transportID)) continue;
                        Print.sysPrintln((String)("   Device does not exist [" + transportID + "]: " + accountID + "/" + deviceID), (Object[])new Object[0]);
                        ++orphanCount;
                    }
                    Print.sysPrintln((String)"   Found %d orphaned records [out of %d]", (Object[])new Object[]{orphanCount, rcdCount});
                    if (rs == null) break block64;
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                DBConnection.release((DBConnection)dbc);
                break block68;
                catch (SQLException sqe) {
                    block65: {
                        Print.logException((String)"Error checking orphaned TransportIDs", (Throwable)sqe);
                        if (rs == null) break block65;
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release((DBConnection)dbc);
                }
                catch (DBException dbe) {
                    block66: {
                        Print.logException((String)"Error checking orphaned TransportIDs", (Throwable)dbe);
                        if (rs == null) break block66;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                }
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                }
                                DBConnection.release(dbc);
                                throw throwable;
                            }
                        }
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release((DBConnection)dbc);
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            Transport.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<Transport> {
        public Key() {
        }

        public Key(String acctId, String xportId) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue(Transport.FLD_transportID, (Object)(xportId != null ? xportId.toLowerCase() : ""));
        }

        public DBFactory<Transport> getFactory() {
            return Transport.getFactory();
        }
    }

    public static enum Encodings implements EnumTools.BitMask,
    EnumTools.StringLocale
    {
        NONE(0L, I18N.getString(Transport.class, (String)"Transport.encoding.none", (String)"None")),
        BINARY(1L, I18N.getString(Transport.class, (String)"Transport.encoding.binary", (String)"Binary")),
        BASE64(2L, I18N.getString(Transport.class, (String)"Transport.encoding.base64", (String)"Base64")),
        HEX(4L, I18N.getString(Transport.class, (String)"Transport.encoding.hex", (String)"Hex"));

        private long vv = 0L;
        private I18N.Text aa = null;

        private Encodings(long v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public long getLongValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }
    }
}

