/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.util.Locale;
import org.opengts.Version;
import org.opengts.db.DBConfig;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.util.I18N;
import org.opengts.util.MethodAction;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class SystemProps
extends DBRecord<SystemProps> {
    public static final String GTS_VERSION = "version.gts";
    public static final String DMTP_VERSION = "version.dmtp";
    private static final String _TABLE_NAME = "SystemProps";
    public static final String FLD_propertyID = "propertyID";
    public static final String FLD_value = "value";
    public static final String FLD_systemKey = "hexValue";
    private static DBField[] FieldInfo = new DBField[]{new DBField("propertyID", String.class, DBField.TYPE_PROP_ID(), "Property ID", "key=true"), new DBField("hexValue", String.class, "TEXT", "System Key", "edit=2 utf8=true"), new DBField("value", String.class, "TEXT", "Value", "edit=2 utf8=true"), SystemProps.newField_description(), SystemProps.newField_lastUpdateTime(), SystemProps.newField_lastUpdateUser((boolean)true), SystemProps.newField_creationTime()};
    private static DBFactory<SystemProps> factory = null;

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<SystemProps> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)SystemProps.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, SystemProps.class, Key.class, (boolean)false, (boolean)false);
        }
        return factory;
    }

    public SystemProps() {
    }

    public SystemProps(Key key) {
        super((DBRecordKey)key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(SystemProps.class, (Locale)loc);
        return i18n.getString("SystemProps.description", "This table defines system-wide installation property key/values.");
    }

    public String getPropertyID() {
        String v = (String)this.getFieldValue(FLD_propertyID);
        return StringTools.trim((String)v);
    }

    private void setPropertyID(String v) {
        this.setFieldValue(FLD_propertyID, StringTools.trim((String)v));
    }

    public String getValue() {
        String v = (String)this.getFieldValue(FLD_value);
        return StringTools.trim((String)v);
    }

    public void setValue(String v) {
        this.setFieldValue(FLD_value, StringTools.trim((String)v));
    }

    public String getSystemKey() {
        String v = (String)this.getFieldValue(FLD_systemKey);
        return StringTools.trim((String)v);
    }

    private void setSystemKey(String v) {
        this.setFieldValue(FLD_systemKey, StringTools.trim((String)v));
    }

    public void setCreationDefaultValues() {
        this.setDescription(this.getPropertyID());
        this.setValue("");
    }

    public String getStringSystemKey() {
        return this.getSystemKey();
    }

    public String getStringValue() {
        return this.getValue();
    }

    public int getIntValue(int dft) {
        return StringTools.parseInt((String)this.getValue(), (int)dft);
    }

    public long getLongValue(long dft) {
        return StringTools.parseLong((String)this.getValue(), (long)dft);
    }

    public float getFloatValue(float dft) {
        return StringTools.parseFloat((String)this.getValue(), (float)dft);
    }

    public double getDoubleValue(double dft) {
        return StringTools.parseDouble((String)this.getValue(), (double)dft);
    }

    public void setStringValue(String v) {
        this.setValue(v);
    }

    public void setIntValue(int v) {
        this.setValue(String.valueOf(v));
    }

    public void setLongValue(long v) {
        this.setValue(String.valueOf(v));
    }

    public void setFloatValue(float v) {
        this.setValue(String.valueOf(v));
    }

    public void setDoubleValue(double v) {
        this.setValue(String.valueOf(v));
    }

    public static SystemProps getProperty(String propKey) throws DBException {
        return SystemProps.getProperty(propKey, false);
    }

    public static SystemProps getProperty(String propKey, boolean create) throws DBException {
        if (propKey == null || propKey.equals("")) {
            return null;
        }
        SystemProps prop = null;
        Key key = new Key(propKey);
        if (key.exists()) {
            prop = (SystemProps)key.getDBRecord(true);
        } else if (create) {
            prop = (SystemProps)key.getDBRecord();
            prop.setCreationDefaultValues();
        }
        return prop;
    }

    public static String getStringValue(String propKey, String dft) {
        try {
            SystemProps prop = SystemProps.getProperty(propKey, false);
            return prop != null ? prop.getValue() : dft;
        }
        catch (DBException dbe) {
            return dft;
        }
    }

    public static String getStringSystemKey(String propKey, String dft) {
        try {
            SystemProps prop = SystemProps.getProperty(propKey, false);
            return prop != null ? prop.getSystemKey() : dft;
        }
        catch (DBException dbe) {
            return dft;
        }
    }

    public static int getIntValue(String propKey, int dft) {
        String strVal = SystemProps.getStringValue(propKey, null);
        return StringTools.parseInt((String)strVal, (int)dft);
    }

    public static long getLongValue(String propKey, long dft) {
        String strVal = SystemProps.getStringValue(propKey, null);
        return StringTools.parseLong((String)strVal, (long)dft);
    }

    public static float getFloatValue(String propKey, float dft) {
        String strVal = SystemProps.getStringValue(propKey, null);
        return StringTools.parseFloat((String)strVal, (float)dft);
    }

    public static double getDoubleValue(String propKey, double dft) {
        String strVal = SystemProps.getStringValue(propKey, null);
        return StringTools.parseDouble((String)strVal, (double)dft);
    }

    public static boolean setStringValue(String propKey, String value) {
        try {
            SystemProps prop = SystemProps.getProperty(propKey, true);
            if (prop != null) {
                try {
                    prop.setValue(value);
                    prop.save();
                    return true;
                }
                catch (DBException dbe) {
                    Print.logException((String)"Setting SystemProps", (Throwable)dbe);
                    return false;
                }
            }
            return false;
        }
        catch (DBException dbe) {
            return false;
        }
    }

    public static boolean setIntValue(String propKey, int v) {
        return SystemProps.setStringValue(propKey, String.valueOf(v));
    }

    public static boolean setLongValue(String propKey, long v) {
        return SystemProps.setStringValue(propKey, String.valueOf(v));
    }

    public static boolean setFloatValue(String propKey, float v) {
        return SystemProps.setStringValue(propKey, String.valueOf(v));
    }

    public static boolean setDoubleValue(String propKey, double v) {
        return SystemProps.setStringValue(propKey, String.valueOf(v));
    }

    public static String getGTSVersion(String dft) {
        return SystemProps.getStringValue(GTS_VERSION, dft);
    }

    public static String getGTSVersion() {
        return SystemProps.getGTSVersion("");
    }

    public static String getDMTPVersion(String dft) {
        return SystemProps.getStringValue(DMTP_VERSION, dft);
    }

    public static String getDMTPVersion() {
        return SystemProps.getDMTPVersion("");
    }

    public static void updateVersions() {
        String gtsPropVersion;
        String gtsCurrVersion = Version.getVersion();
        if (!gtsCurrVersion.equals(gtsPropVersion = SystemProps.getGTSVersion())) {
            Print.logInfo((String)("Updating GTS Version: " + gtsCurrVersion), (Object[])new Object[0]);
            SystemProps.setStringValue(GTS_VERSION, gtsCurrVersion);
        }
        try {
            MethodAction dmtpVersMeth = new MethodAction((Object)"org.opendmtp.server.Version", "getVersion");
            String dmtpCurrVersion = (String)dmtpVersMeth.invoke();
            String dmtpPropVersion = SystemProps.getDMTPVersion();
            if (!dmtpCurrVersion.equals(dmtpPropVersion)) {
                Print.logInfo((String)("Updating DMTP Version: " + dmtpCurrVersion), (Object[])new Object[0]);
                SystemProps.setStringValue(DMTP_VERSION, dmtpCurrVersion);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        Print.sysPrintln((String)("Property 'version.gts' value: " + SystemProps.getStringValue(GTS_VERSION, "undefined")), (Object[])new Object[0]);
        Print.sysPrintln((String)("Property 'version.dmtp' value: " + SystemProps.getStringValue(DMTP_VERSION, "undefined")), (Object[])new Object[0]);
        if (RTConfig.getBoolean((String)"update", (boolean)false)) {
            SystemProps.updateVersions();
        }
    }

    public static class Key
    extends DBRecordKey<SystemProps> {
        public Key() {
        }

        public Key(String versId) {
            super.setKeyValue(SystemProps.FLD_propertyID, (Object)(versId != null ? versId.toLowerCase() : ""));
        }

        public DBFactory<SystemProps> getFactory() {
            return SystemProps.getFactory();
        }
    }
}

