/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.StatusCodeProvider;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.ColorTools;
import org.opengts.util.CssStyle;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class StatusCode
extends DeviceRecord<StatusCode>
implements StatusCodeProvider {
    public static final String ALL_DEVICES = "*";
    public static final String _TABLE_NAME = "StatusCode";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_statusName = "statusName";
    public static final String FLD_foregroundColor = "foregroundColor";
    public static final String FLD_backgroundColor = "backgroundColor";
    public static final String FLD_iconSelector = "iconSelector";
    public static final String FLD_iconName = "iconName";
    private static DBField[] FieldInfo = new DBField[]{StatusCode.newField_accountID(true), StatusCode.newField_deviceID(true), new DBField("statusCode", Integer.TYPE, "UINT32", "Status Code", "key=true editor=statusCode format=X2"), new DBField("statusName", String.class, DBField.TYPE_STRING((int)18), "Status Name", "edit=2"), new DBField("foregroundColor", String.class, DBField.TYPE_STRING((int)10), "Foreground Color", "edit=2"), new DBField("backgroundColor", String.class, DBField.TYPE_STRING((int)10), "Background Color", "edit=2"), new DBField("iconSelector", String.class, DBField.TYPE_STRING((int)128), "Icon Selector", "edit=2 editor=ruleSelector"), new DBField("iconName", String.class, DBField.TYPE_STRING((int)24), "Icon Name", "edit=2"), StatusCode.newField_description(), StatusCode.newField_lastUpdateTime(), StatusCode.newField_lastUpdateUser((boolean)true), StatusCode.newField_creationTime()};
    private static DBFactory<StatusCode> factory = null;
    private CssStyle cachCssStyle = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_CODE = new String[]{"status", "code", "ecode"};
    private static final String[] ARG_ECODE = new String[]{"ecode"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_LIST = new String[]{"list"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<StatusCode> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)StatusCode.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, StatusCode.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
            factory.setFieldDefaultValue("deviceID", (Object)ALL_DEVICES);
        }
        return factory;
    }

    public StatusCode() {
    }

    public StatusCode(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(StatusCode.class, (Locale)loc);
        return i18n.getString("StatusCode.description", "This table defines Device specific StatusCode descriptions.");
    }

    @Override
    public int getStatusCode() {
        Integer v = (Integer)this.getFieldValue(FLD_statusCode);
        return v != null ? v : 0;
    }

    public void setStatusCode(int v) {
        this.setFieldValue(FLD_statusCode, v);
    }

    public String getStatusName() {
        String v = (String)this.getFieldValue(FLD_statusName);
        return StringTools.trim((String)v);
    }

    public void setStatusName(String v) {
        this.setFieldValue(FLD_statusName, StringTools.trim((String)v));
    }

    @Override
    public String getForegroundColor() {
        String v = (String)this.getFieldValue(FLD_foregroundColor);
        return StringTools.trim((String)v);
    }

    public void setForegroundColor(String v) {
        this.setFieldValue(FLD_foregroundColor, StringTools.trim((String)v));
        this.cachCssStyle = null;
    }

    public void setForegroundColor(ColorTools.RGB rgb) {
        this.setForegroundColor(rgb != null ? rgb.toString(true) : (String)null);
    }

    @Override
    public String getBackgroundColor() {
        String v = (String)this.getFieldValue(FLD_backgroundColor);
        return StringTools.trim((String)v);
    }

    public void setBackgroundColor(String v) {
        this.setFieldValue(FLD_backgroundColor, StringTools.trim((String)v));
        this.cachCssStyle = null;
    }

    public void setBackgroundColor(ColorTools.RGB rgb) {
        this.setBackgroundColor(rgb != null ? rgb.toString(true) : (String)null);
    }

    @Override
    public String getIconSelector() {
        String v = (String)this.getFieldValue(FLD_iconSelector);
        return StringTools.trim((String)v);
    }

    public void setIconSelector(String v) {
        this.setFieldValue(FLD_iconSelector, StringTools.trim((String)v));
    }

    @Override
    public String getIconName() {
        String v = (String)this.getFieldValue(FLD_iconName);
        return StringTools.trim((String)v);
    }

    public void setIconName(String v) {
        this.setFieldValue(FLD_iconName, StringTools.trim((String)v));
    }

    @Override
    public String getDescription(Locale locale) {
        return this.getDescription();
    }

    @Override
    public boolean hasStyle() {
        return !StringTools.isBlank((String)this.getForegroundColor()) || !StringTools.isBlank((String)this.getBackgroundColor());
    }

    public CssStyle getCssStyle() {
        if (this.hasStyle() && this.cachCssStyle == null) {
            String fgc = this.getForegroundColor();
            String bgc = this.getBackgroundColor();
            this.cachCssStyle = new CssStyle();
            this.cachCssStyle.setForegroundColor(fgc);
            this.cachCssStyle.setBackgroundColor(bgc);
        }
        return this.cachCssStyle;
    }

    @Override
    public String getStyleString() {
        CssStyle css = this.getCssStyle();
        return css != null ? css.getStyleString() : "";
    }

    public String getHtmlDescription() {
        String scd = this.getDescription();
        CssStyle css = this.getCssStyle();
        return css != null ? css.wrapText_div(scd) : StringTools.htmlFilterText((Object)scd);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAccountID());
        sb.append("/");
        sb.append(this.getDeviceID());
        sb.append(" ");
        sb.append(this.getStatusCode());
        sb.append("[");
        sb.append(this.getDescription());
        sb.append("]");
        return sb.toString();
    }

    public void setCreationDefaultValues() {
        BasicPrivateLabel privateLabel = Account.getPrivateLabel(this.getAccount());
        StatusCodes.Code code = StatusCodes.GetCode(this.getStatusCode(), privateLabel);
        this.setStatusName(code != null ? code.getName() : "");
        this.setDescription(code != null ? code.getDescription(null) : "");
        this.setIconSelector("");
    }

    public static StatusCode findStatusCode(String accountID, String deviceID, int statusCode) {
        String sysAdmin;
        if (!StringTools.isBlank((String)accountID)) {
            StatusCode code;
            Key codeKey;
            if (!StringTools.isBlank((String)deviceID)) {
                try {
                    codeKey = new Key(accountID, deviceID, statusCode);
                    if (codeKey.exists() && (code = (StatusCode)codeKey.getDBRecord(true)) != null) {
                        return code;
                    }
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            try {
                codeKey = new Key(accountID, statusCode);
                if (codeKey.exists() && (code = (StatusCode)codeKey.getDBRecord(true)) != null) {
                    return code;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (!StringTools.isBlank((String)(sysAdmin = AccountRecord.getSystemAdminAccountID()))) {
            try {
                StatusCode code;
                Key codeKey = new Key(sysAdmin, statusCode);
                if (codeKey.exists() && (code = (StatusCode)codeKey.getDBRecord(true)) != null) {
                    return code;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return null;
    }

    public static StatusCodeProvider getStatusCodeProvider(Device device, int statusCode, BasicPrivateLabel bpl, StatusCodeProvider dftSCP) {
        StatusCode code;
        if (device != null && (code = device.getStatusCode(statusCode)) != null) {
            return code;
        }
        if (dftSCP != null) {
            return dftSCP;
        }
        return StatusCodes.GetStatusCodeProvider(statusCode, bpl);
    }

    public static StatusCodeProvider getStatusCodeProvider(String accountID, int statusCode, BasicPrivateLabel bpl, StatusCodeProvider dftSCP) {
        StatusCode code = StatusCode.findStatusCode(accountID, null, statusCode);
        if (code != null) {
            return code;
        }
        if (dftSCP != null) {
            return dftSCP;
        }
        return StatusCodes.GetStatusCodeProvider(statusCode, bpl);
    }

    public static String getDescription(Device device, int statusCode, BasicPrivateLabel bpl, String dftDesc) {
        StatusCode code;
        if (device != null && (code = device.getStatusCode(statusCode)) != null) {
            return code.getDescription();
        }
        if (!StringTools.isBlank((String)dftDesc)) {
            return dftDesc;
        }
        return StatusCodes.GetDescription(statusCode, bpl);
    }

    public static String getDescription(String accountID, int statusCode, BasicPrivateLabel bpl, String dftDesc) {
        StatusCode code = StatusCode.findStatusCode(accountID, null, statusCode);
        if (code != null) {
            return code.getDescription();
        }
        if (!StringTools.isBlank((String)dftDesc)) {
            return dftDesc;
        }
        return StatusCodes.GetDescription(statusCode, bpl);
    }

    public static String getForegroundColor(Device device, int statusCode, BasicPrivateLabel bpl, String dftColor) {
        StatusCode code;
        if (device != null && (code = device.getStatusCode(statusCode)) != null) {
            return code.getForegroundColor();
        }
        if (!StringTools.isBlank((String)dftColor)) {
            return dftColor;
        }
        return null;
    }

    public static String getForegroundColor(String accountID, int statusCode, BasicPrivateLabel bpl, String dftColor) {
        StatusCode code = StatusCode.findStatusCode(accountID, null, statusCode);
        if (code != null) {
            return code.getForegroundColor();
        }
        if (!StringTools.isBlank((String)dftColor)) {
            return dftColor;
        }
        return null;
    }

    public static String getBackgroundColor(Device device, int statusCode, BasicPrivateLabel bpl, String dftColor) {
        StatusCode code;
        if (device != null && (code = device.getStatusCode(statusCode)) != null) {
            return code.getBackgroundColor();
        }
        if (!StringTools.isBlank((String)dftColor)) {
            return dftColor;
        }
        return null;
    }

    public static String getBackgroundColor(String accountID, int statusCode, BasicPrivateLabel bpl, String dftColor) {
        StatusCode code = StatusCode.findStatusCode(accountID, null, statusCode);
        if (code != null) {
            return code.getBackgroundColor();
        }
        if (!StringTools.isBlank((String)dftColor)) {
            return dftColor;
        }
        return null;
    }

    public static String getIconSelector(Device device, int statusCode, BasicPrivateLabel bpl) {
        StatusCode code;
        if (device != null && (code = device.getStatusCode(statusCode)) != null) {
            return code.getIconSelector();
        }
        return "";
    }

    public static String getIconName(Device device, int statusCode, BasicPrivateLabel bpl) {
        StatusCode code;
        if (device != null && (code = device.getStatusCode(statusCode)) != null) {
            return code.getIconName();
        }
        return StatusCodes.GetIconName(statusCode, bpl);
    }

    public static boolean exists(String accountID, String deviceID, int code) throws DBException {
        if (accountID != null && deviceID != null) {
            Key scKey = new Key(accountID, deviceID, code);
            return scKey.exists();
        }
        return false;
    }

    public static StatusCode getStatusCode(String accountID, String deviceID, int code) throws DBException {
        return StatusCode._getStatusCode(accountID, null, deviceID, code, false);
    }

    public static StatusCode getStatusCode(Account account, String deviceID, int code) throws DBException {
        return StatusCode._getStatusCode(null, account, deviceID, code, false);
    }

    public static StatusCode getStatusCode(Account account, String deviceID, int code, boolean createOK) throws DBException {
        return StatusCode._getStatusCode(null, account, deviceID, code, createOK);
    }

    private static StatusCode _getStatusCode(String accountID, Account account, String deviceID, int code, boolean createOK) throws DBException {
        Key scKey;
        if (StringTools.isBlank((String)accountID)) {
            if (account == null) {
                throw new DBException("Account not specified.");
            }
            accountID = account.getAccountID();
        } else if (account != null && !account.getAccountID().equals(accountID)) {
            throw new DBException("Account does not match specified AccountID.");
        }
        if (StringTools.isBlank((String)deviceID)) {
            deviceID = ALL_DEVICES;
        }
        if ((scKey = new Key(accountID, deviceID, code)).exists()) {
            StatusCode sc = (StatusCode)scKey.getDBRecord(true);
            if (account != null) {
                sc.setAccount(account);
            }
            return sc;
        }
        if (createOK) {
            StatusCode sc = (StatusCode)scKey.getDBRecord();
            if (account != null) {
                sc.setAccount(account);
            }
            sc.setCreationDefaultValues();
            return sc;
        }
        return null;
    }

    public static StatusCode createNewStatusCode(Account account, String deviceID, int code) throws DBException {
        if (account == null) {
            throw new DBException("Invalid/Null Account specified");
        }
        if (code < 0 || code > 65535) {
            throw new DBException("Invalid StatusCode specified");
        }
        if (StringTools.isBlank((String)deviceID)) {
            deviceID = ALL_DEVICES;
        }
        StatusCode sc = StatusCode.getStatusCode(account, deviceID, code, true);
        sc.save();
        return sc;
    }

    public static int[] getStatusCodes(String accountID, String deviceID) throws DBException {
        if (StringTools.isBlank((String)accountID)) {
            return new int[0];
        }
        if (StringTools.isBlank((String)deviceID)) {
            deviceID = ALL_DEVICES;
        }
        DBSelect dsel = new DBSelect(StatusCode.getFactory());
        dsel.setSelectedFields(new String[]{FLD_statusCode});
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)accountID), dwh.EQ("deviceID", (Object)deviceID))));
        dsel.setOrderByFields(new String[]{FLD_statusCode});
        Vector<Integer> codeList = new Vector<Integer>();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                int code = rs.getInt(FLD_statusCode);
                codeList.add(new Integer(code));
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting StatusCode List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        int[] codeListInt = new int[codeList.size()];
        for (int i = 0; i < codeListInt.length; ++i) {
            codeListInt[i] = (Integer)codeList.get(i);
        }
        return codeListInt;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + StatusCode.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Account ID owning StatusCode", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>    Device ID owning StatusCode (use '/' for ALL)", (Object[])new Object[0]);
        Print.logInfo((String)"  -code=<id>      StatusCode to create/delete/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new StatusCode", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           To edit an existing StatusCode", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified StatusCode", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String deviceID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        int statusCode = RTConfig.getInt((String[])ARG_CODE, (int)0);
        boolean anyCode = true;
        if (StringTools.isBlank((String)accountID)) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            StatusCode.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(accountID);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                StatusCode.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
            System.exit(99);
        }
        if (StringTools.isBlank((String)deviceID) || deviceID.startsWith("/")) {
            deviceID = ALL_DEVICES;
        }
        if (!deviceID.equals(ALL_DEVICES)) {
            try {
                Device device = Device.getDevice(account, deviceID);
                if (device == null) {
                    Print.logError((String)("Device-ID does not exist: " + accountID + " / " + deviceID), (Object[])new Object[0]);
                    StatusCode.usage();
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Error loading Device: " + accountID + " / " + deviceID), (Throwable)dbe);
                System.exit(99);
            }
        }
        if (statusCode > 0 && !anyCode && !StatusCodes.IsValid(statusCode, account.getPrivateLabel())) {
            Print.logError((String)"Invalid Status Code specified.", (Object[])new Object[0]);
            StatusCode.usage();
        }
        if (statusCode <= 0) {
            Print.logError((String)"StatusCode not specified.", (Object[])new Object[0]);
            StatusCode.usage();
        }
        boolean statusCodeExists = false;
        try {
            statusCodeExists = StatusCode.exists(accountID, deviceID, statusCode);
        }
        catch (DBException dbe) {
            Print.logError((String)("Error determining if StatusCode exists: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false)) {
            ++opts;
            if (!statusCodeExists) {
                Print.logWarn((String)("StatusCode does not exist: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key scKey = new Key(accountID, deviceID, statusCode);
                scKey.delete(true);
                Print.logInfo((String)("StatusCode deleted: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
                statusCodeExists = false;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting StatusCode: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (statusCodeExists) {
                Print.logWarn((String)("StatusCode already exists: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
            } else {
                try {
                    StatusCode.createNewStatusCode(account, deviceID, statusCode);
                    Print.logInfo((String)("Created StatusCode: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
                    statusCodeExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating StatusCode: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false)) {
            ++opts;
            if (!statusCodeExists) {
                Print.logError((String)("StatusCode does not exist: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
            } else {
                try {
                    StatusCode sc = StatusCode.getStatusCode(account, deviceID, statusCode);
                    DBEdit editor = new DBEdit((DBRecord)sc);
                    editor.edit();
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing StatusCode: " + accountID + "/" + deviceID + "/" + statusCode), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            ++opts;
            String listType = RTConfig.getString((String[])ARG_LIST, null);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            StatusCode.usage();
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<StatusCode> {
        public Key() {
        }

        public Key(String accountId, int statusCode) {
            this(accountId, StatusCode.ALL_DEVICES, statusCode);
        }

        public Key(String accountId, String deviceId, int statusCode) {
            super.setKeyValue("accountID", (Object)(accountId != null ? accountId.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(deviceId != null ? deviceId.toLowerCase() : ""));
            super.setKeyValue(StatusCode.FLD_statusCode, statusCode);
        }

        public DBFactory<StatusCode> getFactory() {
            return StatusCode.getFactory();
        }
    }
}

