/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import org.opengts.db.AclEntry;
import org.opengts.db.DBConfig;
import org.opengts.db.RoleRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Role;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class RoleAcl
extends RoleRecord<RoleAcl> {
    public static final String _TABLE_NAME = "RoleAcl";
    public static final String FLD_aclID = "aclID";
    public static final String FLD_accessLevel = "accessLevel";
    private static DBField[] FieldInfo = new DBField[]{RoleAcl.newField_accountID(true), RoleAcl.newField_roleID(true), new DBField("aclID", String.class, DBField.TYPE_STRING((int)64), "ACL ID", "key=true"), new DBField("accessLevel", Integer.TYPE, "UINT16", "Access Level", "edit=2 enum=AclEntry$AccessLevel"), RoleAcl.newField_description(), RoleAcl.newField_lastUpdateTime(), RoleAcl.newField_lastUpdateUser((boolean)true), RoleAcl.newField_creationTime()};
    private static DBFactory<RoleAcl> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_ROLE = new String[]{"role"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_ACL = new String[]{"acl"};
    private static final String[] ARG_SET = new String[]{"set"};
    private static final String[] ARG_CREATE = new String[]{"create", "cr"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_DELETE = new String[]{"delete", "purge"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<RoleAcl> getFactory() {
        if (factory == null) {
            EnumTools.registerEnumClass(AclEntry.AccessLevel.class);
            factory = DBFactory.createDBFactory((String)RoleAcl.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, RoleAcl.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Role.TABLE_NAME());
        }
        return factory;
    }

    public RoleAcl() {
    }

    public RoleAcl(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(RoleAcl.class, (Locale)loc);
        return i18n.getString("RoleAcl.description", "This table defines Role specific Access Control permissions.");
    }

    public String getAclID() {
        String v = (String)this.getFieldValue(FLD_aclID);
        return StringTools.trim((String)v);
    }

    private void setAclID(String v) {
        this.setFieldValue(FLD_aclID, StringTools.trim((String)v));
    }

    public int getAccessLevel() {
        Integer v = (Integer)this.getFieldValue(FLD_accessLevel);
        return v != null ? v : 0;
    }

    public void setAccessLevel(int v) {
        this.setFieldValue(FLD_accessLevel, ((AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (int)v)).getIntValue());
    }

    public void setAccessLevel(String v) {
        this.setFieldValue(FLD_accessLevel, ((AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (String)v)).getIntValue());
    }

    public boolean hasReadAccess() {
        return AclEntry.okRead(this.getAccessLevel());
    }

    public boolean hasWriteAccess() {
        return AclEntry.okWrite(this.getAccessLevel());
    }

    public boolean hasAllAccess() {
        return AclEntry.okAll(this.getAccessLevel());
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getRoleID() + "/" + this.getAclID();
    }

    public void setCreationDefaultValues() {
    }

    public static boolean exists(String acctID, String roleID, String aclID) throws DBException {
        if (acctID != null && roleID != null && aclID != null) {
            Key aclKey = new Key(acctID, roleID, aclID);
            return aclKey.exists();
        }
        return false;
    }

    public static AclEntry.AccessLevel getAccessLevel(RoleAcl ra) {
        return ra != null ? (AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (int)ra.getAccessLevel()) : (AclEntry.AccessLevel)EnumTools.getDefault(AclEntry.AccessLevel.class);
    }

    public static AclEntry.AccessLevel getAccessLevel(Role role, String aclId, AclEntry.AccessLevel dftAccess) {
        if (role == null) {
            return dftAccess;
        }
        if (StringTools.isBlank((String)aclId)) {
            return dftAccess;
        }
        try {
            RoleAcl roleAcl = RoleAcl.getRoleAcl(role, aclId);
            if (roleAcl != null) {
                return RoleAcl.getAccessLevel(roleAcl);
            }
            return dftAccess;
        }
        catch (DBException dbe) {
            return AclEntry.AccessLevel.NONE;
        }
    }

    public static void setAccessLevel(Role role, String aclId, AclEntry.AccessLevel level) throws DBException {
        if (role == null) {
            throw new DBException("Role not specified.");
        }
        String acctId = role.getAccountID();
        String roleId = role.getRoleID();
        if (StringTools.isBlank((String)aclId)) {
            throw new DBException("Acl-ID not specified.");
        }
        RoleAcl roleAcl = null;
        Key aclKey = new Key(acctId, roleId, aclId);
        if (aclKey.exists()) {
            roleAcl = RoleAcl.getRoleAcl(role, aclId);
        } else {
            roleAcl = (RoleAcl)aclKey.getDBRecord();
            roleAcl.setRole(role);
        }
        int levelInt = level != null ? level.getIntValue() : AclEntry.AccessLevel.NONE.getIntValue();
        roleAcl.setAccessLevel(levelInt);
        roleAcl.save();
    }

    public static boolean deleteAccessLevel(Role role, String aclId) throws DBException {
        if (role == null) {
            return false;
        }
        String acctId = role.getAccountID();
        String roleId = role.getRoleID();
        if (StringTools.isBlank((String)aclId)) {
            return false;
        }
        boolean aclExists = RoleAcl.exists(acctId, roleId, aclId);
        if (!aclExists) {
            return false;
        }
        Key aclKey = new Key(acctId, roleId, aclId);
        aclKey.delete(true);
        return true;
    }

    public static RoleAcl getRoleAcl(Role role, String aclId) throws DBException {
        if (role != null && aclId != null) {
            Key aclKey = new Key(role.getAccountID(), role.getRoleID(), aclId);
            if (aclKey.exists()) {
                RoleAcl roleAcl = (RoleAcl)aclKey.getDBRecord(true);
                roleAcl.setRole(role);
                return roleAcl;
            }
            return null;
        }
        throw new DBException("Role or AclID is null");
    }

    public static RoleAcl getRoleAcl(Role role, String aclId, boolean create) throws DBException {
        if (role == null) {
            throw new DBNotFoundException("Role not specified.");
        }
        String acctId = role.getAccountID();
        String roleId = role.getRoleID();
        if (StringTools.isBlank((String)aclId)) {
            throw new DBNotFoundException("Acl-ID not specified.");
        }
        RoleAcl roleAcl = null;
        Key aclKey = new Key(acctId, roleId, aclId);
        if (!aclKey.exists()) {
            if (create) {
                roleAcl = (RoleAcl)aclKey.getDBRecord();
                roleAcl.setRole(role);
                roleAcl.setCreationDefaultValues();
                return roleAcl;
            }
            throw new DBNotFoundException("Acl-ID does not exists '" + (Object)((Object)aclKey) + "'");
        }
        if (create) {
            throw new DBAlreadyExistsException("Acl-ID already exists '" + (Object)((Object)aclKey) + "'");
        }
        roleAcl = RoleAcl.getRoleAcl(role, aclId);
        if (roleAcl == null) {
            throw new DBException("Unable to read existing Role-ID '" + (Object)((Object)aclKey) + "'");
        }
        return roleAcl;
    }

    public static RoleAcl createNewRoleAcl(Role role, String aclID) throws DBException {
        RoleAcl roleAcl = RoleAcl.getRoleAcl(role, aclID, true);
        if (roleAcl != null) {
            roleAcl.save();
        }
        return roleAcl;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + RoleAcl.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Acount ID which owns Role", (Object[])new Object[0]);
        Print.logInfo((String)"  -role=<id>      Role ID which owns RoleAcl", (Object[])new Object[0]);
        Print.logInfo((String)"  -list           List Acls for Role", (Object[])new Object[0]);
        Print.logInfo((String)"  -acl=<id>       Role ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -set=<val>      RoleAcl value (create if necessary)", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new RoleAcl", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           Edit an existing (or newly created) RoleAcl", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified RoleAcl", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String roleID = RTConfig.getString((String[])ARG_ROLE, (String)"");
        String aclID = RTConfig.getString((String[])ARG_ACL, (String)"");
        if (acctID == null || acctID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            RoleAcl.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(acctID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                RoleAcl.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (roleID == null || roleID.equals("")) {
            Print.logError((String)"Role-ID not specified.", (Object[])new Object[0]);
            RoleAcl.usage();
        }
        Role role = null;
        try {
            role = Role.getRole(acct, roleID);
            if (role == null) {
                Print.logError((String)("Role-ID does not exist: " + acctID + "/" + roleID), (Object[])new Object[0]);
                RoleAcl.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Role: " + acctID + "/" + roleID), (Throwable)dbe);
            System.exit(99);
        }
        boolean aclExists = false;
        if (aclID != null && !aclID.equals("")) {
            try {
                aclExists = RoleAcl.exists(acctID, roleID, aclID);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error determining if RoleAcl exists: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_LIST, (boolean)false)) {
            ++opts;
            try {
                String[] aclList = role.getAclsForRole();
                for (int i = 0; i < aclList.length; ++i) {
                    AclEntry.AccessLevel level = RoleAcl.getAccessLevel(role, aclList[i], AclEntry.AccessLevel.NONE);
                    Print.sysPrintln((String)("  " + aclList[i] + " ==> " + (Object)((Object)level)), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Error getting Acl list: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !acctID.equals("") && !roleID.equals("")) {
            ++opts;
            if (!aclExists) {
                Print.logWarn((String)("RoleAcl does not exist: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key aclKey = new Key(acctID, roleID, aclID);
                aclKey.delete(true);
                Print.logInfo((String)("RoleAcl deleted: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting RoleAcl: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (aclExists) {
                Print.logWarn((String)("RoleAcl already exists: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
            } else {
                try {
                    RoleAcl.createNewRoleAcl(role, aclID);
                    Print.logInfo((String)("Created RoleAcl: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
                    aclExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating RoleAcl: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.hasProperty((String[])ARG_SET)) {
            ++opts;
            AclEntry.AccessLevel aclLevel = (AclEntry.AccessLevel)EnumTools.getValueOf(AclEntry.AccessLevel.class, (int)RTConfig.getInt((String[])ARG_SET, (int)-1));
            try {
                RoleAcl.setAccessLevel(role, aclID, aclLevel);
                Print.logInfo((String)("Set RoleAcl '" + acctID + "/" + roleID + "/" + aclID + "' to level " + (Object)((Object)aclLevel)), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error setting RoleAcl: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false)) {
            ++opts;
            if (!aclExists) {
                Print.logError((String)("RoleAcl does not exist: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
            } else {
                try {
                    RoleAcl roleAcl = RoleAcl.getRoleAcl(role, aclID, false);
                    DBEdit editor = new DBEdit((DBRecord)roleAcl);
                    editor.edit();
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing RoleAcl: " + acctID + "/" + roleID + "/" + aclID), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            RoleAcl.usage();
        }
    }

    public static class Key
    extends RoleRecord.RoleKey<RoleAcl> {
        public Key() {
        }

        public Key(String acctId, String roleId, String aclId) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("roleID", (Object)(roleId != null ? roleId.toLowerCase() : ""));
            super.setKeyValue(RoleAcl.FLD_aclID, (Object)(aclId != null ? aclId.toLowerCase() : ""));
        }

        public DBFactory<RoleAcl> getFactory() {
            return RoleAcl.getFactory();
        }
    }
}

