/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.RoleRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.RoleAcl;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Role
extends RoleRecord<Role> {
    public static final String _TABLE_NAME = "Role";
    private static DBField[] FieldInfo = new DBField[]{Role.newField_accountID(true), Role.newField_roleID(true), Role.newField_displayName(), Role.newField_description(), Role.newField_notes(), Role.newField_lastUpdateTime(), Role.newField_lastUpdateUser((boolean)true), Role.newField_creationTime()};
    private static DBFactory<Role> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_ROLE = new String[]{"role"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_EDITALL = new String[]{"editall", "eda"};
    private static final String[] ARG_DELETE = new String[]{"delete", "purge"};
    private static final String[] ARG_LIST = new String[]{"list"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Role> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Role.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Role.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
        }
        return factory;
    }

    public Role() {
    }

    public Role(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Role.class, (Locale)loc);
        return i18n.getString("Role.description", "This table defines Account specific Roles.");
    }

    public void setCreationDefaultValues() {
        this.setDescription("New Role");
        super.setRuntimeDefaultValues();
    }

    public boolean isSystemAdminRole() {
        return AccountRecord.isSystemAdminAccountID(this.getAccountID());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAclsForRole() throws DBException {
        Statement stmt;
        DBConnection dbc;
        Vector<String> aclList;
        block16: {
            String acctID = this.getAccountID();
            aclList = new Vector<String>();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(RoleAcl.getFactory());
                dsel.setSelectedFields(new String[]{"aclID"});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)this.getAccountID()), dwh.EQ("roleID", (Object)this.getRoleID()))));
                dsel.setOrderByFields(new String[]{"aclID"});
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String aclId = rs.getString("aclID");
                    aclList.add(aclId);
                }
                if (rs == null) break block16;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting Role ACL List", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return aclList.toArray(new String[aclList.size()]);
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getRoleID();
    }

    public static boolean exists(String acctID, String roleID) throws DBException {
        if (acctID != null && roleID != null) {
            Key roleKey = new Key(acctID, roleID);
            return roleKey.exists();
        }
        return false;
    }

    public static Role getRole(String accountId, String roleId) throws DBException {
        String acctId;
        if (StringTools.isBlank((String)roleId)) {
            throw new DBException("RoleID is blank/null");
        }
        String string = acctId = RoleRecord.isSystemAdminRoleID(roleId) ? AccountRecord.getSystemAdminAccountID() : accountId;
        if (StringTools.isBlank((String)acctId)) {
            throw new DBException("AccountID is blank/null");
        }
        Key roleKey = new Key(acctId, roleId);
        if (roleKey.exists()) {
            Role role = (Role)roleKey.getDBRecord(true);
            return role;
        }
        return null;
    }

    public static Role getRole(Account account, String roleId) throws DBException {
        if (account != null) {
            String acctId = account.getAccountID();
            Role role = Role.getRole(acctId, roleId);
            if (role != null) {
                if (acctId.equals(role.getAccountID())) {
                    role.setAccount(account);
                }
                return role;
            }
            return null;
        }
        throw new DBException("Account is null");
    }

    public static Role getRole(Account account, String roleId, boolean create) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String acctId = account.getAccountID();
        if (StringTools.isBlank((String)roleId)) {
            throw new DBNotFoundException("RoleID not specified.");
        }
        if (Role.isSystemAdminRoleID(roleId) && !account.isSystemAdmin()) {
            throw new DBNotFoundException("RoleID not allow for non system admin.");
        }
        Role role = null;
        Key roleKey = new Key(acctId, roleId);
        if (!roleKey.exists()) {
            if (create) {
                role = (Role)roleKey.getDBRecord();
                role.setAccount(account);
                role.setCreationDefaultValues();
                return role;
            }
            throw new DBNotFoundException("Role-ID does not exists '" + (Object)((Object)roleKey) + "'");
        }
        if (create) {
            throw new DBAlreadyExistsException("Role-ID already exists '" + (Object)((Object)roleKey) + "'");
        }
        role = Role.getRole(account, roleId);
        if (role == null) {
            throw new DBException("Unable to read existing Role-ID '" + (Object)((Object)roleKey) + "'");
        }
        return role;
    }

    public static Role createNewRole(Account account, String roleID) throws DBException {
        if (account != null && !StringTools.isBlank((String)roleID)) {
            Role role = Role.getRole(account, roleID, true);
            role.save();
            return role;
        }
        throw new DBNotFoundException("Invalid Account/RoleID specified");
    }

    public static String[] getRolesForAccount(String acctId) throws DBException {
        return Role.getRolesForAccount(acctId, false);
    }

    public static String[] getRolesForAccount(String acctId, boolean inclSysRoles) throws DBException {
        String sysAdminID;
        if (StringTools.isBlank((String)acctId)) {
            return new String[0];
        }
        DBSelect dsel = new DBSelect(Role.getFactory());
        dsel.setSelectedFields(new String[]{"roleID"});
        dsel.setOrderByFields(new String[]{"roleID"});
        DBWhere dwh = dsel.createDBWhere();
        dwh.append(dwh.EQ("accountID", (Object)acctId));
        if (inclSysRoles && !StringTools.isBlank((String)"!") && !AccountRecord.isSystemAdminAccountID(acctId) && !StringTools.isBlank((String)(sysAdminID = Account.getSystemAdminAccountID()))) {
            dwh.append(dwh.OR_(dwh.AND(dwh.EQ("accountID", (Object)sysAdminID), dwh.STARTSWITH("roleID", "!"))));
        }
        dsel.setWhere(dwh.WHERE(dwh.toString()));
        return Role.getRoles((DBSelect<Role>)dsel);
    }

    public static String[] getRoles(DBSelect<Role> dsel) throws DBException {
        if (dsel == null) {
            return new String[0];
        }
        dsel.setSelectedFields(new String[]{"roleID"});
        Vector<String> roleList = new Vector<String>();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String roleId = rs.getString("roleID");
                roleList.add(roleId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting Account Role List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return roleList.toArray(new String[roleList.size()]);
    }

    public static boolean hasUsers(Role role) {
        if (role != null) {
            String acctID = role.getAccountID();
            String roleID = role.getRoleID();
            try {
                return User.hasUserIDsForRole(acctID, roleID);
            }
            catch (DBException dbe) {
                Print.logException((String)("Checking for users referencing role: " + acctID + "/" + roleID), (Throwable)dbe);
                return false;
            }
        }
        return false;
    }

    public static long getUserCount(Role role) {
        if (role != null) {
            String acctID = role.getAccountID();
            String roleID = role.getRoleID();
            try {
                return User.countUserIDsForRole(acctID, roleID);
            }
            catch (DBException dbe) {
                Print.logException((String)("Checking for users referencing role: " + acctID + "/" + roleID), (Throwable)dbe);
                return -1L;
            }
        }
        return 0L;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + Role.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Acount ID which owns Role", (Object[])new Object[0]);
        Print.logInfo((String)"  -role=<id>      Role ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new Role", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           Edit an existing (or newly created) Role", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified Role", (Object[])new Object[0]);
        Print.logInfo((String)"  -list           List Roles for Account", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String roleID = RTConfig.getString((String[])ARG_ROLE, (String)"");
        boolean listRoles = RTConfig.getBoolean((String[])ARG_LIST, (boolean)false);
        int opts = 0;
        if (StringTools.isBlank((String)acctID)) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            Role.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(acctID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                Role.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (listRoles) {
            ++opts;
            try {
                Print.logInfo((String)("Account: " + acctID), (Object[])new Object[0]);
                String[] roleList = Role.getRolesForAccount(acctID, false);
                for (int i = 0; i < roleList.length; ++i) {
                    Print.logInfo((String)("  Role: " + roleList[i]), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Error listing Roles: " + acctID), (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (StringTools.isBlank((String)roleID)) {
            Print.logError((String)"Role-ID not specified.", (Object[])new Object[0]);
            Role.usage();
        }
        boolean roleExists = false;
        try {
            roleExists = Role.exists(acctID, roleID);
        }
        catch (DBException dbe) {
            Print.logError((String)("Error determining if Role exists: " + acctID + "," + roleID), (Object[])new Object[0]);
            System.exit(99);
        }
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !acctID.equals("") && !roleID.equals("")) {
            ++opts;
            if (!roleExists) {
                Print.logWarn((String)("Role does not exist: " + acctID + "/" + roleID), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key roleKey = new Key(acctID, roleID);
                roleKey.delete(true);
                Print.logInfo((String)("Role deleted: " + acctID + "/" + roleID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting Role: " + acctID + "/" + roleID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (roleExists) {
                Print.logWarn((String)("Role already exists: " + acctID + "/" + roleID), (Object[])new Object[0]);
            } else {
                try {
                    Role.createNewRole(acct, roleID);
                    Print.logInfo((String)("Created Role-ID: " + acctID + "/" + roleID), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating Role: " + acctID + "/" + roleID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false) || RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false)) {
            ++opts;
            if (!roleExists) {
                Print.logError((String)("Role does not exist: " + acctID + "/" + roleID), (Object[])new Object[0]);
            } else {
                try {
                    boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                    Role role = Role.getRole(acct, roleID, false);
                    DBEdit editor = new DBEdit((DBRecord)role);
                    editor.edit(allFlds);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing Role: " + acctID + "/" + roleID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            Role.usage();
        }
    }

    public static class Key
    extends RoleRecord.RoleKey<Role> {
        public Key() {
        }

        public Key(String acctId, String roleId) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("roleID", (Object)(roleId != null ? roleId.toLowerCase() : ""));
        }

        public DBFactory<Role> getFactory() {
            return Role.getFactory();
        }
    }
}

