/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.I18N;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class Resource
extends AccountRecord<Resource> {
    public static final String RESID_TemporaryProperties = "temporaryproperties";
    public static final String RESID_PrivateLabel_Properties_ = "privatelabel.properties:";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_XML = "xml";
    public static final String TYPE_HTML = "html";
    public static final String TYPE_URL = "url";
    public static final String TYPE_URL_ = "url/";
    public static final String TYPE_URL_IMAGE = "url/image";
    public static final String TYPE_URL_PDF = "url/pdf";
    public static final String TYPE_IMAGE_ = "image/";
    public static final String TYPE_IMAGE_JPEG = "image/jpeg";
    public static final String TYPE_IMAGE_GIF = "image/gif";
    public static final String TYPE_IMAGE_PNG = "image/png";
    public static final String TYPE_IMAGE_GENERIC = "image/generic";
    public static final String TYPE_BINARY = "binary";
    public static final String TYPE_RTPROPS = "rtprops";
    public static final String TYPE_COLOR = "color";
    public static final String PROP_WIDTH = "width";
    public static final String PROP_HEIGHT = "height";
    public static final String PROP_ICON_URL = "iconURL";
    public static final String PROP_ICON_WIDTH = "iconWidth";
    public static final String PROP_ICON_HEIGHT = "iconHeight";
    private static final String _TABLE_NAME = "Resource";
    public static final String FLD_resourceID = "resourceID";
    public static final String FLD_type = "type";
    public static final String FLD_title = "title";
    public static final String FLD_properties = "properties";
    public static final String FLD_value = "value";
    private static DBField[] FieldInfo = new DBField[]{Resource.newField_accountID(true), new DBField("resourceID", String.class, DBField.TYPE_STRING((int)80), "Resource ID", "key=true editor=accountString"), new DBField("type", String.class, DBField.TYPE_STRING((int)16), "Type", "edit=2"), new DBField("title", String.class, DBField.TYPE_STRING((int)70), "Title", "edit=2 utf8=true"), new DBField("properties", String.class, "TEXT", "Properties", "edit=2"), new DBField("value", byte[].class, "BLOB", "Value", "edit=2"), Resource.newField_displayName(), Resource.newField_description(), Resource.newField_lastUpdateTime(), Resource.newField_lastUpdateUser((boolean)true), Resource.newField_creationTime()};
    private static DBFactory<Resource> factory = null;
    private RTProperties rtProps = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_RESOURCE = new String[]{"resource", "res"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_LIST = new String[]{"list"};

    public static boolean isStringType(String type) {
        if (StringTools.isBlank((String)type)) {
            return false;
        }
        return (type = type.toLowerCase()).startsWith(TYPE_TEXT) || type.startsWith(TYPE_XML) || type.startsWith(TYPE_HTML) || type.startsWith(TYPE_URL) || type.startsWith(TYPE_RTPROPS) || type.startsWith(TYPE_COLOR);
    }

    public static boolean isBinaryType(String type) {
        if (StringTools.isBlank((String)type)) {
            return true;
        }
        return (type = type.toLowerCase()).startsWith(TYPE_IMAGE_) || type.startsWith(TYPE_BINARY);
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Resource> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Resource.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Resource.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
        }
        return factory;
    }

    public Resource() {
    }

    public Resource(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Resource.class, (Locale)loc);
        return i18n.getString("Resource.description", "This table defines Account specific text resources.");
    }

    public String getResourceID() {
        String v = (String)this.getFieldValue(FLD_resourceID);
        return StringTools.trim((String)v);
    }

    private void setResourceID(String v) {
        this.setFieldValue(FLD_resourceID, StringTools.trim((String)v));
    }

    public String getTitle() {
        String v = (String)this.getFieldValue(FLD_title);
        return StringTools.trim((String)v);
    }

    public void setTitle(String v) {
        this.setFieldValue(FLD_title, StringTools.trim((String)v));
    }

    public String getType() {
        String v = (String)this.getFieldValue(FLD_type);
        return StringTools.trim((String)v);
    }

    public void setType(String v) {
        this.setFieldValue(FLD_type, StringTools.trim((String)v));
    }

    public boolean isStringType() {
        String t = this.getType();
        return Resource.isStringType(t);
    }

    public boolean isBinaryType() {
        String t = this.getType();
        return Resource.isBinaryType(t);
    }

    public boolean isURL() {
        String t = this.getType();
        return t.equals(TYPE_URL) || t.startsWith(TYPE_URL_);
    }

    public boolean isImageURL() {
        String t = this.getType();
        return t.equalsIgnoreCase(TYPE_URL_IMAGE);
    }

    public boolean isImage() {
        String t = this.getType();
        return t.startsWith(TYPE_IMAGE_);
    }

    public boolean isRTProperties() {
        String t = this.getType();
        return t.startsWith(TYPE_RTPROPS);
    }

    public String getProperties() {
        String v = (String)this.getFieldValue(FLD_properties);
        return StringTools.trim((String)v);
    }

    public void setProperties(String v) {
        this._setProperties(v);
        this.rtProps = null;
    }

    protected void _setProperties(String v) {
        this.setFieldValue(FLD_properties, StringTools.trim((String)v));
    }

    public void setRTProperties(RTProperties v) {
        this._setProperties(v != null ? v.toString() : "");
        this.rtProps = null;
    }

    public RTProperties getRTProperties() {
        if (this.rtProps == null) {
            this.rtProps = this._getRTProperties();
            this.rtProps.addChangeListener(new RTProperties.PropertyChangeListener(){

                public void propertyChange(RTProperties.PropertyChangeEvent pce) {
                    Resource.this._setProperties(Resource.this.rtProps.toString());
                }
            });
        }
        return this.rtProps;
    }

    public RTProperties _getRTProperties() {
        RTProperties rtp = new RTProperties();
        rtp.setProperties(this.getProperties(), false);
        return rtp;
    }

    public String getProperty(String key, String dft) {
        return this.getRTProperties().getString(key, dft);
    }

    public int getProperty(String key, int dft) {
        return this.getRTProperties().getInt(key, dft);
    }

    public long getProperty(String key, long dft) {
        return this.getRTProperties().getLong(key, dft);
    }

    public double getProperty(String key, double dft) {
        return this.getRTProperties().getDouble(key, dft);
    }

    public Dimension getDimension(int dftWidth, int dftHeight) {
        int w = this.getProperty(PROP_WIDTH, dftWidth);
        int h = this.getProperty(PROP_HEIGHT, dftHeight);
        return new Dimension(w, h);
    }

    public String getIconURL(String dft) {
        return this.getProperty(PROP_ICON_URL, dft);
    }

    public Dimension getIconDimension(int dftWidth, int dftHeight) {
        int w = this.getProperty(PROP_ICON_WIDTH, dftWidth);
        int h = this.getProperty(PROP_ICON_HEIGHT, dftHeight);
        return new Dimension(w, h);
    }

    public byte[] getValue() {
        byte[] v = (byte[])this.getFieldValue(FLD_value);
        return v != null ? v : new byte[]{};
    }

    public void setValue(byte[] v) {
        this.setFieldValue(FLD_value, v != null ? v : new byte[]{});
    }

    public void setValue(Object v) {
        if (v == null) {
            this.setValue(null);
        } else if (v instanceof byte[]) {
            this.setValue((byte[])v);
        } else if (v instanceof String) {
            this.setValue(StringTools.getBytes((String)((String)v)));
        } else {
            this.setValue(StringTools.getBytes((String)v.toString()));
        }
    }

    public void setStringValue(String v) {
        this.setValue(StringTools.getBytes((String)v));
    }

    public String getStringValue() {
        byte[] v = this.getValue();
        if (this.isBinaryType()) {
            return "0x" + StringTools.toHexString((byte[])v);
        }
        if (this.isRTProperties()) {
            return this.getProperties();
        }
        return StringTools.toStringValue((byte[])v);
    }

    public void setCreationDefaultValues() {
        this.setDescription("Resource Text");
        this.setType(TYPE_TEXT);
        this.setStringValue("");
        super.setRuntimeDefaultValues();
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getResourceID();
    }

    public static boolean exists(String acctID, String resID) throws DBException {
        if (acctID != null && resID != null) {
            Key resKey = new Key(acctID, resID);
            return resKey.exists();
        }
        return false;
    }

    protected static Resource _getResource(String acctID, String resID) throws DBException {
        if (acctID != null && resID != null) {
            Key key = new Key(acctID, resID);
            if (key.exists()) {
                Resource res = (Resource)key.getDBRecord(true);
                return res;
            }
            return null;
        }
        return null;
    }

    public static Resource getResource(Account account, String resID) throws DBException {
        if (account != null) {
            String acctID = account.getAccountID();
            Resource res = Resource._getResource(acctID, resID);
            if (res != null) {
                res.setAccount(account);
                return res;
            }
            return null;
        }
        return null;
    }

    public static Object getGlobalResourceValue(String resID) throws DBException {
        String sysAdminID = AccountRecord.getSystemAdminAccountID();
        Resource res = Resource._getResource(sysAdminID, resID);
        if (res != null) {
            if (res.isRTProperties()) {
                return res._getRTProperties();
            }
            if (res.isStringType()) {
                return res.getStringValue();
            }
            return res.getValue();
        }
        return null;
    }

    public static Resource getResource(Account account, String resID, boolean create) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String acctID = account.getAccountID();
        Resource res = Resource._getResource(acctID, resID, create);
        res.setAccount(account);
        return res;
    }

    protected static Resource _getResource(String acctID, String resID, boolean create) throws DBException {
        if (acctID == null) {
            throw new DBNotFoundException("Account-ID not specified");
        }
        if (resID == null) {
            throw new DBNotFoundException("Resource-ID not specified for account: " + acctID);
        }
        Resource res = null;
        Key resKey = new Key(acctID, resID);
        if (!resKey.exists()) {
            if (create) {
                res = (Resource)resKey.getDBRecord();
                res.setCreationDefaultValues();
                return res;
            }
            throw new DBNotFoundException("Resource-ID does not exists: " + (Object)((Object)resKey));
        }
        if (create) {
            throw new DBAlreadyExistsException("Resource-ID already exists '" + (Object)((Object)resKey) + "'");
        }
        res = Resource._getResource(acctID, resID);
        if (res == null) {
            throw new DBException("Unable to read existing Resource-ID: " + (Object)((Object)resKey));
        }
        return res;
    }

    public static Resource createNewResource(Account account, String resID) throws DBException {
        if (account != null && !StringTools.isBlank((String)resID)) {
            Resource res = Resource.getResource(account, resID, true);
            res.save();
            return res;
        }
        throw new DBException("Invalid Account/ResourceID specified");
    }

    public static boolean setResource(Account account, String resID, String type, String desc, Object value) throws DBException {
        if (account == null) {
            throw new DBException("Account not specified");
        }
        String acctID = account.getAccountID();
        return Resource._setResource(acctID, resID, type, desc, value);
    }

    protected static boolean _setResource(String acctID, String resID, String type, String desc, Object value) throws DBException {
        if (StringTools.isBlank((String)resID)) {
            throw new DBException("Invalid ResourceID specified for Account: " + acctID);
        }
        boolean exists = Resource.exists(acctID, resID);
        Resource res = Resource._getResource(acctID, resID, !exists);
        if (type != null) {
            res.setType(type);
        }
        if (desc != null) {
            res.setTitle(desc);
        }
        if (value instanceof RTProperties) {
            res.setRTProperties((RTProperties)value);
        } else {
            res.setValue(value);
        }
        res.save();
        return exists;
    }

    public static boolean setGlobalResourceValue(String resID, String type, String desc, Object value) throws DBException {
        String sysAdminID = AccountRecord.getSystemAdminAccountID();
        return Resource._setResource(sysAdminID, resID, type, desc, value);
    }

    public static OrderedSet<String> getResourcesForAccount(String acctId, String startsWith) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return new OrderedSet();
        }
        DBSelect dsel = new DBSelect(Resource.getFactory());
        dsel.setSelectedFields(new String[]{FLD_resourceID});
        dsel.setOrderByFields(new String[]{FLD_resourceID});
        DBWhere dwh = dsel.createDBWhere();
        if (StringTools.isBlank((String)startsWith)) {
            dsel.setWhere(dwh.WHERE(dwh.EQ("accountID", (Object)acctId)));
        } else {
            dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.STARTSWITH(FLD_resourceID, startsWith))));
        }
        return Resource.getResources((DBSelect<Resource>)dsel);
    }

    public static OrderedSet<String> getResources(DBSelect<Resource> dsel) throws DBException {
        OrderedSet resourceList = new OrderedSet(true);
        if (dsel == null) {
            return resourceList;
        }
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String resourceId = rs.getString(FLD_resourceID);
                resourceList.add((Object)resourceId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting Account Resource List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return resourceList;
    }

    private static void MoveProperty(RTProperties rtProps, String fromKey, String toKey) {
        if (rtProps.hasProperty((Object)fromKey)) {
            rtProps.setString(toKey, rtProps.getString(fromKey, ""));
            rtProps.removeProperty((Object)fromKey);
        }
    }

    public static RTProperties getPrivateLabelPropertiesForHost(String hostName, String urlPath) {
        String sysAdminID = AccountRecord.getSystemAdminAccountID();
        if (!StringTools.isBlank((String)hostName) && !StringTools.isBlank((String)sysAdminID)) {
            Resource res = null;
            if (res == null && !StringTools.isBlank((String)urlPath)) {
                String resPathKey = RESID_PrivateLabel_Properties_ + hostName + urlPath;
                try {
                    res = Resource._getResource(sysAdminID, resPathKey);
                }
                catch (DBException dbe) {
                    Print.logException((String)("Error loading Resource: " + sysAdminID + "/" + resPathKey), (Throwable)dbe);
                }
            }
            if (res == null) {
                String resKey = RESID_PrivateLabel_Properties_ + hostName;
                try {
                    res = Resource._getResource(sysAdminID, resKey);
                }
                catch (DBException dbe) {
                    Print.logException((String)("Error loading Resource: " + sysAdminID + "/" + resKey), (Throwable)dbe);
                }
            }
            if (res != null) {
                byte[] value;
                RTProperties rtProps = new RTProperties();
                String props = res.getProperties();
                if (props != null) {
                    rtProps.setProperties(props, false);
                }
                if ((value = res.getValue()).length > 0) {
                    rtProps.setProperties(StringTools.toStringValue((byte[])value), false);
                }
                return rtProps;
            }
        }
        return null;
    }

    private static String _fmtResID(String acctID, String resID) {
        return acctID + "/" + resID;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + Resource.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Acount ID which owns Resource", (Object[])new Object[0]);
        Print.logInfo((String)"  -resource=<id>  Resource ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new Resource", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           Edit an existing (or newly created) Resource", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified Resource", (Object[])new Object[0]);
        Print.logInfo((String)"  -list           List account Resources", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String resID = RTConfig.getString((String[])ARG_RESOURCE, (String)"");
        if (StringTools.isBlank((String)acctID)) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            Resource.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(acctID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                Resource.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (StringTools.isBlank((String)resID)) {
            // empty if block
        }
        boolean resourceExists = false;
        try {
            resourceExists = Resource.exists(acctID, resID);
        }
        catch (DBException dbe) {
            Print.logError((String)("Error determining if Resource exists: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !acctID.equals("") && !resID.equals("")) {
            ++opts;
            if (!resourceExists) {
                Print.logWarn((String)("Resource does not exist: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key strKey = new Key(acctID, resID);
                strKey.delete(true);
                Print.logInfo((String)("Resource deleted: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
                resourceExists = false;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting Resource: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (resourceExists) {
                Print.logWarn((String)("Resource already exists: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
            } else {
                try {
                    Resource.createNewResource(acct, resID);
                    Print.logInfo((String)("Created Resource: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
                    resourceExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating Resource: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false)) {
            ++opts;
            if (!resourceExists) {
                Print.logError((String)("Resource does not exist: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
            } else {
                try {
                    Resource str = Resource.getResource(acct, resID, false);
                    DBEdit editor = new DBEdit((DBRecord)str);
                    editor.edit(true);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing Resource: " + Resource._fmtResID(acctID, resID)), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            String regex = RTConfig.getString((String[])ARG_LIST, (String)"").toLowerCase();
            ++opts;
            try {
                OrderedSet<String> keyList = Resource.getResourcesForAccount(acctID, null);
                for (String resKey : keyList) {
                    Resource res;
                    if (!StringTools.isBlank((String)regex) && resKey.indexOf(regex) < 0 && !StringTools.regexMatches((String)resKey, (String)regex) || (res = Resource._getResource(acctID, resKey)) == null) continue;
                    String v = res.getStringValue();
                    Print.sysPrintln((String)(resKey + "=" + v), (Object[])new Object[0]);
                }
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logException((String)"Listing Resources", (Throwable)dbe);
                System.exit(99);
            }
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            Resource.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<Resource> {
        public Key() {
        }

        public Key(String acctId, String strKey) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue(Resource.FLD_resourceID, (Object)(strKey != null ? strKey.toLowerCase() : ""));
        }

        public DBFactory<Resource> getFactory() {
            return Resource.getFactory();
        }
    }

    public static class Dimension {
        public int width = 0;
        public int height = 0;

        public Dimension(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

