/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.UserRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.I18N;
import org.opengts.util.StringTools;

public class GroupList
extends UserRecord<GroupList> {
    public static final String _TABLE_NAME = "GroupList";
    public static final String FLD_userID = "userID";
    public static final String FLD_groupID = "groupID";
    private static DBField[] FieldInfo = new DBField[]{GroupList.newField_accountID(true), GroupList.newField_userID(true), new DBField("groupID", String.class, DBField.TYPE_GROUP_ID(), "Device Group ID", "key=true"), GroupList.newField_creationTime()};
    private static DBFactory<GroupList> factory = null;

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<GroupList> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)GroupList.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, GroupList.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(User.TABLE_NAME());
            factory.addParentTable(DeviceGroup.TABLE_NAME());
        }
        return factory;
    }

    public GroupList() {
    }

    public GroupList(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(GroupList.class, (Locale)loc);
        return i18n.getString("GroupList.description", "This table defines the authorized Groups that can be accessed by a given User.");
    }

    public String getGroupID() {
        String v = (String)this.getFieldValue(FLD_groupID);
        return StringTools.trim((String)v);
    }

    private void setGroupID(String v) {
        this.setFieldValue(FLD_groupID, StringTools.trim((String)v));
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getUserID() + "/" + this.getGroupID();
    }

    public void setCreationDefaultValues() {
    }

    public static boolean exists(String acctID, String userID, String groupID) throws DBException {
        if (acctID != null && userID != null && groupID != null) {
            Key grpListKey = new Key(acctID, userID, groupID);
            return grpListKey.exists();
        }
        return false;
    }

    public static GroupList getGroupList(User user, String groupID, boolean createOK) throws DBException {
        if (user == null) {
            throw new DBException("User not specified.");
        }
        String accountID = user.getAccountID();
        String userID = user.getUserID();
        if (StringTools.isBlank((String)groupID)) {
            throw new DBException("DeviceGroup ID not specified.");
        }
        if (!DeviceGroup.exists(accountID, groupID)) {
            throw new DBException("DeviceGroup does not exist: " + accountID + "/" + groupID);
        }
        Key grpListKey = new Key(accountID, userID, groupID);
        if (grpListKey.exists()) {
            GroupList listItem = (GroupList)grpListKey.getDBRecord(true);
            listItem.setUser(user);
            return listItem;
        }
        if (createOK) {
            GroupList listItem = (GroupList)grpListKey.getDBRecord();
            listItem.setCreationDefaultValues();
            listItem.setUser(user);
            return listItem;
        }
        return null;
    }

    protected static DBSelect _getUserListSelect(String acctId, String groupId) {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)groupId)) {
            return null;
        }
        DBSelect dsel = new DBSelect(GroupList.getFactory());
        dsel.setSelectedFields(new String[]{FLD_userID});
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ(FLD_groupID, (Object)groupId))));
        dsel.setOrderByFields(new String[]{FLD_userID});
        return dsel;
    }

    public static List<String> getUsersForGroup(String acctId, String groupId) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)groupId)) {
            return null;
        }
        DBSelect dsel = GroupList._getUserListSelect(acctId, groupId);
        if (dsel == null) {
            return null;
        }
        Vector<String> usrList = new Vector<String>();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String usrId = rs.getString(FLD_userID);
                usrList.add(usrId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Get Group GroupeList", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return usrList;
    }

    public static class Key
    extends UserRecord.UserKey<GroupList> {
        public Key() {
        }

        public Key(String accountId, String userId, String groupId) {
            super.setKeyValue("accountID", (Object)(accountId != null ? accountId.toLowerCase() : ""));
            super.setKeyValue(GroupList.FLD_userID, (Object)(userId != null ? userId.toLowerCase() : ""));
            super.setKeyValue(GroupList.FLD_groupID, (Object)(groupId != null ? groupId.toLowerCase() : ""));
        }

        public DBFactory<GroupList> getFactory() {
            return GroupList.getFactory();
        }
    }
}

