/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.ColorTools;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.FileTools;
import org.opengts.util.GeoBounds;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.GeoPolygon;
import org.opengts.util.GeozoneChecker;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedSet;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Geozone
extends AccountRecord<Geozone> {
    private static final boolean USE_BOUNDING_BOX = true;
    private static final boolean ALWAYS_UPDATE_BOUNDS = true;
    public static final double MIN_RADIUS_METERS = 5.0;
    public static final double MAX_RADIUS_METERS = 30000.0;
    public static final double CLIENT_RADIUS_DELTA_METERS = 7.0;
    public static final double CLIENT_GEOPOINT_DELTA = 7.0E-5;
    public static final String _TABLE_NAME = "Geozone";
    public static final String FLD_geozoneID = "geozoneID";
    public static final String FLD_sortID = "sortID";
    public static final String FLD_minLatitude = "minLatitude";
    public static final String FLD_maxLatitude = "maxLatitude";
    public static final String FLD_minLongitude = "minLongitude";
    public static final String FLD_maxLongitude = "maxLongitude";
    public static final String FLD_zonePurposeID = "zonePurposeID";
    public static final String FLD_reverseGeocode = "reverseGeocode";
    public static final String FLD_arrivalZone = "arrivalZone";
    public static final String FLD_departureZone = "departureZone";
    public static final String FLD_autoNotify = "autoNotify";
    public static final String FLD_zoomRegion = "zoomRegion";
    public static final String FLD_shapeColor = "shapeColor";
    public static final String FLD_zoneType = "zoneType";
    public static final String FLD_radius = "radius";
    public static final String FLD_latitude1 = "latitude1";
    public static final String FLD_longitude1 = "longitude1";
    public static final String FLD_latitude2 = "latitude2";
    public static final String FLD_longitude2 = "longitude2";
    public static final String FLD_latitude3 = "latitude3";
    public static final String FLD_longitude3 = "longitude3";
    public static final String FLD_latitude4 = "latitude4";
    public static final String FLD_longitude4 = "longitude4";
    public static final String FLD_latitude5 = "latitude5";
    public static final String FLD_longitude5 = "longitude5";
    public static final String FLD_latitude6 = "latitude6";
    public static final String FLD_longitude6 = "longitude6";
    public static final String FLD_latitude7 = "latitude7";
    public static final String FLD_longitude7 = "longitude7";
    public static final String FLD_latitude8 = "latitude8";
    public static final String FLD_longitude8 = "longitude8";
    public static final String FLD_latitude9 = "latitude9";
    public static final String FLD_longitude9 = "longitude9";
    public static final String FLD_latitude10 = "latitude10";
    public static final String FLD_longitude10 = "longitude10";
    public static final String FLD_clientUpload = "clientUpload";
    public static final String FLD_clientID = "clientID";
    public static final String FLD_groupID = "groupID";
    public static final String FLD_streetAddress = "streetAddress";
    public static final String FLD_city = "city";
    public static final String FLD_stateProvince = "stateProvince";
    public static final String FLD_postalCode = "postalCode";
    public static final String FLD_country = "country";
    public static final String FLD_subdivision = "subdivision";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID(true, "export=true"), new DBField("geozoneID", String.class, DBField.TYPE_ZONE_ID(), "Geozone ID", "key=true export=true"), new DBField("sortID", Integer.TYPE, "UINT32", "Sort ID", "key=true export=true"), new DBField("minLatitude", Double.TYPE, "DOUBLE", "Min Latitude", "edit=2 altkey=bounds format=#0.00000"), new DBField("maxLatitude", Double.TYPE, "DOUBLE", "Max Latitude", "edit=2 altkey=bounds format=#0.00000"), new DBField("minLongitude", Double.TYPE, "DOUBLE", "Min Longitude", "edit=2 altkey=bounds format=#0.00000"), new DBField("maxLongitude", Double.TYPE, "DOUBLE", "Max Longitude", "edit=2 altkey=bounds format=#0.00000"), new DBField("zonePurposeID", String.class, DBField.TYPE_ID(), "Purpose ID", "edit=2"), new DBField("reverseGeocode", Boolean.TYPE, "BOOLEAN", "Reverse geocode", "edit=2 export=true"), new DBField("arrivalZone", Boolean.TYPE, "BOOLEAN", "Arrival Zone", "edit=2 export=true"), new DBField("departureZone", Boolean.TYPE, "BOOLEAN", "Departure Zone", "edit=2 export=true"), new DBField("autoNotify", Boolean.TYPE, "BOOLEAN", "Auto Notify", "edit=2 export=true"), new DBField("zoomRegion", Boolean.TYPE, "BOOLEAN", "Zoom Region", "edit=2 export=true"), new DBField("shapeColor", String.class, DBField.TYPE_STRING((int)12), "Shape Color", "edit=2 export=true"), new DBField("zoneType", Integer.TYPE, "UINT8", "Zone Type", "edit=2 enum=Geozone$GeozoneType export=true"), new DBField("radius", Integer.TYPE, "UINT32", "Radius Meters", "edit=2 export=true"), new DBField("latitude1", Double.TYPE, "DOUBLE", "Latitude 1", "edit=2 format=#0.00000 export=true"), new DBField("longitude1", Double.TYPE, "DOUBLE", "Longitude 1", "edit=2 format=#0.00000 export=true"), new DBField("latitude2", Double.TYPE, "DOUBLE", "Latitude 2", "edit=2 format=#0.00000 export=true"), new DBField("longitude2", Double.TYPE, "DOUBLE", "Longitude 2", "edit=2 format=#0.00000 export=true"), new DBField("latitude3", Double.TYPE, "DOUBLE", "Latitude 3", "edit=2 format=#0.00000 export=true"), new DBField("longitude3", Double.TYPE, "DOUBLE", "Longitude 3", "edit=2 format=#0.00000 export=true"), new DBField("latitude4", Double.TYPE, "DOUBLE", "Latitude 4", "edit=2 format=#0.00000 export=true"), new DBField("longitude4", Double.TYPE, "DOUBLE", "Longitude 4", "edit=2 format=#0.00000 export=true"), new DBField("latitude5", Double.TYPE, "DOUBLE", "Latitude 5", "edit=2 format=#0.00000 export=true"), new DBField("longitude5", Double.TYPE, "DOUBLE", "Longitude 5", "edit=2 format=#0.00000 export=true"), new DBField("latitude6", Double.TYPE, "DOUBLE", "Latitude 6", "edit=2 format=#0.00000 export=true"), new DBField("longitude6", Double.TYPE, "DOUBLE", "Longitude 6", "edit=2 format=#0.00000 export=true"), new DBField("latitude7", Double.TYPE, "DOUBLE", "Latitude 7", "edit=2 format=#0.00000 export=true"), new DBField("longitude7", Double.TYPE, "DOUBLE", "Longitude 7", "edit=2 format=#0.00000 export=true"), new DBField("latitude8", Double.TYPE, "DOUBLE", "Latitude 8", "edit=2 format=#0.00000 export=true"), new DBField("longitude8", Double.TYPE, "DOUBLE", "Longitude 8", "edit=2 format=#0.00000 export=true"), new DBField("latitude9", Double.TYPE, "DOUBLE", "Latitude 9", "edit=2 format=#0.00000 export=true"), new DBField("longitude9", Double.TYPE, "DOUBLE", "Longitude 9", "edit=2 format=#0.00000 export=true"), new DBField("latitude10", Double.TYPE, "DOUBLE", "Latitude 10", "edit=2 format=#0.00000 export=true"), new DBField("longitude10", Double.TYPE, "DOUBLE", "Longitude 10", "edit=2 format=#0.00000 export=true"), new DBField("clientUpload", Boolean.TYPE, "BOOLEAN", "Client Upload", "edit=2"), new DBField("clientID", Integer.TYPE, "UINT32", "Client ID", "edit=2 altkey=true"), new DBField("groupID", String.class, DBField.TYPE_GROUP_ID(), "DeviceGroup", "edit=2"), new DBField("streetAddress", String.class, DBField.TYPE_STRING((int)90), "Street Address", "edit=2 utf8=true export=true"), new DBField("city", String.class, DBField.TYPE_STRING((int)40), "City", "edit=2 utf8=true export=true"), new DBField("stateProvince", String.class, DBField.TYPE_STRING((int)40), "State/Province", "edit=2 utf8=true export=true"), new DBField("postalCode", String.class, DBField.TYPE_STRING((int)16), "Postal Code", "edit=2 utf8=true export=true"), new DBField("country", String.class, DBField.TYPE_STRING((int)40), "Country", "edit=2 utf8=true export=true"), new DBField("subdivision", String.class, DBField.TYPE_STRING((int)32), "Subdivision", "edit=2 utf8=true export=true"), Geozone.newField_displayName("export=true"), Geozone.newField_description((String)"export=true"), Geozone.newField_lastUpdateTime(), Geozone.newField_lastUpdateUser((boolean)true), Geozone.newField_creationTime()};
    public static final String FLD_priority = "priority";
    public static final String FLD_speedLimitKPH = "speedLimitKPH";
    public static final DBField[] PriorityFieldInfo = new DBField[]{new DBField("priority", Integer.TYPE, "UINT32", "Priority", "edit=2 altkey=priority export=true"), new DBField("speedLimitKPH", Double.TYPE, "DOUBLE", "Speed Limit", "format=#0.0 units=speed")};
    public static final String FLD_corrStartSelector = "corrStartSelector";
    public static final String FLD_corrEndSelector = "corrEndSelector";
    public static final String FLD_corridorID = "corridorID";
    public static final DBField[] CorridorFieldInfo = new DBField[]{new DBField("corridorID", String.class, DBField.TYPE_CORR_ID(), "Corridor ID", "edit=2"), new DBField("corrStartSelector", String.class, "TEXT", "Corridor Start Select", "edit=2"), new DBField("corrEndSelector", String.class, "TEXT", "Corridor End Select", "edit=2")};
    private static DBFactory<Geozone> factory = null;
    private static String[][] GeoPointFields = new String[][]{{"latitude1", "longitude1"}, {"latitude2", "longitude2"}, {"latitude3", "longitude3"}, {"latitude4", "longitude4"}, {"latitude5", "longitude5"}, {"latitude6", "longitude6"}, {"latitude7", "longitude7"}, {"latitude8", "longitude8"}, {"latitude9", "longitude9"}, {"latitude10", "longitude10"}};
    private static GeozoneChecker geozoneMultiPointRadius = null;
    private static GeozoneChecker geozoneSweptPointRadius = null;
    private static GeozoneChecker geozoneBoundedRectangle = null;
    private static GeozoneChecker geozonePolygon = null;
    private boolean zoneChanged = false;
    private static final String CSV_EXT = ".csv";
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_GEOZONE = new String[]{"geozone", "zone"};
    private static final String[] ARG_GEOPOINT = new String[]{"geopoint", "gp"};
    private static final String[] ARG_SORT = new String[]{"sort"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_EDITALL = new String[]{"editall", "eda"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_DMTPCSV = new String[]{"dmtpcsv"};
    private static final String[] ARG_EXPORT = new String[]{"export"};
    private static final String[] ARG_DUMP = new String[]{"dump"};
    private static final String[] ARG_LOAD = new String[]{"load"};
    private static final String[] ARG_VALIDATE = new String[]{"validate"};
    private static final String[] ARG_TEST = new String[]{"test"};
    private static final String[] ARG_EVTEST = new String[]{"evtest"};
    private static final String[] ARG_UPDATE = new String[]{"update"};

    public static GeozoneType getGeozoneType(Geozone z) {
        return z != null ? (GeozoneType)EnumTools.getValueOf(GeozoneType.class, (int)z.getZoneType()) : (GeozoneType)EnumTools.getDefault(GeozoneType.class);
    }

    public static GeozoneType getGeozoneType(int zt) {
        return (GeozoneType)EnumTools.getValueOf(GeozoneType.class, (int)zt);
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Geozone> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Geozone.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Geozone.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            Geozone._initZoneTypes();
        }
        return factory;
    }

    public Geozone() {
    }

    public Geozone(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Geozone.class, (Locale)loc);
        return i18n.getString("Geozone.description", "This table defines Account specific geozones/geofences.");
    }

    public String getGeozoneID() {
        String v = (String)this.getFieldValue(FLD_geozoneID);
        return StringTools.trim((String)v);
    }

    public void setGeozoneID(String v) {
        this.setFieldValue(FLD_geozoneID, StringTools.trim((String)v));
    }

    public int getSortID() {
        Integer v = (Integer)this.getFieldValue(FLD_sortID);
        return v != null ? v : 0;
    }

    public void setSortID(int v) {
        this.setFieldValue(FLD_sortID, v);
    }

    public static boolean supportsPriority() {
        return Geozone.getFactory().hasField(FLD_priority);
    }

    public int getPriority() {
        Integer v = (Integer)this.getFieldValue(FLD_priority);
        return v != null ? v : 0;
    }

    public void setPriority(int v) {
        this.setFieldValue(FLD_priority, v);
    }

    public static boolean supportsSpeedLimitKPH() {
        return Geozone.getFactory().hasField(FLD_speedLimitKPH);
    }

    public double getSpeedLimitKPH() {
        return this.getFieldValue(FLD_speedLimitKPH, 0.0);
    }

    public void setSpeedLimitKPH(double v) {
        this.setFieldValue(FLD_speedLimitKPH, v > 0.0 ? v : 0.0);
    }

    public double getMinLatitude() {
        Double v = (Double)this.getFieldValue(FLD_minLatitude);
        return v != null ? v : 0.0;
    }

    public void setMinLatitude(double v) {
        this.setFieldValue(FLD_minLatitude, v);
    }

    public double getMaxLatitude() {
        Double v = (Double)this.getFieldValue(FLD_maxLatitude);
        return v != null ? v : 0.0;
    }

    public void setMaxLatitude(double v) {
        this.setFieldValue(FLD_maxLatitude, v);
    }

    public double getMinLongitude() {
        Double v = (Double)this.getFieldValue(FLD_minLongitude);
        return v != null ? v : 0.0;
    }

    public void setMinLongitude(double v) {
        this.setFieldValue(FLD_minLongitude, v);
    }

    public double getMaxLongitude() {
        Double v = (Double)this.getFieldValue(FLD_maxLongitude);
        return v != null ? v : 0.0;
    }

    public void setMaxLongitude(double v) {
        this.setFieldValue(FLD_maxLongitude, v);
    }

    public GeoPoint getCenterGeoPoint() {
        GeoBounds bounds = this.getBoundingBox();
        return bounds.getCenter();
    }

    public int getZoneType() {
        Integer v = (Integer)this.getFieldValue(FLD_zoneType);
        return v != null ? v.intValue() : ((GeozoneType)EnumTools.getDefault(GeozoneType.class)).getIntValue();
    }

    public void setZoneType(int v) {
        this.setFieldValue(FLD_zoneType, ((GeozoneType)EnumTools.getValueOf(GeozoneType.class, (int)v)).getIntValue());
    }

    public void setZoneType(GeozoneType v) {
        this.setFieldValue(FLD_zoneType, ((GeozoneType)EnumTools.getValueOf(GeozoneType.class, (Enum)v)).getIntValue());
    }

    public void setZoneType(String v, Locale locale) {
        this.setFieldValue(FLD_zoneType, ((GeozoneType)EnumTools.getValueOf(GeozoneType.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getZoneTypeDescription(Locale loc) {
        return Geozone.getGeozoneType(this).toString(loc);
    }

    public boolean hasRadius() {
        return Geozone.getGeozoneType(this).hasRadius();
    }

    public double getRadiusMeters() {
        return this.getRadius();
    }

    public double getRadiusMeters(double minValue, double maxValue) {
        double radM = this.getRadius();
        if (minValue >= 0.0 && radM < minValue) {
            return minValue;
        }
        if (maxValue >= 0.0 && radM > maxValue) {
            return maxValue;
        }
        return radM;
    }

    public double getRadiusKilometers() {
        return (double)this.getRadius() / 1000.0;
    }

    public int getRadius() {
        Integer v = (Integer)this.getFieldValue(FLD_radius);
        return v != null ? v : 0;
    }

    public void setRadius(int v) {
        this.setFieldValue(FLD_radius, v);
        this.setZoneChanged();
    }

    public void setDefaultRadius() {
        int gzType = this.getZoneType();
        if (gzType == GeozoneType.POINT_RADIUS.getIntValue()) {
            int radM = RTConfig.getInt((String)"Geozone.dftRadius.pointRadius", (int)3000);
            this.setRadius(radM);
        } else if (gzType == GeozoneType.POLYGON.getIntValue()) {
            int radM = RTConfig.getInt((String)"Geozone.dftRadius.polygon", (int)500);
            this.setRadius(radM);
        } else if (gzType == GeozoneType.SWEPT_POINT_RADIUS.getIntValue()) {
            int radM = RTConfig.getInt((String)"Geozone.dftRadius.sweptPointRadius", (int)1000);
            this.setRadius(1000);
        } else {
            int radM = RTConfig.getInt((String)"Geozone.dftRadius.pointRadius", (int)3000);
            this.setRadius(radM);
        }
    }

    public String getShapeColor(String dftColor) {
        String color = this.getShapeColor();
        if (!StringTools.isBlank((String)color)) {
            if (!ColorTools.isColor((String)color)) {
                Print.logError((String)("Invalid Color value: " + color), (Object[])new Object[0]);
            }
            return color;
        }
        if (!StringTools.isBlank((String)dftColor) && !ColorTools.isColor((String)dftColor)) {
            Print.logError((String)("Invalid Default Color value: " + dftColor), (Object[])new Object[0]);
        }
        return dftColor;
    }

    public String getShapeColor() {
        String v = (String)this.getFieldValue(FLD_shapeColor);
        return StringTools.trim((String)v);
    }

    public void setShapeColor(String v) {
        this.setFieldValue(FLD_shapeColor, StringTools.trim((String)v));
    }

    public double getNorthLatitude() {
        double lat2;
        double lat1 = this.getLatitude1();
        return lat1 >= (lat2 = this.getLatitude2()) ? lat1 : lat2;
    }

    public double getSouthLatitude() {
        double lat2;
        double lat1 = this.getLatitude1();
        return lat1 <= (lat2 = this.getLatitude2()) ? lat1 : lat2;
    }

    public double getWestLongitude() {
        double lon2;
        double lon1 = this.getLongitude1();
        return lon1 <= (lon2 = this.getLongitude2()) ? lon1 : lon2;
    }

    public double getEastLongitude() {
        double lon2;
        double lon1 = this.getLongitude1();
        return lon1 >= (lon2 = this.getLongitude2()) ? lon1 : lon2;
    }

    public double getLatitude1() {
        Double v = (Double)this.getFieldValue(FLD_latitude1);
        return v != null ? v : 0.0;
    }

    public void setLatitude1(double v) {
        this.setFieldValue(FLD_latitude1, v);
        this.setZoneChanged();
    }

    public double getLongitude1() {
        Double v = (Double)this.getFieldValue(FLD_longitude1);
        return v != null ? v : 0.0;
    }

    public void setLongitude1(double v) {
        this.setFieldValue(FLD_longitude1, v);
        this.setZoneChanged();
    }

    public GeoPoint getGeoPoint1() {
        return new GeoPoint(this.getLatitude1(), this.getLongitude1());
    }

    public void setGeoPoint1(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude1(gp.getLatitude());
            this.setLongitude1(gp.getLongitude());
        } else {
            this.setLatitude1(0.0);
            this.setLongitude1(0.0);
        }
    }

    public double getLatitude2() {
        Double v = (Double)this.getFieldValue(FLD_latitude2);
        return v != null ? v : 0.0;
    }

    public void setLatitude2(double v) {
        this.setFieldValue(FLD_latitude2, v);
        this.setZoneChanged();
    }

    public double getLongitude2() {
        Double v = (Double)this.getFieldValue(FLD_longitude2);
        return v != null ? v : 0.0;
    }

    public void setLongitude2(double v) {
        this.setFieldValue(FLD_longitude2, v);
        this.setZoneChanged();
    }

    public GeoPoint getGeoPoint2() {
        return new GeoPoint(this.getLatitude2(), this.getLongitude2());
    }

    public void setGeoPoint2(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude2(gp.getLatitude());
            this.setLongitude2(gp.getLongitude());
        } else {
            this.setLatitude2(0.0);
            this.setLongitude2(0.0);
        }
    }

    public double getLatitude3() {
        Double v = (Double)this.getFieldValue(FLD_latitude3);
        return v != null ? v : 0.0;
    }

    public void setLatitude3(double v) {
        this.setFieldValue(FLD_latitude3, v);
        this.setZoneChanged();
    }

    public double getLongitude3() {
        Double v = (Double)this.getFieldValue(FLD_longitude3);
        return v != null ? v : 0.0;
    }

    public void setLongitude3(double v) {
        this.setFieldValue(FLD_longitude3, v);
        this.setZoneChanged();
    }

    public GeoPoint getGeoPoint3() {
        return new GeoPoint(this.getLatitude3(), this.getLongitude3());
    }

    public void setGeoPoint3(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude3(gp.getLatitude());
            this.setLongitude3(gp.getLongitude());
        } else {
            this.setLatitude3(0.0);
            this.setLongitude3(0.0);
        }
    }

    public double getLatitude4() {
        Double v = (Double)this.getFieldValue(FLD_latitude4);
        return v != null ? v : 0.0;
    }

    public void setLatitude4(double v) {
        this.setFieldValue(FLD_latitude4, v);
        this.setZoneChanged();
    }

    public double getLongitude4() {
        Double v = (Double)this.getFieldValue(FLD_longitude4);
        return v != null ? v : 0.0;
    }

    public void setLongitude4(double v) {
        this.setFieldValue(FLD_longitude4, v);
        this.setZoneChanged();
    }

    public GeoPoint getGeoPoint4() {
        return new GeoPoint(this.getLatitude4(), this.getLongitude4());
    }

    public void setGeoPoint4(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude4(gp.getLatitude());
            this.setLongitude4(gp.getLongitude());
        } else {
            this.setLatitude4(0.0);
            this.setLongitude4(0.0);
        }
    }

    public double getLatitude5() {
        Double v = (Double)this.getFieldValue(FLD_latitude5);
        return v != null ? v : 0.0;
    }

    public void setLatitude5(double v) {
        this.setFieldValue(FLD_latitude5, v);
        this.setZoneChanged();
    }

    public double getLongitude5() {
        Double v = (Double)this.getFieldValue(FLD_longitude5);
        return v != null ? v : 0.0;
    }

    public void setLongitude5(double v) {
        this.setFieldValue(FLD_longitude5, v);
        this.setZoneChanged();
    }

    public GeoPoint getGeoPoint5() {
        return new GeoPoint(this.getLatitude5(), this.getLongitude5());
    }

    public void setGeoPoint5(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude5(gp.getLatitude());
            this.setLongitude5(gp.getLongitude());
        } else {
            this.setLatitude5(0.0);
            this.setLongitude5(0.0);
        }
    }

    public double getLatitude6() {
        Double v = (Double)this.getFieldValue(FLD_latitude6);
        return v != null ? v : 0.0;
    }

    public void setLatitude6(double v) {
        this.setFieldValue(FLD_latitude6, v);
        this.setZoneChanged();
    }

    public double getLongitude6() {
        Double v = (Double)this.getFieldValue(FLD_longitude6);
        return v != null ? v : 0.0;
    }

    public void setLongitude6(double v) {
        this.setFieldValue(FLD_longitude6, v);
        this.setZoneChanged();
    }

    public GeoPoint getGeoPoint6() {
        return new GeoPoint(this.getLatitude6(), this.getLongitude6());
    }

    public void setGeoPoint6(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude6(gp.getLatitude());
            this.setLongitude6(gp.getLongitude());
        } else {
            this.setLatitude6(0.0);
            this.setLongitude6(0.0);
        }
    }

    public double getLatitude7() {
        Double v = (Double)this.getFieldValue(FLD_latitude7);
        return v != null ? v : 0.0;
    }

    public void setLatitude7(double v) {
        this.setFieldValue(FLD_latitude7, v);
        this.setZoneChanged();
    }

    public double getLongitude7() {
        Double v = (Double)this.getFieldValue(FLD_longitude7);
        return v != null ? v : 0.0;
    }

    public void setLongitude7(double v) {
        this.setFieldValue(FLD_longitude7, v);
        this.setZoneChanged();
    }

    public GeoPoint getGeoPoint7() {
        return new GeoPoint(this.getLatitude7(), this.getLongitude7());
    }

    public void setGeoPoint7(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude7(gp.getLatitude());
            this.setLongitude7(gp.getLongitude());
        } else {
            this.setLatitude7(0.0);
            this.setLongitude7(0.0);
        }
    }

    public double getLatitude8() {
        Double v = (Double)this.getFieldValue(FLD_latitude8);
        return v != null ? v : 0.0;
    }

    public void setLatitude8(double v) {
        this.setFieldValue(FLD_latitude8, v);
        this.setZoneChanged();
    }

    public double getLongitude8() {
        Double v = (Double)this.getFieldValue(FLD_longitude8);
        return v != null ? v : 0.0;
    }

    public void setLongitude8(double v) {
        this.setFieldValue(FLD_longitude8, v);
        this.setZoneChanged();
    }

    public GeoPoint getGeoPoint8() {
        return new GeoPoint(this.getLatitude8(), this.getLongitude8());
    }

    public void setGeoPoint8(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude8(gp.getLatitude());
            this.setLongitude8(gp.getLongitude());
        } else {
            this.setLatitude8(0.0);
            this.setLongitude8(0.0);
        }
    }

    public static int GetGeoPointCount() {
        return GeoPointFields.length;
    }

    public double getLatitude(int ndx) {
        if (ndx >= 0 && ndx < Geozone.GetGeoPointCount()) {
            Double v = (Double)this.getFieldValue(GeoPointFields[ndx][0]);
            return v != null ? v : 0.0;
        }
        return 0.0;
    }

    public void setLatitude(int ndx, double v) {
        if (ndx >= 0 && ndx < Geozone.GetGeoPointCount()) {
            this.setFieldValue(GeoPointFields[ndx][0], v);
            this.setZoneChanged();
        }
    }

    public double getLongitude(int ndx) {
        if (ndx >= 0 && ndx < Geozone.GetGeoPointCount()) {
            Double v = (Double)this.getFieldValue(GeoPointFields[ndx][1]);
            return v != null ? v : 0.0;
        }
        return 0.0;
    }

    public void setLongitude(int ndx, double v) {
        if (ndx >= 0 && ndx < Geozone.GetGeoPointCount()) {
            this.setFieldValue(GeoPointFields[ndx][1], v);
            this.setZoneChanged();
        }
    }

    public GeoPoint getGeoPoint(int ndx) {
        return this.getGeoPoint(ndx, null);
    }

    public GeoPoint getGeoPoint(int ndx, GeoPoint dft) {
        if (ndx >= 0 && ndx < Geozone.GetGeoPointCount()) {
            double lon;
            double lat = this.getLatitude(ndx);
            return GeoPoint.isValid((double)lat, (double)(lon = this.getLongitude(ndx))) ? new GeoPoint(lat, lon) : dft;
        }
        return dft;
    }

    public GeoPoint[] getGeoPoints() {
        Vector<GeoPoint> gpList = new Vector<GeoPoint>();
        int geoCnt = Geozone.GetGeoPointCount();
        for (int i = 0; i < geoCnt; ++i) {
            double lon;
            double lat = this.getLatitude(i);
            if (!GeoPoint.isValid((double)lat, (double)(lon = this.getLongitude(i)))) continue;
            gpList.add(new GeoPoint(lat, lon));
        }
        return gpList.toArray(new GeoPoint[gpList.size()]);
    }

    public void setGeoPoint(int ndx, GeoPoint gp) {
        if (gp != null && gp.isValid()) {
            this.setLatitude(ndx, gp.getLatitude());
            this.setLongitude(ndx, gp.getLongitude());
        } else {
            this.setLatitude(ndx, 0.0);
            this.setLongitude(ndx, 0.0);
        }
    }

    public void setGeoPoint(int ndx, double lat, double lon) {
        if (GeoPoint.isValid((double)lat, (double)lon)) {
            this.setLatitude(ndx, lat);
            this.setLongitude(ndx, lon);
        } else {
            this.setLatitude(ndx, 0.0);
            this.setLongitude(ndx, 0.0);
        }
    }

    public void setGeoPoints(GeoPoint[] gp) {
        int geoCnt = Geozone.GetGeoPointCount();
        for (int i = 0; i < geoCnt; ++i) {
            if (gp != null && i < gp.length) {
                this.setLatitude(i, gp[i].getLatitude());
                this.setLongitude(i, gp[i].getLongitude());
                continue;
            }
            this.setLatitude(i, 0.0);
            this.setLongitude(i, 0.0);
        }
    }

    public void clearGeoPoints() {
        int geoCnt = Geozone.GetGeoPointCount();
        for (int i = 0; i < geoCnt; ++i) {
            this.setLatitude(i, 0.0);
            this.setLongitude(i, 0.0);
        }
    }

    public boolean getClientUpload() {
        Boolean v = (Boolean)this.getFieldValue(FLD_clientUpload);
        return v != null ? v : false;
    }

    public void setClientUpload(boolean v) {
        this.setFieldValue(FLD_clientUpload, v);
    }

    public boolean isClientUpload() {
        return this.getClientUpload();
    }

    public int getClientID() {
        Integer v = (Integer)this.getFieldValue(FLD_clientID);
        return v != null ? v : 0;
    }

    public void setClientID(int v) {
        this.setFieldValue(FLD_clientID, v);
    }

    public String getZonePurposeID() {
        String v = (String)this.getFieldValue(FLD_zonePurposeID);
        return StringTools.trim((String)v);
    }

    public void setZonePurposeID(String v) {
        this.setFieldValue(FLD_zonePurposeID, StringTools.trim((String)v));
    }

    public boolean isZonePurposeID(String v) {
        if (StringTools.isBlank((String)v)) {
            return true;
        }
        String purID = this.getZonePurposeID();
        return v.trim().equalsIgnoreCase(purID);
    }

    public boolean hasGroupID() {
        return !StringTools.isBlank((String)this.getGroupID());
    }

    public String getGroupID() {
        String v = (String)this.getFieldValue(FLD_groupID);
        return StringTools.trim((String)v);
    }

    public void setGroupID(String v) {
        String grp = StringTools.trim((String)v);
        if (grp.equalsIgnoreCase("all")) {
            grp = "";
        }
        this.setFieldValue(FLD_groupID, grp);
    }

    public boolean isDeviceInGroup(String deviceID) {
        String groupID = this.getGroupID();
        if (StringTools.isBlank((String)groupID)) {
            return true;
        }
        if (groupID.equalsIgnoreCase("all")) {
            return true;
        }
        return DeviceGroup.isDeviceInDeviceGroup(this.getAccountID(), groupID, deviceID);
    }

    public static Geozone getFirstGeozoneForDevice(Geozone[] gza, String deviceID) {
        if (!ListTools.isEmpty((Object[])gza)) {
            for (Geozone gz : gza) {
                if (gz == null || !gz.isDeviceInGroup(deviceID)) continue;
                return gz;
            }
        }
        return null;
    }

    public static Geozone getGeozoneForDevice(String acctID, GeoPoint gp, String devID) throws DBException {
        Geozone[] gza = Geozone.getGeozones(acctID, gp);
        if (gza != null && gza.length > 0) {
            Geozone gz = Geozone.getFirstGeozoneForDevice(gza, devID);
            if (gz != null) {
                return gz;
            }
            StringBuffer sb = new StringBuffer();
            for (Geozone g : gza) {
                if (g == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(g.getGeozoneID());
                sb.append("(").append(g.getGroupID()).append(")");
            }
            Print.logWarn((String)("Geozone(s) do not apply to device '" + devID + "': " + sb), (Object[])new Object[0]);
            return null;
        }
        return null;
    }

    public static Geozone getGeozoneForPurpose(String acctID, GeoPoint gp, String purID) throws DBException {
        Geozone[] gza = Geozone.getGeozones(acctID, gp);
        if (ListTools.isEmpty((Object[])gza)) {
            return null;
        }
        if (StringTools.isBlank((String)purID)) {
            return gza[0];
        }
        for (Geozone g : gza) {
            String gzPurID;
            String string = gzPurID = g != null ? g.getZonePurposeID() : "";
            if (!purID.equalsIgnoreCase(gzPurID)) continue;
            return g;
        }
        return null;
    }

    public boolean getReverseGeocode() {
        Boolean v = (Boolean)this.getFieldValue(FLD_reverseGeocode);
        return v != null ? v : false;
    }

    public void setReverseGeocode(boolean v) {
        this.setFieldValue(FLD_reverseGeocode, v);
    }

    public boolean isReverseGeocode(String deviceID) {
        if (!this.getReverseGeocode()) {
            return false;
        }
        if (StringTools.isBlank((String)deviceID)) {
            return true;
        }
        return this.isDeviceInGroup(deviceID);
    }

    public boolean getArrivalZone() {
        Boolean v = (Boolean)this.getFieldValue(FLD_arrivalZone);
        return v != null ? v : false;
    }

    public void setArrivalZone(boolean v) {
        this.setFieldValue(FLD_arrivalZone, v);
    }

    public boolean isArrivalZone(String deviceID) {
        if (!this.getArrivalZone()) {
            return false;
        }
        if (StringTools.isBlank((String)deviceID)) {
            return true;
        }
        return this.isDeviceInGroup(deviceID);
    }

    @Deprecated
    public boolean isArrivalZone() {
        return this.isArrivalZone(null);
    }

    public boolean getDepartureZone() {
        Boolean v = (Boolean)this.getFieldValue(FLD_departureZone);
        return v != null ? v : false;
    }

    public void setDepartureZone(boolean v) {
        this.setFieldValue(FLD_departureZone, v);
    }

    public boolean isDepartureZone(String deviceID) {
        if (!this.getDepartureZone()) {
            return false;
        }
        if (StringTools.isBlank((String)deviceID)) {
            return true;
        }
        return this.isDeviceInGroup(deviceID);
    }

    @Deprecated
    public boolean isDepartureZone() {
        return this.isDepartureZone(null);
    }

    public boolean getAutoNotify() {
        Boolean v = (Boolean)this.getFieldValue(FLD_autoNotify);
        return v != null ? v : false;
    }

    public void setAutoNotify(boolean v) {
        this.setFieldValue(FLD_autoNotify, v);
    }

    public boolean isAutoNotify() {
        return this.getAutoNotify();
    }

    public boolean getZoomRegion() {
        Boolean v = (Boolean)this.getFieldValue(FLD_zoomRegion);
        return v != null ? v : false;
    }

    public void setZoomRegion(boolean v) {
        this.setFieldValue(FLD_zoomRegion, v);
    }

    public boolean isZoomRegion() {
        return this.getZoomRegion();
    }

    public String getStreetAddress() {
        String v = (String)this.getFieldValue(FLD_streetAddress);
        return StringTools.trim((String)v);
    }

    public void setStreetAddress(String v) {
        this.setFieldValue(FLD_streetAddress, StringTools.trim((String)v));
    }

    public String getCity() {
        String v = (String)this.getFieldValue(FLD_city);
        return StringTools.trim((String)v);
    }

    public void setCity(String v) {
        this.setFieldValue(FLD_city, StringTools.trim((String)v));
    }

    public String getStateProvince() {
        String v = (String)this.getFieldValue(FLD_stateProvince);
        return StringTools.trim((String)v);
    }

    public void setStateProvince(String v) {
        this.setFieldValue(FLD_stateProvince, StringTools.trim((String)v));
    }

    public String getPostalCode() {
        String v = (String)this.getFieldValue(FLD_postalCode);
        return StringTools.trim((String)v);
    }

    public void setPostalCode(String v) {
        this.setFieldValue(FLD_postalCode, StringTools.trim((String)v));
    }

    public String getCountry() {
        String v = (String)this.getFieldValue(FLD_country);
        return StringTools.trim((String)v);
    }

    public void setCountry(String v) {
        this.setFieldValue(FLD_country, StringTools.trim((String)v));
    }

    public String getSubdivision() {
        String v = (String)this.getFieldValue(FLD_subdivision);
        return StringTools.trim((String)v);
    }

    public void setSubdivision(String v) {
        this.setFieldValue(FLD_subdivision, StringTools.trim((String)v));
    }

    public static boolean supportsCorridor() {
        return Geozone.getFactory().hasField(FLD_corridorID);
    }

    public String getCorridorID() {
        String v = (String)this.getFieldValue(FLD_corridorID);
        return StringTools.trim((String)v);
    }

    public void setCorridorID(String v) {
        this.setFieldValue(FLD_corridorID, StringTools.trim((String)v));
    }

    public boolean hasCorridorID() {
        return !StringTools.isBlank((String)this.getCorridorID());
    }

    public String getCorrStartSelector() {
        String v = (String)this.getFieldValue(FLD_corrStartSelector);
        return StringTools.trim((String)v);
    }

    public void setCorrStartSelector(boolean v) {
        this.setFieldValue(FLD_corrStartSelector, v);
    }

    public boolean isCorridorStart(EventData ev) {
        if (!this.supportsCorridor()) {
            return false;
        }
        if (ev == null || ev.getStatusCode() != 62000) {
            return false;
        }
        if (!this.hasCorridorID()) {
            return false;
        }
        if (!Device.hasRuleFactory()) {
            String sel = this.getCorrStartSelector();
            return !StringTools.isBlank((String)sel);
        }
        String sel = this.getCorrStartSelector();
        if (StringTools.isBlank((String)sel)) {
            return false;
        }
        RuleFactory rf = Device.getRuleFactory();
        return rf.isSelectorMatch(sel, ev);
    }

    public String getCorrEndSelector() {
        String v = (String)this.getFieldValue(FLD_corrEndSelector);
        return StringTools.trim((String)v);
    }

    public void setCorrEndSelector(boolean v) {
        this.setFieldValue(FLD_corrEndSelector, v);
    }

    public boolean isCorridorEnd(EventData ev) {
        if (!this.supportsCorridor()) {
            return false;
        }
        if (ev == null || ev.getStatusCode() != 61968) {
            return false;
        }
        if (!Device.hasRuleFactory()) {
            String sel = this.getCorrEndSelector();
            return !StringTools.isBlank((String)sel);
        }
        String sel = this.getCorrEndSelector();
        if (StringTools.isBlank((String)sel)) {
            return false;
        }
        RuleFactory rf = Device.getRuleFactory();
        return rf.isSelectorMatch(sel, ev);
    }

    public void setCreationDefaultValues() {
        this.setDescription("Custom Zone");
        this.setReverseGeocode(true);
        this.setArrivalZone(true);
        this.setDepartureZone(true);
        this.setRadius(3000);
        super.setRuntimeDefaultValues();
    }

    private static void _initZoneTypes() {
        StringBuffer sb = new StringBuffer();
        geozoneMultiPointRadius = GeoPoint.getGeozoneChecker();
        sb.append("PointRadius");
        geozonePolygon = GeoPolygon.getGeozoneChecker();
        sb.append(",Polygon");
        geozoneBoundedRectangle = new GeozoneChecker(){

            public boolean containsPoint(GeoPoint gpTest, GeoPoint[] gpList, double radiusKM) {
                if (gpList.length < 2) {
                    return false;
                }
                double latN = -90.0;
                double latS = 90.0;
                double lonW = 180.0;
                double lonE = -180.0;
                for (int i = 0; i < gpList.length; ++i) {
                    double lon;
                    double lat = gpList[i].getLatitude();
                    if (lat > latN) {
                        latN = lat;
                    }
                    if (lat < latS) {
                        latS = lat;
                    }
                    if ((lon = gpList[i].getLongitude()) > lonE) {
                        lonE = lon;
                    }
                    if (!(lon < lonW)) continue;
                    lonW = lon;
                }
                double lat = gpTest.getLatitude();
                double lon = gpTest.getLongitude();
                if (lat > latN + 7.0E-5) {
                    return false;
                }
                if (lat < latS - 7.0E-5) {
                    return false;
                }
                if (lon < lonW - 7.0E-5) {
                    return false;
                }
                return !(lon > lonE + 7.0E-5);
            }
        };
        sb.append(",Rectangle");
        try {
            MethodAction ma = new MethodAction((Object)"org.opengts.rule.util.GeoSegment", "getGeozoneChecker");
            geozoneSweptPointRadius = (GeozoneChecker)ma.invoke();
            sb.append(",SweptPointRadius");
        }
        catch (Throwable th) {
            geozoneSweptPointRadius = null;
        }
    }

    public static boolean IsGeozoneTypeSupported(int type) {
        return Geozone.IsGeozoneTypeSupported(Geozone.getGeozoneType(type));
    }

    public static boolean IsGeozoneTypeSupported(GeozoneType type) {
        switch (type) {
            case POINT_RADIUS: {
                return geozoneMultiPointRadius != null;
            }
            case BOUNDED_RECT: {
                return geozoneBoundedRectangle != null;
            }
            case SWEPT_POINT_RADIUS: {
                return geozoneSweptPointRadius != null;
            }
            case POLYGON: {
                return geozonePolygon != null;
            }
        }
        return false;
    }

    public boolean containsPoint(GeoPoint gp) {
        if (gp == null || !gp.isValid()) {
            return false;
        }
        GeoPoint[] gzPts = this.getGeoPoints();
        switch (Geozone.getGeozoneType(this)) {
            case POINT_RADIUS: {
                double radiusKM = this.getRadiusKilometers();
                if (this.isClientUpload()) {
                    radiusKM += 0.007;
                }
                if (geozoneMultiPointRadius != null) {
                    return geozoneMultiPointRadius.containsPoint(gp, gzPts, radiusKM);
                }
                return false;
            }
            case BOUNDED_RECT: {
                if (geozoneBoundedRectangle != null) {
                    return geozoneBoundedRectangle.containsPoint(gp, gzPts, 0.0);
                }
                return false;
            }
            case POLYGON: {
                if (geozonePolygon != null) {
                    return geozonePolygon.containsPoint(gp, gzPts, 0.0);
                }
                return false;
            }
            case SWEPT_POINT_RADIUS: {
                double radiusKM = this.getRadiusKilometers();
                if (this.isClientUpload()) {
                    radiusKM += 0.007;
                }
                if (geozoneSweptPointRadius != null) {
                    return geozoneSweptPointRadius.containsPoint(gp, gzPts, radiusKM);
                }
                if (geozoneMultiPointRadius != null) {
                    Print.logWarn((String)"GeoSegment not installed, testing with PointRadius ...", (Object[])new Object[0]);
                    return geozoneMultiPointRadius.containsPoint(gp, gzPts, radiusKM);
                }
                return false;
            }
        }
        Print.logError((String)("Unrecognized Geozone type: " + this.getZoneType()), (Object[])new Object[0]);
        return false;
    }

    public boolean encodeDMTPZone(Payload payload, int ptCnt, boolean hiRes) {
        int writeLen;
        int n = writeLen = hiRes ? 22 : 16;
        if (payload != null && payload.isValidWriteLength(writeLen)) {
            long clntID = this.getClientID();
            int zoneType = this.getZoneType();
            int radiusM = this.getRadius();
            long typeRad = zoneType << 13 & 0xE000 | radiusM & 0x1FFF;
            Print.logInfo((String)("ClientID:" + clntID + " zoneType:" + zoneType + " radius:" + radiusM + " typeRad:0x" + StringTools.toHexString((long)typeRad, (int)16)), (Object[])new Object[0]);
            if (hiRes) {
                payload.writeULong(clntID, 4);
                payload.writeULong(typeRad, 2);
                payload.writeGPS(this.getLatitude1(), this.getLongitude1(), 8);
                payload.writeGPS(this.getLatitude2(), this.getLongitude2(), 8);
            } else {
                payload.writeULong(clntID, 2);
                payload.writeULong(typeRad, 2);
                payload.writeGPS(this.getLatitude1(), this.getLongitude1(), 6);
                payload.writeGPS(this.getLatitude2(), this.getLongitude2(), 6);
            }
            return true;
        }
        return false;
    }

    protected void setZoneChanged() {
        this.zoneChanged = true;
    }

    public boolean hasBoundingBox() {
        return this.getMinLatitude() != 0.0 && this.getMaxLatitude() != 0.0 && this.getMinLongitude() != 0.0 && this.getMaxLongitude() != 0.0;
    }

    public static GeoBounds getBoundingBox(GeozoneType zoneType, GeoPoint[] gp, double radiusM) {
        GeoBounds bounds = new GeoBounds();
        switch (zoneType) {
            case POINT_RADIUS: {
                bounds.extendByCircle(radiusM, (GeoPointProvider[])gp);
                break;
            }
            case BOUNDED_RECT: {
                bounds.extendByPoint((GeoPointProvider[])gp);
                break;
            }
            case SWEPT_POINT_RADIUS: {
                bounds.extendByCircle(radiusM, (GeoPointProvider[])gp);
                break;
            }
            case POLYGON: {
                bounds.extendByPoint((GeoPointProvider[])gp);
            }
        }
        return bounds;
    }

    public GeoBounds getBoundingBox() {
        Object[] gp = this.getGeoPoints();
        double radM = this.getRadiusMeters();
        GeozoneType type = Geozone.getGeozoneType(this);
        if (ListTools.isEmpty((Object[])gp)) {
            GeoBounds bounds = new GeoBounds();
            bounds.setMaxLatitude(0.0);
            bounds.setMinLatitude(0.0);
            bounds.setMaxLongitude(0.0);
            bounds.setMinLongitude(0.0);
            return bounds;
        }
        switch (type) {
            case POINT_RADIUS: 
            case SWEPT_POINT_RADIUS: {
                if (!(radM <= 0.0)) break;
                GeoBounds bounds = new GeoBounds();
                bounds.setMaxLatitude(gp[0].getLatitude());
                bounds.setMinLatitude(gp[0].getLatitude());
                bounds.setMaxLongitude(gp[0].getLongitude());
                bounds.setMinLongitude(gp[0].getLongitude());
                return bounds;
            }
            case BOUNDED_RECT: {
                if (gp.length >= 2) break;
                GeoBounds bounds = new GeoBounds();
                bounds.setMaxLatitude(gp[0].getLatitude());
                bounds.setMinLatitude(gp[0].getLatitude());
                bounds.setMaxLongitude(gp[0].getLongitude());
                bounds.setMinLongitude(gp[0].getLongitude());
                return bounds;
            }
            case POLYGON: {
                if (gp.length >= 3) break;
                GeoBounds bounds = new GeoBounds();
                bounds.setMaxLatitude(gp[0].getLatitude());
                bounds.setMinLatitude(gp[0].getLatitude());
                bounds.setMaxLongitude(gp[0].getLongitude());
                bounds.setMinLongitude(gp[0].getLongitude());
                return bounds;
            }
        }
        return Geozone.getBoundingBox(type, (GeoPoint[])gp, radM);
    }

    public boolean resetBoundingBox() {
        GeoBounds bounds = this.getBoundingBox();
        boolean changed = false;
        if (Math.abs(this.getMinLatitude() - bounds.getMinLatitude()) > 1.0E-7) {
            this.setMinLatitude(bounds.getMinLatitude());
            changed = true;
        }
        if (Math.abs(this.getMaxLatitude() - bounds.getMaxLatitude()) > 1.0E-7) {
            this.setMaxLatitude(bounds.getMaxLatitude());
            changed = true;
        }
        if (Math.abs(this.getMinLongitude() - bounds.getMinLongitude()) > 1.0E-7) {
            this.setMinLongitude(bounds.getMinLongitude());
            changed = true;
        }
        if (Math.abs(this.getMaxLongitude() - bounds.getMaxLongitude()) > 1.0E-7) {
            this.setMaxLongitude(bounds.getMaxLongitude());
            changed = true;
        }
        return changed;
    }

    public void insert() throws DBException {
        this.resetBoundingBox();
        super.insert();
        this.zoneChanged = false;
    }

    public void update(String ... updFldArray) throws DBException {
        this.resetBoundingBox();
        if (updFldArray != null) {
            Set fldSet = ListTools.toSet((Object[])updFldArray, new HashSet());
            fldSet.add(FLD_minLatitude);
            fldSet.add(FLD_maxLatitude);
            fldSet.add(FLD_minLongitude);
            fldSet.add(FLD_maxLongitude);
            super.update(fldSet);
        } else {
            super.update((String[])null);
        }
        this.zoneChanged = false;
    }

    public void update(Set<String> updFldSet) throws DBException {
        this.resetBoundingBox();
        if (updFldSet != null) {
            HashSet<String> fldSet = new HashSet<String>(updFldSet);
            fldSet.add(FLD_minLatitude);
            fldSet.add(FLD_maxLatitude);
            fldSet.add(FLD_minLongitude);
            fldSet.add(FLD_maxLongitude);
            super.update(fldSet);
        } else {
            super.update((Set)null);
        }
        this.zoneChanged = false;
    }

    public static String getWhereClause(String acctId, String zoneId, int sortId, GeoBounds bounds, GeoPoint centerGP, boolean clientUploadOnly, boolean reverseGeocodeOnly) {
        DBWhere dwh = new DBWhere(Geozone.getFactory());
        dwh.append(dwh.EQ("accountID", (Object)acctId));
        if (!StringTools.isBlank((String)zoneId)) {
            dwh.append(dwh.AND_(dwh.EQ(FLD_geozoneID, (Object)zoneId)));
            if (sortId >= 0) {
                dwh.append(dwh.AND_(dwh.EQ(FLD_sortID, sortId)));
            }
        }
        if (clientUploadOnly) {
            dwh.append(dwh.AND_(dwh.NE(FLD_clientUpload, 0)));
            dwh.append(dwh.AND_(dwh.GT(FLD_clientID, 0)));
        }
        if (reverseGeocodeOnly) {
            dwh.append(dwh.AND_(dwh.NE(FLD_reverseGeocode, 0)));
        }
        if (bounds != null && bounds.isValid()) {
            double minLat = bounds.getMinLatitude();
            double maxLat = bounds.getMaxLatitude();
            double minLon = bounds.getMinLongitude();
            double maxLon = bounds.getMaxLongitude();
            dwh.append(dwh.AND_(dwh.AND(dwh.LE(FLD_minLatitude, maxLat), dwh.GE(FLD_maxLatitude, minLat), dwh.LE(FLD_minLongitude, maxLon), dwh.GE(FLD_maxLongitude, minLon))));
        } else if (centerGP != null) {
            double lat = centerGP.getLatitude();
            double lon = centerGP.getLongitude();
            dwh.append(dwh.AND_(dwh.AND(dwh.LE(FLD_minLatitude, lat), dwh.GE(FLD_maxLatitude, lat), dwh.LE(FLD_minLongitude, lon), dwh.GE(FLD_maxLongitude, lon))));
        }
        String wh = dwh.WHERE(dwh.toString());
        return wh;
    }

    public static String getWhereClause(String acctId, long clientId) {
        DBWhere dwh = new DBWhere(Geozone.getFactory());
        dwh.append(dwh.EQ("accountID", (Object)acctId));
        dwh.append(dwh.AND_(dwh.EQ(FLD_clientID, clientId)));
        dwh.append(dwh.AND_(dwh.NE(FLD_clientUpload, 0)));
        String wh = dwh.WHERE(dwh.toString());
        return wh;
    }

    public static boolean exists(String acctID, String zoneID, int sortID) throws DBException {
        if (acctID != null && zoneID != null) {
            if (sortID >= 0) {
                Key zoneKey = new Key(acctID, zoneID, sortID);
                return zoneKey.exists();
            }
            Key zoneKey = new Key(acctID, zoneID, -1);
            return zoneKey.exists(false);
        }
        return false;
    }

    public static String getDescription(Account account, GeoPoint gp) {
        if (account != null) {
            return Geozone.getDescription(account.toString(), gp);
        }
        return null;
    }

    public static String getDescription(String acctID, GeoPoint gp) {
        Geozone gz = Geozone.getGeozone(acctID, null, gp, true);
        return gz != null ? gz.getDescription() : null;
    }

    public static Geozone getGeozone(Account account, String zoneID, GeoPoint gp, boolean reverseGeocodeOnly) {
        if (account != null) {
            return Geozone.getGeozone(account.getAccountID(), zoneID, gp, null, reverseGeocodeOnly);
        }
        return null;
    }

    public static Geozone getGeozone(String acctID, String zoneID, GeoPoint gp, boolean reverseGeocodeOnly) {
        return Geozone.getGeozone(acctID, zoneID, gp, null, reverseGeocodeOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geozone getGeozone(String acctID, String zoneID, GeoPoint gp, String purposeID, boolean reverseGeocodeOnly) {
        if (StringTools.isBlank((String)acctID)) {
            return null;
        }
        if (gp == null || !gp.isValid()) {
            return null;
        }
        DBSelect dsel = new DBSelect(Geozone.getFactory());
        dsel.setWhere(Geozone.getWhereClause(acctID, zoneID, -1, null, gp, false, reverseGeocodeOnly));
        if (Geozone.supportsPriority()) {
            dsel.setOrderByFields(new String[]{FLD_priority, FLD_sortID});
        } else {
            dsel.setOrderByFields(new String[]{FLD_sortID});
        }
        Geozone[] gz = null;
        try {
            DBProvider.lockTables((String[])new String[]{Geozone.TABLE_NAME()}, null);
            gz = (Geozone[])DBRecord.select((DBSelect)dsel);
        }
        catch (DBException dbe) {
            Print.logError((String)("Geozone error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            Geozone geozone = null;
            return geozone;
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dbe) {}
        }
        if (ListTools.isEmpty((Object[])gz)) {
            return null;
        }
        String lastDesc = "";
        String lastZoneId = null;
        for (int g = 0; g < gz.length; ++g) {
            String zoneId = gz[g].getGeozoneID();
            if (lastZoneId == null || !lastZoneId.equals(zoneId)) {
                lastZoneId = zoneId;
                lastDesc = "";
            }
            String thisDesc = gz[g].getDescription();
            if (gz[g].containsPoint(gp) && gz[g].isZonePurposeID(purposeID)) {
                if (thisDesc.equals("") && !lastDesc.equals("")) {
                    gz[g].setDescription(lastDesc);
                }
                return gz[g];
            }
            if (thisDesc.equals("")) continue;
            lastDesc = thisDesc;
        }
        return null;
    }

    public static Geozone[] getGeozones(String acctID, GeoPoint gp) throws DBException {
        if (StringTools.isBlank((String)acctID)) {
            return null;
        }
        if (gp == null || !gp.isValid()) {
            return null;
        }
        DBSelect dsel = new DBSelect(Geozone.getFactory());
        dsel.setWhere(Geozone.getWhereClause(acctID, null, -1, null, gp, false, false));
        if (Geozone.supportsPriority()) {
            dsel.setOrderByFields(new String[]{FLD_priority, FLD_sortID});
        } else {
            dsel.setOrderByFields(new String[]{FLD_sortID});
        }
        Geozone[] gz = null;
        try {
            DBProvider.lockTables((String[])new String[]{Geozone.TABLE_NAME()}, null);
            gz = (Geozone[])DBRecord.select((DBSelect)dsel);
        }
        catch (DBException dbe) {
            Print.logError((String)("Geozone error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            throw dbe;
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dbe) {}
        }
        if (ListTools.isEmpty((Object[])gz)) {
            return null;
        }
        int x = 0;
        String lastDesc = "";
        String lastZoneId = null;
        for (int g = 0; g < gz.length; ++g) {
            String zoneId = gz[g].getGeozoneID();
            if (lastZoneId == null || !lastZoneId.equals(zoneId)) {
                lastZoneId = zoneId;
                lastDesc = "";
            }
            String thisDesc = gz[g].getDescription();
            if (gz[g].containsPoint(gp)) {
                if (thisDesc.equals("") && !lastDesc.equals("")) {
                    gz[g].setDescription(lastDesc);
                }
                if (x != g) {
                    gz[x] = gz[g];
                }
                ++x;
            } else {
                gz[g] = null;
            }
            if (thisDesc.equals("")) continue;
            lastDesc = thisDesc;
        }
        if (x == 0) {
            return null;
        }
        if (x == gz.length) {
            return gz;
        }
        Geozone[] nz = new Geozone[x];
        System.arraycopy(gz, 0, nz, 0, x);
        return nz;
    }

    public static Geozone[] getGeozones(String acctID, GeoBounds gb) throws DBException {
        if (StringTools.isBlank((String)acctID)) {
            return null;
        }
        if (gb == null || !gb.isValid()) {
            return null;
        }
        DBSelect dsel = new DBSelect(Geozone.getFactory());
        dsel.setWhere(Geozone.getWhereClause(acctID, null, -1, gb, null, false, false));
        if (Geozone.supportsPriority()) {
            dsel.setOrderByFields(new String[]{FLD_priority, FLD_sortID});
        } else {
            dsel.setOrderByFields(new String[]{FLD_sortID});
        }
        Geozone[] gz = null;
        try {
            DBProvider.lockTables((String[])new String[]{Geozone.TABLE_NAME()}, null);
            gz = (Geozone[])DBRecord.select((DBSelect)dsel);
        }
        catch (DBException dbe) {
            Print.logError((String)("Geozone error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            throw dbe;
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dbe) {}
        }
        if (ListTools.isEmpty((Object[])gz)) {
            return null;
        }
        return gz;
    }

    public static Geozone[] getGeozone(Account account, String geozoneID) throws DBException {
        Geozone zone = Geozone.getGeozone(account, geozoneID, 0, false);
        if (zone == null) {
            return null;
        }
        return new Geozone[]{zone};
    }

    public static Geozone getGeozone(Account account, String geozoneID, int sortID, boolean create) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String acctId = account.getAccountID();
        if (StringTools.isBlank((String)geozoneID)) {
            throw new DBNotFoundException("Geozone-ID not specified.");
        }
        Geozone geozone = null;
        Key zoneKey = new Key(acctId, geozoneID, sortID);
        if (!zoneKey.exists()) {
            if (create) {
                geozone = (Geozone)zoneKey.getDBRecord();
                geozone.setAccount(account);
                geozone.setCreationDefaultValues();
                return geozone;
            }
            throw new DBNotFoundException("Geozone-ID does not exists '" + (Object)((Object)zoneKey) + "'");
        }
        if (create) {
            throw new DBAlreadyExistsException("Geozone-ID already exists '" + (Object)((Object)zoneKey) + "'");
        }
        geozone = (Geozone)zoneKey.getDBRecord(true);
        if (geozone == null) {
            throw new DBException("Unable to read existing Geozone-ID '" + (Object)((Object)zoneKey) + "'");
        }
        return geozone;
    }

    public static boolean containsPoint(Account account, String zoneId, GeoPoint gp) throws DBNotFoundException {
        if (account != null) {
            return Geozone.containsPoint(account.getAccountID(), zoneId, gp);
        }
        return false;
    }

    public static boolean containsPoint(String acctId, String zoneId, GeoPoint gp) throws DBNotFoundException {
        if (StringTools.isBlank((String)acctId)) {
            throw new DBNotFoundException("Account ID is blank/null");
        }
        if (gp == null || !gp.isValid()) {
            return false;
        }
        GeoPoint selGP = gp;
        DBSelect dsel = new DBSelect(Geozone.getFactory());
        dsel.setWhere(Geozone.getWhereClause(acctId, zoneId, -1, null, selGP, false, false));
        Geozone[] gz = null;
        try {
            DBProvider.lockTables((String[])new String[]{Geozone.TABLE_NAME()}, null);
            gz = (Geozone[])DBRecord.select((DBSelect)dsel);
        }
        catch (DBException dbe) {
            throw new DBNotFoundException("Geozone error: " + (Object)((Object)dbe));
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dbe) {}
        }
        if (ListTools.isEmpty((Object[])gz)) {
            if (selGP == null) {
                throw new DBNotFoundException("Geozone not found: " + acctId + "/" + zoneId);
            }
            return false;
        }
        for (int g = 0; g < gz.length; ++g) {
            if (!gz[g].containsPoint(gp)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geozone[] getClientIDZones(String acctId, long clientId) {
        if (acctId == null || acctId.equals("")) {
            Print.logError((String)"AccountID not specified", (Object[])new Object[0]);
            return null;
        }
        if (clientId <= 0L) {
            Print.logError((String)"ClientID not specified", (Object[])new Object[0]);
            return null;
        }
        DBSelect dsel = new DBSelect(Geozone.getFactory());
        dsel.setWhere(Geozone.getWhereClause(acctId, clientId));
        dsel.setOrderByFields(new String[]{FLD_sortID});
        Geozone[] gz = null;
        try {
            DBProvider.lockTables((String[])new String[]{Geozone.TABLE_NAME()}, null);
            gz = (Geozone[])DBRecord.select((DBSelect)dsel);
        }
        catch (DBException dbe) {
            Print.logError((String)("Geozone error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            Geozone[] geozoneArray = null;
            return geozoneArray;
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dbe) {}
        }
        if (gz == null || gz.length == 0) {
            return null;
        }
        return gz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geozone[] getClientUploadZones(String acctId) {
        if (acctId == null || acctId.equals("")) {
            Print.logError((String)"AccountID not specified", (Object[])new Object[0]);
            return null;
        }
        DBSelect dsel = new DBSelect(Geozone.getFactory());
        dsel.setWhere(Geozone.getWhereClause(acctId, null, -1, null, null, true, false));
        dsel.setOrderByFields(new String[]{FLD_clientID, FLD_sortID});
        Geozone[] gz = null;
        try {
            DBProvider.lockTables((String[])new String[]{Geozone.TABLE_NAME()}, null);
            gz = (Geozone[])DBRecord.select((DBSelect)dsel);
        }
        catch (DBException dbe) {
            Print.logError((String)("Geozone error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            Geozone[] geozoneArray = null;
            return geozoneArray;
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dbe) {}
        }
        if (gz == null || gz.length == 0) {
            return null;
        }
        return gz;
    }

    public static String[] getGeozoneIDsForAccount(String acctId) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return new String[0];
        }
        DBSelect dsel = new DBSelect(Geozone.getFactory());
        dsel.setWhere(Geozone.getWhereClause(acctId, null, -1, null, null, false, false));
        dsel.setOrderByFields(new String[]{FLD_geozoneID, FLD_sortID});
        return Geozone.getGeozoneIDs((DBSelect<Geozone>)dsel);
    }

    public static String[] getGeozoneIDs(DBSelect<Geozone> dsel) throws DBException {
        if (dsel == null) {
            return new String[0];
        }
        OrderedSet zoneList = new OrderedSet(true);
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String zoneId = rs.getString(FLD_geozoneID);
                zoneList.add((Object)zoneId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting Geozone ID List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return (String[])zoneList.toArray((Object[])new String[zoneList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printClientCSV(File csvFile, String accountID) {
        FileOutputStream fos = null;
        try {
            fos = csvFile != null ? new FileOutputStream(csvFile) : null;
            String header = "#zoneID,type,rad,lat0,lon0,lat1,lon1\n";
            if (fos != null) {
                FileTools.writeStream((OutputStream)fos, (String)header);
            } else {
                Print.sysPrint((String)header, (Object[])new Object[0]);
            }
            Geozone[] gzList = Geozone.getClientUploadZones(accountID);
            if (gzList != null && gzList.length > 0) {
                for (int i = 0; i < gzList.length; ++i) {
                    Geozone gz = gzList[i];
                    int zoneType = gz.getZoneType();
                    StringBuffer sb = new StringBuffer();
                    sb.append(gz.getClientID()).append(",");
                    sb.append(zoneType).append(",");
                    if (zoneType == GeozoneType.BOUNDED_RECT.getIntValue()) {
                        sb.append(gz.getRadius()).append(",");
                        sb.append(gz.getNorthLatitude()).append(",");
                        sb.append(gz.getWestLongitude()).append(",");
                        sb.append(gz.getSouthLatitude()).append(",");
                        sb.append(gz.getEastLongitude());
                    } else {
                        sb.append(gz.getRadius()).append(",");
                        sb.append(gz.getLatitude1()).append(",");
                        sb.append(gz.getLongitude1()).append(",");
                        sb.append(gz.getLatitude2()).append(",");
                        sb.append(gz.getLongitude2());
                    }
                    sb.append("\n");
                    if (fos != null) {
                        FileTools.writeStream((OutputStream)fos, (String)sb.toString());
                        continue;
                    }
                    Print.sysPrint((String)sb.toString(), (Object[])new Object[0]);
                }
            }
        }
        catch (IOException ioe) {
            Print.logException((String)"Unable to create CSV file", (Throwable)ioe);
        }
        finally {
            if (fos != null) {
                FileTools.closeStream((OutputStream)fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listZones(String acctId, boolean update) {
        if (StringTools.isBlank((String)acctId)) {
            Print.logError((String)"AccountID not specified", (Object[])new Object[0]);
            return;
        }
        DBSelect dsel = new DBSelect(Geozone.getFactory());
        dsel.setWhere(Geozone.getWhereClause(acctId, null, -1, null, null, false, false));
        dsel.setOrderByFields(new String[]{FLD_geozoneID, FLD_sortID});
        Geozone[] gz = null;
        try {
            DBProvider.lockTables((String[])new String[]{Geozone.TABLE_NAME()}, null);
            gz = (Geozone[])DBRecord.select((DBSelect)dsel);
        }
        catch (DBException dbe) {
            Print.logError((String)("Geozone error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            return;
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dbe) {}
        }
        int invalidBoundingBoxes = 0;
        if (gz != null && gz.length > 0) {
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            Print.sysPrintln((String)("Account: " + acctId), (Object[])new Object[0]);
            for (int i = 0; i < gz.length; ++i) {
                int ptCnt = Geozone.GetGeoPointCount();
                StringBuffer sb = new StringBuffer();
                sb.append(" ---------------------------------------------------------\n");
                sb.append("  Geozone  : " + gz[i].getGeozoneID() + ":" + gz[i].getSortID() + " - " + gz[i].getDescription() + "\n");
                String city = gz[i].getCity();
                String postal = gz[i].getPostalCode();
                String subDiv = gz[i].getSubdivision();
                if (StringTools.isBlank((String)city) && StringTools.isBlank((String)postal) && StringTools.isBlank((String)subDiv)) {
                    sb.append("    Address: \n");
                } else {
                    sb.append("    Address: " + city + ", " + postal + ", " + subDiv + "\n");
                }
                sb.append("    Type   : " + gz[i].getZoneType() + " - " + gz[i].getZoneTypeDescription(null) + "\n");
                int radiusM = gz[i].getRadius();
                if (gz[i].hasRadius()) {
                    sb.append("    Radius : " + gz[i].getRadius() + " meters\n");
                } else if (radiusM != 0) {
                    sb.append("    Radius : [" + gz[i].getRadius() + " meters] not used\n");
                }
                for (int p = 0; p < ptCnt; ++p) {
                    if (p % 3 == 0) {
                        if (p > 0) {
                            sb.append("\n");
                        }
                        sb.append("    Points : ");
                    } else {
                        sb.append(" ");
                    }
                    GeoPoint gp = gz[i].getGeoPoint(p);
                    if (gp == null) {
                        gp = GeoPoint.INVALID_GEOPOINT;
                    }
                    sb.append(p + 1).append("(" + gp + ")");
                }
                sb.append("\n");
                boolean hasBounds = gz[i].hasBoundingBox();
                boolean boundsChanged = gz[i].resetBoundingBox();
                if (boundsChanged) {
                    ++invalidBoundingBoxes;
                }
                sb.append("    Bounds : " + hasBounds + " [" + (boundsChanged ? "INVALID" : "valid") + "]\n");
                sb.append("    Upload : " + gz[i].getClientUpload() + " [id=" + gz[i].getClientID() + "]\n");
                sb.append("    RevGeo : " + gz[i].getReverseGeocode() + "\n");
                if (update) {
                    try {
                        gz[i].save();
                        sb.append("    Updated: true\n");
                    }
                    catch (DBException dbe) {
                        sb.append("    Updated: false [ERROR: " + dbe.getMessage() + "]\n");
                    }
                }
                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
            }
            if (invalidBoundingBoxes > 0) {
                if (update) {
                    Print.sysPrintln((String)"Note:", (Object[])new Object[0]);
                    Print.sysPrintln((String)"Invalid Bounding-Box field values have been updated.", (Object[])new Object[0]);
                    Print.sysPrintln((String)"(Run command again without '-update' to verify)", (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)"WARNING:", (Object[])new Object[0]);
                    Print.sysPrintln((String)"Geozones contained invalid Bounding-Box field values.", (Object[])new Object[0]);
                    Print.sysPrintln((String)"Run command again with '-update' option to update Bounding-Box fields.", (Object[])new Object[0]);
                }
                Print.sysPrintln((String)"\n", (Object[])new Object[0]);
            }
        }
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + Geozone.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>     Acount ID which owns the specified Geozone", (Object[])new Object[0]);
        Print.logInfo((String)"  -zone=<id>        Geozone ID", (Object[])new Object[0]);
        Print.logInfo((String)"  -sort=<index>     Unique sort index for Geozone", (Object[])new Object[0]);
        Print.logInfo((String)"  -create           Create Geozone (requires '-zone=<zoneId> -sort=<sortId>')", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit             Edit Geozone (requires '-zone=<zoneId> -sort=<sortId>')", (Object[])new Object[0]);
        Print.logInfo((String)"  -list             List Account Geozones", (Object[])new Object[0]);
        Print.logInfo((String)"  -gp=<lat/lon>     Display all Geozones containing point", (Object[])new Object[0]);
        Print.logInfo((String)"  -dmtpcsv=<file>   Create CSV file for client devices", (Object[])new Object[0]);
        Print.logInfo((String)"  -export=<csvFile> Export Account Geozones to CSV file (selected columns)", (Object[])new Object[0]);
        Print.logInfo((String)"  -dump=<csvFile>   Dump Account Geozones to CSV file (all columns)", (Object[])new Object[0]);
        Print.logInfo((String)"  -load=<csvFile>   Load Account Geozones from CSV file", (Object[])new Object[0]);
        Print.logInfo((String)"  -test=<lat>/<lon> Test Geozone: find specified point", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBSelect dsel;
        DBFactory<Geozone> fact;
        File dumpFile;
        Geozone gz;
        Object gz2;
        boolean isArgEdit;
        DBConfig.cmdLineInit(argv, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        String zoneID = RTConfig.getString((String[])ARG_GEOZONE, (String)"");
        int sortID = RTConfig.getInt((String[])ARG_SORT, (int)-1);
        if (acctID == null || acctID.equals("")) {
            Print.sysPrintln((String)"ERROR: Account-ID not specified.", (Object[])new Object[0]);
            Geozone.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(acctID);
            if (account == null) {
                Print.sysPrintln((String)("ERROR: Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                Geozone.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        boolean zoneSpecified = zoneID != null && !zoneID.equals("");
        boolean sortSpecified = sortID >= 0;
        boolean bl = isArgEdit = RTConfig.hasProperty((String[])ARG_EDIT) || RTConfig.hasProperty((String[])ARG_EDITALL);
        if (isArgEdit && !sortSpecified) {
            sortID = 0;
            sortSpecified = true;
            Print.sysPrintln((String)("Defaulting to '-" + ARG_SORT[0] + "=0'"), (Object[])new Object[0]);
        }
        boolean zoneExists = false;
        try {
            zoneExists = Geozone.exists(acctID, zoneID, sortID);
        }
        catch (DBException dbe) {
            Print.sysPrintln((String)("ERROR: Error determining if Device exists: '" + acctID + "," + zoneID + "," + sortID + "'"), (Object[])new Object[0]);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            ++opts;
            boolean update = RTConfig.getBoolean((String[])ARG_UPDATE, (boolean)false);
            Geozone.listZones(acctID, update);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_GEOPOINT)) {
            String gpStr = RTConfig.getString((String[])ARG_GEOPOINT, null);
            GeoPoint gp = new GeoPoint(gpStr);
            if (!gp.isValid()) {
                Print.sysPrintln((String)("ERROR: Invalid GeoPoint - " + gpStr), (Object[])new Object[0]);
                System.exit(99);
            }
            try {
                gz2 = Geozone.getGeozones(acctID, gp);
                if (ListTools.size((Object[])gz2) > 0) {
                    if (!StringTools.isBlank((String)devID)) {
                        Print.sysPrintln((String)("Found Zones: [validating for '" + devID + "']"), (Object[])new Object[0]);
                    } else {
                        Print.sysPrintln((String)"Found Zones:", (Object[])new Object[0]);
                    }
                    for (Geozone z : gz2) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("  ");
                        sb.append(z.getGeozoneID());
                        if (!StringTools.isBlank((String)devID)) {
                            if (z.isDeviceInGroup(devID)) {
                                sb.append(" [OK]");
                            } else {
                                sb.append(" [no]");
                            }
                        }
                        sb.append("\n");
                        Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)"No Geozones found.", (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to read Geozones", (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_DMTPCSV)) {
            ++opts;
            String csvFileName = RTConfig.getString((String[])ARG_DMTPCSV, (String)"");
            File csvFile = !csvFileName.equals("") ? new File(csvFileName) : null;
            Geozone.printClientCSV(csvFile, acctID);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_CREATE)) {
            ++opts;
            if (!zoneSpecified) {
                Print.sysPrintln((String)"ERROR: Invalid or missing geozoneId", (Object[])new Object[0]);
                Geozone.usage();
            } else if (!sortSpecified) {
                Print.sysPrintln((String)"ERROR: Invalid or missing sortId", (Object[])new Object[0]);
                Geozone.usage();
            } else if (zoneExists) {
                Print.sysPrintln((String)("ERROR: Geozone already exists: '" + acctID + "," + zoneID + "," + sortID + "'"), (Object[])new Object[0]);
                Geozone.usage();
            } else {
                try {
                    Key key = new Key(acctID, zoneID, sortID);
                    gz = (Geozone)key.getDBRecord(false);
                    gz.setCreationDefaultValues();
                    gz.save();
                    Print.sysPrintln((String)"Geozone created ...", (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logException((String)"Creating Geozone", (Throwable)dbe);
                    System.exit(99);
                }
            }
        }
        if (isArgEdit) {
            ++opts;
            if (!zoneSpecified) {
                Print.sysPrintln((String)"ERROR: Invalid or missing geozoneID", (Object[])new Object[0]);
                Geozone.usage();
            } else if (!sortSpecified) {
                Print.sysPrintln((String)"ERROR: Invalid or missing sortID", (Object[])new Object[0]);
                Geozone.usage();
            } else if (!zoneExists) {
                Print.sysPrintln((String)("ERROR: Geozone does not exist: '" + acctID + "," + zoneID + "," + sortID + "'"), (Object[])new Object[0]);
                Geozone.usage();
            } else {
                try {
                    boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                    Key key = new Key(acctID, zoneID, sortID);
                    gz2 = (Geozone)key.getDBRecord(true);
                    DBEdit editor = new DBEdit((DBRecord)gz2);
                    editor.edit(allFlds);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.sysPrintln((String)"ERROR: End of input", (Object[])new Object[0]);
                    }
                    Print.sysPrintln((String)"ERROR: IO Error", (Object[])new Object[0]);
                }
                System.exit(0);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_DELETE)) {
            ++opts;
            if (!zoneSpecified) {
                Print.sysPrintln((String)"ERROR: Invalid or missing geozoneID", (Object[])new Object[0]);
                Geozone.usage();
            } else if (!sortSpecified) {
                Print.sysPrintln((String)"ERROR: Invalid or missing sortId", (Object[])new Object[0]);
                Geozone.usage();
            } else if (!zoneExists) {
                Print.sysPrintln((String)("ERROR: Geozone does not exist exist: '" + acctID + "," + zoneID + "," + sortID + "'"), (Object[])new Object[0]);
                Geozone.usage();
            } else {
                try {
                    Key key = new Key(acctID, zoneID, sortID);
                    key.delete(true);
                    Print.sysPrintln((String)"Geozone deleted ...", (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logException((String)"Error deleting Geozone", (Throwable)dbe);
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_DUMP)) {
            ++opts;
            String dumpFileName = RTConfig.getString((String[])ARG_DUMP, (String)"");
            File file = dumpFile = !StringTools.isBlank((String)dumpFileName) ? new File(dumpFileName) : null;
            if (dumpFile == null || !dumpFile.getName().toLowerCase().endsWith(CSV_EXT)) {
                Print.sysPrintln((String)("ERROR: Invalid file specified: " + dumpFile), (Object[])new Object[0]);
                Geozone.usage();
            }
            fact = Geozone.getFactory();
            try {
                dsel = new DBSelect(fact);
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.EQ("accountID", (Object)acctID)));
                dsel.setOrderByFields(new String[]{FLD_geozoneID, FLD_sortID});
                fact.dumpTable(dumpFile, dsel);
            }
            catch (DBException dbe) {
                Print.logException((String)("Error dumping table: " + Geozone.TABLE_NAME()), (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_EXPORT)) {
            ++opts;
            String dumpFileName = RTConfig.getString((String[])ARG_EXPORT, (String)"");
            File file = dumpFile = !StringTools.isBlank((String)dumpFileName) ? new File(dumpFileName) : new File("stdout.csv");
            if (!dumpFile.getName().toLowerCase().endsWith(CSV_EXT)) {
                Print.sysPrintln((String)("ERROR: Invalid file specified: " + dumpFile), (Object[])new Object[0]);
                Geozone.usage();
            }
            fact = Geozone.getFactory();
            try {
                dsel = new DBSelect(fact);
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.EQ("accountID", (Object)acctID)));
                dsel.setOrderByFields(new String[]{FLD_geozoneID, FLD_sortID});
                String[] exportFlds = DBFactory.getFieldNames((DBField[])fact.getFieldsWithBoolean("export", true));
                fact.dumpTable(dumpFile, dsel, exportFlds);
            }
            catch (DBException dbe) {
                Print.logException((String)("Error exporting table: " + Geozone.TABLE_NAME()), (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LOAD) || RTConfig.hasProperty((String[])ARG_VALIDATE)) {
            File loadFile;
            ++opts;
            boolean validateOnly = RTConfig.hasProperty((String[])ARG_VALIDATE);
            String loadFileName = validateOnly ? RTConfig.getString((String[])ARG_VALIDATE, (String)"") : RTConfig.getString((String[])ARG_LOAD, (String)"");
            File file = loadFile = !loadFileName.equals("") ? new File(loadFileName) : null;
            if (loadFile == null || !loadFile.exists() || !loadFile.getName().toLowerCase().endsWith(CSV_EXT)) {
                Print.sysPrintln((String)("ERROR: Invalid or non-existent file specified: " + loadFile), (Object[])new Object[0]);
                Geozone.usage();
            }
            DBFactory<Geozone> fact2 = Geozone.getFactory();
            try {
                if (fact2.tableExists()) {
                    if (validateOnly) {
                        Print.sysPrintln((String)("Validating '" + Geozone.TABLE_NAME() + "' file: " + loadFile), (Object[])new Object[0]);
                    } else {
                        Print.sysPrintln((String)("Loading '" + Geozone.TABLE_NAME() + "' from file: " + loadFile), (Object[])new Object[0]);
                    }
                    fact2.loadTable(loadFile, (DBFactory.InsertionValidator)new ZoneLoadValidator(acctID, validateOnly), !validateOnly, true);
                    Print.sysPrintln((String)("Successfully validated/loaded '" + Geozone.TABLE_NAME() + "' file: " + loadFile), (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)("ERROR: Table does not exist: " + Geozone.TABLE_NAME()), (Object[])new Object[0]);
                    System.exit(99);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Error loading/validating table: " + Geozone.TABLE_NAME()), (Throwable)dbe);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_TEST)) {
            ++opts;
            GeoPoint gp = new GeoPoint(RTConfig.getString((String[])ARG_TEST, (String)""));
            try {
                Geozone geozone = gz = !StringTools.isBlank((String)devID) ? Geozone.getGeozoneForDevice(acctID, gp, devID) : Geozone.getGeozone(acctID, null, gp, false);
                if (gz == null) {
                    Print.sysPrintln((String)("WARN: Geozone for point not found: " + gp), (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)("Found Geozone: " + gz.getDescription()), (Object[])new Object[0]);
                }
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logException((String)"Geozone error", (Throwable)dbe);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_EVTEST)) {
            ++opts;
            String dtStr = RTConfig.getString((String[])ARG_EVTEST, null);
            try {
                EventData nextED;
                EventData thisED;
                DateTime dt = DateTime.parseArgumentDate((String)dtStr, null, (boolean)false);
                long dte = dt.getTimeSec();
                EventData[] ed = EventData.getRangeEvents(acctID, devID, dte - 1L, dte + 1L, null, true, null, 0L, true, null);
                if (ed == null || ed.length == 0) {
                    throw new DBException("No EvenData records found near the specified date/time");
                }
                EventData prevED = ed[0].getPreviousEventData(true);
                if (prevED != null) {
                    GeoPoint gp = prevED.getGeoPoint();
                    Geozone gz3 = Geozone.getGeozone(account, null, gp, false);
                    if (gz3 == null) {
                        Print.sysPrintln((String)("Prev point: No Geozone: " + gp), (Object[])new Object[0]);
                    } else {
                        Print.sysPrintln((String)("Prev point: Found Geozone: " + gz3.getDescription()), (Object[])new Object[0]);
                    }
                }
                if ((thisED = ed[0]) != null) {
                    GeoPoint gp = thisED.getGeoPoint();
                    Geozone gz4 = Geozone.getGeozone(account, null, gp, false);
                    if (gz4 == null) {
                        Print.sysPrintln((String)("This point: No Geozone: " + gp), (Object[])new Object[0]);
                    } else {
                        Print.sysPrintln((String)("This point: Found Geozone: " + gz4.getDescription()), (Object[])new Object[0]);
                    }
                }
                if ((nextED = ed[0].getPreviousEventData(true)) != null) {
                    GeoPoint gp = nextED.getGeoPoint();
                    Geozone gz5 = Geozone.getGeozone(account, null, gp, false);
                    if (gz5 == null) {
                        Print.sysPrintln((String)("Next point: No Geozone: " + gp), (Object[])new Object[0]);
                    } else {
                        Print.sysPrintln((String)("Next point: Found Geozone: " + gz5.getDescription()), (Object[])new Object[0]);
                    }
                }
            }
            catch (DateTime.DateParseException dpe) {
                Print.logException((String)("Invalid event date: " + dtStr), (Throwable)dpe);
            }
            catch (DBException dbe) {
                Print.logException((String)"DB error", (Throwable)dbe);
            }
            System.exit(0);
        }
        if (opts <= 0) {
            Geozone.usage();
        }
    }

    private static class ZoneLoadValidator
    implements DBFactory.InsertionValidator {
        private String accountID = null;
        private String[] fields = null;
        private int acctNdx = -1;
        private int zoneNdx = -1;
        private int zoneType = -1;
        private int count = 0;
        private boolean forceInvalid = false;

        public ZoneLoadValidator(String acctID, boolean forceInvalid) {
            this.accountID = acctID != null ? acctID : "";
            this.forceInvalid = forceInvalid;
        }

        public boolean setFields(String[] f) throws DBException {
            this.count = 0;
            this.fields = f;
            if (this.fields == null) {
                throw new DBException("No fields specified");
            }
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.acctNdx < 0 && this.fields[i].equals("accountID")) {
                    this.acctNdx = i;
                }
                if (this.zoneNdx < 0 && this.fields[i].equals(Geozone.FLD_geozoneID)) {
                    this.zoneNdx = i;
                }
                if (this.zoneType >= 0 || !this.fields[i].equals(Geozone.FLD_zoneType)) continue;
                this.zoneType = i;
            }
            if (this.acctNdx < 0) {
                throw new DBException("Load file is missing 'accountID'");
            }
            if (this.zoneNdx < 0) {
                throw new DBException("Load file is missing 'geozoneID'");
            }
            return true;
        }

        public boolean validate(String[] v) throws DBException {
            String z;
            String a;
            ++this.count;
            if (this.fields == null) {
                throw new DBException("No fields specified");
            }
            if (v == null) {
                throw new DBException("No field values specified");
            }
            if (v.length != this.fields.length) {
                int vlen = v.length;
                int flen = this.fields.length;
                throw new DBException("Invalid # of fields (found=" + vlen + ", expected=" + flen + ") [" + this.count + "]");
            }
            String string = a = this.acctNdx >= 0 ? v[this.acctNdx] : null;
            if (a == null || a.equals("") || !a.equals(this.accountID)) {
                Print.logError((String)("Invalid Account ID found: " + a + " [cnt=" + this.count + "]"), (Object[])new Object[0]);
                return false;
            }
            String string2 = z = this.zoneNdx >= 0 ? v[this.zoneNdx] : null;
            if (z == null || z.equals("")) {
                Print.logError((String)("Invalid Geozone ID found: " + z + " [cnt=" + this.count + "]"), (Object[])new Object[0]);
                return false;
            }
            return !this.forceInvalid;
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<Geozone> {
        public Key() {
        }

        public Key(String acctId, String zoneId, int sortId) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue(Geozone.FLD_geozoneID, (Object)(zoneId != null ? zoneId.toLowerCase() : ""));
            if (sortId >= 0) {
                super.setKeyValue(Geozone.FLD_sortID, sortId);
            }
        }

        public DBFactory<Geozone> getFactory() {
            return Geozone.getFactory();
        }
    }

    public static enum GeozoneType implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        POINT_RADIUS(0, I18N.getString(Geozone.class, (String)"Geozone.type.pointRadius", (String)"PointRadius"), true),
        BOUNDED_RECT(1, I18N.getString(Geozone.class, (String)"Geozone.type.boundedRectangle", (String)"BoundedRectangle"), false),
        SWEPT_POINT_RADIUS(2, I18N.getString(Geozone.class, (String)"Geozone.type.sweptPointRadius", (String)"SweptPointRadius"), true),
        POLYGON(3, I18N.getString(Geozone.class, (String)"Geozone.type.polygon", (String)"Polygon"), false);

        private int vv = 0;
        private I18N.Text aa = null;
        private boolean rr = false;

        private GeozoneType(int v, I18N.Text a, boolean r) {
            this.vv = v;
            this.aa = a;
            this.rr = r;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean hasRadius() {
            return this.rr;
        }
    }
}

