/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.cellid.CellTower;
import org.opengts.cellid.MobileLocation;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.EntityManager;
import org.opengts.db.EventDataProvider;
import org.opengts.db.GeoEvent;
import org.opengts.db.PushpinIconIndexProvider;
import org.opengts.db.RuleFactory;
import org.opengts.db.RuleParseException;
import org.opengts.db.StatusCodeProvider;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.StatusCode;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBRecordIterator;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.dbtypes.DTOBDFault;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.SlowOperationException;
import org.opengts.util.Accelerometer;
import org.opengts.util.DateTime;
import org.opengts.util.DayNumber;
import org.opengts.util.EnumTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.HTMLTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class EventData
extends DeviceRecord<EventData>
implements EventDataProvider,
GeoPointProvider {
    public static final String OPTCOLS_AddressFieldInfo = "startupInit.EventData.AddressFieldInfo";
    public static final String OPTCOLS_GPSFieldInfo = "startupInit.EventData.GPSFieldInfo";
    public static final String OPTCOLS_CustomFieldInfo = "startupInit.EventData.CustomFieldInfo";
    public static final String OPTCOLS_GarminFieldInfo = "startupInit.EventData.GarminFieldInfo";
    public static final String OPTCOLS_CANBUSFieldInfo = "startupInit.EventData.CANBUSFieldInfo";
    public static final String OPTCOLS_AtmosphereFieldInfo = "startupInit.EventData.AtmosphereFieldInfo";
    public static final String OPTCOLS_ThermoFieldInfo = "startupInit.EventData.ThermoFieldInfo";
    public static final String OPTCOLS_AnalogFieldInfo = "startupInit.EventData.AnalogFieldInfo";
    public static final String OPTCOLS_AutoIncrementIndex = "startupInit.EventData.AutoIncrementIndex";
    public static final String OPTCOLS_EndOfDaySummary = "startupInit.EventData.EndOfDaySummary";
    public static final String OPTCOLS_ServingCellTowerData = "startupInit.EventData.ServingCellTowerData";
    public static final String OPTCOLS_NeighborCellTowerData = "startupInit.EventData.NeighborCellTowerData";
    public static final String OPTCOLS_WorkZoneGridData = "startupInit.EventData.WorkZoneGridData";
    public static final String OPTCOLS_LeaseRentalData = "startupInit.EventData.LeaseRentalData";
    public static final String OPTCOLS_CreationTimeMillisecond = "startupInit.EventData.CreationTimeMillisecond";
    public static final double INVALID_TEMPERATURE = -9999.0;
    public static final double TEMPERATURE_LIMIT = 126.0;
    public static final int ICON_PUSHPIN_BLACK = 0;
    public static final int ICON_PUSHPIN_BROWN = 1;
    public static final int ICON_PUSHPIN_RED = 2;
    public static final int ICON_PUSHPIN_ORANGE = 3;
    public static final int ICON_PUSHPIN_YELLOW = 4;
    public static final int ICON_PUSHPIN_GREEN = 5;
    public static final int ICON_PUSHPIN_BLUE = 6;
    public static final int ICON_PUSHPIN_PURPLE = 7;
    public static final int ICON_PUSHPIN_GRAY = 8;
    public static final int ICON_PUSHPIN_WHITE = 9;
    public static final EventData[] EMPTY_ARRAY;
    public static int AddressColumnLength;
    public static int StreetColumnLength;
    public static int CityColumnLength;
    public static int StateColumnLength;
    public static int PostalColumnLength;
    private static final String ALTKEY_pushkey = "pushkey";
    private static final String ALTKEY_adtkey = "adtkey";
    public static final String ALTKEY_eq_pushkey = "altkey=pushkey";
    public static final String _TABLE_NAME = "EventData";
    public static final String PFLD_deviceDesc = "$deviceDesc";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_latitude = "latitude";
    public static final String FLD_longitude = "longitude";
    public static final String FLD_gpsAge = "gpsAge";
    public static final String FLD_speedKPH = "speedKPH";
    public static final String FLD_heading = "heading";
    public static final String FLD_altitude = "altitude";
    public static final String FLD_transportID = "transportID";
    public static final String FLD_inputMask = "inputMask";
    public static final String FLD_outputMask = "outputMask";
    public static final String FLD_seatbeltMask = "seatbeltMask";
    public static final String FLD_address = "address";
    public static final String FLD_dataSource = "dataSource";
    public static final String FLD_rawData = "rawData";
    public static final String FLD_distanceKM = "distanceKM";
    public static final String FLD_odometerKM = "odometerKM";
    public static final String FLD_odometerOffsetKM = "odometerOffsetKM";
    public static final String FLD_geozoneIndex = "geozoneIndex";
    public static final String FLD_geozoneID = "geozoneID";
    private static final DBField[] StandardFieldInfo;
    public static final String FLD_streetAddress = "streetAddress";
    public static final String FLD_city = "city";
    public static final String FLD_stateProvince = "stateProvince";
    public static final String FLD_postalCode = "postalCode";
    public static final String FLD_country = "country";
    public static final String FLD_subdivision = "subdivision";
    public static final String FLD_speedLimitKPH = "speedLimitKPH";
    public static final String FLD_isTollRoad = "isTollRoad";
    public static final DBField[] AddressFieldInfo;
    public static final String FLD_gpsFixType = "gpsFixType";
    public static final String FLD_gpsFixStatus = "gpsFixStatus";
    public static final String FLD_horzAccuracy = "horzAccuracy";
    public static final String FLD_vertAccuracy = "vertAccuracy";
    public static final String FLD_HDOP = "HDOP";
    public static final String FLD_satelliteCount = "satelliteCount";
    public static final String FLD_batteryLevel = "batteryLevel";
    public static final String FLD_batteryVolts = "batteryVolts";
    public static final String FLD_signalStrength = "signalStrength";
    public static final DBField[] GPSFieldInfo;
    public static final String FLD_priority = "priority";
    public static final String FLD_entityID = "entityID";
    public static final String FLD_entityType = "entityType";
    public static final String FLD_driverID = "driverID";
    public static final String FLD_driverStatus = "driverStatus";
    public static final String FLD_driverMessage = "driverMessage";
    public static final String FLD_emailRecipient = "emailRecipient";
    public static final String FLD_sensorLow = "sensorLow";
    public static final String FLD_sensorHigh = "sensorHigh";
    public static final String FLD_costCenter = "costCenter";
    public static final String FLD_jobNumber = "jobNumber";
    public static final String FLD_rfidTag = "rfidTag";
    public static final String FLD_attachType = "attachType";
    public static final String FLD_attachData = "attachData";
    public static final DBField[] CustomFieldInfo;
    public static final String FLD_fuelTotal = "fuelTotal";
    public static final String FLD_engineRpm = "engineRpm";
    public static final String FLD_engineHours = "engineHours";
    public static final String FLD_engineOnHours = "engineOnHours";
    public static final String FLD_engineLoad = "engineLoad";
    public static final String FLD_engineTorque = "engineTorque";
    public static final String FLD_idleHours = "idleHours";
    public static final String FLD_workHours = "workHours";
    public static final String FLD_transOilTemp = "transOilTemp";
    public static final String FLD_coolantLevel = "coolantLevel";
    public static final String FLD_coolantTemp = "coolantTemp";
    public static final String FLD_intakeTemp = "intakeTemp";
    public static final String FLD_brakeGForce = "brakeGForce";
    public static final String FLD_acceleration = "acceleration";
    public static final String FLD_accelerometerXYZ = "accelerometerXYZ";
    public static final String FLD_oilPressure = "oilPressure";
    public static final String FLD_oilLevel = "oilLevel";
    public static final String FLD_oilTemp = "oilTemp";
    public static final String FLD_airPressure = "airPressure";
    public static final String FLD_airFilterPressure = "airFilterPressure";
    public static final String FLD_turboPressure = "turboPressure";
    public static final String FLD_ptoEngaged = "ptoEngaged";
    public static final String FLD_ptoHours = "ptoHours";
    public static final String FLD_throttlePos = "throttlePos";
    public static final String FLD_brakePos = "brakePos";
    public static final String FLD_j1708Fault = "j1708Fault";
    public static final String FLD_faultCode = "faultCode";
    public static final String FLD_malfunctionLamp = "malfunctionLamp";
    public static final String FLD_fuelLevel = "fuelLevel";
    public static final String FLD_fuelLevel2 = "fuelLevel2";
    public static final String FLD_fuelRemain = "fuelRemain";
    public static final String FLD_fuelTrip = "fuelTrip";
    public static final String FLD_fuelIdle = "fuelIdle";
    public static final String FLD_fuelPTO = "fuelPTO";
    public static final String FLD_fuelEngineOn = "fuelEngineOn";
    public static final String FLD_vBatteryVolts = "vBatteryVolts";
    public static final String FLD_fuelPressure = "fuelPressure";
    public static final String FLD_fuelUsage = "fuelUsage";
    public static final String FLD_fuelTemp = "fuelTemp";
    public static final String FLD_fuelEconomy = "fuelEconomy";
    public static final String FLD_brakePressure = "brakePressure";
    public static final String FLD_massAirFlowRate = "massAirFlowRate";
    public static final String FLD_tirePressure = "tirePressure";
    public static final String FLD_tireTemp = "tireTemp";
    public static final String FLD_tankLevel = "tankLevel";
    public static final DBField[] CANBUSFieldInfo;
    public static final String FLD_etaTimestamp = "etaTimestamp";
    public static final String FLD_etaUniqueID = "etaUniqueID";
    public static final String FLD_etaDistanceKM = "etaDistanceKM";
    public static final String FLD_etaLatitude = "etaLatitude";
    public static final String FLD_etaLongitude = "etaLongitude";
    public static final String FLD_stopID = "stopID";
    public static final String FLD_stopStatus = "stopStatus";
    public static final String FLD_stopIndex = "stopIndex";
    public static final DBField[] GarminFieldInfo;
    public static final String FLD_barometer = "barometer";
    public static final String FLD_ambientTemp = "ambientTemp";
    public static final String FLD_cabinTemp = "cabinTemp";
    public static final DBField[] AtmosphereFieldInfo;
    public static final String FLD_thermoAverage0 = "thermoAverage0";
    public static final String FLD_thermoAverage1 = "thermoAverage1";
    public static final String FLD_thermoAverage2 = "thermoAverage2";
    public static final String FLD_thermoAverage3 = "thermoAverage3";
    public static final String FLD_thermoAverage4 = "thermoAverage4";
    public static final String FLD_thermoAverage5 = "thermoAverage5";
    public static final String FLD_thermoAverage6 = "thermoAverage6";
    public static final String FLD_thermoAverage7 = "thermoAverage7";
    public static final DBField[] ThermoFieldInfo;
    public static final String FLD_analog0 = "analog0";
    public static final String FLD_analog1 = "analog1";
    public static final String FLD_analog2 = "analog2";
    public static final String FLD_analog3 = "analog3";
    public static final String FLD_pulseCount = "pulseCount";
    public static final DBField[] AnalogFieldInfo;
    public static final String FLD_cellTowerID = "cellTowerID";
    public static final String FLD_mobileCountryCode = "mobileCountryCode";
    public static final String FLD_mobileNetworkCode = "mobileNetworkCode";
    public static final String FLD_cellTimingAdvance = "cellTimingAdvance";
    public static final String FLD_locationAreaCode = "locationAreaCode";
    public static final String FLD_cellServingInfo = "cellServingInfo";
    public static final String FLD_cellLatitude = "cellLatitude";
    public static final String FLD_cellLongitude = "cellLongitude";
    public static final String FLD_cellAccuracy = "cellAccuracy";
    public static final DBField[] ServingCellTowerData;
    public static final String FLD_cellNeighborInfo0 = "cellNeighborInfo0";
    public static final String FLD_cellNeighborInfo1 = "cellNeighborInfo1";
    public static final String FLD_cellNeighborInfo2 = "cellNeighborInfo2";
    public static final String FLD_cellNeighborInfo3 = "cellNeighborInfo3";
    public static final String FLD_cellNeighborInfo4 = "cellNeighborInfo4";
    public static final String FLD_cellNeighborInfo5 = "cellNeighborInfo5";
    public static final DBField[] NeighborCellTowerData;
    private static final int COUNT_cellNeighborInfo = 6;
    public static final String FLD_leaseStartDate = "leaseStartDate";
    public static final String FLD_leaseEndDate = "leaseEndDate";
    public static final String FLD_leaseStartOdomKM = "leaseStartOdomKM";
    public static final String FLD_leaseAllowedDistKM = "leaseAllowedDistKM";
    public static final String FLD_leaseContractID = "leaseContractID";
    public static final DBField[] LeaseRentalData;
    public static final String FLD_sampleIndex = "sampleIndex";
    public static final String FLD_sampleID = "sampleID";
    public static final DBField[] WorkZoneGridData;
    public static final String FLD_dataPush = "dataPush";
    public static final DBField[] CreationTimeMillisecond;
    public static final String FLD_dayEngineStarts = "dayEngineStarts";
    public static final String FLD_dayIdleHours = "dayIdleHours";
    public static final String FLD_dayFuelIdle = "dayFuelIdle";
    public static final String FLD_dayWorkHours = "dayWorkHours";
    public static final String FLD_dayFuelWork = "dayFuelWork";
    public static final String FLD_dayFuelPTO = "dayFuelPTO";
    public static final String FLD_dayDistanceKM = "dayDistanceKM";
    public static final String FLD_dayFuelTotal = "dayFuelTotal";
    public static final DBField[] EndOfDaySummary;
    public static final String FLD_autoIndex = "autoIndex";
    public static final DBField[] AutoIncrementIndex;
    private static DBFactory<EventData> factory;
    private GeoPoint geoPoint = null;
    private boolean isActualOdometer = false;
    private static OdometerOffsetType DefaultOdometerOffsetType;
    private Geozone geozone = null;
    private static final EntityManager.EntityType DEFAULT_ENTITY_TYPE;
    private int entityTypeInt = -1;
    private boolean inputMaskExplicitlySet = false;
    private boolean outputMaskExplicitlySet = false;
    private static int Thermo_COUNT;
    private static Object Thermo_COUNT_lock;
    private Driver driver = null;
    private static boolean explicitSetMIL;
    private int eventIndex = -1;
    private boolean isLastEventInList = false;
    private double rptDistKM = 0.0;
    private GeoPoint rptDistGP = null;
    private boolean isStopped = true;
    private boolean isSynthesizedEvent = false;
    private PushpinIconIndexProvider iconIndexProvider = null;
    private int explicitPushpinIconIndex = -1;
    public static final String[] DEBUG_PUSHPINS;
    public static final String PPNAME_last = "last";
    public static final String PPNAME_fleet = "fleet";
    public static final String PPNAME_heading = "heading";
    public static final String PPNAME_stop = "stop";
    public static final String PPNAME_moving = "moving";
    public static final String PPNAME_all = "all";
    private EventData previousEventData = null;
    private EventData previousEventData_validGPS = null;
    private EventData nextEventData = null;
    private EventData nextEventData_validGPS = null;
    public static final String[] KEY_ACCOUNT;
    public static final String[] KEY_DEVICE_COUNT;
    public static final String[] KEY_DEVICE;
    public static final String[] KEY_EVENT_COUNT24;
    public static final String[] KEY_DEVICE_LINK;
    public static final String[] KEY_DEV_CONN_AGE;
    public static final String[] KEY_DEV_TRAILERS;
    public static final String[] KEY_DATETIME;
    public static final String[] KEY_DATE_YEAR;
    public static final String[] KEY_DATE_MONTH;
    public static final String[] KEY_DATE_DAY;
    public static final String[] KEY_DATE_DOW;
    public static final String[] KEY_TIMEZONE;
    public static final String[] KEY_TIME;
    private static final String[] KEY_STATUSDESC;
    private static final String[] KEY_GEOPOINT;
    private static final String[] KEY_LATITUDE;
    private static final String[] KEY_LONGITUDE;
    private static final String[] KEY_GPS_AGE;
    private static final String[] KEY_SPEED;
    private static final String[] KEY_SPEED_LIMIT;
    private static final String[] KEY_DIRECTION;
    private static final String[] KEY_HEADING;
    private static final String[] KEY_ODOMETER;
    private static final String[] KEY_DISTANCE;
    private static final String[] KEY_ALTITUDE;
    private static final String[] KEY_RPT_DISTANCE;
    private static final String[] KEY_BATTERY_LEVEL;
    private static final String[] KEY_BATTERY_VOLTS;
    private static final String[] KEY_VEH_BATTERY_V;
    private static final String[] KEY_FUEL_LEVEL;
    private static final String[] KEY_FUEL_LEVEL2;
    private static final String[] KEY_FUEL_VOLUME;
    private static final String[] KEY_TIRE_TEMP;
    private static final String[] KEY_TIRE_PRESSURE;
    private static final String[] KEY_ADDRESS;
    private static final String[] KEY_STREETADDR;
    private static final String[] KEY_CITY;
    private static final String[] KEY_STATE;
    private static final String[] KEY_POSTALCODE;
    private static final String[] KEY_SUBDIVISION;
    public static final String[] KEY_FAULT_CODE;
    public static final String[] KEY_FAULT_CODES;
    public static final String[] KEY_FAULT_HEADER;
    public static final String[] KEY_FAULT_DESC;
    private static final String[] KEY_GEOZONEID;
    private static final String[] KEY_GEOZONE;
    private static final String[] KEY_GEOZONENAME;
    private static final String[] KEY_ENTITYID;
    private static final String[] KEY_ENTITY;
    private static final String[] KEY_SERVICE_NOTES;
    private static final String[] KEY_MAPLINK;
    public static final String[] KEY_DRIVERID;
    public static final String[] KEY_DRIVER_DESC;
    public static final String[] KEY_DRIVER_BADGE;
    public static final String[] KEY_DRIVER_LICENSE;
    private static final String[] KEY_INPUT_MASK;
    private static final String[] KEY_INPUT_BIT;
    private static final String[] KEY_OUTPUT_MASK;
    private static final String[] KEY_OUTPUT_BIT;
    private static final String[] KEY_SEATBELT_MASK;
    private static final String[] KEY_SEATBELT_BIT;
    private static final String[] KEY_TEMPERATURE;
    private static final String[] KEY_TEMP_ALL;
    private static final String[] KEY_ETA_DATETIME;
    private static final String[] KEY_ETA_UNIQUE_ID;
    private static final String[] KEY_ETA_DISTANCE;
    private static final String[] KEY_ETA_GEOPOINT;
    private static final String[] KEY_STOP_ID;
    private static final String[] KEY_STOP_STATUS;
    private static final String[] KEY_STOP_INDEX;
    private static final String[] KEY_STOPPED_TIME;
    private static Comparator<EventData> devDescComparator;
    private static final String[] ARG_ACCOUNT;
    private static final String[] ARG_DEVICE;
    private static final String[] ARG_EVENTS_PER_SECOND;
    private static final String[] ARG_QUERY_ALL;
    private static final String[] ARG_ADDR_LEN;

    public static int _getPushpinIconIndex(String val, OrderedSet<String> iconKeys, int dft) {
        if (val != null) {
            if (iconKeys != null) {
                int ndx = iconKeys.indexOf((Object)val);
                if (ndx >= 0) {
                    return ndx;
                }
            } else {
                if (val.equalsIgnoreCase("black")) {
                    return 0;
                }
                if (val.equalsIgnoreCase("brown")) {
                    return 1;
                }
                if (val.equalsIgnoreCase("red")) {
                    return 2;
                }
                if (val.equalsIgnoreCase("orange")) {
                    return 3;
                }
                if (val.equalsIgnoreCase("yellow")) {
                    return 4;
                }
                if (val.equalsIgnoreCase("green")) {
                    return 5;
                }
                if (val.equalsIgnoreCase("blue")) {
                    return 6;
                }
                if (val.equalsIgnoreCase("purple")) {
                    return 7;
                }
                if (val.equalsIgnoreCase("gray")) {
                    return 8;
                }
                if (val.equalsIgnoreCase("white")) {
                    return 9;
                }
            }
        }
        return dft;
    }

    public static GPSFixType getGPSFixType(EventData e) {
        return e != null ? (GPSFixType)EnumTools.getValueOf(GPSFixType.class, (int)e.getGpsFixType()) : (GPSFixType)EnumTools.getDefault(GPSFixType.class);
    }

    private static String ADT_adtkey() {
        boolean dftVal = false;
        return RTConfig.getBoolean((String)"EventData.keyedAccountDeviceTime", (boolean)false) ? ALTKEY_adtkey : "";
    }

    private static String Altkey_AccountID() {
        String pushkey;
        StringBuffer AK = new StringBuffer();
        String adtkey = EventData.ADT_adtkey();
        if (!StringTools.isBlank((String)adtkey)) {
            if (AK.length() > 0) {
                AK.append(",");
            }
            AK.append(adtkey);
        }
        String string = pushkey = RTConfig.getBoolean((String)OPTCOLS_CreationTimeMillisecond, (boolean)false) ? ALTKEY_pushkey : "";
        if (!StringTools.isBlank((String)pushkey)) {
            if (AK.length() > 0) {
                AK.append(",");
            }
            AK.append(pushkey);
        }
        if (AK.length() <= 0) {
            return "";
        }
        return AK.insert(0, "altkey=").toString();
    }

    private static String Altkey_DeviceID() {
        return EventData.Altkey_AccountID();
    }

    private static String Altkey_Timestamp() {
        String adtkey = EventData.ADT_adtkey();
        return !StringTools.isBlank((String)adtkey) ? "altkey=" + adtkey : "";
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<EventData> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)EventData.TABLE_NAME(), (DBField[])StandardFieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, EventData.class, Key.class, (boolean)false, (boolean)false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
            DBField addrFld = factory.getField(FLD_address);
            AddressColumnLength = addrFld != null ? addrFld.getStringLength() : 0;
            DBField streetFld = factory.getField(FLD_streetAddress);
            StreetColumnLength = streetFld != null ? streetFld.getStringLength() : 0;
            DBField cityFld = factory.getField(FLD_city);
            CityColumnLength = cityFld != null ? cityFld.getStringLength() : 0;
            DBField stateFld = factory.getField(FLD_stateProvince);
            StateColumnLength = stateFld != null ? stateFld.getStringLength() : 0;
            DBField postalFld = factory.getField(FLD_postalCode);
            PostalColumnLength = postalFld != null ? postalFld.getStringLength() : 0;
            factory.setAllowInnoDBCOUNT(false);
        }
        return factory;
    }

    public EventData() {
    }

    public EventData(Key key) {
        super(key);
    }

    public static EventData copySynthesizedEvent(EventData evdb, int sc) {
        return EventData.copySynthesizedEvent(evdb, sc, 0L);
    }

    public static EventData copySynthesizedEvent(EventData evdb, int sc, long ts) {
        if (evdb == null || sc <= 0) {
            return null;
        }
        try {
            String acctID = evdb.getAccountID();
            String devID = evdb.getDeviceID();
            long timestamp = ts > 0L ? ts : evdb.getTimestamp();
            int statCode = sc;
            Key evk = new Key(acctID, devID, timestamp, statCode);
            EventData copyEv = (EventData)evk.getDBRecord();
            copyEv.setAllFieldValues(evdb);
            copyEv.setSynthesizedEvent(true);
            return copyEv;
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to copy EventData record", (Throwable)dbe);
            return null;
        }
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(EventData.class, (Locale)loc);
        return i18n.getString("EventData.description", "This table contains events which have been generated by all client devices.");
    }

    @Override
    public long getTimestamp() {
        return this.getFieldValue(FLD_timestamp, 0L);
    }

    public void setTimestamp(long v) {
        this.setFieldValue(FLD_timestamp, v);
    }

    public TimeZone getTimeZone() {
        Account a = this.getAccount();
        Device d = this.getDevice();
        if (d != null) {
            return d.getAssignedUserTimeZone();
        }
        if (a != null) {
            return a.getTimeZone(null);
        }
        return DateTime.getGMTTimeZone();
    }

    public static String getTimestampString(long timestamp, Account account, TimeZone tz, BasicPrivateLabel bpl) {
        String timeFmt;
        String dateFmt;
        Account a = account;
        String string = a != null ? a.getDateFormat() : (dateFmt = bpl != null ? bpl.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat());
        String string2 = a != null ? a.getTimeFormat() : (timeFmt = bpl != null ? bpl.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat());
        TimeZone tmz = tz != null ? tz : (a != null ? a.getTimeZone(null) : DateTime.getGMTTimeZone());
        DateTime dt = new DateTime(timestamp, tmz);
        return dt.format(dateFmt + " " + timeFmt + " z");
    }

    public static String getTimestampTime(long timestamp, Account account, TimeZone tz, BasicPrivateLabel bpl) {
        String timeFmt;
        Account a = account;
        String string = a != null ? a.getTimeFormat() : (timeFmt = bpl != null ? bpl.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat());
        TimeZone tmz = tz != null ? tz : (a != null ? a.getTimeZone(null) : DateTime.getGMTTimeZone());
        DateTime dt = new DateTime(timestamp, tmz);
        return dt.format(timeFmt);
    }

    public static String getTimestampYear(long timestamp, TimeZone tz) {
        TimeZone tmz = tz != null ? tz : DateTime.getGMTTimeZone();
        DateTime dt = new DateTime(timestamp, tmz);
        return String.valueOf(dt.getYear());
    }

    public static String getTimestampMonthNumber(long timestamp, TimeZone tz) {
        TimeZone tmz = tz != null ? tz : DateTime.getGMTTimeZone();
        DateTime dt = new DateTime(timestamp, tmz);
        return String.valueOf(dt.getMonth1());
    }

    public static String getTimestampMonth(long timestamp, boolean abbrev, TimeZone tz, Locale locale) {
        TimeZone tmz = tz != null ? tz : DateTime.getGMTTimeZone();
        DateTime dt = new DateTime(timestamp, tmz);
        return DateTime.getMonthName((int)dt.getMonth1(), (boolean)abbrev);
    }

    public static String getTimestampDayOfMonth(long timestamp, TimeZone tz) {
        TimeZone tmz = tz != null ? tz : DateTime.getGMTTimeZone();
        DateTime dt = new DateTime(timestamp, tmz);
        return String.valueOf(dt.getDayOfMonth());
    }

    public static String getTimestampDayOfWeek(long timestamp, boolean abbrev, TimeZone tz, Locale locale) {
        TimeZone tmz = tz != null ? tz : DateTime.getGMTTimeZone();
        DateTime dt = new DateTime(timestamp, tmz);
        return DateTime.getDayName((int)dt.getDayOfWeek(), (boolean)abbrev);
    }

    public String getTimestampString(BasicPrivateLabel bpl) {
        long ts = this.getTimestamp();
        Account acct = this.getAccount();
        TimeZone tmz = this.getTimeZone();
        return EventData.getTimestampString(ts, acct, tmz, bpl);
    }

    public String getTimestampString() {
        long ts = this.getTimestamp();
        Account acct = this.getAccount();
        TimeZone tmz = this.getTimeZone();
        return EventData.getTimestampString(ts, acct, tmz, null);
    }

    public String getTimestampTime() {
        long ts = this.getTimestamp();
        Account acct = this.getAccount();
        TimeZone tmz = this.getTimeZone();
        return EventData.getTimestampTime(ts, acct, tmz, null);
    }

    public String getTimestampYear() {
        long ts = this.getTimestamp();
        TimeZone tmz = this.getTimeZone();
        return EventData.getTimestampYear(ts, tmz);
    }

    public String getTimestampMonth(boolean abbrev, Locale locale) {
        long ts = this.getTimestamp();
        TimeZone tmz = this.getTimeZone();
        return EventData.getTimestampMonth(ts, abbrev, tmz, locale);
    }

    public String getTimestampMonthNumber() {
        long ts = this.getTimestamp();
        TimeZone tmz = this.getTimeZone();
        return EventData.getTimestampMonthNumber(ts, tmz);
    }

    public String getTimestampDayOfMonth() {
        long ts = this.getTimestamp();
        TimeZone tmz = this.getTimeZone();
        return EventData.getTimestampDayOfMonth(ts, tmz);
    }

    public String getTimestampDayOfWeek(boolean abbrev, Locale locale) {
        long ts = this.getTimestamp();
        TimeZone tmz = this.getTimeZone();
        return EventData.getTimestampDayOfWeek(ts, abbrev, tmz, locale);
    }

    @Override
    public long getCreationAge() {
        long ts = this.getTimestamp();
        long ca = this.getCreationTime();
        return ca > ts ? ca - ts : 0L;
    }

    @Override
    public int getStatusCode() {
        return this.getFieldValue(FLD_statusCode, 0);
    }

    @Override
    public StatusCodeProvider getStatusCodeProvider(BasicPrivateLabel bpl) {
        Device dev = this.getDevice();
        int code = this.getStatusCode();
        return StatusCode.getStatusCodeProvider(dev, code, bpl, null);
    }

    public String getStatusCodeForegroundColor(BasicPrivateLabel bpl) {
        Device dev = this.getDevice();
        int code = this.getStatusCode();
        return StatusCode.getForegroundColor(dev, code, bpl, null);
    }

    public String getStatusCodeBackgroundColor(BasicPrivateLabel bpl) {
        Device dev = this.getDevice();
        int code = this.getStatusCode();
        return StatusCode.getBackgroundColor(dev, code, bpl, null);
    }

    public String getStatusCodeHex() {
        return StatusCodes.GetHex(this.getStatusCode());
    }

    @Override
    public String getStatusCodeDescription(BasicPrivateLabel bpl) {
        Device dev = this.getDevice();
        int code = this.getStatusCode();
        return StatusCode.getDescription(dev, code, bpl, null);
    }

    public String getStatusCodeIconSelector(BasicPrivateLabel bpl) {
        Device dev = this.getDevice();
        int code = this.getStatusCode();
        return StatusCode.getIconSelector(dev, code, bpl);
    }

    public String getStatusCodeIconName(BasicPrivateLabel bpl) {
        Device dev = this.getDevice();
        int code = this.getStatusCode();
        return StatusCode.getIconName(dev, code, bpl);
    }

    public void setStatusCode(int v) {
        this.setFieldValue(FLD_statusCode, v >= 0 ? v : 0);
    }

    public String getDataSource() {
        return this.getFieldValue(FLD_dataSource, "");
    }

    public void setDataSource(String v) {
        this.setFieldValue(FLD_dataSource, StringTools.trim((String)v));
    }

    public String getTransportID() {
        return this.getFieldValue(FLD_transportID, "");
    }

    public void setTransportID(String v) {
        this.setFieldValue(FLD_transportID, StringTools.trim((String)v));
    }

    public String getRawData() {
        return this.getFieldValue(FLD_rawData, "");
    }

    public void setRawData(String v) {
        this.setFieldValue(FLD_rawData, StringTools.trim((String)v));
    }

    public double getBestLatitude() {
        if (this.isValidGeoPoint()) {
            return this.getLatitude();
        }
        return this.getCellLatitude();
    }

    public double getBestLongitude() {
        if (this.isValidGeoPoint()) {
            return this.getLongitude();
        }
        return this.getCellLongitude();
    }

    @Override
    public GeoPoint getBestGeoPoint() {
        if (this.isValidGeoPoint()) {
            return this.getGeoPoint();
        }
        return this.getCellGeoPoint();
    }

    @Override
    public double getBestAccuracy() {
        if (this.isValidGeoPoint()) {
            return this.getHorzAccuracy();
        }
        return this.getCellAccuracy();
    }

    @Override
    public GeoPoint getGeoPoint() {
        if (this.geoPoint == null) {
            this.geoPoint = this.isValidGeoPoint() ? new GeoPoint(this.getLatitude(), this.getLongitude()) : GeoPoint.INVALID_GEOPOINT;
        }
        return this.geoPoint;
    }

    public void setGeoPoint(double lat, double lng) {
        this.setLatitude(lat);
        this.setLongitude(lng);
    }

    public void setGeoPoint(GeoPoint gp) {
        if (gp == null) {
            this.setLatitude(0.0);
            this.setLongitude(0.0);
        } else if (!gp.isValid()) {
            if (!GeoPoint.isOrigin((GeoPoint)gp)) {
                Print.logInfo((String)("GeoPoint is invalid: " + gp), (Object[])new Object[0]);
            }
            this.setLatitude(0.0);
            this.setLongitude(0.0);
        } else {
            this.setLatitude(gp.getLatitude());
            this.setLongitude(gp.getLongitude());
        }
    }

    @Override
    public boolean isValidGeoPoint() {
        return GeoPoint.isValid((double)this.getLatitude(), (double)this.getLongitude());
    }

    @Override
    public double getLatitude() {
        return this.getFieldValue(FLD_latitude, 0.0);
    }

    public void setLatitude(double v) {
        this.setFieldValue(FLD_latitude, v);
        this.geoPoint = null;
    }

    @Override
    public double getLongitude() {
        return this.getFieldValue(FLD_longitude, 0.0);
    }

    public void setLongitude(double v) {
        this.setFieldValue(FLD_longitude, v);
        this.geoPoint = null;
    }

    @Override
    public long getGpsAge() {
        return this.getFieldValue(FLD_gpsAge, 0L);
    }

    public void setGpsAge(long v) {
        this.setFieldValue(FLD_gpsAge, v >= 0L ? v : 0L);
    }

    @Override
    public double getSpeedKPH() {
        return this.getFieldValue(FLD_speedKPH, 0.0);
    }

    public void setSpeedKPH(double v) {
        this.setFieldValue(FLD_speedKPH, v);
    }

    public double getSpeedMPH() {
        return this.getSpeedKPH() * 0.621371192237334;
    }

    @Override
    public double getHeading() {
        return this.getFieldValue("heading", 0.0);
    }

    public void setHeading(double v) {
        this.setFieldValue("heading", v);
    }

    @Override
    public double getAltitude() {
        return this.getFieldValue(FLD_altitude, 0.0);
    }

    public String getAltitudeString(boolean inclUnits, Locale locale) {
        I18N i18n = I18N.getI18N(EventData.class, (Locale)locale);
        Account.AltitudeUnits altUnits = Account.getAltitudeUnits(this.getAccount());
        double alt = altUnits.convertFromMeters(this.getAltitude());
        String distUnitsStr = "?";
        distUnitsStr = altUnits.isFeet() ? i18n.getString("EventData.units.feet", "feet") : (altUnits.isMeters() ? i18n.getString("EventData.units.meters", "meters") : altUnits.toString(locale));
        String altStr = StringTools.format((double)alt, (String)"0");
        return inclUnits ? altStr + " " + distUnitsStr : altStr;
    }

    public void setAltitude(double v) {
        this.setFieldValue(FLD_altitude, v);
    }

    @Override
    public double getOdometerKM() {
        return this.getFieldValue(FLD_odometerKM, 0.0);
    }

    public void setOdometerKM(double v) {
        this.setFieldValue(FLD_odometerKM, v);
    }

    public void setOdometerKM(double v, boolean actualOdom) {
        this.setFieldValue(FLD_odometerKM, v);
        this.isActualOdometer = actualOdom;
    }

    public boolean isActualOdometer() {
        return this.isActualOdometer;
    }

    public boolean hasOdometerOffsetKM() {
        if (!super.hasOptionalFieldValue(FLD_odometerOffsetKM)) {
            return false;
        }
        double ofs = this.getOdometerOffsetKM();
        return ofs != 0.0;
    }

    public double getOdometerOffsetKM() {
        return this.getFieldValue(FLD_odometerOffsetKM, 0.0);
    }

    public void setOdometerOffsetKM(double v) {
        this.setFieldValue(FLD_odometerOffsetKM, v);
    }

    public double getOdometerOffsetKM(OdometerOffsetType offsType) {
        Device dev;
        if (offsType == null) {
            if (DefaultOdometerOffsetType == null) {
                String T = StringTools.trim((String)RTConfig.getString((String)"EventData.odometerOffsetType", (String)"")).toUpperCase();
                if (T.startsWith("NONE")) {
                    DefaultOdometerOffsetType = OdometerOffsetType.NONE;
                    Print.logInfo((String)("Default Odometer Offset Type: " + (Object)((Object)DefaultOdometerOffsetType)), (Object[])new Object[0]);
                    Print.logWarn((String)"(Odometer offset will not be applied!)", (Object[])new Object[0]);
                } else if (T.startsWith("DEVICE")) {
                    DefaultOdometerOffsetType = OdometerOffsetType.DEVICE_ONLY;
                    Print.logInfo((String)("Default Odometer Offset Type: " + (Object)((Object)DefaultOdometerOffsetType)), (Object[])new Object[0]);
                    Print.logInfo((String)"(Odometer offset obtained from the Device record only)", (Object[])new Object[0]);
                } else if (T.startsWith("EVENT")) {
                    DefaultOdometerOffsetType = OdometerOffsetType.EVENT_ONLY;
                    Print.logInfo((String)("Default Odometer Offset Type: " + (Object)((Object)DefaultOdometerOffsetType)), (Object[])new Object[0]);
                    Print.logInfo((String)"(Odometer offset obtained from the EventData record only)", (Object[])new Object[0]);
                } else {
                    DefaultOdometerOffsetType = OdometerOffsetType.BEST;
                    Print.logInfo((String)("Default Odometer Offset Type: " + (Object)((Object)DefaultOdometerOffsetType)), (Object[])new Object[0]);
                    Print.logInfo((String)"(Odometer offset obtained from the EventData or Device records)", (Object[])new Object[0]);
                }
            }
            offsType = DefaultOdometerOffsetType;
        }
        switch (offsType) {
            case NONE: {
                return 0.0;
            }
            case DEVICE_ONLY: {
                dev = this.getDevice();
                if (dev != null) {
                    double ofs = dev.getOdometerOffsetKM();
                    return ofs;
                }
                return 0.0;
            }
            case EVENT_ONLY: {
                double ofs = this.getOdometerOffsetKM();
                return ofs;
            }
        }
        if (this.hasOdometerOffsetKM()) {
            double ofs = this.getOdometerOffsetKM();
            return ofs;
        }
        dev = this.getDevice();
        if (dev != null) {
            double ofs = dev.getOdometerOffsetKM();
            return ofs;
        }
        return 0.0;
    }

    public double getOdometerWithOffsetKM() {
        double odom = this.getOdometerKM();
        return odom += this.getOdometerOffsetKM(null);
    }

    public double getDistanceKM() {
        return this.getFieldValue(FLD_distanceKM, 0.0);
    }

    public void setDistanceKM(double v) {
        this.setFieldValue(FLD_distanceKM, v);
    }

    public long getGeozoneIndex() {
        return this.getFieldValue(FLD_geozoneIndex, 0L);
    }

    public void setGeozoneIndex(long v) {
        this.setFieldValue(FLD_geozoneIndex, v);
    }

    public boolean hasGeozoneID() {
        return !StringTools.isBlank((String)this.getGeozoneID());
    }

    @Override
    public String getGeozoneID() {
        return this.getFieldValue(FLD_geozoneID, "");
    }

    public void setGeozoneID(String v) {
        this.setFieldValue(FLD_geozoneID, StringTools.trim((String)v));
    }

    public void setGeozone(Geozone zone) {
        this.geozone = zone;
        this.setGeozoneID(zone != null ? zone.getGeozoneID() : "");
    }

    public boolean hasGeozone() {
        return this.geozone != null;
    }

    public Geozone getGeozone() {
        if (this.geozone == null && this.hasGeozoneID()) {
            String gid = this.getGeozoneID();
            try {
                Geozone[] gz = Geozone.getGeozone(this.getAccount(), gid);
                this.geozone = !ListTools.isEmpty((Object[])gz) ? gz[0] : null;
            }
            catch (DBNotFoundException dbnfe) {
                Print.logWarn((String)("Geozone not found: " + this.getAccountID() + "/" + gid), (Object[])new Object[0]);
                this.geozone = null;
            }
            catch (DBException dbe) {
                Print.logException((String)("Error reading Geozone: " + this.getAccountID() + "/" + gid), (Throwable)dbe);
                this.geozone = null;
            }
        }
        return this.geozone;
    }

    public String getGeozoneDescription() {
        Geozone zone = this.getGeozone();
        return zone != null ? zone.getDescription() : "";
    }

    public String getGeozoneDisplayName() {
        Geozone zone = this.getGeozone();
        return zone != null ? zone.getDisplayName() : "";
    }

    public int getPriority() {
        return this.getFieldValue(FLD_priority, 0);
    }

    public void setPriority(int v) {
        this.setFieldValue(FLD_priority, v);
    }

    public String getEntityID() {
        return this.getFieldValue(FLD_entityID, "");
    }

    public void setEntityID(String v) {
        this.setFieldValue(FLD_entityID, StringTools.trim((String)v));
    }

    public String[] getEntityIDList(String altID) {
        String attachType;
        HashSet<String> entitySet = null;
        String entityID = this.getEntityID();
        if (!StringTools.isBlank((String)altID) || !StringTools.isBlank((String)entityID)) {
            entitySet = new HashSet<String>();
            if (!StringTools.isBlank((String)altID)) {
                entitySet.add(altID.trim());
            }
            if (!StringTools.isBlank((String)entityID)) {
                entitySet.add(entityID.trim());
            }
        }
        if (!(attachType = this.getAttachType()).equalsIgnoreCase("gts/entity-csv")) {
            return ListTools.isEmpty(entitySet) ? null : entitySet.toArray(new String[entitySet.size()]);
        }
        byte[] data = this.getAttachData();
        if (ListTools.isEmpty((byte[])data)) {
            return ListTools.isEmpty(entitySet) ? null : entitySet.toArray(new String[entitySet.size()]);
        }
        String entCSV = StringTools.trim((String)StringTools.toStringValue((byte[])data, (char)' '));
        if (entCSV != null) {
            String[] entIDList;
            if (entitySet == null) {
                entitySet = new HashSet();
            }
            for (String entID : entIDList = StringTools.split((String)entCSV, (char)',')) {
                if (StringTools.isBlank((String)entID)) continue;
                entitySet.add(entID.trim());
            }
        }
        return ListTools.isEmpty(entitySet) ? null : entitySet.toArray(new String[entitySet.size()]);
    }

    public EntityManager.EntityType _getEntityType(EntityManager.EntityType dft) {
        int entTypeInt;
        Integer v = (Integer)this.getFieldValue(FLD_entityType);
        int n = entTypeInt = v != null ? v : this.entityTypeInt;
        if (entTypeInt > 0) {
            return (EntityManager.EntityType)EnumTools.getValueOf(EntityManager.EntityType.class, (int)entTypeInt);
        }
        return EntityManager.getEntityTypeForStatusCode(this.getStatusCode(), dft);
    }

    public int getEntityType() {
        Integer v = (Integer)this.getFieldValue(FLD_entityType);
        int ETI = v != null ? v : this.entityTypeInt;
        return ETI >= 0 ? ETI : DEFAULT_ENTITY_TYPE.getIntValue();
    }

    public void setEntityType(int v) {
        int entType = ((EntityManager.EntityType)EnumTools.getValueOf(EntityManager.EntityType.class, (int)v)).getIntValue();
        this.setFieldValue(FLD_entityType, entType);
        this.entityTypeInt = v;
    }

    public void setEntityType(EntityManager.EntityType v) {
        int entType = ((EntityManager.EntityType)EnumTools.getValueOf(EntityManager.EntityType.class, (Enum)v)).getIntValue();
        this.setEntityType(entType);
    }

    public void setEntityType(String v, Locale locale) {
        int entType = ((EntityManager.EntityType)EnumTools.getValueOf(EntityManager.EntityType.class, (String)v, (Locale)locale)).getIntValue();
        this.setEntityType(entType);
    }

    public String getEntityTypeDescription(Locale loc) {
        EntityManager.EntityType entType = this._getEntityType(null);
        if (entType != null) {
            return entType.toString(loc);
        }
        return "?";
    }

    public int getGpsFixType() {
        Integer v = (Integer)this.getFieldValue(FLD_gpsFixType);
        return v != null ? v.intValue() : ((GPSFixType)EnumTools.getDefault(GPSFixType.class)).getIntValue();
    }

    public void setGpsFixType(int v) {
        this.setFieldValue(FLD_gpsFixType, ((GPSFixType)EnumTools.getValueOf(GPSFixType.class, (int)v)).getIntValue());
    }

    public void setGpsFixType(GPSFixType v) {
        this.setFieldValue(FLD_gpsFixType, ((GPSFixType)EnumTools.getValueOf(GPSFixType.class, (Enum)v)).getIntValue());
    }

    public void setGpsFixType(String v, Locale locale) {
        this.setFieldValue(FLD_gpsFixType, ((GPSFixType)EnumTools.getValueOf(GPSFixType.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getGpsFixTypeDescription(Locale loc) {
        GPSFixType fixType = EventData.getGPSFixType(this);
        if (fixType.equals((Object)GPSFixType.UNKNOWN)) {
            if (this.isValidGeoPoint()) {
                return GPSFixType.n2D.toString(loc);
            }
            return GPSFixType.NONE.toString(loc);
        }
        return fixType.toString(loc);
    }

    public long getGpsFixStatus() {
        Long v = (Long)this.getFieldValue(FLD_gpsFixStatus);
        return v != null ? v : 0L;
    }

    public void setGpsFixStatus(long v) {
        this.setFieldValue(FLD_gpsFixStatus, v >= 0L ? v : 0L);
    }

    @Override
    public double getHorzAccuracy() {
        return this.getFieldValue(FLD_horzAccuracy, 0.0);
    }

    public void setHorzAccuracy(double v) {
        this.setFieldValue(FLD_horzAccuracy, v);
    }

    public double getVertAccuracy() {
        return this.getFieldValue(FLD_vertAccuracy, 0.0);
    }

    public void setVertAccuracy(double v) {
        this.setFieldValue(FLD_vertAccuracy, v);
    }

    public double getHDOP() {
        return this.getFieldValue(FLD_HDOP, 0.0);
    }

    public void setHDOP(double v) {
        this.setFieldValue(FLD_HDOP, v);
    }

    @Override
    public int getSatelliteCount() {
        return this.getFieldValue(FLD_satelliteCount, 0);
    }

    public void setSatelliteCount(int v) {
        this.setFieldValue(FLD_satelliteCount, v < 0 ? 0 : v);
    }

    @Override
    public double getBatteryLevel() {
        return this.getFieldValue(FLD_batteryLevel, 0.0);
    }

    public void setBatteryLevel(double v) {
        this.setFieldValue(FLD_batteryLevel, v);
    }

    public double getBatteryVolts() {
        return this.getFieldValue(FLD_batteryVolts, 0.0);
    }

    public void setBatteryVolts(double v) {
        this.setFieldValue(FLD_batteryVolts, v);
    }

    public double getSignalStrength() {
        return this.getFieldValue(FLD_signalStrength, 0.0);
    }

    public void setSignalStrength(double v) {
        this.setFieldValue(FLD_signalStrength, v);
    }

    public boolean hasAddress() {
        return !this.getAddress().equals("");
    }

    @Override
    public String getAddress() {
        String v = (String)this.getFieldValue(FLD_address);
        return StringTools.trim((String)v);
    }

    public String getAddress(boolean lazyUpdate) {
        String v = this.getAddress();
        if (lazyUpdate && v.equals("")) {
            try {
                Set<String> updFlds = this.updateAddress(true, false);
                if (!ListTools.isEmpty(updFlds)) {
                    this.update(updFlds);
                }
            }
            catch (SlowOperationException soe) {
            }
            catch (DBException dbe) {
                dbe.printException();
            }
            v = this.getAddress();
        }
        return v;
    }

    public void setAddress(String v) {
        String addr = StringTools.trim((String)v);
        if (AddressColumnLength > 0 && addr.length() >= AddressColumnLength) {
            int newLen = AddressColumnLength - 1;
            addr = addr.substring(0, newLen).trim();
        }
        this.setFieldValue(FLD_address, addr);
    }

    public void reloadAddress() {
        this.reload(new String[]{FLD_address, FLD_streetAddress, FLD_city, FLD_stateProvince, FLD_postalCode, FLD_country, FLD_subdivision, FLD_speedLimitKPH, FLD_isTollRoad});
    }

    public Set<String> updateAddress(boolean fastOnly) throws SlowOperationException {
        return this.updateAddress(fastOnly, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> updateAddress(boolean fastOnly, boolean force) throws SlowOperationException {
        double evLon;
        Geozone[] gz;
        if (!force && this.hasAddress()) {
            return null;
        }
        Account acct = this.getAccount();
        if (acct == null) {
            return null;
        }
        Account.GeocoderMode geocoderMode = Account.getGeocoderMode(acct);
        if (geocoderMode.isNone()) {
            return null;
        }
        int statusCode = this.getStatusCode();
        if (statusCode == 62000) {
            String geozoneID;
            long clientId;
            gz = null;
            if ((gz == null || gz.length == 0) && (clientId = this.getGeozoneIndex()) > 0L) {
                gz = Geozone.getClientIDZones(acct.getAccountID(), clientId);
            }
            if (!(gz != null && gz.length != 0 || StringTools.isBlank((String)(geozoneID = this.getGeozoneID())))) {
                try {
                    gz = Geozone.getGeozone(acct, geozoneID);
                }
                catch (DBNotFoundException dbnfe) {
                    Print.logWarn((String)("Geozone not found: " + acct.getAccountID() + "/" + geozoneID), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logException((String)("Error reading Geozone: " + acct.getAccountID() + "/" + geozoneID), (Throwable)dbe);
                }
            }
            if (gz != null && gz.length > 0 && gz[0].isReverseGeocode(this.getDeviceID())) {
                HashSet<String> updFields = new HashSet<String>();
                if (gz[0].isClientUpload()) {
                    this.setGeozoneIndex(gz[0].getClientID());
                    updFields.add(FLD_geozoneIndex);
                }
                this.setGeozoneID(gz[0].getGeozoneID());
                updFields.add(FLD_geozoneID);
                this.setAddress(gz[0].getDescription());
                updFields.add(FLD_address);
                this.setStreetAddress(gz[0].getStreetAddress());
                updFields.add(FLD_streetAddress);
                this.setCity(gz[0].getCity());
                updFields.add(FLD_city);
                this.setStateProvince(gz[0].getStateProvince());
                updFields.add(FLD_stateProvince);
                this.setPostalCode(gz[0].getPostalCode());
                updFields.add(FLD_postalCode);
                this.setCountry(gz[0].getCountry());
                updFields.add(FLD_country);
                this.setSubdivision(gz[0].getSubdivision());
                updFields.add(FLD_subdivision);
                return updFields;
            }
        } else if (statusCode == 61968) {
            String geozoneID;
            long clientId;
            gz = null;
            if ((gz == null || gz.length == 0) && (clientId = this.getGeozoneIndex()) > 0L) {
                gz = Geozone.getClientIDZones(acct.getAccountID(), clientId);
            }
            if (!(gz != null && gz.length != 0 || StringTools.isBlank((String)(geozoneID = this.getGeozoneID())))) {
                try {
                    gz = Geozone.getGeozone(acct, geozoneID);
                }
                catch (DBNotFoundException dbnfe) {
                    Print.logWarn((String)("Geozone not found: " + acct.getAccountID() + "/" + geozoneID), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logException((String)("Error reading Geozone: " + acct.getAccountID() + "/" + geozoneID), (Throwable)dbe);
                }
            }
            if (gz != null && gz.length > 0 && gz[0].isReverseGeocode(this.getDeviceID())) {
                HashSet<String> updFields = new HashSet<String>();
                if (gz[0].isClientUpload()) {
                    this.setGeozoneIndex(gz[0].getClientID());
                    updFields.add(FLD_geozoneIndex);
                }
                this.setGeozoneID(gz[0].getGeozoneID());
                updFields.add(FLD_geozoneID);
                this.setAddress(gz[0].getDescription());
                updFields.add(FLD_address);
                this.setStreetAddress(gz[0].getStreetAddress());
                updFields.add(FLD_streetAddress);
                this.setCity(gz[0].getCity());
                updFields.add(FLD_city);
                this.setStateProvince(gz[0].getStateProvince());
                updFields.add(FLD_stateProvince);
                this.setPostalCode(gz[0].getPostalCode());
                updFields.add(FLD_postalCode);
                this.setCountry(gz[0].getCountry());
                updFields.add(FLD_country);
                this.setSubdivision(gz[0].getSubdivision());
                updFields.add(FLD_subdivision);
                return updFields;
            }
        }
        GeoPoint addrGP = null;
        double evLat = this.getLatitude();
        if (GeoPoint.isValid((double)evLat, (double)(evLon = this.getLongitude()))) {
            addrGP = new GeoPoint(evLat, evLon);
        } else {
            double cellLon;
            double cellLat = this.getCellLatitude();
            if (GeoPoint.isValid((double)cellLat, (double)(cellLon = this.getCellLongitude()))) {
                addrGP = new GeoPoint(cellLat, cellLon);
            } else {
                return null;
            }
        }
        Geozone gzone = Geozone.getGeozone(acct.getAccountID(), null, addrGP, true);
        if (gzone != null && !gzone.isDeviceInGroup(this.getDeviceID())) {
            gzone = null;
        }
        if (gzone != null) {
            HashSet<String> updFields = new HashSet<String>();
            Print.logInfo((String)("Found Geozone : " + gzone.getGeozoneID() + " - " + gzone.getDescription()), (Object[])new Object[0]);
            if (gzone.isClientUpload() && this.getGeozoneIndex() <= 0L) {
                this.setGeozoneIndex(gzone.getClientID());
                updFields.add(FLD_geozoneIndex);
            }
            this.setGeozoneID(gzone.getGeozoneID());
            updFields.add(FLD_geozoneID);
            this.setAddress(gzone.getDescription());
            updFields.add(FLD_address);
            this.setStreetAddress(gzone.getStreetAddress());
            updFields.add(FLD_streetAddress);
            this.setCity(gzone.getCity());
            updFields.add(FLD_city);
            this.setStateProvince(gzone.getStateProvince());
            updFields.add(FLD_stateProvince);
            this.setPostalCode(gzone.getPostalCode());
            updFields.add(FLD_postalCode);
            this.setCountry(gzone.getCountry());
            updFields.add(FLD_country);
            this.setSubdivision(gzone.getSubdivision());
            updFields.add(FLD_subdivision);
            return updFields;
        }
        BasicPrivateLabel privLabel = acct.getPrivateLabel();
        if (!geocoderMode.okFull() && !StatusCodes.IsHighPriority(statusCode, privLabel)) {
            Print.logDebug((String)("Skipping reverse-geocode per Account geocoderMode: " + acct.getAccountID()), (Object[])new Object[0]);
            return null;
        }
        ReverseGeocodeProvider rgp = privLabel.getReverseGeocodeProvider();
        if (rgp == null) {
            String acctID = this.getAccountID();
            if (acct.hasPrivateLabel()) {
                Print.logInfo((String)"[Account '%s'] PrivateLabel '%s' does not define a ReverseGeocodeProvider", (Object[])new Object[]{acctID, privLabel});
            } else {
                Print.logInfo((String)"No PrivateLabel (thus no ReverseGeocodeProvider) for Account '%s'", (Object[])new Object[]{acctID});
            }
            return null;
        }
        if (!rgp.isEnabled()) {
            Print.logInfo((String)("ReverseGeocodeProvider disabled: " + rgp.getName()), (Object[])new Object[0]);
            return null;
        }
        if (fastOnly && !rgp.isFastOperation()) {
            throw new SlowOperationException("'fast' requested, and this operation is 'slow'");
        }
        ReverseGeocode rg = null;
        try {
            privLabel.pushRTProperties();
            privLabel.getLocaleString();
            boolean cache = this.getSpeedKPH() <= 0.0;
            rg = rgp.getReverseGeocode(addrGP, privLabel.getLocaleString(), cache);
        }
        catch (Throwable th) {
        }
        finally {
            privLabel.popRTProperties();
        }
        if (rg != null) {
            HashSet<String> updFields = new HashSet<String>();
            if (rg.hasFullAddress()) {
                this.setAddress(rg.getFullAddress());
                updFields.add(FLD_address);
            }
            if (rg.hasStreetAddress()) {
                this.setStreetAddress(rg.getStreetAddress());
                updFields.add(FLD_streetAddress);
            }
            if (rg.hasCity()) {
                this.setCity(rg.getCity());
                updFields.add(FLD_city);
            }
            if (rg.hasStateProvince()) {
                this.setStateProvince(rg.getStateProvince());
                updFields.add(FLD_stateProvince);
            }
            if (rg.hasPostalCode()) {
                this.setPostalCode(rg.getPostalCode());
                updFields.add(FLD_postalCode);
            }
            if (rg.hasCountryCode()) {
                this.setCountry(rg.getCountryCode());
                updFields.add(FLD_country);
            }
            if (rg.hasSubdivision()) {
                this.setSubdivision(rg.getSubdivision());
                updFields.add(FLD_subdivision);
            }
            if (rg.hasSpeedLimitKPH()) {
                this.setSpeedLimitKPH(rg.getSpeedLimitKPH());
                updFields.add(FLD_speedLimitKPH);
            }
            if (rg.hasIsTollRoad()) {
                this.setIsTollRoad(rg.getIsTollRoad());
                updFields.add(FLD_isTollRoad);
            }
            return !updFields.isEmpty() ? updFields : null;
        }
        Print.logInfo((String)("No RG Address found [" + rgp.getName() + "]: " + addrGP), (Object[])new Object[0]);
        return null;
    }

    public String getStreetAddress() {
        String v = (String)this.getFieldValue(FLD_streetAddress);
        if (v == null || v.equals("")) {
            v = "";
        }
        return v;
    }

    public void setStreetAddress(String v) {
        String street = StringTools.trim((String)v);
        if (StreetColumnLength > 0 && street.length() >= StreetColumnLength) {
            int newLen = StreetColumnLength - 1;
            street = street.substring(0, newLen).trim();
        }
        this.setFieldValue(FLD_streetAddress, street);
    }

    public String getCity() {
        String v = (String)this.getFieldValue(FLD_city);
        if (v == null || v.equals("")) {
            v = "";
        }
        return v;
    }

    public void setCity(String v) {
        String city = StringTools.trim((String)v);
        if (CityColumnLength > 0 && city.length() >= CityColumnLength) {
            int newLen = CityColumnLength - 1;
            city = city.substring(0, newLen).trim();
        }
        this.setFieldValue(FLD_city, city);
    }

    public String getStateProvince() {
        String v = (String)this.getFieldValue(FLD_stateProvince);
        if (v == null || v.equals("")) {
            v = "";
        }
        return v;
    }

    public void setStateProvince(String v) {
        String state = StringTools.trim((String)v);
        if (StateColumnLength > 0 && state.length() >= StateColumnLength) {
            int newLen = StateColumnLength - 1;
            state = state.substring(0, newLen).trim();
        }
        this.setFieldValue(FLD_stateProvince, state);
    }

    public String getPostalCode() {
        String v = (String)this.getFieldValue(FLD_postalCode);
        if (v == null || v.equals("")) {
            v = "";
        }
        return v;
    }

    public void setPostalCode(String v) {
        String postal = StringTools.trim((String)v);
        if (PostalColumnLength > 0 && postal.length() >= PostalColumnLength) {
            int newLen = PostalColumnLength - 1;
            postal = postal.substring(0, newLen).trim();
        }
        this.setFieldValue(FLD_postalCode, postal);
    }

    public String getCountry() {
        String v = (String)this.getFieldValue(FLD_country);
        if (v == null || v.equals("")) {
            v = "";
        }
        return v;
    }

    public void setCountry(String v) {
        this.setFieldValue(FLD_country, StringTools.trim((String)v));
    }

    public String getSubdivision() {
        String v = (String)this.getFieldValue(FLD_subdivision);
        if (v == null || v.equals("")) {
            v = "";
        }
        return v;
    }

    public void setSubdivision(String v) {
        this.setFieldValue(FLD_subdivision, StringTools.trim((String)v));
    }

    public double getSpeedLimitKPH() {
        return this.getFieldValue(FLD_speedLimitKPH, 0.0);
    }

    public void setSpeedLimitKPH(double v) {
        this.setFieldValue(FLD_speedLimitKPH, v > 0.0 ? v : 0.0);
    }

    public boolean getIsTollRoad() {
        return this.getFieldValue(FLD_isTollRoad, false);
    }

    public void setIsTollRoad(boolean v) {
        this.setFieldValue(FLD_isTollRoad, v);
    }

    public boolean isTollRoad() {
        return this.getIsTollRoad();
    }

    public boolean isInputMaskExplicitlySet() {
        return this.inputMaskExplicitlySet;
    }

    @Override
    public long getInputMask() {
        Long v = (Long)this.getFieldValue(FLD_inputMask);
        return v != null ? (long)v.intValue() : 0L;
    }

    public boolean getInputMaskBitState(int bit) {
        long m = this.getInputMask();
        return (1L << bit & m) != 0L;
    }

    public void setInputMask(long v) {
        if (v < 0L) {
            this.setFieldValue(FLD_inputMask, 0L);
            this.inputMaskExplicitlySet = false;
        } else {
            this.setFieldValue(FLD_inputMask, v & 0xFFFFFFFFL);
            this.inputMaskExplicitlySet = true;
        }
    }

    public boolean isOutputMaskExplicitlySet() {
        return this.outputMaskExplicitlySet;
    }

    public long getOutputMask() {
        Long v = (Long)this.getFieldValue(FLD_outputMask);
        return v != null ? (long)v.intValue() : 0L;
    }

    public boolean getOutputMaskBitState(int bit) {
        long m = this.getOutputMask();
        return (1L << bit & m) != 0L;
    }

    public void setOutputMask(long v) {
        if (v < 0L) {
            this.setFieldValue(FLD_outputMask, 0L);
            this.outputMaskExplicitlySet = false;
        } else {
            this.setFieldValue(FLD_outputMask, v & 0xFFFFFFFFL);
            this.outputMaskExplicitlySet = true;
        }
    }

    public long getSeatbeltMask() {
        Long v = (Long)this.getFieldValue(FLD_seatbeltMask);
        return v != null ? (long)v.intValue() : 0L;
    }

    public boolean getSeatbeltMaskBitState(int bit) {
        long m = this.getSeatbeltMask();
        return (1L << bit & m) != 0L;
    }

    public void setSeatbeltMask(long v) {
        if (v < 0L) {
            this.setFieldValue(FLD_seatbeltMask, 0L);
        } else {
            this.setFieldValue(FLD_seatbeltMask, v & 0xFFFFFFFFL);
        }
    }

    public double getBarometer() {
        return this.getFieldValue(FLD_barometer, 0.0);
    }

    public void setBarometer(double v) {
        this.setFieldValue(FLD_barometer, v);
    }

    public double getAmbientTemp() {
        return this.getFieldValue(FLD_ambientTemp, -9999.0);
    }

    public void setAmbientTemp(double v) {
        this.setFieldValue(FLD_ambientTemp, v);
    }

    public double getCabinTemp() {
        return this.getFieldValue(FLD_cabinTemp, -9999.0);
    }

    public void setCabinTemp(double v) {
        this.setFieldValue(FLD_cabinTemp, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getThermoCount() {
        if (Thermo_COUNT < 0) {
            Object object = Thermo_COUNT_lock;
            synchronized (object) {
                if (Thermo_COUNT < 0) {
                    DBFactory<EventData> dbFact = EventData.getFactory();
                    Thermo_COUNT = 0;
                    for (int i = 0; i < ThermoFieldInfo.length && dbFact.hasField(ThermoFieldInfo[i]._getName()); ++i) {
                        ++Thermo_COUNT;
                    }
                }
            }
        }
        return Thermo_COUNT;
    }

    public static boolean isValidTemperature(double t) {
        return t >= -126.0 && t <= 126.0;
    }

    public double getThermoAverage(int ndx) {
        switch (ndx) {
            case 0: {
                return this.getThermoAverage0();
            }
            case 1: {
                return this.getThermoAverage1();
            }
            case 2: {
                return this.getThermoAverage2();
            }
            case 3: {
                return this.getThermoAverage3();
            }
            case 4: {
                return this.getThermoAverage4();
            }
            case 5: {
                return this.getThermoAverage5();
            }
            case 6: {
                return this.getThermoAverage6();
            }
            case 7: {
                return this.getThermoAverage7();
            }
        }
        return -9999.0;
    }

    public void setThermoAverage(int ndx, double v) {
        switch (ndx) {
            case 0: {
                this.setThermoAverage0(v);
                break;
            }
            case 1: {
                this.setThermoAverage1(v);
                break;
            }
            case 2: {
                this.setThermoAverage2(v);
                break;
            }
            case 3: {
                this.setThermoAverage3(v);
                break;
            }
            case 4: {
                this.setThermoAverage4(v);
                break;
            }
            case 5: {
                this.setThermoAverage5(v);
                break;
            }
            case 6: {
                this.setThermoAverage6(v);
                break;
            }
            case 7: {
                this.setThermoAverage7(v);
            }
        }
    }

    public void clearThermoAverage() {
        for (int n = 0; n <= 7; ++n) {
            this.setThermoAverage(n, -9999.0);
        }
    }

    public double getThermoAverage0() {
        return this.getFieldValue(FLD_thermoAverage0, -9999.0);
    }

    public void setThermoAverage0(double v) {
        this.setFieldValue(FLD_thermoAverage0, v);
    }

    public double getThermoAverage1() {
        return this.getFieldValue(FLD_thermoAverage1, -9999.0);
    }

    public void setThermoAverage1(double v) {
        this.setFieldValue(FLD_thermoAverage1, v);
    }

    public double getThermoAverage2() {
        return this.getFieldValue(FLD_thermoAverage2, -9999.0);
    }

    public void setThermoAverage2(double v) {
        this.setFieldValue(FLD_thermoAverage2, v);
    }

    public double getThermoAverage3() {
        return this.getFieldValue(FLD_thermoAverage3, -9999.0);
    }

    public void setThermoAverage3(double v) {
        this.setFieldValue(FLD_thermoAverage3, v);
    }

    public double getThermoAverage4() {
        return this.getFieldValue(FLD_thermoAverage4, -9999.0);
    }

    public void setThermoAverage4(double v) {
        this.setFieldValue(FLD_thermoAverage4, v);
    }

    public double getThermoAverage5() {
        return this.getFieldValue(FLD_thermoAverage5, -9999.0);
    }

    public void setThermoAverage5(double v) {
        this.setFieldValue(FLD_thermoAverage5, v);
    }

    public double getThermoAverage6() {
        return this.getFieldValue(FLD_thermoAverage6, -9999.0);
    }

    public void setThermoAverage6(double v) {
        this.setFieldValue(FLD_thermoAverage6, v);
    }

    public double getThermoAverage7() {
        return this.getFieldValue(FLD_thermoAverage7, -9999.0);
    }

    public void setThermoAverage7(double v) {
        this.setFieldValue(FLD_thermoAverage7, v);
    }

    public double getAnalog(int ndx) {
        switch (ndx) {
            case 0: {
                return this.getAnalog0();
            }
            case 1: {
                return this.getAnalog1();
            }
            case 2: {
                return this.getAnalog2();
            }
            case 3: {
                return this.getAnalog3();
            }
        }
        return 0.0;
    }

    public void setAnalog(int ndx, double v) {
        switch (ndx) {
            case 0: {
                this.setAnalog0(v);
                break;
            }
            case 1: {
                this.setAnalog1(v);
                break;
            }
            case 2: {
                this.setAnalog2(v);
                break;
            }
            case 3: {
                this.setAnalog3(v);
            }
        }
    }

    public double getAnalog0() {
        return this.getFieldValue(FLD_analog0, 0.0);
    }

    public void setAnalog0(double v) {
        this.setFieldValue(FLD_analog0, v);
    }

    public double getAnalog1() {
        return this.getFieldValue(FLD_analog1, 0.0);
    }

    public void setAnalog1(double v) {
        this.setFieldValue(FLD_analog1, v);
    }

    public double getAnalog2() {
        return this.getFieldValue(FLD_analog2, 0.0);
    }

    public void setAnalog2(double v) {
        this.setFieldValue(FLD_analog2, v);
    }

    public double getAnalog3() {
        return this.getFieldValue(FLD_analog3, 0.0);
    }

    public void setAnalog3(double v) {
        this.setFieldValue(FLD_analog3, v);
    }

    public double getPulseCount() {
        return this.getFieldValue(FLD_pulseCount, 0.0);
    }

    public void setPulseCount(double v) {
        this.setFieldValue(FLD_pulseCount, v);
    }

    public int getDayEngineStarts() {
        return this.getFieldValue(FLD_dayEngineStarts, 0);
    }

    public void setDayEngineStarts(int v) {
        this.setFieldValue(FLD_dayEngineStarts, v);
    }

    public double getDayIdleHours() {
        return this.getFieldValue(FLD_dayIdleHours, 0.0);
    }

    public void setDayIdleHours(double v) {
        this.setFieldValue(FLD_dayIdleHours, v);
    }

    public double getDayFuelIdle() {
        return this.getFieldValue(FLD_dayFuelIdle, 0.0);
    }

    public void setDayFuelIdle(double v) {
        this.setFieldValue(FLD_dayFuelIdle, v);
    }

    public double getDayWorkHours() {
        return this.getFieldValue(FLD_dayWorkHours, 0.0);
    }

    public void setDayWorkHours(double v) {
        this.setFieldValue(FLD_dayWorkHours, v);
    }

    public double getDayFuelWork() {
        return this.getFieldValue(FLD_dayFuelWork, 0.0);
    }

    public void setDayFuelWork(double v) {
        this.setFieldValue(FLD_dayFuelWork, v);
    }

    public double getDayFuelPTO() {
        return this.getFieldValue(FLD_dayFuelPTO, 0.0);
    }

    public void setDayFuelPTO(double v) {
        this.setFieldValue(FLD_dayFuelPTO, v);
    }

    public double getDayDistanceKM() {
        return this.getFieldValue(FLD_dayDistanceKM, 0.0);
    }

    public void setDayDistanceKM(double v) {
        this.setFieldValue(FLD_dayDistanceKM, v);
    }

    public double getDayFuelTotal() {
        return this.getFieldValue(FLD_dayFuelTotal, 0.0);
    }

    public void setDayFuelTotal(double v) {
        this.setFieldValue(FLD_dayFuelTotal, v);
    }

    public boolean canUpdateCellTowerLocation() {
        if (this.getCellTowerID() <= 0) {
            return false;
        }
        if (this.getMobileCountryCode() < 0) {
            return false;
        }
        if (this.getMobileNetworkCode() < 0) {
            return false;
        }
        Account acct = this.getAccount();
        if (acct == null) {
            return false;
        }
        MobileLocationProvider mlp = acct.getPrivateLabel().getMobileLocationProvider();
        return mlp != null && mlp.isEnabled();
    }

    public Set<String> updateCellTowerLocation() {
        Account acct = this.getAccount();
        if (acct == null) {
            return null;
        }
        String acctID = this.getAccountID();
        BasicPrivateLabel privLabel = acct.getPrivateLabel();
        MobileLocationProvider mlp = privLabel.getMobileLocationProvider();
        if (mlp == null) {
            if (acct.hasPrivateLabel()) {
                Print.logInfo((String)"[Account '%s'] PrivateLabel '%s' does not define a MobileLocationProvider", (Object[])new Object[]{acctID, privLabel});
            } else {
                Print.logInfo((String)"No PrivateLabel (thus no MobileLocationProvider) for Account '%s'", (Object[])new Object[]{acctID});
            }
            return null;
        }
        if (!mlp.isEnabled()) {
            Print.logInfo((String)("MobileLocationProvider disabled: " + mlp.getName()), (Object[])new Object[0]);
            return null;
        }
        HashSet<String> updFields = new HashSet<String>();
        CellTower servCT = this.getServingCellTower();
        CellTower[] nborCT = this.getNeighborCellTowers();
        Print.logInfo((String)("Getting CellTower location: " + mlp.getName()), (Object[])new Object[0]);
        MobileLocation ml = mlp.getMobileLocation(servCT, nborCT);
        if (ml != null && ml.hasGeoPoint()) {
            GeoPoint gp = ml.getGeoPoint();
            this.setCellLatitude(gp.getLatitude());
            updFields.add(FLD_cellLatitude);
            this.setCellLongitude(gp.getLongitude());
            updFields.add(FLD_cellLongitude);
            if (ml.hasAccuracy()) {
                double accuracyM = ml.getAccuracy();
                this.setCellAccuracy(accuracyM);
                updFields.add(FLD_cellAccuracy);
                Print.logInfo((String)("CellTower location [" + acctID + "]: " + gp + " [+/- " + accuracyM + " meters]"), (Object[])new Object[0]);
            } else {
                Print.logInfo((String)("CellTower location [" + acctID + "]: " + gp), (Object[])new Object[0]);
            }
        } else {
            Print.logInfo((String)("Unable to retrieve CellTower location [" + acctID + "]"), (Object[])new Object[0]);
        }
        return updFields;
    }

    public double getCellLatitude() {
        return this.getFieldValue(FLD_cellLatitude, 0.0);
    }

    public void setCellLatitude(double v) {
        this.setFieldValue(FLD_cellLatitude, v);
    }

    public double getCellLongitude() {
        return this.getFieldValue(FLD_cellLongitude, 0.0);
    }

    public void setCellLongitude(double v) {
        this.setFieldValue(FLD_cellLongitude, v);
    }

    public void setCellGeoPoint(GeoPoint gp) {
        if (GeoPoint.isValid((GeoPoint)gp)) {
            this.setCellLatitude(gp.getLatitude());
            this.setCellLongitude(gp.getLongitude());
        } else {
            this.setCellLatitude(0.0);
            this.setCellLongitude(0.0);
        }
    }

    public GeoPoint getCellGeoPoint() {
        double lon;
        double lat = this.getCellLatitude();
        if (GeoPoint.isValid((double)lat, (double)(lon = this.getCellLongitude()))) {
            return new GeoPoint(lat, lon);
        }
        return GeoPoint.INVALID_GEOPOINT;
    }

    public boolean hasCellLocation() {
        double lat = this.getCellLatitude();
        double lon = this.getCellLongitude();
        return GeoPoint.isValid((double)lat, (double)lon);
    }

    public double getCellAccuracy() {
        return this.getFieldValue(FLD_cellAccuracy, 0.0);
    }

    public void setCellAccuracy(double v) {
        this.setFieldValue(FLD_cellAccuracy, v >= 0.0 ? v : 0.0);
    }

    public int getMobileCountryCode() {
        return this.getFieldValue(FLD_mobileCountryCode, 0);
    }

    public void setMobileCountryCode(int v) {
        this.setFieldValue(FLD_mobileCountryCode, v);
    }

    public int getMobileNetworkCode() {
        return this.getFieldValue(FLD_mobileNetworkCode, 0);
    }

    public void setMobileNetworkCode(int v) {
        this.setFieldValue(FLD_mobileNetworkCode, v);
    }

    public int getCellTimingAdvance() {
        return this.getFieldValue(FLD_cellTimingAdvance, 0);
    }

    public void setCellTimingAdvance(int v) {
        this.setFieldValue(FLD_cellTimingAdvance, v);
    }

    public int getLocationAreaCode() {
        return this.getFieldValue(FLD_locationAreaCode, 0);
    }

    public void setLocationAreaCode(int v) {
        this.setFieldValue(FLD_locationAreaCode, v);
    }

    public int getCellTowerID() {
        return this.getFieldValue(FLD_cellTowerID, 0);
    }

    public void setCellTowerID(int v) {
        this.setFieldValue(FLD_cellTowerID, v);
    }

    public String getCellServingInfo() {
        return this.getFieldValue(FLD_cellServingInfo, "");
    }

    public void setCellServingInfo(String v) {
        this.setFieldValue(FLD_cellServingInfo, StringTools.trim((String)v));
    }

    public CellTower getServingCellTower() {
        RTProperties ctp = new RTProperties(this.getCellServingInfo());
        ctp.setInt("mcc", this.getMobileCountryCode());
        ctp.setInt("mnc", this.getMobileNetworkCode());
        ctp.setInt("tav", this.getCellTimingAdvance());
        ctp.setInt("lac", this.getLocationAreaCode());
        ctp.setInt("cid", this.getCellTowerID());
        if (ctp.getInt("cid") <= 0) {
            return null;
        }
        CellTower ct = new CellTower(ctp);
        if (this.hasCellLocation()) {
            ct.setMobileLocation(this.getCellGeoPoint(), this.getCellAccuracy());
        }
        return ct;
    }

    public void setServingCellTower(CellTower cti) {
        if (cti != null) {
            this.setMobileCountryCode(cti.getMobileCountryCode());
            this.setMobileNetworkCode(cti.getMobileNetworkCode());
            this.setCellTimingAdvance(cti.getTimingAdvance());
            this.setLocationAreaCode(cti.getLocationAreaCode());
            this.setCellTowerID(cti.getCellTowerID());
            this.setCellServingInfo(cti.toString());
        } else {
            this.setMobileCountryCode(0);
            this.setMobileNetworkCode(0);
            this.setCellTimingAdvance(0);
            this.setLocationAreaCode(0);
            this.setCellTowerID(0);
            this.setCellServingInfo(null);
        }
    }

    public String getCellNeighborInfo0() {
        return this.getFieldValue(FLD_cellNeighborInfo0, "");
    }

    public void setCellNeighborInfo0(String v) {
        this.setFieldValue(FLD_cellNeighborInfo0, StringTools.trim((String)v));
    }

    public String getCellNeighborInfo1() {
        return this.getFieldValue(FLD_cellNeighborInfo1, "");
    }

    public void setCellNeighborInfo1(String v) {
        this.setFieldValue(FLD_cellNeighborInfo1, StringTools.trim((String)v));
    }

    public String getCellNeighborInfo2() {
        return this.getFieldValue(FLD_cellNeighborInfo2, "");
    }

    public void setCellNeighborInfo2(String v) {
        this.setFieldValue(FLD_cellNeighborInfo2, StringTools.trim((String)v));
    }

    public String getCellNeighborInfo3() {
        return this.getFieldValue(FLD_cellNeighborInfo3, "");
    }

    public void setCellNeighborInfo3(String v) {
        this.setFieldValue(FLD_cellNeighborInfo3, StringTools.trim((String)v));
    }

    public String getCellNeighborInfo4() {
        return this.getFieldValue(FLD_cellNeighborInfo4, "");
    }

    public void setCellNeighborInfo4(String v) {
        this.setFieldValue(FLD_cellNeighborInfo4, StringTools.trim((String)v));
    }

    public String getCellNeighborInfo5() {
        return this.getFieldValue(FLD_cellNeighborInfo5, "");
    }

    public void setCellNeighborInfo5(String v) {
        this.setFieldValue(FLD_cellNeighborInfo5, StringTools.trim((String)v));
    }

    public CellTower getNeighborCellTower(int ndx) {
        String cts = null;
        switch (ndx) {
            case 0: {
                cts = this.getCellNeighborInfo0();
                break;
            }
            case 1: {
                cts = this.getCellNeighborInfo1();
                break;
            }
            case 2: {
                cts = this.getCellNeighborInfo2();
                break;
            }
            case 3: {
                cts = this.getCellNeighborInfo3();
                break;
            }
            case 4: {
                cts = this.getCellNeighborInfo4();
                break;
            }
            case 5: {
                cts = this.getCellNeighborInfo5();
            }
        }
        if (!StringTools.isBlank(cts)) {
            return new CellTower(new RTProperties(cts));
        }
        return null;
    }

    public void setNeighborCellTower(int ndx, CellTower cti) {
        String cts = cti != null ? cti.toString() : null;
        switch (ndx) {
            case 0: {
                this.setCellNeighborInfo0(cts);
                break;
            }
            case 1: {
                this.setCellNeighborInfo1(cts);
                break;
            }
            case 2: {
                this.setCellNeighborInfo2(cts);
                break;
            }
            case 3: {
                this.setCellNeighborInfo3(cts);
                break;
            }
            case 4: {
                this.setCellNeighborInfo4(cts);
                break;
            }
            case 5: {
                this.setCellNeighborInfo5(cts);
            }
        }
    }

    public CellTower[] getNeighborCellTowers() {
        Vector<CellTower> nctList = null;
        for (int n = 0; n < 6; ++n) {
            CellTower ct = this.getNeighborCellTower(n);
            if (ct == null) continue;
            if (nctList == null) {
                nctList = new Vector<CellTower>();
            }
            nctList.add(ct);
        }
        return nctList != null ? nctList.toArray(new CellTower[nctList.size()]) : null;
    }

    public void setNeighborCellTowers(CellTower[] nct) {
        int nctLen = ListTools.size((Object[])nct);
        for (int n = 0; n < 6; ++n) {
            CellTower ct = nctLen > n ? nct[n] : null;
            this.setNeighborCellTower(n, ct);
        }
    }

    public void setNeighborCellTowers(List<CellTower> nct) {
        int nctLen = ListTools.size(nct);
        for (int n = 0; n < 6; ++n) {
            CellTower ct = nctLen > n ? nct.get(n) : null;
            this.setNeighborCellTower(n, ct);
        }
    }

    public boolean hasDriverID() {
        return !StringTools.isBlank((String)this.getDriverID());
    }

    public String getDriverID() {
        return this.getFieldValue(FLD_driverID, "");
    }

    public void setDriverID(String v) {
        this.setFieldValue(FLD_driverID, StringTools.trim((String)v));
        this.driver = null;
    }

    public String getDriverID(boolean chkDevIfBlank) {
        Device dev;
        String drvID = this.getDriverID();
        if (!StringTools.isBlank((String)drvID)) {
            return drvID;
        }
        if (chkDevIfBlank && (dev = this.getDevice()) != null) {
            return dev.getDriverID();
        }
        return "";
    }

    public Driver getDriver(boolean chkDevIfBlank) {
        String driverID;
        if (this.driver == null && !StringTools.isBlank((String)(driverID = this.getDriverID(chkDevIfBlank)))) {
            try {
                this.driver = Driver.getDriver(this.getAccount(), driverID);
            }
            catch (DBException dbe) {
                this.driver = null;
            }
            if (this.driver != null) {
                // empty if block
            }
        }
        return this.driver;
    }

    public boolean hasDriverStatus() {
        return this.getDriverStatus() > 0L;
    }

    public long getDriverStatus() {
        return this.getFieldValue(FLD_driverStatus, 0L);
    }

    public void setDriverStatus(long v) {
        long ds = v >= 0L ? v : 0L;
        this.setFieldValue(FLD_driverStatus, ds);
    }

    public String getDriverMessage() {
        return this.getFieldValue(FLD_driverMessage, "");
    }

    public void setDriverMessage(String v) {
        this.setFieldValue(FLD_driverMessage, StringTools.trim((String)v));
    }

    public String getEmailRecipient() {
        String v = (String)this.getFieldValue(FLD_emailRecipient);
        return StringTools.trim((String)v);
    }

    public void setEmailRecipient(String v) {
        this.setFieldValue(FLD_emailRecipient, StringTools.trim((String)v));
    }

    public long getSensorLow() {
        return this.getFieldValue(FLD_sensorLow, 0L);
    }

    public void setSensorLow(long v) {
        this.setFieldValue(FLD_sensorLow, v);
    }

    public long getSensorHigh() {
        return this.getFieldValue(FLD_sensorHigh, 0L);
    }

    public void setSensorHigh(long v) {
        this.setFieldValue(FLD_sensorHigh, v);
    }

    public int getSampleIndex() {
        return this.getFieldValue(FLD_sampleIndex, 0);
    }

    public void setSampleIndex(int v) {
        this.setFieldValue(FLD_sampleIndex, v);
    }

    public String getSampleID() {
        String v = (String)this.getFieldValue(FLD_sampleID);
        return StringTools.trim((String)v);
    }

    public void setSampleID(String v) {
        this.setFieldValue(FLD_sampleID, StringTools.trim((String)v));
    }

    public long getLeaseStartDate() {
        return this.getFieldValue(FLD_leaseStartDate, 0L);
    }

    public void setLeaseStartDate(long v) {
        this.setFieldValue(FLD_leaseStartDate, v >= 0L ? v : 0L);
    }

    public void setLeaseStartDate(int year, int month, int day) {
        this.setLeaseStartDate(DateTime.getDayNumberFromDate((int)year, (int)month, (int)day));
    }

    public void setLeaseStartDate(DayNumber dn) {
        this.setLeaseStartDate(dn != null ? dn.getDayNumber() : 0L);
    }

    public long getLeaseEndDate() {
        return this.getFieldValue(FLD_leaseEndDate, 0L);
    }

    public void setLeaseEndDate(long v) {
        this.setFieldValue(FLD_leaseEndDate, v >= 0L ? v : 0L);
    }

    public void setLeaseEndDate(int year, int month, int day) {
        this.setLeaseEndDate(DateTime.getDayNumberFromDate((int)year, (int)month, (int)day));
    }

    public void setLeaseEndDate(DayNumber dn) {
        this.setLeaseEndDate(dn != null ? dn.getDayNumber() : 0L);
    }

    public double getLeaseStartOdomKM() {
        return this.getFieldValue(FLD_leaseStartOdomKM, 0.0);
    }

    public void setLeaseStartOdomKM(double v) {
        this.setFieldValue(FLD_leaseStartOdomKM, v);
    }

    public double getLeaseAllowedDistKM() {
        return this.getFieldValue(FLD_leaseAllowedDistKM, 0.0);
    }

    public void setLeaseAllowedDistKM(double v) {
        this.setFieldValue(FLD_leaseAllowedDistKM, v);
    }

    public String getLeaseContractID() {
        String v = (String)this.getFieldValue(FLD_leaseContractID);
        return StringTools.trim((String)v);
    }

    public void setLeaseContractID(String v) {
        this.setFieldValue(FLD_leaseContractID, StringTools.trim((String)v));
    }

    public double getBrakeGForce() {
        return this.getFieldValue(FLD_brakeGForce, 0.0);
    }

    public void setBrakeGForce(double v) {
        this.setFieldValue(FLD_brakeGForce, v);
    }

    public double getAcceleration() {
        return this.getFieldValue(FLD_acceleration, 0.0);
    }

    public void setAcceleration(double v) {
        this.setFieldValue(FLD_acceleration, v);
    }

    public String getAccelerometerXYZ() {
        String v = (String)this.getFieldValue(FLD_accelerometerXYZ);
        return StringTools.trim((String)v);
    }

    public void setAccelerometerXYZ(String v) {
        this.setFieldValue(FLD_accelerometerXYZ, StringTools.trim((String)v));
    }

    public Accelerometer getAccelerometer() {
        String xyz = this.getAccelerometerXYZ();
        return new Accelerometer(xyz);
    }

    public void setAccelerometer(Accelerometer xyz) {
        String v = xyz != null ? xyz.toString() : "";
        this.setAccelerometerXYZ(v);
    }

    public double getBrakePressure() {
        return this.getFieldValue(FLD_brakePressure, 0.0);
    }

    public void setBrakePressure(double v) {
        this.setFieldValue(FLD_brakePressure, v);
    }

    public double getMassAirFlowRate() {
        return this.getFieldValue(FLD_massAirFlowRate, 0.0);
    }

    public void setMassAirFlowRate(double v) {
        this.setFieldValue(FLD_massAirFlowRate, v);
    }

    public String getTirePressure() {
        return this.getFieldValue(FLD_tirePressure, "");
    }

    public double[] getTirePressure_kPa() {
        String kPaStrArr = this.getTirePressure();
        if (StringTools.isBlank((String)kPaStrArr)) {
            return new double[0];
        }
        String[] kPaStr = StringTools.split((String)kPaStrArr, (char)',');
        double[] kPaArr = new double[kPaStr.length];
        for (int i = 0; i < kPaStr.length; ++i) {
            kPaArr[i] = StringTools.parseDouble((String)kPaStr[i], (double)0.0);
        }
        return kPaArr;
    }

    public double[] getTirePressure_psi() {
        String kPaStrArr = this.getTirePressure();
        if (StringTools.isBlank((String)kPaStrArr)) {
            return new double[0];
        }
        String[] kPaStr = StringTools.split((String)kPaStrArr, (char)',');
        double[] psiArr = new double[kPaStr.length];
        for (int i = 0; i < kPaStr.length; ++i) {
            double kPa = StringTools.parseDouble((String)kPaStr[i], (double)0.0);
            psiArr[i] = kPa * 0.14503773773020923;
        }
        return psiArr;
    }

    public double[] getTirePressure_units(Account.PressureUnits pu) {
        String kPaStrArr = this.getTirePressure();
        if (StringTools.isBlank((String)kPaStrArr)) {
            return new double[0];
        }
        if (pu == null) {
            pu = (Account.PressureUnits)EnumTools.getDefault(Account.PressureUnits.class);
        }
        String[] kPaStr = StringTools.split((String)kPaStrArr, (char)',');
        double[] uniArr = new double[kPaStr.length];
        for (int i = 0; i < kPaStr.length; ++i) {
            double kPa = StringTools.parseDouble((String)kPaStr[i], (double)0.0);
            uniArr[i] = pu.convertFromKPa(kPa);
        }
        return uniArr;
    }

    public void setTirePressure(String v) {
        this.setFieldValue(FLD_tirePressure, v);
    }

    public void setTirePressure_kPa(double[] v) {
        StringBuffer sb = new StringBuffer();
        if (!ListTools.isEmpty((double[])v)) {
            for (int i = 0; i < v.length; ++i) {
                double kPa = v[i];
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(StringTools.format((double)kPa, (String)"0.0"));
            }
        }
        this.setTirePressure(sb.toString());
    }

    public void setTirePressure_psi(double[] v) {
        StringBuffer sb = new StringBuffer();
        if (!ListTools.isEmpty((double[])v)) {
            for (int i = 0; i < v.length; ++i) {
                double kPa = v[i] / 0.14503773773020923;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(StringTools.format((double)kPa, (String)"0.0"));
            }
        }
        this.setTirePressure(sb.toString());
    }

    public String getTireTemp() {
        return this.getFieldValue(FLD_tireTemp, "");
    }

    public double[] getTireTemp_C() {
        String cStrArr = this.getTireTemp();
        if (StringTools.isBlank((String)cStrArr)) {
            return new double[0];
        }
        String[] cStr = StringTools.split((String)cStrArr, (char)',');
        double[] cArr = new double[cStr.length];
        for (int i = 0; i < cStr.length; ++i) {
            double C;
            cArr[i] = C = StringTools.parseDouble((String)cStr[i], (double)0.0);
        }
        return cArr;
    }

    public double[] getTireTemp_units(Account.TemperatureUnits tu) {
        String cStrArr = this.getTireTemp();
        if (StringTools.isBlank((String)cStrArr)) {
            return new double[0];
        }
        if (tu == null) {
            tu = (Account.TemperatureUnits)EnumTools.getDefault(Account.TemperatureUnits.class);
        }
        String[] cStr = StringTools.split((String)cStrArr, (char)',');
        double[] uArr = new double[cStr.length];
        for (int i = 0; i < cStr.length; ++i) {
            double C = StringTools.parseDouble((String)cStr[i], (double)0.0);
            uArr[i] = tu.convertFromC(C);
        }
        return uArr;
    }

    public void setTireTemp(String v) {
        this.setFieldValue(FLD_tireTemp, v);
    }

    public void setTireTemp_C(double[] v) {
        StringBuffer sb = new StringBuffer();
        if (!ListTools.isEmpty((double[])v)) {
            for (int i = 0; i < v.length; ++i) {
                double C = v[i];
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(StringTools.format((double)C, (String)"0.0"));
            }
        }
        this.setTireTemp(sb.toString());
    }

    public double getTankLevel() {
        return this.getFieldValue(FLD_tankLevel, 0.0);
    }

    public void setTankLevel(double v) {
        this.setFieldValue(FLD_tankLevel, v);
    }

    public boolean getDataPush() {
        return this.getFieldValue(FLD_dataPush, true);
    }

    public void setDataPush(boolean v) {
        this.setFieldValue(FLD_dataPush, v);
    }

    public long getCostCenter() {
        return this.getFieldValue(FLD_costCenter, 0L);
    }

    public void setCostCenter(long v) {
        this.setFieldValue(FLD_costCenter, v);
    }

    public String getJobNumber() {
        return this.getFieldValue(FLD_jobNumber, "");
    }

    public void setJobNumber(String v) {
        this.setFieldValue(FLD_jobNumber, StringTools.trim((String)v));
    }

    public boolean hasJobNumber() {
        return !StringTools.isBlank((String)this.getJobNumber());
    }

    public String getRfidTag() {
        return this.getFieldValue(FLD_rfidTag, "");
    }

    public void setRfidTag(String v) {
        this.setFieldValue(FLD_rfidTag, StringTools.trim((String)v));
    }

    public String getAttachType() {
        return this.getFieldValue(FLD_attachType, "");
    }

    public void setAttachType(String v) {
        this.setFieldValue(FLD_attachType, StringTools.trim((String)v));
    }

    public boolean hasAttachData() {
        byte[] v = (byte[])this.getFieldValue(FLD_attachData);
        return !ListTools.isEmpty((byte[])v);
    }

    public byte[] getAttachData() {
        byte[] v = (byte[])this.getFieldValue(FLD_attachData);
        return v != null ? v : new byte[]{};
    }

    public void setAttachData(byte[] v) {
        this.setFieldValue(FLD_attachData, v != null ? v : new byte[]{});
    }

    public void setAttachment(String mimeType, byte[] data) {
        if (ListTools.isEmpty((byte[])data)) {
            this.setAttachType(null);
            this.setAttachData(null);
        } else {
            this.setAttachType(StringTools.isBlank((String)mimeType) ? mimeType : HTMLTools.getMimeTypeFromData((byte[])data, null));
            this.setAttachData(data);
        }
    }

    public long getEtaTimestamp() {
        return this.getFieldValue(FLD_etaTimestamp, 0L);
    }

    public void setEtaTimestamp(long v) {
        this.setFieldValue(FLD_etaTimestamp, v);
    }

    public long getEtaUniqueID() {
        return this.getFieldValue(FLD_etaUniqueID, 0L);
    }

    public void setEtaUniqueID(long v) {
        this.setFieldValue(FLD_etaUniqueID, v);
    }

    public double getEtaDistanceKM() {
        return this.getFieldValue(FLD_etaDistanceKM, 0.0);
    }

    public void setEtaDistanceKM(double v) {
        this.setFieldValue(FLD_etaDistanceKM, v);
    }

    public double getEtaLatitude() {
        return this.getFieldValue(FLD_etaLatitude, 0.0);
    }

    public void setEtaLatitude(double v) {
        this.setFieldValue(FLD_etaLatitude, v);
    }

    public void setEtaGeoPoint(GeoPoint gp) {
        if (gp != null && gp.isValid()) {
            this.setEtaLatitude(gp.getLatitude());
            this.setEtaLongitude(gp.getLongitude());
        } else {
            this.setEtaLatitude(0.0);
            this.setEtaLongitude(0.0);
        }
    }

    public GeoPoint getEtaGeoPoint() {
        return new GeoPoint(this.getEtaLatitude(), this.getEtaLongitude());
    }

    public double getEtaLongitude() {
        return this.getFieldValue(FLD_etaLongitude, 0.0);
    }

    public void setEtaLongitude(double v) {
        this.setFieldValue(FLD_etaLongitude, v);
    }

    public long getStopID() {
        return this.getFieldValue(FLD_stopID, 0L);
    }

    public void setStopID(long v) {
        this.setFieldValue(FLD_stopID, v);
    }

    public int getStopStatus() {
        return this.getFieldValue(FLD_stopStatus, 0);
    }

    public void setStopStatus(int v) {
        this.setFieldValue(FLD_stopStatus, v);
    }

    public int getStopIndex() {
        return this.getFieldValue(FLD_stopIndex, 0);
    }

    public void setStopIndex(int v) {
        if (v < 0 && this.isFieldUnsigned(FLD_stopIndex)) {
            v = 0;
        }
        this.setFieldValue(FLD_stopIndex, v);
    }

    public double getFuelPressure() {
        return this.getFieldValue(FLD_fuelPressure, 0.0);
    }

    public void setFuelPressure(double v) {
        this.setFieldValue(FLD_fuelPressure, v);
    }

    public double getFuelUsage() {
        return this.getFieldValue(FLD_fuelUsage, 0.0);
    }

    public void setFuelUsage(double v) {
        this.setFieldValue(FLD_fuelUsage, v);
    }

    public double getFuelTemp() {
        return this.getFieldValue(FLD_fuelTemp, 0.0);
    }

    public void setFuelTemp(double v) {
        this.setFieldValue(FLD_fuelTemp, v);
    }

    public double getFuelLevel() {
        return this.getFieldValue(FLD_fuelLevel, 0.0);
    }

    public void setFuelLevel(double v) {
        this.setFieldValue(FLD_fuelLevel, v);
    }

    public double getFuelLevel(boolean estimate) {
        double fuelCapL;
        double fuelLevel = this.getFuelLevel();
        if (!estimate || fuelLevel > 0.0) {
            return fuelLevel;
        }
        Device device = this.getDevice();
        double fuelRemain = this.getFuelRemain(false);
        double d = fuelCapL = device != null ? device.getFuelCapacity() : 0.0;
        if (fuelRemain > 0.0 && fuelCapL > 0.0) {
            fuelLevel = fuelRemain / fuelCapL;
            if (fuelLevel > 1.0) {
                fuelLevel = 1.0;
            }
            return fuelLevel;
        }
        return 0.0;
    }

    public double getFuelLevelVolume_Liters() {
        Device device = this.getDevice();
        if (device != null) {
            return this.getFuelLevel(true) * device.getFuelCapacity();
        }
        return 0.0;
    }

    public double getFuelLevelVolume_Units() {
        Account.VolumeUnits vu = Account.getVolumeUnits(this.getAccount());
        return vu.convertFromLiters(this.getFuelLevelVolume_Liters());
    }

    public double getFuelLevel2() {
        return this.getFieldValue(FLD_fuelLevel2, 0.0);
    }

    public void setFuelLevel2(double v) {
        this.setFieldValue(FLD_fuelLevel2, v);
    }

    public double getFuelEconomy() {
        return this.getFieldValue(FLD_fuelEconomy, 0.0);
    }

    public void setFuelEconomy(double v) {
        this.setFieldValue(FLD_fuelEconomy, v);
    }

    public double getFuelTotal() {
        return this.getFieldValue(FLD_fuelTotal, 0.0);
    }

    public void setFuelTotal(double v) {
        this.setFieldValue(FLD_fuelTotal, v);
    }

    public double getFuelRemain() {
        return this.getFieldValue(FLD_fuelRemain, 0.0);
    }

    public void setFuelRemain(double v) {
        this.setFieldValue(FLD_fuelRemain, v);
    }

    public double getFuelRemain(boolean estimate) {
        double fuelCapL;
        double fuelRemain = this.getFuelRemain();
        if (!estimate || fuelRemain > 0.0) {
            return fuelRemain;
        }
        Device device = this.getDevice();
        double fuelLevel = this.getFuelLevel(false);
        double d = fuelCapL = device != null ? device.getFuelCapacity() : 0.0;
        if (fuelLevel > 0.0 && fuelCapL > 0.0) {
            fuelRemain = fuelCapL * fuelLevel;
            return fuelRemain;
        }
        return 0.0;
    }

    public double getFuelTrip() {
        return this.getFieldValue(FLD_fuelTrip, 0.0);
    }

    public void setFuelTrip(double v) {
        this.setFieldValue(FLD_fuelTrip, v);
    }

    public double getFuelIdle() {
        return this.getFieldValue(FLD_fuelIdle, 0.0);
    }

    public void setFuelIdle(double v) {
        this.setFieldValue(FLD_fuelIdle, v);
    }

    public double getFuelPTO() {
        return this.getFieldValue(FLD_fuelPTO, 0.0);
    }

    public void setFuelPTO(double v) {
        this.setFieldValue(FLD_fuelPTO, v);
    }

    public double getFuelEngineOn() {
        return this.getFieldValue(FLD_fuelEngineOn, 0.0);
    }

    public void setFuelEngineOn(double v) {
        this.setFieldValue(FLD_fuelEngineOn, v);
    }

    public long getEngineRpm() {
        return this.getFieldValue(FLD_engineRpm, 0L);
    }

    public void setEngineRpm(long v) {
        this.setFieldValue(FLD_engineRpm, v);
    }

    public double getEngineHours() {
        return this.getFieldValue(FLD_engineHours, 0.0);
    }

    public void setEngineHours(double v) {
        this.setFieldValue(FLD_engineHours, v);
    }

    public double getEngineOnHours() {
        return this.getFieldValue(FLD_engineOnHours, 0.0);
    }

    public void setEngineOnHours(double v) {
        this.setFieldValue(FLD_engineOnHours, v);
    }

    public double getEngineLoad() {
        return this.getFieldValue(FLD_engineLoad, 0.0);
    }

    public void setEngineLoad(double v) {
        this.setFieldValue(FLD_engineLoad, v);
    }

    public double getEngineTorque() {
        return this.getFieldValue(FLD_engineTorque, 0.0);
    }

    public void setEngineTorque(double v) {
        this.setFieldValue(FLD_engineTorque, v);
    }

    public double getIdleHours() {
        return this.getFieldValue(FLD_idleHours, 0.0);
    }

    public void setIdleHours(double v) {
        this.setFieldValue(FLD_idleHours, v);
    }

    public double getWorkHours() {
        return this.getFieldValue(FLD_workHours, 0.0);
    }

    public void setWorkHours(double v) {
        this.setFieldValue(FLD_workHours, v);
    }

    public double getTransOilTemp() {
        return this.getFieldValue(FLD_transOilTemp, 0.0);
    }

    public void setTransOilTemp(double v) {
        this.setFieldValue(FLD_transOilTemp, v);
    }

    public double getCoolantLevel() {
        return this.getFieldValue(FLD_coolantLevel, 0.0);
    }

    public void setCoolantLevel(double v) {
        this.setFieldValue(FLD_coolantLevel, v);
    }

    public double getCoolantTemp() {
        return this.getFieldValue(FLD_coolantTemp, 0.0);
    }

    public void setCoolantTemp(double v) {
        this.setFieldValue(FLD_coolantTemp, v);
    }

    public double getIntakeTemp() {
        return this.getFieldValue(FLD_intakeTemp, 0.0);
    }

    public void setIntakeTemp(double v) {
        this.setFieldValue(FLD_intakeTemp, v);
    }

    public double getOilPressure() {
        return this.getFieldValue(FLD_oilPressure, 0.0);
    }

    public void setOilPressure(double v) {
        this.setFieldValue(FLD_oilPressure, v);
    }

    public double getOilLevel() {
        return this.getFieldValue(FLD_oilLevel, 0.0);
    }

    public void setOilLevel(double v) {
        this.setFieldValue(FLD_oilLevel, v);
    }

    public double getOilTemp() {
        return this.getFieldValue(FLD_oilTemp, 0.0);
    }

    public void setOilTemp(double v) {
        this.setFieldValue(FLD_oilTemp, v);
    }

    public double getAirPressure() {
        return this.getFieldValue(FLD_airPressure, 0.0);
    }

    public void setAirPressure(double v) {
        this.setFieldValue(FLD_airPressure, v);
    }

    public double getAirFilterPressure() {
        return this.getFieldValue(FLD_airFilterPressure, 0.0);
    }

    public void setAirFilterPressure(double v) {
        this.setFieldValue(FLD_airFilterPressure, v);
    }

    public double getTurboPressure() {
        return this.getFieldValue(FLD_turboPressure, 0.0);
    }

    public void setTurboPressure(double v) {
        this.setFieldValue(FLD_turboPressure, v);
    }

    public boolean getPtoEngaged() {
        return this.getFieldValue(FLD_ptoEngaged, true);
    }

    public void setPtoEngaged(boolean v) {
        this.setFieldValue(FLD_ptoEngaged, v);
    }

    public double getPtoHours() {
        return this.getFieldValue(FLD_ptoHours, 0.0);
    }

    public void setPtoHours(double v) {
        this.setFieldValue(FLD_ptoHours, v);
    }

    public double getThrottlePos() {
        return this.getFieldValue(FLD_throttlePos, 0.0);
    }

    public void setThrottlePos(double v) {
        this.setFieldValue(FLD_throttlePos, v);
    }

    public double getBrakePos() {
        return this.getFieldValue(FLD_brakePos, 0.0);
    }

    public void setBrakePos(double v) {
        this.setFieldValue(FLD_brakePos, v);
    }

    public double getVBatteryVolts() {
        return this.getFieldValue(FLD_vBatteryVolts, 0.0);
    }

    public void setVBatteryVolts(double v) {
        this.setFieldValue(FLD_vBatteryVolts, v);
    }

    public long getJ1708Fault() {
        return this.getFieldValue(FLD_j1708Fault, 0L);
    }

    public void setJ1708Fault(long v) {
        this.setFieldValue(FLD_j1708Fault, v);
    }

    public long getOBDFault() {
        return this.getJ1708Fault();
    }

    public void setOBDFault(long v) {
        this.setJ1708Fault(v);
    }

    public static boolean supportsFaultCode() {
        return EventData.getFactory().hasField(FLD_faultCode);
    }

    public String getFaultCode() {
        return this.getFieldValue(FLD_faultCode, "");
    }

    public void setFaultCode(String v) {
        this.setFieldValue(FLD_faultCode, StringTools.trim((String)v));
    }

    public boolean hasFaultCode() {
        return !StringTools.isBlank((String)this.getFaultCode());
    }

    public RTProperties getFaultCodeRTProperties() {
        String fc = this.getFaultCode();
        return new RTProperties(fc);
    }

    public void setFaultCode_OBDII(String[] dtc) {
        if (!ListTools.isEmpty((Object[])dtc)) {
            this.setFaultCode(DTOBDFault.GetPropertyString_OBDII(dtc));
        } else {
            this.setFaultCode(null);
        }
    }

    public boolean getMalfunctionLamp() {
        Boolean v = (Boolean)this.getFieldValue(FLD_malfunctionLamp);
        return v != null ? v : false;
    }

    public void setMalfunctionLamp(boolean v) {
        this.setFieldValue(FLD_malfunctionLamp, v);
        explicitSetMIL = true;
    }

    public boolean hasMalfunctionLamp() {
        return explicitSetMIL;
    }

    public void setCreationDefaultValues() {
    }

    @Override
    public void setEventIndex(int ndx) {
        this.eventIndex = ndx;
    }

    @Override
    public int getEventIndex() {
        return this.eventIndex;
    }

    @Override
    public boolean getIsFirstEvent() {
        return this.getEventIndex() == 0;
    }

    @Override
    public void setIsLastEvent(boolean isLast) {
        this.isLastEventInList = isLast;
    }

    @Override
    public boolean getIsLastEvent() {
        return this.isLastEventInList;
    }

    public boolean showLastEventDevicePushpin(boolean isFleet, BasicPrivateLabel bpl) {
        if (isFleet) {
            boolean dft = false;
            if (bpl != null) {
                return bpl.getRTProperties().getBoolean("trackMap.lastDevicePushpin.fleet", dft);
            }
            return dft;
        }
        boolean dft = false;
        if (bpl != null) {
            return bpl.getRTProperties().getBoolean("trackMap.lastDevicePushpin.device", dft);
        }
        return dft;
    }

    public double getReportDistanceKM() {
        return this.rptDistKM;
    }

    public GeoPoint getReportDistanceGP() {
        return this.rptDistGP != null ? this.rptDistGP : this.getGeoPoint();
    }

    public void setReportDistanceKM(double km, GeoPoint gp) {
        this.rptDistKM = km;
        this.rptDistGP = GeoPoint.isValid((GeoPoint)gp) ? gp : this.getGeoPoint();
    }

    public boolean calculateReportDistance(EventData lastEV) {
        if (lastEV == null) {
            Print.logWarn((String)"Last EventData is null!!", (Object[])new Object[0]);
            this.setReportDistanceKM(0.0, null);
            return false;
        }
        GeoPoint lastGP = lastEV.getReportDistanceGP();
        double distKM = lastEV.getReportDistanceKM();
        if (!GeoPoint.isValid((GeoPoint)lastGP)) {
            Print.logWarn((String)"Last EventData report GeoPoint is invalid!", (Object[])new Object[0]);
            this.setReportDistanceKM(distKM, null);
            return false;
        }
        GeoPoint thisGP = this.getGeoPoint();
        if (!GeoPoint.isValid((GeoPoint)thisGP)) {
            this.setReportDistanceKM(distKM, lastGP);
            return false;
        }
        double deltaKM = lastGP.kilometersToPoint(thisGP);
        this.setReportDistanceKM(distKM + deltaKM, thisGP);
        return true;
    }

    public static void calculateReportDistance(EventData[] evList) {
        if (!ListTools.isEmpty((Object[])evList)) {
            EventData lastEV = null;
            for (EventData ev : evList) {
                if (ev == null) continue;
                ev.calculateReportDistance(lastEV);
                lastEV = ev;
            }
        }
    }

    public static void calculateReportDistance(Collection<EventData> evList) {
        if (!ListTools.isEmpty(evList)) {
            EventData lastEV = null;
            for (EventData ev : evList) {
                if (ev == null) continue;
                ev.calculateReportDistance(lastEV);
                lastEV = ev;
            }
        }
    }

    public boolean getStartStopSupported(boolean dft) {
        Device dev = this.getDevice();
        return dev != null ? dev.getStartStopSupported() : dft;
    }

    public int[] getStartStopStatusCodes() {
        Device dev = this.getDevice();
        int[] ssc = dev != null ? dev.getStartStopStatusCodes() : null;
        return ssc;
    }

    public boolean isStartEvent(boolean checkSpeed) {
        return this.isStartEvent(this.getStartStopStatusCodes(), checkSpeed);
    }

    public boolean isStartEvent(int[] ssc, boolean checkSpeed) {
        if (ssc != null) {
            int sc = this.getStatusCode();
            return sc == ssc[0];
        }
        if (checkSpeed) {
            return this.getSpeedKPH() > 0.0;
        }
        return false;
    }

    public boolean isStopEvent(boolean checkSpeed) {
        return this.isStopEvent(this.getStartStopStatusCodes(), checkSpeed);
    }

    public boolean isStopEvent(int[] ssc, boolean checkSpeed) {
        if (ssc != null) {
            int sc = this.getStatusCode();
            return sc == ssc[1];
        }
        if (checkSpeed) {
            return this.getSpeedKPH() <= 0.0;
        }
        return false;
    }

    public void setStopped(boolean stopped) {
        this.isStopped = stopped;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setSynthesizedEvent(boolean isSynthesized) {
        this.isSynthesizedEvent = isSynthesized;
    }

    public boolean getIsSynthesizedEvent() {
        return this.isSynthesizedEvent;
    }

    public void setPushpinIconIndexProvider(PushpinIconIndexProvider piip) {
        this.iconIndexProvider = piip;
    }

    public void setPushpinIconIndex(int epii) {
        this.explicitPushpinIconIndex = epii;
    }

    public void setPushpinIconIndex(String iconName, OrderedSet<String> iconKeys) {
        this.setPushpinIconIndex(EventData._getPushpinIconIndex(iconName, iconKeys, 5));
    }

    private static void PushpinDebug(String msg, OrderedSet<String> iconKeys, int ndx) {
        String iconName = ndx >= 0 && ndx < ListTools.size(iconKeys) ? (String)iconKeys.get(ndx) : "?";
        Print.logInfo((String)("Pushpin Selection - " + msg + ": #" + ndx + " \"" + iconName + "\""), (Object[])new Object[0]);
    }

    @Override
    public int getPushpinIconIndex(String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, BasicPrivateLabel bpl) {
        int movingIconNdx;
        int stopIconNdx;
        int allIconNdx;
        int iconNdx;
        RuleFactory rf;
        int iconNdx2;
        boolean debugPP = RTConfig.getBoolean((String[])DEBUG_PUSHPINS, (boolean)false);
        if (this.explicitPushpinIconIndex >= 0) {
            if (debugPP) {
                EventData.PushpinDebug("Explicit index", iconKeys, this.explicitPushpinIconIndex);
            }
            return this.explicitPushpinIconIndex;
        }
        if (this.iconIndexProvider != null && (iconNdx2 = this.iconIndexProvider.getPushpinIconIndex(this, iconSelector, iconKeys, isFleet, bpl)) >= 0) {
            if (debugPP) {
                EventData.PushpinDebug("IconIndexProvider", iconKeys, iconNdx2);
            }
            return iconNdx2;
        }
        if (!StringTools.isBlank((String)iconSelector) && (rf = Device.getRuleFactory(true)) != null && (iconNdx = this._getPushpinIndexFromRuleSelector(rf, "IconSelector", iconSelector, iconKeys, debugPP)) >= 0) {
            return iconNdx;
        }
        if (isFleet) {
            String devIcon;
            int iconNdx3;
            Device dev;
            if (this.showLastEventDevicePushpin(isFleet, bpl) && (dev = this.getDevice()) != null && dev.hasPushpinID() && (iconNdx3 = EventData._getPushpinIconIndex(devIcon = dev.getPushpinID(), iconKeys, -1)) >= 0) {
                if (debugPP) {
                    EventData.PushpinDebug("Device (" + dev.getDeviceID() + ") fleet", iconKeys, iconNdx3);
                }
                return iconNdx3;
            }
            int fleetIconNdx = EventData._getPushpinIconIndex(PPNAME_fleet, iconKeys, -1);
            if (fleetIconNdx >= 0) {
                if (debugPP) {
                    EventData.PushpinDebug("\"fleet\" name", iconKeys, fleetIconNdx);
                }
                return fleetIconNdx;
            }
        }
        if ((allIconNdx = EventData._getPushpinIconIndex(PPNAME_all, iconKeys, -1)) >= 0) {
            if (debugPP) {
                EventData.PushpinDebug("\"all\" name", iconKeys, allIconNdx);
            }
            return allIconNdx;
        }
        int scIconNdx = this._getStatusCodePushpinIndex(iconKeys, bpl, debugPP);
        if (scIconNdx >= 0) {
            return scIconNdx;
        }
        if (!isFleet && this.getIsLastEvent()) {
            String devIcon;
            int devIconNdx;
            Device dev;
            if (this.showLastEventDevicePushpin(!isFleet, bpl) && (dev = this.getDevice()) != null && dev.hasPushpinID() && (devIconNdx = EventData._getPushpinIconIndex(devIcon = dev.getPushpinID(), iconKeys, -1)) >= 0) {
                if (debugPP) {
                    EventData.PushpinDebug("Device [" + dev.getDeviceID() + "] last", iconKeys, devIconNdx);
                }
                return devIconNdx;
            }
            int lastIconNdx = EventData._getPushpinIconIndex(PPNAME_last, iconKeys, -1);
            if (lastIconNdx >= 0) {
                if (debugPP) {
                    EventData.PushpinDebug("\"last\" name", iconKeys, lastIconNdx);
                }
                return lastIconNdx;
            }
        }
        if (this.isStopEvent(false) && (stopIconNdx = EventData._getPushpinIconIndex(PPNAME_stop, iconKeys, -1)) >= 0) {
            if (debugPP) {
                EventData.PushpinDebug("\"stop\" name", iconKeys, stopIconNdx);
            }
            return stopIconNdx;
        }
        if (this.getSpeedKPH() > 0.0 && (movingIconNdx = EventData._getPushpinIconIndex(PPNAME_moving, iconKeys, -1)) >= 0) {
            if (debugPP) {
                EventData.PushpinDebug("\"moving\" name", iconKeys, movingIconNdx);
            }
            return movingIconNdx;
        }
        String dftIconName = RTConfig.getString((String)"EventData.defaultPushpinName", (String)"heading");
        int dftIconNdx = EventData._getPushpinIconIndex(dftIconName, iconKeys, 5);
        if (dftIconNdx >= 0) {
            if (debugPP) {
                EventData.PushpinDebug("default(\"" + dftIconName + "\") name", iconKeys, dftIconNdx);
            }
            return dftIconNdx;
        }
        if (debugPP) {
            EventData.PushpinDebug("Not Found", iconKeys, 0);
        }
        return 0;
    }

    private int _getPushpinIndexFromRuleSelector(RuleFactory ruleFact, String type, String iconSel, OrderedSet<String> iconKeys, boolean debugPP) {
        if (ruleFact != null && !StringTools.isBlank((String)iconSel)) {
            try {
                Object result = ruleFact.evaluateSelector(iconSel, this);
                if (result instanceof Number) {
                    int iconNdx = ((Number)result).intValue();
                    if (iconNdx >= iconKeys.size()) {
                        Print.logWarn((String)("Pushpin index invalid: " + iconNdx), (Object[])new Object[0]);
                        if (debugPP) {
                            EventData.PushpinDebug(type + " Rule [" + iconSel + "] (INVALID)", iconKeys, iconNdx);
                        }
                        return iconNdx;
                    }
                    if (iconNdx >= 0) {
                        if (debugPP) {
                            EventData.PushpinDebug(type + " Rule [" + iconSel + "]", iconKeys, iconNdx);
                        }
                        return iconNdx;
                    }
                    return -1;
                }
                if (result instanceof String) {
                    String iconName = (String)result;
                    if (!StringTools.isBlank((String)iconName)) {
                        int iconNdx = EventData._getPushpinIconIndex(iconName, iconKeys, -1);
                        if (iconNdx >= 0) {
                            if (debugPP) {
                                EventData.PushpinDebug(type + " Rule [" + iconSel + "]", iconKeys, iconNdx);
                            }
                            return iconNdx;
                        }
                        Print.logWarn((String)("Pushpin not found: " + iconName), (Object[])new Object[0]);
                        iconNdx = 0;
                        if (debugPP) {
                            EventData.PushpinDebug(type + " Rule [" + iconSel + "] (INVALID)", iconKeys, iconNdx);
                        }
                        return iconNdx;
                    }
                    return -1;
                }
                Print.logError((String)("Pushpin selector invalid result type: " + StringTools.className((Object)result)), (Object[])new Object[0]);
                int iconNdx = 0;
                if (debugPP) {
                    EventData.PushpinDebug(type + " Rule [" + iconSel + "] (INVALID)", iconKeys, iconNdx);
                }
                return iconNdx;
            }
            catch (RuleParseException rpe) {
                Print.logError((String)("Pushpin selector parse error: " + rpe.getMessage()), (Object[])new Object[0]);
                int iconNdx = 0;
                if (debugPP) {
                    EventData.PushpinDebug(type + " Rule [" + iconSel + "] (ERROR)", iconKeys, iconNdx);
                }
                return iconNdx;
            }
        }
        return -1;
    }

    private int _getStatusCodePushpinIndex(OrderedSet<String> iconKeys, BasicPrivateLabel bpl, boolean debugPP) {
        int iconNdx;
        String scIconSel;
        int iconNdx2;
        String scIconName = this.getStatusCodeIconName(bpl);
        if (!StringTools.isBlank((String)scIconName) && (iconNdx2 = EventData._getPushpinIconIndex(scIconName, iconKeys, -1)) >= 0) {
            if (debugPP) {
                EventData.PushpinDebug("StatusCode name", iconKeys, iconNdx2);
            }
            return iconNdx2;
        }
        RuleFactory rf = Device.getRuleFactory(true);
        if (rf != null && !StringTools.isBlank((String)(scIconSel = this.getStatusCodeIconSelector(bpl))) && (iconNdx = this._getPushpinIndexFromRuleSelector(rf, "StatusCode", scIconSel, iconKeys, debugPP)) >= 0) {
            return iconNdx;
        }
        return -1;
    }

    public String formatAsCSVRecord(String[] fields) {
        String csvSep = ",";
        StringBuffer sb = new StringBuffer();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                DBField dbFld;
                Object val;
                if (i > 0) {
                    sb.append(csvSep);
                }
                Object object = val = (dbFld = this.getRecordKey().getField(fields[i])) != null ? this.getFieldValue(fields[i]) : null;
                if (val == null) continue;
                Class typeClass = dbFld.getTypeClass();
                if (fields[i].equals(FLD_statusCode)) {
                    int code = (Integer)val;
                    StatusCodes.Code c = StatusCodes.GetCode(code, Account.getPrivateLabel(this.getAccount()));
                    if (c != null) {
                        sb.append("\"" + c.getDescription(null) + "\"");
                        continue;
                    }
                    sb.append("\"0x" + StringTools.toHexString((long)code, (int)16) + "\"");
                    continue;
                }
                if (typeClass == Double.class || typeClass == Double.TYPE) {
                    double d = (Double)val;
                    String fmt = dbFld.getFormat();
                    if (fmt != null && !fmt.equals("")) {
                        sb.append("\"" + StringTools.format((double)d, (String)fmt) + "\"");
                        continue;
                    }
                    sb.append("\"" + String.valueOf(d) + "\"");
                    continue;
                }
                if (typeClass == Float.class || typeClass == Float.TYPE) {
                    float d = ((Float)val).floatValue();
                    String fmt = dbFld.getFormat();
                    if (fmt != null && !fmt.equals("")) {
                        sb.append("\"" + StringTools.format((double)d, (String)fmt) + "\"");
                        continue;
                    }
                    sb.append("\"" + String.valueOf(d) + "\"");
                    continue;
                }
                sb.append(StringTools.quoteCSVString((String)val.toString()));
            }
        }
        return sb.toString();
    }

    public void setPreviousEventData(EventData ev) {
        if (ev != null) {
            this.previousEventData = ev;
            if (this.previousEventData.isValidGeoPoint()) {
                this.previousEventData_validGPS = this.previousEventData;
            }
        }
    }

    public EventData getPreviousEventData(boolean validGPS) throws DBException {
        return this.getPreviousEventData(null, validGPS);
    }

    public EventData getPreviousEventData(int[] statusCodes, boolean validGPS) throws DBException {
        if (statusCodes == null) {
            if (!validGPS && this.previousEventData != null) {
                return this.previousEventData;
            }
            if (validGPS && this.previousEventData_validGPS != null) {
                return this.previousEventData_validGPS;
            }
        }
        long startTime = -1L;
        long endTime = this.getTimestamp() - 1L;
        Object[] ed = EventData.getRangeEvents(this.getAccountID(), this.getDeviceID(), startTime, endTime, statusCodes, validGPS, LimitType.LAST, 1L, true, null);
        if (!ListTools.isEmpty((Object[])ed)) {
            Object ev = ed[0];
            if (statusCodes == null) {
                if (validGPS) {
                    this.previousEventData_validGPS = ev;
                } else {
                    this.previousEventData = ev;
                    if (this.previousEventData.isValidGeoPoint()) {
                        this.previousEventData_validGPS = this.previousEventData;
                    }
                }
            }
            return ev;
        }
        return null;
    }

    public static EventData getPreviousEventData(String accountID, String deviceID, long timestamp, int[] statusCodes, boolean validGPS) throws DBException {
        long startTime = -1L;
        long endTime = timestamp - 1L;
        Object[] ed = EventData.getRangeEvents(accountID, deviceID, startTime, endTime, statusCodes, validGPS, LimitType.LAST, 1L, true, null);
        return !ListTools.isEmpty((Object[])ed) ? ed[0] : null;
    }

    public EventData getNextEventData(boolean validGPS) throws DBException {
        if (!validGPS && this.nextEventData == null || validGPS && this.nextEventData_validGPS == null) {
            long startTime = this.getTimestamp() + 1L;
            long endTime = -1L;
            EventData[] ed = EventData.getRangeEvents(this.getAccountID(), this.getDeviceID(), startTime, endTime, null, validGPS, LimitType.FIRST, 1L, true, null);
            if (ed != null && ed.length > 0) {
                if (validGPS) {
                    this.nextEventData_validGPS = ed[0];
                } else {
                    this.nextEventData = ed[0];
                    if (this.nextEventData.isValidGeoPoint()) {
                        this.nextEventData_validGPS = this.nextEventData;
                    }
                }
            }
        }
        return validGPS ? this.nextEventData_validGPS : this.nextEventData;
    }

    public static EventData getNextEventData(String accountID, String deviceID, long timestamp, int[] statusCodes, boolean validGPS) throws DBException {
        long startTime = timestamp + 1L;
        long endTime = -1L;
        Object[] ed = EventData.getRangeEvents(accountID, deviceID, startTime, endTime, statusCodes, validGPS, LimitType.FIRST, 1L, true, null);
        return !ListTools.isEmpty((Object[])ed) ? ed[0] : null;
    }

    public Object getFieldValue(String fldName) {
        return super.getFieldValue(fldName);
    }

    protected void recordWillInsert() {
    }

    protected void recordDidInsert() {
    }

    protected void recordWillUpdate() {
    }

    protected void recordDidUpdate() {
    }

    public static boolean exists(String acctID, String devID, long time, int stCode) throws DBException {
        if (StringTools.isBlank((String)acctID)) {
            return false;
        }
        if (StringTools.isBlank((String)devID)) {
            return false;
        }
        if (time < 0L) {
            return false;
        }
        if (stCode < 0) {
            return false;
        }
        Key evKey = new Key(acctID, devID, time, stCode);
        return evKey.exists();
    }

    public static EventData createEventDataRecord(GeoEvent gev) {
        if (gev == null) {
            Print.logError((String)"GeoEvent is null", (Object[])new Object[0]);
            return null;
        }
        String acctID = gev.getAccountID();
        String devID = gev.getDeviceID();
        long time = gev.getTimestamp();
        int stCode = gev.getStatusCode();
        if (StringTools.isBlank((String)acctID) || StringTools.isBlank((String)devID) || time <= 0L || stCode <= 0) {
            Print.logError((String)"Invalid key specification", (Object[])new Object[0]);
            return null;
        }
        Key evKey = new Key(acctID, devID, time, stCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        for (String fldn : gev.getFieldKeys()) {
            Object val = gev.getFieldValue(fldn, null);
            evdb.setFieldValue(fldn, val);
        }
        return evdb;
    }

    public static String getWhereClause(long autoIndex) {
        DBWhere dwh = new DBWhere(EventData.getFactory());
        dwh.append(dwh.EQ(FLD_autoIndex, autoIndex));
        return dwh.WHERE(dwh.toString());
    }

    public static String getWhereClause(String acctId, String devId, long timeStart, long timeEnd, int[] statCode, boolean gpsRequired, String andSelect) {
        DBFactory<EventData> dbFact = EventData.getFactory();
        DBWhere dwh = new DBWhere(EventData.getFactory());
        if (!StringTools.isBlank((String)acctId)) {
            dwh.append(dwh.EQ("accountID", (Object)acctId));
            if (!StringTools.isBlank((String)devId) && !devId.equals("*")) {
                dwh.append(dwh.AND_(dwh.EQ("deviceID", (Object)devId)));
            }
        }
        if (statCode != null && statCode.length > 0) {
            dwh.append(dwh.AND_(dwh.INLIST(FLD_statusCode, statCode)));
        }
        if (gpsRequired) {
            if (!dbFact.hasField(FLD_cellLatitude)) {
                dwh.append(dwh.AND_(dwh.OR(dwh.NE(FLD_latitude, 0L), dwh.NE(FLD_longitude, 0L))));
            } else {
                dwh.append(dwh.AND_(dwh.OR(dwh.NE(FLD_latitude, 0L), dwh.NE(FLD_longitude, 0L), dwh.NE(FLD_cellLatitude, 0L), dwh.NE(FLD_cellLongitude, 0L))));
            }
        }
        if (timeStart >= 0L) {
            dwh.append(dwh.AND_(dwh.GE(FLD_timestamp, timeStart)));
        }
        if (timeEnd >= 0L && timeEnd >= timeStart) {
            dwh.append(dwh.AND_(dwh.LE(FLD_timestamp, timeEnd)));
        }
        if (!StringTools.isBlank((String)andSelect)) {
            dwh.append(dwh.AND_(andSelect));
        }
        return dwh.WHERE(dwh.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventData getAutoIndexEvent(long autoIndex) throws DBException {
        DBFactory<EventData> dbFact = EventData.getFactory();
        if (!dbFact.hasField(FLD_autoIndex)) {
            return null;
        }
        DBSelect dsel = new DBSelect(dbFact);
        dsel.setWhere(EventData.getWhereClause(autoIndex));
        Object[] ed = null;
        try {
            DBProvider.lockTables((String[])new String[]{EventData.TABLE_NAME()}, null);
            ed = (EventData[])DBRecord.select((DBSelect)dsel, null);
        }
        finally {
            DBProvider.unlockTables();
        }
        return !ListTools.isEmpty((Object[])ed) ? ed[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventData[] getSelectedEvents(DBSelect<EventData> dsel, DBRecordHandler<EventData> rcdHandler) throws DBException {
        Object[] ed = null;
        try {
            DBProvider.lockTables((String[])new String[]{EventData.TABLE_NAME()}, null);
            ed = (EventData[])DBRecord.select(dsel, rcdHandler);
        }
        finally {
            DBProvider.unlockTables();
        }
        return !ListTools.isEmpty((Object[])ed) ? ed : null;
    }

    private static DBSelect<EventData> _createRangeEventSelector(String acctId, String devId, long timeStart, long timeEnd, int[] statCode, boolean validGPS, LimitType limitType, long limit, boolean ascending, String addtnlSelect) {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)devId)) {
            return null;
        }
        if (timeStart > 0L && timeEnd > 0L && timeStart > timeEnd) {
            return null;
        }
        boolean isAscending = ascending;
        if (limit > 0L && (limitType == null || LimitType.LAST.equals((Object)limitType))) {
            isAscending = false;
        }
        DBSelect dsel = new DBSelect(EventData.getFactory());
        dsel.setWhere(EventData.getWhereClause(acctId, devId, timeStart, timeEnd, statCode, validGPS, addtnlSelect));
        dsel.setOrderByFields(new String[]{FLD_timestamp});
        dsel.setOrderAscending(isAscending);
        dsel.setLimit(limit);
        return dsel;
    }

    public static EventData getEventData(String acctId, String devId, long timestamp, int statusCode) throws DBException {
        EventData[] ed = EventData.getRangeEvents(acctId, devId, timestamp, timestamp, new int[]{statusCode}, false, LimitType.LAST, 1L, true, null, null);
        return ed.length > 0 ? ed[0] : null;
    }

    public static EventData[] getRangeEvents(String acctId, String devId, long timeStart, long timeEnd, int[] statCode, boolean validGPS, LimitType limitType, long limit, boolean ascending, String addtnlSelect) throws DBException {
        return EventData.getRangeEvents(acctId, devId, timeStart, timeEnd, statCode, validGPS, limitType, limit, ascending, addtnlSelect, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventData[] getRangeEvents(String acctId, String devId, long timeStart, long timeEnd, int[] statCode, boolean validGPS, LimitType limitType, long limit, boolean ascending, String addtnlSelect, DBRecordHandler<EventData> rcdHandler) throws DBException {
        DBSelect<EventData> dsel = EventData._createRangeEventSelector(acctId, devId, timeStart, timeEnd, statCode, validGPS, limitType, limit, ascending, addtnlSelect);
        if (dsel == null) {
            return EMPTY_ARRAY;
        }
        if (DBConnection.getShowExecutedSQL()) {
            Print.logInfo((String)"SQL Select comparison:", (Object[])new Object[0]);
            Print.logInfo((String)(" DBSelect[MySQL/MyISAM]: " + dsel.toString("mysql_myisam")), (Object[])new Object[0]);
            Print.logInfo((String)(" DBSelect[MySQL/InnoDB]: " + dsel.toString("mysql_innodb")), (Object[])new Object[0]);
            Print.logInfo((String)(" DBSelect[PostgreSQL  ]: " + dsel.toString("postgresql")), (Object[])new Object[0]);
            Print.logInfo((String)(" DBSelect[MS/SQLServer]: " + dsel.toString("sqlserver")), (Object[])new Object[0]);
        }
        EventData[] ed = null;
        try {
            DBProvider.lockTables((String[])new String[]{EventData.TABLE_NAME()}, null);
            ed = (EventData[])DBRecord.select(dsel, rcdHandler);
        }
        finally {
            DBProvider.unlockTables();
        }
        if (ed == null) {
            return EMPTY_ARRAY;
        }
        if (dsel.isOrderAscending() == ascending) {
            return ed;
        }
        int lastNdx = ed.length - 1;
        for (int i = 0; i < ed.length / 2; ++i) {
            EventData edrcd = ed[i];
            ed[i] = ed[lastNdx - i];
            ed[lastNdx - i] = edrcd;
        }
        return ed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countRangeEvents(String acctId, String devId, long timeStart, long timeEnd, int[] statCode, boolean validGPS, LimitType limitType, long limit, String addtnlSelect) throws DBException {
        DBSelect<EventData> dsel = EventData._createRangeEventSelector(acctId, devId, timeStart, timeEnd, statCode, validGPS, limitType, limit, true, addtnlSelect);
        if (dsel == null) {
            return 0L;
        }
        long recordCount = 0L;
        try {
            DBProvider.lockTables((String[])new String[]{EventData.TABLE_NAME()}, null);
            recordCount = DBRecord.getRecordCount(dsel);
        }
        finally {
            DBProvider.unlockTables();
        }
        return recordCount;
    }

    public static long getRecordCount(String acctId, String devId, long timeStart, long timeEnd) throws DBException {
        StringBuffer wh = new StringBuffer();
        wh.append(EventData.getWhereClause(acctId, devId, timeStart, timeEnd, null, false, null));
        return DBRecord.getRecordCount(EventData.getFactory(), (StringBuffer)wh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventData[] getEventsByCreationMillis(String acctId, String devId, long createStartMS, long createEndMS, long limit) throws DBException {
        DBFactory<EventData> dbFact = EventData.getFactory();
        if (StringTools.isBlank((String)acctId)) {
            return EMPTY_ARRAY;
        }
        if (StringTools.isBlank((String)devId)) {
            return EMPTY_ARRAY;
        }
        if (createStartMS > 0L && createEndMS > 0L && createStartMS > createEndMS) {
            return EMPTY_ARRAY;
        }
        if (!dbFact.hasField("creationMillis")) {
            Print.logError((String)"EventData table does not contain field 'creationMillis'", (Object[])new Object[0]);
            return EMPTY_ARRAY;
        }
        DBSelect dsel = new DBSelect(dbFact);
        DBWhere dwh = new DBWhere(dbFact);
        dwh.append(dwh.EQ("accountID", (Object)acctId));
        if (!StringTools.isBlank((String)devId) && !devId.equals("*")) {
            dwh.append(dwh.AND_(dwh.EQ("deviceID", (Object)devId)));
        }
        if (createStartMS >= 0L) {
            dwh.append(dwh.AND_(dwh.GE("creationMillis", createStartMS)));
        }
        if (createEndMS >= 0L && createEndMS >= createStartMS) {
            dwh.append(dwh.AND_(dwh.LE("creationMillis", createEndMS)));
        }
        dsel.setWhere(dwh.WHERE(dwh.toString()));
        dsel.setOrderByFields(new String[]{"creationMillis", FLD_timestamp});
        dsel.setOrderAscending(true);
        dsel.setLimit(limit);
        EventData[] ed = null;
        try {
            DBProvider.lockTables((String[])new String[]{EventData.TABLE_NAME()}, null);
            ed = (EventData[])DBRecord.select((DBSelect)dsel, null);
        }
        finally {
            DBProvider.unlockTables();
        }
        if (ed == null) {
            return EMPTY_ARRAY;
        }
        return ed;
    }

    public static long deleteFutureEvents(Device device, long futureTime) throws DBException {
        if (device == null) {
            throw new DBException("Device not specified");
        }
        String acctID = device.getAccountID();
        String devID = device.getDeviceID();
        return EventData.deleteFutureEvents(acctID, devID, futureTime);
    }

    public static long deleteFutureEvents(String acctID, String devID, long futureTime) throws DBException {
        if (StringTools.isBlank((String)acctID) || StringTools.isBlank((String)devID)) {
            throw new DBException("AccountID/DeviceID not specified");
        }
        long minTime = DateTime.getCurrentTimeSec() + 60L;
        if (futureTime <= minTime) {
            throw new DBException("Invalid future time specified");
        }
        return EventData.deleteEventsAfterTimestamp(acctID, devID, futureTime, true);
    }

    public static long deleteEventsAfterTimestamp(String acctID, String devID, long timestamp, boolean inclusive) throws DBException {
        long delFromTime;
        long l = delFromTime = inclusive ? timestamp : timestamp + 1L;
        if (StringTools.isBlank((String)acctID) || StringTools.isBlank((String)devID)) {
            throw new DBException("AccountID/DeviceID not specified");
        }
        long count = EventData.getRecordCount(acctID, devID, delFromTime, -1L);
        if (count <= 0L) {
            return 0L;
        }
        DBDelete ddel = new DBDelete(EventData.getFactory());
        DBWhere dwh = ddel.createDBWhere();
        ddel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctID), dwh.EQ("deviceID", (Object)devID), dwh.GE(FLD_timestamp, delFromTime))));
        DBConnection dbc = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(ddel.toString());
        }
        catch (SQLException sqe) {
            throw new DBException("Deleting future EventData records", (Throwable)sqe);
        }
        finally {
            DBConnection.release((DBConnection)dbc);
        }
        return count;
    }

    public static long deleteOldEvents(Device device, long oldTimeSec, StringBuffer msg) throws DBException {
        long count;
        long lastTimestamp;
        if (device == null) {
            throw new DBException("Device not specified");
        }
        Account account = device.getAccount();
        if (account == null) {
            throw new DBException("Account is null");
        }
        long delOldTimeSec = account.adjustRetainedEventTime(oldTimeSec);
        if (delOldTimeSec != oldTimeSec) {
            oldTimeSec = delOldTimeSec;
            if (msg != null) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append("Using retained-date");
            }
        }
        if (oldTimeSec < 1L) {
            oldTimeSec = 1L;
        }
        String acctID = device.getAccountID();
        String devID = device.getDeviceID();
        Object[] ev = EventData.getRangeEvents(acctID, devID, -1L, -1L, null, false, LimitType.LAST, 1L, true, null);
        boolean savingLastEvent = false;
        long l = lastTimestamp = !ListTools.isEmpty((Object[])ev) ? ((EventData)ev[0]).getTimestamp() : 0L;
        if (lastTimestamp <= 0L) {
            if (msg != null) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append("No events");
            }
        } else if (lastTimestamp <= oldTimeSec) {
            oldTimeSec = lastTimestamp;
            savingLastEvent = true;
            if (msg != null) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append("Saved last event");
            }
        }
        if ((count = EventData.getRecordCount(acctID, devID, -1L, oldTimeSec - 1L)) <= 0L) {
            if (msg != null) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                if (savingLastEvent) {
                    msg.append("Nothing to delete");
                } else {
                    msg.append("Empty range");
                }
            }
            return 0L;
        }
        DBDelete ddel = new DBDelete(EventData.getFactory());
        DBWhere dwh = ddel.createDBWhere();
        ddel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctID), dwh.EQ("deviceID", (Object)devID), dwh.LT(FLD_timestamp, oldTimeSec))));
        DBConnection dbc = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(ddel.toString());
        }
        catch (SQLException sqe) {
            throw new DBException("Deleting old EventData records", (Throwable)sqe);
        }
        finally {
            DBConnection.release((DBConnection)dbc);
        }
        return count;
    }

    public static double getGPSDistanceTraveledKM(String acctId, String devId, long timeStart, long timeEnd, GeoPoint startingGP, double startingOdomKM) {
        GPSDistanceAccumulator rcdHandler = new GPSDistanceAccumulator(startingGP, startingOdomKM);
        try {
            EventData.getRangeEvents(acctId, devId, timeStart, timeEnd, null, true, LimitType.LAST, -1L, true, null, rcdHandler);
        }
        catch (DBException dbe) {
            Print.logException((String)"Calculating GPS distance traveled", (Throwable)dbe);
        }
        return rcdHandler.getGPSDistanceTraveledKM();
    }

    public static DateTime parseDate(String dateStr, TimeZone tz) {
        String[] dateFld = StringTools.parseStringArray((String)dateStr, (String)"/:");
        if (dateFld == null || dateFld.length == 0) {
            return null;
        }
        if (dateFld.length == 1) {
            long epoch = StringTools.parseLong((String)dateFld[0], (long)-1L);
            return epoch > 0L ? new DateTime(epoch, tz) : null;
        }
        int YY = StringTools.parseInt((String)dateFld[0], (int)-1);
        int MM = StringTools.parseInt((String)dateFld[1], (int)-1);
        if (YY < 1900 || MM < 1 || MM > 12) {
            return null;
        }
        int DD = 1;
        int hh = 0;
        int mm = 0;
        int ss = 0;
        if (dateFld.length >= 3) {
            DD = StringTools.parseInt((String)dateFld[2], (int)-1);
            if (DD < 1) {
                DD = 1;
            } else if (DD > DateTime.getDaysInMonth((TimeZone)tz, (int)MM, (int)YY)) {
                DD = DateTime.getDaysInMonth((TimeZone)tz, (int)MM, (int)YY);
            } else {
                if (dateFld.length >= 4) {
                    hh = StringTools.parseInt((String)dateFld[3], (int)0);
                }
                if (dateFld.length >= 5) {
                    mm = StringTools.parseInt((String)dateFld[4], (int)0);
                }
                if (dateFld.length >= 6) {
                    ss = StringTools.parseInt((String)dateFld[5], (int)0);
                }
            }
        } else {
            DD = 1;
        }
        return new DateTime(tz, YY, MM, DD, hh, mm, ss);
    }

    public static boolean _keyMatch(String key, String keyMatch) {
        return key.equalsIgnoreCase(keyMatch);
    }

    public static boolean _keyMatch(String key, String[] keyList) {
        for (int i = 0; i < keyList.length; ++i) {
            if (!key.equalsIgnoreCase(keyList[i])) continue;
            return true;
        }
        return false;
    }

    public static String getKeyFieldTitle(String key, String arg, Locale locale) {
        return EventData._getKeyFieldString(true, key, arg, locale, null, null);
    }

    public String getKeyFieldValue(String key, String arg, BasicPrivateLabel bpl) {
        Locale locale = bpl != null ? bpl.getLocale() : null;
        return EventData._getKeyFieldString(false, key, arg, locale, bpl, this);
    }

    public static String _getKeyFieldString(boolean getTitle, String key, String arg, Locale locale, BasicPrivateLabel bpl, EventData ed) {
        if (key == null) {
            return null;
        }
        if (ed == null && !getTitle) {
            return null;
        }
        if (locale == null && bpl != null) {
            locale = bpl.getLocale();
        }
        I18N i18n = I18N.getI18N(EventData.class, (Locale)locale);
        long now = DateTime.getCurrentTimeSec();
        if (arg == null) {
            arg = "";
        }
        if (EventData._keyMatch(key, KEY_ACCOUNT)) {
            if (getTitle) {
                return i18n.getString("EventData.key.accountDescription", "Account");
            }
            Account account = ed.getAccount();
            if (arg.equalsIgnoreCase("id") || account == null) {
                return ed.getAccountID();
            }
            return account.getDescription();
        }
        if (EventData._keyMatch(key, KEY_DEVICE_COUNT)) {
            if (getTitle) {
                return i18n.getString("EventData.key.deviceCount", "Device Count");
            }
            Account account = ed.getAccount();
            return account != null ? String.valueOf(account.getDeviceCount()) : "?";
        }
        if (EventData._keyMatch(key, KEY_DEVICE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.deviceDescription", "Device");
            }
            Device device = ed.getDevice();
            if (arg.equalsIgnoreCase("id") || device == null) {
                return ed.getDeviceID();
            }
            return device.getDescription();
        }
        if (EventData._keyMatch(key, KEY_EVENT_COUNT24)) {
            int[] nArray;
            int sinceHH;
            if (getTitle) {
                return i18n.getString("EventData.key.24HourEventCount", "24Hr Event Count");
            }
            String[] a = StringTools.split((String)arg, (char)',');
            int n = sinceHH = a.length > 1 ? StringTools.parseInt((String)a[0], (int)24) : 24;
            if (a.length > 2 && !StringTools.isBlank((String)a[1])) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = StringTools.parseInt((String)a[1], (int)0);
            } else {
                nArray = null;
            }
            int[] statCodes = nArray;
            long timeStart = now - DateTime.HourSeconds((long)(sinceHH > 0 ? (long)sinceHH : 24L));
            long timeEnd = -1L;
            long recordCount = -1L;
            try {
                recordCount = EventData.countRangeEvents(ed.getAccountID(), ed.getDeviceID(), timeStart, timeEnd, statCodes, false, LimitType.LAST, -1L, null);
            }
            catch (DBException dbe) {
                Print.logError((String)("Unable to obtain EventData record count [" + (Object)((Object)dbe)), (Object[])new Object[0]);
            }
            return String.valueOf(recordCount);
        }
        if (EventData._keyMatch(key, KEY_DEVICE_LINK)) {
            if (getTitle) {
                return i18n.getString("EventData.key.deviceLink", "Device Link");
            }
            Device device = ed.getDevice();
            if (device != null) {
                String url = device.getLinkURL();
                String dsc = StringTools.blankDefault((String)device.getLinkDescription(), (String)i18n.getString("EventData.key.link", "Link"));
                if (StringTools.isBlank((String)url)) {
                    return "";
                }
                if (StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("a") || arg.equalsIgnoreCase("html")) {
                    if (!StringTools.isBlank((String)url)) {
                        return "$HTML:<a href='" + url + "' target='_blank'>" + dsc + "</a>";
                    }
                    return "$HTML:<a>" + dsc + "</a>";
                }
                if (arg.equalsIgnoreCase("plain") || arg.equalsIgnoreCase("desc")) {
                    return dsc + ": " + url;
                }
                return url;
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_DEV_CONN_AGE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.sinceLastConnect", "Since Connection");
            }
            Device device = ed.getDevice();
            if (device != null) {
                long lastConnectTime = device.getLastTotalConnectTime();
                if (lastConnectTime <= 0L) {
                    return "--:--:--";
                }
                long ageSec = DateTime.getCurrentTimeSec() - lastConnectTime;
                if (ageSec < 0L) {
                    ageSec = 0L;
                }
                long hours = ageSec / 3600L;
                long min = ageSec % 3600L / 60L;
                long sec = ageSec % 60L;
                StringBuffer sb = new StringBuffer();
                sb.append(hours).append(":");
                if (min < 10L) {
                    sb.append("0");
                }
                sb.append(min).append(":");
                if (sec < 10L) {
                    sb.append("0");
                }
                sb.append(sec);
                return sb.toString();
            }
            return "--:--:--";
        }
        if (EventData._keyMatch(key, KEY_DEV_TRAILERS)) {
            if (getTitle) {
                return i18n.getString("EventData.key.attachedTrailers", "Attached Trailers");
            }
            Device device = ed.getDevice();
            if (device != null) {
                String[] e = device.getAttachedEntityDescriptions(EntityManager.EntityType.TRAILER);
                if (e != null && e.length > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < e.length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(e[i]);
                    }
                    return sb.toString();
                }
                return "";
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_DATETIME)) {
            if (getTitle) {
                return i18n.getString("EventData.key.dateTime", "Date/Time");
            }
            return ed.getTimestampString();
        }
        if (EventData._keyMatch(key, KEY_DATE_YEAR)) {
            if (getTitle) {
                return i18n.getString("EventData.key.dateYear", "Year");
            }
            return ed.getTimestampYear();
        }
        if (EventData._keyMatch(key, KEY_DATE_MONTH)) {
            if (getTitle) {
                return i18n.getString("EventData.key.dateMonth", "Month");
            }
            if (StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("name") || arg.equalsIgnoreCase("text")) {
                return ed.getTimestampMonth(false, locale);
            }
            if (arg.equalsIgnoreCase("abbr") || arg.equalsIgnoreCase("abbrev")) {
                return ed.getTimestampMonth(true, locale);
            }
            return ed.getTimestampMonthNumber();
        }
        if (EventData._keyMatch(key, KEY_DATE_DAY)) {
            if (getTitle) {
                return i18n.getString("EventData.key.dateDay", "Day");
            }
            return ed.getTimestampDayOfMonth();
        }
        if (EventData._keyMatch(key, KEY_DATE_DOW)) {
            if (getTitle) {
                return i18n.getString("EventData.key.dayOfWeek", "Day Of Week");
            }
            return ed.getTimestampDayOfWeek(false, locale);
        }
        if (EventData._keyMatch(key, KEY_TIMEZONE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.timeZone", "TimeZone");
            }
            TimeZone tmz = ed.getTimeZone();
            return tmz.getDisplayName(locale);
        }
        if (EventData._keyMatch(key, KEY_TIME)) {
            if (getTitle) {
                return i18n.getString("EventData.key.time", "Time");
            }
            return ed.getTimestampTime();
        }
        if (EventData._keyMatch(key, KEY_STATUSDESC)) {
            if (getTitle) {
                return i18n.getString("EventData.key.statusCode", "Status Code");
            }
            return ed.getStatusCodeDescription(bpl);
        }
        if (EventData._keyMatch(key, KEY_GEOPOINT)) {
            if (getTitle) {
                return i18n.getString("EventData.key.latitudeLongitude", "Latitude/Longitude");
            }
            Account.LatLonFormat latlonFmt = Account.getLatLonFormat(ed.getAccount());
            double lat = ed.getLatitude();
            double lon = ed.getLongitude();
            String fmt = latlonFmt.isDegMinSec() ? "DMS" : (latlonFmt.isDegMin() ? "DM" : "5");
            String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
            String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
            return latStr + "/" + lonStr;
        }
        if (EventData._keyMatch(key, KEY_LATITUDE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.latitude", "Latitude");
            }
            Account.LatLonFormat latlonFmt = Account.getLatLonFormat(ed.getAccount());
            double lat = ed.getLatitude();
            String fmt = latlonFmt.isDegMinSec() ? "DMS" : (latlonFmt.isDegMin() ? "DM" : "5");
            return GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
        }
        if (EventData._keyMatch(key, KEY_LONGITUDE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.longitude", "Longitude");
            }
            Account.LatLonFormat latlonFmt = Account.getLatLonFormat(ed.getAccount());
            double lon = ed.getLongitude();
            String fmt = latlonFmt.isDegMinSec() ? "DMS" : (latlonFmt.isDegMin() ? "DM" : "5");
            return GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
        }
        if (EventData._keyMatch(key, KEY_GPS_AGE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.gpsAge", "GPS Age");
            }
            long ageSec = ed.getGpsAge();
            if (ageSec < 0L) {
                ageSec = 0L;
            }
            long hours = ageSec / 3600L;
            long min = ageSec % 3600L / 60L;
            long sec = ageSec % 60L;
            StringBuffer sb = new StringBuffer();
            sb.append(hours).append(":");
            if (min < 10L) {
                sb.append("0");
            }
            sb.append(min).append(":");
            if (sec < 10L) {
                sb.append("0");
            }
            sb.append(sec);
            return sb.toString();
        }
        if (EventData._keyMatch(key, KEY_SPEED)) {
            if (getTitle) {
                return i18n.getString("EventData.key.speed", "Speed");
            }
            double kph = ed.getSpeedKPH();
            Account account = ed.getAccount();
            if (account != null) {
                return account.getSpeedString(kph, true, locale);
            }
            return StringTools.format((double)kph, (String)"0") + " " + Account.SpeedUnits.KPH.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_SPEED_LIMIT)) {
            Device device;
            if (getTitle) {
                return i18n.getString("EventData.key.speedLimit", "Speed Limit");
            }
            double kph = ed.getSpeedLimitKPH();
            if (kph <= 0.0 && (device = ed.getDevice()) != null && (kph = device.getSpeedLimitKPH()) <= 0.0) {
                return i18n.getString("EventData.notAvailable", "n/a");
            }
            Account account = ed.getAccount();
            if (account != null) {
                return account.getSpeedString(kph, true, locale);
            }
            return StringTools.format((double)kph, (String)"0") + " " + Account.SpeedUnits.KPH.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_DIRECTION)) {
            if (getTitle) {
                return i18n.getString("EventData.key.direction", "Heading");
            }
            double deg = ed.getHeading();
            if (arg.equalsIgnoreCase("deg") || arg.equalsIgnoreCase("degrees")) {
                return StringTools.format((double)deg, (String)"0.0");
            }
            return GeoPoint.GetHeadingString((double)deg, (Locale)locale);
        }
        if (EventData._keyMatch(key, KEY_HEADING)) {
            if (getTitle) {
                return i18n.getString("EventData.key.heading", "Heading");
            }
            double deg = ed.getHeading();
            if (arg.equalsIgnoreCase("desc")) {
                return GeoPoint.GetHeadingString((double)deg, (Locale)locale);
            }
            return StringTools.format((double)deg, (String)"0.0");
        }
        if (EventData._keyMatch(key, KEY_ODOMETER)) {
            if (getTitle) {
                return i18n.getString("EventData.key.odometer", "Odometer");
            }
            double odomKM = ed.getOdometerWithOffsetKM();
            Account account = ed.getAccount();
            if (account != null) {
                return account.getDistanceString(odomKM, true, locale);
            }
            return StringTools.format((double)odomKM, (String)"0") + " " + Account.DistanceUnits.KM.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_DISTANCE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.distance", "Distance");
            }
            double distKM = ed.getDistanceKM();
            Account account = ed.getAccount();
            if (account != null) {
                return account.getDistanceString(distKM, true, locale);
            }
            return StringTools.format((double)distKM, (String)"0") + " " + Account.DistanceUnits.KM.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_ALTITUDE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.altitude", "Altitude");
            }
            return ed.getAltitudeString(true, locale);
        }
        if (EventData._keyMatch(key, KEY_RPT_DISTANCE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.reportDistance", "Report\nDistance");
            }
            double distKM = ed.getReportDistanceKM();
            Account account = ed.getAccount();
            if (account != null) {
                return account.getDistanceString(distKM, true, locale);
            }
            return StringTools.format((double)distKM, (String)"0") + " " + Account.DistanceUnits.KM.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_BATTERY_LEVEL)) {
            if (getTitle) {
                return i18n.getString("EventData.key.batteryLevel", "Battery Level");
            }
            long pct = Math.round(ed.getBatteryLevel() * 100.0);
            return pct + "%";
        }
        if (EventData._keyMatch(key, KEY_BATTERY_VOLTS)) {
            if (getTitle) {
                return i18n.getString("EventData.key.batteryVolts", "Battery Volts");
            }
            return StringTools.format((double)ed.getBatteryVolts(), (String)"0.0");
        }
        if (EventData._keyMatch(key, KEY_VEH_BATTERY_V)) {
            if (getTitle) {
                return i18n.getString("EventData.key.vehBatteryVolts", "Veh. Batt Volts");
            }
            return StringTools.format((double)ed.getVBatteryVolts(), (String)"0.0");
        }
        if (EventData._keyMatch(key, KEY_FUEL_LEVEL)) {
            if (getTitle) {
                return i18n.getString("EventData.key.fuelLevel", "Fuel Level");
            }
            double level = ed.getFuelLevel(true);
            if (level < 0.0) {
                return i18n.getString("EventData.notAvailable", "n/a");
            }
            long pct = Math.round(level * 100.0);
            return pct + "%";
        }
        if (EventData._keyMatch(key, KEY_FUEL_LEVEL2)) {
            if (getTitle) {
                return i18n.getString("EventData.key.fuelLevel2", "Fuel Level 2");
            }
            double level = ed.getFuelLevel2();
            if (level < 0.0) {
                return i18n.getString("EventData.notAvailable", "n/a");
            }
            long pct = Math.round(level * 100.0);
            return pct + "%";
        }
        if (EventData._keyMatch(key, KEY_FUEL_VOLUME)) {
            if (getTitle) {
                return i18n.getString("EventData.key.fuelVolume", "Fuel Volume");
            }
            Device device = ed.getDevice();
            if (device == null) {
                return "";
            }
            Account.VolumeUnits vu = Account.getVolumeUnits(ed.getAccount());
            double L = device.getFuelCapacity() * ed.getFuelLevel(true);
            double V = vu.convertFromLiters(L);
            return StringTools.format((double)V, (String)"0.0") + " " + vu.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_TIRE_TEMP)) {
            if (getTitle) {
                return i18n.getString("EventData.key.tireTemp", "Tire Temp");
            }
            Account.TemperatureUnits tu = Account.getTemperatureUnits(ed.getAccount());
            double[] T = ed.getTireTemp_units(tu);
            StringBuffer sb = new StringBuffer();
            for (int t = 0; t < T.length; ++t) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(StringTools.format((double)T[t], (String)"0.0"));
            }
            sb.append(" ");
            sb.append(tu.toString(locale));
            return sb.toString();
        }
        if (EventData._keyMatch(key, KEY_TIRE_PRESSURE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.tirePressure", "Tire Pressure");
            }
            Account.PressureUnits pu = Account.getPressureUnits(ed.getAccount());
            double[] P = ed.getTirePressure_units(pu);
            StringBuffer sb = new StringBuffer();
            for (int p = 0; p < P.length; ++p) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(StringTools.format((double)P[p], (String)"0.0"));
            }
            return sb + " " + pu.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_ADDRESS)) {
            if (getTitle) {
                return i18n.getString("EventData.key.address", "Address");
            }
            return ed.getAddress();
        }
        if (EventData._keyMatch(key, KEY_STREETADDR)) {
            if (getTitle) {
                return i18n.getString("EventData.key.streetAddress", "Street");
            }
            return ed.getStreetAddress();
        }
        if (EventData._keyMatch(key, KEY_CITY)) {
            if (getTitle) {
                return i18n.getString("EventData.key.city", "City");
            }
            return ed.getCity();
        }
        if (EventData._keyMatch(key, KEY_STATE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.state", "State");
            }
            return ed.getStateProvince();
        }
        if (EventData._keyMatch(key, KEY_POSTALCODE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.postalCode", "Postal Code");
            }
            return ed.getPostalCode();
        }
        if (EventData._keyMatch(key, KEY_SUBDIVISION)) {
            if (getTitle) {
                return i18n.getString("EventData.key.subdivision", "Country/State");
            }
            return ed.getSubdivision();
        }
        if (EventData._keyMatch(key, KEY_FAULT_CODES)) {
            if (getTitle) {
                return i18n.getString("EventData.key.faultCodes", "Fault Codes");
            }
            String evFault = ed.getFieldValue(FLD_faultCode, "").toUpperCase();
            if (StringTools.isBlank((String)evFault)) {
                long fault = ed.getFieldValue(FLD_j1708Fault, 0L);
                return DTOBDFault.GetFaultString(fault);
            }
            RTProperties rtpFault = new RTProperties(evFault);
            return DTOBDFault.GetFaultString(rtpFault);
        }
        if (EventData._keyMatch(key, KEY_FAULT_CODE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.faultCode", "Fault Code");
            }
            long fault = ed.getFieldValue(FLD_j1708Fault, 0L);
            return DTOBDFault.GetFaultString(fault);
        }
        if (EventData._keyMatch(key, KEY_FAULT_HEADER)) {
            if (getTitle) {
                return i18n.getString("EventData.key.faultHeader", "Fault Header");
            }
            long fault = ed.getFieldValue(FLD_j1708Fault, 0L);
            return DTOBDFault.GetFaultHeader(fault);
        }
        if (EventData._keyMatch(key, KEY_FAULT_DESC)) {
            if (getTitle) {
                return i18n.getString("EventData.key.faultDescr", "Fault Description");
            }
            long fault = ed.getFieldValue(FLD_j1708Fault, 0L);
            return DTOBDFault.GetFaultDescription(fault, locale);
        }
        if (EventData._keyMatch(key, KEY_GEOZONEID)) {
            if (getTitle) {
                return i18n.getString("EventData.key.geozoneID", "Geozone ID");
            }
            return ed.getGeozoneID();
        }
        if (EventData._keyMatch(key, KEY_GEOZONE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.geozoneDescription", "Geozone");
            }
            if (arg.equalsIgnoreCase("id")) {
                return ed.getGeozoneID();
            }
            if (arg.equalsIgnoreCase("name")) {
                return ed.getGeozoneDisplayName();
            }
            return ed.getGeozoneDescription();
        }
        if (EventData._keyMatch(key, KEY_GEOZONENAME)) {
            if (getTitle) {
                return i18n.getString("EventData.key.geozoneName", "Geozone Name");
            }
            return ed.getGeozoneDisplayName();
        }
        if (EventData._keyMatch(key, KEY_ENTITYID)) {
            if (getTitle) {
                return i18n.getString("EventData.key.entityID", "Entity ID");
            }
            return ed.getEntityID();
        }
        if (EventData._keyMatch(key, KEY_ENTITY)) {
            if (getTitle) {
                return i18n.getString("EventData.key.entityDescription", "Entity");
            }
            if (arg.equalsIgnoreCase("id")) {
                return ed.getEntityID();
            }
            String aid = ed.getAccountID();
            String eid = ed.getEntityID();
            int type = ed.getEntityType();
            return Device.getEntityDescription(aid, eid, type);
        }
        if (EventData._keyMatch(key, KEY_DRIVERID)) {
            if (getTitle) {
                return i18n.getString("EventData.key.driverID", "Driver ID");
            }
            return ed.getDriverID(true);
        }
        if (EventData._keyMatch(key, KEY_DRIVER_DESC)) {
            String entityID;
            if (getTitle) {
                return i18n.getString("EventData.key.driverDescription", "Driver");
            }
            String driverID = ed.getDriverID(true);
            if (!StringTools.isBlank((String)driverID)) {
                Driver driver = ed.getDriver(true);
                if (driver != null) {
                    return driver.getDescription();
                }
                Print.logDebug((String)("Unable to read Driver: " + driverID), (Object[])new Object[0]);
                return driverID;
            }
            int entityType = ed.getEntityType();
            String string = entityID = entityType == EntityManager.EntityType.DRIVER.getIntValue() ? ed.getEntityID() : null;
            if (!StringTools.isBlank((String)entityID)) {
                String desc = Device.getEntityDescription(ed.getAccountID(), entityID, entityType);
                if (!StringTools.isBlank((String)desc)) {
                    return desc;
                }
                return entityID;
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_DRIVER_BADGE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.driverBadge", "Driver Badge");
            }
            String driverID = ed.getDriverID();
            if (!StringTools.isBlank((String)driverID)) {
                Driver driver = ed.getDriver(true);
                if (driver != null) {
                    return driver.getBadgeID();
                }
                Print.logDebug((String)("Unable to read Driver: " + driverID), (Object[])new Object[0]);
                return driverID;
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_DRIVER_LICENSE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.driverLicense", "Driver License");
            }
            String driverID = ed.getDriverID();
            if (!StringTools.isBlank((String)driverID)) {
                Driver driver = ed.getDriver(true);
                if (driver != null) {
                    return driver.getLicenseNumber();
                }
                Print.logDebug((String)("Unable to read Driver: " + driverID), (Object[])new Object[0]);
                return driverID;
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_INPUT_MASK)) {
            int blen;
            if (getTitle) {
                return i18n.getString("EventData.key.inputMask", "Input Mask");
            }
            int input = (int)ed.getInputMask();
            String s = StringTools.toBinaryString((int)input);
            int slen = s.length();
            int len = slen >= (blen = StringTools.parseInt((String)arg, (int)8)) ? slen - blen : 0;
            return s.substring(len, slen);
        }
        if (EventData._keyMatch(key, KEY_INPUT_BIT)) {
            int argBit = StringTools.parseInt((String)arg, (int)0);
            if (getTitle) {
                return i18n.getString("EventData.key.inputBit", "Input Bit {0}", (Object)String.valueOf(argBit));
            }
            int input = (int)ed.getInputMask();
            if ((input & 1 << argBit) != 0) {
                return i18n.getString("EventData.bitTrue", "On");
            }
            return i18n.getString("EventData.bitFalse", "Off");
        }
        if (EventData._keyMatch(key, KEY_OUTPUT_MASK)) {
            int blen;
            if (getTitle) {
                return i18n.getString("EventData.key.outputMask", "Output Mask");
            }
            int output = (int)ed.getOutputMask();
            String s = StringTools.toBinaryString((int)output);
            int slen = s.length();
            int len = slen >= (blen = StringTools.parseInt((String)arg, (int)8)) ? slen - blen : 0;
            return s.substring(len, slen);
        }
        if (EventData._keyMatch(key, KEY_OUTPUT_BIT)) {
            int argBit = StringTools.parseInt((String)arg, (int)0);
            if (getTitle) {
                return i18n.getString("EventData.key.outputBit", "Output Bit {0}", (Object)String.valueOf(argBit));
            }
            int output = (int)ed.getOutputMask();
            if ((output & 1 << argBit) != 0) {
                return i18n.getString("EventData.bitTrue", "On");
            }
            return i18n.getString("EventData.bitFalse", "Off");
        }
        if (EventData._keyMatch(key, KEY_SEATBELT_MASK)) {
            int blen;
            if (getTitle) {
                return i18n.getString("EventData.key.seatbeltMask", "Seatbelt Mask");
            }
            int seatbelt = (int)ed.getSeatbeltMask();
            String s = StringTools.toBinaryString((int)seatbelt);
            int slen = s.length();
            int len = slen >= (blen = StringTools.parseInt((String)arg, (int)8)) ? slen - blen : 0;
            return s.substring(len, slen);
        }
        if (EventData._keyMatch(key, KEY_SEATBELT_BIT)) {
            int argBit = StringTools.parseInt((String)arg, (int)0);
            if (getTitle) {
                if (argBit == 0) {
                    return i18n.getString("EventData.key.seatbeltDrver", "Seatbelt Driver");
                }
                return i18n.getString("EventData.key.seatbeltBit", "Seatbelt #{0}", (Object)String.valueOf(argBit));
            }
            int seatbelt = (int)ed.getSeatbeltMask();
            if (argBit >= 0 && (seatbelt & 1 << argBit) != 0) {
                return i18n.getString("EventData.bitTrue", "On");
            }
            return i18n.getString("EventData.bitFalse", "Off");
        }
        if (EventData._keyMatch(key, KEY_TEMPERATURE)) {
            int argNdx = StringTools.parseInt((String)arg, (int)0);
            if (getTitle) {
                return i18n.getString("EventData.key.temperature", "Temperature {0}", (Object)String.valueOf(argNdx));
            }
            Account.TemperatureUnits tu = Account.getTemperatureUnits(ed.getAccount());
            double tempC = ed.getThermoAverage(argNdx);
            if (EventData.isValidTemperature(tempC)) {
                double temp = tu.convertFromC(tempC);
                StringBuffer sb = new StringBuffer();
                sb.append(StringTools.format((double)temp, (String)"0.0"));
                sb.append(" ");
                sb.append(tu.toString(locale));
                return sb.toString();
            }
            return i18n.getString("EventData.notAvailable", "n/a");
        }
        if (EventData._keyMatch(key, KEY_TEMP_ALL)) {
            int argNdx = StringTools.parseInt((String)key.substring(key.length() - 1), (int)-1);
            if (argNdx < 0) {
                argNdx = StringTools.parseInt((String)arg, (int)0);
            }
            if (getTitle) {
                return i18n.getString("EventData.key.temperature", "Temperature {0}", (Object)String.valueOf(argNdx));
            }
            Account.TemperatureUnits tu = Account.getTemperatureUnits(ed.getAccount());
            double tempC = ed.getThermoAverage(argNdx);
            if (EventData.isValidTemperature(tempC)) {
                double temp = tu.convertFromC(tempC);
                StringBuffer sb = new StringBuffer();
                sb.append(StringTools.format((double)temp, (String)"0.0"));
                sb.append(" ");
                sb.append(tu.toString(locale));
                return sb.toString();
            }
            return i18n.getString("EventData.notAvailable", "n/a");
        }
        if (EventData._keyMatch(key, KEY_SERVICE_NOTES)) {
            if (getTitle) {
                return i18n.getString("EventData.key.serviceNotes", "Service Notes");
            }
            Device device = ed.getDevice();
            return device != null ? device.getMaintNotes() : "";
        }
        if (EventData._keyMatch(key, KEY_MAPLINK)) {
            if (getTitle) {
                return i18n.getString("EventData.key.mapLink", "Map Link");
            }
            Account.LatLonFormat latlonFmt = Account.getLatLonFormat(ed.getAccount());
            double lat = ed.getLatitude();
            double lon = ed.getLongitude();
            String fmt = "5";
            String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
            String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
            StringBuffer url = new StringBuffer();
            url.append("http://maps.google.com/maps?f=q&source=s_q&hl=en&geocode=&q=");
            url.append(latStr).append(",").append(lonStr);
            if (arg.equalsIgnoreCase("a") || arg.equalsIgnoreCase("html")) {
                String dsc = i18n.getString("EventData.key.map", "Map");
                String a = "$HTML:<a href='" + url + "' target='_blank'>" + dsc + "</a>";
                return a;
            }
            return url.toString();
        }
        if (EventData._keyMatch(key, KEY_ETA_DATETIME)) {
            if (getTitle) {
                return i18n.getString("EventData.key.etaDateTime", "ETA Date/Time");
            }
            long ts = ed.getEtaTimestamp();
            Account acct = ed.getAccount();
            TimeZone tmz = ed.getTimeZone();
            return EventData.getTimestampString(ts, acct, tmz, null);
        }
        if (EventData._keyMatch(key, KEY_ETA_UNIQUE_ID)) {
            if (getTitle) {
                return i18n.getString("EventData.key.etaUniqueID", "ETA Unique ID");
            }
            long id = ed.getEtaUniqueID();
            return String.valueOf(id);
        }
        if (EventData._keyMatch(key, KEY_ETA_DISTANCE)) {
            if (getTitle) {
                return i18n.getString("EventData.key.etaDistance", "ETA Distance");
            }
            double distKM = ed.getEtaDistanceKM();
            Account account = ed.getAccount();
            if (account != null) {
                return account.getDistanceString(distKM, true, locale);
            }
            return StringTools.format((double)distKM, (String)"0") + " " + Account.DistanceUnits.KM.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_ETA_GEOPOINT)) {
            if (getTitle) {
                return i18n.getString("EventData.key.etaLatLon", "ETA Latitude/Longitude");
            }
            Account.LatLonFormat latlonFmt = Account.getLatLonFormat(ed.getAccount());
            double lat = ed.getEtaLatitude();
            double lon = ed.getEtaLongitude();
            String fmt = latlonFmt.isDegMinSec() ? "DMS" : (latlonFmt.isDegMin() ? "DM" : "5");
            String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
            String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
            return latStr + "/" + lonStr;
        }
        if (EventData._keyMatch(key, KEY_STOP_ID)) {
            if (getTitle) {
                return i18n.getString("EventData.key.stopID", "Stop ID");
            }
            long id = ed.getStopID();
            return String.valueOf(id);
        }
        if (EventData._keyMatch(key, KEY_STOP_STATUS)) {
            if (getTitle) {
                return i18n.getString("EventData.key.stopStatus", "Stop Status");
            }
            int status = ed.getStopStatus();
            return String.valueOf(status);
        }
        if (EventData._keyMatch(key, KEY_STOP_INDEX)) {
            if (getTitle) {
                return i18n.getString("EventData.key.stopIndex", "Stop Index");
            }
            int ndx = ed.getStopIndex();
            return String.valueOf(ndx);
        }
        if (getTitle) {
            DBField dbFld = EventData.getFactory().getField(key);
            if (dbFld != null) {
                return dbFld.getTitle(locale);
            }
        } else {
            DBField dbFld;
            String fldName = ed.getFieldName(key);
            DBField dBField = dbFld = fldName != null ? ed.getField(fldName) : null;
            if (dbFld != null) {
                Account account;
                Object val = ed.getFieldValue(fldName);
                if (val == null) {
                    val = dbFld.getDefaultValue();
                }
                if ((account = ed.getAccount()) != null) {
                    val = account.convertFieldUnits(dbFld, val, true, locale);
                    return StringTools.trim((Object)val);
                }
                return dbFld.formatValue(val);
            }
        }
        if (getTitle) {
            return Device._getKeyFieldString(true, key, arg, locale, null, null);
        }
        Device device = ed.getDevice();
        if (device != null) {
            return Device._getKeyFieldString(false, key, arg, locale, bpl, device);
        }
        if (getTitle) {
            return Account._getKeyFieldString(true, key, arg, locale, null, null);
        }
        return Account._getKeyFieldString(false, key, arg, locale, bpl, ed.getAccount());
    }

    public static Comparator<EventData> getDeviceDescriptionComparator() {
        if (devDescComparator == null) {
            devDescComparator = new DeviceDescriptionComparator();
        }
        return devDescComparator;
    }

    private static void usage() {
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + EventData.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -eps=<HOURS>   Display event-per-second over the last specified HOURS", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String deviceID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (RTConfig.hasProperty((String[])ARG_EVENTS_PER_SECOND)) {
            long deltaSec = RTConfig.getLong((String[])ARG_EVENTS_PER_SECOND, (long)24L) * DateTime.HourSeconds((long)1L);
            if (deltaSec <= 0L) {
                deltaSec = DateTime.HourSeconds((long)24L);
            }
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            try {
                long nowTime = DateTime.getCurrentTimeSec();
                long count = EventData.getRecordCount(null, null, nowTime - deltaSec, nowTime);
                String fmtEPS = StringTools.format((double)((double)count / (double)deltaSec), (String)"0.0000000");
                String fmtHours = StringTools.format((double)((double)deltaSec / 3600.0), (String)"0.00");
                Print.sysPrintln((String)("Event Time Range : " + fmtHours + " hours"), (Object[])new Object[0]);
                Print.sysPrintln((String)("Total Events     : " + count), (Object[])new Object[0]);
                Print.sysPrintln((String)("Events Per Second: " + fmtEPS), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logException((String)"Retrieving record count for EventData table", (Throwable)dbe);
            }
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_QUERY_ALL, (boolean)false)) {
            String addrSizeKey = "db.typeSize.address";
            Print.logInfo((String)(addrSizeKey + " = " + RTConfig.getInt((String)addrSizeKey, (int)-1) + " [expected]"), (Object[])new Object[0]);
            DBField addrFld = EventData.getFactory().getField(FLD_address);
            if (addrFld != null) {
                Print.sysPrintln((String)("EventData address field length = " + addrFld.getStringLength() + " [found]"), (Object[])new Object[0]);
            } else {
                Print.sysPrintln((String)"EROR: EventData.address not found", (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_QUERY_ALL, (boolean)false)) {
            DBSelect<EventData> dsel = EventData._createRangeEventSelector(accountID, deviceID, -1L, -1L, null, false, LimitType.FIRST, 0L, true, null);
            try {
                DBRecordIterator dbi = new DBRecordIterator(dsel);
                int rc = 1;
                while (dbi.hasNext()) {
                    EventData ed = (EventData)dbi.next();
                    StringBuffer sb = new StringBuffer();
                    sb.append(rc).append(") ");
                    sb.append(ed.getTimestamp()).append("  ");
                    sb.append(new DateTime(ed.getTimestamp()).toString()).append("  ");
                    sb.append(ed.getGeoPoint().toString());
                    Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                    ++rc;
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"", (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        Print.sysPrintln((String)"No command-line options specified", (Object[])new Object[0]);
        EventData.usage();
    }

    static {
        EventData.getDeviceDescriptionComparator();
        EMPTY_ARRAY = new EventData[0];
        AddressColumnLength = -1;
        StreetColumnLength = -1;
        CityColumnLength = -1;
        StateColumnLength = -1;
        PostalColumnLength = -1;
        StandardFieldInfo = new DBField[]{EventData.newField_accountID(true, EventData.Altkey_AccountID()), EventData.newField_deviceID(true, EventData.Altkey_DeviceID()), new DBField(FLD_timestamp, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.timestamp", (String)"Timestamp"), "key=true " + EventData.Altkey_Timestamp()), new DBField(FLD_statusCode, Integer.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.statusCode", (String)"Status Code"), "key=true editor=statusCode format=X2"), new DBField(FLD_latitude, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.latitude", (String)"Latitude"), "format=#0.00000"), new DBField(FLD_longitude, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.longitude", (String)"Longitude"), "format=#0.00000"), new DBField(FLD_gpsAge, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.gpsAge", (String)"GPS Fix Age"), ""), new DBField(FLD_speedKPH, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.speedKPH", (String)"Speed"), "format=#0.0 units=speed"), new DBField("heading", Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.heading", (String)"Heading"), "format=#0.0"), new DBField(FLD_altitude, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.altitude", (String)"Altitude"), "format=#0.0"), new DBField(FLD_transportID, String.class, DBField.TYPE_XPORT_ID(), I18N.getString(EventData.class, (String)"EventData.fld.transportID", (String)"Transport ID"), ""), new DBField(FLD_inputMask, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.inputMask", (String)"Input Mask"), "format=X4"), new DBField(FLD_outputMask, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.outputMask", (String)"Output Mask"), "format=X4"), new DBField(FLD_seatbeltMask, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.seatbeltMask", (String)"Seatbelt Mask"), "format=X4"), new DBField(FLD_address, String.class, DBField.TYPE_ADDRESS(), I18N.getString(EventData.class, (String)"EventData.fld.address", (String)"Full Address"), "utf8=true"), new DBField(FLD_dataSource, String.class, DBField.TYPE_STRING((int)32), I18N.getString(EventData.class, (String)"EventData.fld.dataSource", (String)"Data Source"), ""), new DBField(FLD_rawData, String.class, "TEXT", I18N.getString(EventData.class, (String)"EventData.fld.rawData", (String)"Raw Data"), ""), new DBField(FLD_distanceKM, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.distanceKM", (String)"Distance KM"), "format=#0.0 units=distance"), new DBField(FLD_odometerKM, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.odometerOffsetKM", (String)"Odometer Offset KM"), "format=#0.0 units=distance"), new DBField(FLD_odometerOffsetKM, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.odometerKM", (String)"Odometer KM"), "format=#0.0 units=distance"), new DBField(FLD_geozoneIndex, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.geozoneIndex", (String)"Geozone Index"), ""), new DBField(FLD_geozoneID, String.class, DBField.TYPE_ZONE_ID(), I18N.getString(EventData.class, (String)"EventData.fld.geozoneID", (String)"Geozone ID"), ""), EventData.newField_creationTime((boolean)RTConfig.getBoolean((String)"EventData.keyedCreationTime", (boolean)false))};
        AddressFieldInfo = new DBField[]{new DBField(FLD_streetAddress, String.class, DBField.TYPE_STRING((int)90), I18N.getString(EventData.class, (String)"EventData.fld.streetAddress", (String)"Street Address"), "utf8=true"), new DBField(FLD_city, String.class, DBField.TYPE_STRING((int)40), I18N.getString(EventData.class, (String)"EventData.fld.city", (String)"City"), "utf8=true"), new DBField(FLD_stateProvince, String.class, DBField.TYPE_STRING((int)40), I18N.getString(EventData.class, (String)"EventData.fld.stateProvince", (String)"State/Privince"), "utf8=true"), new DBField(FLD_postalCode, String.class, DBField.TYPE_STRING((int)16), I18N.getString(EventData.class, (String)"EventData.fld.postalCode", (String)"Postal Code"), "utf8=true"), new DBField(FLD_country, String.class, DBField.TYPE_STRING((int)40), I18N.getString(EventData.class, (String)"EventData.fld.country", (String)"Country"), "utf8=true"), new DBField(FLD_subdivision, String.class, DBField.TYPE_STRING((int)32), I18N.getString(EventData.class, (String)"EventData.fld.subdivision", (String)"Subdivision"), "utf8=true"), new DBField(FLD_speedLimitKPH, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.speedLimitKPH", (String)"Speed Limit"), "format=#0.0 units=speed"), new DBField(FLD_isTollRoad, Boolean.TYPE, "BOOLEAN", I18N.getString(EventData.class, (String)"EventData.fld.isTollRoad", (String)"Toll Road"), "")};
        GPSFieldInfo = new DBField[]{new DBField(FLD_gpsFixType, Integer.TYPE, "UINT16", I18N.getString(EventData.class, (String)"EventData.fld.gpsFixType", (String)"GPS Fix Type"), "enum=EventData$GPSFixType"), new DBField(FLD_gpsFixStatus, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.gpsFixStatus", (String)"GPS Fix Status"), ""), new DBField(FLD_horzAccuracy, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.horzAccuracy", (String)"Horizontal Accuracy"), "format=#0.0"), new DBField(FLD_vertAccuracy, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.vertAccuracy", (String)"Vertical Accuracy"), "format=#0.0"), new DBField(FLD_HDOP, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.HDOP", (String)FLD_HDOP), "format=#0.0"), new DBField(FLD_satelliteCount, Integer.TYPE, "UINT16", I18N.getString(EventData.class, (String)"EventData.fld.satelliteCount", (String)"Number of Satellites"), ""), new DBField(FLD_batteryLevel, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.batteryLevel", (String)"Battery Level %"), "format=#0.0 units=percent"), new DBField(FLD_batteryVolts, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.batteryVolts", (String)"Battery Volts"), "format=#0.0"), new DBField(FLD_signalStrength, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.signalStrength", (String)"Signal Strength (RSSI)"), "format=#0.0")};
        CustomFieldInfo = new DBField[]{new DBField(FLD_priority, Integer.TYPE, "UINT16", I18N.getString(EventData.class, (String)"EventData.fld.priority", (String)"Priority"), ""), new DBField(FLD_entityID, String.class, DBField.TYPE_ENTITY_ID(), I18N.getString(EventData.class, (String)"EventData.fld.entityID", (String)"Entity ID"), "utf8=true"), new DBField(FLD_entityType, Integer.TYPE, "UINT16", I18N.getString(EventData.class, (String)"EventData.fld.entityType", (String)"Entity Type"), "enum=EntityManager$EntityType"), new DBField(FLD_driverID, String.class, DBField.TYPE_DRIVER_ID(), I18N.getString(EventData.class, (String)"EventData.fld.driverID", (String)"Driver/User"), "utf8=true"), new DBField(FLD_driverStatus, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.driverStatus", (String)"Driver Status"), ""), new DBField(FLD_driverMessage, String.class, DBField.TYPE_STRING((int)200), I18N.getString(EventData.class, (String)"EventData.fld.driverMessage", (String)"Driver Message"), "utf8=true"), new DBField(FLD_sensorLow, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.sensorLow", (String)"Sensor Low"), "format=X4"), new DBField(FLD_sensorHigh, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.sensorHigh", (String)"Sensor High"), "format=X4"), new DBField(FLD_costCenter, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.costCenter", (String)"Cost Center"), ""), new DBField(FLD_jobNumber, String.class, DBField.TYPE_STRING((int)32), I18N.getString(EventData.class, (String)"EventData.fld.jobNumber", (String)"Job Number"), ""), new DBField(FLD_rfidTag, String.class, DBField.TYPE_STRING((int)32), I18N.getString(EventData.class, (String)"EventData.fld.rfidTag", (String)"RFID/BarCode Tag"), ""), new DBField(FLD_attachType, String.class, DBField.TYPE_STRING((int)64), I18N.getString(EventData.class, (String)"EventData.fld.attachType", (String)"Attachment MIME Type"), ""), new DBField(FLD_attachData, byte[].class, "BLOB", I18N.getString(EventData.class, (String)"EventData.fld.attachData", (String)"Attachment Data"), "")};
        CANBUSFieldInfo = new DBField[]{new DBField(FLD_fuelPressure, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelPressure", (String)"Fuel Pressure"), "format=#0.00 units=pressure"), new DBField(FLD_fuelUsage, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelUsage", (String)"Fuel Usage"), "format=#0.00"), new DBField(FLD_fuelTemp, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelTemp", (String)"Fuel Temp"), "format=#0.00 units=temp"), new DBField(FLD_fuelLevel, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelLevel", (String)"Fuel Level"), "format=#0.0 units=percent"), new DBField(FLD_fuelLevel2, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelLevel2", (String)"Fuel Level 2"), "format=#0.0 units=percent"), new DBField(FLD_fuelEconomy, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelEconomy", (String)"Fuel Economy"), "format=#0.0 units=econ"), new DBField(FLD_fuelTotal, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelTotal", (String)"Total Fuel Used"), "format=#0.0 units=volume"), new DBField(FLD_fuelRemain, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelRemain", (String)"Fuel Remaining"), "format=#0.0 units=volume"), new DBField(FLD_fuelTrip, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelTrip", (String)"Trip Fuel Used"), "format=#0.0 units=volume"), new DBField(FLD_fuelIdle, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelIdle", (String)"Idle Fuel Used"), "format=#0.0 units=volume"), new DBField(FLD_fuelPTO, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelPTO", (String)"PTO Fuel Used"), "format=#0.0 units=volume"), new DBField(FLD_fuelEngineOn, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.fuelEngineOn", (String)"Fuel Since Engine On"), "format=#0.0 units=volume"), new DBField(FLD_engineRpm, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.engineRpm", (String)"Engine RPM"), ""), new DBField(FLD_engineHours, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.engineHours", (String)"Engine Hours"), "format=#0.0"), new DBField(FLD_engineOnHours, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.engineOnHours", (String)"Engine 'On' Hours"), "format=#0.0"), new DBField(FLD_engineLoad, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.engineLoad", (String)"Engine Load"), "format=#0.00 units=percent"), new DBField(FLD_engineTorque, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.engineTorque", (String)"Engine Torque %"), "format=#0.00 units=percent"), new DBField(FLD_idleHours, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.idleHours", (String)"Idle Hours"), "format=#0.0"), new DBField(FLD_workHours, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.workHours", (String)"Work Hours"), "format=#0.0"), new DBField(FLD_transOilTemp, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.transOilTemp", (String)"Transmission Oil Temp"), "format=#0.00 units=temp"), new DBField(FLD_coolantLevel, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.coolantLevel", (String)"Coolant Level"), "format=#0.00 units=percent"), new DBField(FLD_coolantTemp, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.coolantTemp", (String)"Coolant Temperature"), "format=#0.00 units=temp"), new DBField(FLD_intakeTemp, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.intakeTemp", (String)"Intake Temperature"), "format=#0.00 units=temp"), new DBField(FLD_brakeGForce, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.brakeGForce", (String)"Brake G Force"), "format=#0.00"), new DBField(FLD_acceleration, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.acceleration", (String)"Acceleration"), "format=#0.00"), new DBField(FLD_accelerometerXYZ, String.class, DBField.TYPE_STRING((int)32), I18N.getString(EventData.class, (String)"EventData.fld.accelerometerXYZ", (String)"Accelerometer XYZ"), ""), new DBField(FLD_brakePressure, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.brakePressure", (String)"Brake Pressure"), "format=#0.00 units=pressure"), new DBField(FLD_massAirFlowRate, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.massAirFlowRate", (String)"Mass Air Flow Rate"), "format=#0.00"), new DBField(FLD_oilPressure, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.oilPressure", (String)"Oil Pressure"), "format=#0.00 units=pressure"), new DBField(FLD_oilLevel, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.oilLevel", (String)"Oil Level"), "format=#0.00"), new DBField(FLD_oilTemp, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.oilTemp", (String)"Oil Temperature"), "format=#0.00 units=temp"), new DBField(FLD_airPressure, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.airPressure", (String)"Air Supply Pressure"), "format=#0.00 units=pressure"), new DBField(FLD_airFilterPressure, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.airFilterPressure", (String)"Air Filter Pressure"), "format=#0.00 units=pressure"), new DBField(FLD_turboPressure, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.turboPressure", (String)"Turbo Pressure"), "format=#0.00 units=pressure"), new DBField(FLD_ptoEngaged, Boolean.TYPE, "BOOLEAN", I18N.getString(EventData.class, (String)"EventData.fld.ptoEngaged", (String)"PTO Engaged"), ""), new DBField(FLD_ptoHours, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.ptoHours", (String)"PTO Hours"), "format=#0.0"), new DBField(FLD_throttlePos, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.throttlePos", (String)"Throttle Position"), "format=#0.0 units=percent"), new DBField(FLD_brakePos, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.brakePos", (String)"Brake Position"), "format=#0.0 units=percent"), new DBField(FLD_vBatteryVolts, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.vBatteryVolts", (String)"Vehicle Battery Volts"), "format=#0.0"), new DBField(FLD_j1708Fault, Long.TYPE, "UINT64", I18N.getString(EventData.class, (String)"EventData.fld.j1708Fault", (String)"Fault Code"), ""), new DBField(FLD_faultCode, String.class, DBField.TYPE_STRING((int)96), I18N.getString(EventData.class, (String)"EventData.fld.faultCode", (String)"Fault String"), ""), new DBField(FLD_malfunctionLamp, Boolean.TYPE, "BOOLEAN", I18N.getString(EventData.class, (String)"EventData.fld.malfunctionLamp", (String)"Malfunction Lamp"), ""), new DBField(FLD_tirePressure, String.class, DBField.TYPE_STRING((int)140), I18N.getString(EventData.class, (String)"EventData.fld.tirePressure", (String)"Tire Pressure"), "format=#0.00 units=pressure"), new DBField(FLD_tireTemp, String.class, DBField.TYPE_STRING((int)140), I18N.getString(EventData.class, (String)"EventData.fld.tireTemp", (String)"Tire Temperature"), "format=#0.00 units=temp"), new DBField(FLD_tankLevel, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.tankLevel", (String)"Tank Level"), "format=#0.0 units=percent")};
        GarminFieldInfo = new DBField[]{new DBField(FLD_etaTimestamp, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.etaTimestamp", (String)"ETA Time"), "format=time"), new DBField(FLD_etaUniqueID, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.etaUniqueID", (String)"ETA Unique ID"), ""), new DBField(FLD_etaDistanceKM, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.etaDistanceKM", (String)"ETA Distance KM"), "format=#0.0 units=distance"), new DBField(FLD_etaLatitude, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.etaLatitude", (String)"ETA Latitude"), "format=#0.00000"), new DBField(FLD_etaLongitude, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.etaLongitude", (String)"ETA Longitude"), "format=#0.00000"), new DBField(FLD_stopID, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.stopID", (String)"STOP ID"), ""), new DBField(FLD_stopStatus, Integer.TYPE, "UINT16", I18N.getString(EventData.class, (String)"EventData.fld.stopStatus", (String)"STOP Status"), ""), new DBField(FLD_stopIndex, Integer.TYPE, DBField.TYPE_STOP_INDEX(), I18N.getString(EventData.class, (String)"EventData.fld.stopIndex", (String)"STOP Index"), "")};
        AtmosphereFieldInfo = new DBField[]{new DBField(FLD_barometer, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.barometer", (String)"Barometric Pressure"), "format=#0.00 units=pressure"), new DBField(FLD_ambientTemp, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.ambientTemp", (String)"Ambient Temperature"), "format=#0.0 units=temp"), new DBField(FLD_cabinTemp, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.cabinTemp", (String)"Cabin Temperature"), "format=#0.0 units=temp")};
        ThermoFieldInfo = new DBField[]{new DBField(FLD_thermoAverage0, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.thermoAverage0", (String)"Temperature Average 0"), "format=#0.0 units=temp"), new DBField(FLD_thermoAverage1, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.thermoAverage1", (String)"Temperature Average 1"), "format=#0.0 units=temp"), new DBField(FLD_thermoAverage2, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.thermoAverage2", (String)"Temperature Average 2"), "format=#0.0 units=temp"), new DBField(FLD_thermoAverage3, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.thermoAverage3", (String)"Temperature Average 3"), "format=#0.0 units=temp"), new DBField(FLD_thermoAverage4, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.thermoAverage4", (String)"Temperature Average 4"), "format=#0.0 units=temp"), new DBField(FLD_thermoAverage5, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.thermoAverage5", (String)"Temperature Average 5"), "format=#0.0 units=temp"), new DBField(FLD_thermoAverage6, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.thermoAverage6", (String)"Temperature Average 6"), "format=#0.0 units=temp"), new DBField(FLD_thermoAverage7, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.thermoAverage7", (String)"Temperature Average 7"), "format=#0.0 units=temp")};
        AnalogFieldInfo = new DBField[]{new DBField(FLD_pulseCount, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.pulseCount", (String)"Pulse Count/Gain"), "format=#0.0"), new DBField(FLD_analog0, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.analog0", (String)"Analog 0"), "format=#0.0"), new DBField(FLD_analog1, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.analog1", (String)"Analog 1"), "format=#0.0"), new DBField(FLD_analog2, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.analog2", (String)"Analog 2"), "format=#0.0"), new DBField(FLD_analog3, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.analog3", (String)"Analog 3"), "format=#0.0")};
        ServingCellTowerData = new DBField[]{new DBField(FLD_cellTowerID, Integer.TYPE, "INT32", I18N.getString(EventData.class, (String)"EventData.fld.cellTowerID", (String)"Cell Tower ID"), ""), new DBField(FLD_mobileCountryCode, Integer.TYPE, "INT32", I18N.getString(EventData.class, (String)"EventData.fld.mobileCountryCode", (String)"Mobile Country Code"), ""), new DBField(FLD_mobileNetworkCode, Integer.TYPE, "INT32", I18N.getString(EventData.class, (String)"EventData.fld.mobileNetworkCode", (String)"Mobile Network Code"), ""), new DBField(FLD_cellTimingAdvance, Integer.TYPE, "INT32", I18N.getString(EventData.class, (String)"EventData.fld.cellTimingAdvance", (String)"Cell Timing Advance"), ""), new DBField(FLD_locationAreaCode, Integer.TYPE, "INT32", I18N.getString(EventData.class, (String)"EventData.fld.locationAreaCode", (String)"Location Area Code"), ""), new DBField(FLD_cellServingInfo, String.class, DBField.TYPE_STRING((int)80), I18N.getString(EventData.class, (String)"EventData.fld.cellServingInfo", (String)"Serving Cell Info"), ""), new DBField(FLD_cellLatitude, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.cellLatitude", (String)"Cell Tower Latitude"), "format=#0.00000"), new DBField(FLD_cellLongitude, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.cellLongitude", (String)"Cell Tower Longitude"), "format=#0.00000"), new DBField(FLD_cellAccuracy, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.cellAccuracy", (String)"Cell GPS Accuracy M"), "format=#0.0")};
        NeighborCellTowerData = new DBField[]{new DBField(FLD_cellNeighborInfo0, String.class, DBField.TYPE_STRING((int)80), I18N.getString(EventData.class, (String)"EventData.fld.cellNeighborInfo0", (String)"Neighbor Cell Info #0"), ""), new DBField(FLD_cellNeighborInfo1, String.class, DBField.TYPE_STRING((int)80), I18N.getString(EventData.class, (String)"EventData.fld.cellNeighborInfo1", (String)"Neighbor Cell Info #1"), ""), new DBField(FLD_cellNeighborInfo2, String.class, DBField.TYPE_STRING((int)80), I18N.getString(EventData.class, (String)"EventData.fld.cellNeighborInfo2", (String)"Neighbor Cell Info #2"), ""), new DBField(FLD_cellNeighborInfo3, String.class, DBField.TYPE_STRING((int)80), I18N.getString(EventData.class, (String)"EventData.fld.cellNeighborInfo3", (String)"Neighbor Cell Info #3"), ""), new DBField(FLD_cellNeighborInfo4, String.class, DBField.TYPE_STRING((int)80), I18N.getString(EventData.class, (String)"EventData.fld.cellNeighborInfo4", (String)"Neighbor Cell Info #4"), ""), new DBField(FLD_cellNeighborInfo5, String.class, DBField.TYPE_STRING((int)80), I18N.getString(EventData.class, (String)"EventData.fld.cellNeighborInfo5", (String)"Neighbor Cell Info #5"), "")};
        LeaseRentalData = new DBField[]{new DBField(FLD_leaseStartDate, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.leaseStartDay", (String)"Lease Start Date"), "format=date"), new DBField(FLD_leaseEndDate, Long.TYPE, "UINT32", I18N.getString(EventData.class, (String)"EventData.fld.leaseEndDay", (String)"Lease End Date"), "format=date"), new DBField(FLD_leaseStartOdomKM, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.leaseStartOdomKM", (String)"Lease Start Odom KM"), "format=#0.0 units=distance"), new DBField(FLD_leaseAllowedDistKM, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.leaseAllowedDistKM", (String)"Lease Allowed Dist KM"), "format=#0.0 units=distance"), new DBField(FLD_leaseContractID, String.class, DBField.TYPE_STRING((int)32), I18N.getString(EventData.class, (String)"EventData.fld.sampleID", (String)"Sample ID"), "")};
        WorkZoneGridData = new DBField[]{new DBField(FLD_sampleIndex, Integer.TYPE, "INT32", I18N.getString(EventData.class, (String)"EventData.fld.sampleIndex", (String)"Sample Index"), ""), new DBField(FLD_sampleID, String.class, DBField.TYPE_STRING((int)32), I18N.getString(EventData.class, (String)"EventData.fld.sampleID", (String)"Sample ID"), "")};
        CreationTimeMillisecond = new DBField[]{EventData.newField_creationMillis((String)ALTKEY_eq_pushkey), new DBField(FLD_dataPush, Boolean.TYPE, "BOOLEAN", I18N.getString(EventData.class, (String)"EventData.fld.dataPush", (String)"Data Push Indicator"), ALTKEY_eq_pushkey)};
        EndOfDaySummary = new DBField[]{new DBField(FLD_dayEngineStarts, Integer.TYPE, "UINT16", I18N.getString(EventData.class, (String)"EventData.fld.dayEngineStarts", (String)"# Engine Starts"), ""), new DBField(FLD_dayIdleHours, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.dayIdleHours", (String)"Day Idle Hours"), "format=#0.0"), new DBField(FLD_dayFuelIdle, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.dayFuelIdle", (String)"Day Idle Fuel"), "format=#0.0 units=volume"), new DBField(FLD_dayWorkHours, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.dayWorkHours", (String)"Day Work Hours"), "format=#0.0"), new DBField(FLD_dayFuelWork, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.dayFuelWork", (String)"Day Work Fuel"), "format=#0.0 units=volume"), new DBField(FLD_dayFuelPTO, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.dayFuelPTO", (String)"Day PTO Fuel"), "format=#0.0 units=volume"), new DBField(FLD_dayDistanceKM, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.dayDistanceKM", (String)"Day Distance KM"), "format=#0.0 units=distance"), new DBField(FLD_dayFuelTotal, Double.TYPE, "DOUBLE", I18N.getString(EventData.class, (String)"EventData.fld.dayFuelTotal", (String)"Day Total Fuel"), "format=#0.0 units=volume")};
        AutoIncrementIndex = new DBField[]{new DBField(FLD_autoIndex, Long.TYPE, "INT64", I18N.getString(EventData.class, (String)"EventData.fld.autoIndex", (String)"Auto Increment Index"), "key=true auto=true")};
        factory = null;
        DefaultOdometerOffsetType = null;
        DEFAULT_ENTITY_TYPE = EntityManager.EntityType.GENERAL;
        Thermo_COUNT = -1;
        Thermo_COUNT_lock = new Object();
        explicitSetMIL = false;
        DEBUG_PUSHPINS = new String[]{"DebugPushpins", "debugPP"};
        KEY_ACCOUNT = new String[]{"account", "accountDesc"};
        KEY_DEVICE_COUNT = new String[]{"deviceCount", "devCount"};
        KEY_DEVICE = new String[]{"device", "deviceDesc"};
        KEY_EVENT_COUNT24 = new String[]{"eventCount24"};
        KEY_DEVICE_LINK = new String[]{"deviceLink", "devLink"};
        KEY_DEV_CONN_AGE = new String[]{"devConnectAge", "connectAge"};
        KEY_DEV_TRAILERS = new String[]{"deviceEntities", "deviceTrailers"};
        KEY_DATETIME = new String[]{"dateTime", "date"};
        KEY_DATE_YEAR = new String[]{"dateYear", "year"};
        KEY_DATE_MONTH = new String[]{"dateMonth", "month"};
        KEY_DATE_DAY = new String[]{"dateDay", "dayOfMonth", "day"};
        KEY_DATE_DOW = new String[]{"dateDow", "dayOfWeek"};
        KEY_TIMEZONE = new String[]{"timeZone", "tmz"};
        KEY_TIME = new String[]{"time"};
        KEY_STATUSDESC = new String[]{"status"};
        KEY_GEOPOINT = new String[]{"geopoint"};
        KEY_LATITUDE = new String[]{FLD_latitude};
        KEY_LONGITUDE = new String[]{FLD_longitude};
        KEY_GPS_AGE = new String[]{FLD_gpsAge};
        KEY_SPEED = new String[]{"speed"};
        KEY_SPEED_LIMIT = new String[]{"speedLimit"};
        KEY_DIRECTION = new String[]{"direction", "compass"};
        KEY_HEADING = new String[]{"heading", "bearing", "course"};
        KEY_ODOMETER = new String[]{"odometer"};
        KEY_DISTANCE = new String[]{"distance"};
        KEY_ALTITUDE = new String[]{"alt", FLD_altitude};
        KEY_RPT_DISTANCE = new String[]{"reportDistance"};
        KEY_BATTERY_LEVEL = new String[]{FLD_batteryLevel};
        KEY_BATTERY_VOLTS = new String[]{FLD_batteryVolts};
        KEY_VEH_BATTERY_V = new String[]{FLD_vBatteryVolts, "vehicleVolts"};
        KEY_FUEL_LEVEL = new String[]{FLD_fuelLevel};
        KEY_FUEL_LEVEL2 = new String[]{FLD_fuelLevel2};
        KEY_FUEL_VOLUME = new String[]{"fuelLevelVolume", "fuelVolume"};
        KEY_TIRE_TEMP = new String[]{"tireTemperature", FLD_tireTemp};
        KEY_TIRE_PRESSURE = new String[]{FLD_tirePressure, "tirePress"};
        KEY_ADDRESS = new String[]{"fullAddress", FLD_address};
        KEY_STREETADDR = new String[]{FLD_streetAddress, "street"};
        KEY_CITY = new String[]{FLD_city};
        KEY_STATE = new String[]{"state", "province"};
        KEY_POSTALCODE = new String[]{FLD_postalCode, "zipCode"};
        KEY_SUBDIVISION = new String[]{FLD_subdivision, "subdiv"};
        KEY_FAULT_CODE = new String[]{FLD_faultCode};
        KEY_FAULT_CODES = new String[]{"faultCodes"};
        KEY_FAULT_HEADER = new String[]{"faultHeader"};
        KEY_FAULT_DESC = new String[]{"faultDesc"};
        KEY_GEOZONEID = new String[]{FLD_geozoneID};
        KEY_GEOZONE = new String[]{"geozone", "geozoneDesc"};
        KEY_GEOZONENAME = new String[]{"geozoneName"};
        KEY_ENTITYID = new String[]{FLD_entityID};
        KEY_ENTITY = new String[]{"entity", "entityDesc"};
        KEY_SERVICE_NOTES = new String[]{"serviceNotes"};
        KEY_MAPLINK = new String[]{"maplink", "mapurl"};
        KEY_DRIVERID = new String[]{FLD_driverID};
        KEY_DRIVER_DESC = new String[]{"driverDesc", "driver", "driverName"};
        KEY_DRIVER_BADGE = new String[]{"driverBadgeID", "driverBadge"};
        KEY_DRIVER_LICENSE = new String[]{"driverLicense"};
        KEY_INPUT_MASK = new String[]{FLD_inputMask};
        KEY_INPUT_BIT = new String[]{"inputBit"};
        KEY_OUTPUT_MASK = new String[]{FLD_outputMask};
        KEY_OUTPUT_BIT = new String[]{"outputBit"};
        KEY_SEATBELT_MASK = new String[]{FLD_seatbeltMask};
        KEY_SEATBELT_BIT = new String[]{"seatbeltBit"};
        KEY_TEMPERATURE = new String[]{"temperature", "temp", "thermoAverage"};
        KEY_TEMP_ALL = new String[]{"temp0", "temp1", "temp2", "temp3", "temp4", "temp5", "temp6", "temp7"};
        KEY_ETA_DATETIME = new String[]{"etaDateTime"};
        KEY_ETA_UNIQUE_ID = new String[]{FLD_etaUniqueID, "etaID"};
        KEY_ETA_DISTANCE = new String[]{FLD_etaDistanceKM};
        KEY_ETA_GEOPOINT = new String[]{"etaGeoPoint"};
        KEY_STOP_ID = new String[]{"stopUniqueID", FLD_stopID};
        KEY_STOP_STATUS = new String[]{FLD_stopStatus};
        KEY_STOP_INDEX = new String[]{FLD_stopIndex};
        KEY_STOPPED_TIME = new String[]{"elapsedTimeStopped", "stoppedTimeSec"};
        devDescComparator = null;
        ARG_ACCOUNT = new String[]{"account", "a"};
        ARG_DEVICE = new String[]{"device", "d"};
        ARG_EVENTS_PER_SECOND = new String[]{"eventsPerSecond", "eps"};
        ARG_QUERY_ALL = new String[]{"queryAll"};
        ARG_ADDR_LEN = new String[]{"addressLen"};
    }

    public static class FieldComparator
    implements Comparator<EventData> {
        private boolean ascending = true;
        private String fieldName = "";

        public FieldComparator(String fldName) {
            this.fieldName = fldName != null ? fldName : "";
        }

        @Override
        public int compare(EventData o1, EventData o2) {
            Object v2;
            EventData ed1 = o1;
            EventData ed2 = o2;
            if (ed1 == ed2) {
                return 0;
            }
            if (ed1 == null) {
                return this.ascending ? -1 : 1;
            }
            if (ed2 == null) {
                return this.ascending ? 1 : -1;
            }
            Object v1 = ed1.getFieldValue(this.fieldName);
            if (v1 == (v2 = ed2.getFieldValue(this.fieldName))) {
                return 0;
            }
            if (v1 == null) {
                return this.ascending ? -1 : 1;
            }
            if (v2 == null) {
                return this.ascending ? 1 : -1;
            }
            if (v1.equals(v2)) {
                return 0;
            }
            if (v1 instanceof Number && v2 instanceof Number) {
                double d = ((Number)v2).doubleValue() - ((Number)v1).doubleValue();
                if (d > 0.0) {
                    return this.ascending ? 1 : -1;
                }
                if (d < 0.0) {
                    return this.ascending ? -1 : 1;
                }
                return 0;
            }
            String s1 = v1.toString();
            String s2 = v2.toString();
            return this.ascending ? s1.compareTo(s2) : s2.compareTo(s1);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof FieldComparator) {
                FieldComparator edc = (FieldComparator)other;
                if (this.ascending != edc.ascending) {
                    return false;
                }
                return this.fieldName.equals(edc.fieldName);
            }
            return false;
        }
    }

    public static class DeviceDescriptionComparator
    implements Comparator<EventData> {
        private boolean ascending = true;

        public DeviceDescriptionComparator() {
            this(true);
        }

        public DeviceDescriptionComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(EventData ev1, EventData ev2) {
            if (ev1 == ev2) {
                return 0;
            }
            if (ev1 == null) {
                return this.ascending ? -1 : 1;
            }
            if (ev2 == null) {
                return this.ascending ? 1 : -1;
            }
            String D1 = ev1.getDeviceDescription().toLowerCase();
            String D2 = ev2.getDeviceDescription().toLowerCase();
            return this.ascending ? D1.compareTo(D2) : D2.compareTo(D1);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof DeviceDescriptionComparator) {
                DeviceDescriptionComparator ddc = (DeviceDescriptionComparator)other;
                return this.ascending == ddc.ascending;
            }
            return false;
        }
    }

    private static class GPSDistanceAccumulator
    implements DBRecordHandler<EventData> {
        private double accumKM = 0.0;
        private GeoPoint startingGP = null;
        private EventData lastEvent = null;

        public GPSDistanceAccumulator() {
        }

        public GPSDistanceAccumulator(GeoPoint startingGP, double startingOdomKM) {
            this();
            this.startingGP = startingGP;
            this.accumKM = startingOdomKM;
        }

        public int handleDBRecord(EventData rcd) throws DBException {
            EventData ev = rcd;
            if (this.lastEvent != null) {
                GeoPoint lastGP = this.lastEvent.getGeoPoint();
                GeoPoint thisGP = ev.getGeoPoint();
                double distKM = lastGP.kilometersToPoint(thisGP);
                this.accumKM += distKM;
            } else if (this.startingGP != null) {
                GeoPoint thisGP = ev.getGeoPoint();
                double distKM = this.startingGP.kilometersToPoint(thisGP);
                this.accumKM += distKM;
            }
            this.lastEvent = ev;
            return 1;
        }

        public void clearGPSDistanceTraveled() {
            this.accumKM = 0.0;
        }

        public double getGPSDistanceTraveledKM() {
            return this.accumKM;
        }
    }

    public static enum OdometerOffsetType {
        NONE,
        DEVICE_ONLY,
        EVENT_ONLY,
        BEST;

    }

    public static class Key
    extends DeviceRecord.DeviceKey<EventData> {
        public Key() {
            this.getFieldValues().setIgnoreInvalidFields(true);
        }

        public Key(String acctId, String devId, long timestamp, int statusCode) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setKeyValue(EventData.FLD_timestamp, timestamp);
            super.setKeyValue(EventData.FLD_statusCode, statusCode);
            this.getFieldValues().setIgnoreInvalidFields(true);
        }

        public Key(String acctId, String devId, long timestamp, int statusCode, String entity) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setKeyValue(EventData.FLD_timestamp, timestamp);
            super.setKeyValue(EventData.FLD_statusCode, statusCode);
            super.setKeyValue(EventData.FLD_entityID, (Object)(entity != null ? entity.toLowerCase() : ""));
            this.getFieldValues().setIgnoreInvalidFields(true);
        }

        public DBFactory<EventData> getFactory() {
            return EventData.getFactory();
        }
    }

    public static enum GPSFixType implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        UNKNOWN(0, I18N.getString(EventData.class, (String)"EventData.gpsFix.unknown", (String)"Unknown")),
        NONE(1, I18N.getString(EventData.class, (String)"EventData.gpsFix.none", (String)"None")),
        n2D(2, I18N.getString(EventData.class, (String)"EventData.gpsFix.2D", (String)"2D")),
        n3D(3, I18N.getString(EventData.class, (String)"EventData.gpsFix.3D", (String)"3D"));

        private int vv = 0;
        private I18N.Text aa = null;

        private GPSFixType(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }
    }

    public static enum LimitType {
        FIRST,
        LAST;

    }
}

