/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.DayNumber;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Driver
extends AccountRecord<Driver> {
    public static final long DutyStatus_INVALID = -1L;
    public static final long DutyStatus_UNKNOWN = 0L;
    public static final long DutyStatus_OFF_DUTY = 1L;
    public static final long DutyStatus_SLEEPING = 2L;
    public static final long DutyStatus_DRIVING = 3L;
    public static final long DutyStatus_ON_DUTY = 4L;
    public static final String _TABLE_NAME = "Driver";
    public static final String FLD_driverID = "driverID";
    public static final String FLD_contactPhone = "contactPhone";
    public static final String FLD_contactEmail = "contactEmail";
    public static final String FLD_licenseType = "licenseType";
    public static final String FLD_licenseNumber = "licenseNumber";
    public static final String FLD_licenseExpire = "licenseExpire";
    public static final String FLD_badgeID = "badgeID";
    public static final String FLD_address = "address";
    public static final String FLD_birthdate = "birthdate";
    public static final String FLD_deviceID = "deviceID";
    public static final String FLD_driverStatus = "driverStatus";
    private static DBField[] FieldInfo = new DBField[]{Driver.newField_accountID(true), new DBField("driverID", String.class, DBField.TYPE_DRIVER_ID(), "Driver ID", "key=true"), new DBField("contactPhone", String.class, DBField.TYPE_STRING((int)32), "Contact Phone", "edit=2"), new DBField("contactEmail", String.class, DBField.TYPE_STRING((int)128), "Contact EMail", "edit=2"), new DBField("licenseType", String.class, DBField.TYPE_STRING((int)24), "License Type", "edit=2"), new DBField("licenseNumber", String.class, DBField.TYPE_STRING((int)32), "License Number", "edit=2"), new DBField("licenseExpire", Long.TYPE, "UINT32", "License Expiration Day", "edit=2 format=date"), new DBField("badgeID", String.class, DBField.TYPE_STRING((int)32), "Badge ID", "edit=2"), new DBField("address", String.class, DBField.TYPE_STRING((int)90), "Full Address", "utf8=true"), new DBField("birthdate", Long.TYPE, "UINT32", "Driver Birthdate", "edit=2 format=date"), DeviceRecord.newField_deviceID(false), new DBField("driverStatus", Long.TYPE, "UINT32", "Driver/Duty Status", "edit=2"), Driver.newField_displayName(), Driver.newField_description(), Driver.newField_notes(), Driver.newField_lastUpdateTime(), Driver.newField_lastUpdateUser((boolean)true), Driver.newField_creationTime()};
    private static DBFactory<Driver> factory = null;
    private Device device = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    private static final String[] ARG_DRIVER = new String[]{"driver", "drv", "d"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_EDITALL = new String[]{"editall", "eda"};

    public static DutyStatus getDutyStatus(long ds) {
        return (DutyStatus)EnumTools.getValueOf(DutyStatus.class, (int)((int)ds));
    }

    public static DutyStatus getDutyStatus(Driver d) {
        return d != null ? (DutyStatus)EnumTools.getValueOf(DutyStatus.class, (int)((int)d.getDriverStatus())) : (DutyStatus)EnumTools.getDefault(DutyStatus.class);
    }

    public static String getDutyStatusDescription(DutyStatus ds, Locale loc) {
        return ds != null ? ds.toString(loc) : "";
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Driver> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Driver.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Driver.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
        }
        return factory;
    }

    public Driver() {
    }

    public Driver(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Driver.class, (Locale)loc);
        return i18n.getString("Driver.description", "This table defines Account specific Vehicle Drivers.");
    }

    public String getDriverID() {
        String v = (String)this.getFieldValue(FLD_driverID);
        return StringTools.trim((String)v);
    }

    public void setDriverID(String v) {
        this.setFieldValue(FLD_driverID, StringTools.trim((String)v));
    }

    public boolean hasDriverStatus() {
        return this.getDriverStatus() > 0L;
    }

    public long getDriverStatus() {
        return this.getFieldValue(FLD_driverStatus, 0L);
    }

    public void setDriverStatus(long v) {
        long ds = v >= 0L ? v : 0L;
        this.setFieldValue(FLD_driverStatus, ds);
    }

    public static boolean updateDriverStatus(Account acct, String drvID, long status) throws DBException {
        if (acct != null && !StringTools.isBlank((String)drvID)) {
            Driver driver = Driver.getDriver(acct, drvID);
            if (driver != null) {
                long ds;
                long l = ds = status >= 0L ? status : 0L;
                if (ds != driver.getDriverStatus()) {
                    driver.setDriverStatus(status);
                    driver.update(new String[]{FLD_driverStatus});
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String getContactPhone() {
        String v = (String)this.getFieldValue(FLD_contactPhone);
        return StringTools.trim((String)v);
    }

    public void setContactPhone(String v) {
        this.setFieldValue(FLD_contactPhone, StringTools.trim((String)v));
    }

    public String getContactEmail() {
        String v = (String)this.getFieldValue(FLD_contactEmail);
        return StringTools.trim((String)v);
    }

    public void setContactEmail(String v) {
        this.setFieldValue(FLD_contactEmail, StringTools.trim((String)v));
    }

    public String getLicenseType() {
        String v = (String)this.getFieldValue(FLD_licenseType);
        return StringTools.trim((String)v);
    }

    public void setLicenseType(String v) {
        this.setFieldValue(FLD_licenseType, StringTools.trim((String)v));
    }

    public String getLicenseNumber() {
        String v = (String)this.getFieldValue(FLD_licenseNumber);
        return StringTools.trim((String)v);
    }

    public void setLicenseNumber(String v) {
        this.setFieldValue(FLD_licenseNumber, StringTools.trim((String)v));
    }

    public long getLicenseExpire() {
        return this.getFieldValue(FLD_licenseExpire, 0L);
    }

    public void setLicenseExpire(long v) {
        this.setFieldValue(FLD_licenseExpire, v >= 0L ? v : 0L);
    }

    public void setLicenseExpire(int year, int month1, int day) {
        this.setLicenseExpire(DateTime.getDayNumberFromDate((int)year, (int)month1, (int)day));
    }

    public void setLicenseExpire(DayNumber dn) {
        this.setLicenseExpire(dn != null ? dn.getDayNumber() : 0L);
    }

    public boolean isLicenseExpired(long asofDay) {
        long le = this.getLicenseExpire();
        if (le <= 0L) {
            return false;
        }
        long ae = asofDay;
        if (ae <= 0L) {
            Account acct = this.getAccount();
            TimeZone tz = acct != null ? acct.getTimeZone(null) : null;
            ae = DateTime.getDayNumberFromDate((DateTime)new DateTime(tz));
        }
        return le < ae;
    }

    public boolean isLicenseExpired(DayNumber asof) {
        return this.isLicenseExpired(asof != null ? asof.getDayNumber() : 0L);
    }

    public String getBadgeID() {
        String v = (String)this.getFieldValue(FLD_badgeID);
        return StringTools.trim((String)v);
    }

    public void setBadgeID(String v) {
        this.setFieldValue(FLD_badgeID, StringTools.trim((String)v));
    }

    public String getAddress() {
        String v = (String)this.getFieldValue(FLD_address);
        return StringTools.trim((String)v);
    }

    public void setAddress(String v) {
        this.setFieldValue(FLD_address, StringTools.trim((String)v));
    }

    public long getBirthdate() {
        return this.getFieldValue(FLD_birthdate, 0L);
    }

    public void setBirthdate(long v) {
        this.setFieldValue(FLD_birthdate, v >= 0L ? v : 0L);
    }

    public void setBirthdate(int year, int month1, int day) {
        this.setBirthdate(DateTime.getDayNumberFromDate((int)year, (int)month1, (int)day));
    }

    public void setBirthdate(DayNumber dn) {
        this.setBirthdate(dn != null ? dn.getDayNumber() : 0L);
    }

    public String getDeviceID() {
        String v = (String)this.getFieldValue(FLD_deviceID);
        return v != null ? v : "";
    }

    public void setDeviceID(String v) {
        this.setFieldValue(FLD_deviceID, v != null ? v : "");
        this.device = null;
    }

    public Device getDevice() {
        if (this.device == null) {
            Account account = this.getAccount();
            String deviceID = this.getDeviceID();
            if (account != null && !StringTools.isBlank((String)deviceID)) {
                try {
                    this.device = Device.getDevice(account, deviceID);
                }
                catch (DBException dbe) {
                    this.device = null;
                }
            }
        }
        return this.device;
    }

    public String getDeviceDescription() {
        Device device = this.getDevice();
        return device != null ? device.getDescription() : "";
    }

    public void setCreationDefaultValues() {
        super.setRuntimeDefaultValues();
    }

    public static boolean exists(String acctID, String drvID) throws DBException {
        if (acctID != null && drvID != null) {
            Key drvKey = new Key(acctID, drvID);
            return drvKey.exists();
        }
        return false;
    }

    public static Driver getDriver(Account account, String drvID) throws DBException {
        if (account != null && drvID != null) {
            String acctID = account.getAccountID();
            Key key = new Key(acctID, drvID);
            if (key.exists()) {
                Driver drv = (Driver)key.getDBRecord(true);
                drv.setAccount(account);
                return drv;
            }
            return null;
        }
        return null;
    }

    public static Driver getDriver(Account account, String drvID, boolean create) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String acctID = account.getAccountID();
        if (StringTools.isBlank((String)drvID)) {
            throw new DBNotFoundException("Driver-ID not specified for account: " + acctID);
        }
        Driver drv = null;
        Key drvKey = new Key(acctID, drvID);
        if (!drvKey.exists()) {
            if (create) {
                drv = (Driver)drvKey.getDBRecord();
                drv.setAccount(account);
                drv.setCreationDefaultValues();
                return drv;
            }
            throw new DBNotFoundException("Driver-ID does not exists: " + (Object)((Object)drvKey));
        }
        if (create) {
            throw new DBAlreadyExistsException("Driver-ID already exists '" + (Object)((Object)drvKey) + "'");
        }
        drv = Driver.getDriver(account, drvID);
        if (drv == null) {
            throw new DBException("Unable to read existing Driver-ID: " + (Object)((Object)drvKey));
        }
        return drv;
    }

    public static Driver createNewDriver(Account account, String drvID) throws DBException {
        if (account != null && !StringTools.isBlank((String)drvID)) {
            Driver drv = Driver.getDriver(account, drvID, true);
            drv.save();
            return drv;
        }
        throw new DBException("Invalid Account/DriverID specified");
    }

    public static OrderedSet<String> getDriverIDsForAccount(String acctId) throws DBException {
        return Driver.getDriverIDsForAccount(acctId, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OrderedSet<String> getDriverIDsForAccount(String acctId, long limit) throws DBException {
        Statement stmt;
        DBConnection dbc;
        OrderedSet drvList;
        block17: {
            if (StringTools.isBlank((String)acctId)) {
                Print.logError((String)"Account not specified!", (Object[])new Object[0]);
                return new OrderedSet();
            }
            drvList = new OrderedSet();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(Driver.getFactory());
                dsel.setSelectedFields(new String[]{FLD_driverID});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE(dwh.EQ("accountID", (Object)acctId)));
                dsel.setOrderByFields(new String[]{FLD_driverID});
                dsel.setLimit(limit);
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String drvId = rs.getString(FLD_driverID);
                    drvList.add((Object)drvId);
                }
                if (rs == null) break block17;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting Account Driver List", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return drvList;
    }

    public static void getRecordCallback(DBRecordHandler<Driver> rcdHandler) throws DBException {
        DBFactory<Driver> drvFact = Driver.getFactory();
        DBSelect dsel = new DBSelect(drvFact);
        DBRecord.select((DBSelect)dsel, rcdHandler);
    }

    private static String _fmtDrvID(String acctID, String drvID) {
        return acctID + "/" + drvID;
    }

    private static void usage() {
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + Driver.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>   Acount ID which owns Driver", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -driver=<id>    Driver ID to create/edit", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -create         Create a new Driver", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -edit[all]      Edit an existing (or newly created) Driver", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -delete         Delete specified Driver", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void cron(String[] args) {
        DBConfig.cmdLineInit(args, false);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String drvID = RTConfig.getString((String[])ARG_DRIVER, (String)"");
        Collection<String> acctList = null;
        try {
            acctList = Account.getAllAccounts();
        }
        catch (DBException dbe) {
            Print.logError((String)("Unable to read Accounts: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            return;
        }
        try {
            for (String accountID : acctList) {
                Account account = Account.getAccount(accountID);
                if (!account.isActive()) continue;
                DateTime nowDT = new DateTime(account.getTimeZone(DateTime.GMT));
                long today = nowDT.getDayNumber();
                long futureDay = today + 14L;
                OrderedSet<String> driverList = Driver.getDriverIDsForAccount(accountID);
                for (String driverID : driverList) {
                    Driver driver = Driver.getDriver(account, driverID);
                    if (!driver.isLicenseExpired(today) && !driver.isLicenseExpired(futureDay)) continue;
                }
            }
        }
        catch (DBException dbe) {
            Print.logError((String)("Error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            return;
        }
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String drvID = RTConfig.getString((String[])ARG_DRIVER, (String)"");
        if (StringTools.isBlank((String)acctID)) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            Driver.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(acctID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                Driver.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        BasicPrivateLabel privLabel = acct.getPrivateLabel();
        if (StringTools.isBlank((String)drvID)) {
            Print.logError((String)"Driver-ID not specified.", (Object[])new Object[0]);
            Driver.usage();
        }
        boolean driverExists = false;
        try {
            driverExists = Driver.exists(acctID, drvID);
        }
        catch (DBException dbe) {
            Print.logError((String)("Error determining if Driver exists: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !StringTools.isBlank((String)acctID) && !StringTools.isBlank((String)drvID)) {
            ++opts;
            if (!driverExists) {
                Print.logWarn((String)("Driver does not exist: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key drvKey = new Key(acctID, drvID);
                drvKey.delete(true);
                Print.logInfo((String)("Driver deleted: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
                driverExists = false;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting Driver: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (driverExists) {
                Print.logWarn((String)("Driver already exists: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
            } else {
                try {
                    Driver.createNewDriver(acct, drvID);
                    Print.logInfo((String)("Created Device: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
                    driverExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating Driver: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false) || RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false)) {
            ++opts;
            if (!driverExists) {
                Print.logError((String)("Driver does not exist: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
            } else {
                try {
                    boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                    Driver driver = Driver.getDriver(acct, drvID);
                    DBEdit editor = new DBEdit((DBRecord)driver);
                    editor.edit(allFlds);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing Driver: " + Driver._fmtDrvID(acctID, drvID)), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            Driver.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<Driver> {
        public Key() {
        }

        public Key(String accountId, String driverId) {
            super.setKeyValue("accountID", (Object)(accountId != null ? accountId.toLowerCase() : ""));
            super.setKeyValue(Driver.FLD_driverID, (Object)(driverId != null ? driverId.toLowerCase() : ""));
        }

        public DBFactory<Driver> getFactory() {
            return Driver.getFactory();
        }
    }

    public static enum DutyStatus implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        INVALID(-1, I18N.getString(Driver.class, (String)"Driver.status.invalid", (String)"Invalid")),
        UNKNOWN(0, I18N.getString(Driver.class, (String)"Driver.status.unknown", (String)"Unknown")),
        OFF_DUTY(1, I18N.getString(Driver.class, (String)"Driver.status.offDuty", (String)"Off Duty")),
        SLEEPING(2, I18N.getString(Driver.class, (String)"Driver.status.sleeping", (String)"Sleeping")),
        DRIVING(3, I18N.getString(Driver.class, (String)"Driver.status.driving", (String)"Driving")),
        ON_DUTY(4, I18N.getString(Driver.class, (String)"Driver.status.onDuty", (String)"On Duty"));

        private int vv = 0;
        private I18N.Text aa = null;

        private DutyStatus(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean isDefault() {
            return this.equals((Object)UNKNOWN);
        }

        public boolean isOffDuty() {
            return this.equals((Object)OFF_DUTY) || this.equals((Object)SLEEPING);
        }

        public boolean isOnDuty() {
            return this.equals((Object)DRIVING) || this.equals((Object)ON_DUTY);
        }

        public boolean isStatus(int status) {
            return this.getIntValue() == status;
        }
    }
}

