/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.util.Locale;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DeviceList
extends DeviceRecord<DeviceList> {
    public static final String _TABLE_NAME = "DeviceList";
    public static final String FLD_groupID = "groupID";
    private static DBField[] FieldInfo = new DBField[]{DeviceList.newField_accountID(true), new DBField("groupID", String.class, DBField.TYPE_GROUP_ID(), "Device Group ID", "key=true"), DeviceList.newField_deviceID(true), DeviceList.newField_lastUpdateTime(), DeviceList.newField_lastUpdateUser((boolean)true), DeviceList.newField_creationTime()};
    private static DBFactory<DeviceList> factory = null;
    private DeviceGroup group = null;

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<DeviceList> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)DeviceList.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, DeviceList.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(DeviceGroup.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public DeviceList() {
    }

    public DeviceList(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(DeviceList.class, (Locale)loc);
        return i18n.getString("DeviceList.description", "This table defines the membership of a given Device within a DeviceGroup. A Device may be defined in more than one DeviceGroup.");
    }

    public String getGroupID() {
        String v = (String)this.getFieldValue(FLD_groupID);
        return StringTools.trim((String)v);
    }

    private void setGroupID(String v) {
        this.setFieldValue(FLD_groupID, StringTools.trim((String)v));
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getGroupID() + "/" + this.getDeviceID();
    }

    public void setCreationDefaultValues() {
    }

    public static boolean exists(String acctID, String groupID, String devID) throws DBException {
        if (acctID != null && groupID != null && devID != null) {
            Key devListKey = new Key(acctID, groupID, devID);
            return devListKey.exists();
        }
        return false;
    }

    public DeviceGroup getGroup() {
        if (this.group == null) {
            try {
                this.group = DeviceGroup.getDeviceGroup(this.getAccount(), this.getGroupID(), false);
            }
            catch (DBException dbe) {
                this.group = null;
            }
        }
        return this.group;
    }

    public void setGroup(DeviceGroup group) {
        this.group = group != null && group.getAccountID().equals(this.getAccountID()) && group.getGroupID().equals(this.getGroupID()) ? group : null;
    }

    public static DeviceList getDeviceList(DeviceGroup group, String deviceID, boolean createOK) throws DBException {
        Key devListKey;
        if (group == null) {
            throw new DBException("DeviceGroup not specified.");
        }
        String accountID = group.getAccountID();
        String groupID = group.getGroupID();
        if (StringTools.isBlank((String)deviceID)) {
            throw new DBException("Device ID not specified.");
        }
        if (!Device.exists(accountID, deviceID)) {
            // empty if block
        }
        if ((devListKey = new Key(accountID, groupID, deviceID)).exists()) {
            DeviceList list = (DeviceList)devListKey.getDBRecord(true);
            list.setGroup(group);
            return list;
        }
        if (createOK) {
            DeviceList list = (DeviceList)devListKey.getDBRecord();
            list.setCreationDefaultValues();
            list.setGroup(group);
            return list;
        }
        return null;
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        Print.logWarn((String)"No command-line options available for this table", (Object[])new Object[0]);
    }

    public static class Key
    extends DeviceRecord.DeviceKey<DeviceList> {
        public Key() {
        }

        public Key(String accountId, String groupId, String deviceId) {
            super.setKeyValue("accountID", (Object)(accountId != null ? accountId.toLowerCase() : ""));
            super.setKeyValue(DeviceList.FLD_groupID, (Object)(groupId != null ? groupId.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(deviceId != null ? deviceId.toLowerCase() : ""));
        }

        public DBFactory<DeviceList> getFactory() {
            return DeviceList.getFactory();
        }
    }
}

