/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.DBConfig;
import org.opengts.db.GroupRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceList;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class DeviceGroup
extends GroupRecord<DeviceGroup> {
    public static final String DEVICE_GROUP_ALL = "all";
    public static final String DEVICE_GROUP_NONE = "none";
    public static final OrderedSet<String> GROUP_LIST_ALL = new OrderedSet((Object[])new String[]{"all"});
    public static final OrderedSet<String> GROUP_LIST_EMPTY = new OrderedSet();
    public static final String OPTCOLS_WorkOrderInfo = "startupInit.DeviceGroup.WorkOrderInfo";
    public static final String _TABLE_NAME = "DeviceGroup";
    public static final String FLD_groupType = "groupType";
    private static DBField[] FieldInfo = new DBField[]{DeviceGroup.newField_accountID(true), DeviceGroup.newField_groupID(true), DeviceGroup.newField_displayName(), DeviceGroup.newField_description(), DeviceGroup.newField_notes(), DeviceGroup.newField_lastUpdateTime(), DeviceGroup.newField_lastUpdateUser((boolean)true), DeviceGroup.newField_creationTime()};
    public static final String FLD_workOrderID = "workOrderID";
    public static final DBField[] WorkOrderInfo = new DBField[]{new DBField("workOrderID", String.class, DBField.TYPE_STRING((int)512), "Work Order IDs", "edit=2")};
    private static DBFactory<DeviceGroup> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_GROUP = new String[]{"group", "grp"};
    private static final String[] ARG_CREATE = new String[]{"create", "cr"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_ADD = new String[]{"add"};
    private static final String[] ARG_REMOVE = new String[]{"remove"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_CNT_OLD_EV = new String[]{"countOldEvents"};
    private static final String[] ARG_DEL_OLD_EV = new String[]{"deleteOldEvents"};
    private static final String[] ARG_CONFIRM = new String[]{"confirm"};

    public static String[] GetTitles(Locale loc) {
        I18N i18n = I18N.getI18N(DeviceGroup.class, (Locale)loc);
        return new String[]{i18n.getString("DeviceGroup.title.singular", "Group"), i18n.getString("DeviceGroup.title.plural", "Groups")};
    }

    public static String GetDeviceGroupAll(Locale loc) {
        I18N i18n = I18N.getI18N(DeviceGroup.class, (Locale)loc);
        return i18n.getString("DeviceGroup.allDescription", "All");
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<DeviceGroup> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)DeviceGroup.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, DeviceGroup.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
        }
        return factory;
    }

    public DeviceGroup() {
    }

    public DeviceGroup(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(DeviceGroup.class, (Locale)loc);
        return i18n.getString("DeviceGroup.description", "This table defines Account specific Device Groups.");
    }

    public int getGroupType() {
        Integer v = (Integer)this.getFieldValue(FLD_groupType);
        return v != null ? v : 0;
    }

    public void setGroupType(int v) {
        this.setFieldValue(FLD_groupType, v);
    }

    public String getWorkOrderID() {
        String v = (String)this.getOptionalFieldValue(FLD_workOrderID);
        return StringTools.trim((String)v);
    }

    public void setWorkOrderID(String v) {
        this.setOptionalFieldValue(FLD_workOrderID, StringTools.trim((String)v));
    }

    public void setMapLegend(String legend) {
    }

    public String getMapLegend() {
        return "";
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getGroupID();
    }

    public void setCreationDefaultValues() {
        this.setDescription("");
    }

    public boolean isDeviceInDeviceGroup(String deviceID) {
        if (deviceID != null) {
            String accountID = this.getAccountID();
            String groupID = this.getGroupID();
            return DeviceGroup.isDeviceInDeviceGroup(accountID, deviceID, groupID);
        }
        return false;
    }

    public boolean isDeviceInDeviceGroup(Device device) {
        if (device != null) {
            return this.isDeviceInDeviceGroup(device.getDeviceID());
        }
        return false;
    }

    public void addDeviceToDeviceGroup(String deviceID) throws DBException {
        if (deviceID != null) {
            String accountID = this.getAccountID();
            String groupID = this.getGroupID();
            DeviceGroup.addDeviceToDeviceGroup(accountID, groupID, deviceID);
        }
    }

    public void addDeviceToDeviceGroup(Device device) throws DBException {
        if (device != null) {
            this.addDeviceToDeviceGroup(device.getDeviceID());
        }
    }

    public void removeDeviceFromDeviceGroup(String deviceID) throws DBException {
        if (deviceID != null) {
            String accountID = this.getAccountID();
            String groupID = this.getGroupID();
            DeviceGroup.removeDeviceFromDeviceGroup(accountID, deviceID, groupID);
        }
    }

    public void removeDeviceFromDeviceGroup(Device device) throws DBException {
        if (device != null) {
            this.removeDeviceFromDeviceGroup(device.getDeviceID());
        }
    }

    public long countOldEvents(long oldTimeSec, boolean log) throws DBException {
        Account account = this.getAccount();
        String groupID = this.getGroupID();
        return DeviceGroup.countOldEvents(account, groupID, oldTimeSec, log);
    }

    public static long countOldEvents(Account account, String groupID, long oldTimeSec, boolean log) throws DBException {
        if (account == null) {
            if (log) {
                Print.sysPrintln((String)"  Account is null", (Object[])new Object[0]);
            }
            return 0L;
        }
        String acctID = account.getAccountID();
        if (log) {
            StringBuffer sb = new StringBuffer();
            sb.append("Counting old events for group ").append(acctID + "/" + groupID);
            sb.append(" prior to ").append(new DateTime(oldTimeSec).toString());
            Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
        }
        OrderedSet<String> devList = null;
        devList = DeviceGroup.getDeviceIDsForGroup(acctID, groupID, null, true, -1L);
        int devCount = ListTools.size(devList);
        if (devCount <= 0) {
            if (log) {
                Print.sysPrintln((String)("  No Devices Found: " + acctID + "/" + groupID), (Object[])new Object[0]);
            }
            return 0L;
        }
        long totalCount = 0L;
        for (String devID : devList) {
            long startMS = DateTime.getCurrentTimeMillis();
            long count = EventData.getRecordCount(acctID, devID, -1L, oldTimeSec);
            long endMS = DateTime.getCurrentTimeMillis();
            long deltaMS = endMS - startMS;
            totalCount += count;
            --devCount;
            if (log && count > 0L) {
                StringBuffer sb = new StringBuffer();
                sb.append("  Device: ").append(StringTools.leftAlign((String)(acctID + "/" + devID), (int)25));
                sb.append(" - counted ").append(StringTools.rightAlign((String)String.valueOf(count), (int)5));
                sb.append(" [").append(deltaMS).append("]");
                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
            }
            if (devCount <= 0) continue;
            long sleepMS = 500L;
            try {
                Thread.sleep(sleepMS);
            }
            catch (Throwable th) {}
        }
        if (log) {
            if (totalCount > 0L) {
                StringBuffer sb = new StringBuffer();
                sb.append("  Total : ").append(StringTools.leftAlign((String)(acctID + "/" + groupID), (int)25));
                sb.append(" - counted ").append(StringTools.rightAlign((String)String.valueOf(totalCount), (int)5));
                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
            } else {
                Print.sysPrintln((String)("  No Devices with counts greater than zero: " + acctID + "/" + groupID), (Object[])new Object[0]);
            }
        }
        return totalCount;
    }

    public long deleteOldEvents(long oldTimeSec, boolean log) throws DBException {
        Account account = this.getAccount();
        String groupID = this.getGroupID();
        return DeviceGroup.deleteOldEvents(account, groupID, oldTimeSec, log);
    }

    public static long deleteOldEvents(Account account, String groupID, long oldTimeSec, boolean log) throws DBException {
        if (account == null) {
            if (log) {
                Print.sysPrintln((String)"  Account is null", (Object[])new Object[0]);
            }
            return 0L;
        }
        String acctID = account.getAccountID();
        boolean usingRetainedDate = false;
        long delOldTimeSec = account.adjustRetainedEventTime(oldTimeSec);
        if (delOldTimeSec != oldTimeSec) {
            oldTimeSec = delOldTimeSec;
            usingRetainedDate = true;
        }
        if (oldTimeSec < 1L) {
            oldTimeSec = 1L;
        }
        if (log) {
            StringBuffer sb = new StringBuffer();
            sb.append("Deleting old events for group ").append(acctID + "/" + groupID);
            sb.append(" prior to ").append(new DateTime(oldTimeSec).toString());
            if (usingRetainedDate) {
                sb.append(" (retained-date)");
            }
            Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
        }
        OrderedSet<String> devList = null;
        devList = DeviceGroup.getDeviceIDsForGroup(acctID, groupID, null, true, -1L);
        int devCount = ListTools.size(devList);
        if (devCount <= 0) {
            if (log) {
                Print.sysPrintln((String)("  No Devices Found: " + acctID + "/" + groupID), (Object[])new Object[0]);
            }
            return 0L;
        }
        StringBuffer msg = new StringBuffer();
        long totalCount = 0L;
        for (String devID : devList) {
            msg.setLength(0);
            Device device = null;
            try {
                device = Device.getDevice(account, devID);
            }
            catch (DBException dbe) {
                Print.logException((String)("Unable to read device: " + acctID + "/" + devID), (Throwable)dbe);
                return totalCount;
            }
            long startMS = DateTime.getCurrentTimeMillis();
            long count = EventData.deleteOldEvents(device, oldTimeSec, msg);
            long endMS = DateTime.getCurrentTimeMillis();
            long deltaMS = endMS - startMS;
            totalCount += count;
            --devCount;
            if (log) {
                StringBuffer sb = new StringBuffer();
                sb.append("  Device: ").append(StringTools.leftAlign((String)(acctID + "/" + devID), (int)25));
                sb.append(" - deleted ").append(StringTools.rightAlign((String)String.valueOf(count), (int)5));
                sb.append(" [").append(deltaMS).append("ms]");
                if (msg.length() > 0) {
                    sb.append("  ").append(msg);
                }
                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
            }
            if (devCount <= 0) continue;
            long sleepMS = 4500L * deltaMS / 30000L + 500L;
            if (sleepMS > 5000L) {
                sleepMS = 5000L;
            }
            try {
                Thread.sleep(sleepMS);
            }
            catch (Throwable th) {}
        }
        if (log) {
            StringBuffer sb = new StringBuffer();
            sb.append("  Total : ").append(StringTools.leftAlign((String)(acctID + "/" + groupID), (int)25));
            sb.append(" - deleted ").append(StringTools.rightAlign((String)String.valueOf(totalCount), (int)5));
            Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
        }
        return totalCount;
    }

    public static boolean exists(String acctID, String groupID) throws DBException {
        if (StringTools.isBlank((String)acctID)) {
            return false;
        }
        if (StringTools.isBlank((String)groupID)) {
            return false;
        }
        if (groupID.equalsIgnoreCase(DEVICE_GROUP_ALL)) {
            return true;
        }
        Key groupKey = new Key(acctID, groupID);
        return groupKey.exists();
    }

    public static boolean exists(String acctID, String groupID, String deviceID) throws DBException {
        if (acctID != null && groupID != null && deviceID != null) {
            DeviceList.Key deviceListKey = new DeviceList.Key(acctID, groupID, deviceID);
            return deviceListKey.exists();
        }
        return false;
    }

    public static boolean isDeviceInDeviceGroup(String acctID, String groupID, String deviceID) {
        if (acctID == null || groupID == null || deviceID == null) {
            return false;
        }
        if (groupID.equalsIgnoreCase(DEVICE_GROUP_ALL)) {
            return true;
        }
        try {
            return DeviceGroup.exists(acctID, groupID, deviceID);
        }
        catch (DBException dbe) {
            return false;
        }
    }

    public static void addDeviceToDeviceGroup(String accountID, String groupID, String deviceID) throws DBException {
        if (!Device.exists(accountID, deviceID)) {
            throw new DBException("Device does not exist: " + accountID + "/" + deviceID);
        }
        if (!DeviceGroup.exists(accountID, groupID)) {
            throw new DBException("DeviceGroup does not exist: " + accountID + "/" + groupID);
        }
        DeviceList.Key devListKey = new DeviceList.Key(accountID, groupID, deviceID);
        if (!devListKey.exists()) {
            DeviceList devListEntry = (DeviceList)devListKey.getDBRecord();
            devListEntry.save();
        }
    }

    public static void removeDeviceFromDeviceGroup(String accountID, String groupID, String deviceID) throws DBException {
        if (!Device.exists(accountID, deviceID)) {
            throw new DBException("Device does not exist: " + accountID + "/" + deviceID);
        }
        DeviceList.Key devListKey = new DeviceList.Key(accountID, groupID, deviceID);
        devListKey.delete(false);
    }

    public static DeviceGroup getDeviceGroup(Account account, String groupId) throws DBException {
        if (groupId == null) {
            return null;
        }
        return DeviceGroup.getDeviceGroup(account, groupId, false);
    }

    public static DeviceGroup getDeviceGroup(Account account, String groupId, boolean createOK) throws DBException {
        if (account == null) {
            throw new DBException("Account not specified.");
        }
        if (StringTools.isBlank((String)groupId)) {
            throw new DBException("Device Group-ID not specified.");
        }
        Key groupKey = new Key(account.getAccountID(), groupId);
        if (groupKey.exists()) {
            DeviceGroup group = (DeviceGroup)groupKey.getDBRecord(true);
            group.setAccount(account);
            return group;
        }
        if (createOK) {
            DeviceGroup group = (DeviceGroup)groupKey.getDBRecord();
            group.setAccount(account);
            group.setCreationDefaultValues();
            return group;
        }
        return null;
    }

    public static DeviceGroup createNewDeviceGroup(Account account, String groupID) throws DBException {
        if (account != null && groupID != null && !groupID.equals("")) {
            DeviceGroup group = DeviceGroup.getDeviceGroup(account, groupID, true);
            group.save();
            return group;
        }
        throw new DBException("Invalid Account/GroupID specified");
    }

    protected static DBSelect _getDeviceListSelect(String acctId, String groupId, long limit) {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)groupId)) {
            return null;
        }
        DBSelect dsel = new DBSelect(DeviceList.getFactory());
        dsel.setSelectedFields(new String[]{"deviceID"});
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("groupID", (Object)groupId))));
        dsel.setOrderByFields(new String[]{"deviceID"});
        dsel.setLimit(limit);
        return dsel;
    }

    public long getDeviceCount() {
        String groupId;
        String acctId = this.getAccountID();
        DBSelect dsel = DeviceGroup._getDeviceListSelect(acctId, groupId = this.getGroupID(), -1L);
        if (dsel == null) {
            return 0L;
        }
        try {
            return DBRecord.getRecordCount(DeviceList.getFactory(), (String)dsel.getWhere());
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to retrieve DeviceList count", (Throwable)dbe);
            return 0L;
        }
    }

    public OrderedSet<String> getDevices(User userAuth, boolean inclInactv) throws DBException {
        String acctId = this.getAccountID();
        String groupId = this.getGroupID();
        return DeviceGroup.getDeviceIDsForGroup(acctId, groupId, userAuth, inclInactv, -1L);
    }

    public static OrderedSet<String> getDeviceIDsForGroup(String acctId, String groupId, User userAuth, boolean inclInactv) throws DBException {
        return DeviceGroup.getDeviceIDsForGroup(acctId, groupId, userAuth, inclInactv, -1L);
    }

    public static OrderedSet<String> getDeviceIDsForGroup(String acctId, String groupId, User userAuth, boolean inclInactv, long limit) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return new OrderedSet();
        }
        if (StringTools.isBlank((String)groupId)) {
            return new OrderedSet();
        }
        if (groupId.equalsIgnoreCase(DEVICE_GROUP_ALL)) {
            return Device.getDeviceIDsForAccount(acctId, userAuth, inclInactv);
        }
        DBSelect dsel = DeviceGroup._getDeviceListSelect(acctId, groupId, limit);
        if (dsel == null) {
            return new OrderedSet();
        }
        Account account = null;
        if (!inclInactv) {
            Account account2 = account = userAuth != null ? userAuth.getAccount() : Account.getAccount(acctId);
            if (account == null) {
                Print.logWarn((String)("Account not found? " + acctId), (Object[])new Object[0]);
                return new OrderedSet();
            }
        }
        OrderedSet devList = new OrderedSet();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                Device device;
                String devId = rs.getString("deviceID");
                if (!inclInactv && ((device = account != null ? Device.getDevice(account, devId) : null) == null || !device.isActive()) || userAuth != null && !userAuth.isAuthorizedDevice(devId)) continue;
                devList.add((Object)devId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Get Group DeviceList", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return devList;
    }

    public static OrderedSet<String> getDeviceGroupsForAccount(String acctId, boolean includeAll) throws DBException {
        DBSelect dsel = new DBSelect(DeviceGroup.getFactory());
        dsel.setSelectedFields(new String[]{"groupID"});
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE(dwh.EQ("accountID", (Object)acctId)));
        dsel.setOrderByFields(new String[]{"groupID"});
        return DeviceGroup.getDeviceGroups((DBSelect<DeviceGroup>)dsel, includeAll);
    }

    public static OrderedSet<String> getDeviceGroups(DBSelect<DeviceGroup> dsel, boolean includeAll) throws DBException {
        OrderedSet groupList = new OrderedSet(true);
        if (includeAll) {
            groupList.add((Object)DEVICE_GROUP_ALL);
        }
        if (dsel == null) {
            return groupList;
        }
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String groupId = rs.getString("groupID");
                groupList.add((Object)groupId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting Account DeviceGroup List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return groupList;
    }

    public static Collection<String> getDeviceGroupsForDevice(String acctId, String deviceId) throws DBException {
        return DeviceGroup.getDeviceGroupsForDevice(acctId, deviceId, true);
    }

    public static Collection<String> getDeviceGroupsForDevice(String acctId, String deviceId, boolean inclAll) throws DBException {
        try {
            if (acctId == null || deviceId == null || !Device.exists(acctId, deviceId)) {
                return null;
            }
        }
        catch (DBException dbe) {
            return null;
        }
        Vector<String> groupList = new Vector<String>();
        if (inclAll) {
            groupList.add(DEVICE_GROUP_ALL);
        }
        DBSelect dsel = new DBSelect(DeviceList.getFactory());
        dsel.setSelectedFields(new String[]{"groupID"});
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("deviceID", (Object)deviceId))));
        dsel.setOrderByFields(new String[]{"groupID"});
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String devId = rs.getString("groupID");
                groupList.add(devId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Get Group DeviceList", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return groupList;
    }

    private static void usage() {
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + DeviceGroup.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>               Acount ID which owns DeviceGroup", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -group=<id>                 Group ID to create/edit", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -create                     Create a new DeviceGroup", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -edit                       Edit an existing (or newly created) DeviceGroup", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -delete                     Delete specified DeviceGroup", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -add=<deviceID>             Add deviceID to group", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -remove=<deviceID>          Remove deviceID from group", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -list                       List Devices in this Group", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -countOldEvents=<time>      Count events before specified time (requires '-confirm')", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -deleteOldEvents=<time>     Delete events ibefore specified time (requires '-confirm')", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -confirm                    Confirms countOldEvents/deleteOldEvents", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        String deviceID;
        DBConfig.cmdLineInit(argv, true);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String groupID = RTConfig.getString((String[])ARG_GROUP, (String)"");
        boolean list = RTConfig.getBoolean((String[])ARG_LIST, (boolean)false);
        int opts = 0;
        if (accountID == null || accountID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            DeviceGroup.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(accountID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                DeviceGroup.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
            System.exit(99);
        }
        boolean hasGroupID = groupID != null && !groupID.equals("");
        boolean groupExists = false;
        if (hasGroupID) {
            try {
                groupExists = DeviceGroup.exists(accountID, groupID);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error determining if DeviceGroup exists: " + accountID + "," + groupID), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false)) {
            ++opts;
            if (!hasGroupID) {
                Print.logError((String)"Group-ID not specified.", (Object[])new Object[0]);
                DeviceGroup.usage();
            } else if (!groupExists) {
                Print.logWarn((String)("DeviceGroup does not exist: " + accountID + "/" + groupID), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key groupKey = new Key(accountID, groupID);
                groupKey.delete(true);
                Print.logInfo((String)("DeviceGroup deleted: " + accountID + "/" + groupID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting DeviceGroup: " + accountID + "/" + groupID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (!hasGroupID) {
                Print.logError((String)"Group-ID not specified.", (Object[])new Object[0]);
                DeviceGroup.usage();
            } else if (groupExists) {
                Print.logWarn((String)("DeviceGroup already exists: " + accountID + "/" + groupID), (Object[])new Object[0]);
            } else {
                try {
                    DeviceGroup.createNewDeviceGroup(acct, groupID);
                    Print.logInfo((String)("Created DeviceGroup: " + accountID + "/" + groupID), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating DeviceGroup: " + accountID + "/" + groupID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false)) {
            ++opts;
            if (!hasGroupID) {
                Print.logError((String)"Group-ID not specified.", (Object[])new Object[0]);
                DeviceGroup.usage();
            } else if (!groupExists) {
                Print.logError((String)("DeviceGroup does not exist: " + accountID + "/" + groupID), (Object[])new Object[0]);
            } else {
                try {
                    DeviceGroup group = DeviceGroup.getDeviceGroup(acct, groupID, false);
                    DBEdit editor = new DBEdit((DBRecord)group);
                    editor.edit();
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing DeviceGroup: " + accountID + "/" + groupID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_ADD)) {
            ++opts;
            deviceID = RTConfig.getString((String[])ARG_ADD, (String)"");
            if (!hasGroupID) {
                Print.logError((String)"Group-ID not specified.", (Object[])new Object[0]);
                DeviceGroup.usage();
            } else if (!groupExists) {
                Print.logError((String)("DeviceGroup does not exist: " + accountID + "/" + groupID), (Object[])new Object[0]);
            } else {
                try {
                    DeviceGroup.addDeviceToDeviceGroup(accountID, groupID, deviceID);
                    Print.logInfo((String)("DeviceList entry added: " + accountID + "/" + groupID + "/" + deviceID), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating DeviceList entry: " + accountID + "/" + groupID + "/" + deviceID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_REMOVE)) {
            ++opts;
            if (!hasGroupID) {
                Print.logError((String)"Group-ID not specified.", (Object[])new Object[0]);
                DeviceGroup.usage();
            } else if (!groupExists) {
                Print.logError((String)("DeviceGroup does not exist: " + accountID + "/" + groupID), (Object[])new Object[0]);
            } else {
                deviceID = RTConfig.getString((String[])ARG_REMOVE, (String)"");
                try {
                    DeviceGroup.removeDeviceFromDeviceGroup(accountID, groupID, deviceID);
                    Print.logInfo((String)("DeviceList entry deleted: " + accountID + "/" + groupID + "/" + deviceID), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating DeviceList entry: " + accountID + "/" + groupID + "/" + deviceID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            ++opts;
            if (hasGroupID) {
                if (!groupExists) {
                    Print.logError((String)("DeviceGroup does not exist: " + accountID + "/" + groupID), (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)"", (Object[])new Object[0]);
                    Print.sysPrintln((String)("DeviceGroup: " + accountID + "/" + groupID), (Object[])new Object[0]);
                    try {
                        OrderedSet<String> devList = DeviceGroup.getDeviceIDsForGroup(accountID, groupID, null, true, -1L);
                        if (devList.size() <= 0) {
                            Print.sysPrintln((String)"  No Devices", (Object[])new Object[0]);
                        }
                        for (int d = 0; d < devList.size(); ++d) {
                            Print.sysPrintln((String)("  Device: " + (String)devList.get(d)), (Object[])new Object[0]);
                        }
                    }
                    catch (DBException dbe) {
                        Print.logError((String)("Error listing Devices: " + accountID + "/" + groupID), (Object[])new Object[0]);
                        dbe.printException();
                        System.exit(99);
                    }
                }
            } else {
                try {
                    Print.sysPrintln((String)"", (Object[])new Object[0]);
                    Print.logInfo((String)("Account: " + accountID), (Object[])new Object[0]);
                    OrderedSet<String> groupList = DeviceGroup.getDeviceGroupsForAccount(accountID, true);
                    if (groupList.size() == 0) {
                        Print.sysPrintln((String)"  No DeviceGroups", (Object[])new Object[0]);
                    } else {
                        for (String gid : groupList) {
                            Print.sysPrintln((String)("  DeviceGroup: " + gid), (Object[])new Object[0]);
                        }
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error listing DeviceGroups: " + accountID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.hasProperty((String[])ARG_CNT_OLD_EV) || RTConfig.hasProperty((String[])ARG_DEL_OLD_EV)) {
            String argTime;
            ++opts;
            boolean deleteEvents = RTConfig.hasProperty((String[])ARG_DEL_OLD_EV);
            String actionText = deleteEvents ? "Deleting" : "Counting";
            TimeZone acctTMZ = acct.getTimeZone(null);
            String string = argTime = deleteEvents ? RTConfig.getString((String[])ARG_DEL_OLD_EV, (String)"") : RTConfig.getString((String[])ARG_CNT_OLD_EV, (String)"");
            if (!hasGroupID) {
                Print.logError((String)"DeviceGroup ID not specified", (Object[])new Object[0]);
                System.exit(99);
            } else if (!groupExists) {
                Print.logError((String)("DeviceGroup does not exist: " + accountID + "/" + groupID), (Object[])new Object[0]);
                System.exit(99);
            }
            DateTime oldTime = null;
            if (StringTools.isBlank((String)argTime)) {
                Print.logError((String)("Invalid time specification: " + argTime), (Object[])new Object[0]);
                System.exit(98);
            } else if (argTime.equalsIgnoreCase("current")) {
                oldTime = new DateTime(acctTMZ);
            } else {
                try {
                    oldTime = DateTime.parseArgumentDate((String)argTime, (TimeZone)acctTMZ, (boolean)true);
                }
                catch (DateTime.DateParseException dpe) {
                    oldTime = null;
                }
                if (oldTime == null) {
                    Print.sysPrintln((String)("Invalid Time specification: " + argTime), (Object[])new Object[0]);
                    System.exit(98);
                } else if (oldTime.getTimeSec() > DateTime.getCurrentTimeSec()) {
                    Print.sysPrintln((String)(actionText + " future events not allowed"), (Object[])new Object[0]);
                    System.exit(98);
                }
            }
            long oldTimeSec = oldTime.getTimeSec();
            boolean confirm = RTConfig.getBoolean((String[])ARG_CONFIRM, (boolean)false);
            try {
                if (deleteEvents) {
                    Print.sysPrintln((String)("Deleting events prior to: " + new DateTime(oldTimeSec)), (Object[])new Object[0]);
                    if (!confirm) {
                        Print.sysPrintln((String)"ERROR: Missing '-confirm', aborting delete ...", (Object[])new Object[0]);
                        System.exit(1);
                    }
                    DeviceGroup.deleteOldEvents(acct, groupID, oldTimeSec, true);
                } else {
                    Print.sysPrintln((String)("Counting events prior to: " + new DateTime(oldTimeSec)), (Object[])new Object[0]);
                    if (!confirm) {
                        Print.sysPrintln((String)"ERROR: Missing '-confirm', aborting count ...", (Object[])new Object[0]);
                        System.exit(1);
                    }
                    DeviceGroup.countOldEvents(acct, groupID, oldTimeSec, true);
                }
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error " + actionText + " old events: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            DeviceGroup.usage();
        }
    }

    public static class Key
    extends GroupRecord.GroupKey<DeviceGroup> {
        public Key() {
        }

        public Key(String accountId, String groupId) {
            super.setKeyValue("accountID", (Object)(accountId != null ? accountId.toLowerCase() : ""));
            super.setKeyValue("groupID", (Object)(groupId != null ? groupId.toLowerCase() : ""));
        }

        public DBFactory<DeviceGroup> getFactory() {
            return DeviceGroup.getFactory();
        }
    }
}

