/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.cellid.CellTower;
import org.opengts.cellid.MobileLocation;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DataTransport;
import org.opengts.db.DeviceRecord;
import org.opengts.db.EntityManager;
import org.opengts.db.EventUtil;
import org.opengts.db.FuelManager;
import org.opengts.db.PingDispatcher;
import org.opengts.db.RuleFactory;
import org.opengts.db.RuleFactoryAdapter;
import org.opengts.db.SMSOutboundGateway;
import org.opengts.db.SessionStatsFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.WorkHours;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.StatusCode;
import org.opengts.db.tables.Transport;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.dbtypes.DTIPAddress;
import org.opengts.dbtypes.DTOBDFault;
import org.opengts.dbtypes.DTProfileMask;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.SlowOperationException;
import org.opengts.util.AccumulatorLong;
import org.opengts.util.ColorTools;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadPool;

public class Device
extends DeviceRecord<Device>
implements DataTransport {
    private static int LogEventDataInsertion = -1;
    public static boolean CACHE_STATUS_CODE_DESCRIPTIONS = true;
    public static boolean INSERT_REVERSEGEOCODE_REQUIRED = false;
    public static boolean ALLOW_USE_EMAIL_WRAPPER = false;
    public static boolean AUTO_GENERATE_NON_MOVING_EVENT = false;
    public static long MAX_STOPPED_DELTA_SEC = DateTime.MinuteSeconds((long)20L);
    public static final Device[] EMPTY_ARRAY = new Device[0];
    public static int LastFaultCodeColumnLength = -1;
    public static final String OPTCOLS_NotificationFieldInfo = "startupInit.Device.NotificationFieldInfo";
    public static final String OPTCOLS_BorderCrossingFieldInfo = "startupInit.Device.BorderCrossingFieldInfo";
    public static final String OPTCOLS_LinkFieldInfo = "startupInit.Device.LinkFieldInfo";
    public static final String OPTCOLS_FixedLocationFieldInfo = "startupInit.Device.FixedLocationFieldInfo";
    public static final String OPTCOLS_GeoCorridorFieldInfo = "startupInit.Device.GeoCorridorFieldInfo";
    public static final String OPTCOLS_MaintOdometerFieldInfo = "startupInit.Device.MaintOdometerFieldInfo";
    public static final String OPTCOLS_WorkOrderInfo = "startupInit.Device.WorkOrderInfo";
    public static final String OPTCOLS_DataPushInfo = "startupInit.Device.DataPushInfo";
    private static final RTKey PROP_ThreadPool_DeviceEventUpdate_ = RTKey.valueOf((String)"Device.ThreadPool.DeviceEventUpdate.");
    private static final int ThreadPool_DeviceEventUpdate_Size = 50;
    private static final int ThreadPool_DeviceEventUpdate_IdleSec = 0;
    private static final int ThreadPool_DeviceEventUpdate_QueSize = 0;
    private static ThreadPool ThreadPool_DeviceEventUpdate = new ThreadPool("DeviceEventUpdate", PROP_ThreadPool_DeviceEventUpdate_, 50, 0, 0);
    private static final String NEW_DEVICE_NAME_ = "Nuevo dispositivo";
    private static final int EXT_UPDATE_MASK = 65535;
    private static final int EXT_UPDATE_NONE = 0;
    private static final int EXT_UPDATE_CELLGPS = 1;
    private static final int EXT_UPDATE_ADDRESS = 2;
    private static final int EXT_UPDATE_BORDER = 4;
    private static final int EXT_UPDATE_JMS = 8;
    private static boolean EPS_did_init = false;
    public static long EPS_RANGE_SECONDS = 3600L;
    public static long EPS_RANGE_MS = EPS_RANGE_SECONDS * 1000L;
    public static double EPS_WEIGHT = 0.9;
    public static double EPS_ALPHA = 1.0 - Math.exp(Math.log(1.0 - EPS_WEIGHT) / (double)EPS_RANGE_MS);
    public static final boolean CHECK_LAST_ODOMETER = false;
    public static boolean SIMULATE_ENGINE_HOURS = false;
    public static boolean UPDATE_EVENT_WITH_GEOZONE_LOC = false;
    public static final double MAX_DEVICE_ODOM_KM = 1609344.0;
    private static final double MAX_DEVICE_RUNTIME_HOURS = (double)DateTime.DaySeconds((long)10950L) / 3600.0;
    private static final boolean CHECK_NOTIFY_SELECTOR = true;
    public static final boolean SAVE_EVENT_DRIVER_ID = true;
    private static boolean cellTower_initDefault = false;
    private static MobileLocationProvider cellTower_GetLocation = null;
    private static RuleFactory ruleFactory = null;
    private static SessionStatsFactory statsFactory = null;
    private static EntityManager entityManager = null;
    private static FuelManager fuelManager = null;
    private static PingDispatcher pingDispatcher = null;
    public static final int PAST_DATE_UNDEFINED = -999;
    public static final int PAST_DATE_IGNORE = -1;
    public static final int PAST_DATE_DISABLED = 0;
    public static final int PAST_DATE_TRUNCATE = 1;
    private static int PastEventDateAction = -999;
    private static long PastEventDateMaxSec = -999L;
    public static final int FUTURE_DATE_UNDEFINED = -999;
    public static final int FUTURE_DATE_IGNORE = -1;
    public static final int FUTURE_DATE_DISABLED = 0;
    public static final int FUTURE_DATE_TRUNCATE = 1;
    private static int FutureEventDateAction = -999;
    private static long FutureEventDateMaxSec = -999L;
    public static final int INVALID_SPEED_UNDEFINED = -999;
    public static final int INVALID_SPEED_IGNORE = -1;
    public static final int INVALID_SPEED_DISABLED = 0;
    public static final int INVALID_SPEED_TRUNCATE = 1;
    public static final int INVALID_SPEED_ZERO = 2;
    private static int InvalidSpeedAction = -999;
    private static double InvalidSpeedMaxKPH = -999.0;
    public static final String _TABLE_NAME = "Device";
    public static final String FLD_groupID = "groupID";
    public static final String FLD_equipmentType = "equipmentType";
    public static final String FLD_equipmentStatus = "equipmentStatus";
    public static final String FLD_vehicleMake = "vehicleMake";
    public static final String FLD_vehicleModel = "vehicleModel";
    public static final String FLD_vehicleID = "vehicleID";
    public static final String FLD_licensePlate = "licensePlate";
    public static final String FLD_driverID = "driverID";
    public static final String FLD_driverStatus = "driverStatus";
    public static final String FLD_fuelCapacity = "fuelCapacity";
    public static final String FLD_fuelEconomy = "fuelEconomy";
    public static final String FLD_speedLimitKPH = "speedLimitKPH";
    public static final String FLD_planDistanceKM = "planDistanceKM";
    public static final String FLD_installTime = "installTime";
    public static final String FLD_resetTime = "resetTime";
    public static final String FLD_expirationTime = "expirationTime";
    public static final String FLD_uniqueID = "uniqueID";
    public static final String FLD_deviceCode = "deviceCode";
    public static final String FLD_deviceType = "deviceType";
    public static final String FLD_pushpinID = "pushpinID";
    public static final String FLD_displayColor = "displayColor";
    public static final String FLD_serialNumber = "serialNumber";
    public static final String FLD_simPhoneNumber = "simPhoneNumber";
    public static final String FLD_simID = "simID";
    public static final String FLD_smsEmail = "smsEmail";
    public static final String FLD_imeiNumber = "imeiNumber";
    public static final String FLD_dataKey = "dataKey";
    public static final String FLD_ignitionIndex = "ignitionIndex";
    public static final String FLD_codeVersion = "codeVersion";
    public static final String FLD_featureSet = "featureSet";
    public static final String FLD_ipAddressValid = "ipAddressValid";
    public static final String FLD_lastTcpSessionID = "lastTcpSessionID";
    public static final String FLD_ipAddressCurrent = "ipAddressCurrent";
    public static final String FLD_remotePortCurrent = "remotePortCurrent";
    public static final String FLD_listenPortCurrent = "listenPortCurrent";
    public static final String FLD_pingCommandURI = "pingCommandURI";
    public static final String FLD_pendingPingCommand = "pendingPingCommand";
    public static final String FLD_lastPingTime = "lastPingTime";
    public static final String FLD_totalPingCount = "totalPingCount";
    public static final String FLD_maxPingCount = "maxPingCount";
    public static final String FLD_commandStateMask = "commandStateMask";
    public static final String FLD_expectAck = "expectAck";
    public static final String FLD_expectAckCode = "expectAckCode";
    public static final String FLD_lastAckCommand = "lastAckCommand";
    public static final String FLD_lastAckResponse = "lastAckResponse";
    public static final String FLD_lastAckTime = "lastAckTime";
    public static final String FLD_dcsPropertiesID = "dcsPropertiesID";
    public static final String FLD_dcsCommandHost = "dcsCommandHost";
    public static final String FLD_dcsConfigMask = "dcsConfigMask";
    public static final String FLD_dcsConfigString = "dcsConfigString";
    public static final String FLD_supportsDMTP = "supportsDMTP";
    public static final String FLD_supportedEncodings = "supportedEncodings";
    public static final String FLD_unitLimitInterval = "unitLimitInterval";
    public static final String FLD_maxAllowedEvents = "maxAllowedEvents";
    public static final String FLD_totalProfileMask = "totalProfileMask";
    public static final String FLD_totalMaxConn = "totalMaxConn";
    public static final String FLD_totalMaxConnPerMin = "totalMaxConnPerMin";
    public static final String FLD_duplexProfileMask = "duplexProfileMask";
    public static final String FLD_duplexMaxConn = "duplexMaxConn";
    public static final String FLD_duplexMaxConnPerMin = "duplexMaxConnPerMin";
    public static final String FLD_lastTotalConnectTime = "lastTotalConnectTime";
    public static final String FLD_lastDuplexConnectTime = "lastDuplexConnectTime";
    public static final String FLD_lastInputState = "lastInputState";
    public static final String FLD_lastOutputState = "lastOutputState";
    public static final String FLD_statusCodeState = "statusCodeState";
    public static final String FLD_lastBatteryLevel = "lastBatteryLevel";
    public static final String FLD_lastFuelLevel = "lastFuelLevel";
    public static final String FLD_lastFuelTotal = "lastFuelTotal";
    public static final String FLD_lastOilLevel = "lastOilLevel";
    public static final String FLD_lastValidLatitude = "lastValidLatitude";
    public static final String FLD_lastValidLongitude = "lastValidLongitude";
    public static final String FLD_lastValidHeading = "lastValidHeading";
    public static final String FLD_lastValidSpeed = "lastValidSpeed";
    public static final String FLD_lastGPSTimestamp = "lastGPSTimestamp";
    public static final String FLD_lastEventTimestamp = "lastEventTimestamp";
    public static final String FLD_lastCellServingInfo = "lastCellServingInfo";
    public static final String FLD_lastDistanceKM = "lastDistanceKM";
    public static final String FLD_lastOdometerKM = "lastOdometerKM";
    public static final String FLD_odometerOffsetKM = "odometerOffsetKM";
    public static final String FLD_lastEngineOnTime = "lastEngineOnTime";
    public static final String FLD_lastEngineOffTime = "lastEngineOffTime";
    public static final String FLD_lastEngineHours = "lastEngineHours";
    public static final String FLD_engineHoursOffset = "engineHoursOffset";
    public static final String FLD_lastIgnitionOnTime = "lastIgnitionOnTime";
    public static final String FLD_lastIgnitionOffTime = "lastIgnitionOffTime";
    public static final String FLD_lastIgnitionHours = "lastIgnitionHours";
    public static final String FLD_lastStopTime = "lastStopTime";
    public static final String FLD_lastStartTime = "lastStartTime";
    public static final String FLD_lastMalfunctionLamp = "lastMalfunctionLamp";
    public static final String FLD_lastFaultCode = "lastFaultCode";
    private static DBField[] FieldInfo = new DBField[]{Device.newField_accountID(true), Device.newField_deviceID(true), new DBField("groupID", String.class, DBField.TYPE_GROUP_ID(), I18N.getString(Device.class, (String)"Device.fld.groupID", (String)"Group ID"), "edit=2"), new DBField("equipmentType", String.class, DBField.TYPE_STRING((int)40), I18N.getString(Device.class, (String)"Device.fld.equipmentType", (String)"Equipment Type"), "edit=2"), new DBField("equipmentStatus", Integer.TYPE, "INT32", I18N.getString(Device.class, (String)"Device.fld.equipmentStatus", (String)"Equipment Status"), "edit=2"), new DBField("vehicleMake", String.class, DBField.TYPE_STRING((int)40), I18N.getString(Device.class, (String)"Device.fld.vehicleMake", (String)"Vehicle Make"), "edit=2"), new DBField("vehicleModel", String.class, DBField.TYPE_STRING((int)40), I18N.getString(Device.class, (String)"Device.fld.vehicleModel", (String)"Vehicle Model"), "edit=2"), new DBField("vehicleID", String.class, DBField.TYPE_STRING((int)24), I18N.getString(Device.class, (String)"Device.fld.vehicleID", (String)"VIN"), "edit=2"), new DBField("licensePlate", String.class, DBField.TYPE_STRING((int)24), I18N.getString(Device.class, (String)"Device.fld.licensePlate", (String)"License Plate"), "edit=2"), new DBField("driverID", String.class, DBField.TYPE_DRIVER_ID(), I18N.getString(Device.class, (String)"Device.fld.driverID", (String)"Driver ID"), "edit=2"), new DBField("driverStatus", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.driverStatus", (String)"Driver Status"), "edit=2"), new DBField("fuelCapacity", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.fuelCapacity", (String)"Fuel Capacity"), "edit=2 format=#0.0"), new DBField("fuelEconomy", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.fuelEconomy", (String)"Approx. Fuel Economy"), "edit=2 format=#0.0"), new DBField("speedLimitKPH", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.speedLimitKPH", (String)"Max Speed km/h"), "edit=2 format=#0.0"), new DBField("planDistanceKM", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.planDistance", (String)"Planned Trip Distance"), "edit=2 format=#0.0"), new DBField("installTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.installTime", (String)"Install Time"), "edit=2 format=time"), new DBField("resetTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.resetTime", (String)"Reset Time"), "edit=2 format=time"), new DBField("expirationTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.expirationTime", (String)"Expiration Time"), "edit=2 format=time"), new DBField("uniqueID", String.class, DBField.TYPE_UNIQ_ID(), I18N.getString(Device.class, (String)"Device.fld.uniqueID", (String)"Unique ID"), "edit=2 altkey=true presep"), new DBField("deviceCode", String.class, DBField.TYPE_STRING((int)24), I18N.getString(Device.class, (String)"Device.fld.deviceCode", (String)"Server ID"), "edit=2"), new DBField("deviceType", String.class, DBField.TYPE_STRING((int)24), I18N.getString(Device.class, (String)"Device.fld.deviceType", (String)"Device Type"), "edit=2"), new DBField("pushpinID", String.class, DBField.TYPE_STRING((int)32), I18N.getString(Device.class, (String)"Device.fld.pushpinID", (String)"Pushpin ID"), "edit=2"), new DBField("displayColor", String.class, DBField.TYPE_STRING((int)16), I18N.getString(Device.class, (String)"Device.fld.displayColor", (String)"Display Color"), "edit=2"), new DBField("serialNumber", String.class, DBField.TYPE_STRING((int)24), I18N.getString(Device.class, (String)"Device.fld.serialNumber", (String)"Serial Number"), "edit=2"), new DBField("simPhoneNumber", String.class, DBField.TYPE_STRING((int)24), I18N.getString(Device.class, (String)"Device.fld.simPhoneNumber", (String)"SIM Phone Number"), Device._simPhoneNumber_attr()), new DBField("simID", String.class, DBField.TYPE_STRING((int)24), I18N.getString(Device.class, (String)"Device.fld.simID", (String)"SIM ID"), "edit=2"), new DBField("smsEmail", String.class, DBField.TYPE_STRING((int)64), I18N.getString(Device.class, (String)"Device.fld.smsEmail", (String)"SMS EMail Address"), "edit=2"), new DBField("imeiNumber", String.class, DBField.TYPE_STRING((int)24), I18N.getString(Device.class, (String)"Device.fld.imeiNumber", (String)"IMEI Number"), "edit=2"), new DBField("dataKey", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.dataKey", (String)"Data Key"), "edit=2"), new DBField("ignitionIndex", Integer.TYPE, "INT16", I18N.getString(Device.class, (String)"Device.fld.ignitionIndex", (String)"Ignition I/O Index"), "edit=2"), new DBField("codeVersion", String.class, DBField.TYPE_STRING((int)32), I18N.getString(Device.class, (String)"Device.fld.codeVersion", (String)"Code Version"), ""), new DBField("featureSet", String.class, DBField.TYPE_STRING((int)64), I18N.getString(Device.class, (String)"Device.fld.featureSet", (String)"Feature Set"), ""), new DBField("ipAddressValid", DTIPAddrList.class, DBField.TYPE_STRING((int)128), I18N.getString(Device.class, (String)"Device.fld.ipAddressValid", (String)"Valid IP Addresses"), "edit=2"), new DBField("lastTotalConnectTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastTotalConnectTime", (String)"Last Total Connect Time"), "format=time"), new DBField("lastDuplexConnectTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastDuplexConnectTime", (String)"Last Duplex Connect Time"), "format=time"), new DBField("pendingPingCommand", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.pendingPingCommand", (String)"Pending Ping Command"), "edit=2"), new DBField("lastPingTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastPingTime", (String)"Last 'Ping' Time"), "format=time"), new DBField("totalPingCount", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.totalPingCount", (String)"Total 'Ping' Count"), ""), new DBField("maxPingCount", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.maxPingCount", (String)"Maximum 'Ping' Count"), "edit=2"), new DBField("commandStateMask", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.commandStateMask", (String)"Command State Mask"), "edit=2"), new DBField("expectAck", Boolean.TYPE, "BOOLEAN", I18N.getString(Device.class, (String)"Device.fld.expectAck", (String)"Expecting an ACK"), "edit=2"), new DBField("expectAckCode", Integer.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.expectAckStatusCode", (String)"Expected ACK Status Code"), "edit=2"), new DBField("lastAckCommand", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.lastAckCommand", (String)"Last Command Expecting ACK"), ""), new DBField("lastAckTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastAckTime", (String)"Last Received 'ACK' Time"), "format=time"), new DBField("dcsPropertiesID", String.class, DBField.TYPE_STRING((int)32), I18N.getString(Device.class, (String)"Device.fld.dcsPropertiesID", (String)"DCS Properties ID"), "edit=2"), new DBField("dcsConfigMask", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.dcsConfigMask", (String)"DCS Configuration Mask"), "edit=2"), new DBField("dcsConfigString", String.class, DBField.TYPE_STRING((int)80), I18N.getString(Device.class, (String)"Device.fld.dcsConfigString", (String)"DCS Configuration String"), "edit=2"), new DBField("dcsCommandHost", String.class, DBField.TYPE_STRING((int)32), I18N.getString(Device.class, (String)"Device.fld.dcsCommandHost", (String)"DCS Command Host"), "edit=2"), new DBField("supportsDMTP", Boolean.TYPE, "BOOLEAN", I18N.getString(Device.class, (String)"Device.fld.supportsDMTP", (String)"Supports DMTP"), "edit=2"), new DBField("supportedEncodings", Integer.TYPE, "UINT8", I18N.getString(Device.class, (String)"Device.fld.supportedEncodings", (String)"Supported Encodings"), "edit=2 format=X1 editor=encodings mask=Transport$Encodings"), new DBField("unitLimitInterval", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.unitLimitInterval", (String)"Accounting Time Interval Min"), "edit=2"), new DBField("maxAllowedEvents", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.maxAllowedEvents", (String)"Max Events per Interval"), "edit=2"), new DBField("totalProfileMask", DTProfileMask.class, "BLOB", I18N.getString(Device.class, (String)"Device.fld.totalProfileMask", (String)"Total Profile Mask"), ""), new DBField("totalMaxConn", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.totalMaxConn", (String)"Max Total Conn per Interval"), "edit=2"), new DBField("totalMaxConnPerMin", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.totalMaxConnPerMin", (String)"Max Total Conn per Minute"), "edit=2"), new DBField("duplexProfileMask", DTProfileMask.class, "BLOB", I18N.getString(Device.class, (String)"Device.fld.duplexProfileMask", (String)"Duplex Profile Mask"), ""), new DBField("duplexMaxConn", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.duplexMaxConn", (String)"Max Duplex Conn per Interval"), "edit=2"), new DBField("duplexMaxConnPerMin", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.duplexMaxConnPerMin", (String)"Max Duplex Conn per Minute"), "edit=2"), new DBField("lastTcpSessionID", String.class, DBField.TYPE_STRING((int)32), I18N.getString(Device.class, (String)"Device.fld.tcpSessionID", (String)"Last TCP Session ID"), ""), new DBField("ipAddressCurrent", DTIPAddress.class, DBField.TYPE_STRING((int)32), I18N.getString(Device.class, (String)"Device.fld.ipAddressCurrent", (String)"Current IP Address"), ""), new DBField("remotePortCurrent", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.remotePortCurrent", (String)"Current Remote Port"), ""), new DBField("listenPortCurrent", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.listenPortCurrent", (String)"Current Listen Port"), ""), new DBField("lastInputState", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastInputState", (String)"Last Input State"), ""), new DBField("lastOutputState", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastOutputState", (String)"Last Output State"), ""), new DBField("statusCodeState", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.statusCodeState", (String)"StatusCode On/Off State"), ""), new DBField("lastBatteryLevel", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastBatteryLevel", (String)"Last Battery Level"), "format=#0.0 units=percent"), new DBField("lastFuelLevel", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastFuelLevel", (String)"Last Fuel Level"), "format=#0.0 units=percent"), new DBField("lastFuelTotal", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastFuelTotal", (String)"Last Fuel Total Liters"), "format=#0.0 units=volume"), new DBField("lastOilLevel", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastOilLevel", (String)"Last Oil Level"), "format=#0.0"), new DBField("lastValidLatitude", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastValidLatitude", (String)"Last Valid Latitude"), "format=#0.00000"), new DBField("lastValidLongitude", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastValidLongitude", (String)"Last Valid Longitude"), "format=#0.00000"), new DBField("lastValidHeading", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastValidHeading", (String)"Last Valid Heading"), "format=#0.00000"), new DBField("lastValidSpeed", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastValidSpeed", (String)"Last Valid Speed"), "format=#0.00000"), new DBField("lastGPSTimestamp", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastGPSTimestamp", (String)"Last Valid GPS Timestamp"), "format=time"), new DBField("lastEventTimestamp", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastEventTimestamp", (String)"Last Event Timestamp"), "format=time"), new DBField("lastCellServingInfo", String.class, DBField.TYPE_STRING((int)100), I18N.getString(Device.class, (String)"Device.fld.lastCellServingInfo", (String)"Last Serving Cell Info"), ""), new DBField("lastDistanceKM", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastDistanceKM", (String)"Last Distance km"), "format=#0.0 units=distance"), new DBField("lastOdometerKM", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastOdometerKM", (String)"Last Odometer km"), "format=#0.0 units=distance"), new DBField("odometerOffsetKM", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.odometerOffsetKM", (String)"Odometer Offset km"), "format=#0.0 units=distance"), new DBField("lastEngineOnTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastEngineOnTime", (String)"Last Engine On Time"), "format=time"), new DBField("lastEngineOffTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastEngineOffTime", (String)"Last Engine Off Time"), "format=time"), new DBField("lastEngineHours", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastEngineHours", (String)"Last Engine Hours"), "format=#0.0"), new DBField("engineHoursOffset", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.ngineHoursOffset", (String)"Engine Hours Offset"), "format=#0.0"), new DBField("lastIgnitionOnTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastIgnitionOnTime", (String)"Last Ignition On Time"), "format=time"), new DBField("lastIgnitionOffTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastIgnitionOffTime", (String)"Last Ignition Off Time"), "format=time"), new DBField("lastIgnitionHours", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastIgnitionHours", (String)"Last Ignition Hours"), "format=#0.0"), new DBField("lastStopTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastStopTime", (String)"Last Stop  Time"), "format=time"), new DBField("lastStartTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastStartTime", (String)"Last Start Time"), "format=time"), new DBField("lastMalfunctionLamp", Boolean.TYPE, "BOOLEAN", I18N.getString(Device.class, (String)"Device.fld.lastMalfunctionLamp", (String)"Last MIL"), "edit=2"), new DBField("lastFaultCode", String.class, DBField.TYPE_STRING((int)96), I18N.getString(Device.class, (String)"Device.fld.lastFaultCode", (String)"Last Fault Code"), ""), Device.newField_isActive(), Device.newField_displayName(), Device.newField_description(), Device.newField_notes(), Device.newField_lastUpdateTime(), Device.newField_lastUpdateUser((boolean)true), Device.newField_creationTime()};
    public static final String FLD_allowNotify = "allowNotify";
    public static final String FLD_lastNotifyTime = "lastNotifyTime";
    public static final String FLD_lastNotifyCode = "lastNotifyCode";
    public static final String FLD_lastNotifyRule = "lastNotifyRule";
    public static final String FLD_notifyEmail = "notifyEmail";
    public static final String FLD_notifySelector = "notifySelector";
    public static final String FLD_notifyAction = "notifyAction";
    public static final String FLD_notifyDescription = "notifyDescription";
    public static final String FLD_notifySubject = "notifySubject";
    public static final String FLD_notifyText = "notifyText";
    public static final String FLD_notifyUseWrapper = "notifyUseWrapper";
    public static final String FLD_notifyPriority = "notifyPriority";
    public static final String FLD_parkedLatitude = "parkedLatitude";
    public static final String FLD_parkedLongitude = "parkedLongitude";
    public static final String FLD_parkedRadius = "parkedRadius";
    public static final String FLD_assignedUserID = "assignedUserID";
    public static final String FLD_thermalProfile = "thermalProfile";
    public static final String FLD_hoursOfOperation = "hoursOfOperation";
    public static final String FLD_lastEventsPerSecond = "lastEventsPerSecond";
    public static final String FLD_lastEventsPerSecondMS = "lastEventsPerSecondMS";
    public static final DBField[] NotificationFieldInfo = new DBField[]{new DBField("allowNotify", Boolean.TYPE, "BOOLEAN", I18N.getString(Device.class, (String)"Device.fld.allowNotify", (String)"Allow Notification"), "edit=2"), new DBField("lastNotifyTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastNotifyTime", (String)"Last Notify Time"), Device._lastNotifyTime_attr()), new DBField("lastNotifyCode", Integer.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastNotifyCode", (String)"Last Notify Status Code"), "format=X2"), new DBField("lastNotifyRule", String.class, DBField.TYPE_RULE_ID(), I18N.getString(Device.class, (String)"Device.fld.lastNotifyRule", (String)"Last Notify Rule ID"), ""), new DBField("notifyEmail", String.class, DBField.TYPE_EMAIL_LIST(), I18N.getString(Device.class, (String)"Device.fld.notifyEmail", (String)"Notification EMail Address"), "edit=2"), new DBField("notifySelector", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.notifySelector", (String)"Notification Selector"), "edit=2 editor=ruleSelector"), new DBField("notifyAction", Integer.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.notifyAction", (String)"Notification Action"), "edit=2 format=X2 editor=ruleAction mask=RuleFactory$NotifyAction"), new DBField("notifyDescription", String.class, DBField.TYPE_STRING((int)64), I18N.getString(Device.class, (String)"Device.fld.notifyDescription", (String)"Notification Description"), "edit=2 utf8=true"), new DBField("notifySubject", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.notifySubject", (String)"Notification Subject"), "edit=2 utf8=true"), new DBField("notifyText", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.notifyText", (String)"Notification Message"), "edit=2 editor=textArea utf8=true"), new DBField("notifyUseWrapper", Boolean.TYPE, "BOOLEAN", I18N.getString(Device.class, (String)"Device.fld.notifyUseWrapper", (String)"Notification Use Wrapper"), "edit=2"), new DBField("notifyPriority", Integer.TYPE, "UINT16", I18N.getString(Device.class, (String)"Device.fld.notifyPriority", (String)"Notification Priority"), "edit=2"), new DBField("parkedLatitude", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.parkedLatitude", (String)"Parked Latitude"), "format=#0.00000 edit=2"), new DBField("parkedLongitude", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.parkedLongitude", (String)"Parked Longitude"), "format=#0.00000 edit=2"), new DBField("parkedRadius", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.parkedRadius", (String)"Parked Radius"), "format=#0.0 edit=2"), new DBField("assignedUserID", String.class, DBField.TYPE_USER_ID(), I18N.getString(Device.class, (String)"Device.fld.assignedUserID", (String)"Assigned User"), "edit=2"), new DBField("thermalProfile", String.class, DBField.TYPE_STRING((int)200), I18N.getString(Device.class, (String)"Device.fld.thermalProfile", (String)"Temperature Profile"), "edit=2"), new DBField("hoursOfOperation", String.class, DBField.TYPE_STRING((int)200), I18N.getString(Device.class, (String)"Device.fld.hoursOfOperation", (String)"Hours Of Operation"), "edit=2"), new DBField("lastEventsPerSecond", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.lastEventsPerSecond", (String)"Last Event per Second"), "format=#0.00"), new DBField("lastEventsPerSecondMS", Long.TYPE, "INT64", I18N.getString(Device.class, (String)"Device.fld.lastEventsPerSecondMS", (String)"Last Event/Second time MS"), "format=time")};
    public static final String FLD_borderCrossing = "borderCrossing";
    public static final String FLD_lastBorderCrossTime = "lastBorderCrossTime";
    public static final DBField[] BorderCrossingFieldInfo = new DBField[]{new DBField("borderCrossing", Integer.TYPE, "UINT8", I18N.getString(Device.class, (String)"Device.fld.borderCrossing", (String)"Border Crossing Flags"), "edit=2 enum=Device$BorderCrossingState"), new DBField("lastBorderCrossTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastBorderCrossTime", (String)"Last Border Crossing Time"), "format=time")};
    public static final String FLD_linkURL = "linkURL";
    public static final String FLD_linkDescription = "linkDescription";
    public static final DBField[] LinkFieldInfo = new DBField[]{new DBField("linkURL", String.class, DBField.TYPE_STRING((int)128), I18N.getString(Device.class, (String)"Device.fld.linkURL", (String)"Link URL"), "edit=2"), new DBField("linkDescription", String.class, DBField.TYPE_STRING((int)64), I18N.getString(Device.class, (String)"Device.fld.linkDescription", (String)"Link Description"), "edit=2")};
    public static final String FLD_fixedLatitude = "fixedLatitude";
    public static final String FLD_fixedLongitude = "fixedLongitude";
    public static final String FLD_fixedAddress = "fixedAddress";
    public static final String FLD_fixedContactPhone = "fixedContactPhone";
    public static final String FLD_fixedServiceTime = "fixedServiceTime";
    public static final DBField[] FixedLocationFieldInfo = new DBField[]{new DBField("fixedLatitude", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.fixedLatitude", (String)"Fixed Latitude"), "format=#0.00000 edit=2"), new DBField("fixedLongitude", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.fixedLongitude", (String)"Fixed Longitude"), "format=#0.00000 edit=2"), new DBField("fixedAddress", String.class, DBField.TYPE_STRING((int)90), I18N.getString(Device.class, (String)"Device.fld.fixedAddress", (String)"Fixed Address (Physical)"), "utf8=true"), new DBField("fixedContactPhone", String.class, DBField.TYPE_STRING((int)64), I18N.getString(Device.class, (String)"Device.fld.fixedContactPhone", (String)"Fixed Contact Phone"), "utf8=true"), new DBField("fixedServiceTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.fixedServiceTime", (String)"Last Service Time"), "format=time edit=2")};
    public static final String FLD_activeCorridor = "activeCorridor";
    public static final DBField[] GeoCorridorFieldInfo = new DBField[]{new DBField("activeCorridor", String.class, DBField.TYPE_CORR_ID(), "Active GeoCorridor", "")};
    public static final String FLD_maintDescriptionKM0 = "maintDescriptionKM0";
    public static final String FLD_maintIntervalKM0 = "maintIntervalKM0";
    public static final String FLD_maintOdometerKM0 = "maintOdometerKM0";
    public static final String FLD_maintDescriptionKM1 = "maintDescriptionKM1";
    public static final String FLD_maintIntervalKM1 = "maintIntervalKM1";
    public static final String FLD_maintOdometerKM1 = "maintOdometerKM1";
    public static final String FLD_maintIntervalHR0 = "maintIntervalHR0";
    public static final String FLD_maintEngHoursHR0 = "maintEngHoursHR0";
    public static final String FLD_maintNotes = "maintNotes";
    public static final String FLD_reminderType = "reminderType";
    public static final String FLD_reminderMessage = "reminderMessage";
    public static final String FLD_reminderInterval = "reminderInterval";
    public static final String FLD_reminderTime = "reminderTime";
    public static final String FLD_lastServiceTime = "lastServiceTime";
    public static final String FLD_nextServiceTime = "nextServiceTime";
    public static final DBField[] MaintOdometerFieldInfo = new DBField[]{new DBField("maintIntervalKM0", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.maintIntervalKM0", (String)"#0 Maint Distance"), "format=#0.0 edit=2"), new DBField("maintOdometerKM0", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.maintOdometerKM0", (String)"#0 Maint Last Odom"), "format=#0.0"), new DBField("maintIntervalKM1", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.maintIntervalKM1", (String)"#1 Maint Distance "), "format=#0.0 edit=2"), new DBField("maintOdometerKM1", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.maintOdometerKM1", (String)"#1 Maint Last Odom"), "format=#0.0"), new DBField("maintIntervalHR0", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.maintIntervalHR0", (String)"#0 Maint ElapsedHours"), "format=#0.0 edit=2"), new DBField("maintEngHoursHR0", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.maintEngHoursHR0", (String)"#0 Maint Last EngineHours"), "format=#0.0"), new DBField("maintNotes", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.maintNotes", (String)"Maint Notes"), "edit=2 editor=textArea utf8=true"), new DBField("reminderMessage", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.reminderMessage", (String)"Reminder Message"), "edit=2 editor=textArea utf8=true"), new DBField("reminderInterval", String.class, DBField.TYPE_STRING((int)64), I18N.getString(Device.class, (String)"Device.fld.reminderInterval", (String)"Reminder Interval"), "edit=2"), new DBField("reminderTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.reminderTime", (String)"Last Reminder Time"), "format=time"), new DBField("lastServiceTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastServiceTime", (String)"Last Service Time"), "format=time"), new DBField("nextServiceTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.nextServiceTime", (String)"Next Service Time"), "format=time")};
    public static final String FLD_workOrderID = "workOrderID";
    public static final String FLD_jobNumber = "jobNumber";
    public static final String FLD_jobLatitude = "jobLatitude";
    public static final String FLD_jobLongitude = "jobLongitude";
    public static final String FLD_jobRadius = "jobRadius";
    public static final String FLD_customAttributes = "customAttributes";
    public static final DBField[] WorkOrderInfo = new DBField[]{new DBField("workOrderID", String.class, DBField.TYPE_STRING((int)512), I18N.getString(Device.class, (String)"Device.fld.workOrderID", (String)"Work Order ID"), "edit=2"), new DBField("jobNumber", String.class, DBField.TYPE_STRING((int)32), I18N.getString(Device.class, (String)"Device.fld.jobNumber", (String)"Job Number"), "edit=2"), new DBField("jobLatitude", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.jobLatitude", (String)"Job Latitude"), "format=#0.00000 edit=2"), new DBField("jobLongitude", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.jobLongitude", (String)"Job Longitude"), "format=#0.00000 edit=2"), new DBField("jobRadius", Double.TYPE, "DOUBLE", I18N.getString(Device.class, (String)"Device.fld.jobRadius", (String)"Job Radius"), "format=#0.0 edit=2"), new DBField("customAttributes", String.class, "TEXT", I18N.getString(Device.class, (String)"Device.fld.customFields", (String)"Custom Fields"), "edit=2")};
    public static final String FLD_lastDataPushTime = "lastDataPushTime";
    public static final String FLD_lastEventCreateMillis = "lastEventCreateMillis";
    public static final DBField[] DataPushInfo = new DBField[]{new DBField("lastDataPushTime", Long.TYPE, "UINT32", I18N.getString(Device.class, (String)"Device.fld.lastDataPushTime", (String)"Last Data Push Time (sec)"), "format=time"), new DBField("lastEventCreateMillis", Long.TYPE, "INT64", I18N.getString(Device.class, (String)"Device.fld.lastEventCreateMillis", (String)"Last Event Create Time (MS)"), "format=time")};
    private static DBFactory<Device> factory = null;
    private String lastVehicleID = null;
    private Driver driver = null;
    private static final boolean CHECK_ACCOUNT_ALLOWNOTIFY = false;
    private static boolean CHECK_IMEI_FOR_MODEM_ID = false;
    private String modemID = "";
    private static boolean CHECK_LAST_EVENT_IGNITION = false;
    private int cacheIgnitionState = -2;
    private static final Integer GEOZONE_ARRIVE = new Integer(61968);
    private static final Integer GEOZONE_DEPART = new Integer(62000);
    private static final Integer CORRIDOR_ENABLE = new Integer(62072);
    private static final Integer CORRIDOR_DISABLE = new Integer(62088);
    private static int MAX_MAINT_ODOM_COUNT = 2;
    private static Vector<Integer> RuleMaintTrigger = null;
    private static boolean REMINDER_LOG = RTConfig.getBoolean((String)"device.debugReminder", (boolean)false);
    private User assignedUser = null;
    public static WorkHours DefaultWorkHours = new WorkHours(RTConfig.getPropertyGetter(), "rule.workHours.");
    private WorkHours cacheWorkHours = null;
    private RTProperties customAttrRTP = null;
    private Collection<String> customAttrKeys = null;
    private int[] startStopStatusCodes = null;
    private boolean startStopStatusCodes_init = false;
    private static boolean allowSlowReverseGeocode = true;
    private static boolean ENABLE_LOAD_TESTING = true;
    private static Object loadTestingLock = new Object();
    private static DateTime loadTestingTime = null;
    private static long loadTestingCount = 0L;
    private static final String[] DefaultUpdatedFieldsList = new String[]{"deviceCode", "imeiNumber", "lastTcpSessionID", "ipAddressCurrent", "remotePortCurrent", "listenPortCurrent", "lastInputState", "lastBatteryLevel", "lastFuelLevel", "lastFuelTotal", "lastOilLevel", "lastValidLatitude", "lastValidLongitude", "lastValidHeading", "lastGPSTimestamp", "lastEventTimestamp", "lastMalfunctionLamp", "lastFaultCode", "lastOdometerKM", "lastDistanceKM", "lastEngineOnTime", "lastEngineOffTime", "lastEngineHours", "lastIgnitionOnTime", "lastIgnitionOffTime", "lastIgnitionHours", "lastStopTime", "lastStartTime", "lastTotalConnectTime"};
    private static final Set<String> DefaultUpdatedFieldsSet = ListTools.toSet((Object[])DefaultUpdatedFieldsList);
    private Set<String> otherChangedFieldsSet = null;
    private Map<Integer, StatusCode> cacheStatusCodeMap = null;
    private EventData[] cachedRangeEvents = null;
    private Transport transport = null;
    private static final String[] KEY_DEVICE = EventData.KEY_DEVICE;
    private static final String[] KEY_DEVICE_LINK = EventData.KEY_DEVICE_LINK;
    private static final String[] KEY_DEV_CONN_AGE = EventData.KEY_DEV_CONN_AGE;
    private static final String[] KEY_DEV_TRAILERS = EventData.KEY_DEV_TRAILERS;
    public static final String[] KEY_LICENSE_PLATE = new String[]{"licensePlate"};
    private static final String[] KEY_EVENT_COUNT24 = EventData.KEY_EVENT_COUNT24;
    private static final String[] KEY_LAST_EPS = new String[]{"lastEventsPerSecond", "lastEPS", "eventsPerSecond"};
    private static final String[] KEY_LAST_EPH = new String[]{"lastEventsPerHour", "lastEPH", "eventsPerHour"};
    private static final String[] KEY_DRIVERID = EventData.KEY_DRIVERID;
    private static final String[] KEY_DRIVER_DESC = EventData.KEY_DRIVER_DESC;
    public static final String[] KEY_DRIVER_BADGE = EventData.KEY_DRIVER_BADGE;
    public static final String[] KEY_DRIVER_LICENSE = EventData.KEY_DRIVER_LICENSE;
    private static final String[] KEY_FAULT_CODE = EventData.KEY_FAULT_CODE;
    private static final String[] KEY_FAULT_CODES = EventData.KEY_FAULT_CODES;
    private static final String[] KEY_FUEL_LEVEL = new String[]{"fuelLevel"};
    private static final String[] KEY_LAST_FUEL_LEV = new String[]{"lastFuelLevel"};
    private static final String[] KEY_FUEL_VOLUME = new String[]{"fuelLevelVolume", "fuelVolume"};
    private static final String[] KEY_LAST_FUEL_VOL = new String[]{"lastFuelLevelVolume", "lastFuelVolume"};
    private static final String[] KEY_CORRIDOR_ID = new String[]{"activeCorridor", "corridorID"};
    private static final String[] KEY_CORRIDOR_DESC = new String[]{"activeCorridorDesc", "corridorDesc"};
    private static final String[] KEY_STOP_ELAPSED = new String[]{"stopElapsed", "timeStopped"};
    private static final String[] KEY_SPEED_LIMIT = new String[]{"devSpeedLimit", "speedLimit"};
    private static final String[] KEY_REMINDER = new String[]{"reminderMessage", "reminder"};
    private static final String[] KEY_COMMAND_STATE = new String[]{"commandState"};
    private static final String[] KEY_COMMAND_TIME = new String[]{"commandDateTime", "commandTime", "pingDateTime"};
    private static final String[] KEY_ACK_DATETIME = new String[]{"ackDateTime"};
    private static final String[] KEY_MAINT_DESC = new String[]{"maintDesc"};
    private static final String[] KEY_MAINT_ODOMETER = new String[]{"maintOdometer", "mainOdom"};
    private static final String[] KEY_MAINT_INTERVAL = new String[]{"maintInterval", "mainInter"};
    private static final String[] KEY_CUSTOM = new String[]{"custom"};
    private static Comparator<Device> devDescComparator = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev", "d"};
    private static final String[] ARG_UNIQID = new String[]{"uniqueid", "unique", "uniq", "uid", "u"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_EDITALL = new String[]{"editall", "eda"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_EVENTS = new String[]{"events", "ev"};
    private static final String[] ARG_FORMAT = new String[]{"format", "fmt"};
    private static final String[] ARG_INSERT = new String[]{"insertGP"};
    private static final String[] ARG_CLEARACK = new String[]{"clearAck"};
    private static final String[] ARG_RESET_ACCUM = new String[]{"resetAccum", "resetAccumulators"};
    private static final String[] ARG_MAINTKM = new String[]{"maint", "maintkm"};
    private static final String[] ARG_CHECKRULES = new String[]{"ckRules"};
    private static final String[] ARG_RESET_ODOM = new String[]{"resetOdom"};
    private static final String[] ARG_SEND_COMMAND = new String[]{"sendCmd"};
    private static final String[] ARG_CNT_FUTURE_EV = new String[]{"countFutureEvents"};
    private static final String[] ARG_DEL_FUTURE_EV = new String[]{"deleteFutureEvents"};
    private static final String[] ARG_CNT_OLD_EV = new String[]{"countOldEvents"};
    private static final String[] ARG_DEL_OLD_EV = new String[]{"deleteOldEvents"};
    private static final String[] ARG_CONFIRM_DEL = new String[]{"confirmDelete"};
    private static final String[] ARG_ZONECHECK = new String[]{"zoneCheck"};
    private static final String[] ARG_SIM_PHONE = new String[]{"simPhone"};

    public static void SetLogEventDataInsertion(int logLevel) {
        if (logLevel >= 3) {
            LogEventDataInsertion = logLevel;
        } else {
            Print.logWarn((String)("'SetLogEventDataInsertion' ignoring excessive log level: " + Print.getLogLevelString((int)logLevel) + " (using LOG_WARN instead)"), (Object[])new Object[0]);
            LogEventDataInsertion = 3;
        }
    }

    public static long MinMax(long val, long min, long max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static double MinMax(double val, double min, double max) {
        return val < min ? min : (val > max ? max : val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initEventsPerSecond() {
        if (EPS_did_init) return;
        String string = "Device.eventsPerSecond";
        synchronized ("Device.eventsPerSecond") {
            if (EPS_did_init) return;
            double[] E = RTConfig.getDoubleArray((String)"Device.eventsPerSecond", null);
            if (!ListTools.isEmpty((double[])E)) {
                double weight;
                long rangeSec = E.length > 0 ? Math.round(E[0]) : EPS_RANGE_SECONDS;
                double d = weight = E.length > 1 ? E[1] : EPS_WEIGHT;
                if (weight >= 2.0) {
                    weight /= 100.0;
                }
                EPS_RANGE_SECONDS = Device.MinMax(rangeSec, 10L, DateTime.DaySeconds((long)1L));
                EPS_RANGE_MS = EPS_RANGE_SECONDS * 1000L;
                EPS_WEIGHT = Device.MinMax(weight, 0.05, 0.999);
                EPS_ALPHA = 1.0 - Math.exp(Math.log(1.0 - EPS_WEIGHT) / (double)EPS_RANGE_MS);
            }
            EPS_did_init = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String[] GetTitles(Locale loc) {
        I18N i18n = I18N.getI18N(Device.class, (Locale)loc);
        return new String[]{i18n.getString("Device.title.singular", "Vehicle"), i18n.getString("Device.title.plural", "Vehicles")};
    }

    public static EquipmentStatus getEquipmentStatus(Device d) {
        return d != null ? (EquipmentStatus)EnumTools.getValueOf(EquipmentStatus.class, (int)d.getEquipmentStatus()) : (EquipmentStatus)EnumTools.getDefault(EquipmentStatus.class);
    }

    public static ReminderType getReminderType(Device d) {
        return d != null ? (ReminderType)EnumTools.getValueOf(ReminderType.class, (int)d.getReminderType()) : (ReminderType)EnumTools.getDefault(ReminderType.class);
    }

    public static boolean GetCheckLastOdometer() {
        return RTConfig.getBoolean((String)"Device.checkLastOdometer", (boolean)false);
    }

    public static boolean GetSimulateEngineHours(Device dev) {
        return RTConfig.getBoolean((String)"Device.simulateEngineHours", (boolean)SIMULATE_ENGINE_HOURS);
    }

    public static boolean UpdateEventWithGeozoneLocation() {
        return RTConfig.getBoolean((String)"Device.updateEventWithGeozoneLoc", (boolean)UPDATE_EVENT_WITH_GEOZONE_LOC);
    }

    public static double GetMaximumOdometerKM() {
        return RTConfig.getDouble((String)"Device.maximumOdometerKM", (double)1609344.0);
    }

    public static double GetMaximumRuntimeHours() {
        return RTConfig.getDouble((String)"Device.maximumRuntimeHours", (double)MAX_DEVICE_RUNTIME_HOURS);
    }

    public static boolean CheckNotifySelector() {
        if (!Device.hasRuleFactory()) {
            return false;
        }
        if (!RTConfig.getBoolean((String)"Device.checkNotifySelector", (boolean)true)) {
            return false;
        }
        if (Device.hasENRE()) {
            return RTConfig.getBoolean((String)"Device.checkNotifySelector.ENRE", (boolean)false);
        }
        return true;
    }

    public static boolean GetSaveEventDriverID() {
        return RTConfig.getBoolean((String)"Device.saveEventDriverID", (boolean)true);
    }

    public static void setCellTowerGetLocation(MobileLocationProvider ctgl) {
        cellTower_initDefault = true;
        if (ctgl != null) {
            cellTower_GetLocation = ctgl;
            Print.logDebug((String)("Device CellTower.GetLocation installed: " + StringTools.className((Object)ctgl)), (Object[])new Object[0]);
        } else if (cellTower_GetLocation != null) {
            cellTower_GetLocation = null;
            Print.logDebug((String)"Device CellTower.GetLocation removed.", (Object[])new Object[0]);
        }
    }

    public static boolean hasCellTowerGetLocation() {
        return cellTower_GetLocation != null;
    }

    public static MobileLocationProvider getMobileLocationProvider() {
        if (!cellTower_initDefault) {
            cellTower_initDefault = true;
            if (cellTower_GetLocation == null) {
                cellTower_GetLocation = null;
            }
        }
        return cellTower_GetLocation;
    }

    public static void setRuleFactory(RuleFactory rf) {
        if (rf != null) {
            ruleFactory = rf;
            Print.logDebug((String)("Device RuleFactory installed: " + StringTools.className((Object)rf)), (Object[])new Object[0]);
        } else if (ruleFactory != null) {
            ruleFactory = null;
            Print.logDebug((String)"Device RuleFactory removed.", (Object[])new Object[0]);
        }
    }

    public static boolean hasRuleFactory() {
        return ruleFactory != null;
    }

    public static boolean hasENRE() {
        if (ruleFactory != null) {
            return OSTools.instanceOf((Object)ruleFactory, (String)"org.opengts.rule.EventRuleFactory");
        }
        return false;
    }

    public static RuleFactory getRuleFactory() {
        return ruleFactory;
    }

    public static RuleFactory getRuleFactory(boolean checkRuntime) {
        if (checkRuntime && ruleFactory != null) {
            return ruleFactory.checkRuntime() ? ruleFactory : null;
        }
        return ruleFactory;
    }

    public static void setSessionStatsFactory(SessionStatsFactory rf) {
        if (rf != null) {
            statsFactory = rf;
            Print.logDebug((String)("Device SessionStatsFactory installed: " + StringTools.className((Object)statsFactory)), (Object[])new Object[0]);
        } else if (statsFactory != null) {
            statsFactory = null;
            Print.logDebug((String)"Device SessionStatsFactory removed.", (Object[])new Object[0]);
        }
    }

    public static boolean hasSessionStatsFactory() {
        return statsFactory != null;
    }

    public static SessionStatsFactory getSessionStatsFactory() {
        return statsFactory;
    }

    public static void setEntityManager(EntityManager ef) {
        if (ef != null) {
            entityManager = ef;
        } else if (entityManager != null) {
            entityManager = null;
        }
    }

    public static boolean hasEntityManager() {
        return entityManager != null;
    }

    public static EntityManager getEntityManager() {
        return entityManager;
    }

    public static String getEntityDescription(String accountID, String entityID, EntityManager.EntityType etype) {
        EntityManager.EntityType et = EntityManager.getEntityType(etype);
        return Device.getEntityDescription(accountID, entityID, et.getIntValue());
    }

    public static String getEntityDescription(String accountID, String entityID, int etype) {
        String eid = StringTools.trim((String)entityID);
        if (!eid.equals("") && Device.hasEntityManager()) {
            eid = Device.getEntityManager().getEntityDescription(accountID, eid, etype);
        }
        return eid;
    }

    public static boolean isEntityAttached(String accountID, String deviceID, String entityID, EntityManager.EntityType etype) {
        EntityManager.EntityType et = EntityManager.getEntityType(etype);
        return Device.isEntityAttached(accountID, deviceID, entityID, et.getIntValue());
    }

    public static boolean isEntityAttached(String accountID, String deviceID, String entityID, int etype) {
        String eid = StringTools.trim((String)entityID);
        if (!eid.equals("") && Device.hasEntityManager()) {
            return Device.getEntityManager().isEntityAttached(accountID, deviceID, eid, etype);
        }
        return false;
    }

    public static void setFuelManager(FuelManager fm) {
        if (fm != null) {
            fuelManager = fm;
        } else if (fuelManager != null) {
            fuelManager = null;
        }
    }

    public static boolean hasFuelManager() {
        return fuelManager != null;
    }

    public static FuelManager getFuelManager() {
        return fuelManager;
    }

    public static void setPingDispatcher(PingDispatcher pd) {
        if (pd != null) {
            pingDispatcher = pd;
            Print.logDebug((String)("Device PingDispatcher installed: " + StringTools.className((Object)pingDispatcher)), (Object[])new Object[0]);
        } else if (pingDispatcher != null) {
            pingDispatcher = null;
            Print.logDebug((String)"Device PingDispatcher removed.", (Object[])new Object[0]);
        }
    }

    public static boolean hasPingDispatcher() {
        return pingDispatcher != null;
    }

    public static PingDispatcher getPingDispatcher() {
        return pingDispatcher;
    }

    public static int pastEventDateAction() {
        if (PastEventDateAction == -999) {
            String act = RTConfig.getString((String)"Device.pastDate.action", (String)"");
            if (act.equalsIgnoreCase("ignore") || act.equalsIgnoreCase("skip") || act.equalsIgnoreCase("-1")) {
                PastEventDateAction = -1;
            } else if (act.equalsIgnoreCase("truncate") || act.equalsIgnoreCase("1")) {
                PastEventDateAction = 1;
            } else if (StringTools.isBlank((String)act) || act.equalsIgnoreCase("disabled") || act.equalsIgnoreCase("disable") || act.equalsIgnoreCase("0")) {
                PastEventDateAction = 0;
            } else {
                Print.logError((String)"Invalid property value %s => %s", (Object[])new Object[]{"Device.pastDate.action", act});
                PastEventDateAction = 0;
            }
        }
        return PastEventDateAction;
    }

    public static long pastEventDateMaximumSec() {
        if (PastEventDateMaxSec == -999L) {
            String M = RTConfig.getString((String)"Device.pastDate.maximumSec", (String)"");
            if (!StringTools.isBlank((String)M)) {
                long S = StringTools.parseLong((String)M, (long)0L);
                if (StringTools.endsWithIgnoreCase((String)M, (String)"d")) {
                    S = DateTime.DaySeconds((long)S);
                }
                PastEventDateMaxSec = Math.abs(S);
            } else {
                PastEventDateMaxSec = 0L;
            }
        }
        return PastEventDateMaxSec;
    }

    public static int futureEventDateAction() {
        if (FutureEventDateAction == -999) {
            String act = RTConfig.getString((String)"Device.futureDate.action", (String)"");
            if (act.equalsIgnoreCase("ignore") || act.equalsIgnoreCase("skip") || act.equalsIgnoreCase("-1")) {
                FutureEventDateAction = -1;
            } else if (act.equalsIgnoreCase("truncate") || act.equalsIgnoreCase("1")) {
                FutureEventDateAction = 1;
            } else if (StringTools.isBlank((String)act) || act.equalsIgnoreCase("disabled") || act.equalsIgnoreCase("disable") || act.equalsIgnoreCase("0")) {
                FutureEventDateAction = 0;
            } else {
                Print.logError((String)"Invalid property value %s => %s", (Object[])new Object[]{"Device.futureDate.action", act});
                FutureEventDateAction = 0;
            }
        }
        return FutureEventDateAction;
    }

    public static long futureEventDateMaximumSec() {
        if (FutureEventDateMaxSec == -999L) {
            String M = RTConfig.getString((String)"Device.futureDate.maximumSec", (String)"");
            if (!StringTools.isBlank((String)M)) {
                long S = StringTools.parseLong((String)M, (long)0L);
                if (StringTools.endsWithIgnoreCase((String)M, (String)"d")) {
                    S = DateTime.DaySeconds((long)S);
                }
                FutureEventDateMaxSec = Math.abs(S);
            } else {
                FutureEventDateMaxSec = 0L;
            }
        }
        return FutureEventDateMaxSec;
    }

    public static int invalidSpeedAction() {
        if (InvalidSpeedAction == -999) {
            String act = RTConfig.getString((String)"Device.invalidSpeed.action", (String)"");
            if (act.equalsIgnoreCase("ignore") || act.equalsIgnoreCase("skip") || act.equalsIgnoreCase("-1")) {
                InvalidSpeedAction = -1;
            } else if (act.equalsIgnoreCase("truncate") || act.equalsIgnoreCase("1")) {
                InvalidSpeedAction = 1;
            } else if (act.equalsIgnoreCase("zero") || act.equalsIgnoreCase("setzero") || act.equalsIgnoreCase("2")) {
                InvalidSpeedAction = 2;
            } else if (StringTools.isBlank((String)act) || act.equalsIgnoreCase("disabled") || act.equalsIgnoreCase("disable") || act.equalsIgnoreCase("0")) {
                InvalidSpeedAction = 0;
            } else {
                Print.logError((String)"Invalid property value %s => %s", (Object[])new Object[]{"Device.invalidSpeed.action", act});
                InvalidSpeedAction = 0;
            }
        }
        return InvalidSpeedAction;
    }

    public static double invalidSpeedMaximumKPH() {
        if (InvalidSpeedMaxKPH <= -999.0) {
            String spdMaxProp = "Device.invalidSpeed.maximumKPH";
            InvalidSpeedMaxKPH = RTConfig.getDouble((String)spdMaxProp, (double)0.0);
            if (InvalidSpeedMaxKPH <= 0.0) {
                InvalidSpeedMaxKPH = 0.0;
            } else if (InvalidSpeedMaxKPH <= 100.0) {
                Print.logWarn((String)("**** \"" + spdMaxProp + "\" set to " + InvalidSpeedMaxKPH + " km/h ****"), (Object[])new Object[0]);
            }
        }
        return InvalidSpeedMaxKPH;
    }

    private static String _simPhoneNumber_attr() {
        String commonAttr = "edit=2";
        if (RTConfig.getBoolean((String)"Device.keyedSimPhoneNumber", (boolean)false)) {
            return commonAttr + " altkey=simphone";
        }
        return commonAttr;
    }

    private static String _lastNotifyTime_attr() {
        String commonAttr = "format=time";
        if (RTConfig.getBoolean((String)"Device.keyedLastNotifyTime", (boolean)false)) {
            return commonAttr + " altkey=notifyTime";
        }
        return commonAttr;
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Device> getFactory() {
        if (factory == null) {
            EnumTools.registerEnumClass(RuleFactory.NotifyAction.class);
            factory = DBFactory.createDBFactory((String)Device.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Device.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            DBField lastFCFld = factory.getField(FLD_lastFaultCode);
            LastFaultCodeColumnLength = lastFCFld != null ? lastFCFld.getStringLength() : 0;
        }
        return factory;
    }

    public Device() {
    }

    public Device(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Device.class, (Locale)loc);
        return i18n.getString("Device.description", "This table defines Device/Vehicle specific information for an Account. A 'Device' record typically represents something that is being 'tracked', such as a Vehicle.");
    }

    public String getGroupID() {
        String v = (String)this.getFieldValue(FLD_groupID);
        return StringTools.trim((String)v);
    }

    public void setGroupID(String v) {
        this.setFieldValue(FLD_groupID, StringTools.trim((String)v));
    }

    public String getEquipmentType() {
        String v = (String)this.getFieldValue(FLD_equipmentType);
        return StringTools.trim((String)v);
    }

    public void setEquipmentType(String v) {
        this.setFieldValue(FLD_equipmentType, StringTools.trim((String)v));
    }

    public boolean hasEquipmentStatus() {
        return this.getEquipmentStatus() > EquipmentStatus.UNSPECIFIED.getIntValue();
    }

    public int getEquipmentStatus() {
        Integer v = (Integer)this.getFieldValue(FLD_equipmentStatus);
        return v != null ? v.intValue() : EquipmentStatus.UNSPECIFIED.getIntValue();
    }

    public void setEquipmentStatus(int v) {
        int es = v >= EquipmentStatus.UNSPECIFIED.getIntValue() ? v : EquipmentStatus.UNSPECIFIED.getIntValue();
        this.setFieldValue(FLD_equipmentStatus, es);
        this.addOtherChangedFieldNames(FLD_equipmentStatus);
    }

    public String getVehicleMake() {
        String v = (String)this.getFieldValue(FLD_vehicleMake);
        return StringTools.trim((String)v);
    }

    public void setVehicleMake(String v) {
        this.setFieldValue(FLD_vehicleMake, StringTools.trim((String)v));
    }

    public String getVehicleModel() {
        String v = (String)this.getFieldValue(FLD_vehicleModel);
        return StringTools.trim((String)v);
    }

    public void setVehicleModel(String v) {
        this.setFieldValue(FLD_vehicleModel, StringTools.trim((String)v));
    }

    public String getVehicleID() {
        String v = (String)this.getFieldValue(FLD_vehicleID);
        return StringTools.trim((String)v);
    }

    public void setVehicleID(String v) {
        String lastVIN;
        String VIN = StringTools.trim((String)v);
        if (!VIN.equals(lastVIN = this.getVehicleID())) {
            this.lastVehicleID = lastVIN;
        }
        this.setFieldValue(FLD_vehicleID, VIN);
    }

    public String getLastVehicleID() {
        if (!StringTools.isBlank((String)this.lastVehicleID)) {
            return this.lastVehicleID;
        }
        return this.getVehicleID();
    }

    public String getLicensePlate() {
        String v = (String)this.getFieldValue(FLD_licensePlate);
        return StringTools.trim((String)v);
    }

    public void setLicensePlate(String v) {
        this.setFieldValue(FLD_licensePlate, StringTools.trim((String)v));
    }

    public boolean hasDriverID() {
        return !StringTools.isBlank((String)this.getDriverID());
    }

    public boolean isDriverID(String drvID) {
        if (!StringTools.isBlank((String)drvID)) {
            return this.getDriverID().equalsIgnoreCase(drvID);
        }
        return false;
    }

    public String getDriverID() {
        String v = (String)this.getFieldValue(FLD_driverID);
        return StringTools.trim((String)v);
    }

    public void setDriverID(String v) {
        this.setFieldValue(FLD_driverID, StringTools.trim((String)v));
        this.addOtherChangedFieldNames(FLD_driverID);
        this.driver = null;
    }

    public Driver getDriver() {
        String driverID;
        if (this.driver == null && !StringTools.isBlank((String)(driverID = this.getDriverID()))) {
            try {
                this.driver = Driver.getDriver(this.getAccount(), driverID);
            }
            catch (DBException dbe) {
                this.driver = null;
            }
        }
        return this.driver;
    }

    public boolean hasDriverStatus() {
        return this.getDriverStatus() > 0L;
    }

    public long getDriverStatus() {
        Long v = (Long)this.getFieldValue(FLD_driverStatus);
        return v != null ? v : 0L;
    }

    public void setDriverStatus(long v) {
        long ds = v >= 0L ? v : 0L;
        this.setFieldValue(FLD_driverStatus, ds);
        this.addOtherChangedFieldNames(FLD_driverStatus);
    }

    public double getFuelCapacity() {
        Double v = (Double)this.getFieldValue(FLD_fuelCapacity);
        return v != null ? v : 0.0;
    }

    public void setFuelCapacity(double v) {
        this.setFieldValue(FLD_fuelCapacity, v >= 0.0 ? v : 0.0);
    }

    public double getFuelEconomy() {
        Double v = (Double)this.getFieldValue(FLD_fuelEconomy);
        return v != null ? v : 0.0;
    }

    public void setFuelEconomy(double v) {
        this.setFieldValue(FLD_fuelEconomy, v >= 0.0 ? v : 0.0);
    }

    public double getSpeedLimitKPH() {
        Double v = (Double)this.getFieldValue(FLD_speedLimitKPH);
        return v != null ? v : 0.0;
    }

    public void setSpeedLimitKPH(double v) {
        this.setFieldValue(FLD_speedLimitKPH, v >= 0.0 ? v : 0.0);
    }

    public double getPlanDistanceKM() {
        Double v = (Double)this.getFieldValue(FLD_planDistanceKM);
        return v != null ? v : 0.0;
    }

    public void setPlanDistanceKM(double v) {
        this.setFieldValue(FLD_planDistanceKM, v >= 0.0 ? v : 0.0);
    }

    public long getInstallTime() {
        Long v = (Long)this.getFieldValue(FLD_installTime);
        return v != null ? v : 0L;
    }

    public void setInstallTime(long v) {
        this.setFieldValue(FLD_installTime, v >= 0L ? v : 0L);
    }

    public long getResetTime() {
        Long v = (Long)this.getFieldValue(FLD_resetTime);
        return v != null ? v : 0L;
    }

    public void setResetTime(long v) {
        this.setFieldValue(FLD_resetTime, v >= 0L ? v : 0L);
    }

    public long getExpirationTime() {
        Long v = (Long)this.getFieldValue(FLD_expirationTime);
        return v != null ? v : 0L;
    }

    public void setExpirationTime(long v) {
        this.setFieldValue(FLD_expirationTime, v >= 0L ? v : 0L);
    }

    public boolean isExpired() {
        long expireTime = this.getExpirationTime();
        return expireTime > 0L && expireTime < DateTime.getCurrentTimeSec();
    }

    public boolean doesExpire() {
        long expireTime = this.getExpirationTime();
        return expireTime > 0L;
    }

    public boolean willExpire(long withinSec) {
        long expireTime = this.getExpirationTime();
        return expireTime > 0L && (withinSec < 0L || expireTime < DateTime.getCurrentTimeSec() + withinSec);
    }

    public static boolean supportsLinkURL() {
        return Device.getFactory().hasField(FLD_linkURL);
    }

    public boolean hasLink() {
        return !StringTools.isBlank((String)this.getLinkURL());
    }

    public String getLinkURL() {
        String v = (String)this.getOptionalFieldValue(FLD_linkURL);
        return StringTools.trim((String)v);
    }

    public void setLinkURL(String v) {
        this.setOptionalFieldValue(FLD_linkURL, StringTools.trim((String)v));
    }

    public String getLinkDescription() {
        String v = (String)this.getOptionalFieldValue(FLD_linkDescription);
        return StringTools.trim((String)v);
    }

    public void setLinkDescription(String v) {
        this.setOptionalFieldValue(FLD_linkDescription, StringTools.trim((String)v));
    }

    public static boolean supportsNotification() {
        return Device.getFactory().hasField(FLD_allowNotify);
    }

    public boolean getAllowNotify() {
        Boolean v = (Boolean)this.getOptionalFieldValue(FLD_allowNotify);
        return v != null ? v : false;
    }

    public void setAllowNotify(boolean v) {
        this.setOptionalFieldValue(FLD_allowNotify, v);
    }

    public boolean getAllowNotify(boolean checkAccount) {
        if (!checkAccount) {
            return this.getAllowNotify();
        }
        if (!RTConfig.getBoolean((String)"Device.checkAccountAllowNotify", (boolean)false)) {
            return this.getAllowNotify();
        }
        Account acct = this.getAccount();
        return acct != null ? acct.getAllowNotify() : false;
    }

    public long getLastNotifyTime() {
        Long v = (Long)this.getOptionalFieldValue(FLD_lastNotifyTime);
        return v != null ? v : 0L;
    }

    public void setLastNotifyTime(long v) {
        this.setOptionalFieldValue(FLD_lastNotifyTime, v);
    }

    public int getLastNotifyCode() {
        Integer v = (Integer)this.getOptionalFieldValue(FLD_lastNotifyCode);
        return v != null ? v : 0;
    }

    public void setLastNotifyCode(int v) {
        this.setOptionalFieldValue(FLD_lastNotifyCode, v);
    }

    public String getLastNotifyRule() {
        String v = (String)this.getOptionalFieldValue(FLD_lastNotifyRule);
        return StringTools.trim((String)v);
    }

    public void setLastNotifyRule(String v) {
        this.setOptionalFieldValue(FLD_lastNotifyRule, StringTools.trim((String)v));
    }

    public void setLastNotifyEvent(long timestamp, String ruleID, boolean update) throws DBException {
        if (timestamp >= 0L) {
            this.setLastNotifyTime(timestamp);
            this.setLastNotifyCode(0);
        } else {
            this.setLastNotifyTime(0L);
            this.setLastNotifyCode(0);
        }
        this.setLastNotifyRule(ruleID);
        if (update) {
            this.update(new String[]{FLD_lastNotifyTime, FLD_lastNotifyCode, FLD_lastNotifyRule});
        } else {
            this.addOtherChangedFieldNames(FLD_lastNotifyTime, FLD_lastNotifyCode, FLD_lastNotifyRule);
        }
    }

    public void setLastNotifyEvent(EventData event, String ruleID, boolean update) throws DBException {
        if (event != null) {
            this.setLastNotifyTime(event.getTimestamp());
            this.setLastNotifyCode(event.getStatusCode());
        } else {
            this.setLastNotifyTime(0L);
            this.setLastNotifyCode(0);
        }
        this.setLastNotifyRule(ruleID);
        if (update) {
            this.update(new String[]{FLD_lastNotifyTime, FLD_lastNotifyCode, FLD_lastNotifyRule});
        } else {
            this.addOtherChangedFieldNames(FLD_lastNotifyTime, FLD_lastNotifyCode, FLD_lastNotifyRule);
        }
    }

    public void clearLastNotifyEvent(boolean update) throws DBException {
        this.setLastNotifyEvent(null, "", update);
    }

    public EventData getLastNotifyEvent() {
        long ts = this.getLastNotifyTime();
        int sc = this.getLastNotifyCode();
        if (ts <= 0L || sc <= 0) {
            return null;
        }
        String A = this.getAccountID();
        String D = this.getDeviceID();
        try {
            EventData ev = EventData.getEventData(A, D, ts, sc);
            if (ev == null) {
                Print.logWarn((String)("LastNofityEvent not found: " + A + "/" + D + ", " + ts + " " + StatusCodes.ToString(sc)), (Object[])new Object[0]);
                return null;
            }
            return ev;
        }
        catch (DBException dbe) {
            Print.logError((String)("Error reading Device notify event [" + A + "/" + D + "]: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            return null;
        }
    }

    public String getNotifyEmail() {
        String v = (String)this.getOptionalFieldValue(FLD_notifyEmail);
        return StringTools.trim((String)v);
    }

    public void setNotifyEmail(String v) {
        this.setOptionalFieldValue(FLD_notifyEmail, StringTools.trim((String)v));
    }

    public String getNotifyEmail(boolean inclAccount, boolean inclUser) {
        String ae;
        Account acct;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNotifyEmail());
        if (inclAccount && (acct = this.getAccount()) != null && !StringTools.isBlank((String)(ae = acct.getNotifyEmail()))) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(ae);
        }
        if (inclUser) {
            User user = this.getAssignedUser();
            try {
                String ue;
                if (user != null && user.isAuthorizedDevice(this.getDeviceID()) && !StringTools.isBlank((String)(ue = user.getNotifyEmail()))) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(ue);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Checking User authorization", (Throwable)dbe);
            }
        }
        return sb.toString();
    }

    public String getNotifySelector() {
        String v = (String)this.getOptionalFieldValue(FLD_notifySelector);
        return StringTools.trim((String)v);
    }

    public void setNotifySelector(String v) {
        this.setOptionalFieldValue(FLD_notifySelector, StringTools.trim((String)v));
    }

    public int getNotifyAction() {
        Integer v = (Integer)this.getOptionalFieldValue(FLD_notifyAction);
        return v != null ? RuleFactoryAdapter.ValidateActionMask(v) : 263;
    }

    public void setNotifyAction(int v) {
        this.setOptionalFieldValue(FLD_notifyAction, RuleFactoryAdapter.ValidateActionMask(v));
    }

    public String getNotifyDescription() {
        String v = (String)this.getOptionalFieldValue(FLD_notifyDescription);
        return StringTools.trim((String)v);
    }

    public void setNotifyDescription(String v) {
        this.setOptionalFieldValue(FLD_notifyDescription, StringTools.trim((String)v));
    }

    public String getNotifySubject() {
        String v = (String)this.getFieldValue(FLD_notifySubject);
        return v != null ? v : "";
    }

    public void setNotifySubject(String v) {
        this.setFieldValue(FLD_notifySubject, v != null ? v : "");
    }

    public String getNotifyText() {
        String v = (String)this.getFieldValue(FLD_notifyText);
        return v != null ? v : "";
    }

    public void setNotifyText(String v) {
        String s = v != null ? StringTools.encodeNewline((String)v) : "";
        this.setFieldValue(FLD_notifyText, s);
    }

    public boolean getNotifyUseWrapper() {
        if (ALLOW_USE_EMAIL_WRAPPER) {
            Boolean v = (Boolean)this.getFieldValue(FLD_notifyUseWrapper);
            return v != null ? v : true;
        }
        return false;
    }

    public void setNotifyUseWrapper(boolean v) {
        this.setFieldValue(FLD_notifyUseWrapper, v);
    }

    public int getNotifyPriority() {
        Integer v = (Integer)this.getOptionalFieldValue(FLD_notifyPriority);
        return v != null ? v : 0;
    }

    public void setNotifyPriority(int v) {
        this.setOptionalFieldValue(FLD_notifyPriority, v < 0 ? 0 : v);
    }

    public void clearParkedLocation(boolean update) throws DBException {
        this.setParkedLocation(null, 0.0, update);
    }

    public void setParkedLocation(GeoPoint parkLoc, double parkRadM, boolean update) throws DBException {
        String adID = this.getAccountID() + "/" + this.getDeviceID();
        if (!GeoPoint.isValid((GeoPoint)parkLoc) || parkRadM <= 0.0) {
            Print.logInfo((String)("[" + adID + "] Clearing parked location"), (Object[])new Object[0]);
            this.setParkedLatitude(0.0);
            this.setParkedLongitude(0.0);
            this.setParkedRadius(0.0);
        } else {
            Print.logInfo((String)("[" + adID + "] Setting parked location: " + parkLoc + " " + parkRadM + " m"), (Object[])new Object[0]);
            this.setParkedLatitude(parkLoc.getLatitude());
            this.setParkedLongitude(parkLoc.getLongitude());
            this.setParkedRadius(parkRadM);
        }
        if (update) {
            this.update(new String[]{FLD_parkedLatitude, FLD_parkedLongitude, FLD_parkedRadius});
        } else {
            this.addOtherChangedFieldNames(FLD_parkedLatitude, FLD_parkedLongitude, FLD_parkedRadius);
        }
    }

    public void saveParkedLocation() throws DBException {
        this.update(new String[]{FLD_parkedLatitude, FLD_parkedLongitude, FLD_parkedRadius});
    }

    public boolean isParked() {
        if (this.getParkedRadius() <= 0.0) {
            return false;
        }
        return GeoPoint.isValid((double)this.getParkedLatitude(), (double)this.getParkedLongitude());
    }

    public boolean isParkedViolation(GeoPoint gp) {
        if (!GeoPoint.isValid((GeoPoint)gp)) {
            return false;
        }
        double parkLat = this.getParkedLatitude();
        double parkLon = this.getParkedLongitude();
        double parkRad = this.getParkedRadius();
        if (!GeoPoint.isValid((double)parkLat, (double)parkLon) || parkRad <= 0.0) {
            return false;
        }
        GeoPoint parkLoc = new GeoPoint(parkLat, parkLon);
        double distM = parkLoc.metersToPoint(gp);
        return distM > parkRad;
    }

    public double getParkedLatitude() {
        return this.getOptionalFieldValue(FLD_parkedLatitude, 0.0);
    }

    public void setParkedLatitude(double v) {
        this.setOptionalFieldValue(FLD_parkedLatitude, v);
    }

    public double getParkedLongitude() {
        return this.getOptionalFieldValue(FLD_parkedLongitude, 0.0);
    }

    public void setParkedLongitude(double v) {
        this.setOptionalFieldValue(FLD_parkedLongitude, v);
    }

    public GeoPoint getParkedLocation() {
        double pLat = this.getParkedLatitude();
        double pLon = this.getParkedLongitude();
        double pRad = this.getParkedRadius();
        if (pRad > 0.0 && GeoPoint.isValid((double)pLat, (double)pLon)) {
            return new GeoPoint(pLat, pLon);
        }
        return GeoPoint.INVALID_GEOPOINT;
    }

    public double getParkedRadius() {
        return this.getOptionalFieldValue(FLD_parkedRadius, 0.0);
    }

    public void setParkedRadius(double v) {
        this.setOptionalFieldValue(FLD_parkedRadius, v);
    }

    public String getParkedAddress() {
        return "";
    }

    public void setParkedAddress(String v) {
    }

    public static boolean supportsBorderCrossing() {
        return Device.getFactory().hasField(FLD_borderCrossing);
    }

    public int getBorderCrossing() {
        Integer v = (Integer)this.getOptionalFieldValue(FLD_borderCrossing);
        return v != null ? v : 0;
    }

    public void setBorderCrossing(int flags) {
        this.setOptionalFieldValue(FLD_borderCrossing, flags);
    }

    public void setBorderCrossing(BorderCrossingState bcs) {
        int bcf = bcs != null ? bcs.getIntValue() : BorderCrossingState.OFF.getIntValue();
        this.setBorderCrossing(bcf);
    }

    public long getLastBorderCrossTime() {
        Long v = (Long)this.getOptionalFieldValue(FLD_lastBorderCrossTime);
        return v != null ? v : 0L;
    }

    public void setLastBorderCrossTime(long v) {
        this.setOptionalFieldValue(FLD_lastBorderCrossTime, v);
    }

    public String getModemID() {
        if (StringTools.isBlank((String)this.modemID)) {
            String imei = this.getImeiNumber();
            if (CHECK_IMEI_FOR_MODEM_ID && !StringTools.isBlank((String)imei)) {
                this.modemID = imei;
            } else {
                String uniqID = this.getUniqueID();
                if (!StringTools.isBlank((String)uniqID)) {
                    int p = uniqID.indexOf("_");
                    if (p < 0) {
                        p = uniqID.indexOf("-");
                    }
                    this.modemID = p < 0 ? uniqID : uniqID.substring(p + 1);
                }
            }
        }
        return this.modemID;
    }

    public void setModemID(String mid) {
        this.modemID = StringTools.trim((String)mid);
    }

    @Override
    public String getUniqueID() {
        String v = (String)this.getFieldValue(FLD_uniqueID);
        return StringTools.trim((String)v);
    }

    public void setUniqueID(String v) {
        this.setFieldValue(FLD_uniqueID, StringTools.trim((String)v));
    }

    @Override
    public String getDeviceCode() {
        String v = (String)this.getFieldValue(FLD_deviceCode);
        return StringTools.trim((String)v);
    }

    @Override
    public void setDeviceCode(String v) {
        this.setFieldValue(FLD_deviceCode, StringTools.trim((String)v));
    }

    @Override
    public String getDeviceType() {
        String v = (String)this.getFieldValue(FLD_deviceType);
        return StringTools.trim((String)v);
    }

    @Override
    public void setDeviceType(String v) {
        this.setFieldValue(FLD_deviceType, StringTools.trim((String)v));
    }

    public String getDcsPropertiesID() {
        String v = (String)this.getFieldValue(FLD_dcsPropertiesID);
        return StringTools.trim((String)v);
    }

    public void setDcsPropertiesID(String v) {
        this.setFieldValue(FLD_dcsPropertiesID, StringTools.trim((String)v));
    }

    public static String GetDcsPropertiesID(Device device) {
        if (device == null) {
            return "";
        }
        String dcsPropsID = device.getDcsPropertiesID();
        if (!StringTools.isBlank((String)dcsPropsID)) {
            return dcsPropsID;
        }
        Account account = device.getAccount();
        if (account != null && !StringTools.isBlank((String)(dcsPropsID = account.getDcsPropertiesID()))) {
            return dcsPropsID;
        }
        return "";
    }

    public String getDcsCommandHost() {
        String v = (String)this.getFieldValue(FLD_dcsCommandHost);
        return StringTools.trim((String)v);
    }

    public boolean hasDcsCommandHost() {
        return !StringTools.isBlank((String)this.getDcsCommandHost());
    }

    public void setDcsCommandHost(String v) {
        this.setFieldValue(FLD_dcsCommandHost, StringTools.trim((String)v));
    }

    public boolean hasPushpinID() {
        return !StringTools.isBlank((String)this.getPushpinID());
    }

    public String getPushpinID() {
        String v = (String)this.getFieldValue(FLD_pushpinID);
        return StringTools.trim((String)v);
    }

    public void setPushpinID(String v) {
        this.setFieldValue(FLD_pushpinID, StringTools.trim((String)v));
    }

    public boolean hasDisplayColor() {
        return !StringTools.isBlank((String)this.getDisplayColor());
    }

    public String getDisplayColor() {
        String v = (String)this.getFieldValue(FLD_displayColor);
        return StringTools.trim((String)v);
    }

    public ColorTools.RGB getDisplayColor(ColorTools.RGB dft) {
        return ColorTools.parseColor((String)this.getDisplayColor(), (ColorTools.RGB)dft);
    }

    public void setDisplayColor(ColorTools.RGB v) {
        this.setDisplayColor(v != null ? v.toString(true) : null);
    }

    public void setDisplayColor(String v) {
        this.setFieldValue(FLD_displayColor, StringTools.trim((String)v));
    }

    public String getMapLegend() {
        return "";
    }

    public void setMapLegend(String legend) {
    }

    @Override
    public String getSerialNumber() {
        String v = (String)this.getFieldValue(FLD_serialNumber);
        return StringTools.trim((String)v);
    }

    @Override
    public void setSerialNumber(String v) {
        this.setFieldValue(FLD_serialNumber, StringTools.trim((String)v));
    }

    @Override
    public String getSimPhoneNumber() {
        String v = (String)this.getFieldValue(FLD_simPhoneNumber);
        return StringTools.trim((String)v);
    }

    @Override
    public void setSimPhoneNumber(String v) {
        this.setFieldValue(FLD_simPhoneNumber, StringTools.trim((String)v));
    }

    public static List<String> getDeviceIDsForSimPhoneNumber(String simPhone) throws DBException {
        return Device.getDeviceIDsForSimPhoneNumber(simPhone, '\u0000');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getDeviceIDsForSimPhoneNumber(String simPhone, char sepCH) throws DBException {
        Statement stmt;
        DBConnection dbc;
        Vector<String> devList;
        block17: {
            String sep;
            String string = sep = sepCH == '\u0000' ? "," : String.valueOf(sepCH);
            if (StringTools.isBlank((String)simPhone)) {
                throw new DBException("SIM phone number not specified");
            }
            devList = new Vector<String>();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(Device.getFactory());
                dsel.setSelectedFields(new String[]{"accountID", "deviceID", FLD_simPhoneNumber});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE(dwh.EQ(FLD_simPhoneNumber, (Object)simPhone)));
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String acctId = rs.getString("accountID");
                    String devId = rs.getString("deviceID");
                    devList.add(acctId + sep + devId);
                }
                if (rs == null) break block17;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Get Device SimPhoneNumber", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return devList;
    }

    public String getSimID() {
        String v = (String)this.getFieldValue(FLD_simID);
        return StringTools.trim((String)v);
    }

    public void setSimID(String v) {
        this.setFieldValue(FLD_simID, StringTools.trim((String)v));
    }

    @Override
    public String getSmsEmail() {
        String v = (String)this.getFieldValue(FLD_smsEmail);
        return StringTools.trim((String)v);
    }

    @Override
    public void setSmsEmail(String v) {
        this.setFieldValue(FLD_smsEmail, StringTools.trim((String)v));
    }

    @Override
    public String getImeiNumber() {
        String v = (String)this.getFieldValue(FLD_imeiNumber);
        return StringTools.trim((String)v);
    }

    @Override
    public void setImeiNumber(String v) {
        this.setFieldValue(FLD_imeiNumber, StringTools.trim((String)v));
    }

    public boolean validateDataKey(String pin) {
        String dkey = this.getDataKey();
        return !StringTools.isBlank((String)dkey) ? dkey.equals(pin) : true;
    }

    public String getDataKey() {
        String v = (String)this.getFieldValue(FLD_dataKey);
        return StringTools.trim((String)v);
    }

    public byte[] getDataKeyAsByteArray() {
        String dk = this.getDataKey();
        if (dk.startsWith("0x") || dk.startsWith("0X")) {
            return StringTools.parseHex((String)dk, null);
        }
        return dk.getBytes();
    }

    public void setDataKey(String v) {
        this.setFieldValue(FLD_dataKey, StringTools.trim((String)v));
    }

    public boolean getLastInputState(int bit) {
        long mask = this.getLastInputState();
        DCServerConfig dcs = this.getDCServerConfig();
        if (dcs != null) {
            return dcs.getDigitalInputState(mask, bit);
        }
        return (mask & 1L << bit) != 0L;
    }

    @Override
    public long getLastInputState() {
        Long v = (Long)this.getFieldValue(FLD_lastInputState);
        return v != null ? v : 0L;
    }

    @Override
    public void setLastInputState(long v) {
        this.setFieldValue(FLD_lastInputState, v & 0xFFFFFFFFL);
    }

    public boolean getLastOutputState(int bit) {
        long mask = this.getLastOutputState();
        DCServerConfig dcs = this.getDCServerConfig();
        if (dcs != null) {
            return dcs.getDigitalOutputState(mask, bit);
        }
        return (mask & 1L << bit) != 0L;
    }

    @Override
    public long getLastOutputState() {
        Long v = (Long)this.getFieldValue(FLD_lastOutputState);
        return v != null ? v : 0L;
    }

    @Override
    public void setLastOutputState(long v) {
        this.setFieldValue(FLD_lastOutputState, v & 0xFFFFFFFFL);
    }

    public boolean getStatusCodeStateBit(int bit) {
        long mask = this.getStatusCodeState();
        return (mask & 1L << bit) != 0L;
    }

    public void setStatusCodeStateBit(int bit, boolean state) {
        long mask = this.getStatusCodeState();
        mask = state ? (mask |= 1L << bit) : (mask &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        this.setStatusCodeState(mask);
    }

    public long getStatusCodeState() {
        Long v = (Long)this.getFieldValue(FLD_statusCodeState);
        return v != null ? v : 0L;
    }

    public void setStatusCodeState(long v) {
        this.setFieldValue(FLD_statusCodeState, v);
    }

    public double getLastBatteryLevel() {
        Double v = (Double)this.getFieldValue(FLD_lastBatteryLevel);
        return v != null ? v : 0.0;
    }

    public void setLastBatteryLevel(double v) {
        this.setFieldValue(FLD_lastBatteryLevel, v >= 0.0 ? v : 0.0);
    }

    public double getLastFuelLevel() {
        Double v = (Double)this.getFieldValue(FLD_lastFuelLevel);
        return v != null ? v : 0.0;
    }

    public void setLastFuelLevel(double v) {
        this.setFieldValue(FLD_lastFuelLevel, v >= 0.0 ? v : 0.0);
    }

    public double getLastFuelTotal() {
        Double v = (Double)this.getFieldValue(FLD_lastFuelTotal);
        return v != null ? v : 0.0;
    }

    public void setLastFuelTotal(double v) {
        this.setFieldValue(FLD_lastFuelTotal, v >= 0.0 ? v : 0.0);
    }

    public double getFuelUsedInRange(long startTime, long endTime) {
        long limit = 5L;
        long timeOfs = 120L;
        if (startTime <= 0L) {
            return -1.0;
        }
        Object evStrBest = null;
        try {
            Object[] evStr = this.getRangeEvents(startTime - timeOfs, -1L, null, false, EventData.LimitType.FIRST, limit);
            if (ListTools.isEmpty((Object[])evStr)) {
                return -1.0;
            }
            for (int i = 0; i < evStr.length; ++i) {
                long ts = ((EventData)evStr[i]).getTimestamp();
                double fuelUsed = ((EventData)evStr[i]).getFuelTotal();
                if (fuelUsed > 0.0) {
                    evStrBest = evStr[i];
                }
                if (ts >= startTime && evStrBest != null) break;
            }
            if (evStrBest == null) {
                return -1.0;
            }
        }
        catch (DBException dbe) {
            Print.logException((String)"Getting starting fuel events", (Throwable)dbe);
            return -1.0;
        }
        Object evEndBest = null;
        try {
            Object[] evEnd = this.getRangeEvents(-1L, endTime > 0L ? endTime + timeOfs : -1L, null, false, EventData.LimitType.LAST, limit);
            if (ListTools.isEmpty((Object[])evEnd)) {
                return -1.0;
            }
            for (int i = evEnd.length - 1; i >= 0; --i) {
                long ts = ((EventData)evEnd[i]).getTimestamp();
                double fuelUsed = ((EventData)evEnd[i]).getFuelTotal();
                if (fuelUsed > 0.0) {
                    evEndBest = evEnd[i];
                }
                if ((endTime <= 0L || ts <= endTime) && evEndBest != null) break;
            }
            if (evStrBest == null) {
                return -1.0;
            }
        }
        catch (DBException dbe) {
            Print.logException((String)"Getting ending fuel events", (Throwable)dbe);
            return -1.0;
        }
        double fuelUsedStr = ((EventData)evStrBest).getFuelTotal();
        double fuelUsedEnd = ((EventData)evEndBest).getFuelTotal();
        if (fuelUsedEnd >= fuelUsedStr) {
            return fuelUsedEnd - fuelUsedStr;
        }
        return -1.0;
    }

    public double getLastOilLevel() {
        Double v = (Double)this.getFieldValue(FLD_lastOilLevel);
        return v != null ? v : 0.0;
    }

    public void setLastOilLevel(double v) {
        this.setFieldValue(FLD_lastOilLevel, v >= 0.0 ? v : 0.0);
    }

    @Override
    public int getIgnitionIndex() {
        Integer v = (Integer)this.getFieldValue(FLD_ignitionIndex);
        return v != null ? v : -1;
    }

    @Override
    public void setIgnitionIndex(int v) {
        int ignNdx = this.getIgnitionIndex();
        if (ignNdx != v) {
            this.setFieldValue(FLD_ignitionIndex, v >= 0 ? v : -1);
            this.setLastIgnitionOnTime(0L);
            this.setLastIgnitionOffTime(0L);
        }
    }

    @Override
    public int[] getIgnitionStatusCodes() {
        int ndx = this.getIgnitionIndex();
        if (ndx >= 0) {
            int scOFF = StatusCodes.GetDigitalInputStatusCode(ndx, false);
            int scON = StatusCodes.GetDigitalInputStatusCode(ndx, true);
            if (scOFF != 0) {
                return new int[]{scOFF, scON};
            }
            return null;
        }
        return null;
    }

    public int getCurrentIgnitionState() {
        boolean checkSC = RTConfig.getBoolean((String)"Device.checkLastEventIgnitionState", (boolean)CHECK_LAST_EVENT_IGNITION);
        return this.getCurrentIgnitionState(checkSC, true);
    }

    public int getCurrentIgnitionState(boolean checkSC, boolean update) {
        int ignNdx;
        if (this.cacheIgnitionState >= -1) {
            return this.cacheIgnitionState;
        }
        long lastIgnOn = this.getLastIgnitionOnTime();
        long lastIgnOff = this.getLastIgnitionOffTime();
        if (lastIgnOn > 0L && lastIgnOff > 0L) {
            if (lastIgnOn > lastIgnOff) {
                this.cacheIgnitionState = 1;
                return this.cacheIgnitionState;
            }
            if (lastIgnOff > lastIgnOn) {
                this.cacheIgnitionState = 0;
                return this.cacheIgnitionState;
            }
        }
        if ((ignNdx = this.getIgnitionIndex()) < 0) {
            this.cacheIgnitionState = -1;
            return this.cacheIgnitionState;
        }
        if (ignNdx < 99) {
            this.cacheIgnitionState = this.getLastInputState(ignNdx) ? 1 : 0;
            return this.cacheIgnitionState;
        }
        int[] ignSC = this.getIgnitionStatusCodes();
        if (ignSC == null) {
            this.cacheIgnitionState = -1;
            return this.cacheIgnitionState;
        }
        if (checkSC) {
            block22: {
                try {
                    EventData ev = this.getLastEvent(ignSC);
                    if (ev == null) {
                        this.cacheIgnitionState = -1;
                        break block22;
                    }
                    if (ev.getStatusCode() == ignSC[0]) {
                        this.cacheIgnitionState = 0;
                        long ignTS = ev.getTimestamp();
                        this.setLastIgnitionOffTime(ignTS);
                        if (ignTS < this.getLastIgnitionOnTime()) {
                            this.setLastIgnitionOnTime(0L);
                        }
                        boolean didUpdate = false;
                        if (update) {
                            try {
                                this.update(new String[]{FLD_lastIgnitionOnTime, FLD_lastIgnitionOffTime});
                                didUpdate = true;
                            }
                            catch (DBException dbe) {
                                didUpdate = false;
                            }
                        }
                        if (!didUpdate) {
                            this.addOtherChangedFieldNames(FLD_lastIgnitionOnTime, FLD_lastIgnitionOffTime);
                        }
                        break block22;
                    }
                    if (ev.getStatusCode() != ignSC[1]) break block22;
                    this.cacheIgnitionState = 1;
                    long ignTS = ev.getTimestamp();
                    this.setLastIgnitionOnTime(ignTS);
                    if (ignTS < this.getLastIgnitionOffTime()) {
                        this.setLastIgnitionOffTime(0L);
                    }
                    boolean didUpdate = false;
                    if (update) {
                        try {
                            this.update(new String[]{FLD_lastIgnitionOnTime, FLD_lastIgnitionOffTime});
                            didUpdate = true;
                        }
                        catch (DBException dbe) {
                            didUpdate = false;
                        }
                    }
                    if (!didUpdate) {
                        this.addOtherChangedFieldNames(FLD_lastIgnitionOnTime, FLD_lastIgnitionOffTime);
                    }
                }
                catch (DBException dbe) {
                    this.cacheIgnitionState = -1;
                }
            }
            return this.cacheIgnitionState;
        }
        this.cacheIgnitionState = -1;
        return this.cacheIgnitionState;
    }

    public int getIgnitionStateAsOfEvent(EventData ev) {
        boolean checkSC = RTConfig.getBoolean((String)"Device.checkLastEventIgnitionState", (boolean)CHECK_LAST_EVENT_IGNITION);
        return this.getIgnitionStateAsOfEvent(ev, checkSC);
    }

    public int getIgnitionStateAsOfEvent(EventData ev, boolean checkSC) {
        if (ev == null) {
            return this.getCurrentIgnitionState();
        }
        int ignNdx = this.getIgnitionIndex();
        if (ignNdx < 0) {
            return -1;
        }
        if (ignNdx < 99) {
            long mask = ev.getInputMask();
            DCServerConfig dcs = this.getDCServerConfig();
            if (dcs != null) {
                return dcs.getDigitalInputState(mask, ignNdx) ? 1 : 0;
            }
            return (mask & 1L << ignNdx) != 0L ? 1 : 0;
        }
        int[] ignSC = this.getIgnitionStatusCodes();
        if (ignSC == null) {
            return -1;
        }
        if (ev.getStatusCode() == ignSC[0]) {
            return 0;
        }
        if (ev.getStatusCode() == ignSC[1]) {
            return 1;
        }
        if (checkSC) {
            try {
                EventData priorEV = this.getLastEvent(ignSC, ev.getTimestamp(), false);
                if (priorEV != null) {
                    return priorEV.getStatusCode() == ignSC[1] ? 1 : 0;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getEventIgnitionState(EventData ev) {
        boolean evntIgnState;
        if (ev == null) {
            return -1;
        }
        int ignNdx = this.getIgnitionIndex();
        if (ignNdx < 0) {
            return -1;
        }
        if (ignNdx >= 99) {
            int evSC = ev.getStatusCode();
            int[] ignSC = this.getIgnitionStatusCodes();
            if (ignSC == null) {
                return -1;
            }
            if (evSC == ignSC[0]) {
                return 0;
            }
            if (evSC == ignSC[1]) {
                return 1;
            }
            return -1;
        }
        boolean lastIgnState = this.getLastInputState(ignNdx);
        if (lastIgnState == (evntIgnState = ev.getInputMaskBitState(ignNdx))) {
            return -1;
        }
        if (evntIgnState) {
            return 1;
        }
        return 0;
    }

    public boolean getDigitalInputIgnitionState(long gpioInput) {
        if (gpioInput < 0L) {
            return false;
        }
        int bitNdx = this.getIgnitionIndex();
        if (bitNdx < 0 || bitNdx > 63) {
            return false;
        }
        return (gpioInput & 1L << bitNdx) != 0L;
    }

    @Override
    public String getCodeVersion() {
        String v = (String)this.getFieldValue(FLD_codeVersion);
        return StringTools.trim((String)v);
    }

    @Override
    public void setCodeVersion(String v) {
        this.setFieldValue(FLD_codeVersion, StringTools.trim((String)v));
    }

    @Override
    public String getFeatureSet() {
        String v = (String)this.getFieldValue(FLD_featureSet);
        return StringTools.trim((String)v);
    }

    @Override
    public void setFeatureSet(String v) {
        this.setFieldValue(FLD_featureSet, StringTools.trim((String)v));
    }

    @Override
    public DTIPAddrList getIpAddressValid() {
        DTIPAddrList v = (DTIPAddrList)((Object)this.getFieldValue(FLD_ipAddressValid));
        return v;
    }

    @Override
    public void setIpAddressValid(DTIPAddrList v) {
        this.setFieldValue(FLD_ipAddressValid, (Object)v);
    }

    public void setIpAddressValid(String v) {
        this.setIpAddressValid(v != null ? new DTIPAddrList(v) : null);
    }

    @Override
    public boolean isValidIPAddress(String ipAddr) {
        DTIPAddrList ipList = this.getIpAddressValid();
        if (ipList == null || ipList.isEmpty()) {
            return true;
        }
        return ipList.isMatch(ipAddr);
    }

    public boolean hasLastTcpSessionID() {
        return !StringTools.isBlank((String)this.getLastTcpSessionID());
    }

    public String getLastTcpSessionID() {
        String v = (String)this.getFieldValue(FLD_lastTcpSessionID);
        return StringTools.trim((String)v);
    }

    public void setLastTcpSessionID(String v) {
        this.setFieldValue(FLD_lastTcpSessionID, StringTools.trim((String)v));
    }

    @Override
    public DTIPAddress getIpAddressCurrent() {
        DTIPAddress v = (DTIPAddress)((Object)this.getFieldValue(FLD_ipAddressCurrent));
        return v;
    }

    public void setIpAddressCurrent(DTIPAddress v) {
        this.setFieldValue(FLD_ipAddressCurrent, (Object)v);
    }

    @Override
    public void setIpAddressCurrent(String v) {
        this.setIpAddressCurrent(v != null ? new DTIPAddress(v) : null);
    }

    @Override
    public int getRemotePortCurrent() {
        Integer v = (Integer)this.getFieldValue(FLD_remotePortCurrent);
        return v != null ? v : 0;
    }

    @Override
    public void setRemotePortCurrent(int v) {
        this.setFieldValue(FLD_remotePortCurrent, v > 0 ? v : 0);
    }

    @Override
    public int getListenPortCurrent() {
        Integer v = (Integer)this.getFieldValue(FLD_listenPortCurrent);
        return v != null ? v : 0;
    }

    @Override
    public void setListenPortCurrent(int v) {
        this.setFieldValue(FLD_listenPortCurrent, v > 0 ? v : 0);
    }

    public double getLastValidLatitude() {
        return this.getOptionalFieldValue(FLD_lastValidLatitude, 0.0);
    }

    public void setLastValidLatitude(double v) {
        this.setOptionalFieldValue(FLD_lastValidLatitude, v);
    }

    public double getLastValidLongitude() {
        return this.getOptionalFieldValue(FLD_lastValidLongitude, 0.0);
    }

    public void setLastValidLongitude(double v) {
        this.setOptionalFieldValue(FLD_lastValidLongitude, v);
    }

    public double getLastValidSpeed() {
        return this.getOptionalFieldValue(FLD_lastValidSpeed, 0.0);
    }

    public void setLastValidSpeed(double v) {
        this.setOptionalFieldValue(FLD_lastValidSpeed, v);
    }

    public boolean hasLastValidLocation() {
        double lat = this.getLastValidLatitude();
        double lon = this.getLastValidLongitude();
        return GeoPoint.isValid((double)lat, (double)lon);
    }

    public GeoPoint getLastValidLocation() {
        double lon;
        double lat = this.getLastValidLatitude();
        return GeoPoint.isValid((double)lat, (double)(lon = this.getLastValidLongitude())) ? new GeoPoint(lat, lon) : null;
    }

    public GeoPoint getLastValidLocation(boolean tryLastEvent) {
        GeoPoint gp = this.getLastValidLocation();
        if (gp == null && tryLastEvent) {
            try {
                EventData lastEv = this.getLastEvent(true);
                if (lastEv != null && lastEv.isValidGeoPoint()) {
                    gp = lastEv.getGeoPoint();
                    this.setLastValidLocation(lastEv.getTimestamp(), lastEv.getGeoPoint(), lastEv.getHeading());
                    if (this.getLastOdometerKM() <= 0.0) {
                        double odomKM = lastEv.getOdometerKM();
                        this.setLastOdometerKM(odomKM);
                    }
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return gp;
    }

    private void setLastValidLocation(long timestamp, GeoPoint gp, double heading) {
        if (gp != null && gp.isValid()) {
            this.setLastGPSTimestamp(timestamp);
            this.setLastValidLatitude(gp.getLatitude());
            this.setLastValidLongitude(gp.getLongitude());
            if (heading >= 0.0) {
                this.setLastValidHeading(heading);
            }
        } else {
            this.setLastGPSTimestamp(0L);
            this.setLastValidLatitude(0.0);
            this.setLastValidLongitude(0.0);
            this.setLastValidHeading(0.0);
        }
    }

    public double getMetersToLastValidLocation(GeoPoint gp) {
        GeoPoint lastValidLoc;
        if (GeoPoint.isValid((GeoPoint)gp) && (lastValidLoc = this.getLastValidLocation(true)) != null) {
            return gp.metersToPoint(lastValidLoc);
        }
        return -1.0;
    }

    public boolean isNearLastValidLocation(GeoPoint gp, double meters) {
        if (meters > 0.0) {
            double deltaM = this.getMetersToLastValidLocation(gp);
            return deltaM >= 0.0 && deltaM < meters;
        }
        return false;
    }

    public String getLastValidAddress() {
        return "";
    }

    public double getLastValidHeading() {
        return this.getOptionalFieldValue(FLD_lastValidHeading, 0.0);
    }

    public void setLastValidHeading(double v) {
        this.setOptionalFieldValue(FLD_lastValidHeading, v);
    }

    public long getLastGPSTimestamp() {
        Long v = (Long)this.getFieldValue(FLD_lastGPSTimestamp);
        return v != null ? v : 0L;
    }

    public void setLastGPSTimestamp(long v) {
        this.setFieldValue(FLD_lastGPSTimestamp, v);
    }

    public long getLastEventTimestamp() {
        Long v = (Long)this.getFieldValue(FLD_lastEventTimestamp);
        return v != null ? v : 0L;
    }

    public void setLastEventTimestamp(long v) {
        this.setFieldValue(FLD_lastEventTimestamp, v);
    }

    public boolean isOldEventTimestamp(long timestamp) {
        if (timestamp <= 0L) {
            return true;
        }
        if (timestamp < this.getLastGPSTimestamp()) {
            return true;
        }
        return timestamp < this.getLastEventTimestamp();
    }

    public static boolean supportsEventsPerSecond() {
        return Device.getFactory().hasField(FLD_lastEventsPerSecond);
    }

    public double getLastEventsPerSecond() {
        Double v = (Double)this.getOptionalFieldValue(FLD_lastEventsPerSecond);
        return v != null ? v : 0.0;
    }

    public void setLastEventsPerSecond(double v) {
        this.setOptionalFieldValue(FLD_lastEventsPerSecond, v);
    }

    public double getAgedEventsPerSecond(long ageMS) {
        Device.initEventsPerSecond();
        long epst = this.getLastEventsPerSecondMS();
        double epms = this.getLastEventsPerSecond() / 1000.0;
        double deltaVal = ageMS - epst;
        if (deltaVal > 0.0) {
            double AGE_A = Math.pow(1.0 - EPS_ALPHA, deltaVal);
            epms = AGE_A * epms;
        }
        return epms * 1000.0;
    }

    public long getLastEventsPerSecondMS() {
        Long v = (Long)this.getOptionalFieldValue(FLD_lastEventsPerSecondMS);
        return v != null ? v : 0L;
    }

    public void setLastEventsPerSecondMS(long v) {
        this.setOptionalFieldValue(FLD_lastEventsPerSecondMS, v);
    }

    private void _countEventsPerSecond() {
        if (!Device.supportsEventsPerSecond()) {
            return;
        }
        Device.initEventsPerSecond();
        long nowTimeMS = System.currentTimeMillis();
        long lastEvTimeMS = this.getLastEventsPerSecondMS();
        double epsLastEPS = this.getLastEventsPerSecond();
        double deltaMS = nowTimeMS - lastEvTimeMS;
        double deltaSec = deltaMS / 1000.0;
        double deltaVal = deltaMS;
        double newVal = 0.0;
        try {
            double thisVal = 1.0;
            double agedVal = epsLastEPS / 1000.0;
            if (deltaVal > 0.0) {
                double AGE_A = Math.pow(1.0 - EPS_ALPHA, deltaVal);
                agedVal = AGE_A * agedVal;
            }
            newVal = EPS_ALPHA * thisVal + agedVal;
        }
        catch (Throwable th) {
            newVal = 0.0;
        }
        this.setLastEventsPerSecond(newVal * 1000.0);
        this.setLastEventsPerSecondMS(nowTimeMS);
        this.addOtherChangedFieldNames(FLD_lastEventsPerSecond, FLD_lastEventsPerSecondMS);
    }

    public String getLastCellServingInfo() {
        String v = (String)this.getFieldValue(FLD_lastCellServingInfo);
        return StringTools.trim((String)v);
    }

    public void setLastCellServingInfo(String v) {
        this.setFieldValue(FLD_lastCellServingInfo, StringTools.trim((String)v));
    }

    public void setLastServingCellTower(CellTower sct) {
        if (sct != null) {
            this.setLastCellServingInfo(sct.toString());
        } else {
            this.setLastCellServingInfo(null);
        }
    }

    public CellTower getLastServingCellTower() {
        String csi = this.getLastCellServingInfo();
        if (!StringTools.isBlank((String)csi)) {
            return new CellTower(csi);
        }
        return null;
    }

    public List<GeozoneTransition> checkGeozoneTransitions(long eventTime, GeoPoint eventGP) {
        if (!GeoPoint.isValid((GeoPoint)eventGP)) {
            return null;
        }
        if (eventTime < 2L) {
            return null;
        }
        if (this.isOldEventTimestamp(eventTime)) {
            return null;
        }
        String deviceID = this.getDeviceID();
        String accountID = this.getAccountID();
        GeoPoint prevGP = this.getLastValidLocation(true);
        boolean GET_GEOZONE_FOR_DEVICE = true;
        Geozone prevZone = null;
        try {
            Geozone gz;
            prevZone = GET_GEOZONE_FOR_DEVICE ? Geozone.getGeozoneForDevice(accountID, prevGP, deviceID) : ((gz = Geozone.getGeozone(accountID, null, prevGP, false)) != null && gz.isDeviceInGroup(deviceID) ? gz : null);
        }
        catch (DBException dbe) {
            Print.logException((String)"Geozone error (previous zone)", (Throwable)dbe);
            prevZone = null;
        }
        Geozone thisZone = null;
        try {
            Geozone gz;
            thisZone = GET_GEOZONE_FOR_DEVICE ? Geozone.getGeozoneForDevice(accountID, eventGP, deviceID) : ((gz = Geozone.getGeozone(accountID, null, eventGP, false)) != null && gz.isDeviceInGroup(deviceID) ? gz : null);
        }
        catch (DBException dbe) {
            Print.logException((String)"Geozone error (current zone)", (Throwable)dbe);
            thisZone = null;
        }
        Vector<GeozoneTransition> geoTrans = null;
        if (prevZone != null && thisZone == null) {
            String devID = null;
            boolean isDepart = prevZone.isDepartureZone(devID);
            if (isDepart) {
                geoTrans = new Vector<GeozoneTransition>();
                geoTrans.add(new GeozoneTransition(eventTime - 2L, GEOZONE_DEPART, prevZone));
            }
            return geoTrans;
        }
        if (prevZone == null && thisZone != null) {
            String devID = null;
            boolean isArrive = thisZone.isArrivalZone(devID);
            if (isArrive) {
                geoTrans = new Vector();
                geoTrans.add(new GeozoneTransition(eventTime - 1L, GEOZONE_ARRIVE, thisZone));
            }
            return geoTrans;
        }
        if (prevZone != null && thisZone != null && !prevZone.getGeozoneID().equals(thisZone.getGeozoneID())) {
            String devID = null;
            boolean isDepart = prevZone.isDepartureZone(devID);
            boolean isArrive = thisZone.isArrivalZone(devID);
            if (isDepart || isArrive) {
                geoTrans = new Vector();
                if (isDepart) {
                    geoTrans.add(new GeozoneTransition(eventTime - 2L, GEOZONE_DEPART, prevZone));
                }
                if (isArrive) {
                    geoTrans.add(new GeozoneTransition(eventTime - 1L, GEOZONE_ARRIVE, thisZone));
                }
            }
            return geoTrans;
        }
        return null;
    }

    public double getLastDistanceKM() {
        return this.getOptionalFieldValue(FLD_lastDistanceKM, 0.0);
    }

    public void setLastDistanceKM(double distKM) {
        if (distKM < this.getMaxOdometerKM()) {
            this.setOptionalFieldValue(FLD_lastDistanceKM, distKM);
        }
    }

    public double getMaxOdometerKM() {
        return Device.GetMaximumOdometerKM();
    }

    public static boolean supportsLastOdometer() {
        return Device.getFactory().hasField(FLD_lastOdometerKM);
    }

    public double getLastOdometerKM() {
        return this.getOptionalFieldValue(FLD_lastOdometerKM, 0.0);
    }

    public void setLastOdometerKM(double odomKM) {
        if (odomKM < this.getMaxOdometerKM()) {
            this.setOptionalFieldValue(FLD_lastOdometerKM, odomKM);
        }
    }

    public double getNextOdometerKM(GeoPoint geoPoint) {
        GeoPoint lastValidLoc = this.getLastValidLocation(true);
        double odomKM = this.getLastOdometerKM();
        if (GeoPoint.isValid((GeoPoint)geoPoint) && lastValidLoc != null) {
            odomKM += geoPoint.kilometersToPoint(lastValidLoc);
        }
        return odomKM;
    }

    public double adjustOdometerKM(double odomKM) {
        return this.adjustOdometerKM(odomKM, Device.GetCheckLastOdometer());
    }

    public double adjustOdometerKM(double odomKM, boolean checkLast) {
        double lastOdomKM = this.getLastOdometerKM();
        if (checkLast && odomKM < lastOdomKM) {
            return lastOdomKM;
        }
        if (odomKM >= this.getMaxOdometerKM()) {
            return lastOdomKM;
        }
        return odomKM;
    }

    public double calculateOdometerKM(double odomKM, long fixtime, boolean validGPS, GeoPoint geoPoint, boolean estimate, boolean logInfo) {
        if (this.isOldEventTimestamp(fixtime)) {
            double d = odomKM = estimate ? 0.0 : this.adjustOdometerKM(odomKM);
            if (logInfo) {
                Print.logInfo((String)("OdometerKM: " + odomKM + " (old event)"), (Object[])new Object[0]);
            }
        } else if (odomKM <= 0.0 || estimate) {
            double d = odomKM = estimate && validGPS ? this.getNextOdometerKM(geoPoint) : this.getLastOdometerKM();
            if (logInfo) {
                Print.logInfo((String)("OdometerKM: " + odomKM + " (estimated)"), (Object[])new Object[0]);
            }
        } else {
            odomKM = this.adjustOdometerKM(odomKM);
            if (logInfo) {
                Print.logInfo((String)("OdometerKM: " + odomKM + " (actual)"), (Object[])new Object[0]);
            }
        }
        return odomKM;
    }

    public double getOdometerOffsetKM() {
        return this.getOptionalFieldValue(FLD_odometerOffsetKM, 0.0);
    }

    public void setOdometerOffsetKM(double v) {
        if (v < this.getMaxOdometerKM()) {
            this.setOptionalFieldValue(FLD_odometerOffsetKM, v);
        }
    }

    public long getLastEngineOnTime() {
        Long v = (Long)this.getFieldValue(FLD_lastEngineOnTime);
        return v != null ? v : 0L;
    }

    public void setLastEngineOnTime(long v) {
        this.setFieldValue(FLD_lastEngineOnTime, v);
    }

    public long getLastEngineOffTime() {
        Long v = (Long)this.getFieldValue(FLD_lastEngineOffTime);
        return v != null ? v : 0L;
    }

    public void setLastEngineOffTime(long v) {
        this.setFieldValue(FLD_lastEngineOffTime, v);
    }

    public double getMaxRuntimeHours() {
        return Device.GetMaximumRuntimeHours();
    }

    public static boolean supportsLastEngineHours() {
        return Device.getFactory().hasField(FLD_lastEngineHours);
    }

    public double getLastEngineHours() {
        return this.getOptionalFieldValue(FLD_lastEngineHours, 0.0);
    }

    public void setLastEngineHours(double v) {
        if (v < this.getMaxRuntimeHours()) {
            this.setOptionalFieldValue(FLD_lastEngineHours, v);
        }
    }

    public double getEngineHoursOffset() {
        return this.getOptionalFieldValue(FLD_engineHoursOffset, 0.0);
    }

    public void setEngineHoursOffset(double v) {
        this.setOptionalFieldValue(FLD_engineHoursOffset, v);
    }

    public long getLastIgnitionOnTime() {
        Long v = (Long)this.getFieldValue(FLD_lastIgnitionOnTime);
        return v != null ? v : 0L;
    }

    public void setLastIgnitionOnTime(long v) {
        this.setFieldValue(FLD_lastIgnitionOnTime, v);
    }

    public long getLastIgnitionOffTime() {
        Long v = (Long)this.getFieldValue(FLD_lastIgnitionOffTime);
        return v != null ? v : 0L;
    }

    public void setLastIgnitionOffTime(long v) {
        this.setFieldValue(FLD_lastIgnitionOffTime, v);
    }

    public double getLastIgnitionHours() {
        return this.getOptionalFieldValue(FLD_lastIgnitionHours, 0.0);
    }

    public void setLastIgnitionHours(double v) {
        this.setOptionalFieldValue(FLD_lastIgnitionHours, v);
    }

    public long getLastStopTime() {
        Long v = (Long)this.getFieldValue(FLD_lastStopTime);
        return v != null ? v : 0L;
    }

    public void setLastStopTime(long v) {
        this.setFieldValue(FLD_lastStopTime, v);
    }

    public boolean isStopped() {
        long stopTime = this.getLastStopTime();
        if (stopTime <= 0L) {
            return false;
        }
        return stopTime > this.getLastStartTime();
    }

    public EventData getLastStopEvent() {
        long st = this.getLastStopTime();
        if (st <= 0L || st <= this.getLastStartTime()) {
            return null;
        }
        try {
            Object[] ev = this.getRangeEvents(st, st, null, false, EventData.LimitType.FIRST, -1L);
            if (ListTools.isEmpty((Object[])ev)) {
                Print.logWarn((String)("Last stopped time event not found: " + st), (Object[])new Object[0]);
                return null;
            }
            for (Object evt : ev) {
                if (!((EventData)evt).isStopEvent(true)) continue;
                return evt;
            }
            Print.logWarn((String)("LastStopEvent is not a stop-event! " + st), (Object[])new Object[0]);
            return null;
        }
        catch (DBException dbe) {
            Print.logException((String)"Getting last stop event", (Throwable)dbe);
            return null;
        }
    }

    public long getLastStartTime() {
        Long v = (Long)this.getFieldValue(FLD_lastStartTime);
        return v != null ? v : 0L;
    }

    public void setLastStartTime(long v) {
        this.setFieldValue(FLD_lastStartTime, v);
    }

    public boolean getLastMalfunctionLamp() {
        Boolean v = (Boolean)this.getFieldValue(FLD_lastMalfunctionLamp);
        return v != null ? v : true;
    }

    public void setLastMalfunctionLamp(boolean v) {
        this.setFieldValue(FLD_lastMalfunctionLamp, v);
    }

    public static boolean supportsFaultCodes() {
        return Device.getFactory().hasField(FLD_lastFaultCode) && EventData.getFactory().hasField("faultCode");
    }

    public String getLastFaultCode() {
        String v = (String)this.getFieldValue(FLD_lastFaultCode);
        return StringTools.trim((String)v);
    }

    public void setLastFaultCode(String v) {
        String fc = StringTools.trim((String)v);
        if (LastFaultCodeColumnLength > 0 && fc.length() >= LastFaultCodeColumnLength) {
            int newLen = LastFaultCodeColumnLength - 1;
            fc = fc.substring(0, newLen).trim();
        }
        this.setFieldValue(FLD_lastFaultCode, fc);
    }

    public void appendLastFaultCode(String v) {
        String lastFCStr = this.getLastFaultCode();
        if (StringTools.isBlank((String)lastFCStr)) {
            this.setLastFaultCode(v);
        } else {
            RTProperties newFC = new RTProperties(v);
            RTProperties oldFC = new RTProperties(lastFCStr);
            if (DTOBDFault.IsOBDII(oldFC)) {
                String[] newDTC = StringTools.split((String)newFC.getString(DTOBDFault.PROP_DTC, ""), (char)',');
                Object[] oldDTC = StringTools.split((String)oldFC.getString(DTOBDFault.PROP_DTC, ""), (char)',');
                boolean changed = false;
                for (String dtc : newDTC) {
                    if (StringTools.isBlank((String)dtc) || ListTools.contains((Object[])oldDTC, (Object)dtc)) continue;
                    oldDTC = (String[])ListTools.add((Object[])oldDTC, (Object)dtc);
                    changed = true;
                }
                if (changed) {
                    oldFC.setString(DTOBDFault.PROP_DTC[0], StringTools.join((String[])oldDTC, (String)","));
                    this.setLastFaultCode(oldFC.toString());
                }
            } else if (DTOBDFault.IsJ1708(oldFC)) {
                this.setLastFaultCode(v);
            } else if (DTOBDFault.IsJ1939(oldFC)) {
                this.setLastFaultCode(v);
            }
        }
    }

    public String getPingCommandURI() {
        String v = (String)this.getFieldValue(FLD_pingCommandURI);
        return StringTools.trim((String)v);
    }

    public void setPingCommandURI(String v) {
        this.setFieldValue(FLD_pingCommandURI, StringTools.trim((String)v));
    }

    public String getPendingPingCommand() {
        String v = (String)this.getFieldValue(FLD_pendingPingCommand);
        return StringTools.trim((String)v);
    }

    public String getPendingCommand() {
        return this.getPendingPingCommand();
    }

    public void setPendingPingCommand(String v) {
        this.setFieldValue(FLD_pendingPingCommand, StringTools.trim((String)v));
    }

    public void setPendingCommand(String v) {
        this.setPendingPingCommand(v);
    }

    public boolean hasPendingPingCommand() {
        return !StringTools.isBlank((String)this.getPendingPingCommand());
    }

    public boolean hasPendingCommand() {
        return this.hasPendingPingCommand();
    }

    public boolean clearPendingPingCommand(boolean update) {
        this.setPendingPingCommand(null);
        if (update) {
            try {
                this.update(new String[]{FLD_pendingPingCommand});
                return true;
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to update Device.pendingPingCommand", (Throwable)dbe);
                return false;
            }
        }
        return false;
    }

    public boolean clearPendingCommand(boolean update) {
        return this.clearPendingPingCommand(update);
    }

    @Override
    public long getLastPingTime() {
        Long v = (Long)this.getFieldValue(FLD_lastPingTime);
        return v != null ? v : 0L;
    }

    public void _setLastPingTime(long v) {
        this.setFieldValue(FLD_lastPingTime, v);
    }

    public void setLastPingTime(long v) {
        this._setLastPingTime(v);
        if (this.transport != null) {
            this.transport._setLastPingTime(v);
        }
    }

    @Override
    public int getTotalPingCount() {
        Integer v = (Integer)this.getFieldValue(FLD_totalPingCount);
        return v != null ? v : 0;
    }

    public void _setTotalPingCount(int v) {
        this.setFieldValue(FLD_totalPingCount, v);
    }

    public void setTotalPingCount(int v) {
        this._setTotalPingCount(v);
        if (this.transport != null) {
            this.transport._setTotalPingCount(v);
        }
    }

    public boolean incrementPingCount(long pingTime, boolean reload, boolean update) {
        Account account;
        if (reload) {
            this.reload(new String[]{FLD_totalPingCount});
        }
        this.setTotalPingCount(this.getTotalPingCount() + 1);
        if (pingTime > 0L) {
            this.setLastPingTime(pingTime);
        }
        if (update) {
            try {
                this.update(new String[]{FLD_lastPingTime, FLD_totalPingCount});
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to update 'ping' count", (Throwable)dbe);
                return false;
            }
        }
        if ((account = this.getAccount()) != null) {
            account.incrementPingCount(pingTime, reload, update);
        }
        return true;
    }

    @Override
    public int getMaxPingCount() {
        Integer v = (Integer)this.getFieldValue(FLD_maxPingCount);
        return v != null ? v : 0;
    }

    public void _setMaxPingCount(int v) {
        this.setFieldValue(FLD_maxPingCount, v);
    }

    public void setMaxPingCount(int v) {
        this._setMaxPingCount(v);
        if (this.transport != null) {
            this.transport._setMaxPingCount(v);
        }
    }

    public boolean exceedsMaxPingCount() {
        int totPings = this.getTotalPingCount();
        int maxPings = this.getMaxPingCount();
        if (maxPings > 0 && totPings >= maxPings) {
            Print.logInfo((String)"Device exceeded maximum allowed pings: %d >= %d", (Object[])new Object[]{totPings, maxPings});
            return true;
        }
        Account account = this.getAccount();
        if (account != null) {
            int totPings2 = account.getTotalPingCount();
            int maxPings2 = account.getMaxPingCount();
            if (maxPings2 > 0 && totPings2 >= maxPings2) {
                Print.logInfo((String)"Account exceeded maximum allowed pings: %d >= %d", (Object[])new Object[]{totPings2, maxPings2});
                return true;
            }
        }
        return false;
    }

    public long getCommandStateMask() {
        Long v = (Long)this.getFieldValue(FLD_commandStateMask);
        return v != null ? v : 0L;
    }

    public boolean getCommandStateMaskBit(int bit) {
        long v = this.getCommandStateMask();
        return (v & 1L << bit) != 0L;
    }

    public void setCommandStateMask(long v) {
        this.setFieldValue(FLD_commandStateMask, v);
        this.addOtherChangedFieldNames(FLD_commandStateMask);
    }

    public void setCommandStateBit(int bit, boolean state) {
        if (bit >= 0) {
            this._setCommandStateMask(bit << 1, state);
        }
    }

    private void _setCommandStateMask(long mask, boolean state) {
        long v = this.getCommandStateMask();
        v = state ? (v |= mask) : (v &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.setCommandStateMask(v);
    }

    public boolean getExpectAck() {
        Boolean v = (Boolean)this.getFieldValue(FLD_expectAck);
        return v != null ? v : true;
    }

    public void _setExpectAck(boolean v) {
        this.setFieldValue(FLD_expectAck, v);
        this.addOtherChangedFieldNames(FLD_expectAck);
    }

    public void setExpectAck(boolean v) {
        this._setExpectAck(v);
        if (this.transport != null) {
            this.transport._setExpectAck(v);
        }
    }

    public int getExpectAckCode() {
        Integer v = (Integer)this.getFieldValue(FLD_expectAckCode);
        return v != null ? v : 0;
    }

    public void setExpectAckCode(int v) {
        this.setFieldValue(FLD_expectAckCode, v >= 0 ? v : 0);
        this.addOtherChangedFieldNames(FLD_expectAckCode);
    }

    public boolean isAckStatusCode(int statusCode) {
        if (statusCode <= 0) {
            return false;
        }
        if (!this.isExpectingCommandAck()) {
            return false;
        }
        int ackCode = this.getExpectAckCode();
        if (ackCode <= 0) {
            return true;
        }
        return statusCode == ackCode;
    }

    public String getLastAckCommand() {
        String v = (String)this.getFieldValue(FLD_lastAckCommand);
        return StringTools.trim((String)v);
    }

    public void setLastAckCommand(String v) {
        this.setFieldValue(FLD_lastAckCommand, StringTools.trim((String)v));
    }

    public boolean isExpectingCommandAck() {
        return this.getExpectAck() && this.getLastAckTime() <= 0L;
    }

    public boolean clearExpectCommandAck(boolean didAck, boolean update) {
        if (!this.isExpectingCommandAck()) {
            Print.logInfo((String)"Device is not expecting an ACK", (Object[])new Object[0]);
            return false;
        }
        String lastAckCmd = this.getLastAckCommand();
        this.setExpectAck(false);
        this.setExpectAckCode(0);
        if (didAck) {
            this.setLastAckTime(DateTime.getCurrentTimeSec());
            Print.logInfo((String)("ACK received for command: " + lastAckCmd), (Object[])new Object[0]);
        } else {
            this.setLastAckTime(0L);
        }
        if (update) {
            try {
                this.update(new String[]{FLD_expectAck, FLD_expectAckCode, FLD_lastAckTime});
                return true;
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to set Device.lastAck...", (Throwable)dbe);
                return false;
            }
        }
        this.addOtherChangedFieldNames(FLD_expectAck, FLD_expectAckCode, FLD_lastAckTime);
        return true;
    }

    public String getLastAckResponse() {
        String v = (String)this.getFieldValue(FLD_lastAckResponse);
        return StringTools.trim((String)v);
    }

    public void setLastAckResponse(String v) {
        this.setFieldValue(FLD_lastAckResponse, StringTools.trim((String)v));
    }

    public long getLastAckTime() {
        Long v = (Long)this.getFieldValue(FLD_lastAckTime);
        return v != null ? v : 0L;
    }

    public void _setLastAckTime(long v) {
        this.setFieldValue(FLD_lastAckTime, v);
        this.addOtherChangedFieldNames(FLD_lastAckTime);
    }

    public void setLastAckTime(long v) {
        this._setLastAckTime(v);
        if (this.transport != null) {
            this.transport._setLastAckTime(v);
        }
    }

    public long getDcsConfigMask() {
        Long v = (Long)this.getOptionalFieldValue(FLD_dcsConfigMask);
        return v != null ? v : 0L;
    }

    public void setDcsConfigMask(long v) {
        this.setOptionalFieldValue(FLD_dcsConfigMask, v);
    }

    public String getDcsConfigString() {
        String v = (String)this.getOptionalFieldValue(FLD_dcsConfigString);
        return StringTools.trim((String)v);
    }

    public void setDcsConfigString(String v) {
        this.setOptionalFieldValue(FLD_dcsConfigString, StringTools.trim((String)v));
    }

    @Override
    public boolean getSupportsDMTP() {
        Boolean v = (Boolean)this.getFieldValue(FLD_supportsDMTP);
        return v != null ? v : true;
    }

    public boolean supportsDMTP() {
        return this.getSupportsDMTP();
    }

    @Override
    public void setSupportsDMTP(boolean v) {
        this.setFieldValue(FLD_supportsDMTP, v);
    }

    @Override
    public int getSupportedEncodings() {
        Integer v = (Integer)this.getFieldValue(FLD_supportedEncodings);
        return v != null ? v : (int)Transport.Encodings.BINARY.getLongValue();
    }

    @Override
    public void setSupportedEncodings(int v) {
        if ((v &= (int)EnumTools.getValueMask(Transport.Encodings.class)) == 0) {
            v = (int)Transport.Encodings.BINARY.getLongValue();
        }
        this.setFieldValue(FLD_supportedEncodings, v);
    }

    @Override
    public int getUnitLimitInterval() {
        Integer v = (Integer)this.getFieldValue(FLD_unitLimitInterval);
        return v != null ? v : 0;
    }

    public void setUnitLimitInterval(int v) {
        this.setFieldValue(FLD_unitLimitInterval, v);
    }

    @Override
    public int getMaxAllowedEvents() {
        Integer v = (Integer)this.getFieldValue(FLD_maxAllowedEvents);
        return v != null ? v : 1;
    }

    public void setMaxAllowedEvents(int v) {
        this.setFieldValue(FLD_maxAllowedEvents, v);
    }

    @Override
    public DTProfileMask getTotalProfileMask() {
        DTProfileMask v = (DTProfileMask)((Object)this.getFieldValue(FLD_totalProfileMask));
        return v;
    }

    @Override
    public void setTotalProfileMask(DTProfileMask v) {
        this.setFieldValue(FLD_totalProfileMask, (Object)v);
    }

    @Override
    public int getTotalMaxConn() {
        Integer v = (Integer)this.getFieldValue(FLD_totalMaxConn);
        return v != null ? v : 0;
    }

    public void setTotalMaxConn(int v) {
        this.setFieldValue(FLD_totalMaxConn, v);
    }

    @Override
    public int getTotalMaxConnPerMin() {
        Integer v = (Integer)this.getFieldValue(FLD_totalMaxConnPerMin);
        return v != null ? v : 0;
    }

    public void setTotalMaxConnPerMin(int v) {
        this.setFieldValue(FLD_totalMaxConnPerMin, v);
    }

    @Override
    public DTProfileMask getDuplexProfileMask() {
        DTProfileMask v = (DTProfileMask)((Object)this.getFieldValue(FLD_duplexProfileMask));
        return v;
    }

    @Override
    public void setDuplexProfileMask(DTProfileMask v) {
        this.setFieldValue(FLD_duplexProfileMask, (Object)v);
    }

    @Override
    public int getDuplexMaxConn() {
        Integer v = (Integer)this.getFieldValue(FLD_duplexMaxConn);
        return v != null ? v : 0;
    }

    public void setDuplexMaxConn(int v) {
        this.setFieldValue(FLD_duplexMaxConn, v);
    }

    @Override
    public int getDuplexMaxConnPerMin() {
        Integer v = (Integer)this.getFieldValue(FLD_duplexMaxConnPerMin);
        return v != null ? v : 0;
    }

    public void setDuplexMaxConnPerMin(int v) {
        this.setFieldValue(FLD_duplexMaxConnPerMin, v);
    }

    @Override
    public long getLastDuplexConnectTime() {
        Long v = (Long)this.getFieldValue(FLD_lastDuplexConnectTime);
        return v != null ? v : 0L;
    }

    public void _setLastDuplexConnectTime(long v) {
        this.setFieldValue(FLD_lastDuplexConnectTime, v);
    }

    @Override
    public void setLastDuplexConnectTime(long v) {
        this._setLastDuplexConnectTime(v);
        if (this.transport != null) {
            this.transport._setLastDuplexConnectTime(v);
        }
    }

    @Override
    public long getLastTotalConnectTime() {
        Long v = (Long)this.getFieldValue(FLD_lastTotalConnectTime);
        return v != null ? v : 0L;
    }

    public void _setLastTotalConnectTime(long v) {
        this.setFieldValue(FLD_lastTotalConnectTime, v);
    }

    @Override
    public void setLastTotalConnectTime(long v) {
        this._setLastTotalConnectTime(v);
        if (this.transport != null) {
            this.transport._setLastTotalConnectTime(v);
        }
    }

    public long getLastConnectTime() {
        return this.getLastTotalConnectTime();
    }

    public void setLastConnectTime(long v, boolean isDuplex) {
        this.setLastTotalConnectTime(v);
        if (isDuplex) {
            this.setLastDuplexConnectTime(v);
        }
    }

    public static boolean supportsFixedLocation() {
        return Device.getFactory().hasField(FLD_fixedLatitude);
    }

    public double getFixedLatitude() {
        return this.getOptionalFieldValue(FLD_fixedLatitude, 0.0);
    }

    public void setFixedLatitude(double v) {
        this.setOptionalFieldValue(FLD_fixedLatitude, v);
    }

    public double getFixedLongitude() {
        return this.getOptionalFieldValue(FLD_fixedLongitude, 0.0);
    }

    public void setFixedLongitude(double v) {
        this.setOptionalFieldValue(FLD_fixedLongitude, v);
    }

    public boolean hasFixedLocation() {
        return this.hasField(FLD_fixedLatitude);
    }

    public boolean isValidFixedLocation() {
        return GeoPoint.isValid((double)this.getFixedLatitude(), (double)this.getFixedLongitude());
    }

    public GeoPoint getFixedLocation() {
        return new GeoPoint(this.getFixedLatitude(), this.getFixedLongitude());
    }

    public String getFixedAddress() {
        String v = StringTools.trim((String)((String)this.getFieldValue(FLD_fixedAddress)));
        return v;
    }

    public void setFixedAddress(String v) {
        this.setFieldValue(FLD_fixedAddress, StringTools.trim((String)v));
    }

    public String getFixedContactPhone() {
        String v = StringTools.trim((String)((String)this.getFieldValue(FLD_fixedContactPhone)));
        return v;
    }

    public void setFixedContactPhone(String v) {
        this.setFieldValue(FLD_fixedContactPhone, StringTools.trim((String)v));
    }

    public long getFixedServiceTime() {
        Long v = (Long)this.getOptionalFieldValue(FLD_fixedServiceTime);
        return v != null ? v : 0L;
    }

    public void setFixedServiceTime(long v) {
        this.setOptionalFieldValue(FLD_fixedServiceTime, v);
    }

    public static boolean supportsActiveCorridor() {
        return Device.getFactory().hasField(FLD_activeCorridor);
    }

    public String getActiveCorridor() {
        String v = (String)this.getOptionalFieldValue(FLD_activeCorridor);
        return StringTools.trim((String)v);
    }

    public boolean hasActiveCorridor() {
        return !StringTools.isBlank((String)this.getActiveCorridor());
    }

    public void setActiveCorridor(String v) {
        this.setOptionalFieldValue(FLD_activeCorridor, StringTools.trim((String)v));
    }

    public static String[] getCorridorIDsForAccount(String acctId) {
        Class<?> gcClass = null;
        try {
            gcClass = Class.forName("org.opengts.rule.tables.GeoCorridor");
        }
        catch (Throwable th) {
            return null;
        }
        MethodAction gcListMeth = null;
        try {
            gcListMeth = new MethodAction(gcClass, "getCorridorIDsForAccount", new Class[]{String.class});
        }
        catch (Throwable th) {
            return null;
        }
        try {
            return (String[])gcListMeth.invoke(new Object[]{acctId});
        }
        catch (DBException dbe) {
            Print.logError((String)("DBException: " + (Object)((Object)dbe)), (Object[])new Object[0]);
        }
        finally {
            return null;
        }
    }

    public static boolean supportsPeriodicMaintenance() {
        if (Device.getPeriodicMaintOdometerCount() <= 0) {
            return false;
        }
        return Device.getFactory().hasField(FLD_maintOdometerKM0);
    }

    public static int getPeriodicMaintOdometerCount() {
        int mc = RTConfig.getInt((String)"Device.maintenanceOdometerCount", (int)MAX_MAINT_ODOM_COUNT);
        if (mc <= 0) {
            return 0;
        }
        if (mc >= MAX_MAINT_ODOM_COUNT) {
            return MAX_MAINT_ODOM_COUNT;
        }
        return mc;
    }

    public void setMaintTriggeredKM(int ndx) {
        if (ndx >= 0 && ndx < MAX_MAINT_ODOM_COUNT) {
            if (RuleMaintTrigger == null) {
                RuleMaintTrigger = new Vector();
            }
            RuleMaintTrigger.add(new Integer(ndx));
        }
    }

    public int getMaintTriggeredKM() {
        if (!ListTools.isEmpty(RuleMaintTrigger)) {
            return RuleMaintTrigger.get(0);
        }
        return -1;
    }

    public String getMaintDescriptionKM(int ndx) {
        switch (ndx) {
            case 0: {
                return this.getMaintDescriptionKM0();
            }
            case 1: {
                return this.getMaintDescriptionKM1();
            }
        }
        return "";
    }

    public double getMaintOdometerKM(int ndx) {
        switch (ndx) {
            case 0: {
                return this.getMaintOdometerKM0();
            }
            case 1: {
                return this.getMaintOdometerKM1();
            }
        }
        return 0.0;
    }

    public void resetMaintOdometerKM(int ndx) {
        switch (ndx) {
            case 0: {
                this.resetMaintOdometerKM0();
                break;
            }
            case 1: {
                this.resetMaintOdometerKM1();
            }
        }
    }

    public double getMaintIntervalKM(int ndx) {
        switch (ndx) {
            case 0: {
                return this.getMaintIntervalKM0();
            }
            case 1: {
                return this.getMaintIntervalKM1();
            }
        }
        return 0.0;
    }

    public boolean isMaintenanceDueKM(int ndx, double deltaKM) {
        double intvKM;
        double lastKM;
        double odomKM;
        return Device.supportsPeriodicMaintenance() && (odomKM = this.getLastOdometerKM()) > 0.0 && odomKM + deltaKM >= (lastKM = this.getMaintOdometerKM(ndx)) + (intvKM = this.getMaintIntervalKM(ndx));
    }

    public String getMaintDescriptionKM0() {
        return RTConfig.getString((String)"Device.maintenanceDescriptionKM.0", (String)"#1");
    }

    public double getMaintIntervalKM0() {
        return this.getOptionalFieldValue(FLD_maintIntervalKM0, 0.0);
    }

    public void setMaintIntervalKM0(double v) {
        this.setOptionalFieldValue(FLD_maintIntervalKM0, v);
    }

    public double getMaintOdometerKM0() {
        return this.getOptionalFieldValue(FLD_maintOdometerKM0, 0.0);
    }

    public void setMaintOdometerKM0(double v) {
        if (v < this.getMaxOdometerKM()) {
            this.setOptionalFieldValue(FLD_maintOdometerKM0, v >= 0.0 ? v : 0.0);
        }
    }

    public void resetMaintOdometerKM0() {
        this.setMaintOdometerKM0(this.getLastOdometerKM());
        this.addOtherChangedFieldNames(FLD_maintOdometerKM0);
    }

    public String getMaintDescriptionKM1() {
        return RTConfig.getString((String)"Device.maintenanceDescriptionKM.1", (String)"#2");
    }

    public double getMaintIntervalKM1() {
        return this.getOptionalFieldValue(FLD_maintIntervalKM1, 0.0);
    }

    public void setMaintIntervalKM1(double v) {
        this.setOptionalFieldValue(FLD_maintIntervalKM1, v);
    }

    public double getMaintOdometerKM1() {
        return this.getOptionalFieldValue(FLD_maintOdometerKM1, 0.0);
    }

    public void setMaintOdometerKM1(double v) {
        if (v < this.getMaxOdometerKM()) {
            this.setOptionalFieldValue(FLD_maintOdometerKM1, v >= 0.0 ? v : 0.0);
        }
    }

    public void resetMaintOdometerKM1() {
        this.setMaintOdometerKM1(this.getLastOdometerKM());
        this.addOtherChangedFieldNames(FLD_maintOdometerKM0);
    }

    public static int getPeriodicMaintEngHoursCount() {
        return 1;
    }

    public double getMaintEngHoursHR(int ndx) {
        switch (ndx) {
            case 0: {
                return this.getMaintEngHoursHR0();
            }
        }
        return 0.0;
    }

    public void resetMaintEngHoursHR(int ndx) {
        switch (ndx) {
            case 0: {
                this.resetMaintEngHoursHR0();
            }
        }
    }

    public double getMaintIntervalHR(int ndx) {
        switch (ndx) {
            case 0: {
                return this.getMaintIntervalHR0();
            }
        }
        return 0.0;
    }

    public boolean isMaintenanceDueHR(int ndx, double deltaHR) {
        double intvHR;
        double lastHR;
        double engHrs;
        return Device.supportsPeriodicMaintenance() && (engHrs = this.getLastEngineHours()) > 0.0 && engHrs + deltaHR >= (lastHR = this.getMaintEngHoursHR(ndx)) + (intvHR = this.getMaintIntervalHR(ndx));
    }

    public double getMaintIntervalHR0() {
        return this.getOptionalFieldValue(FLD_maintIntervalHR0, 0.0);
    }

    public void setMaintIntervalHR0(double v) {
        this.setOptionalFieldValue(FLD_maintIntervalHR0, v);
    }

    public double getMaintEngHoursHR0() {
        return this.getOptionalFieldValue(FLD_maintEngHoursHR0, 0.0);
    }

    public void setMaintEngHoursHR0(double v) {
        if (v < this.getMaxRuntimeHours()) {
            this.setOptionalFieldValue(FLD_maintEngHoursHR0, v >= 0.0 ? v : 0.0);
        }
    }

    public void resetMaintEngHoursHR0() {
        this.setMaintEngHoursHR0(this.getLastEngineHours());
        this.addOtherChangedFieldNames(FLD_maintEngHoursHR0);
    }

    public String getMaintNotes() {
        String v = (String)this.getOptionalFieldValue(FLD_maintNotes);
        return StringTools.trim((String)v);
    }

    public void setMaintNotes(String v) {
        this.setOptionalFieldValue(FLD_maintNotes, StringTools.trim((String)v));
    }

    public int getReminderType() {
        Integer v = (Integer)this.getOptionalFieldValue(FLD_reminderType);
        return v != null ? v.intValue() : ReminderType.PERIODIC_INTERVAL.getIntValue();
    }

    public void setReminderType(int v) {
        this.setOptionalFieldValue(FLD_reminderType, v);
    }

    public void setReminderType(ReminderType r) {
        int v = r != null ? r.getIntValue() : ReminderType.PERIODIC_INTERVAL.getIntValue();
        this.setReminderType(v);
    }

    public String getReminderMessage() {
        String v = (String)this.getOptionalFieldValue(FLD_reminderMessage);
        return StringTools.trim((String)v);
    }

    public void setReminderMessage(String v) {
        this.setOptionalFieldValue(FLD_reminderMessage, StringTools.trim((String)v));
    }

    public long getReminderTime() {
        Long v = (Long)this.getFieldValue(FLD_reminderTime);
        return v != null ? v : 0L;
    }

    public void setReminderTime(long v) {
        this.setFieldValue(FLD_reminderTime, v);
    }

    public String getReminderInterval() {
        String v = (String)this.getFieldValue(FLD_reminderInterval);
        return StringTools.trim((String)v);
    }

    public void setReminderInterval(String v) {
        this.setFieldValue(FLD_reminderInterval, StringTools.trim((String)v).toLowerCase());
    }

    public boolean isReminderExpired(TimeZone tz, long nowTime) {
        int remType = this.getReminderType();
        long remTime = this.getReminderTime();
        String remIntStr = this.getReminderInterval();
        return Device._isReminderExpired(remType, remTime, remIntStr, tz, nowTime);
    }

    private static boolean _isReminderExpired(int remType, long remTime, String remIntStr, TimeZone tz, long nowTime) {
        if (nowTime <= 0L) {
            if (REMINDER_LOG) {
                Print.logInfo((String)"Invalid Reminder Now Time", (Object[])new Object[0]);
            }
            return false;
        }
        if (StringTools.isBlank((String)remIntStr)) {
            if (REMINDER_LOG) {
                Print.logInfo((String)"No Reminder Interval Specified", (Object[])new Object[0]);
            }
            return false;
        }
        DateTime remDT = new DateTime(remTime, tz);
        int remDOW = remDT.getDayOfWeek();
        int remMon0 = remDT.getMonth0();
        int remYear = remDT.getYear();
        DateTime nowDT = new DateTime(nowTime, tz);
        int nowDOW = nowDT.getDayOfWeek();
        int nowMon0 = nowDT.getMonth0();
        int nowYear = nowDT.getYear();
        String[] remInt = StringTools.split((String)remIntStr, (char)',');
        for (int i = 0; i < remInt.length; ++i) {
            String rem = remInt[i].toLowerCase();
            if (StringTools.isBlank((String)rem)) {
                if (!REMINDER_LOG) continue;
                Print.logInfo((String)("Skipping blank Reminder Entry: " + i), (Object[])new Object[0]);
                continue;
            }
            if (StringTools.isLong((String)rem, (boolean)true)) {
                long interval = StringTools.parseLong((String)rem, (long)0L);
                if (interval > 0L) {
                    long nexTime = remTime + interval;
                    if (nexTime > nowTime) continue;
                    if (REMINDER_LOG) {
                        Print.logInfo((String)("Interval Reminder Expired: " + rem), (Object[])new Object[0]);
                    }
                    return true;
                }
                if (!REMINDER_LOG) continue;
                Print.logWarn((String)("Invalid Reminder Interval: " + rem), (Object[])new Object[0]);
                continue;
            }
            if (rem.startsWith("date:") || rem.indexOf("/") > 0) {
                String dateStr = rem.startsWith("date:") ? rem.substring("date:".length()) : rem;
                try {
                    DateTime dateDT = DateTime.parseArgumentDate((String)dateStr, (TimeZone)tz);
                    long dateTime = dateDT.getTimeSec();
                    if (dateTime <= remTime) {
                        if (REMINDER_LOG) {
                            Print.logInfo((String)("Date Reminder Already Expired: " + rem), (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (dateTime > nowTime) continue;
                    if (REMINDER_LOG) {
                        Print.logInfo((String)("Date Reminder Expired: " + rem), (Object[])new Object[0]);
                    }
                    return true;
                }
                catch (DateTime.DateParseException dpe) {
                    if (!REMINDER_LOG) continue;
                    Print.logWarn((String)("Invalid Reminder Date: " + rem), (Object[])new Object[0]);
                }
                continue;
            }
            int dowNdx = DateTime.getDayIndex((String)rem, (int)-1);
            if (dowNdx >= 0) {
                long nextTime;
                DateTime nextDT;
                if (dowNdx != nowDOW) continue;
                int deltaDays = dowNdx - remDOW;
                if (deltaDays <= 0) {
                    deltaDays += 7;
                }
                if ((nextDT = new DateTime(nextTime = remTime + DateTime.DaySeconds((long)deltaDays), tz)).getDayStart() > nowTime) continue;
                if (REMINDER_LOG) {
                    Print.logInfo((String)("DOW Reminder Expired: " + rem), (Object[])new Object[0]);
                }
                return true;
            }
            int monNdx0 = DateTime.getMonthIndex0((String)rem, (int)-1);
            if (monNdx0 >= 0) {
                if (monNdx0 != nowMon0) continue;
                if (remYear == nowYear && remMon0 == nowMon0) {
                    if (!REMINDER_LOG) continue;
                    Print.logInfo((String)("Reminder Already Expired: " + rem), (Object[])new Object[0]);
                    continue;
                }
                if (REMINDER_LOG) {
                    Print.logInfo((String)("Month Reminder Expired: " + rem), (Object[])new Object[0]);
                }
                return true;
            }
            if (!REMINDER_LOG) continue;
            Print.logInfo((String)("Ignoring unrecognized reminder format: " + remIntStr), (Object[])new Object[0]);
        }
        if (REMINDER_LOG) {
            Print.logInfo((String)"Reminder not expired", (Object[])new Object[0]);
        }
        return false;
    }

    public boolean isReminderExpired(TimeZone tz) {
        return this.isReminderExpired(tz, DateTime.getCurrentTimeSec());
    }

    public void resetReminder(long currentTime) {
        this.setReminderTime(currentTime);
        this.addOtherChangedFieldNames(FLD_reminderTime);
    }

    public void resetReminder() {
        this.resetReminder(DateTime.getCurrentTimeSec());
    }

    public long getLastServiceTime() {
        Long v = (Long)this.getFieldValue(FLD_lastServiceTime);
        return v != null ? v : 0L;
    }

    public void setLastServiceTime(long v) {
        this.setFieldValue(FLD_lastServiceTime, v >= 0L ? v : 0L);
    }

    public long getLastServiceDayNumber() {
        long ts = this.getLastServiceTime();
        if (ts <= 0L) {
            return 0L;
        }
        TimeZone tmz = Account.getTimeZone(this.getAccount(), DateTime.getGMTTimeZone());
        return new DateTime(ts, tmz).getDayNumber();
    }

    public long getNextServiceTime() {
        Long v = (Long)this.getFieldValue(FLD_nextServiceTime);
        return v != null ? v : 0L;
    }

    public void setNextServiceTime(long v) {
        this.setFieldValue(FLD_nextServiceTime, v >= 0L ? v : 0L);
    }

    public long getNextServiceDayNumber() {
        long ts = this.getNextServiceTime();
        if (ts <= 0L) {
            return 0L;
        }
        TimeZone tmz = Account.getTimeZone(this.getAccount(), DateTime.getGMTTimeZone());
        return new DateTime(ts, tmz).getDayNumber();
    }

    public static boolean supportsAssignedUserID() {
        return Device.getFactory().hasField(FLD_assignedUserID);
    }

    public String getAssignedUserID() {
        String v = (String)this.getOptionalFieldValue(FLD_assignedUserID);
        return StringTools.trim((String)v);
    }

    public void setAssignedUserID(String v) {
        this.setOptionalFieldValue(FLD_assignedUserID, StringTools.trim((String)v).toLowerCase());
        this.assignedUser = null;
    }

    public User getAssignedUser() {
        String userID;
        if (this.assignedUser == null && !StringTools.isBlank((String)(userID = this.getAssignedUserID()))) {
            try {
                this.assignedUser = User.getUser(this.getAccount(), userID);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this.assignedUser;
    }

    public TimeZone getAssignedUserTimeZone() {
        Account acct = this.getAccount();
        if (acct != null) {
            TimeZone tmz;
            User user = this.getAssignedUser();
            if (user != null && (tmz = DateTime.getTimeZone((String)user.getTimeZone(), null)) != null) {
                return tmz;
            }
            return acct.getTimeZone(null);
        }
        return DateTime.getGMTTimeZone();
    }

    public static boolean supportsThermalProfile() {
        return Device.getFactory().hasField(FLD_thermalProfile);
    }

    public String getThermalProfile() {
        String v = (String)this.getOptionalFieldValue(FLD_thermalProfile);
        return StringTools.trim((String)v);
    }

    public void setThermalProfile(String v) {
        this.setOptionalFieldValue(FLD_thermalProfile, StringTools.trim((String)v).toLowerCase());
    }

    public static boolean supportsHoursOfOperation() {
        return Device.getFactory().hasField(FLD_hoursOfOperation);
    }

    public boolean hasHoursOfOperation() {
        return !StringTools.isBlank((String)this.getHoursOfOperation());
    }

    public String getHoursOfOperation() {
        String v = (String)this.getOptionalFieldValue(FLD_hoursOfOperation);
        return StringTools.trim((String)v);
    }

    public void setHoursOfOperation(String v) {
        if (!StringTools.isBlank((String)v)) {
            RTProperties vRTP = new RTProperties(v.toLowerCase().replace(',', ' '));
            WorkHours wh = new WorkHours((RTConfig.PropertyGetter)vRTP, "");
            RTProperties whRTP = wh.getProperties();
            this.setOptionalFieldValue(FLD_hoursOfOperation, whRTP.toString());
        } else {
            this.setOptionalFieldValue(FLD_hoursOfOperation, "");
        }
        this.cacheWorkHours = null;
    }

    public void setHoursOfOperation(RTProperties rtp) {
        this.setHoursOfOperation(rtp != null ? rtp.toString() : (String)null);
    }

    public void setHoursOfOperation(WorkHours wh) {
        if (wh != null) {
            this.setHoursOfOperation(wh.getProperties());
        } else {
            this.setHoursOfOperation("");
        }
    }

    public WorkHours getWorkHours(WorkHours dft) {
        if (this.cacheWorkHours != null) {
            return this.cacheWorkHours;
        }
        String whStr = this.getHoursOfOperation();
        if (!StringTools.isBlank((String)whStr)) {
            this.cacheWorkHours = new WorkHours((RTConfig.PropertyGetter)new RTProperties(whStr), "");
            return this.cacheWorkHours;
        }
        return dft;
    }

    public boolean isHoursOfOperation(long ts) {
        if (ts < 0L) {
            return false;
        }
        TimeZone tz = Account.getTimeZone(this.getAccount(), null);
        DateTime dt = new DateTime(ts, tz);
        return this.isHoursOfOperation(dt, tz);
    }

    public boolean isHoursOfOperation(DateTime dt, TimeZone tz) {
        if (dt == null) {
            return false;
        }
        if (tz == null) {
            tz = Account.getTimeZone(this.getAccount(), dt.getTimeZone());
        }
        WorkHours wh = this.getWorkHours(DefaultWorkHours);
        return wh.isMatch(dt, tz);
    }

    public String getCustomAttributes() {
        String v = (String)this.getOptionalFieldValue(FLD_customAttributes);
        return StringTools.trim((String)v);
    }

    public void setCustomAttributes(String v) {
        this.setOptionalFieldValue(FLD_customAttributes, StringTools.trim((String)v));
        this.customAttrRTP = null;
        this.customAttrKeys = null;
    }

    public RTProperties getCustomAttributesRTP() {
        if (this.customAttrRTP == null) {
            this.customAttrRTP = new RTProperties(this.getCustomAttributes());
        }
        return this.customAttrRTP;
    }

    public Collection<String> getCustomAttributeKeys() {
        if (this.customAttrKeys == null) {
            this.customAttrKeys = this.getCustomAttributesRTP().getPropertyKeys(null);
        }
        return this.customAttrKeys;
    }

    public String getCustomAttribute(String key) {
        return this.getCustomAttributesRTP().getString(key, null);
    }

    public String setCustomAttribute(String key, String value) {
        return this.getCustomAttributesRTP().getString(key, value);
    }

    public String getWorkOrderID() {
        String v = (String)this.getOptionalFieldValue(FLD_workOrderID);
        return StringTools.trim((String)v);
    }

    public void setWorkOrderID(String v) {
        this.setOptionalFieldValue(FLD_workOrderID, StringTools.trim((String)v));
    }

    public String[] getWorkOrderIDs() {
        String woid = this.getWorkOrderID();
        if (StringTools.isBlank((String)woid)) {
            return new String[0];
        }
        return StringTools.split((String)woid, (char)',');
    }

    public boolean addWorkOrderID(String woid) {
        if (StringTools.isBlank((String)(woid = StringTools.trim((String)woid)))) {
            return false;
        }
        if (ListTools.containsIgnoreCase((String[])this.getWorkOrderIDs(), (String)woid)) {
            return false;
        }
        String woidStr = this.getWorkOrderID();
        if (StringTools.isBlank((String)woidStr)) {
            this.setWorkOrderID(woid);
        } else {
            String nWL = woidStr + "," + woid;
            this.setWorkOrderID(nWL);
        }
        return true;
    }

    public boolean removeWorkOrderID(String woid) {
        if (StringTools.isBlank((String)woid)) {
            return false;
        }
        Object[] W = this.getWorkOrderIDs();
        if (W.length == 0) {
            return false;
        }
        List WL = ListTools.toList((Object[])W);
        for (Object WID : W) {
            if (woid.equalsIgnoreCase((String)WID)) continue;
            WL.add(WID);
        }
        if (WL.size() == W.length) {
            return false;
        }
        String woidStr = StringTools.join((Iterable)WL, (String)",");
        this.setWorkOrderID(woidStr);
        return true;
    }

    public void setWorkOrderIDs(String[] W) {
        if (ListTools.isEmpty((Object[])W)) {
            this.setWorkOrderID("");
        } else {
            String woidStr = StringTools.join((String[])W, (String)",");
            this.setWorkOrderID(woidStr);
        }
    }

    public String getJobNumber() {
        return this.getFieldValue(FLD_jobNumber, "");
    }

    public void setJobNumber(String v) {
        this.setFieldValue(FLD_jobNumber, StringTools.trim((String)v));
        this.addOtherChangedFieldNames(FLD_jobNumber);
    }

    public boolean hasJobNumber() {
        return !StringTools.isBlank((String)this.getJobNumber());
    }

    public void setJobLocation(GeoPoint jobLoc, double jobRadM) {
        if (!GeoPoint.isValid((GeoPoint)jobLoc) || jobRadM <= 0.0) {
            this.setJobLatitude(0.0);
            this.setJobLongitude(0.0);
            this.setJobRadius(0.0);
        } else {
            this.setJobLatitude(jobLoc.getLatitude());
            this.setJobLongitude(jobLoc.getLongitude());
            this.setJobRadius(jobRadM);
        }
    }

    public boolean hasCurrentJob() {
        if (this.getJobRadius() <= 0.0) {
            return false;
        }
        return GeoPoint.isValid((double)this.getJobLatitude(), (double)this.getJobLongitude());
    }

    public boolean isImplicitJobDepart(GeoPoint gp) {
        if (!GeoPoint.isValid((GeoPoint)gp)) {
            return false;
        }
        double jobLat = this.getJobLatitude();
        double jobLon = this.getJobLongitude();
        double jobRad = this.getJobRadius();
        if (!GeoPoint.isValid((double)jobLat, (double)jobLon) || jobRad <= 0.0) {
            return false;
        }
        GeoPoint jobLoc = new GeoPoint(jobLat, jobLon);
        double distM = jobLoc.metersToPoint(gp);
        return distM > jobRad;
    }

    public double getJobLatitude() {
        return this.getOptionalFieldValue(FLD_jobLatitude, 0.0);
    }

    public void setJobLatitude(double v) {
        this.setOptionalFieldValue(FLD_jobLatitude, v);
    }

    public double getJobLongitude() {
        return this.getOptionalFieldValue(FLD_jobLongitude, 0.0);
    }

    public void setJobLongitude(double v) {
        this.setOptionalFieldValue(FLD_jobLongitude, v);
    }

    public double getJobRadius() {
        return this.getOptionalFieldValue(FLD_jobRadius, 0.0);
    }

    public void setJobRadius(double v) {
        this.setOptionalFieldValue(FLD_jobRadius, v);
    }

    public boolean supportsDataPushTime() {
        return Device.getFactory().hasField(FLD_lastDataPushTime);
    }

    public long getLastDataPushTime() {
        Long v = (Long)this.getFieldValue(FLD_lastDataPushTime);
        return v != null ? v : 0L;
    }

    public void setLastDataPushTime(long v) {
        this.setFieldValue(FLD_lastTotalConnectTime, v);
    }

    public long getLastEventCreateMillis() {
        Long v = (Long)this.getFieldValue(FLD_lastEventCreateMillis);
        return v != null ? v : 0L;
    }

    public void setLastEventCreateMillis(long v) {
        this.setFieldValue(FLD_lastEventCreateMillis, v);
    }

    public void setCreationDefaultValues() {
        this.setIsActive(true);
        this.setDescription("Nuevo dispositivo [" + this.getDeviceID() + "]");
        this.setIgnitionIndex(-1);
        if (Device.hasRuleFactory()) {
            this.setAllowNotify(true);
        }
        this.setNotifyAction(263);
        if (Device.supportsBorderCrossing()) {
            this.setBorderCrossing(BorderCrossingState.ON);
        }
        this.setSupportedEncodings(7);
        this.setTotalMaxConn(0);
        this.setDuplexMaxConn(0);
        this.setUnitLimitInterval(0);
        this.setTotalMaxConnPerMin(0);
        this.setDuplexMaxConnPerMin(0);
        this.setMaxAllowedEvents(0);
        super.setRuntimeDefaultValues();
    }

    @Override
    public String getAssocAccountID() {
        return this.getAccountID();
    }

    @Override
    public String getAssocDeviceID() {
        return this.getDeviceID();
    }

    public DCServerConfig getDCServerConfig() {
        return DCServerFactory.getServerConfig(this.getDeviceCode());
    }

    public Map<String, String> getSupportedCommands(BasicPrivateLabel privLabel, User user, String type) {
        DCServerConfig dcs = this.getDCServerConfig();
        return dcs != null ? dcs.getCommandDescriptionMap(privLabel, user, type) : null;
    }

    public boolean getStartStopSupported() {
        return this.getStartStopStatusCodes() != null;
    }

    public int[] getStartStopStatusCodes() {
        if (!this.startStopStatusCodes_init) {
            DCServerConfig dcs = this.getDCServerConfig();
            this.startStopStatusCodes = dcs != null ? dcs.getStartStopStatusCodes() : null;
            this.startStopStatusCodes_init = true;
        }
        return this.startStopStatusCodes;
    }

    public boolean isPingSupported(BasicPrivateLabel privLabel, User user) {
        DCServerConfig dcs = this.getDCServerConfig();
        if (privLabel != null && dcs != null && !privLabel.hasWriteAccess(user, dcs.getCommandsAclName())) {
            Print.logDebug((String)"User does not have access to device command handler", (Object[])new Object[0]);
            return false;
        }
        if (Device.hasPingDispatcher()) {
            boolean supported = Device.getPingDispatcher().isPingSupported(this);
            Print.logDebug((String)("Device " + this.getDeviceID() + " isPingSupported = " + supported), (Object[])new Object[0]);
            return supported;
        }
        Print.logDebug((String)("Device " + this.getDeviceID() + " does not have a command-handler"), (Object[])new Object[0]);
        return false;
    }

    public boolean sendDeviceCommand(String cmdType, String cmdName, String[] cmdArgs) {
        String ct = !StringTools.isBlank((String)cmdType) ? cmdType : "config";
        DCServerConfig dcs = this.getDCServerConfig();
        if (dcs != null) {
            RTProperties resp = DCServerFactory.sendServerCommand(this, ct, cmdName, cmdArgs);
            Print.logInfo((String)("Ping Response: " + resp), (Object[])new Object[0]);
            boolean sentOK = DCServerFactory.isCommandResultOK(resp);
            return sentOK;
        }
        if (Device.hasPingDispatcher()) {
            boolean sentOK = Device.getPingDispatcher().sendDeviceCommand(this, ct, cmdName, cmdArgs);
            return sentOK;
        }
        Print.logWarn((String)"Device has no PingDispatcher", (Object[])new Object[0]);
        return false;
    }

    public static void SetAllowSlowReverseGeocoding(boolean allow) {
        allowSlowReverseGeocode = allow;
    }

    public static boolean GetAllowSlowReverseGeocoding() {
        return allowSlowReverseGeocode;
    }

    public long getEventCount(long timeStart, long timeEnd) throws DBException {
        long count = EventData.getRecordCount(this.getAccountID(), this.getDeviceID(), timeStart, timeEnd);
        return count;
    }

    public long getEventCount() throws DBException {
        return this.getEventCount(-1L, -1L);
    }

    public void log_EventData(int logLevel, EventData ev) {
        StringBuffer sb = new StringBuffer();
        sb.append("Event: ");
        if (ev != null) {
            int sc = ev.getStatusCode();
            DateTime dt = new DateTime(ev.getTimestamp());
            String zone = ev.getGeozoneID();
            sb.append(dt.format("yyyy/MM/dd|HH:mm:ss|zzz")).append(", ");
            sb.append(ev.getAccountID()).append("|").append(ev.getDeviceID()).append(", ");
            sb.append(StatusCodes.GetHex(sc)).append("|").append(StatusCodes.GetDescription(sc, null));
            if (!StringTools.isBlank((String)zone)) {
                sb.append("|").append(zone);
            } else if (sc == 61968 || sc == 61968) {
                sb.append("|?");
            }
            sb.append(", ");
            sb.append(ev.getGeoPoint().toString('|'));
            sb.append(", ");
            sb.append(StringTools.format((double)ev.getSpeedKPH(), (String)"0.0"));
            sb.append("|");
            sb.append(StringTools.format((double)ev.getHeading(), (String)"0"));
        } else {
            sb.append("null");
        }
        Print.log((int)logLevel, (String)sb.toString());
    }

    public boolean insertEventData(EventData evdb) {
        Geozone zone;
        if (LogEventDataInsertion >= 3) {
            this.log_EventData(LogEventDataInsertion, evdb);
        }
        if (!this._insertEventData(evdb)) {
            Print.logWarn((String)"Event not inserted ...", (Object[])new Object[0]);
            return false;
        }
        int sc = evdb.getStatusCode();
        if (sc == 61968) {
            Geozone zone2 = evdb.getGeozone();
            if (this.hasActiveCorridor() && zone2 != null && zone2.isCorridorEnd(evdb)) {
                this.setActiveCorridor("");
            }
        } else if (sc == 62000 && (zone = evdb.getGeozone()) != null && zone.isCorridorStart(evdb)) {
            String corridorID = zone.getCorridorID();
            this.setActiveCorridor(corridorID);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _insertEventData(final EventData evdb) {
        double oilLevel;
        double fuelLevel;
        double battLevel;
        double evEngHours;
        double fuelTotal;
        double distKM;
        boolean hasEngSt;
        long lastEngOff;
        long lastIgnOff;
        Geozone gz;
        double evSpeedKPH2;
        double maxSpeedKPH2;
        long nowTime;
        long maxTime;
        long evTime;
        long maxFutureSec;
        int futureDateAction;
        long nowTime2;
        long minTime;
        long evTime2;
        long maxPastSec;
        Account account = this.getAccount();
        String acctID = this.getAccountID();
        String devID = this.getDeviceID();
        if (evdb == null) {
            return false;
        }
        int statusCode = evdb.getStatusCode();
        evdb.setDevice(this);
        evdb.setTransportID(this.getTransportID());
        long eventTime = evdb.getTimestamp();
        long lastEventTime = this.getLastEventTimestamp();
        if (eventTime >= 5000000000L) {
            Print.logWarn((String)("EventData time is invalid (too large): " + eventTime + " [ignoring record]"), (Object[])new Object[0]);
            return false;
        }
        if (eventTime <= 0L) {
            Print.logWarn((String)("EventData time is invalid (<=1980/01/01): " + eventTime + " [ignoring record]"), (Object[])new Object[0]);
            return false;
        }
        int pastDateAction = Device.pastEventDateAction();
        if (pastDateAction != 0 && (maxPastSec = Device.pastEventDateMaximumSec()) > 0L && (evTime2 = eventTime) < (minTime = (nowTime2 = DateTime.getCurrentTimeSec()) - maxPastSec)) {
            if (pastDateAction == -1) {
                Print.logWarn((String)("Invalid EventData past time: " + new DateTime(evTime2) + " [ignoring record per configuration]"), (Object[])new Object[0]);
                return false;
            }
            if (pastDateAction == 1) {
                long truncTime = nowTime2;
                Print.logWarn((String)("Invalid EventData past time: " + new DateTime(evTime2) + " [set/truncate to " + new DateTime(truncTime) + "]"), (Object[])new Object[0]);
                evdb.setTimestamp(truncTime);
                eventTime = truncTime;
            } else {
                Print.logWarn((String)("Invalid EventData past time: " + new DateTime(evTime2) + " [unexpected action " + pastDateAction + "]"), (Object[])new Object[0]);
            }
        }
        if ((futureDateAction = Device.futureEventDateAction()) != 0 && (maxFutureSec = Device.futureEventDateMaximumSec()) > 0L && (evTime = eventTime) > (maxTime = (nowTime = DateTime.getCurrentTimeSec()) + maxFutureSec)) {
            if (futureDateAction == -1) {
                Print.logWarn((String)("Invalid EventData future time: " + new DateTime(evTime) + " [ignoring record per configuration]"), (Object[])new Object[0]);
                return false;
            }
            if (futureDateAction == 1) {
                long truncTime = nowTime;
                Print.logWarn((String)("Invalid EventData future time: " + new DateTime(evTime) + " [set/truncate to " + new DateTime(truncTime) + "]"), (Object[])new Object[0]);
                evdb.setTimestamp(truncTime);
                eventTime = truncTime;
            } else {
                Print.logWarn((String)("Invalid EventData future time: " + new DateTime(evTime) + " [unexpected action " + futureDateAction + "]"), (Object[])new Object[0]);
            }
        }
        boolean isOldEvent = eventTime < lastEventTime;
        int invalidSpeedAction = Device.invalidSpeedAction();
        if (invalidSpeedAction != 0 && (maxSpeedKPH2 = Device.invalidSpeedMaximumKPH()) > 0.0 && (evSpeedKPH2 = evdb.getSpeedKPH()) > maxSpeedKPH2) {
            if (invalidSpeedAction == -1) {
                Print.logWarn((String)("Invalid EventData speed: " + evSpeedKPH2 + " km/h [ignoring/skipping record per config]"), (Object[])new Object[0]);
                return false;
            }
            if (invalidSpeedAction == 1) {
                Print.logWarn((String)("Invalid EventData speed: " + evSpeedKPH2 + " km/h [set/truncate to " + maxSpeedKPH2 + "]"), (Object[])new Object[0]);
                evdb.setSpeedKPH(maxSpeedKPH2);
            } else if (invalidSpeedAction == 2) {
                Print.logWarn((String)("Invalid EventData speed: " + evSpeedKPH2 + " km/h [set to 0.0]"), (Object[])new Object[0]);
                evdb.setSpeedKPH(0.0);
            } else {
                Print.logWarn((String)("Invalid EventData speed: " + evSpeedKPH2 + " km/h [unexpected action " + invalidSpeedAction + "]"), (Object[])new Object[0]);
            }
        }
        if (statusCode == 0) {
            if (ENABLE_LOAD_TESTING) {
                double eps;
                long deltaSec;
                if (loadTestingTime == null) {
                    Object maxSpeedKPH2 = loadTestingLock;
                    synchronized (maxSpeedKPH2) {
                        if (loadTestingTime == null) {
                            loadTestingTime = new DateTime();
                        }
                    }
                }
                if ((deltaSec = DateTime.getCurrentTimeSec() - loadTestingTime.getTimeSec()) > 60L) {
                    Object evSpeedKPH2 = loadTestingLock;
                    synchronized (evSpeedKPH2) {
                        loadTestingTime = new DateTime();
                        loadTestingCount = 0L;
                        deltaSec = 0L;
                    }
                }
                double d = eps = deltaSec > 0L ? (double)loadTestingCount / (double)deltaSec : (double)(++loadTestingCount);
                if (loadTestingCount % 50L == 0L) {
                    System.err.println("EventData LoadTest (" + eps + " ev/sec)");
                }
            }
            return true;
        }
        int extUpdate = 0;
        if (Device.UpdateEventWithGeozoneLocation() && !evdb.isValidGeoPoint() && evdb.hasGeozoneID() && statusCode != 62000 && statusCode != 62080 && (gz = evdb.getGeozone()) != null) {
            GeoPoint gp = gz.getCenterGeoPoint();
            evdb.setGeoPoint(gp);
        }
        if (!evdb.isValidGeoPoint() && evdb.canUpdateCellTowerLocation()) {
            CellTower dct;
            boolean ALWAYS_UPDATE_CELLGPS = true;
            CellTower cellTower = dct = !ALWAYS_UPDATE_CELLGPS ? this.getLastServingCellTower() : null;
            if (dct == null) {
                extUpdate |= 1;
            } else if (!dct.equals(evdb.getServingCellTower())) {
                extUpdate |= 1;
            } else {
                MobileLocation ml = dct.getMobileLocation();
                if (ml != null && ml.isValid()) {
                    GeoPoint mgp = ml.getGeoPoint();
                    double acc = ml.getAccuracy();
                    evdb.setCellGeoPoint(mgp);
                    evdb.setCellAccuracy(acc);
                    Print.logInfo((String)("Using cached CellTower location: " + mgp + " [+/- " + acc + " meters]"), (Object[])new Object[0]);
                } else {
                    Print.logInfo((String)"Using cached CellTower location: no location", (Object[])new Object[0]);
                }
            }
        }
        try {
            Set<String> updFields = evdb.updateAddress(true);
            if (updFields != null) {
                BasicPrivateLabel privLabel = account.getPrivateLabel();
                ReverseGeocodeProvider rgp = privLabel.getReverseGeocodeProvider();
                String rgName = rgp != null ? rgp.getName() : "???";
                Print.logInfo((String)"EventData address: [%s/%s:%s] %s: %s", (Object[])new Object[]{this.getAccountID(), this.getDeviceID(), rgName, evdb.getGeoPoint().toString(), evdb.getAddress()});
            }
        }
        catch (SlowOperationException soe) {
            if (allowSlowReverseGeocode) {
                extUpdate |= 2;
            }
        }
        catch (Throwable th) {
            Print.logException((String)"Address update error", (Throwable)th);
        }
        long lastStopTime = this.getLastStopTime();
        long lastStartTime = this.getLastStartTime();
        long nextStopTime = 0L;
        long nextStartTime = 0L;
        if (lastStartTime > lastStopTime) {
            if (evdb.isStopEvent(true)) {
                evdb.setStopped(true);
                nextStopTime = eventTime;
            } else {
                evdb.setStopped(false);
            }
        } else if (lastStopTime > lastStartTime) {
            if (evdb.isStartEvent(true)) {
                evdb.setStopped(false);
                nextStartTime = eventTime;
            } else {
                evdb.setStopped(true);
            }
        } else if (evdb.isStopEvent(true)) {
            evdb.setStopped(true);
            nextStopTime = eventTime;
        } else if (evdb.isStartEvent(true)) {
            evdb.setStopped(false);
            nextStartTime = eventTime;
        } else if (evdb.getSpeedKPH() <= 0.0) {
            evdb.setStopped(true);
            nextStopTime = eventTime;
        } else {
            evdb.setStopped(false);
            nextStartTime = eventTime;
        }
        if (!evdb.isInputMaskExplicitlySet()) {
            evdb.setInputMask(this.getLastInputState());
        }
        if (!evdb.isOutputMaskExplicitlySet()) {
            evdb.setOutputMask(this.getLastOutputState());
        }
        double ignHours = this.getLastIgnitionHours();
        long lastIgnOn = this.getLastIgnitionOnTime();
        if (lastIgnOn < (lastIgnOff = this.getLastIgnitionOffTime())) {
            lastIgnOn = 0L;
        } else if (lastIgnOff < lastIgnOn) {
            lastIgnOff = 0L;
        }
        boolean hasIgnSt = lastIgnOn > 0L || lastIgnOff > 0L;
        int ignStateCh = this.getEventIgnitionState(evdb);
        if (lastIgnOn > 0L && eventTime > lastIgnOn) {
            double runHrs = (double)(eventTime - lastIgnOn) / 3600.0;
            ignHours += runHrs;
        }
        double engHours = this.getLastEngineHours();
        long lastEngOn = this.getLastEngineOnTime();
        if (lastEngOn < (lastEngOff = this.getLastEngineOffTime())) {
            lastEngOn = 0L;
        } else if (lastEngOff < lastEngOn) {
            lastEngOff = 0L;
        }
        boolean bl = hasEngSt = lastEngOn > 0L || lastEngOff > 0L;
        if (lastEngOn > 0L && eventTime > lastEngOn) {
            double runHrs = (double)(eventTime - lastEngOn) / 3600.0;
            engHours += runHrs;
        }
        if (Device.GetSimulateEngineHours(this)) {
            if (evdb.getEngineHours() > 0.0) {
                Print.logInfo((String)("[" + acctID + "/" + devID + "] SimEngHours: Event engine-hours already set (leaving as-is)"), (Object[])new Object[0]);
            } else if (hasEngSt && engHours > 0.0) {
                Print.logInfo((String)("[" + acctID + "/" + devID + "] SimEngHours: Event engine-hours set to " + engHours + " hours (based on Engine On/Off)"), (Object[])new Object[0]);
                evdb.setEngineHours(engHours);
            } else if (hasIgnSt && ignHours > 0.0) {
                Print.logInfo((String)("[" + acctID + "/" + devID + "] SimEngHours: Event engine-hours set to " + ignHours + " hours (based on Ignition On/Off)"), (Object[])new Object[0]);
                evdb.setEngineHours(ignHours);
            } else {
                Print.logInfo((String)("[" + acctID + "/" + devID + "] SimEngHours: No available engine/ignition hours"), (Object[])new Object[0]);
                evdb.setEngineHours(engHours);
            }
        }
        String driverID = null;
        long driverStatus = -1L;
        boolean saveDriverID = false;
        boolean saveDriverStatus = false;
        if (Device.GetSaveEventDriverID()) {
            if (evdb.hasDriverID()) {
                driverID = evdb.getDriverID();
                saveDriverID = true;
                if (evdb.hasDriverStatus()) {
                    driverStatus = evdb.getDriverStatus();
                    saveDriverStatus = true;
                } else if (this.isDriverID(driverID)) {
                    driverStatus = this.getDriverStatus();
                    evdb.setDriverStatus(driverStatus);
                } else {
                    driverStatus = -1L;
                    saveDriverStatus = true;
                }
            } else if (this.hasDriverID()) {
                driverID = this.getDriverID();
                evdb.setDriverID(driverID);
                if (this.hasDriverStatus()) {
                    driverStatus = this.getDriverStatus();
                    evdb.setDriverStatus(driverStatus);
                } else {
                    driverStatus = -1L;
                    evdb.setDriverStatus(driverStatus);
                }
            }
        }
        evdb.setOdometerOffsetKM(this.getOdometerOffsetKM());
        if (statusCode == 57793) {
            String aid = evdb.getAccountID();
            String did = evdb.getDeviceID();
            long ts = evdb.getTimestamp();
            try {
                for (int sc : StatusCodes.GFMI_StopStatus) {
                    EventData gfmiEV = EventData.getEventData(aid, did, ts, sc);
                    if (gfmiEV == null) {
                        if (sc != statusCode) {
                            statusCode = sc;
                            evdb.setStatusCode(statusCode);
                        }
                    } else {
                        if (gfmiEV.getStopID() != evdb.getStopID() && gfmiEV.getStopStatus() != evdb.getStopStatus()) continue;
                        if (sc != statusCode) {
                            statusCode = sc;
                            evdb.setStatusCode(statusCode);
                        }
                    }
                    break;
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to read GFMI StopStatus events", (Throwable)dbe);
            }
        }
        try {
            evdb.save();
        }
        catch (DBException dbe) {
            Print.logError((String)("EventData save failed: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            return false;
        }
        if (extUpdate != 0) {
            final int extUpd = extUpdate;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    Device.this._postEventInsertionProcessing(evdb, extUpd);
                }
            };
            ThreadPool_DeviceEventUpdate.run(job);
            Print.logDebug((String)"Address update queued for background operation", (Object[])new Object[0]);
        }
        if (this.checkEventRules(evdb)) {
            // empty if block
        }
        this._countEventsPerSecond();
        this.setLastEventTimestamp(evdb.getTimestamp());
        if (evdb.isValidGeoPoint()) {
            this.setLastValidLatitude(evdb.getLatitude());
            this.setLastValidLongitude(evdb.getLongitude());
            this.setLastValidHeading(evdb.getHeading());
            this.setLastGPSTimestamp(evdb.getTimestamp());
        }
        if (nextStopTime > 0L) {
            this.setLastStopTime(nextStopTime);
        }
        if (nextStartTime > 0L) {
            this.setLastStartTime(nextStartTime);
        }
        if (evdb.hasMalfunctionLamp()) {
            this.setLastMalfunctionLamp(evdb.getMalfunctionLamp());
        }
        if (evdb.hasFaultCode()) {
            this.appendLastFaultCode(evdb.getFaultCode());
        }
        if (!((distKM = evdb.getDistanceKM()) < 0.0)) {
            this.setLastDistanceKM(distKM);
        }
        double odomKM = evdb.getOdometerKM();
        if (!(odomKM < 0.0) && odomKM != 0.0) {
            this.setLastOdometerKM(odomKM);
        }
        if (!((fuelTotal = evdb.getFuelTotal()) < 0.0) && fuelTotal != 0.0) {
            this.setLastFuelTotal(fuelTotal);
        }
        if (!((evEngHours = evdb.getEngineHours()) < 0.0) && evEngHours != 0.0) {
            this.setLastEngineHours(evEngHours);
        }
        if (statusCode == 62476) {
            this.setLastEngineOnTime(eventTime);
            this.setLastEngineOffTime(0L);
        } else if (statusCode == 62477) {
            this.setLastEngineOnTime(0L);
            this.setLastEngineOffTime(eventTime);
        }
        if (ignStateCh == 1) {
            if (lastIgnOn > 0L) {
                Print.logWarn((String)("Ignition-ON event found, without interleaving Ignition-OFF: " + acctID + "/" + devID), (Object[])new Object[0]);
            } else {
                this.setLastIgnitionOnTime(eventTime);
            }
            if (eventTime < this.getLastIgnitionOffTime()) {
                Print.logWarn((String)("Event time is prior to last Ignition-OFF! " + acctID + "/" + devID), (Object[])new Object[0]);
                this.setLastIgnitionOffTime(0L);
            }
        } else if (ignStateCh == 0) {
            if (lastIgnOff > 0L) {
                Print.logWarn((String)("Ignition-OFF event found, without interleaving Ignition-ON: " + acctID + "/" + devID), (Object[])new Object[0]);
            } else {
                this.setLastIgnitionOffTime(eventTime);
                this.setLastIgnitionHours(ignHours);
            }
            if (eventTime < this.getLastIgnitionOnTime()) {
                Print.logWarn((String)("Event time is prior to last Ignition-ON! " + acctID + "/" + devID), (Object[])new Object[0]);
                this.setLastIgnitionOnTime(0L);
            }
        }
        if (!((battLevel = evdb.getBatteryLevel()) < 0.0) && battLevel != 0.0) {
            this.setLastBatteryLevel(battLevel);
        }
        if (!((fuelLevel = evdb.getFuelLevel(true)) < 0.0) && fuelLevel != 0.0) {
            this.setLastFuelLevel(fuelLevel);
        }
        if (!((oilLevel = evdb.getOilLevel()) < 0.0) && oilLevel != 0.0) {
            this.setLastOilLevel(oilLevel);
        }
        if (saveDriverID) {
            this.setDriverID(driverID);
            if (saveDriverStatus) {
                this.setDriverStatus(driverStatus);
            }
            try {
                Driver.updateDriverStatus(account, driverID, driverStatus);
            }
            catch (DBException dbe) {
                Print.logError((String)("Driver status save failed: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            }
        }
        if (this.isAckStatusCode(statusCode)) {
            String ad = this.getAccountID() + "/" + this.getDeviceID();
            Print.logInfo((String)("ACK status code match [" + ad + "]: " + StatusCodes.GetHex(statusCode)), (Object[])new Object[0]);
            this.clearExpectCommandAck(true, false);
        }
        return true;
    }

    private void _postEventInsertionProcessing(EventData evdb, int extUpdate) {
        Set<String> updf;
        HashSet<String> updatedEvFields = null;
        if ((extUpdate & 1) != 0 && (updf = evdb.updateCellTowerLocation()) != null) {
            if (updatedEvFields == null) {
                updatedEvFields = new HashSet<String>();
            }
            updatedEvFields.addAll(updf);
            CellTower sct = evdb.getServingCellTower();
            if (sct != null) {
                this.setLastServingCellTower(sct);
                try {
                    this.update(new String[]{FLD_lastCellServingInfo});
                }
                catch (DBException dbe) {
                    Print.logError((String)("Unable to update Device: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                }
                if (allowSlowReverseGeocode) {
                    extUpdate |= 2;
                }
            }
        }
        if ((extUpdate & 2) != 0) {
            try {
                updf = evdb.updateAddress(false);
                if (updf != null) {
                    if (updatedEvFields == null) {
                        updatedEvFields = new HashSet();
                    }
                    updatedEvFields.addAll(updf);
                }
            }
            catch (SlowOperationException soe) {
                // empty catch block
            }
        }
        if (!ListTools.isEmpty(updatedEvFields)) {
            try {
                evdb.update(updatedEvFields);
                Print.logInfo((String)"EventData address: [%s/%s] %s: %s", (Object[])new Object[]{this.getAccountID(), this.getDeviceID(), evdb.getGeoPoint().toString(), evdb.getAddress()});
            }
            catch (DBException dbe) {
                Print.logError((String)("EventData update error: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            }
        }
    }

    public boolean postCommandHandling(DCServerConfig.Command command, String cmdStr, boolean update) {
        if (command == null) {
            return false;
        }
        if (command.getExpectAck()) {
            if (this.isExpectingCommandAck()) {
                Print.logWarn((String)("Already expecting an ACK for: " + this.getLastAckCommand()), (Object[])new Object[0]);
            } else {
                int ackCode = command.getExpectAckCode();
                String cs = !StringTools.isBlank((String)cmdStr) ? StringTools.trim((String)cmdStr) : command.getCommandString(this, null);
                this.setExpectAck(true);
                this.setExpectAckCode(ackCode);
                this.setLastAckCommand(cmdStr);
                this.setLastAckTime(0L);
                this.addOtherChangedFieldNames(FLD_expectAck, FLD_expectAckCode, FLD_lastAckCommand, FLD_lastAckTime);
            }
        }
        if (command.hasStateBitMask()) {
            long bitMask = command.getStateBitMask();
            boolean bitVal = command.getStateBitValue();
            this._setCommandStateMask(bitMask, bitVal);
        }
        if (command.hasAuditStatusCode()) {
            int sc = command.getAuditStatusCode();
            String acctID = this.getAccountID();
            String devID = this.getDeviceID();
            long fixtime = DateTime.getCurrentTimeSec();
            EventData.Key evk = new EventData.Key(acctID, devID, fixtime, sc);
            EventData evd = (EventData)evk.getDBRecord();
            this.insertEventData(evd);
        }
        if (this.hasChangedFieldNames()) {
            if (update) {
                try {
                    this.updateOtherChangedEventFields();
                }
                catch (DBException dbe) {
                    Print.logException((String)"Unable to update Device", (Throwable)dbe);
                }
            }
            return true;
        }
        return false;
    }

    public static OrderedSet<User> getAuthorizedUsers(Device device) throws DBException {
        OrderedSet userList = new OrderedSet();
        if (device == null) {
            return userList;
        }
        String deviceID = device.getDeviceID();
        Account account = device.getAccount();
        if (account == null) {
            return userList;
        }
        String accountID = device.getAccountID();
        Object[] userIDs = User.getUsersForAccount(accountID);
        if (ListTools.isEmpty((Object[])userIDs)) {
            return userList;
        }
        for (Object userID : userIDs) {
            try {
                User user = User.getUser(account, (String)userID);
                if (!user.isAuthorizedDevice(deviceID)) continue;
                userList.add((Object)user);
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return userList;
    }

    public long deleteEventsPriorTo(long priorToTime) throws DBException {
        if (priorToTime <= 0L) {
            throw new DBException("Invalid 'priorTo' timestamp specified: " + priorToTime);
        }
        long delEventCount = this.getEventCount(-1L, priorToTime - 1L);
        DBConnection dbc = null;
        try {
            DBDelete edel = new DBDelete(EventData.getFactory());
            DBWhere ewh = edel.createDBWhere();
            edel.setWhere(ewh.WHERE_(ewh.AND(ewh.EQ("accountID", (Object)this.getAccountID()), ewh.EQ("deviceID", (Object)this.getDeviceID()), ewh.LT("timestamp", priorToTime))));
            Print.logInfo((String)("EventData delete command: " + edel), (Object[])new Object[0]);
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(edel.toString());
        }
        catch (SQLException sqe) {
            try {
                throw new DBException("Deleting EventData records", (Throwable)sqe);
            }
            catch (Throwable throwable) {
                DBConnection.release(dbc);
                throw throwable;
            }
        }
        DBConnection.release((DBConnection)dbc);
        return delEventCount;
    }

    public Set<String> _createChangedFieldsSet(Set<String> flds) throws DBException {
        Set<String> otherSet = this.getOtherChangedFieldNames();
        if (flds == null && otherSet == null) {
            return DefaultUpdatedFieldsSet;
        }
        Set updFields = ListTools.toSet((Object[])DefaultUpdatedFieldsList);
        if (flds != null) {
            ListTools.toSet(flds, (Set)updFields);
        }
        if (otherSet != null) {
            ListTools.toSet(otherSet, (Set)updFields);
        }
        return updFields;
    }

    public Set<String> _createChangedFieldsSet(String ... flds) throws DBException {
        Set<String> otherSet = this.getOtherChangedFieldNames();
        if (flds == null && otherSet == null) {
            return DefaultUpdatedFieldsSet;
        }
        Set updFields = ListTools.toSet((Object[])DefaultUpdatedFieldsList);
        if (flds != null) {
            ListTools.toSet((Object[])flds, (Set)updFields);
        }
        if (otherSet != null) {
            ListTools.toSet(otherSet, (Set)updFields);
        }
        return updFields;
    }

    private Set<String> _createOtherChangedFieldsSet() {
        if (this.otherChangedFieldsSet == null) {
            this.otherChangedFieldsSet = new HashSet<String>();
        }
        return this.otherChangedFieldsSet;
    }

    private void _clearOtherChangedFieldsSet() {
        this.otherChangedFieldsSet = null;
    }

    public void clearOtherChangedFieldNames() {
        this._clearOtherChangedFieldsSet();
    }

    public boolean hasChangedFieldNames() {
        return this.otherChangedFieldsSet != null;
    }

    public Set<String> getOtherChangedFieldNames() {
        return this.otherChangedFieldsSet;
    }

    public void addOtherChangedFieldNames(Set<String> flds) {
        if (flds != null) {
            ListTools.toSet(flds, this._createOtherChangedFieldsSet());
        }
    }

    public void addOtherChangedFieldNames(String ... flds) {
        if (flds != null) {
            ListTools.toSet((Object[])flds, this._createOtherChangedFieldsSet());
        }
    }

    public void updateOtherChangedEventFields() throws DBException {
        Set<String> updSet = this.getOtherChangedFieldNames();
        if (updSet != null) {
            this.update(updSet);
            this._clearOtherChangedFieldsSet();
        }
    }

    public void updateChangedEventFields() throws DBException {
        this.update(this._createChangedFieldsSet((String[])null));
    }

    public void updateChangedEventFields(Set<String> flds) throws DBException {
        this.update(this._createChangedFieldsSet(flds));
    }

    public void updateChangedEventFields(String ... flds) throws DBException {
        this.update(this._createChangedFieldsSet(flds));
    }

    public void insertSessionStatistic(long startTime, String ipAddr, boolean isDuplex, long bytesRead, long bytesWritten, long evtsRecv) {
        SessionStatsFactory csf = Device.getSessionStatsFactory();
        if (csf != null) {
            try {
                csf.addSessionStatistic(this, startTime, ipAddr, isDuplex, bytesRead, bytesWritten, evtsRecv);
            }
            catch (DBException dbe) {
                Print.logError((String)("Session statistic: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            }
        }
    }

    public static boolean CheckSelectorSyntax(String selector) {
        if (StringTools.isBlank((String)selector)) {
            return true;
        }
        RuleFactory ruleFact = Device.getRuleFactory();
        if (ruleFact != null) {
            return ruleFact.checkSelectorSyntax(selector);
        }
        Print.logWarn((String)"No RuleFactory defined", (Object[])new Object[0]);
        return false;
    }

    protected boolean checkEventRules(EventData event) {
        int actionMask;
        boolean allowNotify;
        Account account = this.getAccount();
        if (event == null) {
            return false;
        }
        int statusCode = event.getStatusCode();
        if (StatusCodes.IsRuleTrigger(statusCode)) {
            return false;
        }
        boolean isSynthesizedEvent = event.getIsSynthesizedEvent();
        event.setDevice(this);
        if (!isSynthesizedEvent && Device.hasEntityManager()) {
            Device.getEntityManager().insertEntityChange(event);
        }
        if (!isSynthesizedEvent && Device.hasFuelManager()) {
            FuelManager fm = Device.getFuelManager();
            FuelManager.LevelChangeType lvlType = fm.insertFuelLevelChange(event);
            switch (lvlType) {
                case INCREASE: {
                    if (statusCode == 63825) break;
                    int fuelCode = 63825;
                    EventData fuelEv = EventData.copySynthesizedEvent(event, fuelCode);
                    if (this.insertEventData(fuelEv)) {
                        Print.logWarn((String)("FuelManager: Added new Fuel 'REFILL' Event - " + fuelEv), (Object[])new Object[0]);
                        break;
                    }
                    Print.logError((String)"FuelManager: New Fuel 'REFILL' Event failed!", (Object[])new Object[0]);
                    break;
                }
                case DECREASE: {
                    if (statusCode == 63826) break;
                    int fuelCode = 63826;
                    EventData fuelEv = EventData.copySynthesizedEvent(event, fuelCode);
                    if (this.insertEventData(fuelEv)) {
                        Print.logWarn((String)("FuelManager: Added new Fuel 'THEFT' Event - " + fuelEv), (Object[])new Object[0]);
                        break;
                    }
                    Print.logError((String)"FuelManager: New Fuel 'THEFT' Event failed!", (Object[])new Object[0]);
                    break;
                }
                case NONE: {
                    break;
                }
            }
        }
        if (!(allowNotify = this.getAllowNotify(true))) {
            Print.logDebug((String)("Notification disallowed for this device: " + this), (Object[])new Object[0]);
            return false;
        }
        String ruleSelector = Device.CheckNotifySelector() ? this.getNotifySelector() : null;
        RuleFactory ruleFact = Device.getRuleFactory();
        if (ruleFact == null) {
            return false;
        }
        int accumActionMask = 0;
        boolean didTrigger = false;
        if (!StringTools.isBlank((String)ruleSelector)) {
            Print.logDebug((String)("Processing Device rule [selector = " + ruleSelector + "] " + this), (Object[])new Object[0]);
            actionMask = ruleFact.executeSelector(ruleSelector, event);
            if (this._setDeviceAction(actionMask, event, null)) {
                didTrigger = true;
                accumActionMask |= actionMask;
            }
        }
        if (this._setDeviceAction(actionMask = ruleFact.executeRules(event), event, null)) {
            didTrigger = true;
            accumActionMask |= actionMask;
        }
        if (StatusCodes.IsGeozoneTransition(statusCode)) {
            BasicPrivateLabel bpl = Account.getPrivateLabel(account);
            Geozone zone = event.getGeozone();
            if (account == null) {
                Print.logError((String)("Unable to determine account for Geozone email: " + this.getAccountID() + "/" + this.getDeviceID() + " (zone: " + event.getGeozoneID() + ")"), (Object[])new Object[0]);
            } else if (bpl == null) {
                Print.logWarn((String)("Unable to determine Account PrivateLabel for Geozone email: " + this.getAccountID() + "/" + this.getDeviceID() + " (zone: " + event.getGeozoneID() + ")"), (Object[])new Object[0]);
            } else if (zone == null) {
                Print.logWarn((String)("Geozone status code, but Geozone not found: " + this.getAccountID() + "/" + this.getDeviceID() + " (zone: " + event.getGeozoneID() + ")"), (Object[])new Object[0]);
            } else if (zone.getAutoNotify()) {
                String devEmail;
                I18N i18n = I18N.getI18N(Device.class, (Locale)account.getLocale());
                String timeFmt = bpl.getDateFormat() + " " + bpl.getTimeFormat();
                TimeZone tmz = Account.getTimeZone(account, DateTime.getGMTTimeZone());
                String timeStr = new DateTime(event.getTimestamp()).format(timeFmt, tmz);
                String devDesc = this.getDescription();
                String zoneDesc = zone.getDescription();
                String subj = null;
                String body = null;
                body = statusCode == 61968 ? (subj = i18n.getString("Device.autoArriveMessage", "{0}: \"{1}\" arrived \"{2}\"", (Object[])new String[]{timeStr, devDesc, zoneDesc})) : (statusCode == 62000 ? (subj = i18n.getString("Device.autoDepartMessage", "{0}: \"{1}\" departed \"{2}\"", (Object[])new String[]{timeStr, devDesc, zoneDesc})) : (subj = i18n.getString("Device.autoGeozoneMessage", "{0}: \"{1}\" arrived/departed \"{2}\"", (Object[])new String[]{timeStr, devDesc, zoneDesc})));
                HashSet recipients = new HashSet();
                String acctEmail = account.getNotifyEmail();
                if (!StringTools.isBlank((String)acctEmail)) {
                    ListTools.toSet((Object[])StringTools.split((String)acctEmail, (char)','), recipients);
                }
                if (!StringTools.isBlank((String)(devEmail = this.getNotifyEmail(false, true)))) {
                    ListTools.toSet((Object[])StringTools.split((String)devEmail, (char)','), recipients);
                }
                StringBuffer toSMS = new StringBuffer();
                StringBuffer toEmail = new StringBuffer();
                for (String R : recipients) {
                    if (SMSOutboundGateway.StartsWithSMS(R)) {
                        if (toSMS.length() > 0) {
                            toSMS.append(",");
                        }
                        toSMS.append(R.substring("SMS:".length()));
                        continue;
                    }
                    if (toEmail.length() > 0) {
                        toEmail.append(",");
                    }
                    toEmail.append(R);
                }
                String frEmail = bpl.getEventNotificationFrom();
                if (StringTools.isBlank((String)frEmail) && StringTools.isBlank((String)(frEmail = bpl.getEMailAddress("notify")))) {
                    frEmail = bpl.getSmtpProperties().getUserEmail();
                }
                if (StringTools.isBlank((StringBuffer)toEmail)) {
                    Print.logInfo((String)"No email recipients, skipping email ...", (Object[])new Object[0]);
                } else if (StringTools.isBlank((String)frEmail)) {
                    Print.logWarn((String)"No 'From:' email address, skipping email ...", (Object[])new Object[0]);
                } else {
                    Print.logInfo((String)("From     : " + frEmail), (Object[])new Object[0]);
                    Print.logInfo((String)("To(email): " + toEmail), (Object[])new Object[0]);
                    Print.logInfo((String)("Subject  : " + subj), (Object[])new Object[0]);
                    Print.logInfo((String)("Body     :\n" + body), (Object[])new Object[0]);
                    try {
                        Print.logInfo((String)"Sending Geozone auto notify email ...", (Object[])new Object[0]);
                        SendMail.SmtpProperties smtpProps = bpl.getSmtpProperties();
                        SendMail.send((String)frEmail, (String)toEmail.toString(), null, null, (String)subj, (String)body, null, (SendMail.SmtpProperties)smtpProps);
                    }
                    catch (Throwable t) {
                        Print.logWarn((String)("SendMail error: " + t), (Object[])new Object[0]);
                    }
                }
                if (!StringTools.isBlank((StringBuffer)toSMS)) {
                    if (account.getSmsEnabled()) {
                        String smsMsg = subj;
                        Print.logInfo((String)("To(SMS): " + toSMS), (Object[])new Object[0]);
                        Print.logInfo((String)("Message: " + smsMsg), (Object[])new Object[0]);
                        String smsGatewayName = SMSOutboundGateway.GetDefaultGatewayName();
                        SMSOutboundGateway smsGW = SMSOutboundGateway.GetSMSGateway(smsGatewayName);
                        if (smsGW != null) {
                            String[] smsPhoneList;
                            Print.logInfo((String)("Sending SMS via gateway: " + smsGatewayName), (Object[])new Object[0]);
                            for (String smsPhone : smsPhoneList = StringTools.split((StringBuffer)toSMS, (char)',')) {
                                if (SMSOutboundGateway.StartsWithSMS(smsPhone)) {
                                    smsPhone = smsPhone.substring("SMS:".length());
                                }
                                if (StringTools.isBlank((String)smsPhone)) continue;
                                Print.logInfo((String)("SMS: " + smsPhone + " --> " + smsMsg), (Object[])new Object[0]);
                                DCServerFactory.ResultCode result = smsGW.sendSMSMessage(account, smsMsg, smsPhone);
                                if (result.isSuccess()) continue;
                                Print.logWarn((String)("SMS error: " + (Object)((Object)result)), (Object[])new Object[0]);
                            }
                        } else {
                            Print.logWarn((String)("SMS Gateway not found: " + smsGatewayName), (Object[])new Object[0]);
                        }
                    } else {
                        Print.logWarn((String)("SMS notification disabled for account: " + account.getAccountID()), (Object[])new Object[0]);
                    }
                }
            }
        }
        return didTrigger;
    }

    private boolean _setDeviceAction(int actionMask, EventData event, String ruleID) {
        if (actionMask < 0 || actionMask == 0) {
            return false;
        }
        if ((actionMask & 0x10000) != 0) {
            try {
                this.setLastNotifyEvent(event, ruleID, false);
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return true;
    }

    public StatusCode getStatusCode(int code) {
        Integer codeKey;
        if (this.cacheStatusCodeMap == null) {
            this.cacheStatusCodeMap = new HashMap<Integer, StatusCode>();
        }
        if (this.cacheStatusCodeMap.containsKey(codeKey = new Integer(code))) {
            return this.cacheStatusCodeMap.get(codeKey);
        }
        String accountID = this.getAccountID();
        String deviceID = this.getDeviceID();
        StatusCode sc = StatusCode.findStatusCode(accountID, deviceID, code);
        this.cacheStatusCodeMap.put(new Integer(code), sc);
        return sc;
    }

    public String[] getAttachedEntityIDs(EntityManager.EntityType etype) {
        EntityManager.EntityType et = EntityManager.getEntityType(etype);
        return this.getAttachedEntityIDs(et.getIntValue());
    }

    public String[] getAttachedEntityIDs(int entityType) {
        if (Device.hasEntityManager()) {
            String[] attEnt = null;
            try {
                String acctID = this.getAccountID();
                String devID = this.getDeviceID();
                attEnt = Device.getEntityManager().getAttachedEntityIDs(acctID, devID, entityType);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error reading Device Entities", (Throwable)dbe);
            }
            return attEnt;
        }
        return null;
    }

    public String[] getAttachedEntityDescriptions(EntityManager.EntityType etype) {
        EntityManager.EntityType et = EntityManager.getEntityType(etype);
        return this.getAttachedEntityDescriptions(et.getIntValue());
    }

    public String[] getAttachedEntityDescriptions(int entityType) {
        if (Device.hasEntityManager()) {
            String[] attEnt = null;
            try {
                String acctID = this.getAccountID();
                String devID = this.getDeviceID();
                attEnt = Device.getEntityManager().getAttachedEntityDescriptions(acctID, devID, entityType);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error reading Device Entities", (Throwable)dbe);
            }
            return attEnt;
        }
        return null;
    }

    public EventData[] getSavedRangeEvents() {
        return this.cachedRangeEvents;
    }

    public void setSavedRangeEvents(EventData[] events) {
        this.cachedRangeEvents = events;
    }

    public EventData[] getRangeEvents(long timeStart, long timeEnd, int[] statusCodes, boolean validGPS, EventData.LimitType limitType, long limit) throws DBException {
        EventData[] ev = EventData.getRangeEvents(this.getAccountID(), this.getDeviceID(), timeStart, timeEnd, statusCodes, validGPS, limitType, limit, true, null);
        if (ev != null) {
            for (int i = 0; i < ev.length; ++i) {
                ev[i].setDevice(this);
            }
        }
        return ev;
    }

    public EventData[] getRangeEvents(long timeStart, long timeEnd, boolean validGPS, EventData.LimitType limitType, long limit) throws DBException {
        return this.getRangeEvents(timeStart, timeEnd, null, validGPS, limitType, limit);
    }

    public EventData[] getLatestEvents(long limit, boolean validGPS) throws DBException {
        long timeStart = -1L;
        long timeEnd = -1L;
        return this.getRangeEvents(timeStart, timeEnd, null, validGPS, EventData.LimitType.LAST, limit);
    }

    public EventData getFirstEvent(long startTime, boolean validGPS) throws DBException {
        long endTime = -1L;
        EventData[] ev = EventData.getRangeEvents(this.getAccountID(), this.getDeviceID(), startTime, endTime, null, validGPS, EventData.LimitType.FIRST, 1L, true, null);
        if (ev == null || ev.length <= 0) {
            return null;
        }
        ev[0].setDevice(this);
        return ev[0];
    }

    public EventData getLastEvent(boolean validGPS) throws DBException {
        return this.getLastEvent(null, -1L, validGPS);
    }

    public EventData getLastEvent(long endTime, boolean validGPS) throws DBException {
        return this.getLastEvent(null, endTime, validGPS);
    }

    public EventData getLastEvent(int[] statusCodes) throws DBException {
        return this.getLastEvent(statusCodes, -1L, false);
    }

    public EventData getLastEvent(int[] statusCodes, long endTime, boolean validGPS) throws DBException {
        long startTime = -1L;
        EventData[] ev = EventData.getRangeEvents(this.getAccountID(), this.getDeviceID(), startTime, endTime, statusCodes, validGPS, EventData.LimitType.LAST, 1L, true, null);
        if (ev == null || ev.length <= 0) {
            return null;
        }
        ev[0].setDevice(this);
        return ev[0];
    }

    public void reprocessEventDataRecords(long timeStart, long timeEnd, final EventDataHandler edh) throws DBException {
        EventData.getRangeEvents(this.getAccountID(), this.getDeviceID(), timeStart, timeEnd, null, false, EventData.LimitType.LAST, -1L, true, null, new DBRecordHandler<EventData>(){

            public int handleDBRecord(EventData rcd) throws DBException {
                edh.handleEventDataRecord(rcd);
                return 1;
            }
        });
    }

    public void save() throws DBException {
        super.save();
        if (this.transport != null) {
            this.transport.save();
        }
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getDeviceID();
    }

    public void setTransport(Transport xport) {
        this.transport = xport;
    }

    @Override
    public String getTransportID() {
        return this.transport != null ? this.transport.getTransportID() : "";
    }

    public DataTransport getDataTransport() {
        return this.transport != null ? this.transport : this;
    }

    public long countOldEvents(long oldTimeSec) throws DBException {
        String acctID = this.getAccountID();
        String devID = this.getDeviceID();
        long count = EventData.getRecordCount(acctID, devID, -1L, oldTimeSec);
        return count;
    }

    public long deleteOldEvents(long oldTimeSec, StringBuffer logMsg) throws DBException {
        return EventData.deleteOldEvents(this, oldTimeSec, logMsg);
    }

    protected Device _reload(String ... fldNames) throws DBException {
        super._reload(fldNames);
        this.cacheIgnitionState = -2;
        this.cacheWorkHours = null;
        this.cacheStatusCodeMap = null;
        return this;
    }

    public static boolean exists(String acctID, String devID) throws DBException {
        if (acctID != null && devID != null) {
            Key devKey = new Key(acctID, devID);
            return devKey.exists();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Device loadDeviceBySimPhoneNumber(String simPhone) throws DBException {
        Statement stmt;
        DBConnection dbc;
        Device dev;
        block18: {
            if (simPhone == null) return null;
            if (simPhone.equals("")) {
                return null;
            }
            dev = null;
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(Device.getFactory());
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.EQ(FLD_simPhoneNumber, (Object)simPhone)));
                dsel.setLimit(2L);
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                if (rs.next()) {
                    String acctId = rs.getString("accountID");
                    String devId = rs.getString("deviceID");
                    dev = new Device(new Key(acctId, devId));
                    dev.setAllFieldValues(rs);
                    if (rs.next()) {
                        Print.logError((String)("Found multiple occurances of this SIM phone number: " + simPhone), (Object[])new Object[0]);
                    }
                }
                if (rs == null) break block18;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting Device SIM phone number: " + simPhone, (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return dev;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Device loadDeviceByUniqueID(String uniqId) throws DBException {
        Statement stmt;
        DBConnection dbc;
        Device dev;
        block18: {
            if (uniqId == null) return null;
            if (uniqId.equals("")) {
                return null;
            }
            dev = null;
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(Device.getFactory());
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.EQ(FLD_uniqueID, (Object)uniqId)));
                dsel.setLimit(2L);
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                if (rs.next()) {
                    String acctId = rs.getString("accountID");
                    String devId = rs.getString("deviceID");
                    dev = new Device(new Key(acctId, devId));
                    dev.setAllFieldValues(rs);
                    if (rs.next()) {
                        Print.logError((String)("Found multiple occurances of this unique-id: " + uniqId), (Object[])new Object[0]);
                    }
                }
                if (rs == null) break block18;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting Device unique-id: " + uniqId, (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return dev;
    }

    public static Device loadDeviceByName(Account account, String devID) throws DBException {
        Device dev = Device.getDevice(account, devID);
        return dev;
    }

    public static Device getDevice(Account account, String devID) throws DBException {
        if (account != null && devID != null) {
            String acctID = account.getAccountID();
            Key key = new Key(acctID, devID);
            if (key.exists()) {
                Device dev = (Device)key.getDBRecord(true);
                dev.setAccount(account);
                return dev;
            }
            return null;
        }
        return null;
    }

    public static Device getDevice(Account account, String devID, boolean create) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String acctID = account.getAccountID();
        if (StringTools.isBlank((String)devID)) {
            throw new DBNotFoundException("Device-ID not specified for account: " + acctID);
        }
        Device dev = null;
        Key devKey = new Key(acctID, devID);
        if (!devKey.exists()) {
            if (create) {
                dev = (Device)devKey.getDBRecord();
                dev.setAccount(account);
                dev.setCreationDefaultValues();
                return dev;
            }
            throw new DBNotFoundException("Device-ID does not exists: " + (Object)((Object)devKey));
        }
        if (create) {
            throw new DBAlreadyExistsException("Device-ID already exists '" + (Object)((Object)devKey) + "'");
        }
        dev = Device.getDevice(account, devID);
        if (dev == null) {
            throw new DBException("Unable to read existing Device-ID: " + (Object)((Object)devKey));
        }
        return dev;
    }

    public static Device createNewDevice(Account account, String devID, String uniqueID) throws DBException {
        if (account != null && !StringTools.isBlank((String)devID)) {
            Device dev = Device.getDevice(account, devID, true);
            if (!StringTools.isBlank((String)uniqueID)) {
                dev.setUniqueID(uniqueID);
                dev.setSpeedLimitKPH(80.0);
            }
            dev.save();
            return dev;
        }
        throw new DBException("Invalid Account/DeviceID specified");
    }

    public static Device createVirtualDevice(String acctID, String devID) {
        Key devKey = new Key(acctID, devID);
        Device dev = (Device)devKey.getDBRecord();
        dev.setCreationDefaultValues();
        dev.setVirtual(true);
        return dev;
    }

    public static OrderedSet<String> getDeviceIDsForAccount(String acctId, User userAuth, boolean inclInactv) throws DBException {
        return Device.getDeviceIDsForAccount(acctId, userAuth, inclInactv, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OrderedSet<String> getDeviceIDsForAccount(String acctId, User userAuth, boolean inclInactv, long limit) throws DBException {
        Statement stmt;
        DBConnection dbc;
        OrderedSet devList;
        block20: {
            if (StringTools.isBlank((String)acctId)) {
                if (userAuth == null) {
                    Print.logError((String)"Account not specified!", (Object[])new Object[0]);
                    return new OrderedSet();
                }
                acctId = userAuth.getAccountID();
            }
            devList = new OrderedSet();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(Device.getFactory());
                dsel.setSelectedFields(new String[]{"deviceID"});
                DBWhere dwh = dsel.createDBWhere();
                if (inclInactv) {
                    dsel.setWhere(dwh.WHERE(dwh.EQ("accountID", (Object)acctId)));
                } else {
                    dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.NE("isActive", 0))));
                }
                dsel.setOrderByFields(new String[]{"deviceID"});
                dsel.setLimit(limit);
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String devId = rs.getString("deviceID");
                    if (userAuth != null && !userAuth.isAuthorizedDevice(devId)) continue;
                    devList.add((Object)devId);
                }
                if (rs == null) break block20;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting Account Device List", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return devList;
    }

    public static String getKeyFieldTitle(String key, String arg, Locale locale) {
        return Device._getKeyFieldString(true, key, arg, locale, null, null);
    }

    public String getKeyFieldValue(String key, String arg, BasicPrivateLabel bpl) {
        Locale locale = bpl != null ? bpl.getLocale() : null;
        return Device._getKeyFieldString(false, key, arg, locale, bpl, this);
    }

    public static String _getKeyFieldString(boolean getTitle, String key, String arg, Locale locale, BasicPrivateLabel bpl, Device dev) {
        if (key == null) {
            return null;
        }
        if (dev == null && !getTitle) {
            return null;
        }
        if (locale == null && bpl != null) {
            locale = bpl.getLocale();
        }
        I18N i18n = I18N.getI18N(Device.class, (Locale)locale);
        long now = DateTime.getCurrentTimeSec();
        if (EventData._keyMatch(key, KEY_DEVICE)) {
            if (getTitle) {
                return i18n.getString("Device.key.deviceDescription", _TABLE_NAME);
            }
            return dev.getDescription();
        }
        if (EventData._keyMatch(key, KEY_DEVICE_LINK)) {
            if (getTitle) {
                return i18n.getString("Device.key.deviceLink", "Device Link");
            }
            String url = dev.getLinkURL();
            String dsc = StringTools.blankDefault((String)dev.getLinkDescription(), (String)i18n.getString("Device.key.link", "Link"));
            if (StringTools.isBlank((String)url)) {
                return "";
            }
            if (StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("a") || arg.equalsIgnoreCase("html")) {
                if (!StringTools.isBlank((String)url)) {
                    return "$HTML:<a href='" + url + "' target='_blank'>" + dsc + "</a>";
                }
                return "$HTML:<a>" + dsc + "</a>";
            }
            if (arg.equalsIgnoreCase("plain") || arg.equalsIgnoreCase("desc")) {
                return dsc + ": " + url;
            }
            return url;
        }
        if (EventData._keyMatch(key, KEY_DEV_CONN_AGE)) {
            if (getTitle) {
                return i18n.getString("Device.key.sinceLastConnect", "Since Connection");
            }
            long lastConnectTime = dev.getLastTotalConnectTime();
            if (lastConnectTime <= 0L) {
                return "--:--:--";
            }
            long ageSec = DateTime.getCurrentTimeSec() - lastConnectTime;
            if (ageSec < 0L) {
                ageSec = 0L;
            }
            long hours = ageSec / 3600L;
            long min = ageSec % 3600L / 60L;
            long sec = ageSec % 60L;
            StringBuffer sb = new StringBuffer();
            sb.append(hours).append(":");
            if (min < 10L) {
                sb.append("0");
            }
            sb.append(min).append(":");
            if (sec < 10L) {
                sb.append("0");
            }
            sb.append(sec);
            return sb.toString();
        }
        if (EventData._keyMatch(key, KEY_DEV_TRAILERS)) {
            if (getTitle) {
                return i18n.getString("Device.key.attachedTrailers", "Attached Trailers");
            }
            Object[] e = dev.getAttachedEntityDescriptions(EntityManager.EntityType.TRAILER);
            if (!ListTools.isEmpty((Object[])e)) {
                return StringTools.join((String[])e, (String)",");
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_LICENSE_PLATE)) {
            if (getTitle) {
                return i18n.getString("Device.key.licensePlate", "License Plate");
            }
            return dev.getLicensePlate();
        }
        if (EventData._keyMatch(key, KEY_EVENT_COUNT24)) {
            int[] nArray;
            int sinceHH;
            if (getTitle) {
                return i18n.getString("Device.key.24HourEventCount", "24Hr Event Count");
            }
            String[] a = StringTools.split((String)arg, (char)',');
            int n = sinceHH = a.length > 1 ? StringTools.parseInt((String)a[0], (int)24) : 24;
            if (a.length > 2 && !StringTools.isBlank((String)a[1])) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = StringTools.parseInt((String)a[1], (int)0);
            } else {
                nArray = null;
            }
            int[] statCodes = nArray;
            long timeStart = now - DateTime.HourSeconds((long)(sinceHH > 0 ? (long)sinceHH : 24L));
            long timeEnd = -1L;
            long recordCount = -1L;
            try {
                recordCount = EventData.countRangeEvents(dev.getAccountID(), dev.getDeviceID(), timeStart, timeEnd, statCodes, false, EventData.LimitType.LAST, -1L, null);
            }
            catch (DBException dbe) {
                Print.logError((String)("Unable to obtain EventData record count [" + (Object)((Object)dbe)), (Object[])new Object[0]);
            }
            return String.valueOf(recordCount);
        }
        if (EventData._keyMatch(key, KEY_LAST_EPS)) {
            if (getTitle) {
                return i18n.getString("Device.key.lastEventsPerSecond", "Events/Sec");
            }
            double eps = dev.getAgedEventsPerSecond(System.currentTimeMillis());
            if (eps <= 0.0) {
                return i18n.getString("Device.notAvailable", "n/a");
            }
            return StringTools.format((double)eps, (String)"0.000");
        }
        if (EventData._keyMatch(key, KEY_LAST_EPH)) {
            if (getTitle) {
                return i18n.getString("Device.key.lastEventsPerHour", "Events/Hour");
            }
            double eps = dev.getAgedEventsPerSecond(System.currentTimeMillis());
            if (eps <= 0.0) {
                return i18n.getString("Device.notAvailable", "n/a");
            }
            double eph = eps * 60.0 * 60.0;
            return StringTools.format((double)eph, (String)"0.0");
        }
        if (EventData._keyMatch(key, KEY_FUEL_LEVEL)) {
            if (getTitle) {
                return i18n.getString("Device.key.fuelLevel", "Fuel Level");
            }
            double level = dev.getLastFuelLevel();
            if (level < 0.0) {
                return i18n.getString("Device.notAvailable", "n/a");
            }
            long pct = Math.round(level * 100.0);
            return pct + "%";
        }
        if (EventData._keyMatch(key, KEY_LAST_FUEL_LEV)) {
            if (getTitle) {
                return i18n.getString("Device.key.lastFuelLevel", "Last Fuel Level");
            }
            double level = dev.getLastFuelLevel();
            if (level < 0.0) {
                return i18n.getString("Device.notAvailable", "n/a");
            }
            long pct = Math.round(level * 100.0);
            return pct + "%";
        }
        if (EventData._keyMatch(key, KEY_FUEL_VOLUME)) {
            if (getTitle) {
                return i18n.getString("Device.key.fuelVolume", "Fuel Volume");
            }
            Account.VolumeUnits vu = Account.getVolumeUnits(dev.getAccount());
            double L = dev.getFuelCapacity() * dev.getLastFuelLevel();
            double V = vu.convertFromLiters(L);
            return StringTools.format((double)V, (String)"0.0") + " " + vu.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_LAST_FUEL_VOL)) {
            if (getTitle) {
                return i18n.getString("Device.key.lastFuelVolume", "Last Fuel Volume");
            }
            Account.VolumeUnits vu = Account.getVolumeUnits(dev.getAccount());
            double L = dev.getFuelCapacity() * dev.getLastFuelLevel();
            double V = vu.convertFromLiters(L);
            return StringTools.format((double)V, (String)"0.0") + " " + vu.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_DRIVERID)) {
            if (getTitle) {
                return i18n.getString("Device.key.driverID", "Driver ID");
            }
            String driverID = dev.getDriverID();
            if (!StringTools.isBlank((String)driverID)) {
                return driverID;
            }
            Object[] d = dev.getAttachedEntityIDs(EntityManager.EntityType.DRIVER);
            if (!ListTools.isEmpty((Object[])d)) {
                return StringTools.join((String[])d, (String)",");
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_DRIVER_DESC)) {
            if (getTitle) {
                return i18n.getString("Device.key.driverDescription", "Driver");
            }
            String driverID = dev.getDriverID();
            if (!StringTools.isBlank((String)driverID)) {
                Driver driver = dev.getDriver();
                if (driver != null) {
                    return driver.getDescription();
                }
                Print.logDebug((String)("Unable to read Driver: " + driverID), (Object[])new Object[0]);
                return driverID;
            }
            Object[] d = dev.getAttachedEntityDescriptions(EntityManager.EntityType.DRIVER);
            if (!ListTools.isEmpty((Object[])d)) {
                return StringTools.join((String[])d, (String)",");
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_DRIVER_BADGE)) {
            if (getTitle) {
                return i18n.getString("Device.key.driverBadge", "Driver Badge");
            }
            String driverID = dev.getDriverID();
            if (!StringTools.isBlank((String)driverID)) {
                Driver driver = dev.getDriver();
                if (driver != null) {
                    return driver.getBadgeID();
                }
                Print.logDebug((String)("Unable to read Driver: " + driverID), (Object[])new Object[0]);
                return driverID;
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_DRIVER_LICENSE)) {
            if (getTitle) {
                return i18n.getString("Device.key.driverLicense", "Driver License");
            }
            String driverID = dev.getDriverID();
            if (!StringTools.isBlank((String)driverID)) {
                Driver driver = dev.getDriver();
                if (driver != null) {
                    return driver.getLicenseNumber();
                }
                Print.logDebug((String)("Unable to read Driver: " + driverID), (Object[])new Object[0]);
                return driverID;
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_FAULT_CODES)) {
            if (getTitle) {
                return i18n.getString("Device.key.faultCodes", "Fault Codes");
            }
            String fault = dev.getLastFaultCode().toUpperCase();
            if (!StringTools.isBlank((String)fault)) {
                RTProperties rtpFault = new RTProperties(fault);
                return DTOBDFault.GetFaultString(rtpFault);
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_FAULT_CODE)) {
            if (getTitle) {
                return i18n.getString("Device.key.faultCodes", "Fault Codes");
            }
            String fault = dev.getLastFaultCode().toUpperCase();
            if (!StringTools.isBlank((String)fault)) {
                RTProperties rtpFault = new RTProperties(fault);
                return DTOBDFault.GetFaultString(rtpFault);
            }
            return "";
        }
        if (EventData._keyMatch(key, KEY_CORRIDOR_ID)) {
            if (getTitle) {
                return i18n.getString("Device.key.activeCorridor", "Active Corridor");
            }
            String actvCorr = dev.getActiveCorridor();
            return actvCorr;
        }
        if (EventData._keyMatch(key, KEY_CORRIDOR_DESC)) {
            if (getTitle) {
                return i18n.getString("Device.key.activeCorridorDesc", "Active Corridor\nDescription");
            }
            String actvCorr = dev.getActiveCorridor();
            if (!StringTools.isBlank((String)actvCorr)) {
                Account acct = dev.getAccount();
                RuleFactory rf = Device.getRuleFactory();
                String corrDesc = rf != null ? rf.getGeoCorridorDescription(acct, actvCorr) : null;
                return !StringTools.isBlank((String)corrDesc) ? corrDesc : actvCorr;
            }
            return actvCorr;
        }
        if (EventData._keyMatch(key, KEY_STOP_ELAPSED)) {
            long stopDelta;
            if (getTitle) {
                return i18n.getString("Device.key.stopElapsed", "Stop Elapsed");
            }
            long startTime = dev.getLastStartTime();
            long stopTime = dev.getLastStopTime();
            boolean isStopped = stopTime > 0L && stopTime > startTime;
            long l = stopDelta = isStopped ? DateTime.getCurrentTimeSec() - stopTime : 0L;
            if (stopDelta <= 0L) {
                return "";
            }
            return StringTools.formatElapsedSeconds((long)stopDelta, (int)0);
        }
        if (EventData._keyMatch(key, KEY_SPEED_LIMIT)) {
            if (getTitle) {
                return i18n.getString("Device.key.speedLimit", "Speed Limit");
            }
            double kph = dev.getSpeedLimitKPH();
            if (kph <= 0.0) {
                return i18n.getString("Device.notAvailable", "n/a");
            }
            Account account = dev.getAccount();
            if (account != null) {
                return account.getSpeedString(kph, true, locale);
            }
            return StringTools.format((double)kph, (String)"0") + " " + Account.SpeedUnits.KPH.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_REMINDER)) {
            if (getTitle) {
                return i18n.getString("Device.key.reminder", "Reminder");
            }
            String reminder = dev.getReminderMessage();
            return StringTools.trim((String)reminder);
        }
        if (EventData._keyMatch(key, KEY_COMMAND_STATE)) {
            int bitNdx = StringTools.parseInt((String)arg, (int)0);
            if (getTitle) {
                return i18n.getString("Device.key.commandState", "Command State #{0}", (Object)String.valueOf(bitNdx));
            }
            return dev.getCommandStateMaskBit(bitNdx) ? AccountRecord.GetSimpleLocalString("true", locale) : AccountRecord.GetSimpleLocalString("false", locale);
        }
        if (EventData._keyMatch(key, KEY_COMMAND_TIME)) {
            if (getTitle) {
                return i18n.getString("Device.key.commandTime", "Command Time");
            }
            long T = dev.getLastPingTime();
            Account acct = dev.getAccount();
            TimeZone tmz = acct != null ? acct.getTimeZone(null) : DateTime.getGMTTimeZone();
            return EventData.getTimestampString(T, acct, tmz, bpl);
        }
        if (EventData._keyMatch(key, KEY_ACK_DATETIME)) {
            if (getTitle) {
                return i18n.getString("Device.key.ackTime", "Ack Time");
            }
            long T = dev.getLastAckTime();
            Account acct = dev.getAccount();
            TimeZone tmz = acct != null ? acct.getTimeZone(null) : DateTime.getGMTTimeZone();
            return EventData.getTimestampString(T, acct, tmz, bpl);
        }
        if (EventData._keyMatch(key, KEY_MAINT_DESC)) {
            if (getTitle) {
                return i18n.getString("Device.key.maintDesc", "Maint. #");
            }
            int ndx = StringTools.parseInt((String)arg, (int)dev.getMaintTriggeredKM());
            String desc = dev.getMaintDescriptionKM(ndx);
            return StringTools.trim((String)desc);
        }
        if (EventData._keyMatch(key, KEY_MAINT_ODOMETER)) {
            if (getTitle) {
                return i18n.getString("Device.key.mainOdometer", "Maint. Odom");
            }
            int ndx = StringTools.parseInt((String)arg, (int)dev.getMaintTriggeredKM());
            double odomKM = dev.getMaintOdometerKM(ndx);
            Account acct = dev.getAccount();
            if (acct != null) {
                return acct.getDistanceString(odomKM, true, locale);
            }
            return StringTools.format((double)odomKM, (String)"0") + " " + Account.DistanceUnits.KM.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_MAINT_INTERVAL)) {
            if (getTitle) {
                return i18n.getString("Device.key.mainInterval", "Maint. Intrv");
            }
            int ndx = StringTools.parseInt((String)arg, (int)dev.getMaintTriggeredKM());
            double intrvKM = dev.getMaintIntervalKM(ndx);
            Account acct = dev.getAccount();
            if (acct != null) {
                return acct.getDistanceString(intrvKM, true, locale);
            }
            return StringTools.format((double)intrvKM, (String)"0") + " " + Account.DistanceUnits.KM.toString(locale);
        }
        if (EventData._keyMatch(key, KEY_CUSTOM)) {
            if (getTitle) {
                String K;
                String D;
                if (!StringTools.isBlank((String)arg) && bpl != null && !StringTools.isBlank((String)(D = bpl.getStringProperty(K = "deviceInfo.custom." + arg, null)))) {
                    return D;
                }
                return i18n.getString("Device.key.custom", "Custom");
            }
            String value = dev.getCustomAttribute(arg);
            return StringTools.trim((String)value);
        }
        if (getTitle) {
            DBField dbFld = Device.getFactory().getField(key);
            if (dbFld != null) {
                return dbFld.getTitle(locale);
            }
        } else {
            DBField dbFld;
            String fldName = dev.getFieldName(key);
            DBField dBField = dbFld = fldName != null ? dev.getField(fldName) : null;
            if (dbFld != null) {
                Account account;
                Object val = dev.getFieldValue(fldName);
                if (val == null) {
                    val = dbFld.getDefaultValue();
                }
                if ((account = dev.getAccount()) != null) {
                    val = account.convertFieldUnits(dbFld, val, true, locale);
                    return StringTools.trim((Object)val);
                }
                return dbFld.formatValue(val);
            }
        }
        if (getTitle) {
            return Account._getKeyFieldString(true, key, arg, locale, null, null);
        }
        return Account._getKeyFieldString(false, key, arg, locale, bpl, dev.getAccount());
    }

    public static Comparator<Device> getDeviceDescriptionComparator() {
        if (devDescComparator == null) {
            devDescComparator = new DeviceDescriptionComparator();
        }
        return devDescComparator;
    }

    private static String _fmtDevID(String acctID, String devID) {
        return acctID + "/" + devID;
    }

    private static void usage() {
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + Device.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>               Acount ID which owns Device", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -device=<id>                Device ID to create/edit", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -uniqueid=<id>              Unique ID to create/edit", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -create                     Create a new Device", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -edit                       Edit an existing (or newly created) Device", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -delete                     Delete specified Device", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -events=<limit>             Retrieve the last <limit> events", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -ckRules=<lat>/<lon>,<sc>   Check rule (may change db!)", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -countFutureEvents=<sec>    Count events beyond (now + sec) into the future", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -deleteFutureEvents=<sec>   Delete events beyond (now + sec) into the future", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -countOldEvents=<time>      Count events before specified time (requires '-confirm')", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -deleteOldEvents=<time>     Delete events before specified time (requires '-confirm')", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -confirm                    Confirms countOldEvents/deleteOldEvents", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -zoneCheck=<GP1>/<GP2>      Geozone transition check", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        EventData evRcd;
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        String uniqID = RTConfig.getString((String[])ARG_UNIQID, (String)"");
        Account acct = null;
        boolean acctExists = false;
        if (!StringTools.isBlank((String)acctID)) {
            try {
                acct = Account.getAccount(acctID);
                if (acct != null) {
                    acctExists = true;
                } else {
                    acctExists = false;
                    Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                    Device.usage();
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
                System.exit(99);
            }
        }
        BasicPrivateLabel privLabel = acct != null ? acct.getPrivateLabel() : null;
        boolean deviceExists = false;
        if (!StringTools.isBlank((String)devID)) {
            if (acctExists) {
                try {
                    deviceExists = Device.exists(acctID, devID);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error determining if Device exists: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                    System.exit(99);
                }
            } else {
                Print.logError((String)"Account-ID not specified, or does not exist", (Object[])new Object[0]);
                Device.usage();
            }
        }
        Device deviceRcd = null;
        if (deviceExists) {
            try {
                deviceRcd = Device.getDevice(acct, devID, false);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error getting Device: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !StringTools.isBlank((String)acctID) && !StringTools.isBlank((String)devID)) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logWarn((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key devKey = new Key(acctID, devID);
                devKey.delete(true);
                Print.logInfo((String)("Device deleted: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                deviceExists = false;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting Device: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (!acctExists) {
                Print.logError((String)("Account does not exist: " + acctID), (Object[])new Object[0]);
            } else if (deviceExists) {
                Print.logWarn((String)("Device already exists: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
            } else {
                try {
                    Device.createNewDevice(acct, devID, uniqID);
                    Print.logInfo((String)("Created Device: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                    deviceExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating Device: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false) || RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false)) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
            } else {
                try {
                    boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                    DBEdit editor = new DBEdit((DBRecord)deviceRcd);
                    editor.edit(allFlds);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    }
                    Print.logError((String)"IO Error", (Object[])new Object[0]);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_EVENTS)) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
            } else {
                int limit = RTConfig.getInt((String[])ARG_EVENTS, (int)10);
                int fmt = EventUtil.parseOutputFormat(RTConfig.getString((String[])ARG_FORMAT, null), 1);
                try {
                    EventData[] evList = deviceRcd.getLatestEvents(limit, false);
                    deviceRcd.setSavedRangeEvents(evList);
                    Vector<Device> devList = new Vector<Device>();
                    devList.add(deviceRcd);
                    EventUtil evUtil = EventUtil.getInstance();
                    evUtil.writeEvents((PrintWriter)null, acct, devList, fmt, true, null, privLabel);
                }
                catch (IOException ioe) {
                    Print.logError((String)"IO Error", (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error getting events for Device: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_ZONECHECK)) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
            } else {
                String[] gpStr = StringTools.split((String)RTConfig.getString((String[])ARG_ZONECHECK, (String)""), (char)',');
                GeoPoint gp1 = gpStr.length > 0 ? new GeoPoint(gpStr[0]) : GeoPoint.INVALID_GEOPOINT;
                GeoPoint gp2 = gpStr.length > 1 ? new GeoPoint(gpStr[1]) : GeoPoint.INVALID_GEOPOINT;
                long fixtime = DateTime.getCurrentTimeSec();
                deviceRcd.setLastValidLocation(fixtime, gp1, 0.0);
                List<GeozoneTransition> zone = deviceRcd.checkGeozoneTransitions(fixtime, gp2);
                if (ListTools.size(zone) > 0) {
                    for (GeozoneTransition z : zone) {
                        Print.sysPrintln((String)("Zone Transition: " + z), (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)"Not in a Geozone ...", (Object[])new Object[0]);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_INSERT)) {
            ++opts;
            GeoPoint gp = new GeoPoint(RTConfig.getString((String[])ARG_INSERT, (String)""));
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(1);
            } else if (!gp.isValid()) {
                Print.logError((String)("Invalid GeoPoint: " + gp), (Object[])new Object[0]);
                System.exit(1);
            } else {
                SendMail.SetThreadModel((String)"debug");
                Print.sysPrintln((String)("Account PrivateLabel: " + privLabel.getName()), (Object[])new Object[0]);
                ReverseGeocodeProvider rgp = privLabel.getReverseGeocodeProvider();
                if (INSERT_REVERSEGEOCODE_REQUIRED && rgp == null) {
                    Print.sysPrintln((String)"Account has no ReverseGeocodeProvider (record not inserted)", (Object[])new Object[0]);
                    System.exit(1);
                }
                Print.sysPrintln((String)("Account ReverseGeocodeProvider: " + (rgp != null ? rgp.getName() : "<none>")), (Object[])new Object[0]);
                if (INSERT_REVERSEGEOCODE_REQUIRED && !Account.getGeocoderMode(acct).equals((Object)Account.GeocoderMode.FULL)) {
                    Print.sysPrintln((String)"Overriding Account GeocoderMode to 'FULL'", (Object[])new Object[0]);
                    acct.setGeocoderMode(Account.GeocoderMode.FULL);
                }
                long timestamp = DateTime.getCurrentTimeSec();
                int statusCode = 61488;
                EventData.Key evKey = new EventData.Key(acctID, devID, timestamp, statusCode);
                evRcd = (EventData)evKey.getDBRecord();
                evRcd.setGeoPoint(gp);
                evRcd.setAddress(null);
                if (deviceRcd.insertEventData(evRcd)) {
                    Print.sysPrintln((String)"EventData record inserted ...", (Object[])new Object[0]);
                } else {
                    Print.logError((String)"*** Unable to insert EventData record!!!", (Object[])new Object[0]);
                }
                ThreadPool_DeviceEventUpdate.stopThreads();
                if (ThreadPool_DeviceEventUpdate.getPoolSize() > 0) {
                    do {
                        Print.sysPrintln((String)"Waiting for background threads to complete ...", (Object[])new Object[0]);
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    } while (ThreadPool_DeviceEventUpdate.getPoolSize() > 0);
                }
                Print.sysPrintln((String)"... done", (Object[])new Object[0]);
                System.exit(0);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_CLEARACK)) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            boolean didClear = deviceRcd.clearExpectCommandAck(false, true);
            Print.logInfo((String)("Cleared Device ACK: " + didClear), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_RESET_ACCUM)) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            Device device = deviceRcd;
            device.setLastEngineOnTime(0L);
            device.setLastEngineOffTime(0L);
            device.setLastEngineHours(0.0);
            device.setLastIgnitionOnTime(0L);
            device.setLastIgnitionOffTime(0L);
            device.setLastIgnitionHours(0.0);
            device.setLastStopTime(0L);
            device.setLastStartTime(0L);
            device.setLastOdometerKM(0.0);
            device.setLastDistanceKM(0.0);
            device.setLastValidLatitude(0.0);
            device.setLastValidLongitude(0.0);
            device.setLastValidHeading(0.0);
            device.setLastGPSTimestamp(0L);
            device.setLastNotifyTime(0L);
            device.setLastNotifyCode(0);
            device.setLastNotifyRule(null);
            device.setLastInputState(0L);
            device.setLastOutputState(0L);
            device.setLastBatteryLevel(0.0);
            device.setLastFuelLevel(0.0);
            device.setLastFuelTotal(0.0);
            device.setLastOilLevel(0.0);
            device.setLastTcpSessionID(null);
            device.setLastEventTimestamp(0L);
            device.setLastEventsPerSecond(0.0);
            device.setLastEventsPerSecondMS(0L);
            device.setLastCellServingInfo(null);
            device.setLastMalfunctionLamp(false);
            device.setLastFaultCode(null);
            device.setLastPingTime(0L);
            device.setTotalPingCount(0);
            device.setLastAckCommand(null);
            device.setLastAckResponse(null);
            device.setLastAckTime(0L);
            device.setLastDuplexConnectTime(0L);
            device.setLastTotalConnectTime(0L);
            device.setLastServiceTime(0L);
            try {
                device.save();
                Print.logInfo((String)"Cleared Device accumulators", (Object[])new Object[0]);
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to clear Device accumulators", (Throwable)dbe);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_MAINTKM)) {
            double maintKM;
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            int ndx = 0;
            double odomKM = deviceRcd.getLastOdometerKM();
            double intervKM = deviceRcd.getMaintIntervalKM(ndx);
            if (odomKM <= 0.0 || intervKM <= 0.0) {
                System.exit(2);
            }
            if (odomKM >= (maintKM = deviceRcd.getMaintOdometerKM(ndx)) + intervKM) {
                String devDesc = deviceRcd.getDescription();
                String maintDesc = deviceRcd.getMaintDescriptionKM(ndx);
                Print.logInfo((String)("'" + maintDesc + "' Service Interval due for " + deviceRcd.getDescription()), (Object[])new Object[0]);
                String frEmail = privLabel.getSmtpProperties().getUserEmail();
                String toEmail = RTConfig.getString((String[])ARG_MAINTKM, (String)"");
                if (!StringTools.isBlank((String)frEmail) && !StringTools.isBlank((String)toEmail)) {
                    I18N i18n = I18N.getI18N(Device.class, (Locale)acct.getLocale());
                    String text = i18n.getString("Device.serviceMaint.dueFor", "Periodic Maintenance({1}) due for {0}", (Object)devDesc, (Object)maintDesc);
                    String odom = i18n.getString("Device.serviceMaint.odometer", "Odometer");
                    String subj = text;
                    String body = text + "\n" + odom + ": " + odomKM + "\n" + "\n";
                    try {
                        Print.logInfo((String)("From:" + frEmail), (Object[])new Object[0]);
                        Print.logInfo((String)("To:" + toEmail), (Object[])new Object[0]);
                        Print.logInfo((String)("Subject: " + subj), (Object[])new Object[0]);
                        Print.logInfo((String)("Body:\n" + body), (Object[])new Object[0]);
                        Print.logInfo((String)"Sending email ...", (Object[])new Object[0]);
                        SendMail.SetThreadModel((String)"current");
                        SendMail.SmtpProperties smtoProps = privLabel.getSmtpProperties();
                        SendMail.send((String)frEmail, (String)toEmail, null, null, (String)subj, (String)body, null, (SendMail.SmtpProperties)smtoProps);
                        System.exit(0);
                    }
                    catch (Throwable t) {
                        Print.logWarn((String)("SendMail error: " + t), (Object[])new Object[0]);
                        System.exit(97);
                    }
                }
                System.exit(1);
            } else {
                System.exit(2);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_CHECKRULES)) {
            ++opts;
            Object[] crArgs = StringTools.split((String)RTConfig.getString((String[])ARG_CHECKRULES, (String)""), (char)',');
            if (crArgs.length < 1) {
                Print.logError((String)"Invalid 'checkRules' arguments ['lat/lon,code']", (Object[])new Object[0]);
                System.exit(99);
            }
            GeoPoint gp = new GeoPoint(crArgs[0]);
            int code = StatusCodes.ParseCode((String)ListTools.itemAt((Object[])crArgs, (int)1, (Object)""), null, 61488);
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            } else if (!gp.isValid()) {
                Print.logError((String)("Invalid GeoPoint: " + gp), (Object[])new Object[0]);
                System.exit(98);
            }
            long timestamp = DateTime.getCurrentTimeSec();
            EventData.Key evKey = new EventData.Key(acctID, devID, timestamp, code);
            evRcd = (EventData)evKey.getDBRecord();
            evRcd.setGeoPoint(gp);
            evRcd.setAddress(null);
            Print.logInfo((String)("Created Event: " + Device._fmtDevID(acctID, devID) + " " + gp + " [" + StatusCodes.GetHex(code) + ":" + StatusCodes.GetDescription(code, null) + "]"), (Object[])new Object[0]);
            Print.logInfo((String)"Checking Rules ...", (Object[])new Object[0]);
            if (!deviceRcd.checkEventRules(evRcd)) {
                Print.logWarn((String)"No rules triggered ...", (Object[])new Object[0]);
            }
            ThreadPool_DeviceEventUpdate.stopThreads();
            if (ThreadPool_DeviceEventUpdate.getPoolSize() > 0) {
                do {
                    Print.sysPrintln((String)"Waiting for background threads to complete ...", (Object[])new Object[0]);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                } while (ThreadPool_DeviceEventUpdate.getPoolSize() > 0);
            }
            Print.sysPrintln((String)"... done", (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_CNT_FUTURE_EV)) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            long sec = RTConfig.getLong((String[])ARG_CNT_FUTURE_EV, (long)0L);
            long nowTime = DateTime.getCurrentTimeSec();
            long futureTime = nowTime + sec;
            Print.sysPrintln((String)("Counting events after \"" + new DateTime(futureTime) + "\" ..."), (Object[])new Object[0]);
            try {
                long rcdCount = EventData.getRecordCount(acctID, devID, futureTime, -1L);
                if (rcdCount <= 0L) {
                    Print.sysPrintln((String)"No future events found", (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)("Found " + rcdCount + " future events"), (Object[])new Object[0]);
                }
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error counting future events: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_DEL_FUTURE_EV)) {
            long sec;
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            if ((sec = RTConfig.getLong((String[])ARG_DEL_FUTURE_EV, (long)0L)) < 60L) {
                Print.logError((String)"Specified seconds must be >= 60", (Object[])new Object[0]);
                System.exit(99);
            }
            long nowTime = DateTime.getCurrentTimeSec();
            long futureTime = nowTime + sec;
            Print.sysPrintln((String)("Deleting events after \"" + new DateTime(futureTime) + "\" ..."), (Object[])new Object[0]);
            try {
                long delCount = EventData.deleteFutureEvents(acctID, devID, futureTime);
                if (delCount <= 0L) {
                    Print.sysPrintln((String)"No future events found", (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)("Deleted " + delCount + " future events"), (Object[])new Object[0]);
                }
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting future events: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_CNT_OLD_EV) || RTConfig.hasProperty((String[])ARG_DEL_OLD_EV)) {
            String actionText;
            ++opts;
            boolean deleteEvents = RTConfig.hasProperty((String[])ARG_DEL_OLD_EV);
            String string = actionText = deleteEvents ? "Deleting" : "Counting";
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            TimeZone acctTMZ = acct.getTimeZone(null);
            String argTime = deleteEvents ? RTConfig.getString((String[])ARG_DEL_OLD_EV, (String)"") : RTConfig.getString((String[])ARG_CNT_OLD_EV, (String)"");
            DateTime oldTime = null;
            if (StringTools.isBlank((String)argTime)) {
                Print.logError((String)("Invalid time specification: " + argTime), (Object[])new Object[0]);
                System.exit(98);
            } else if (argTime.equalsIgnoreCase("current")) {
                oldTime = new DateTime(acctTMZ);
            } else {
                try {
                    oldTime = DateTime.parseArgumentDate((String)argTime, (TimeZone)acctTMZ, (boolean)true);
                }
                catch (DateTime.DateParseException dpe) {
                    oldTime = null;
                }
                if (oldTime == null) {
                    Print.sysPrintln((String)("Invalid Time specification: " + argTime), (Object[])new Object[0]);
                    System.exit(98);
                } else if (oldTime.getTimeSec() > DateTime.getCurrentTimeSec()) {
                    Print.sysPrintln((String)(actionText + " future events not allowed"), (Object[])new Object[0]);
                    System.exit(98);
                }
            }
            boolean usingRetainedDate = false;
            long oldTimeSec = oldTime.getTimeSec();
            if (deleteEvents) {
                long delOldTimeSec;
                long l = delOldTimeSec = deleteEvents ? acct.adjustRetainedEventTime(oldTimeSec) : oldTimeSec;
                if (delOldTimeSec != oldTimeSec) {
                    oldTimeSec = delOldTimeSec;
                    usingRetainedDate = true;
                }
            }
            if (usingRetainedDate) {
                Print.sysPrintln((String)(actionText + " events before \"" + new DateTime(oldTimeSec) + "\" (retained-date) ..."), (Object[])new Object[0]);
            } else {
                Print.sysPrintln((String)(actionText + " events before \"" + new DateTime(oldTimeSec) + "\" ..."), (Object[])new Object[0]);
            }
            boolean confirmDel = RTConfig.getBoolean((String[])ARG_CONFIRM_DEL, (boolean)false);
            try {
                String _devIDStr = devID;
                if (deleteEvents) {
                    if (!confirmDel) {
                        Print.sysPrintln((String)"ERROR: Missing '-confirmDelete', aborting delete ...", (Object[])new Object[0]);
                        System.exit(1);
                    }
                    StringBuffer sbMsg = new StringBuffer();
                    long delCount = deviceRcd.deleteOldEvents(oldTimeSec, sbMsg);
                    String msg = sbMsg.length() > 0 ? " (" + sbMsg + ")" : "";
                    Print.sysPrintln((String)("  Device: " + _devIDStr + " - Deleted " + delCount + " old events" + msg), (Object[])new Object[0]);
                } else {
                    long rcdCount = deviceRcd.countOldEvents(oldTimeSec);
                    if (rcdCount <= 0L) {
                        Print.sysPrintln((String)("  Device: " + _devIDStr + " - No old events found"), (Object[])new Object[0]);
                    } else {
                        Print.sysPrintln((String)("  Device: " + _devIDStr + " - Counted " + rcdCount + " old events"), (Object[])new Object[0]);
                    }
                }
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error " + actionText + " old events: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_RESET_ODOM)) {
            ++opts;
            long resetTime = RTConfig.getLong((String[])ARG_RESET_ODOM, (long)0L);
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            final AccumulatorLong count = new AccumulatorLong();
            final Device device = deviceRcd;
            double lastOdomKM = device.getLastOdometerKM();
            device.setLastOdometerKM(0.0);
            DBRecordHandler<EventData> odomResetHandler = new DBRecordHandler<EventData>(){
                private boolean firstZeroOdom = false;
                private EventData lastEvent = null;
                private double lastOdomKM = 0.0;

                public int handleDBRecord(EventData rcd) throws DBException {
                    EventData ev = rcd;
                    ev.setDevice(device);
                    ev.setPreviousEventData(this.lastEvent);
                    double evOdomKM = ev.getOdometerKM();
                    long evTime = ev.getTimestamp();
                    double evLat = ev.getLatitude();
                    double evLon = ev.getLongitude();
                    double evHead = ev.getHeading();
                    if (!this.firstZeroOdom) {
                        if (evOdomKM > 0.0) {
                            this.lastOdomKM = evOdomKM;
                            this.lastEvent = ev;
                            device.setLastOdometerKM(this.lastOdomKM);
                            device.setLastValidLatitude(evLat);
                            device.setLastValidLongitude(evLon);
                            device.setLastValidHeading(evHead);
                            device.setLastGPSTimestamp(evTime);
                            return 1;
                        }
                        this.firstZeroOdom = true;
                        if (this.lastEvent == null) {
                            this.lastOdomKM = evOdomKM;
                            this.lastEvent = ev;
                            device.setLastOdometerKM(this.lastOdomKM);
                            device.setLastValidLatitude(evLat);
                            device.setLastValidLongitude(evLon);
                            device.setLastValidHeading(evHead);
                            device.setLastGPSTimestamp(evTime);
                        }
                    }
                    this.lastOdomKM += ev.getGeoPoint().kilometersToPoint(this.lastEvent.getGeoPoint());
                    if (count.get() % 100L == 0L) {
                        Print.sysPrintln((String)("Updating Event " + evTime + " (" + new DateTime(evTime) + ") ==> " + this.lastOdomKM), (Object[])new Object[0]);
                    }
                    ev.setOdometerKM(this.lastOdomKM);
                    ev.update(new String[]{"odometerKM"});
                    this.lastEvent = ev;
                    device.setLastOdometerKM(this.lastOdomKM);
                    device.setLastValidLatitude(evLat);
                    device.setLastValidLongitude(evLon);
                    device.setLastValidHeading(evHead);
                    device.setLastGPSTimestamp(evTime);
                    count.increment();
                    return 1;
                }
            };
            try {
                EventData.getRangeEvents(acctID, devID, resetTime, -1L, null, true, EventData.LimitType.FIRST, -1L, true, null, odomResetHandler);
                device.update(new String[]{FLD_lastValidLatitude, FLD_lastValidLongitude, FLD_lastValidHeading, FLD_lastGPSTimestamp, FLD_lastOdometerKM});
                long lastGPSTime = device.getLastGPSTimestamp();
                Print.sysPrintln((String)("Timestamp of last event processed: " + lastGPSTime + " (" + new DateTime(lastGPSTime) + ")"), (Object[])new Object[0]);
                long c = count.get();
                if (c == 0L) {
                    Print.sysPrintln((String)"... done (no events updated)", (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)("... done (updated " + c + " events)"), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Error reading event records: " + acctID + "/" + devID), (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_SEND_COMMAND)) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            String cmdType = "config";
            String cmdName = RTConfig.getString((String[])ARG_SEND_COMMAND, (String)"");
            String[] cmdArgs = null;
            boolean success = deviceRcd.sendDeviceCommand(null, cmdName, cmdArgs);
            Print.sysPrintln((String)("Command Sent: " + success), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_SIM_PHONE)) {
            ++opts;
            String simPhone = RTConfig.getString((String[])ARG_SIM_PHONE, (String)"");
            try {
                List<String> devList = Device.getDeviceIDsForSimPhoneNumber(simPhone);
                if (!ListTools.isEmpty(devList)) {
                    Print.sysPrintln((String)("Found SIM Phone number: " + simPhone), (Object[])new Object[0]);
                    for (String ad : devList) {
                        Print.sysPrintln((String)("  " + ad), (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)("SIM Phone number not found: " + simPhone), (Object[])new Object[0]);
                }
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logException((String)"Getting SIM phone number", (Throwable)dbe);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String)"reminderTest")) {
            ++opts;
            if (!acctExists || !deviceExists) {
                Print.logError((String)("Account/Device does not exist: " + Device._fmtDevID(acctID, devID)), (Object[])new Object[0]);
                System.exit(98);
            }
            Device device = deviceRcd;
            TimeZone tz = acct.getTimeZone(null);
            String remIntStr = RTConfig.getString((String)"reminderTest", (String)"");
            long nowTime = DateTime.getCurrentTimeSec();
            REMINDER_LOG = true;
            device.setReminderInterval(remIntStr);
            boolean expired = device.isReminderExpired(tz, nowTime);
            if (expired) {
                try {
                    device.setReminderTime(nowTime);
                    device.update(new String[]{FLD_reminderTime});
                }
                catch (DBException dbe) {
                    Print.logException((String)"Error updating Device", (Throwable)dbe);
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            Device.usage();
        }
    }

    public static class DeviceDescriptionComparator
    implements Comparator<Device> {
        private boolean ascending = true;

        public DeviceDescriptionComparator() {
            this(true);
        }

        public DeviceDescriptionComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(Device dv1, Device dv2) {
            if (dv1 == dv2) {
                return 0;
            }
            if (dv1 == null) {
                return this.ascending ? -1 : 1;
            }
            if (dv2 == null) {
                return this.ascending ? 1 : -1;
            }
            String D1 = dv1.getDescription().toLowerCase();
            String D2 = dv2.getDescription().toLowerCase();
            return this.ascending ? D1.compareTo(D2) : D2.compareTo(D1);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof DeviceDescriptionComparator) {
                DeviceDescriptionComparator ddc = (DeviceDescriptionComparator)other;
                return this.ascending == ddc.ascending;
            }
            return false;
        }
    }

    public static interface EventDataHandler {
        public void handleEventDataRecord(EventData var1);
    }

    public static class GeozoneTransition {
        private long time = 0L;
        private Integer code = null;
        private Geozone zone = null;

        public GeozoneTransition(long timestamp, Integer code, Geozone zone) {
            this.time = timestamp;
            this.code = code;
            this.zone = zone;
        }

        public long getTimestamp() {
            return this.time;
        }

        public int getStatusCode() {
            return this.code;
        }

        public Geozone getGeozone() {
            return this.zone;
        }

        public String getGeozoneID() {
            return this.zone.getGeozoneID();
        }

        public String getGeozoneDescription() {
            return this.zone.getDescription();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[").append(StatusCodes.GetDescription(this.code, null)).append("] ");
            sb.append(this.getGeozoneID()).append(" - ");
            sb.append(this.getGeozoneDescription());
            return sb.toString();
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<Device> {
        public Key() {
        }

        public Key(String acctId, String devId) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
        }

        public DBFactory<Device> getFactory() {
            return Device.getFactory();
        }
    }

    public static enum FuelEconomyType implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        UNKNOWN(0, I18N.getString(Device.class, (String)"Device.fuelEconomyType.notAvail", (String)"n/a"), I18N.getString(Device.class, (String)"Device.fuelEconomyType.unknown", (String)"Unknown")),
        FUEL_CONSUMED(1, I18N.getString(Device.class, (String)"Device.fuelEconomyType.used", (String)"Used"), I18N.getString(Device.class, (String)"Device.fuelEconomyType.fuelUsed", (String)"Fuel Used")),
        FUEL_REMAINING(2, I18N.getString(Device.class, (String)"Device.fuelEconomyType.tank", (String)"Tank"), I18N.getString(Device.class, (String)"Device.fuelEconomyType.tankRemaining", (String)"Tank Remaining")),
        FUEL_LEVEL(3, I18N.getString(Device.class, (String)"Device.fuelEconomyType.level", (String)"Level"), I18N.getString(Device.class, (String)"Device.fuelEconomyType.fuelLevel", (String)"Fuel Level")),
        EVENT_ECONOMY(8, I18N.getString(Device.class, (String)"Device.fuelEconomyType.event", (String)"Event"), I18N.getString(Device.class, (String)"Device.fuelEconomyType.eventEconomy", (String)"Event Economy")),
        DEVICE_ECONOMY(9, I18N.getString(Device.class, (String)"Device.fuelEconomyType.device", (String)"Device"), I18N.getString(Device.class, (String)"Device.fuelEconomyType.deviceEconomy", (String)"Device Economy"));

        private int vv = 0;
        private I18N.Text aa = null;
        private I18N.Text dd = null;

        private FuelEconomyType(int v, I18N.Text a, I18N.Text d) {
            this.vv = v;
            this.aa = a;
            this.dd = d;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String getAbbrev() {
            return this.aa.toString();
        }

        public String getAbbrev(Locale loc) {
            return this.aa.toString(loc);
        }

        public String toString() {
            return this.dd.toString();
        }

        public String toString(Locale loc) {
            return this.dd.toString(loc);
        }
    }

    public static enum ReminderType implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        PERIODIC_INTERVAL(0, I18N.getString(Device.class, (String)"Device.reminderType.periodicInterval", (String)"Periodic Interval")),
        SINGLE_INTERVAL(1, I18N.getString(Device.class, (String)"Device.reminderType.singleInterval", (String)"Single Interval"));

        private int vv = 0;
        private I18N.Text aa = null;

        private ReminderType(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }
    }

    public static enum BorderCrossingState implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        OFF(0, I18N.getString(Device.class, (String)"Device.boarderCrossing.off", (String)"off")),
        ON(1, I18N.getString(Device.class, (String)"Device.boarderCrossing.on", (String)"on"));

        private int vv = 0;
        private I18N.Text aa = null;

        private BorderCrossingState(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }
    }

    public static enum EquipmentStatus implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        UNSPECIFIED(0, I18N.getString(Device.class, (String)"Device.EquipmentStatus.unspecified", (String)"Unspecified")),
        ASSIGNED(1000, I18N.getString(Device.class, (String)"Device.EquipmentStatus.assigned", (String)"Assigned")),
        ACTIVE(1100, I18N.getString(Device.class, (String)"Device.EquipmentStatus.assigned", (String)"Assigned")),
        INUSE(1200, I18N.getString(Device.class, (String)"Device.EquipmentStatus.inuse", (String)"InUse")),
        RENTED(1400, I18N.getString(Device.class, (String)"Device.EquipmentStatus.rented", (String)"Rented")),
        AUTHORIZED(2000, I18N.getString(Device.class, (String)"Device.EquipmentStatus.authorized", (String)"Authorized")),
        AVAILABLE(3000, I18N.getString(Device.class, (String)"Device.EquipmentStatus.available", (String)"Available")),
        SPARE(3300, I18N.getString(Device.class, (String)"Device.EquipmentStatus.available", (String)"Available")),
        UNAVAILABLE(4000, I18N.getString(Device.class, (String)"Device.EquipmentStatus.unavailable", (String)"Unavailable")),
        REPAIR(4200, I18N.getString(Device.class, (String)"Device.EquipmentStatus.repair", (String)"Repair")),
        PENDING(4400, I18N.getString(Device.class, (String)"Device.EquipmentStatus.pending", (String)"Pending")),
        IMPOUND(4600, I18N.getString(Device.class, (String)"Device.EquipmentStatus.impound", (String)"Impound")),
        STOLEN(9000, I18N.getString(Device.class, (String)"Device.EquipmentStatus.stolen", (String)"Stolen")),
        DECOMMISIONED(99000, I18N.getString(Device.class, (String)"Device.EquipmentStatus.decommissioned", (String)"Decommissioned"));

        private int vv = 0;
        private I18N.Text aa = null;

        private EquipmentStatus(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }
    }
}

