/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class AccountString
extends AccountRecord<AccountString> {
    public static final String ID_ACCOUNT = "account";
    public static final String ID_USER = "user";
    public static final String ID_DEVICE = "device";
    public static final String ID_DEVICE_NEW_DESCRIPTION = "deviceDesc";
    public static final String ID_DEVICE_GROUP = "deviceGroup";
    public static final String ID_ENTITY = "entity";
    public static final String ID_PING_DEVICE = "pingDevice";
    public static final String ID_ADDRESS = "address";
    public static final String[] ID_KEYS = new String[]{"account", "user", "device", "deviceDesc", "deviceGroup", "entity", "pingDevice", "address"};
    private static final String _TABLE_NAME = "AccountString";
    public static final String FLD_stringID = "stringID";
    public static final String FLD_singularTitle = "singularTitle";
    public static final String FLD_pluralTitle = "pluralTitle";
    private static DBField[] FieldInfo = new DBField[]{AccountString.newField_accountID(true), new DBField("stringID", String.class, DBField.TYPE_ID(), "String ID", "key=true editor=accountString"), new DBField("singularTitle", String.class, DBField.TYPE_STRING((int)64), "Singular Title", "edit=2"), new DBField("pluralTitle", String.class, DBField.TYPE_STRING((int)64), "Plural Title", "edit=2"), AccountString.newField_description(), AccountString.newField_lastUpdateTime(), AccountString.newField_lastUpdateUser((boolean)true), AccountString.newField_creationTime()};
    private static DBFactory<AccountString> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_STRING = new String[]{"string", "str"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_DELETE = new String[]{"delete"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<AccountString> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)AccountString.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, AccountString.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
        }
        return factory;
    }

    public AccountString() {
    }

    public AccountString(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(AccountString.class, (Locale)loc);
        return i18n.getString("AccountString.description", "This table defines Account specific customized String key/values.");
    }

    public String getStringID() {
        String v = (String)this.getFieldValue(FLD_stringID);
        return StringTools.trim((String)v);
    }

    private void setStringID(String v) {
        this.setFieldValue(FLD_stringID, StringTools.trim((String)v));
    }

    public String getSingularTitle() {
        String v = (String)this.getFieldValue(FLD_singularTitle);
        return StringTools.trim((String)v);
    }

    public boolean hasSingularTitle() {
        return !this.getSingularTitle().equals("");
    }

    public void setSingularTitle(String v) {
        this.setFieldValue(FLD_singularTitle, StringTools.trim((String)v));
    }

    public String getPluralTitle() {
        String v = (String)this.getFieldValue(FLD_pluralTitle);
        return StringTools.trim((String)v);
    }

    public boolean hasPluralTitle() {
        return !this.getPluralTitle().equals("");
    }

    public void setPluralTitle(String v) {
        this.setFieldValue(FLD_pluralTitle, StringTools.trim((String)v));
    }

    public void setCreationDefaultValues() {
        this.setDescription("String");
        this.setSingularTitle("singular");
        this.setPluralTitle("plural");
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getStringID();
    }

    public static boolean exists(String acctID, String strID) throws DBException {
        if (acctID != null && strID != null) {
            Key strKey = new Key(acctID, strID);
            return strKey.exists();
        }
        return false;
    }

    public static void updateAccountString(Account account, String stringID, String description, String singular, String plural) throws DBException {
        if (account == null) {
            throw new DBException("Account not specified.");
        }
        if ((singular == null || singular.equals("")) && (plural == null || plural.equals(""))) {
            String acctID = account.getAccountID();
            Key key = new Key(acctID, stringID);
            key.delete(true);
            return;
        }
        AccountString str = AccountString.getAccountString(account, stringID);
        if (str == null) {
            str = AccountString.getAccountString(account, stringID, true);
        }
        str.setDescription(description);
        str.setSingularTitle(singular);
        str.setPluralTitle(plural != null ? plural : singular);
        str.save();
    }

    public static AccountString getAccountString(Account account, String strID) throws DBException {
        if (account != null && strID != null) {
            String acctID = account.getAccountID();
            Key key = new Key(acctID, strID);
            if (key.exists()) {
                AccountString str = (AccountString)key.getDBRecord(true);
                str.setAccount(account);
                return str;
            }
            return null;
        }
        return null;
    }

    public static String[] getStringsArray(Account account, String strID, String[] dft) {
        try {
            AccountString str = AccountString.getAccountString(account, strID);
            if (str != null) {
                String s = str.getSingularTitle();
                String p = str.getPluralTitle();
                if (dft != null && dft.length >= 2) {
                    if (s.equals("")) {
                        s = dft[0];
                    }
                    if (p.equals("")) {
                        p = dft[1];
                    }
                }
                return new String[]{s, p};
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return dft;
    }

    public static AccountString getAccountString(Account account, String strID, boolean create) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String acctID = account.getAccountID();
        if (strID == null || strID.equals("")) {
            throw new DBNotFoundException("String-ID not specified for account: " + acctID);
        }
        AccountString str = null;
        Key strKey = new Key(acctID, strID);
        if (!strKey.exists()) {
            if (create) {
                str = (AccountString)strKey.getDBRecord();
                str.setAccount(account);
                str.setCreationDefaultValues();
                return str;
            }
            throw new DBNotFoundException("String-ID does not exists: " + (Object)((Object)strKey));
        }
        if (create) {
            throw new DBAlreadyExistsException("String-ID already exists '" + (Object)((Object)strKey) + "'");
        }
        str = AccountString.getAccountString(account, strID);
        if (str == null) {
            throw new DBException("Unable to read existing String-ID: " + (Object)((Object)strKey));
        }
        return str;
    }

    public static AccountString createNewAccountString(Account account, String strID) throws DBException {
        if (account != null && strID != null && !strID.equals("")) {
            AccountString str = AccountString.getAccountString(account, strID, true);
            str.save();
            return str;
        }
        throw new DBException("Invalid Account/StringID specified");
    }

    private static String _fmtStrID(String acctID, String strID) {
        return acctID + "/" + strID;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + AccountString.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Acount ID which owns AccountString", (Object[])new Object[0]);
        Print.logInfo((String)"  -string=<id>    String ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new AccountString", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           Edit an existing (or newly created) AccountString", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified AccountString", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String strID = RTConfig.getString((String[])ARG_STRING, (String)"");
        if (StringTools.isBlank((String)acctID)) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            AccountString.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(acctID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                AccountString.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (strID == null || strID.equals("")) {
            Print.logError((String)"String-ID not specified.", (Object[])new Object[0]);
            AccountString.usage();
        }
        boolean stringExists = false;
        try {
            stringExists = AccountString.exists(acctID, strID);
        }
        catch (DBException dbe) {
            Print.logError((String)("Error determining if AccountString exists: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && !acctID.equals("") && !strID.equals("")) {
            ++opts;
            if (!stringExists) {
                Print.logWarn((String)("AccountString does not exist: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key strKey = new Key(acctID, strID);
                strKey.delete(true);
                Print.logInfo((String)("AccountString deleted: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
                stringExists = false;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting AccountString: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (stringExists) {
                Print.logWarn((String)("AccountString already exists: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
            } else {
                try {
                    AccountString.createNewAccountString(acct, strID);
                    Print.logInfo((String)("Created AccountString: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
                    stringExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating AccountString: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false)) {
            ++opts;
            if (!stringExists) {
                Print.logError((String)("AccountString does not exist: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
            } else {
                try {
                    AccountString str = AccountString.getAccountString(acct, strID, false);
                    DBEdit editor = new DBEdit((DBRecord)str);
                    editor.edit(true);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing AccountString: " + AccountString._fmtStrID(acctID, strID)), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            AccountString.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<AccountString> {
        public Key() {
        }

        public Key(String acctId, String strKey) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue(AccountString.FLD_stringID, (Object)(strKey != null ? strKey.toLowerCase() : ""));
        }

        public DBFactory<AccountString> getFactory() {
            return AccountString.getFactory();
        }
    }
}

