/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.tables;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.DBConfig;
import org.opengts.db.GeneralPasswordHandler;
import org.opengts.db.PasswordHandler;
import org.opengts.db.RuleFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.UserInformation;
import org.opengts.db.tables.AccountString;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBAlreadyExistsException;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotAuthorizedException;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class Account
extends AccountRecord<Account>
implements UserInformation {
    public static final String OPTCOLS_AddressFieldInfo = "startupInit.Account.AddressFieldInfo";
    public static final String OPTCOLS_MapLegendFieldInfo = "startupInit.Account.MapLegendFieldInfo";
    public static final String OPTCOLS_AccountManagerInfo = "startupInit.Account.AccountManagerInfo";
    public static final String OPTCOLS_DataPushInfo = "startupInit.Account.DataPushInfo";
    public static final String ACL_CHANGE_PASSWORD = "acl.admin.password";
    public static final String ACL_CHANGE_ACCOUNT = "acl.admin.account";
    public static final String ACL_CHANGE_USER = "acl.admin.user";
    public static String SUPER_ACCOUNT_SEPARATOR = ":";
    public static String PROP_DemoAccount_ = "DemoAccount.";
    public static String PROP_DemoAccount_accountName = PROP_DemoAccount_ + "accountName";
    public static String PROP_DemoAccount_deviceNames = PROP_DemoAccount_ + "deviceNames";
    public static String _PROP_DemoAccount_device_dateRange = "dateRange";
    private static String DEFAULT_DEMO_ACCOUNT_ID = "demo";
    private static String[] DEFAULT_DEMO_DEVICE_IDS = new String[]{"demo", "demo2"};
    private static String[] DEFAULT_DEMO_DEVICE_DATE_RANGE = new String[]{"2013/08/26", "2013/08/26"};
    public static final long DFT_EXPIRATION_SEC = DateTime.DaySeconds((long)7L);
    public static final long MAX_EXPIRATION_SEC = DateTime.DaySeconds((long)60L);
    public static final long MAX_UNCONFIRMED_SEC = DateTime.HourSeconds((long)12L);
    private static Object TempAccountLock = new Object();
    public static final int TEMP_PASSWORD_LENGTH = 8;
    public static final String BLANK_PASSWORD = "*blank*";
    private static PasswordHandler passwordHandler = null;
    public static final String DEFAULT_TIMEZONE = "GMT";
    public static final double LITERS_PER_US_GALLON = 3.785411784;
    public static final double US_GALLONS_PER_LITER = 0.26417205235814845;
    public static final double LITERS_PER_UK_GALLON = 4.54609;
    public static final double UK_GALLONS_PER_LITER = 0.21996924829908776;
    public static final double CUBIC_FEET_PER_LITER = 0.0353146667;
    public static final double PA_PER_KPA = 1000.0;
    public static final double PSF_PER_KPA = 20.885434233;
    public static final double PSI_PER_KPA = 0.14503773773020923;
    public static final double TORR_PER_KPA = 7.500616827;
    public static final double MMHG_PER_KPA = 7.500637554;
    public static final double ATM_PER_KPA = 0.009869233;
    public static final double AT_PER_KPA = 0.010197162;
    public static final double BAR_PER_PA = 1.0E-5;
    public static final double BAR_PER_KPA = 0.01;
    public static final double KPA_PER_BAR = 100.0;
    public static final double KPA_PER_PSI = 6.894757293168361;
    public static final double LBS_PER_KG = 2.20462262185;
    public static final double METERS_PER_SEC_SQ_PER_G = 9.80665;
    public static final double MPSS_PER_G_FORCE = 9.80665;
    public static final double G_PER_MPSS_FORCE = 0.10197162129779283;
    public static final double MPH_PER_SEC_PER_MPSS = 0.44704;
    public static final double MPH_PER_SEC_PER_G = 21.9368512884753;
    public static final double SQUARE_METERS_PER_KILOMETER = 1000000.0;
    public static final double SQUARE_KILOMETERS_PER_METER = 1.0E-6;
    public static final double SQUARE_METERS_PER_MILE = 2589988.110336;
    public static final double SQUARE_MILES_PER_METER = 3.861021585424458E-7;
    public static final double SQUARE_METERS_PER_ACRE = 4046.8564224;
    public static final double ACRES_PER_SQUARE_METER = 2.471053814671653E-4;
    public static final double SQUARE_METERS_PER_FOOT = 0.09290304;
    public static final double SQUARE_FEET_PER_METER = 10.763910416709722;
    private static final String _TABLE_NAME = "Account";
    public static final String FLD_accountType = "accountType";
    public static final String FLD_notifyEmail = "notifyEmail";
    public static final String FLD_allowNotify = "allowNotify";
    public static final String FLD_speedUnits = "speedUnits";
    public static final String FLD_distanceUnits = "distanceUnits";
    public static final String FLD_volumeUnits = "volumeUnits";
    public static final String FLD_pressureUnits = "pressureUnits";
    public static final String FLD_economyUnits = "economyUnits";
    public static final String FLD_temperatureUnits = "temperatureUnits";
    public static final String FLD_latLonFormat = "latLonFormat";
    public static final String FLD_geocoderMode = "geocoderMode";
    public static final String FLD_privateLabelName = "privateLabelName";
    public static final String FLD_privateLabelJsp = "privateLabelJsp";
    public static final String FLD_isBorderCrossing = "isBorderCrossing";
    public static final String FLD_retainedEventAge = "retainedEventAge";
    public static final String FLD_maximumDevices = "maximumDevices";
    public static final String FLD_totalPingCount = "totalPingCount";
    public static final String FLD_maxPingCount = "maxPingCount";
    public static final String FLD_autoAddDevices = "autoAddDevices";
    public static final String FLD_dcsPropertiesID = "dcsPropertiesID";
    public static final String FLD_smsEnabled = "smsEnabled";
    public static final String FLD_smsProperties = "smsProperties";
    public static final String FLD_emailProperties = "emailProperties";
    public static final String FLD_expirationTime = "expirationTime";
    public static final String FLD_defaultUser = "defaultUser";
    public static final String FLD_password = "password";
    public static final String FLD_platformMessage = "platformMessage";
    public static final String FLD_contactName = "contactName";
    public static final String FLD_contactPhone = "contactPhone";
    public static final String FLD_contactEmail = "contactEmail";
    public static final String FLD_timeZone = "timeZone";
    public static final String FLD_passwdChangeTime = "passwdChangeTime";
    public static final String FLD_passwdQueryTime = "passwdQueryTime";
    public static final String FLD_lastLoginTime = "lastLoginTime";
    public static final DBField[] FieldInfo = new DBField[]{Account.newField_accountID(true), new DBField("accountType", Integer.TYPE, "UINT16", "Account Type", "edit=2 enum=Account$AccountType"), new DBField("notifyEmail", String.class, DBField.TYPE_EMAIL_LIST(), "Notification EMail Address", "edit=2"), new DBField("allowNotify", Boolean.TYPE, "BOOLEAN", "Allow Notification", "edit=2"), new DBField("speedUnits", Integer.TYPE, "UINT8", "Speed Units", "edit=2 enum=Account$SpeedUnits"), new DBField("distanceUnits", Integer.TYPE, "UINT8", "Distance Units", "edit=2 enum=Account$DistanceUnits"), new DBField("volumeUnits", Integer.TYPE, "UINT8", "Volume Units", "edit=2 enum=Account$VolumeUnits"), new DBField("pressureUnits", Integer.TYPE, "UINT8", "Pressure Units", "edit=2 enum=Account$PressureUnits"), new DBField("economyUnits", Integer.TYPE, "UINT8", "Economy Units", "edit=2 enum=Account$EconomyUnits"), new DBField("temperatureUnits", Integer.TYPE, "UINT8", "Temperature Units", "edit=2 enum=Account$TemperatureUnits"), new DBField("latLonFormat", Integer.TYPE, "UINT8", "Latitude/Longitude Format", "edit=2 enum=Account$LatLonFormat"), new DBField("geocoderMode", Integer.TYPE, "UINT8", "Geocoder Mode", "edit=2 enum=Account$GeocoderMode"), new DBField("privateLabelName", String.class, DBField.TYPE_STRING((int)32), "PrivateLabel Name", "edit=2 editor=privateLabel"), new DBField("isBorderCrossing", Boolean.TYPE, "BOOLEAN", "Is BorderCrossing Enabled", "edit=2"), new DBField("retainedEventAge", Long.TYPE, "UINT32", "Retained Event Age (sec)", "edit=2"), new DBField("maximumDevices", Long.TYPE, "INT32", "Maximum number of devices", "edit=2"), new DBField("totalPingCount", Integer.TYPE, "UINT16", "Total 'Ping' Count", ""), new DBField("maxPingCount", Integer.TYPE, "UINT16", "Maximum 'Ping' Count", "edit=2"), new DBField("autoAddDevices", Boolean.TYPE, "BOOLEAN", "AutoAdd Devices", "edit=2"), new DBField("dcsPropertiesID", String.class, DBField.TYPE_STRING((int)32), "DCS Properties ID", "edit=2"), new DBField("smsEnabled", Boolean.TYPE, "BOOLEAN", "SMS Enabled", "edit=2"), new DBField("smsProperties", String.class, DBField.TYPE_STRING((int)200), "SMS Properties", "edit=2"), new DBField("emailProperties", String.class, DBField.TYPE_STRING((int)250), "EMail Properties", "edit=2"), new DBField("expirationTime", Long.TYPE, "UINT32", "Expiration Time", "format=time"), new DBField("defaultUser", String.class, DBField.TYPE_USER_ID(), "Default User ID", "edit=2"), new DBField("password", String.class, DBField.TYPE_STRING((int)32), "Password", "edit=2 editor=password"), new DBField("platformMessage", String.class, DBField.TYPE_STRING((int)250), "Platform Message", "edit=2 utf8=true"), new DBField("contactName", String.class, DBField.TYPE_STRING((int)64), "Contact Name", "edit=2 utf8=true"), new DBField("contactPhone", String.class, DBField.TYPE_STRING((int)32), "Contact Phone", "edit=2"), new DBField("contactEmail", String.class, DBField.TYPE_STRING((int)128), "Contact EMail Address", "edit=2 altkey=email"), new DBField("timeZone", String.class, DBField.TYPE_STRING((int)32), "Time Zone", "edit=2 editor=timeZone"), new DBField("passwdChangeTime", Long.TYPE, "UINT32", "Last Password Change Time", "format=time"), new DBField("passwdQueryTime", Long.TYPE, "UINT32", "Last Password Query Time", "format=time"), new DBField("lastLoginTime", Long.TYPE, "UINT32", "Last Login Time", "format=time"), Account.newField_isActive(), Account.newField_displayName(), Account.newField_description(), Account.newField_notes(), Account.newField_lastUpdateTime(), Account.newField_lastUpdateUser((boolean)true), Account.newField_creationTime()};
    public static final String FLD_addressLine1 = "addressLine1";
    public static final String FLD_addressLine2 = "addressLine2";
    public static final String FLD_addressLine3 = "addressLine3";
    public static final String FLD_addressCity = "addressCity";
    public static final String FLD_addressState = "addressState";
    public static final String FLD_addressPostalCode = "addressPostalCode";
    public static final String FLD_addressCountry = "addressCountry";
    public static final DBField[] AddressFieldInfo = new DBField[]{new DBField("addressLine1", String.class, DBField.TYPE_STRING((int)70), "Address Line 1", "edit=2 utf8=true"), new DBField("addressLine2", String.class, DBField.TYPE_STRING((int)70), "Address Line 2", "edit=2 utf8=true"), new DBField("addressLine3", String.class, DBField.TYPE_STRING((int)70), "Address Line 3", "edit=2 utf8=true"), new DBField("addressCity", String.class, DBField.TYPE_STRING((int)50), "Address City", "edit=2 utf8=true"), new DBField("addressState", String.class, DBField.TYPE_STRING((int)50), "Address State/Province", "edit=2 utf8=true"), new DBField("addressPostalCode", String.class, DBField.TYPE_STRING((int)20), "Address Postal Code", "edit=2 utf8=true"), new DBField("addressCountry", String.class, DBField.TYPE_STRING((int)20), "Address Country", "edit=2 utf8=true")};
    public static final String FLD_mapLegendDevice = "mapLegendDevice";
    public static final String FLD_mapLegendGroup = "mapLegendGroup";
    public static final DBField[] MapLegendFieldInfo = new DBField[]{new DBField("mapLegendDevice", String.class, "TEXT", "Device Map Legend", "edit=2 utf8=true"), new DBField("mapLegendGroup", String.class, "TEXT", "DeviceGroup Map Legend", "edit=2 utf8=true")};
    public static final String FLD_isAccountManager = "isAccountManager";
    public static final String FLD_managerID = "managerID";
    public static final DBField[] AccountManagerInfo = new DBField[]{new DBField("isAccountManager", Boolean.TYPE, "BOOLEAN", "Is Account Manager", "edit=2"), new DBField("managerID", String.class, DBField.TYPE_ID(), "Manager ID", "edit=2 altkey=manager")};
    public static final String FLD_requestPassCode = "requestPassCode";
    public static final String FLD_requestIPAddress = "requestIPAddress";
    public static final String FLD_dataPushURL = "dataPushURL";
    public static final String FLD_lastDataRequestTime = "lastDataRequestTime";
    public static final String FLD_lastDataPushTime = "lastDataPushTime";
    public static final DBField[] DataPushInfo = new DBField[]{new DBField("requestPassCode", String.class, DBField.TYPE_STRING((int)32), "Request Passcode", "edit=2"), new DBField("requestIPAddress", DTIPAddrList.class, DBField.TYPE_STRING((int)128), "Valid Request IP Addresses", "edit=2"), new DBField("dataPushURL", String.class, DBField.TYPE_STRING((int)240), "Data Push URL (destination)", "edit=2"), new DBField("lastDataRequestTime", Long.TYPE, "UINT32", "Last Data Request Time", "format=time"), new DBField("lastDataPushTime", Long.TYPE, "UINT32", "Last Data Push Time (millis)", "format=time")};
    protected static DBFactory<Account> factory = null;
    private TimeZone timeZone = null;
    private static int borderCrossingExists = -1;
    private User currentUser = null;
    private BasicPrivateLabel privateLabel = null;
    private boolean foundPrivateLabel = false;
    private static final String PASSWORD_ALPHABET = "0123456789bcdfghjklmnpqrstvwxyzBCDFGHJKLMNPQRSTVWXYZ.@#&-=_+";
    private static final String[] KEY_ACCOUNT = EventData.KEY_ACCOUNT;
    private static final String[] KEY_DEVICE_COUNT = EventData.KEY_DEVICE_COUNT;
    private static final String[] KEY_DATETIME = EventData.KEY_DATETIME;
    private static final String[] KEY_DATE_YEAR = EventData.KEY_DATE_YEAR;
    private static final String[] KEY_DATE_MONTH = EventData.KEY_DATE_MONTH;
    private static final String[] KEY_DATE_DAY = EventData.KEY_DATE_DAY;
    private static final String[] KEY_DATE_DOW = EventData.KEY_DATE_DOW;
    private static final String[] KEY_TIME = EventData.KEY_TIME;
    private static final String[] KEY_EXPIREDATE = new String[]{"accountExpireDate", "acctExpireDate"};
    private static final String[] KEY_EXPIREDAYS = new String[]{"accountExpireDays", "acctExpireDays"};
    private static final String[] KEY_DISKUSAGE = new String[]{"gtsHomeDiskUsage", "gtsDiskUsage"};
    private static final String[] ARG_MANAGER = new String[]{"manager", "am", "m"};
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct", "a", "list", "report"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev", "d"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_NOPASS = new String[]{"nopass"};
    private static final String[] ARG_PASSWORD = new String[]{"password", "passwd", "pass"};
    private static final String[] ARG_SET_PASSWD = new String[]{"setPasswd", "setPass", "setPassword"};
    private static final String[] ARG_DESC = new String[]{"desc", "description"};
    private static final String[] ARG_EDIT = new String[]{"edit"};
    private static final String[] ARG_EDITALL = new String[]{"editall"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_REPORT = new String[]{"report"};
    private static final String[] ARG_PRUNE = new String[]{"prune"};
    private static final String[] ARG_XML = new String[]{"xml"};
    private static final String[] ARG_PRIVLABEL = new String[]{"privLabel", "pl"};
    private static final String[] ARG_LISTTYPE = new String[]{"listType", "type"};
    private static final String[] ARG_EVENTCOUNT = new String[]{"eventCount", "ec"};
    private static final String[] ARG_CNT_OLD_EV = new String[]{"countOldEvents"};
    private static final String[] ARG_DEL_OLD_EV = new String[]{"deleteOldEvents"};
    private static final String[] ARG_CONFIRM_DEL = new String[]{"confirmDelete"};
    private static final String[] ARG_FIND_EMAIL = new String[]{"findEMail"};

    public static String[] GetTitles(Locale loc) {
        I18N i18n = I18N.getI18N(Account.class, (Locale)loc);
        return new String[]{i18n.getString("Account.title.singular", _TABLE_NAME), i18n.getString("Account.title.plural", "Accounts")};
    }

    public static String getAccountDisplayID(String accountID) {
        int p;
        if (accountID != null && (p = accountID.indexOf(SUPER_ACCOUNT_SEPARATOR)) >= 0) {
            return accountID.substring(p + 1);
        }
        return accountID;
    }

    public static String GetDemoAccountID() {
        String da = RTConfig.getString((String)PROP_DemoAccount_accountName, (String)DEFAULT_DEMO_ACCOUNT_ID);
        return da;
    }

    public static boolean IsDemoAccount(String accountID) {
        if (!StringTools.isBlank((String)accountID)) {
            return accountID.equals(Account.GetDemoAccountID());
        }
        return false;
    }

    public static String[] GetDemoAccountDeviceIDs() {
        String[] dd = RTConfig.getStringArray((String)PROP_DemoAccount_deviceNames, (String[])DEFAULT_DEMO_DEVICE_IDS);
        Print.logInfo((String)("Demo Devices: " + StringTools.join((String[])dd, (String)"|")), (Object[])new Object[0]);
        return dd;
    }

    public static boolean IsDemoDevice(String accountID, String deviceID) {
        Object[] did;
        if (Account.IsDemoAccount(accountID) && !StringTools.isBlank((String)deviceID) && ListTools.size((Object[])(did = Account.GetDemoAccountDeviceIDs())) > 0) {
            for (int i = 0; i < did.length; ++i) {
                if (!deviceID.equals(did[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] GetDemoDeviceDateRange(String accountID, String deviceID) {
        if (Account.IsDemoDevice(accountID, deviceID)) {
            String key = PROP_DemoAccount_ + deviceID + _PROP_DemoAccount_device_dateRange;
            String[] dr = RTConfig.getStringArray((String)key, (String[])DEFAULT_DEMO_DEVICE_DATE_RANGE);
            Print.logInfo((String)("Demo Device: " + accountID + "/" + deviceID + " Date Rage " + StringTools.join((String[])dr, (String)",")), (Object[])new Object[0]);
            return dr;
        }
        return null;
    }

    public static SMSDefaultState GetDefaultSmsEnabledState() {
        String smsState = RTConfig.getString((String)"Account.smsEnabled", (String)"");
        if (StringTools.isBoolean((String)smsState, (boolean)false)) {
            return StringTools.parseBoolean((String)smsState, (boolean)false) ? SMSDefaultState.TRUE : SMSDefaultState.FALSE;
        }
        return SMSDefaultState.ACCOUNT;
    }

    public static boolean IsFixedSmsEnabledState() {
        switch (Account.GetDefaultSmsEnabledState()) {
            case FALSE: 
            case TRUE: {
                return true;
            }
        }
        return false;
    }

    public static void setDefaultPasswordHandler(PasswordHandler ph) {
        passwordHandler = ph;
    }

    public static PasswordHandler getDefaultPasswordHandler() {
        if (passwordHandler == null) {
            passwordHandler = new GeneralPasswordHandler();
        }
        return passwordHandler;
    }

    public static PasswordHandler getPasswordHandler(BasicPrivateLabel bpl) {
        if (bpl != null) {
            return bpl.getPasswordHandler();
        }
        return Account.getDefaultPasswordHandler();
    }

    public static AccountType getAccountType(Account a) {
        return a != null ? (AccountType)EnumTools.getValueOf(AccountType.class, (int)a.getAccountType()) : (AccountType)EnumTools.getDefault(AccountType.class);
    }

    public static GeocoderMode getGeocoderMode(Account a) {
        return a != null ? (GeocoderMode)EnumTools.getValueOf(GeocoderMode.class, (int)a.getGeocoderMode()) : (GeocoderMode)EnumTools.getDefault(GeocoderMode.class);
    }

    public static SpeedUnits getSpeedUnits(Account a) {
        return a != null ? (SpeedUnits)EnumTools.getValueOf(SpeedUnits.class, (int)a.getSpeedUnits()) : (SpeedUnits)EnumTools.getDefault(SpeedUnits.class);
    }

    public static SpeedUnits getSpeedUnits(User u) {
        return u != null ? (SpeedUnits)EnumTools.getValueOf(SpeedUnits.class, (int)u.getSpeedUnits()) : (SpeedUnits)EnumTools.getDefault(SpeedUnits.class);
    }

    public static DistanceUnits getDistanceUnits(Account a) {
        return a != null ? (DistanceUnits)EnumTools.getValueOf(DistanceUnits.class, (int)a.getDistanceUnits()) : (DistanceUnits)EnumTools.getDefault(DistanceUnits.class);
    }

    public static DistanceUnits getDistanceUnits(User u) {
        return u != null ? (DistanceUnits)EnumTools.getValueOf(DistanceUnits.class, (int)u.getDistanceUnits()) : (DistanceUnits)EnumTools.getDefault(DistanceUnits.class);
    }

    public static AltitudeUnits getAltitudeUnits(Account a) {
        DistanceUnits distUnits = Account.getDistanceUnits(a);
        return distUnits.isMiles() || distUnits.isKnots() ? AltitudeUnits.FEET : AltitudeUnits.METERS;
    }

    public static AltitudeUnits getAltitudeUnits(User u) {
        DistanceUnits distUnits = Account.getDistanceUnits(u);
        return distUnits.isMiles() || distUnits.isKnots() ? AltitudeUnits.FEET : AltitudeUnits.METERS;
    }

    public static TemperatureUnits getTemperatureUnits(Account a) {
        return a != null ? (TemperatureUnits)EnumTools.getValueOf(TemperatureUnits.class, (int)a.getTemperatureUnits()) : (TemperatureUnits)EnumTools.getDefault(TemperatureUnits.class);
    }

    public static VolumeUnits getVolumeUnits(Account a) {
        return a != null ? (VolumeUnits)EnumTools.getValueOf(VolumeUnits.class, (int)a.getVolumeUnits()) : (VolumeUnits)EnumTools.getDefault(VolumeUnits.class);
    }

    public static EconomyUnits getEconomyUnits(Account a) {
        return a != null ? (EconomyUnits)EnumTools.getValueOf(EconomyUnits.class, (int)a.getEconomyUnits()) : (EconomyUnits)EnumTools.getDefault(EconomyUnits.class);
    }

    public static PressureUnits getPressureUnits(Account a) {
        return a != null ? (PressureUnits)EnumTools.getValueOf(PressureUnits.class, (int)a.getPressureUnits()) : (PressureUnits)EnumTools.getDefault(PressureUnits.class);
    }

    public static MassUnits getMassUnits(Account a) {
        if (a != null) {
            VolumeUnits vu = Account.getVolumeUnits(a);
            MassUnits massUnits = vu.isUSGallons() ? MassUnits.LB : MassUnits.KG;
            return (MassUnits)EnumTools.getValueOf(MassUnits.class, (Enum)massUnits);
        }
        return (MassUnits)EnumTools.getDefault(MassUnits.class);
    }

    public static LatLonFormat getLatLonFormat(Account a) {
        return a != null ? (LatLonFormat)EnumTools.getValueOf(LatLonFormat.class, (int)a.getLatLonFormat()) : (LatLonFormat)EnumTools.getDefault(LatLonFormat.class);
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Account> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Account.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Account.class, Key.class, (boolean)true, (boolean)true);
        }
        return factory;
    }

    public Account() {
    }

    public Account(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Account.class, (Locale)loc);
        return i18n.getString("Account.description", "This table defines the top level Account specific information.");
    }

    public String getDefaultUser() {
        String v = (String)this.getFieldValue(FLD_defaultUser);
        return v != null ? v : "";
    }

    public void setDefaultUser(String v) {
        this.setFieldValue(FLD_defaultUser, StringTools.trim((String)v));
    }

    public static String getDefaultUser(Account acct, boolean rtnAdmin) {
        String userID;
        String string = userID = acct != null ? acct.getDefaultUser() : null;
        if (!StringTools.isBlank((String)userID)) {
            return userID;
        }
        if (rtnAdmin) {
            return User.getAdminUserID();
        }
        return null;
    }

    public String getPassword() {
        String p = (String)this.getFieldValue(FLD_password);
        return p != null ? p : "";
    }

    public void setPassword(String p) {
        this.setFieldValue(FLD_password, p != null ? p : "");
        this.setPasswdChangeTime(DateTime.getCurrentTimeSec());
    }

    @Override
    public String getEncodedPassword() {
        return this.getPassword();
    }

    public void setEncodedPassword(String p) {
        this.setPassword(p);
    }

    public String getDecodedPassword(BasicPrivateLabel bpl) {
        if (bpl == null) {
            bpl = this.getPrivateLabel();
        }
        String pass = Account.decodePassword(bpl, this.getEncodedPassword());
        return pass;
    }

    @Override
    public void setDecodedPassword(BasicPrivateLabel bpl, String enteredPass) {
        if (bpl == null) {
            bpl = this.getPrivateLabel();
        }
        String pass = Account.encodePassword(bpl, enteredPass);
        if (!this.getEncodedPassword().equals(pass)) {
            this.setEncodedPassword(pass);
        }
    }

    public String resetPassword(BasicPrivateLabel bpl) {
        String pass = Account.createRandomPassword(8);
        this.setDecodedPassword(bpl, pass);
        return pass;
    }

    @Override
    public boolean checkPassword(BasicPrivateLabel bpl, String enteredPass) {
        if (bpl == null) {
            bpl = this.getPrivateLabel();
        }
        return Account.checkPassword(bpl, enteredPass, this.getEncodedPassword());
    }

    public static boolean checkPassword(BasicPrivateLabel bpl, String enteredPass, String tablePass) {
        PasswordHandler pwh = Account.getPasswordHandler(bpl);
        return pwh.checkPassword(enteredPass, tablePass);
    }

    public static String encodePassword(BasicPrivateLabel bpl, String enteredPass) {
        PasswordHandler pwh = Account.getPasswordHandler(bpl);
        return pwh.encodePassword(enteredPass);
    }

    public static String decodePassword(BasicPrivateLabel bpl, String tablePass) {
        PasswordHandler pwh = Account.getPasswordHandler(bpl);
        return pwh.decodePassword(tablePass);
    }

    public int getAccountType() {
        Integer v = (Integer)this.getFieldValue(FLD_accountType);
        return v != null ? v.intValue() : ((AccountType)EnumTools.getDefault(AccountType.class)).getIntValue();
    }

    public void setAccountType(int v) {
        this.setFieldValue(FLD_accountType, ((AccountType)EnumTools.getValueOf(AccountType.class, (int)v)).getIntValue());
    }

    public void setAccountType(AccountType v) {
        this.setFieldValue(FLD_accountType, ((AccountType)EnumTools.getValueOf(AccountType.class, (Enum)v)).getIntValue());
    }

    public void setAccountType(String v, Locale locale) {
        this.setFieldValue(FLD_accountType, ((AccountType)EnumTools.getValueOf(AccountType.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getPlatformMessage() {
        String v = (String)this.getFieldValue(FLD_platformMessage);
        return StringTools.trim((String)v);
    }

    public void setPlatformMessage(String v) {
        this.setFieldValue(FLD_platformMessage, StringTools.trim((String)v));
    }

    @Override
    public String getContactName() {
        String v = (String)this.getFieldValue(FLD_contactName);
        return StringTools.trim((String)v);
    }

    @Override
    public void setContactName(String v) {
        this.setFieldValue(FLD_contactName, StringTools.trim((String)v));
    }

    @Override
    public String getContactPhone() {
        String v = (String)this.getFieldValue(FLD_contactPhone);
        return StringTools.trim((String)v);
    }

    @Override
    public void setContactPhone(String v) {
        this.setFieldValue(FLD_contactPhone, StringTools.trim((String)v));
    }

    @Override
    public String getContactEmail() {
        String v = (String)this.getFieldValue(FLD_contactEmail);
        return StringTools.trim((String)v);
    }

    @Override
    public void setContactEmail(String v) {
        this.setFieldValue(FLD_contactEmail, StringTools.trim((String)v));
    }

    public String getNotifyEmail() {
        String v = (String)this.getFieldValue(FLD_notifyEmail);
        return StringTools.trim((String)v);
    }

    public void setNotifyEmail(String v) {
        this.setFieldValue(FLD_notifyEmail, StringTools.trim((String)v));
    }

    public boolean getAllowNotify() {
        Boolean v = (Boolean)this.getOptionalFieldValue(FLD_allowNotify);
        return v != null ? v : false;
    }

    public void setAllowNotify(boolean v) {
        this.setOptionalFieldValue(FLD_allowNotify, v);
    }

    public static TimeZone getTimeZone(Account account, TimeZone dft) {
        return account != null ? account.getTimeZone(dft) : dft;
    }

    public TimeZone getTimeZone(TimeZone dft) {
        if (this.timeZone == null) {
            this.timeZone = DateTime.getTimeZone((String)this.getTimeZone(), null);
            if (this.timeZone == null) {
                this.timeZone = dft != null ? dft : DateTime.getGMTTimeZone();
            }
        }
        return this.timeZone;
    }

    @Override
    public String getTimeZone() {
        String v = (String)this.getFieldValue(FLD_timeZone);
        return v != null && !v.equals("") ? v.trim() : DEFAULT_TIMEZONE;
    }

    @Override
    public void setTimeZone(String v) {
        this.timeZone = null;
        this.setFieldValue(FLD_timeZone, v != null && !v.equals("") ? v.trim() : DEFAULT_TIMEZONE);
    }

    public DateTime getCurrentDateTime() {
        return new DateTime(this.getTimeZone(null));
    }

    public long getPasswdChangeTime() {
        Long v = (Long)this.getFieldValue(FLD_passwdChangeTime);
        return v != null ? v : 0L;
    }

    public void setPasswdChangeTime(long v) {
        this.setFieldValue(FLD_passwdChangeTime, v);
    }

    public boolean hasPasswordExpired() {
        BasicPrivateLabel bpl = this.getPrivateLabel();
        PasswordHandler pwh = Account.getPasswordHandler(bpl);
        return pwh.hasPasswordExpired(this.getPasswdChangeTime());
    }

    @Override
    public long getPasswdQueryTime() {
        Long v = (Long)this.getFieldValue(FLD_passwdQueryTime);
        return v != null ? v : 0L;
    }

    @Override
    public void setPasswdQueryTime(long v) {
        this.setFieldValue(FLD_passwdQueryTime, v);
    }

    public boolean hasRetainedEventAge() {
        return this.getRetainedEventAge() > 0L;
    }

    public long getRetainedEventAge() {
        Long v = (Long)this.getFieldValue(FLD_retainedEventAge);
        return v != null ? v : 0L;
    }

    public void setRetainedEventAge(long v) {
        this.setFieldValue(FLD_retainedEventAge, v);
    }

    public long adjustRetainedEventTime(long oldTimeSec) {
        long retainedTimeSec;
        long retainedAgeSec = this.getRetainedEventAge();
        if (retainedAgeSec > 0L && (retainedTimeSec = DateTime.getCurrentTimeSec() - retainedAgeSec) < oldTimeSec && (oldTimeSec = retainedTimeSec) < 1L) {
            oldTimeSec = 1L;
        }
        return oldTimeSec;
    }

    public boolean exceedsMaximumDevices(long devCnt, boolean zeroUnlimited) {
        long maxCnt = this.getMaximumDevices();
        if (maxCnt < 0L) {
            return false;
        }
        if (maxCnt == 0L && zeroUnlimited) {
            return false;
        }
        return devCnt > maxCnt;
    }

    public long getMaximumDevices() {
        Long v = (Long)this.getFieldValue(FLD_maximumDevices);
        return v != null ? (long)v.intValue() : -1L;
    }

    public void setMaximumDevices(long v) {
        this.setFieldValue(FLD_maximumDevices, v);
    }

    public int getTotalPingCount() {
        Integer v = (Integer)this.getFieldValue(FLD_totalPingCount);
        return v != null ? v : 0;
    }

    public void setTotalPingCount(int v) {
        this.setFieldValue(FLD_totalPingCount, v >= 0 ? v : 0);
    }

    public boolean incrementPingCount(long pingTime, boolean reload, boolean update) {
        if (reload) {
            this.reload(new String[]{FLD_totalPingCount});
        }
        this.setTotalPingCount(this.getTotalPingCount() + 1);
        if (pingTime > 0L) {
            // empty if block
        }
        if (update) {
            try {
                this.update(new String[]{FLD_totalPingCount});
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to update 'ping' count", (Throwable)dbe);
                return false;
            }
        }
        return true;
    }

    public boolean resetTotalPingCount(boolean update) {
        this.setTotalPingCount(0);
        if (update) {
            try {
                this.update(new String[]{FLD_totalPingCount});
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to update 'ping' count", (Throwable)dbe);
                return false;
            }
        }
        return true;
    }

    public int getMaxPingCount() {
        Integer v = (Integer)this.getFieldValue(FLD_maxPingCount);
        return v != null ? v : 0;
    }

    public void setMaxPingCount(int v) {
        this.setFieldValue(FLD_maxPingCount, v >= 0 ? v : 0);
    }

    public long getExpirationTime() {
        Long v = (Long)this.getFieldValue(FLD_expirationTime);
        return v != null ? v : 0L;
    }

    public void setExpirationTime(long v) {
        this.setFieldValue(FLD_expirationTime, v);
    }

    public boolean isExpired() {
        long expireTime = this.getExpirationTime();
        return expireTime > 0L && expireTime < DateTime.getCurrentTimeSec();
    }

    public boolean doesExpire() {
        long expireTime = this.getExpirationTime();
        return expireTime > 0L;
    }

    public boolean willExpire(long withinSec) {
        long expireTime = this.getExpirationTime();
        return expireTime > 0L && (withinSec < 0L || expireTime < DateTime.getCurrentTimeSec() + withinSec);
    }

    public String getAddressLine1() {
        String v = (String)this.getFieldValue(FLD_addressLine1);
        return StringTools.trim((String)v);
    }

    public String getAddressLine2() {
        String v = (String)this.getFieldValue(FLD_addressLine2);
        return StringTools.trim((String)v);
    }

    public String getAddressLine3() {
        String v = (String)this.getFieldValue(FLD_addressLine3);
        return StringTools.trim((String)v);
    }

    public String[] getAddressLines() {
        return new String[]{this.getAddressLine1(), this.getAddressLine2(), this.getAddressLine3()};
    }

    public String getAddressCity() {
        String v = (String)this.getFieldValue(FLD_addressCity);
        return StringTools.trim((String)v);
    }

    public String getAddressState() {
        String v = (String)this.getFieldValue(FLD_addressState);
        return StringTools.trim((String)v);
    }

    public String getAddressPostalCode() {
        String v = (String)this.getFieldValue(FLD_addressPostalCode);
        return StringTools.trim((String)v);
    }

    public String getAddressCountry() {
        String v = (String)this.getFieldValue(FLD_addressCountry);
        return StringTools.trim((String)v);
    }

    public void setAddressLine1(String v) {
        this.setFieldValue(FLD_addressLine1, StringTools.trim((String)v));
    }

    public void setAddressLine2(String v) {
        this.setFieldValue(FLD_addressLine2, StringTools.trim((String)v));
    }

    public void setAddressLine3(String v) {
        this.setFieldValue(FLD_addressLine3, StringTools.trim((String)v));
    }

    public void setAddressLines(String[] lines) {
        if (lines != null && lines.length > 0) {
            int n;
            for (n = 0; n < lines.length && (lines[n] == null || lines[n].trim().equals("")); ++n) {
            }
            this.setAddressLine1(n < lines.length ? lines[n++].trim() : "");
            while (n < lines.length && (lines[n] == null || lines[n].trim().equals(""))) {
                ++n;
            }
            this.setAddressLine2(n < lines.length ? lines[n++].trim() : "");
            while (n < lines.length && (lines[n] == null || lines[n].trim().equals(""))) {
                ++n;
            }
            this.setAddressLine3(n < lines.length ? lines[n++].trim() : "");
        } else {
            this.setAddressLine1("");
            this.setAddressLine2("");
            this.setAddressLine3("");
        }
    }

    public void setAddressCity(String v) {
        this.setFieldValue(FLD_addressCity, StringTools.trim((String)v));
    }

    public void setAddressState(String v) {
        this.setFieldValue(FLD_addressState, StringTools.trim((String)v));
    }

    public void setAddressPostalCode(String v) {
        this.setFieldValue(FLD_addressPostalCode, StringTools.trim((String)v));
    }

    public void setAddressCountry(String v) {
        this.setFieldValue(FLD_addressCountry, StringTools.trim((String)v));
    }

    public int getSpeedUnits() {
        Integer v = (Integer)this.getFieldValue(FLD_speedUnits);
        return v != null ? v.intValue() : ((SpeedUnits)EnumTools.getDefault(SpeedUnits.class)).getIntValue();
    }

    public void setSpeedUnits(int v) {
        this.setFieldValue(FLD_speedUnits, ((SpeedUnits)EnumTools.getValueOf(SpeedUnits.class, (int)v)).getIntValue());
    }

    public void setSpeedUnits(SpeedUnits v) {
        this.setFieldValue(FLD_speedUnits, ((SpeedUnits)EnumTools.getValueOf(SpeedUnits.class, (Enum)v)).getIntValue());
    }

    public void setSpeedUnits(String v, Locale locale) {
        this.setFieldValue(FLD_speedUnits, ((SpeedUnits)EnumTools.getValueOf(SpeedUnits.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getSpeedString(double speedKPH, boolean inclUnits, Locale locale) {
        return this.getSpeedString(speedKPH, "0", null, inclUnits, locale);
    }

    public String getSpeedString(double speedKPH, String format, boolean inclUnits, Locale locale) {
        return this.getSpeedString(speedKPH, format, null, inclUnits, locale);
    }

    public String getSpeedString(double speedKPH, String format, SpeedUnits speedUnitsEnum, boolean inclUnits, Locale locale) {
        if (speedUnitsEnum == null) {
            speedUnitsEnum = Account.getSpeedUnits(this);
        }
        double speed = speedUnitsEnum.convertFromKPH(speedKPH);
        String speedFmt = StringTools.format((double)speed, (String)format);
        if (speed <= 0.0) {
            return speedFmt;
        }
        if (inclUnits) {
            return speedFmt + " " + speedUnitsEnum.toString(locale);
        }
        return speedFmt;
    }

    public int getDistanceUnits() {
        Integer v = (Integer)this.getFieldValue(FLD_distanceUnits);
        return v != null ? v.intValue() : ((DistanceUnits)EnumTools.getDefault(DistanceUnits.class)).getIntValue();
    }

    public void setDistanceUnits(int v) {
        this.setFieldValue(FLD_distanceUnits, ((DistanceUnits)EnumTools.getValueOf(DistanceUnits.class, (int)v)).getIntValue());
    }

    public void setDistanceUnits(DistanceUnits v) {
        this.setFieldValue(FLD_distanceUnits, ((DistanceUnits)EnumTools.getValueOf(DistanceUnits.class, (Enum)v)).getIntValue());
    }

    public void setDistanceUnits(String v, Locale locale) {
        this.setFieldValue(FLD_distanceUnits, ((DistanceUnits)EnumTools.getValueOf(DistanceUnits.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getDistanceString(double distKM, boolean inclUnits, Locale locale) {
        DistanceUnits units = Account.getDistanceUnits(this);
        String distUnitsStr = units.toString(locale);
        double dist = units.convertFromKM(distKM);
        String distStr = StringTools.format((double)dist, (String)"0");
        return inclUnits ? distStr + " " + distUnitsStr : distStr;
    }

    public int getVolumeUnits() {
        Integer v = (Integer)this.getFieldValue(FLD_volumeUnits);
        if (v != null) {
            return v;
        }
        switch (Account.getDistanceUnits(this)) {
            case MILES: {
                return VolumeUnits.US_GALLONS.getIntValue();
            }
        }
        return VolumeUnits.LITERS.getIntValue();
    }

    public void setVolumeUnits(int v) {
        this.setFieldValue(FLD_volumeUnits, ((VolumeUnits)EnumTools.getValueOf(VolumeUnits.class, (int)v)).getIntValue());
    }

    public void setVolumeUnits(VolumeUnits v) {
        this.setFieldValue(FLD_volumeUnits, ((VolumeUnits)EnumTools.getValueOf(VolumeUnits.class, (Enum)v)).getIntValue());
    }

    public void setVolumeUnits(String v, Locale locale) {
        this.setFieldValue(FLD_volumeUnits, ((VolumeUnits)EnumTools.getValueOf(VolumeUnits.class, (String)v, (Locale)locale)).getIntValue());
    }

    public int getPressureUnits() {
        Integer v = (Integer)this.getFieldValue(FLD_pressureUnits);
        if (v != null) {
            return v;
        }
        switch (Account.getVolumeUnits(this)) {
            case US_GALLONS: {
                return PressureUnits.PSI.getIntValue();
            }
        }
        return PressureUnits.KPA.getIntValue();
    }

    public void setPressureUnits(int v) {
        this.setFieldValue(FLD_pressureUnits, ((PressureUnits)EnumTools.getValueOf(PressureUnits.class, (int)v)).getIntValue());
    }

    public void setPressureUnits(PressureUnits v) {
        this.setFieldValue(FLD_pressureUnits, ((PressureUnits)EnumTools.getValueOf(PressureUnits.class, (Enum)v)).getIntValue());
    }

    public void setPressureUnits(String v, Locale locale) {
        this.setFieldValue(FLD_pressureUnits, ((PressureUnits)EnumTools.getValueOf(PressureUnits.class, (String)v, (Locale)locale)).getIntValue());
    }

    public int getEconomyUnits() {
        Integer v = (Integer)this.getFieldValue(FLD_economyUnits);
        if (v != null) {
            return v;
        }
        switch (Account.getVolumeUnits(this)) {
            case US_GALLONS: {
                return EconomyUnits.MPG.getIntValue();
            }
        }
        return EconomyUnits.KPL.getIntValue();
    }

    public void setEconomyUnits(int v) {
        this.setFieldValue(FLD_economyUnits, ((EconomyUnits)EnumTools.getValueOf(EconomyUnits.class, (int)v)).getIntValue());
    }

    public void setEconomyUnits(EconomyUnits v) {
        this.setFieldValue(FLD_economyUnits, ((EconomyUnits)EnumTools.getValueOf(EconomyUnits.class, (Enum)v)).getIntValue());
    }

    public void setEconomyUnits(String v, Locale locale) {
        this.setFieldValue(FLD_economyUnits, ((EconomyUnits)EnumTools.getValueOf(EconomyUnits.class, (String)v, (Locale)locale)).getIntValue());
    }

    public int getTemperatureUnits() {
        Integer v = (Integer)this.getFieldValue(FLD_temperatureUnits);
        return v != null ? v.intValue() : ((TemperatureUnits)EnumTools.getDefault(TemperatureUnits.class)).getIntValue();
    }

    public void setTemperatureUnits(int v) {
        this.setFieldValue(FLD_temperatureUnits, ((TemperatureUnits)EnumTools.getValueOf(TemperatureUnits.class, (int)v)).getIntValue());
    }

    public void setTemperatureUnits(TemperatureUnits v) {
        this.setFieldValue(FLD_temperatureUnits, ((TemperatureUnits)EnumTools.getValueOf(TemperatureUnits.class, (Enum)v)).getIntValue());
    }

    public void setTemperatureUnits(String v, Locale locale) {
        this.setFieldValue(FLD_temperatureUnits, ((TemperatureUnits)EnumTools.getValueOf(TemperatureUnits.class, (String)v, (Locale)locale)).getIntValue());
    }

    public int getLatLonFormat() {
        Integer v = (Integer)this.getFieldValue(FLD_latLonFormat);
        return v != null ? v.intValue() : ((LatLonFormat)EnumTools.getDefault(LatLonFormat.class)).getIntValue();
    }

    public void setLatLonFormat(int v) {
        this.setFieldValue(FLD_latLonFormat, ((LatLonFormat)EnumTools.getValueOf(LatLonFormat.class, (int)v)).getIntValue());
    }

    public void setLatLonFormat(LatLonFormat v) {
        this.setFieldValue(FLD_latLonFormat, ((LatLonFormat)EnumTools.getValueOf(LatLonFormat.class, (Enum)v)).getIntValue());
    }

    public void setLatLonFormat(String v, Locale locale) {
        this.setFieldValue(FLD_latLonFormat, ((LatLonFormat)EnumTools.getValueOf(LatLonFormat.class, (String)v, (Locale)locale)).getIntValue());
    }

    public int getGeocoderMode() {
        Integer v = (Integer)this.getFieldValue(FLD_geocoderMode);
        return v != null ? v.intValue() : ((GeocoderMode)EnumTools.getDefault(GeocoderMode.class)).getIntValue();
    }

    public void setGeocoderMode(int v) {
        this.setFieldValue(FLD_geocoderMode, ((GeocoderMode)EnumTools.getValueOf(GeocoderMode.class, (int)v)).getIntValue());
    }

    public void setGeocoderMode(GeocoderMode v) {
        this.setFieldValue(FLD_geocoderMode, ((GeocoderMode)EnumTools.getValueOf(GeocoderMode.class, (Enum)v)).getIntValue());
    }

    public void setGeocoderMode(String v, Locale locale) {
        this.setFieldValue(FLD_geocoderMode, ((GeocoderMode)EnumTools.getValueOf(GeocoderMode.class, (String)v, (Locale)locale)).getIntValue());
    }

    public String getPrivateLabelName() {
        String v = (String)this.getFieldValue(FLD_privateLabelName);
        return StringTools.trim((String)v);
    }

    public void setPrivateLabelName(String v) {
        this.setFieldValue(FLD_privateLabelName, StringTools.trim((String)v));
    }

    public String getPrivateLabelJsp() {
        String v = (String)this.getOptionalFieldValue(FLD_privateLabelJsp);
        return StringTools.trim((String)v);
    }

    public void setPrivateLabelJsp(String v) {
        this.setOptionalFieldValue(FLD_privateLabelJsp, StringTools.trim((String)v));
    }

    @Override
    public long getLastLoginTime() {
        Long v = (Long)this.getFieldValue(FLD_lastLoginTime);
        return v != null ? v : 0L;
    }

    @Override
    public void setLastLoginTime(long v) {
        this.setFieldValue(FLD_lastLoginTime, v);
    }

    public boolean getIsBorderCrossing() {
        Boolean v = (Boolean)this.getFieldValue(FLD_isBorderCrossing);
        return v != null ? v : false;
    }

    public void setIsBorderCrossing(boolean v) {
        this.setFieldValue(FLD_isBorderCrossing, v);
    }

    public boolean isBorderCrossing() {
        return this.getIsBorderCrossing();
    }

    public static boolean SupportsBorderCrossing() {
        if (borderCrossingExists < 0) {
            try {
                Class.forName("org.opengts.bcross.tables.BorderCrossing");
                borderCrossingExists = 1;
            }
            catch (Throwable th) {
                borderCrossingExists = 0;
            }
        }
        return borderCrossingExists == 1;
    }

    public boolean getAutoAddDevices() {
        Boolean v = (Boolean)this.getFieldValue(FLD_autoAddDevices);
        return v != null ? v : false;
    }

    public void setAutoAddDevices(boolean v) {
        this.setFieldValue(FLD_autoAddDevices, v);
    }

    public String getDcsPropertiesID() {
        String v = (String)this.getFieldValue(FLD_dcsPropertiesID);
        return StringTools.trim((String)v);
    }

    public void setDcsPropertiesID(String v) {
        this.setFieldValue(FLD_dcsPropertiesID, StringTools.trim((String)v));
    }

    public boolean getSmsEnabled() {
        switch (Account.GetDefaultSmsEnabledState()) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case ACCOUNT: {
                Boolean v = (Boolean)this.getFieldValue(FLD_smsEnabled);
                return v != null ? v : false;
            }
        }
        return false;
    }

    public void setSmsEnabled(boolean v) {
        this.setFieldValue(FLD_smsEnabled, v);
    }

    public String getSmsProperties() {
        String v = (String)this.getFieldValue(FLD_smsProperties);
        return StringTools.trim((String)v);
    }

    public void setSmsProperties(String v) {
        this.setFieldValue(FLD_smsProperties, StringTools.trim((String)v));
    }

    public RTProperties getSmsRTProperties() {
        String v = this.getSmsProperties();
        return new RTProperties(v);
    }

    public void setSmsRTProperties(RTProperties v) {
        if (v == null) {
            this.setSmsProperties("");
        } else {
            this.setSmsProperties(v.toString());
        }
    }

    public String getEmailProperties() {
        String v = (String)this.getFieldValue(FLD_emailProperties);
        return StringTools.trim((String)v);
    }

    public void setEmailProperties(String v) {
        this.setFieldValue(FLD_emailProperties, StringTools.trim((String)v));
    }

    public RTProperties getEmailRTProperties() {
        String v = this.getEmailProperties();
        return new RTProperties(v);
    }

    public void setEmailRTProperties(RTProperties v) {
        if (v == null) {
            this.setEmailProperties("");
        } else {
            this.setEmailProperties(v.toString());
        }
    }

    public String getMapLegendDevice() {
        if (this.hasField(FLD_mapLegendDevice)) {
            String v = (String)this.getFieldValue(FLD_mapLegendDevice);
            return StringTools.trim((String)v);
        }
        return "";
    }

    public void setMapLegendDevice(String v) {
        if (this.hasField(FLD_mapLegendDevice)) {
            this.setFieldValue(FLD_mapLegendDevice, v != null ? v : "");
        }
    }

    public String getMapLegendGroup() {
        if (this.hasField(FLD_mapLegendGroup)) {
            String v = (String)this.getFieldValue(FLD_mapLegendGroup);
            return StringTools.trim((String)v);
        }
        return "";
    }

    public void setMapLegendGroup(String v) {
        if (this.hasField(FLD_mapLegendGroup)) {
            this.setFieldValue(FLD_mapLegendGroup, v != null ? v : "");
        }
    }

    public void setMapLegend(boolean isFleet, String legend) {
        if (isFleet) {
            this.setMapLegendGroup(legend);
        } else {
            this.setMapLegendDevice(legend);
        }
    }

    public String getMapLegend(boolean isFleet) {
        if (isFleet) {
            return this.getMapLegendGroup();
        }
        return this.getMapLegendDevice();
    }

    public static boolean SupportsAccountManager() {
        DBFactory<Account> dbFact = Account.getFactory();
        if (!dbFact.hasField(FLD_isAccountManager)) {
            return false;
        }
        return dbFact.hasField(FLD_managerID);
    }

    public boolean getIsAccountManager() {
        if (this.hasField(FLD_isAccountManager)) {
            Boolean v = (Boolean)this.getFieldValue(FLD_isAccountManager);
            return v != null ? v : false;
        }
        return false;
    }

    public void setIsAccountManager(boolean v) {
        if (this.hasField(FLD_isAccountManager)) {
            this.setFieldValue(FLD_isAccountManager, v);
        }
    }

    public boolean isAccountManager() {
        return this.getIsAccountManager();
    }

    public String getManagerID() {
        if (this.hasField(FLD_managerID)) {
            String v = (String)this.getFieldValue(FLD_managerID);
            return StringTools.trim((String)v);
        }
        return "";
    }

    public void setManagerID(String v) {
        if (this.hasField(FLD_managerID)) {
            this.setFieldValue(FLD_managerID, StringTools.trim((String)v));
        }
    }

    public boolean hasManagerID() {
        return !StringTools.isBlank((String)this.getManagerID());
    }

    public String getRequestPassCode() {
        if (this.hasField(FLD_requestPassCode)) {
            String v = (String)this.getFieldValue(FLD_requestPassCode);
            return StringTools.trim((String)v);
        }
        return "";
    }

    public void setRequestPassCode(String v) {
        if (this.hasField(FLD_requestPassCode)) {
            this.setFieldValue(FLD_requestPassCode, StringTools.trim((String)v));
        }
    }

    public DTIPAddrList getRequestIPAddress() {
        if (this.hasField(FLD_requestIPAddress)) {
            DTIPAddrList v = (DTIPAddrList)((Object)this.getFieldValue(FLD_requestIPAddress));
            return v;
        }
        return null;
    }

    public void setRequestIPAddress(DTIPAddrList v) {
        if (this.hasField(FLD_requestIPAddress)) {
            this.setFieldValue(FLD_requestIPAddress, (Object)v);
        }
    }

    public void setRequestIPAddress(String v) {
        if (this.hasField(FLD_requestIPAddress)) {
            this.setRequestIPAddress(v != null ? new DTIPAddrList(v) : null);
        }
    }

    public boolean isValidRequestIPAddress(String ipAddr) {
        DTIPAddrList ipList = this.getRequestIPAddress();
        if (ipList == null || ipList.isEmpty()) {
            return true;
        }
        return ipList.isMatch(ipAddr);
    }

    public static boolean SupportsDataPushURL() {
        DBFactory<Account> dbFact = Account.getFactory();
        return dbFact.hasField(FLD_dataPushURL);
    }

    public String getDataPushURL() {
        if (this.hasField(FLD_dataPushURL)) {
            String v = (String)this.getFieldValue(FLD_dataPushURL);
            return StringTools.trim((String)v);
        }
        return "";
    }

    public void setDataPushURL(String v) {
        if (this.hasField(FLD_dataPushURL)) {
            this.setFieldValue(FLD_dataPushURL, StringTools.trim((String)v));
        }
    }

    public long getLastDataRequestTime() {
        if (this.hasField(FLD_lastDataRequestTime)) {
            Long v = (Long)this.getFieldValue(FLD_lastDataRequestTime);
            return v != null ? v : 0L;
        }
        return 0L;
    }

    public void setLastDataRequestTime(long v) {
        if (this.hasField(FLD_lastDataRequestTime)) {
            this.setFieldValue(FLD_lastDataRequestTime, v);
        }
    }

    public long getLastDataPushTime() {
        if (this.hasField(FLD_lastDataPushTime)) {
            Long v = (Long)this.getFieldValue(FLD_lastDataPushTime);
            return v != null ? v : 0L;
        }
        return 0L;
    }

    public void setLastDataPushTime(long v) {
        if (this.hasField(FLD_lastDataPushTime)) {
            this.setFieldValue(FLD_lastDataPushTime, v);
        }
    }

    public void setCreationDefaultValues() {
        this.setIsActive(true);
        if (this.isSystemAdmin()) {
            this.setDescription("Administrador de Plataforma");
            this.setPrivateLabelName("*");
            this.setGeocoderMode(GeocoderMode.FULL);
            this.setIsAccountManager(true);
        } else {
            this.setDescription("Nueva Cuenta [" + this.getAccountID() + "]");
            this.setPlatformMessage("Plataforma GPS");
            this.setGeocoderMode(GeocoderMode.FULL);
            this.setIsBorderCrossing(Account.SupportsBorderCrossing());
            String[] plk = this.getDefaultFieldValueKey(FLD_privateLabelName);
            this.setPrivateLabelName(RTConfig.hasProperty((String[])plk, (boolean)false) ? RTConfig.getString((String[])plk, (String)"") : "*");
            this.setIsAccountManager(false);
        }
        this.setAllowNotify(RTConfig.getBoolean((String)"Device.checkAccountAllowNotify", (boolean)false));
        switch (Account.GetDefaultSmsEnabledState()) {
            case FALSE: {
                this.setSmsEnabled(false);
                break;
            }
            case TRUE: {
                this.setSmsEnabled(true);
            }
        }
        this.setManagerID("");
        super.setRuntimeDefaultValues();
    }

    public boolean hasAdminUser() {
        try {
            return User.exists(this.getAccountID(), User.getAdminUserID());
        }
        catch (DBException dbe) {
            return false;
        }
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public static String getReportEmailAddress(Account account, User user) {
        return account != null ? account.getReportEmailAddress(user) : null;
    }

    public String getReportEmailAddress(User user) {
        String contactEmail;
        String notifyEmail;
        if (user != null && user.getAccountID().equals(this.getAccountID())) {
            notifyEmail = user.getNotifyEmail();
            if (!StringTools.isBlank((String)notifyEmail)) {
                return notifyEmail;
            }
            contactEmail = user.getContactEmail();
            if (!StringTools.isBlank((String)contactEmail)) {
                return contactEmail;
            }
        }
        try {
            User adminUser = User.getUser(this, User.getAdminUserID());
            if (adminUser != null) {
                String notifyEmail2 = adminUser.getNotifyEmail();
                if (!StringTools.isBlank((String)notifyEmail2)) {
                    return notifyEmail2;
                }
                String contactEmail2 = adminUser.getContactEmail();
                if (!StringTools.isBlank((String)contactEmail2)) {
                    return contactEmail2;
                }
            }
        }
        catch (DBException dbe) {
            Print.logError((String)("Error retrieving Admin user: " + (Object)((Object)dbe)), (Object[])new Object[0]);
        }
        notifyEmail = this.getNotifyEmail();
        if (!StringTools.isBlank((String)notifyEmail)) {
            return notifyEmail;
        }
        contactEmail = this.getContactEmail();
        if (!StringTools.isBlank((String)contactEmail)) {
            return contactEmail;
        }
        return null;
    }

    public Device getDevice(String devID) throws DBException {
        return Device.getDevice(this, devID);
    }

    public long getDeviceCount() {
        try {
            DBWhere dwh = new DBWhere(Device.getFactory());
            String where = dwh.WHERE_(dwh.EQ("accountID", (Object)this.getAccountID()));
            return DBRecord.getRecordCount(Device.getFactory(), (String)where);
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to retrieve DeviceList count", (Throwable)dbe);
            return -1L;
        }
    }

    public boolean hasDeviceLastNotifySince(long sinceTime, User user) throws DBException {
        if (sinceTime < 0L) {
            return true;
        }
        if (user != null && !user.getAccountID().equals(this.getAccountID())) {
            Print.logError((String)"User Account does not match Device Account", (Object[])new Object[0]);
            return false;
        }
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean found = false;
        try {
            DBSelect dsel = new DBSelect(Device.getFactory());
            dsel.setSelectedFields(new String[]{"accountID", "deviceID", "lastNotifyTime", "lastNotifyCode"});
            DBWhere dwh = dsel.createDBWhere();
            dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)this.getAccountID()), dwh.GT("lastNotifyTime", sinceTime), dwh.NE("isActive", 0))));
            dsel.setOrderByFields(new String[]{"accountID", "deviceID"});
            dsel.setLimit(1L);
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String accountID = rs.getString("accountID");
                String deviceID = rs.getString("deviceID");
                long notifyTime = rs.getLong("lastNotifyTime");
                int notifyCode = rs.getInt("lastNotifyCode");
                if (user != null && !user.isAuthorizedDevice(deviceID)) {
                    Print.logDebug((String)("User '" + accountID + "/" + user.getUserID() + "' not authorized to device: " + deviceID), (Object[])new Object[0]);
                    continue;
                }
                Print.logDebug((String)("Found Device with recent notification: " + accountID + "/" + deviceID + " ==> " + notifyTime + ":" + StatusCodes.GetHex(notifyCode)), (Object[])new Object[0]);
                found = true;
            }
        }
        catch (SQLException sqe) {
            try {
                throw new DBException("Getting Account Device 'lastNotifyTime'", (Throwable)sqe);
            }
            catch (Throwable throwable) {
                DBConnection.release(dbc, stmt, rs);
                throw throwable;
            }
        }
        DBConnection.release((DBConnection)dbc, (Statement)stmt, (ResultSet)rs);
        return found;
    }

    public static boolean hasAnyDeviceLastNotifySince(long sinceTime) throws DBException {
        if (sinceTime < 0L) {
            return true;
        }
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean found = false;
        try {
            DBSelect dsel = new DBSelect(Device.getFactory());
            dsel.setSelectedFields(new String[]{"accountID", "deviceID", "lastNotifyTime", "lastNotifyCode"});
            DBWhere dwh = dsel.createDBWhere();
            dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.GT("lastNotifyTime", sinceTime), dwh.NE("isActive", 0))));
            dsel.setOrderByFields(new String[]{"accountID", "deviceID"});
            dsel.setLimit(1L);
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            if (rs.next()) {
                found = true;
                String accountID = rs.getString("accountID");
                String deviceID = rs.getString("deviceID");
                long notifyTime = rs.getLong("lastNotifyTime");
                int notifyCode = rs.getInt("lastNotifyCode");
                Print.logInfo((String)("Found Device with recent notification: " + accountID + "/" + deviceID + " ==> " + notifyTime + ":" + StatusCodes.GetHex(notifyCode)), (Object[])new Object[0]);
            }
        }
        catch (SQLException sqe) {
            try {
                throw new DBException("Getting Account Device 'lastNotifyTime'", (Throwable)sqe);
            }
            catch (Throwable throwable) {
                DBConnection.release(dbc, stmt, rs);
                throw throwable;
            }
        }
        DBConnection.release((DBConnection)dbc, (Statement)stmt, (ResultSet)rs);
        return found;
    }

    public Object convertFieldUnits(DBField field, Object value, boolean inclUnits, Locale locale) {
        if (field == null || value == null) {
            return value;
        }
        String fldName = field.getName();
        String unitAtt = field.getStringAttribute("units", null);
        if (StringTools.isBlank((String)unitAtt)) {
            return value;
        }
        if (unitAtt.equalsIgnoreCase("speed")) {
            SpeedUnits units = Account.getSpeedUnits(this);
            double val = units.convertFromKPH(StringTools.parseDouble((Object)value, (double)0.0));
            if (inclUnits) {
                String valFmt = StringTools.format((double)val, (String)field.getFormat("0"));
                return valFmt + " " + units.toString(locale);
            }
            return new Double(val);
        }
        if (unitAtt.equalsIgnoreCase("distance")) {
            DistanceUnits units = Account.getDistanceUnits(this);
            double val = units.convertFromKM(StringTools.parseDouble((Object)value, (double)0.0));
            if (inclUnits) {
                String valFmt = StringTools.format((double)val, (String)field.getFormat("0"));
                return valFmt + " " + units.toString(locale);
            }
            return new Double(val);
        }
        if (unitAtt.equalsIgnoreCase("volume")) {
            VolumeUnits units = Account.getVolumeUnits(this);
            double val = units.convertFromLiters(StringTools.parseDouble((Object)value, (double)0.0));
            if (inclUnits) {
                String valFmt = StringTools.format((double)val, (String)field.getFormat("0"));
                return valFmt + " " + units.toString(locale);
            }
            return new Double(val);
        }
        if (unitAtt.equalsIgnoreCase("temp")) {
            TemperatureUnits units = Account.getTemperatureUnits(this);
            double val = units.convertFromC(StringTools.parseDouble((Object)value, (double)0.0));
            if (inclUnits) {
                String valFmt = StringTools.format((double)val, (String)field.getFormat("0"));
                return valFmt + " " + units.toString(locale);
            }
            return new Double(val);
        }
        if (unitAtt.equalsIgnoreCase("econ")) {
            EconomyUnits units = Account.getEconomyUnits(this);
            double val = units.convertFromKPL(StringTools.parseDouble((Object)value, (double)0.0));
            if (inclUnits) {
                String valFmt = StringTools.format((double)val, (String)field.getFormat("0"));
                return valFmt + " " + units.toString(locale);
            }
            return new Double(val);
        }
        if (unitAtt.equalsIgnoreCase("percent")) {
            double val;
            double dval = StringTools.parseDouble((Object)value, (double)0.0);
            double d = dval < 0.0 ? 0.0 : (val = dval > 1.5 ? dval : dval * 100.0);
            if (inclUnits) {
                String valFmt = StringTools.format((double)val, (String)field.getFormat("0"));
                return valFmt + "%";
            }
            return new Double(val);
        }
        return value;
    }

    public String toString() {
        return this.getAccountID();
    }

    public static BasicPrivateLabel getPrivateLabel(Account acct) {
        return acct != null ? acct.getPrivateLabel() : null;
    }

    public BasicPrivateLabel getPrivateLabel() {
        if (this.privateLabel == null) {
            String bplName = this.getPrivateLabelName();
            this.privateLabel = BasicPrivateLabelLoader.getPrivateLabel(bplName);
            if (this.privateLabel == null) {
                Print.logWarn((String)("PrivateLabel not defined! [" + bplName + "]"), (Object[])new Object[0]);
                this.privateLabel = new BasicPrivateLabel("null");
                this.foundPrivateLabel = false;
            } else {
                this.foundPrivateLabel = true;
            }
        }
        return this.privateLabel;
    }

    public boolean hasPrivateLabel() {
        this.getPrivateLabel();
        return this.foundPrivateLabel;
    }

    public Locale getLocale() {
        BasicPrivateLabel bpl = this.getPrivateLabel();
        if (bpl != null) {
            return bpl.getLocale();
        }
        return null;
    }

    public String getDateFormat() {
        BasicPrivateLabel privLabel = this.getPrivateLabel();
        if (privLabel != null) {
            return privLabel.getDateFormat();
        }
        return BasicPrivateLabel.getDefaultDateFormat();
    }

    public String getTimeFormat() {
        BasicPrivateLabel privLabel = this.getPrivateLabel();
        if (privLabel != null) {
            return privLabel.getTimeFormat();
        }
        return BasicPrivateLabel.getDefaultTimeFormat();
    }

    public String getDateTimeFormat() {
        return this.getDateFormat() + " " + this.getTimeFormat();
    }

    public String formatDate(DateTime dt) {
        if (dt != null) {
            TimeZone tz = this.getTimeZone(null);
            return dt.format(this.getDateFormat(), tz);
        }
        return "";
    }

    public String formatTime(DateTime dt) {
        if (dt != null) {
            TimeZone tz = this.getTimeZone(null);
            return dt.format(this.getTimeFormat(), tz);
        }
        return "";
    }

    public String formatDateTime(DateTime dt) {
        if (dt != null) {
            TimeZone tz = this.getTimeZone(null);
            return dt.format(this.getDateTimeFormat(), tz);
        }
        return "";
    }

    public String formatDateTime(long dt) {
        TimeZone tz = this.getTimeZone(null);
        return new DateTime(dt, tz).format(this.getDateTimeFormat(), tz);
    }

    public String[] getDeviceTitles(Locale loc) {
        return this.getDeviceTitles(loc, Device.GetTitles(loc));
    }

    public String[] getDeviceTitles(Locale loc, String[] dft) {
        return AccountString.getStringsArray(this, "device", dft);
    }

    public void setDeviceTitle(String singular, String plural) {
        try {
            String strID = "device";
            String desc = "Device Title";
            if (StringTools.isBlank((String)plural)) {
                plural = singular;
            }
            AccountString.updateAccountString(this, strID, desc, singular, plural);
        }
        catch (DBException dbe) {
            Print.logError((String)("Unable to save Device: " + (Object)((Object)dbe)), (Object[])new Object[0]);
        }
    }

    public String getNewDeviceDescription() {
        return this.getNewDeviceDescription(null, "");
    }

    public String getNewDeviceDescription(Locale loc, String dftDesc) {
        try {
            AccountString str = AccountString.getAccountString(this, "deviceDesc");
            return str != null && str.hasSingularTitle() ? str.getSingularTitle() : dftDesc;
        }
        catch (DBException dbe) {
            return dftDesc;
        }
    }

    public void setNewDeviceDescription(String singular) {
        this.setNewDeviceDescription(singular, null);
    }

    public void setNewDeviceDescription(String singular, String plural) {
        try {
            String strID = "deviceDesc";
            String desc = "New Device Description";
            AccountString.updateAccountString(this, strID, desc, singular, plural);
        }
        catch (DBException dbe) {
            Print.logError((String)("Unable to save Device: " + (Object)((Object)dbe)), (Object[])new Object[0]);
        }
    }

    public String[] getDeviceGroupTitles(Locale loc) {
        return this.getDeviceGroupTitles(loc, DeviceGroup.GetTitles(loc));
    }

    public String[] getDeviceGroupTitles(Locale loc, String[] dft) {
        return AccountString.getStringsArray(this, "deviceGroup", dft);
    }

    public void setDeviceGroupTitle(String singular, String plural) {
        try {
            String strID = "deviceGroup";
            String desc = "Device Group Title";
            if (StringTools.isBlank((String)plural)) {
                plural = singular;
            }
            AccountString.updateAccountString(this, strID, desc, singular, plural);
        }
        catch (DBException dbe) {
            Print.logError((String)("Unable to save DeviceGroup title: " + (Object)((Object)dbe)), (Object[])new Object[0]);
        }
    }

    public String[] getEntityTitles(Locale loc) {
        String[] stringArray;
        String[] T = this.getEntityTitles(loc, null);
        if (T != null) {
            stringArray = T;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "";
            stringArray = stringArray2;
            stringArray2[1] = "";
        }
        return stringArray;
    }

    public String[] getEntityTitles(Locale loc, String[] dft) {
        return AccountString.getStringsArray(this, "entity", dft);
    }

    public void setEntityTitle(String singular, String plural) {
        try {
            String strID = "entity";
            String desc = "Entity Title";
            AccountString.updateAccountString(this, strID, desc, singular, plural);
        }
        catch (DBException dbe) {
            Print.logError((String)("Unable to save Entity title: " + (Object)((Object)dbe)), (Object[])new Object[0]);
        }
    }

    public String[] getAddressTitles(Locale loc) {
        String[] stringArray;
        String[] T = this.getAddressTitles(loc, null);
        if (T != null) {
            stringArray = T;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "";
            stringArray = stringArray2;
            stringArray2[1] = "";
        }
        return stringArray;
    }

    public String[] getAddressTitles(Locale loc, String[] dft) {
        return AccountString.getStringsArray(this, "address", dft);
    }

    public void setAddressTitle(String singular, String plural) {
        try {
            String strID = "address";
            String desc = "Address Title";
            AccountString.updateAccountString(this, strID, desc, singular, plural);
        }
        catch (DBException dbe) {
            Print.logError((String)("Unable to save Address title: " + (Object)((Object)dbe)), (Object[])new Object[0]);
        }
    }

    public static Collection<String> getAllAccounts() throws DBException {
        return Account.getAllAccounts(null);
    }

    public static Collection<String> getDataPushAccountIDs() throws DBException {
        DBFactory<Account> acctFact = Account.getFactory();
        DBSelect dsel = new DBSelect(acctFact);
        DBWhere dwh = new DBWhere(acctFact);
        dwh.append(dwh.NE(FLD_dataPushURL, (Object)""));
        dsel.setWhere(dwh);
        dsel.setSelectedFields(new String[]{"accountID"});
        dsel.setOrderByFields(new String[]{"accountID"});
        return Account.getAllAccounts((DBSelect<Account>)dsel);
    }

    public static Collection<String> getAllAccounts(DBSelect<Account> dsel) throws DBException {
        if (dsel == null) {
            dsel = new DBSelect(Account.getFactory());
            dsel.setSelectedFields(new String[]{"accountID"});
            dsel.setOrderByFields(new String[]{"accountID"});
        }
        Vector<String> acctList = new Vector<String>();
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                String acctId = rs.getString("accountID");
                acctList.add(acctId);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Getting Account List", (Throwable)sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release((DBConnection)dbc);
        }
        return acctList;
    }

    public static Collection<String> getAuthorizedAccounts(Account account) throws DBException {
        String managerID;
        if (account == null) {
            return new Vector<String>();
        }
        if (account.isSystemAdmin()) {
            return Account.getAllAccounts();
        }
        if (!account.getIsActive()) {
            return new Vector<String>();
        }
        if (account.isAccountManager() && !StringTools.isBlank((String)(managerID = account.getManagerID()))) {
            DBSelect dsel = new DBSelect(Account.getFactory());
            dsel.setSelectedFields(new String[]{"accountID", FLD_managerID});
            dsel.setOrderByFields(new String[]{"accountID"});
            DBWhere dwh = dsel.createDBWhere();
            dsel.setWhere(dwh.WHERE(dwh.EQ(FLD_managerID, (Object)managerID)));
            return Account.getAllAccounts((DBSelect<Account>)dsel);
        }
        Vector<String> acctList = new Vector<String>();
        acctList.add(account.getAccountID());
        return acctList;
    }

    public static boolean exists(String acctID) throws DBException {
        if (acctID != null) {
            Key actKey = new Key(acctID);
            return actKey.exists();
        }
        return false;
    }

    public static Account getAccount(String acctID) throws DBException {
        if (StringTools.isBlank((String)acctID)) {
            return null;
        }
        Key key = new Key(acctID);
        if (key.exists()) {
            return (Account)key.getDBRecord(true);
        }
        return null;
    }

    public static Account getAccount(String acctID, boolean create) throws DBException {
        if (StringTools.isBlank((String)acctID)) {
            throw new DBNotFoundException("Account-ID not specified.");
        }
        Account acct = null;
        Key acctKey = new Key(acctID);
        if (!acctKey.exists()) {
            if (create) {
                acct = (Account)acctKey.getDBRecord();
                acct.setCreationDefaultValues();
                return acct;
            }
            throw new DBNotFoundException("Account-ID does not exists '" + (Object)((Object)acctKey) + "'");
        }
        if (create) {
            throw new DBAlreadyExistsException("Account-ID already exists '" + (Object)((Object)acctKey) + "'");
        }
        acct = Account.getAccount(acctID);
        if (acct == null) {
            throw new DBException("Unable to read existing Account-ID '" + (Object)((Object)acctKey) + "'");
        }
        return acct;
    }

    public static Account createNewAccount(Account acctMgr, String acctID, String passwd) throws DBException {
        if (StringTools.isBlank((String)acctID)) {
            throw new DBException("Invalid AccountID specified");
        }
        Account acct = Account.getAccount(acctID, true);
        User.createNewUser(acct, "admin", "", passwd);
        Device.createNewDevice(acct, "default", "default");
        if (passwd != null) {
            acct.setDecodedPassword(null, passwd);
        }
        if (acctMgr != null) {
            if (!Account.isSystemAdmin(acctMgr) && !Account.isAccountManager(acctMgr)) {
                throw new DBNotAuthorizedException("Not Authorized to create accounts");
            }
            acct.setPrivateLabelName(acctMgr.getPrivateLabelName());
            acct.setManagerID(acctMgr.getManagerID());
            acct.setGeocoderMode(acctMgr.getGeocoderMode());
            acct.setIsBorderCrossing(acctMgr.getIsBorderCrossing());
            acct.setDcsPropertiesID(acctMgr.getDcsPropertiesID());
            acct.setSmsEnabled(acctMgr.getSmsEnabled());
            acct.setSmsProperties(acctMgr.getSmsProperties());
        }
        acct.save();
        return acct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Account createTemporaryAccount(String accountID, int expireDays, String encPass, String contactName, String contactEmail, String privateLabelName) throws DBException {
        long expireTime;
        long nowTime;
        Account account;
        block7: {
            long expireSec;
            account = null;
            nowTime = DateTime.getCurrentTimeSec();
            long l = expireSec = (long)expireDays > 0L ? DateTime.DaySeconds((long)expireDays) : DFT_EXPIRATION_SEC;
            if (expireSec > MAX_EXPIRATION_SEC) {
                expireSec = MAX_EXPIRATION_SEC;
            }
            expireTime = new DateTime(nowTime + expireSec, DateTime.getGMTTimeZone()).getDayEnd();
            Object object = TempAccountLock;
            synchronized (object) {
                block6: {
                    if (StringTools.isBlank((String)accountID)) break block6;
                    Key acctKey = new Key(accountID);
                    if (acctKey.exists()) break block7;
                    account = (Account)acctKey.getDBRecord();
                    break block7;
                }
                long tval = nowTime % DateTime.DaySeconds((long)34L) / 3L;
                for (int i = 0; i < 3; ++i) {
                    String acctID = "T" + StringTools.format((long)(tval + (long)i), (String)"000000");
                    Key acctKey = new Key(acctID);
                    if (acctKey.exists()) continue;
                    account = (Account)acctKey.getDBRecord();
                    break;
                }
            }
        }
        if (account != null) {
            account.setCreationDefaultValues();
            account.setDescription(contactName);
            account.setContactEmail(contactEmail);
            account.setContactName(contactName);
            account.setPlatformMessage("Plataforma GPS");
            account.setMaximumDevices(1L);
            account.setPasswdQueryTime(nowTime);
            account.setEncodedPassword(encPass);
            account.setExpirationTime(expireTime);
            account.setPrivateLabelName(privateLabelName);
            account.save();
        }
        return account;
    }

    public static String createRandomPassword(int length) {
        return StringTools.createRandomString((int)length, (String)PASSWORD_ALPHABET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getAccountIDsForContactEmail(String emailAddr) throws DBException {
        Statement stmt;
        DBConnection dbc;
        Vector<String> acctList;
        block17: {
            if (StringTools.isBlank((String)emailAddr)) {
                throw new DBException("Contact EMail address not specified");
            }
            acctList = new Vector<String>();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(Account.getFactory());
                dsel.setSelectedFields(new String[]{"accountID"});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE(dwh.EQ(FLD_contactEmail, (Object)emailAddr)));
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String acctId = rs.getString("accountID");
                    acctList.add(acctId);
                }
                if (rs == null) break block17;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Get Account ContactEmail", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return acctList;
    }

    public static String[] getUnconfirmedAccounts() throws DBException {
        return Account.getUnconfirmedAccounts(MAX_UNCONFIRMED_SEC);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getUnconfirmedAccounts(long ageSec) throws DBException {
        Statement stmt;
        DBConnection dbc;
        Vector<String> acctList;
        block16: {
            acctList = new Vector<String>();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                long unconfirmedTime = DateTime.getCurrentTimeSec() - ageSec;
                DBSelect dsel = new DBSelect(Account.getFactory());
                dsel.setSelectedFields(new String[]{"accountID"});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.GT(FLD_expirationTime, 0L), dwh.EQ(FLD_lastLoginTime, 0L), dwh.LT("creationTime", unconfirmedTime))));
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String acctId = rs.getString("accountID");
                    acctList.add(acctId);
                }
                if (rs == null) break block16;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Get Unconfirmed Account List", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return acctList.toArray(new String[acctList.size()]);
    }

    public static String[] getExpiredAccounts() throws DBException {
        return Account.getExpiredAccounts(0L, true);
    }

    public static String[] getExpiredAccounts(long deltaSec) throws DBException {
        return Account.getExpiredAccounts(deltaSec, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getExpiredAccounts(long deltaSec, boolean activeState) throws DBException {
        Statement stmt;
        DBConnection dbc;
        Vector<String> acctList;
        block16: {
            acctList = new Vector<String>();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                long expTime = DateTime.getCurrentTimeSec() - deltaSec;
                DBSelect dsel = new DBSelect(Account.getFactory());
                dsel.setSelectedFields(new String[]{"accountID"});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.GT(FLD_expirationTime, 0L), dwh.LT(FLD_expirationTime, expTime), dwh.EQ("isActive", activeState))));
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String acctId = rs.getString("accountID");
                    acctList.add(acctId);
                }
                if (rs == null) break block16;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Get Expired Account List", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return acctList.toArray(new String[acctList.size()]);
    }

    public static void deactivateAccounts(String[] acctID) throws DBException {
        if (acctID != null) {
            for (int i = 0; i < acctID.length; ++i) {
                Account account = Account.getAccount(acctID[i]);
                if (account != null) {
                    Print.logInfo((String)("Deactivating account: " + acctID[i]), (Object[])new Object[0]);
                    if (!account.getIsActive()) continue;
                    account.setIsActive(false);
                    account.save();
                    continue;
                }
                Print.logWarn((String)("[Deactivate] Account not found: " + acctID[i]), (Object[])new Object[0]);
            }
        }
    }

    public static void deleteAccounts(String[] acctID) throws DBException {
        if (acctID != null) {
            for (int i = 0; i < acctID.length; ++i) {
                Key acctKey = new Key(acctID[i]);
                Print.logWarn((String)("Deleting Account: " + acctID[i]), (Object[])new Object[0]);
                acctKey.delete(true);
            }
        }
    }

    public long countOldEvents(long oldTimeSec, boolean log) throws DBException {
        String acctID = this.getAccountID();
        String groupID = "all";
        if (log) {
            Print.sysPrintln((String)("Counting old events for account " + acctID + " prior to " + new DateTime(oldTimeSec)), (Object[])new Object[0]);
        }
        return DeviceGroup.countOldEvents(this, groupID, oldTimeSec, log);
    }

    public long deleteOldEvents(long oldTimeSec, boolean log) throws DBException {
        String acctID = this.getAccountID();
        String groupID = "all";
        if (log) {
            Print.sysPrintln((String)("Deleting old events for account " + acctID + " prior to " + new DateTime(oldTimeSec)), (Object[])new Object[0]);
        }
        return DeviceGroup.deleteOldEvents(this, groupID, oldTimeSec, log);
    }

    public static double getEventsPerSecond() {
        try {
            return Account._getEventsPerSecond();
        }
        catch (DBException dbe) {
            return -1.0;
        }
    }

    public static double _getEventsPerSecond() throws DBException {
        double accumEPS = 0.0;
        Collection<String> acctList = Account.getAllAccounts();
        long nowTimeMS = System.currentTimeMillis();
        for (String acctID : acctList) {
            Account account = Account.getAccount(acctID);
            if (account == null) continue;
            OrderedSet<String> devIDList = Device.getDeviceIDsForAccount(acctID, null, false);
            for (String devID : devIDList) {
                Device device = account.getDevice(devID);
                if (device == null) continue;
                accumEPS += device.getAgedEventsPerSecond(nowTimeMS);
            }
        }
        return accumEPS;
    }

    public static String getKeyFieldTitle(String key, String arg, Locale locale) {
        return Account._getKeyFieldString(true, key, arg, locale, null, null);
    }

    public String getKeyFieldValue(String key, String arg, BasicPrivateLabel bpl) {
        Locale locale = bpl != null ? bpl.getLocale() : null;
        return Account._getKeyFieldString(false, key, arg, locale, bpl, this);
    }

    public static String _getKeyFieldString(boolean getTitle, String key, String arg, Locale locale, BasicPrivateLabel bpl, Account acct) {
        if (key == null) {
            return null;
        }
        if (acct == null && !getTitle) {
            return null;
        }
        if (locale == null && bpl != null) {
            locale = bpl.getLocale();
        }
        I18N i18n = I18N.getI18N(Account.class, (Locale)locale);
        long now = DateTime.getCurrentTimeSec();
        if (EventData._keyMatch(key, KEY_ACCOUNT)) {
            if (getTitle) {
                return i18n.getString("Account.key.accountDescription", _TABLE_NAME);
            }
            return acct.getDescription();
        }
        if (EventData._keyMatch(key, KEY_DEVICE_COUNT)) {
            if (getTitle) {
                return i18n.getString("Account.key.deviceCount", "Device Count");
            }
            return String.valueOf(acct.getDeviceCount());
        }
        if (EventData._keyMatch(key, KEY_DATETIME)) {
            if (getTitle) {
                return i18n.getString("Account.key.dateTime", "Date/Time");
            }
            TimeZone tmz = acct.getTimeZone(null);
            return EventData.getTimestampString(now, acct, tmz, bpl);
        }
        if (EventData._keyMatch(key, KEY_DATE_YEAR)) {
            if (getTitle) {
                return i18n.getString("Account.key.dateYear", "Year");
            }
            TimeZone tmz = acct.getTimeZone(null);
            return EventData.getTimestampYear(now, tmz);
        }
        if (EventData._keyMatch(key, KEY_DATE_MONTH)) {
            if (getTitle) {
                return i18n.getString("Account.key.dateMonth", "Month");
            }
            TimeZone tmz = acct.getTimeZone(null);
            return EventData.getTimestampMonth(now, false, tmz, locale);
        }
        if (EventData._keyMatch(key, KEY_DATE_DAY)) {
            if (getTitle) {
                return i18n.getString("Account.key.dateDay", "Day");
            }
            TimeZone tmz = acct.getTimeZone(null);
            return EventData.getTimestampDayOfMonth(now, tmz);
        }
        if (EventData._keyMatch(key, KEY_DATE_DOW)) {
            if (getTitle) {
                return i18n.getString("Account.key.dayOfWeek", "Day Of Week");
            }
            TimeZone tmz = acct.getTimeZone(null);
            return EventData.getTimestampDayOfWeek(now, false, tmz, locale);
        }
        if (EventData._keyMatch(key, KEY_TIME)) {
            if (getTitle) {
                return i18n.getString("Account.key.time", "Time");
            }
            TimeZone tmz = acct.getTimeZone(null);
            return EventData.getTimestampString(now, acct, tmz, bpl);
        }
        if (EventData._keyMatch(key, KEY_EXPIREDATE)) {
            if (getTitle) {
                return i18n.getString("Account.key.expireDate", "Expiration Date");
            }
            long expTime = acct.getExpirationTime();
            if (expTime > 0L) {
                if (expTime <= now) {
                    return i18n.getString("Account.key.expireDate.expired", "Expired");
                }
                TimeZone tmz = acct.getTimeZone(null);
                return EventData.getTimestampString(expTime, acct, tmz, bpl);
            }
            return i18n.getString("Account.key.expireDate.noExpire", "n/a");
        }
        if (EventData._keyMatch(key, KEY_EXPIREDAYS)) {
            if (getTitle) {
                return i18n.getString("Account.key.expireDays", "Expiration Days");
            }
            long expTime = acct.getExpirationTime();
            if (expTime > 0L) {
                if (expTime <= now) {
                    return i18n.getString("Account.key.expireDays.expired", "Expired");
                }
                long expSec = expTime - now;
                String D = String.valueOf(expSec / DateTime.DaySeconds((long)1L));
                String H = String.valueOf(expSec % DateTime.DaySeconds((long)1L) / DateTime.HourSeconds((long)1L));
                return i18n.getString("Account.key.expireDays.daysHours", "{0} Days {1} Hours", (Object[])new String[]{D, H});
            }
            return i18n.getString("Account.key.expireDays.noExpire", "n/a");
        }
        if (EventData._keyMatch(key, KEY_DISKUSAGE)) {
            if (getTitle) {
                return i18n.getString("Account.key.gtsHomeDiskUsage", "Disk Usage");
            }
            if (!acct.isSystemAdmin()) {
                return i18n.getString("Account.key.gtsHomeDiskUsage.notAuthorized", "n/a");
            }
            File gtsHome = RTConfig.getLoadedConfigDir();
            if (gtsHome != null && gtsHome.isDirectory()) {
                double usedMb = (double)gtsHome.getUsableSpace() / 1048576.0;
                double totalMb = (double)gtsHome.getTotalSpace() / 1048576.0;
                double freeMb = totalMb - usedMb;
                double freePct = totalMb > 0.0 ? freeMb / totalMb : 0.0;
                StringBuffer sb = new StringBuffer();
                sb.append(i18n.getString("Account.key.gtsHomeDiskUsage.directory", "Dir"));
                sb.append("=");
                sb.append(gtsHome.toString());
                sb.append("  ");
                sb.append(i18n.getString("Account.key.gtsHomeDiskUsage.total", "Total"));
                sb.append("=");
                sb.append(StringTools.format((double)totalMb, (String)"0"));
                sb.append("mb  ");
                sb.append(i18n.getString("Account.key.gtsHomeDiskUsage.free", "Free"));
                sb.append("=");
                sb.append(StringTools.format((double)freeMb, (String)"0"));
                sb.append("mb  [");
                sb.append(StringTools.format((double)(freePct * 100.0), (String)"0"));
                sb.append("% ");
                sb.append(i18n.getString("Account.key.gtsHomeDiskUsage.free", "Free").toLowerCase());
                sb.append("]");
                return sb.toString();
            }
            return i18n.getString("Account.key.gtsHomeDiskUsage.notAuthorized", "n/a");
        }
        if (getTitle) {
            DBField dbFld = Account.getFactory().getField(key);
            if (dbFld != null) {
                return dbFld.getTitle(locale);
            }
        } else {
            DBField dbFld;
            String fldName = acct.getFieldName(key);
            DBField dBField = dbFld = fldName != null ? acct.getField(fldName) : null;
            if (dbFld != null) {
                Account account;
                Object val = acct.getFieldValue(fldName);
                if (val == null) {
                    val = dbFld.getDefaultValue();
                }
                if ((account = acct) != null) {
                    val = account.convertFieldUnits(dbFld, val, true, locale);
                    return StringTools.trim((Object)val);
                }
                return dbFld.formatValue(val);
            }
        }
        return null;
    }

    private static void usage() {
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + Account.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<AccountID>         Specific AccountID to list/report/delete/create/edit", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -delete                      Delete specified Account and owned Devices (USE WITH CAUTION!)", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -create                      To create a new Account", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -pass=<pass>                 Set password on Account creation", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -nopass                      Set blank password on Account creation", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -edit                        To edit an existing (or newly created) Account", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -list[=<AccountID>]          List all Accounts and owned Devices", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -report[=<AccountID>]        Report on Accounts total/active Devices", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -manager=<ManagerID>         Confine '-list' and '-report' to specified ManagerID", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -findEMail=<EmailAddr>       Find all references to specified email address", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -countOldEvents=<EpochTime>  Count events (for all Devices) before specified Epoch time", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -deleteOldEvents=<EpochTime> Delete events (for all Devices) before specified Epoch time (requires '-confirm')", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -confirm                     Confirms countOldEvents/deleteOldEvents", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -prune                       Deactivate/Delete expired accounts", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        boolean hasAccountID;
        DBConfig.cmdLineInit(argv, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        if (acctID == null) {
            acctID = "";
        }
        boolean bl = hasAccountID = !StringTools.isBlank((String)acctID);
        if (RTConfig.hasProperty((String[])ARG_DEVICE)) {
            Print.logError((String)"Cannot specify '-device' on Account admin command", (Object[])new Object[0]);
            System.exit(99);
        }
        boolean accountExists = false;
        if (hasAccountID) {
            try {
                accountExists = Account.exists(acctID);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error determining if Account exists: " + acctID), (Object[])new Object[0]);
                System.exit(99);
            }
        } else {
            accountExists = false;
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false) && hasAccountID) {
            ++opts;
            if (!accountExists) {
                Print.logWarn((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Account.deleteAccounts(new String[]{acctID});
                Print.logInfo((String)("Account-ID deleted: " + acctID), (Object[])new Object[0]);
                accountExists = false;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting Account-ID: " + acctID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false) && hasAccountID) {
            ++opts;
            if (accountExists) {
                Print.logWarn((String)("Account-ID already exists: " + acctID), (Object[])new Object[0]);
            } else {
                try {
                    String passwd = null;
                    if (RTConfig.getBoolean((String[])ARG_NOPASS, (boolean)false)) {
                        passwd = BLANK_PASSWORD;
                    } else if (RTConfig.hasProperty((String[])ARG_PASSWORD)) {
                        passwd = RTConfig.getString((String[])ARG_PASSWORD, (String)"");
                    }
                    Account acct = Account.createNewAccount(null, acctID, passwd);
                    if (RTConfig.hasProperty((String[])ARG_DESC)) {
                        try {
                            acct.setDescription(RTConfig.getString((String[])ARG_DESC, (String)""));
                            acct.save();
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    Print.logInfo((String)("Created Account-ID: " + acctID), (Object[])new Object[0]);
                    accountExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating Account-ID: " + acctID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_XML, (boolean)false) && hasAccountID) {
            ++opts;
            if (!accountExists) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
            } else {
                try {
                    Account account = Account.getAccount(acctID, false);
                    DBRecord.printXML((PrintWriter)new PrintWriter(System.out), (DBRecord[])new DBRecord[]{account});
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error displaying Account-ID: " + acctID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if ((RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false) || RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false)) && hasAccountID) {
            ++opts;
            if (!accountExists) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
            } else {
                boolean adminExists = false;
                try {
                    adminExists = User.exists(acctID, User.getAdminUserID());
                    if (adminExists) {
                        Print.sysPrintln((String)("(Note: This account has an '" + User.getAdminUserID() + "' user)"), (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error determining if User exists: " + acctID + "," + User.getAdminUserID()), (Object[])new Object[0]);
                }
                try {
                    boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                    Account account = Account.getAccount(acctID, false);
                    DBEdit editor = new DBEdit((DBRecord)account);
                    editor.edit(allFlds);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing Account-ID: " + acctID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_SET_PASSWD)) {
            String passwd;
            ++opts;
            if (!accountExists) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                System.exit(99);
            }
            if (StringTools.isBlank((String)(passwd = RTConfig.getString((String[])ARG_SET_PASSWD, null)))) {
                Print.logError((String)"Password not specified", (Object[])new Object[0]);
                System.exit(99);
            }
            try {
                Account account = Account.getAccount(acctID, false);
                account.setPassword(passwd);
                account.update(new String[]{FLD_password});
                Print.logInfo((String)("Set Account password: " + acctID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error setting Account-ID password: " + acctID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_REPORT)) {
            String plName = RTConfig.getString((String[])ARG_PRIVLABEL, null);
            String manager = RTConfig.getString((String[])ARG_MANAGER, null);
            String rptFmt = "{C:4}{0:-3} {C:+6}{1:-5} {C:+8}{3:18} {C:+20}{4}";
            ++opts;
            try {
                int acctCount = 0;
                int tdevCountTotal = 0;
                int tdevCountActiv = 0;
                int tdevCountHasEv = 0;
                Collection<String> acctList = Account.getAllAccounts();
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                for (String acctListID : acctList) {
                    Account account;
                    if (hasAccountID && !acctID.equals(acctListID) || (account = Account.getAccount(acctListID)) == null) continue;
                    String privLabelName = account.getPrivateLabelName();
                    if (!StringTools.isBlank((String)plName) && !plName.equalsIgnoreCase(privLabelName)) continue;
                    String managerID = account.getManagerID();
                    if (!StringTools.isBlank((String)manager)) {
                        if (!managerID.equals(manager)) continue;
                        Print.sysPrintln((String)("AccountManager: " + manager), (Object[])new Object[0]);
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                    }
                    ++acctCount;
                    boolean acctActive = account.getIsActive();
                    String acctDesc = account.getDescription();
                    Print.sysPrintln((String)("  Account: " + acctListID + " - " + acctDesc + " [active=" + acctActive + "]"), (Object[])new Object[0]);
                    Print.sysPrintln((String)StringTools.formatLine((String)rptFmt, (Object[])new Object[]{" ## ", "Active", "Events", "DeviceID", "Description"}), (Object[])new Object[0]);
                    Print.sysPrintln((String)StringTools.formatLine((String)rptFmt, (Object[])new Object[]{"----", "------", "------", "------------------", "-----------------------------"}), (Object[])new Object[0]);
                    OrderedSet devList = new OrderedSet();
                    OrderedSet<String> devIDList = Device.getDeviceIDsForAccount(acctListID, null, true);
                    int devCntTotal = 0;
                    int devCntActiv = 0;
                    int devCntHasEv = 0;
                    for (String devID : devIDList) {
                        Device device = account.getDevice(devID);
                        if (device == null) continue;
                        boolean devActive = acctActive && device.getIsActive();
                        boolean hasEvents = device.getLastEventTimestamp() > 0L;
                        String devDesc = device.getDescription();
                        EventData lastEvent = device.getLastEvent(false);
                        if (!hasEvents && lastEvent != null) {
                            hasEvents = true;
                        }
                        devList.add((Object)device);
                        ++devCntTotal;
                        ++tdevCountTotal;
                        if (devActive) {
                            ++devCntActiv;
                            ++tdevCountActiv;
                        }
                        if (hasEvents || lastEvent != null) {
                            ++devCntHasEv;
                            ++tdevCountHasEv;
                        }
                        Print.sysPrintln((String)StringTools.formatLine((String)rptFmt, (Object[])new Object[]{String.valueOf(devCntTotal), devActive ? "yes" : "--", hasEvents ? "yes" : "", devID, devDesc}), (Object[])new Object[0]);
                    }
                    Print.sysPrintln((String)StringTools.formatLine((String)rptFmt, (Object[])new Object[]{"----", "------", "", "", ""}), (Object[])new Object[0]);
                    Print.sysPrintln((String)StringTools.formatLine((String)rptFmt, (Object[])new Object[]{String.valueOf(devCntTotal), String.valueOf(devCntActiv), "", "Active Count", ""}), (Object[])new Object[0]);
                    Print.sysPrintln((String)"", (Object[])new Object[0]);
                }
                Print.sysPrintln((String)"---------------------------------", (Object[])new Object[0]);
                Print.sysPrintln((String)("Total  Device Count: " + tdevCountTotal), (Object[])new Object[0]);
                Print.sysPrintln((String)("Active Device Count: " + tdevCountActiv), (Object[])new Object[0]);
                Print.sysPrintln((String)"", (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error listing Accounts", (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            String type = RTConfig.getString((String[])ARG_LISTTYPE, (String)"all");
            String plName = RTConfig.getString((String[])ARG_PRIVLABEL, null);
            String manager = RTConfig.getString((String[])ARG_MANAGER, null);
            boolean eventCnt = RTConfig.getBoolean((String[])ARG_EVENTCOUNT, (boolean)false);
            long nowMS = System.currentTimeMillis();
            ++opts;
            try {
                int acctCount = 0;
                int tdevCountTotal = 0;
                int tdevCountActiv = 0;
                double tdevEventsPerSec = 0.0;
                Collection<String> acctList = Account.getAllAccounts();
                for (String acctListID : acctList) {
                    Account account;
                    if (hasAccountID && !acctID.equals(acctListID) || (account = Account.getAccount(acctListID)) == null) continue;
                    String privLabelName = account.getPrivateLabelName();
                    if (!StringTools.isBlank((String)plName) && !plName.equalsIgnoreCase(privLabelName)) continue;
                    String managerID = account.getManagerID();
                    if (!StringTools.isBlank((String)manager) && !managerID.equals(manager)) continue;
                    ++acctCount;
                    if (StringTools.isBlank((String)type) || type.equalsIgnoreCase("all") || type.equalsIgnoreCase("active") || type.equalsIgnoreCase("count")) {
                        boolean groupALL;
                        long lastLoginTime;
                        boolean fullList = !type.equalsIgnoreCase("active");
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                        StringBuffer asb = new StringBuffer();
                        asb.append("Account: " + acctListID + " - " + account.getDescription());
                        asb.append(" [active=").append(account.getIsActive());
                        if (fullList) {
                            asb.append(", hasAdminUser=" + account.hasAdminUser());
                            if (account.isSystemAdmin()) {
                                asb.append(", isSysAdmin=true");
                            }
                            if (account.hasAdminUser()) {
                                String pass;
                                try {
                                    User adminUser = User.getUser(account, User.getAdminUserID());
                                    pass = adminUser != null ? adminUser.getDecodedPassword(null) : "??";
                                }
                                catch (DBException dbe) {
                                    pass = "???";
                                }
                                asb.append(", pass=" + pass);
                            } else {
                                asb.append(", pass=" + account.getDecodedPassword(null));
                            }
                        }
                        asb.append("]");
                        if (!AccountRecord.isValidID(acctListID)) {
                            asb.append(" (ID may contain invalid characters)");
                        }
                        Print.sysPrintln((String)asb.toString(), (Object[])new Object[0]);
                        Print.sysPrintln((String)("  > PrivateLabel: " + privLabelName), (Object[])new Object[0]);
                        if (!StringTools.isBlank((String)managerID)) {
                            Print.sysPrintln((String)("  > Account Manager: " + managerID), (Object[])new Object[0]);
                        }
                        String lastLoginDt = (lastLoginTime = account.getLastLoginTime()) > 0L ? new DateTime(lastLoginTime).toString() : "never";
                        Print.sysPrintln((String)("  > Last Login: " + lastLoginDt), (Object[])new Object[0]);
                        long expireTime = account.getExpirationTime();
                        if (expireTime > 0L) {
                            String expireDt = new DateTime(expireTime).toString();
                            boolean expired = expireTime < DateTime.getCurrentTimeSec();
                            Print.sysPrintln((String)("  > Expires: " + expireDt + (expired ? " [expired]" : "")), (Object[])new Object[0]);
                        }
                        if (!(groupALL = DBConfig.GetDefaultDeviceAuthorization(acctListID))) {
                            Print.sysPrintln((String)("  > Group 'ALL' Allowed: " + groupALL), (Object[])new Object[0]);
                        }
                        OrderedSet devList = new OrderedSet();
                        OrderedSet<String> devIDList = Device.getDeviceIDsForAccount(acctListID, null, true);
                        int devCntTotal = 0;
                        int devCntActiv = 0;
                        for (String devID : devIDList) {
                            Device device = account.getDevice(devID);
                            if (device == null) continue;
                            devList.add((Object)device);
                            ++devCntTotal;
                            ++tdevCountTotal;
                            if (account.getIsActive() && device.getIsActive()) {
                                ++devCntActiv;
                                ++tdevCountActiv;
                            }
                            tdevEventsPerSec += device.getAgedEventsPerSecond(nowMS);
                        }
                        Print.sysPrintln((String)("  > Active Device Count: " + devCntActiv + (devCntTotal > devCntActiv ? " [total=" + devCntTotal + "]" : "")), (Object[])new Object[0]);
                        if (type.equalsIgnoreCase("count")) continue;
                        for (Device device : devList) {
                            String lastEventDt;
                            String ephs;
                            String lastConnectDt;
                            String uniq = device.getDataTransport().getUniqueID();
                            boolean actv = account.getIsActive() && device.getIsActive();
                            StringBuffer dsb = new StringBuffer();
                            dsb.append("  ");
                            if (fullList) {
                                dsb.append("Device: ");
                            }
                            dsb.append("[ID=").append(device.getDeviceID());
                            dsb.append(", uniq=").append(uniq);
                            dsb.append(", active=").append(actv);
                            dsb.append("] ");
                            dsb.append(device.getDescription());
                            Print.sysPrintln((String)dsb.toString(), (Object[])new Object[0]);
                            long lastConnectTime = device.getLastConnectTime();
                            String string = lastConnectDt = lastConnectTime > 0L ? new DateTime(lastConnectTime).toString() : "never";
                            if (!fullList) continue;
                            Print.sysPrintln((String)("    > Last Connect: " + lastConnectDt), (Object[])new Object[0]);
                            long epst = device.getLastEventsPerSecondMS();
                            double eps = device.getAgedEventsPerSecond(nowMS);
                            double eph = eps * 60.0 * 60.0;
                            String string2 = ephs = eph >= 0.01 ? StringTools.format((double)eph, (String)"0.00") : "n/a";
                            if (eventCnt) {
                                long evCnt = device.getEventCount();
                                if (evCnt <= 0L) continue;
                                EventData[] lastEv = device.getLatestEvents(1L, false);
                                lastEventDt = new DateTime(lastEv[0].getTimestamp());
                                Print.sysPrintln((String)("    > Events: " + evCnt + "  [" + lastEventDt + "] ev/h=" + ephs), (Object[])new Object[0]);
                                continue;
                            }
                            Object[] lastEv = device.getLatestEvents(1L, false);
                            if (!ListTools.isEmpty((Object[])lastEv)) {
                                long lastEventTime = ((EventData)lastEv[0]).getTimestamp();
                                lastEventDt = new DateTime(lastEventTime).toString();
                                Print.sysPrintln((String)("    > Last Event: [" + lastEventDt + "] ev/h=" + ephs), (Object[])new Object[0]);
                                continue;
                            }
                            Print.sysPrintln((String)"    > Last Event: n/a", (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (!type.equalsIgnoreCase("comma")) continue;
                    if (acctCount > 1) {
                        Print.sysPrint((String)",", (Object[])new Object[0]);
                    }
                    Print.sysPrint((String)acctListID, (Object[])new Object[0]);
                }
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                Print.sysPrintln((String)("Total Active Device Count: " + tdevCountActiv + (tdevCountTotal > tdevCountActiv ? " [total=" + tdevCountTotal + "]" : "")), (Object[])new Object[0]);
                if (tdevEventsPerSec > 0.0) {
                    String eps = StringTools.format((double)tdevEventsPerSec, (String)"0.000");
                    String eph = StringTools.format((double)(tdevEventsPerSec * 3600.0), (String)"0");
                    Print.sysPrintln((String)("Average Rate of Events   : " + eps + "/second [" + eph + "/hour]"), (Object[])new Object[0]);
                }
                Print.sysPrintln((String)"", (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error listing Accounts", (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_PRUNE, (boolean)false)) {
            ++opts;
            try {
                Account.deleteAccounts(Account.getUnconfirmedAccounts());
                Account.deleteAccounts(Account.getExpiredAccounts(DateTime.DaySeconds((long)3L), false));
                Account.deactivateAccounts(Account.getExpiredAccounts(0L, true));
            }
            catch (DBException dbe) {
                Print.logException((String)"Error pruning Accounts", (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String)"reloadTest", (boolean)false)) {
            ++opts;
            if (!accountExists) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
            } else {
                try {
                    Account account = Account.getAccount(acctID, false);
                    Print.sysPrintln((String)("Original TimeZone   : " + account.getTimeZone()), (Object[])new Object[0]);
                    Print.sysPrintln((String)("Original AccountType: " + account.getAccountType()), (Object[])new Object[0]);
                    account.setTimeZone("US/Hawaii");
                    account.setAccountType(20);
                    Print.sysPrintln((String)("Before   TimeZone   : " + account.getTimeZone()), (Object[])new Object[0]);
                    Print.sysPrintln((String)("Before   AccountType: " + account.getAccountType()), (Object[])new Object[0]);
                    account.reload(new String[]{FLD_accountType});
                    Print.sysPrintln((String)("After 1  TimeZone   : " + account.getTimeZone()), (Object[])new Object[0]);
                    Print.sysPrintln((String)("After 1  AccountType: " + account.getAccountType()), (Object[])new Object[0]);
                    account.setAccountType(3);
                    account.reload(new String[]{FLD_timeZone});
                    Print.sysPrintln((String)("After 2  TimeZone   : " + account.getTimeZone()), (Object[])new Object[0]);
                    Print.sysPrintln((String)("After 2  AccountType: " + account.getAccountType()), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error displaying Account-ID: " + acctID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_CNT_OLD_EV) || RTConfig.hasProperty((String[])ARG_DEL_OLD_EV)) {
            ++opts;
            boolean deleteEvents = RTConfig.hasProperty((String[])ARG_DEL_OLD_EV);
            String actionText = deleteEvents ? "Deleting" : "Counting";
            TimeZone acctTMZ = DateTime.GMT;
            String argTime = deleteEvents ? RTConfig.getString((String[])ARG_DEL_OLD_EV, (String)"") : RTConfig.getString((String[])ARG_CNT_OLD_EV, (String)"");
            DateTime oldTime = null;
            if (StringTools.isBlank((String)argTime)) {
                Print.logError((String)("Invalid time specification: " + argTime), (Object[])new Object[0]);
                System.exit(98);
            } else if (argTime.equalsIgnoreCase("current")) {
                oldTime = new DateTime(acctTMZ);
            } else {
                try {
                    oldTime = DateTime.parseArgumentDate((String)argTime, (TimeZone)acctTMZ, (boolean)true);
                }
                catch (DateTime.DateParseException dpe) {
                    oldTime = null;
                }
                if (oldTime == null) {
                    Print.sysPrintln((String)("Invalid Time specification: " + argTime), (Object[])new Object[0]);
                    System.exit(98);
                } else if (oldTime.getTimeSec() > DateTime.getCurrentTimeSec()) {
                    Print.sysPrintln((String)(actionText + " future events not allowed"), (Object[])new Object[0]);
                    System.exit(98);
                }
            }
            Collection<Object> acctList = null;
            if (accountExists) {
                acctList = new Vector<String>();
                acctList.add(acctID);
            } else if (acctID.equalsIgnoreCase("all")) {
                try {
                    acctList = Account.getAllAccounts();
                }
                catch (DBException dbe) {
                    acctList = null;
                }
            } else if (acctID.endsWith("*") || acctID.endsWith("%")) {
                String partAcctID = acctID.substring(0, acctID.length() - 1);
                if (!StringTools.isBlank((String)partAcctID) && partAcctID.indexOf(",") < 0) {
                    acctList = new Vector();
                    try {
                        Collection<String> alist = Account.getAllAccounts();
                        for (String aid : alist) {
                            if (!aid.startsWith(partAcctID)) continue;
                            acctList.add(aid);
                        }
                    }
                    catch (DBException dbe) {
                        acctList = null;
                    }
                }
            } else if (acctID.indexOf(",") >= 0) {
                acctList = ListTools.toList((Object[])StringTools.split((String)acctID, (char)','));
            }
            for (String A : acctList) {
            }
            if (ListTools.isEmpty(acctList)) {
                Print.sysPrintln((String)"No Accounts specified", (Object[])new Object[0]);
                System.exit(1);
            }
            long oldTimeSec = oldTime.getTimeSec();
            boolean confirmDel = RTConfig.getBoolean((String[])ARG_CONFIRM_DEL, (boolean)false);
            try {
                Account account;
                if (deleteEvents) {
                    Print.sysPrintln((String)("Deleting events prior to: " + new DateTime(oldTimeSec)), (Object[])new Object[0]);
                    if (!confirmDel) {
                        Print.sysPrintln((String)("ERROR: Missing '-" + ARG_CONFIRM_DEL[0] + "', aborting delete ..."), (Object[])new Object[0]);
                        System.exit(1);
                    }
                    for (String A : acctList) {
                        if (StringTools.isBlank((String)A)) continue;
                        account = Account.getAccount(A);
                        if (account != null) {
                            account.deleteOldEvents(oldTimeSec, true);
                            continue;
                        }
                        Print.sysPrintln((String)("WARN: Skipping non-existent Account: " + A), (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)("Counting events prior to: " + new DateTime(oldTimeSec)), (Object[])new Object[0]);
                    for (String A : acctList) {
                        if (StringTools.isBlank((String)A)) continue;
                        account = Account.getAccount(A);
                        if (account != null) {
                            account.countOldEvents(oldTimeSec, true);
                            continue;
                        }
                        Print.sysPrintln((String)("WARN: Skipping non-existent Account: " + A), (Object[])new Object[0]);
                    }
                }
                System.exit(0);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error " + actionText + " old events: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_FIND_EMAIL)) {
            ++opts;
            String emailAddr = RTConfig.getString((String[])ARG_FIND_EMAIL, (String)"");
            Print.sysPrintln((String)("Searching for email address: " + emailAddr), (Object[])new Object[0]);
            int findCount = 0;
            try {
                Collection<String> AIDList = Account.getAllAccounts();
                for (String AID : AIDList) {
                    String[] UIDList;
                    String ane;
                    String ace;
                    Account A = Account.getAccount(AID);
                    if (A == null) continue;
                    String AHdr = " Account " + AID;
                    if (A.hasManagerID()) {
                        AHdr = AHdr + "[" + A.getManagerID() + "]";
                    }
                    if (StringTools.indexOfIgnoreCase((String)(ace = A.getContactEmail()), (String)emailAddr) >= 0) {
                        Print.sysPrintln((String)(AHdr + ": Contact Email [Account." + FLD_contactEmail + "] " + ace), (Object[])new Object[0]);
                        ++findCount;
                    }
                    if (StringTools.indexOfIgnoreCase((String)(ane = A.getNotifyEmail()), (String)emailAddr) >= 0) {
                        Print.sysPrintln((String)(AHdr + ": Notify Email [Account." + FLD_notifyEmail + "] " + ane), (Object[])new Object[0]);
                        ++findCount;
                    }
                    for (String UID : UIDList = User.getUsersForAccount(AID)) {
                        User U = User.getUser(A, UID);
                        if (U == null) continue;
                        String UHdr = " User " + AID + "/" + UID;
                        String uce = U.getContactEmail();
                        if (StringTools.indexOfIgnoreCase((String)uce, (String)emailAddr) < 0) continue;
                        Print.sysPrintln((String)(UHdr + ": Contact Email [User." + FLD_contactEmail + "] " + uce), (Object[])new Object[0]);
                        ++findCount;
                    }
                    OrderedSet<String> DIDList = Device.getDeviceIDsForAccount(AID, null, true);
                    for (String DID : DIDList) {
                        String sme;
                        Device D = Device.getDevice(A, DID);
                        if (D == null) continue;
                        String DHdr = " Device " + AID + "/" + DID;
                        String dne = D.getNotifyEmail(false, false);
                        if (StringTools.indexOfIgnoreCase((String)dne, (String)emailAddr) >= 0) {
                            Print.sysPrintln((String)(DHdr + ": Notify Email [Device." + FLD_notifyEmail + "] " + dne), (Object[])new Object[0]);
                            ++findCount;
                        }
                        if (StringTools.indexOfIgnoreCase((String)(sme = D.getSmsEmail()), (String)emailAddr) < 0) continue;
                        Print.sysPrintln((String)(DHdr + ": SMS Email [Device." + FLD_notifyEmail + "] " + sme), (Object[])new Object[0]);
                        ++findCount;
                    }
                    RuleFactory ruleFactory = Device.getRuleFactory();
                    if (ruleFactory == null) continue;
                    String[] RIDList = ruleFactory.getRuleIDs(A);
                    if (RIDList == null) {
                        RIDList = new String[]{};
                    }
                    for (String RID : RIDList) {
                        String RHdr = " Rule " + AID + "/" + RID;
                        String rne = StringTools.trim((String)ruleFactory.getRuleNotifyEmail(A, RID));
                        if (StringTools.indexOfIgnoreCase((String)rne, (String)emailAddr) < 0) continue;
                        Print.sysPrintln((String)(RHdr + ": Notify Email [Rule." + FLD_notifyEmail + "] " + rne), (Object[])new Object[0]);
                        ++findCount;
                    }
                }
                if (findCount <= 0) {
                    Print.sysPrintln((String)"Email address not found", (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)("Found " + findCount + " matches"), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Account error", (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            Account.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<Account> {
        public Key() {
        }

        public Key(String acctId) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.trim().toLowerCase() : ""));
        }

        public DBFactory<Account> getFactory() {
            return Account.getFactory();
        }
    }

    public static enum LatLonFormat implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        DEG(0, I18N.getString(Account.class, (String)"Account.latlon.degrees", (String)"Degrees")),
        DMS(1, I18N.getString(Account.class, (String)"Account.latlon.dms", (String)"Deg:Min:Sec")),
        DM(2, I18N.getString(Account.class, (String)"Account.latlon.dm", (String)"Deg:Min"));

        private int vv = 0;
        private I18N.Text aa = null;

        private LatLonFormat(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public boolean isDegrees() {
            return this.vv == DEG.getIntValue();
        }

        public boolean isDegMinSec() {
            return this.vv == DMS.getIntValue();
        }

        public boolean isDegMin() {
            return this.vv == DM.getIntValue();
        }

        public String getFormatType() {
            return this.isDegMinSec() ? "DMS" : (this.isDegMin() ? "DM" : "5");
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }
    }

    public static enum AreaUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        SQUARE_METERS(0, I18N.getString(Account.class, (String)"Account.area.squareMeters", (String)"Sq.m"), 1.0),
        SQUARE_FEET(1, I18N.getString(Account.class, (String)"Account.area.squareFeet", (String)"Sq.ft"), 10.763910416709722),
        SQUARE_MILES(10, I18N.getString(Account.class, (String)"Account.area.squareMiles", (String)"Sq.mi"), 3.861021585424458E-7),
        ACRES(20, I18N.getString(Account.class, (String)"Account.area.acres", (String)"Acres"), 2.471053814671653E-4);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;

        private AreaUnits(int v, I18N.Text a, double m) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double getMultiplier() {
            return this.mm;
        }

        public double convertFromSquareMeters(double v) {
            return v * this.mm;
        }

        public double convertToSquareMeters(double v) {
            return v / this.mm;
        }
    }

    public static enum ForceUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        MPSS(0, I18N.getString(Account.class, (String)"Account.force.metersPerSecSquared", (String)"m/ss"), 1.0),
        CMPSS(1, I18N.getString(Account.class, (String)"Account.force.centimPerSecSquared", (String)"cm/ss"), 100.0),
        G(5, I18N.getString(Account.class, (String)"Account.force.gForce", (String)"G"), 0.10197162129779283),
        MPHPS(10, I18N.getString(Account.class, (String)"Account.force.milesPerHourPerSec", (String)"mph/s"), 0.44704);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;

        private ForceUnits(int v, I18N.Text a, double m) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double getMultiplier() {
            return this.mm;
        }

        public double convertFromMetersPerSS(double v) {
            return v * this.mm;
        }

        public double convertToMetersPerSS(double v) {
            return v / this.mm;
        }
    }

    public static enum MassUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        KG(0, I18N.getString(Account.class, (String)"Account.mass.kg", (String)"kg"), 1.0),
        LB(1, I18N.getString(Account.class, (String)"Account.mass.lb", (String)"lb"), 2.20462262185);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;

        private MassUnits(int v, I18N.Text a, double m) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double getMultiplier() {
            return this.mm;
        }

        public double convertFromKG(double v) {
            return v * this.mm;
        }

        public double convertToKG(double v) {
            return v / this.mm;
        }
    }

    public static enum PressureUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        KPA(0, I18N.getString(Account.class, (String)"Account.pressure.kPa", (String)"kPa"), 1.0),
        PSI(1, I18N.getString(Account.class, (String)"Account.pressure.psi", (String)"psi"), 0.14503773773020923),
        MMHG(2, I18N.getString(Account.class, (String)"Account.pressure.mmHg", (String)"mmHg"), 7.500637554),
        BAR(3, I18N.getString(Account.class, (String)"Account.pressure.bar", (String)"bar"), 0.01);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;

        private PressureUnits(int v, I18N.Text a, double m) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double getMultiplier() {
            return this.mm;
        }

        public double convertFromKPa(double v) {
            return v * this.mm;
        }

        public double convertToKPa(double v) {
            return v / this.mm;
        }
    }

    public static enum EconomyUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        MPG(0, I18N.getString(Account.class, (String)"Account.economy.mpg", (String)"mpg"), 2.352145833333333, false),
        KPL(1, I18N.getString(Account.class, (String)"Account.economy.kpl", (String)"km/L"), 1.0, false),
        KPG(2, I18N.getString(Account.class, (String)"Account.economy.kpg", (String)"kpg"), 3.785411784, false),
        LP100KM(3, I18N.getString(Account.class, (String)"Account.economy.lp100km", (String)"L/100km"), 0.01, true);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;
        private boolean ii = false;

        private EconomyUnits(int v, I18N.Text a, double m, boolean i) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
            this.ii = i;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double convertFromKPL(double v) {
            return v == 0.0 ? 0.0 : (this.ii ? 1.0 / (v * this.mm) : v * this.mm);
        }

        public double convertToKPL(double v) {
            return v == 0.0 ? 0.0 : (this.ii ? 1.0 / v / this.mm : v / this.mm);
        }
    }

    public static enum VolumeUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        US_GALLONS(0, I18N.getString(Account.class, (String)"Account.volume.usgal", (String)"gal"), 0.26417205235814845),
        LITERS(1, I18N.getString(Account.class, (String)"Account.volume.liter", (String)"Liter"), 1.0),
        UK_GALLONS(2, I18N.getString(Account.class, (String)"Account.volume.ukgal", (String)"IG"), 0.21996924829908776),
        CUBIC_FEET(3, I18N.getString(Account.class, (String)"Account.volume.cubicFt", (String)"ft^3"), 0.0353146667);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;

        private VolumeUnits(int v, I18N.Text a, double m) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double getMultiplier() {
            return this.mm;
        }

        public double convertFromLiters(double v) {
            return v * this.mm;
        }

        public double convertToLiters(double v) {
            return v / this.mm;
        }

        public boolean isUSGallons() {
            return this.equals((Object)US_GALLONS);
        }
    }

    public static enum TemperatureUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        F(0, I18N.getString(Account.class, (String)"Account.temperature.f", (String)"F")),
        C(1, I18N.getString(Account.class, (String)"Account.temperature.c", (String)"C"));

        private int vv = 0;
        private I18N.Text aa = null;

        private TemperatureUnits(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double convertFromC(double c) {
            return this.equals((Object)F) ? c * 9.0 / 5.0 + 32.0 : c;
        }

        public double convertToC(double c) {
            return this.equals((Object)F) ? (c - 32.0) * 5.0 / 9.0 : c;
        }
    }

    public static enum AltitudeUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        FEET(0, I18N.getString(Account.class, (String)"Account.altitude.feet", (String)"feet"), 3.280839895013123),
        METERS(1, I18N.getString(Account.class, (String)"Account.altitude.meters", (String)"meters"), 1.0),
        MILES(2, I18N.getString(Account.class, (String)"Account.altitude.miles", (String)"miles"), 6.213711922373339E-4),
        KM(3, I18N.getString(Account.class, (String)"Account.altitude.km", (String)"km"), 0.001),
        CUBITS(4, I18N.getString(Account.class, (String)"Account.altitude.cubits", (String)"cubits"), 2.187226597);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;

        private AltitudeUnits(int v, I18N.Text a, double m) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double getMultiplier() {
            return this.mm;
        }

        public boolean isMeters() {
            return this.equals((Object)METERS);
        }

        public boolean isFeet() {
            return this.equals((Object)FEET);
        }

        public double convertFromMeters(double v) {
            return v * this.mm;
        }

        public double convertToMeters(double v) {
            return v / this.mm;
        }
    }

    public static enum DistanceUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        MILES(0, I18N.getString(Account.class, (String)"Account.distance.miles", (String)"Miles"), 0.621371192237334),
        KM(1, I18N.getString(Account.class, (String)"Account.distance.km", (String)"Km"), 1.0),
        NM(2, I18N.getString(Account.class, (String)"Account.distance.nm", (String)"Nm"), 0.5399568034557235);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;

        private DistanceUnits(int v, I18N.Text a, double m) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double getMultiplier() {
            return this.mm;
        }

        public boolean isKM() {
            return this.equals((Object)KM);
        }

        public boolean isMiles() {
            return this.equals((Object)MILES);
        }

        public boolean isKnots() {
            return this.equals((Object)NM);
        }

        public double convertFromKM(double v) {
            return v * this.mm;
        }

        public double convertToKM(double v) {
            return v / this.mm;
        }
    }

    public static enum SpeedUnits implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        MPH(0, I18N.getString(Account.class, (String)"Account.speed.mph", (String)"mph"), 0.621371192237334),
        KPH(1, I18N.getString(Account.class, (String)"Account.speed.kph", (String)"km/h"), 1.0),
        KNOTS(2, I18N.getString(Account.class, (String)"Account.speed.knots", (String)"knots"), 0.5399568034557235);

        private int vv = 0;
        private I18N.Text aa = null;
        private double mm = 1.0;

        private SpeedUnits(int v, I18N.Text a, double m) {
            this.vv = v;
            this.aa = a;
            this.mm = m;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public double getMultiplier() {
            return this.mm;
        }

        public double convertFromKPH(double v) {
            return v * this.mm;
        }

        public double convertToKPH(double v) {
            return v / this.mm;
        }
    }

    public static enum GeocoderMode implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        NONE(0, I18N.getString(Account.class, (String)"Account.geocoder.none", (String)"none")),
        GEOZONE(1, I18N.getString(Account.class, (String)"Account.geocoder.geozone", (String)"geozone")),
        PARTIAL(2, I18N.getString(Account.class, (String)"Account.geocoder.partial", (String)"partial")),
        FULL(3, I18N.getString(Account.class, (String)"Account.geocoder.full", (String)"full"));

        private int vv = 0;
        private I18N.Text aa = null;

        private GeocoderMode(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean isNone() {
            return this.getIntValue() <= 0;
        }

        public boolean okGeozone() {
            return this.getIntValue() >= 1;
        }

        public boolean okPartial() {
            return this.getIntValue() >= 2;
        }

        public boolean okFull() {
            return this.getIntValue() >= 3;
        }
    }

    public static enum AccountType implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        TYPE_000(0, I18N.getString(Account.class, (String)"Account.type.type000", (String)"Type000")),
        TYPE_001(1, I18N.getString(Account.class, (String)"Account.type.type001", (String)"Type001")),
        TYPE_002(2, I18N.getString(Account.class, (String)"Account.type.type002", (String)"Type002")),
        TYPE_003(3, I18N.getString(Account.class, (String)"Account.type.type003", (String)"Type003")),
        TYPE_004(4, I18N.getString(Account.class, (String)"Account.type.type004", (String)"Type004")),
        TYPE_005(5, I18N.getString(Account.class, (String)"Account.type.type005", (String)"Type005")),
        TYPE_006(6, I18N.getString(Account.class, (String)"Account.type.type006", (String)"Type006")),
        TYPE_007(7, I18N.getString(Account.class, (String)"Account.type.type007", (String)"Type007")),
        TYPE_008(8, I18N.getString(Account.class, (String)"Account.type.type008", (String)"Type008")),
        TYPE_009(9, I18N.getString(Account.class, (String)"Account.type.type009", (String)"Type009")),
        TYPE_010(10, I18N.getString(Account.class, (String)"Account.type.type010", (String)"Type010")),
        TYPE_011(11, I18N.getString(Account.class, (String)"Account.type.type011", (String)"Type011")),
        TYPE_020(20, I18N.getString(Account.class, (String)"Account.type.type020", (String)"Type020")),
        TYPE_021(21, I18N.getString(Account.class, (String)"Account.type.type021", (String)"Type021")),
        TYPE_030(30, I18N.getString(Account.class, (String)"Account.type.type030", (String)"Type030")),
        TYPE_031(31, I18N.getString(Account.class, (String)"Account.type.type031", (String)"Type031")),
        TEMPORARY(900, I18N.getString(Account.class, (String)"Account.type.temporary", (String)"Temporary")),
        DEMO(920, I18N.getString(Account.class, (String)"Account.type.demo", (String)"Demo")),
        SYSTEM(999, I18N.getString(Account.class, (String)"Account.type.system", (String)"System"));

        private int vv = 0;
        private I18N.Text aa = null;

        private AccountType(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean isDefault() {
            return this.equals((Object)TYPE_000);
        }

        public boolean isTemporary() {
            return this.equals((Object)TEMPORARY);
        }

        public boolean isSystem() {
            return this.equals((Object)SYSTEM);
        }

        public boolean isType(int type) {
            return this.getIntValue() == type;
        }
    }

    public static enum SMSDefaultState {
        FALSE,
        TRUE,
        ACCOUNT;

    }
}

