/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.dmtp;

import java.util.Locale;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.dmtp.PropertyKey;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Property
extends DeviceRecord<Property> {
    public static final String _TABLE_NAME = "Property";
    public static final String FLD_propKey = "propKey";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_binaryValue = "binaryValue";
    private static DBField[] FieldInfo = new DBField[]{Property.newField_accountID(true), Property.newField_deviceID(true), new DBField("propKey", Integer.TYPE, "UINT32", "Property Key", "key=true"), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", null), new DBField("binaryValue", byte[].class, "BLOB", "Binary Value", null)};
    private static DBFactory<Property> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_DEMO = new String[]{"demo"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Property> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Property.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Property.class, Key.class, (boolean)false, (boolean)false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public Property() {
    }

    public Property(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Property.class, (Locale)loc);
        return i18n.getString("Property.description", "This table contains Device specific property information collected from client devices.");
    }

    public int getPropKey() {
        Integer v = (Integer)this.getFieldValue(FLD_propKey);
        return v != null ? v : 0;
    }

    public String getPropKeyHex() {
        return StringTools.toHexString((long)this.getPropKey(), (int)16);
    }

    public void setPropKey(int v) {
        this.setFieldValue(FLD_propKey, v);
    }

    public long getTimestamp() {
        Long v = (Long)this.getFieldValue(FLD_timestamp);
        return v != null ? v : 0L;
    }

    public void setTimestamp(long v) {
        this.setFieldValue(FLD_timestamp, v);
    }

    public byte[] getBinaryValue() {
        byte[] v = (byte[])this.getFieldValue(FLD_binaryValue);
        return v != null ? v : new byte[]{};
    }

    private void setBinaryValue(byte[] v) {
        this.setFieldValue(FLD_binaryValue, v != null ? v : new byte[]{});
    }

    public static boolean saveProperty(Device device, int propKey, byte[] propVal) throws DBException {
        if (device != null) {
            String acctID = device.getAccountID();
            String devID = device.getDeviceID();
            return Property.saveProperty(acctID, devID, propKey, propVal);
        }
        return false;
    }

    public static boolean saveProperty(String acctID, String devID, int propKey, byte[] propVal) throws DBException {
        if (acctID != null && !acctID.equals("") && devID != null && !devID.equals("") && propKey > 0 && propVal != null) {
            Key key = new Key(acctID, devID, propKey);
            Property prop = new Property(key);
            prop.setTimestamp(DateTime.getCurrentTimeSec());
            prop.setBinaryValue(propVal);
            prop.save();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAccountID()).append("/").append(this.getDeviceID());
        sb.append(" ");
        PropertyKey pk = this.getPropertyKey();
        if (pk != null) {
            sb.append(pk.getName());
            sb.append(" [").append(pk.getKeyHex()).append("] ");
            sb.append(pk.toStringValue(this.getBinaryValue()));
        } else {
            sb.append("[").append(StringTools.toHexString((long)this.getPropKey(), (int)16)).append("] ");
            sb.append("0x").append(StringTools.toHexString((byte[])this.getBinaryValue()));
        }
        return sb.toString();
    }

    public String getDescription() {
        return PropertyKey.GetKeyDescription(this.getPropKey());
    }

    public String getValueAsString() {
        PropertyKey pk = this.getPropertyKey();
        byte[] bin = this.getBinaryValue();
        if (pk != null) {
            return pk.toStringValue(bin);
        }
        Print.logWarn((String)("Invalid Property Key: " + this.getPropKeyHex()), (Object[])new Object[0]);
        return "0x" + StringTools.toHexString((byte[])bin);
    }

    public PropertyKey getPropertyKey() {
        return PropertyKey.GetPropertyKey(this.getPropKey());
    }

    public String getName() {
        PropertyKey pk = this.getPropertyKey();
        if (pk != null) {
            return pk.getName();
        }
        return "";
    }

    public int getPropertyType() {
        PropertyKey pk = this.getPropertyKey();
        if (pk != null) {
            return pk.getType();
        }
        return 0;
    }

    public boolean isNumeric() {
        PropertyKey pk = this.getPropertyKey();
        if (pk != null) {
            return pk.isNumeric();
        }
        return false;
    }

    public int[] getIntValues() {
        PropertyKey pk = this.getPropertyKey();
        if (pk != null) {
            return pk.toIntArray(this.getBinaryValue());
        }
        return null;
    }

    public double[] getDoubleValues() {
        PropertyKey pk = this.getPropertyKey();
        if (pk != null) {
            return pk.toDoubleArray(this.getBinaryValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Property[] getProperties(String acctId, String devId) throws DBException {
        if (acctId == null || acctId.equals("")) {
            return null;
        }
        if (devId == null || devId.equals("")) {
            return null;
        }
        DBSelect dsel = new DBSelect(Property.getFactory());
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("deviceID", (Object)devId))));
        dsel.setOrderByFields(new String[]{FLD_propKey});
        dsel.setLimit(-1L);
        Property[] p = null;
        try {
            DBProvider.lockTables((String[])new String[]{Property.TABLE_NAME()}, null);
            p = (Property[])DBRecord.select((DBSelect)dsel);
        }
        finally {
            DBProvider.unlockTables();
        }
        if (p == null) {
            return null;
        }
        return p;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + Property.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>           Acount ID which owns the specified Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>            Device ID to read properties", (Object[])new Object[0]);
        Print.logInfo((String)"  -list                   List properties", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String deviceID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (accountID == null || accountID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            Property.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(accountID);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                Property.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
            System.exit(99);
        }
        OrderedSet deviceList = null;
        try {
            if (deviceID != null && !deviceID.equals("")) {
                if (Device.exists(accountID, deviceID)) {
                    deviceList = new OrderedSet((Object[])new String[]{deviceID});
                } else {
                    Print.logError((String)("Device-ID does not exist: " + deviceID), (Object[])new Object[0]);
                    Property.usage();
                }
            } else {
                deviceList = Device.getDeviceIDsForAccount(accountID, null, true);
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Devices from Account: " + accountID), (Throwable)dbe);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            for (int d = 0; d < deviceList.size(); ++d) {
                String devId = (String)deviceList.get(d);
                try {
                    Device device = Device.getDevice(account, devId);
                    if (device != null) {
                        Print.sysPrintln((String)("Properties: " + accountID + "/" + devId + " [\"" + device.getDescription() + "\"]:"), (Object[])new Object[0]);
                        Property[] p = Property.getProperties(accountID, devId);
                        if (p != null && p.length > 0) {
                            for (int i = 0; i < p.length; ++i) {
                                PropertyKey pk = p[i].getPropertyKey();
                                StringBuffer sb = new StringBuffer("  ");
                                sb.append("[0x").append(p[i].getPropKeyHex()).append("]").append(p[i].getName());
                                sb.append(" = ").append(p[i].getValueAsString());
                                sb.append("  // ").append(new DateTime(p[i].getTimestamp()).toString());
                                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                            }
                        } else {
                            Print.sysPrintln((String)"  No properties", (Object[])new Object[0]);
                        }
                    } else {
                        Print.logError((String)("Device-ID does not exist: " + devId), (Object[])new Object[0]);
                    }
                }
                catch (Throwable th) {
                    Print.logException((String)"Error while getting properties for account/device", (Throwable)th);
                    System.exit(1);
                }
                Print.sysPrintln((String)"", (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_DEMO)) {
            ++opts;
            try {
                Key key = new Key("demo", "demo", 61717);
                Property record = (Property)key.getDBRecord();
                record.setBinaryValue("demo".getBytes());
                record.save();
            }
            catch (DBException dbe) {
                Print.logException((String)"Error creating demo Property", (Throwable)dbe);
                System.exit(99);
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            Property.usage();
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<Property> {
        public Key() {
        }

        public Key(String acctId, String devId, int propKey) {
            super.setFieldValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setFieldValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setFieldValue(Property.FLD_propKey, propKey);
        }

        public DBFactory<Property> getFactory() {
            return Property.getFactory();
        }
    }
}

