/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.dmtp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import org.opendmtp.codes.PropCodes;
import org.opendmtp.server.base.Packet;
import org.opendmtp.server.base.PacketParseException;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class PendingPacket
extends DeviceRecord<PendingPacket> {
    public static final String _TABLE_NAME = "PendingPacket";
    public static final String FLD_queueTime = "queueTime";
    public static final String FLD_sequence = "sequence";
    public static final String FLD_packetBytes = "packetBytes";
    public static final String FLD_autoDelete = "autoDelete";
    private static DBField[] FieldInfo = new DBField[]{PendingPacket.newField_accountID(true), PendingPacket.newField_deviceID(true), new DBField("queueTime", Long.TYPE, "UINT32", "Packet Queue Time", "key=true"), new DBField("sequence", Integer.TYPE, "UINT16", "Sequence", "key=true"), new DBField("packetBytes", byte[].class, "MBLOB", "Packet Bytes", null), new DBField("autoDelete", Boolean.TYPE, "BOOLEAN", "Delete after sending", "edit=2")};
    private static DBFactory<PendingPacket> factory = null;
    private static Object timestampLock = new Object();
    private static long lastTimestamp = 0L;
    private static int lastSequence = 0;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_SETPROP = new String[]{"setprop"};
    private static final String[] ARG_GETPROP = new String[]{"getprop"};
    private static final String[] ARG_GETGPS = new String[]{"getgps"};
    private static final String[] ARG_UPLOAD = new String[]{"upload"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_GEOZ = new String[]{"geoz"};
    private static final String[] ARG_REBOOT = new String[]{"reboot"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<PendingPacket> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)PendingPacket.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, PendingPacket.class, Key.class, (boolean)false, (boolean)false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public PendingPacket() {
    }

    public PendingPacket(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(PendingPacket.class, (Locale)loc);
        return i18n.getString("PendingPacket.description", "This table contains configuration packets which are to be sent to the DMTP client device the next time it 'checks-in' with the server.");
    }

    public long getQueueTime() {
        Long v = (Long)this.getFieldValue(FLD_queueTime);
        return v != null ? v : 0L;
    }

    public void setQueueTime(long v) {
        this.setFieldValue(FLD_queueTime, v);
    }

    public int getSequence() {
        Integer v = (Integer)this.getFieldValue(FLD_sequence);
        return v != null ? v : 0;
    }

    public void setSequence(int v) {
        this.setFieldValue(FLD_sequence, v);
    }

    public byte[] getPacketBytes() {
        byte[] v = (byte[])this.getFieldValue(FLD_packetBytes);
        return v != null ? v : new byte[]{};
    }

    public void setPacketBytes(byte[] v) {
        this.setFieldValue(FLD_packetBytes, v != null ? v : new byte[]{});
    }

    public void setPacketBytes(byte[] v, int vlen) {
        if (v == null || vlen == 0) {
            this.setFieldValue(FLD_packetBytes, new byte[0]);
        } else if (vlen > 0 && vlen < v.length) {
            byte[] vc = new byte[vlen];
            System.arraycopy(v, 0, vc, 0, vlen);
            this.setFieldValue(FLD_packetBytes, vc);
        } else {
            this.setFieldValue(FLD_packetBytes, v);
        }
    }

    public boolean getAutoDelete() {
        Boolean v = (Boolean)this.getFieldValue(FLD_autoDelete);
        return v != null ? v : false;
    }

    public void setAutoDelete(boolean v) {
        this.setFieldValue(FLD_autoDelete, v);
    }

    public boolean isAutoDelete() {
        return this.getAutoDelete();
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getDeviceID() + "/" + this.getQueueTime() + "/" + this.getSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key _CreatePendingPacketKey(String accountID, String deviceID) {
        int sequence;
        long timestamp;
        Object object = timestampLock;
        synchronized (object) {
            long now = DateTime.getCurrentTimeSec();
            if (now == lastTimestamp) {
                ++lastSequence;
            } else {
                lastTimestamp = now;
                lastSequence = 0;
            }
            timestamp = lastTimestamp;
            sequence = lastSequence;
        }
        return new Key(accountID, deviceID, timestamp, sequence);
    }

    public Packet[] getPackets() throws PacketParseException {
        int len;
        byte[] b = this.getPacketBytes();
        if (b == null || b.length == 0) {
            Print.logWarn((String)"No packet bytes ...", (Object[])new Object[0]);
            return null;
        }
        Vector<Packet> pkts = new Vector<Packet>();
        for (int ofs = 0; ofs < b.length; ofs += len) {
            len = Packet.getPacketLength((byte[])b, (int)ofs);
            if (len > 0) {
                try {
                    byte[] p = new byte[len];
                    System.arraycopy(b, ofs, p, 0, len);
                    Packet pkt = new Packet(p);
                    pkts.add(pkt);
                    continue;
                }
                catch (PacketParseException ppe) {
                    Print.logException((String)"Invalid PendingPacket found!", (Throwable)ppe);
                    throw ppe;
                }
            }
            Print.logInfo((String)("Premature end of packet bytes: ofs=" + ofs), (Object[])new Object[0]);
            throw new PacketParseException(61715);
        }
        int pktCnt = pkts.size();
        if (pktCnt <= 0) {
            Print.logWarn((String)"No packet data found in this pending packet! ...", (Object[])new Object[0]);
            return null;
        }
        return pkts.toArray(new Packet[pktCnt]);
    }

    public void setPackets(Packet[] pkt) {
        if (pkt != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int i = 0; i < pkt.length; ++i) {
                try {
                    baos.write(pkt[i].encode(0));
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.setPacketBytes(baos.toByteArray());
        } else {
            this.setPacketBytes(null);
        }
    }

    public static void deletePendingPackets(String acctId, String devId, long queueTime) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return;
        }
        if (StringTools.isBlank((String)devId)) {
            return;
        }
        DBConnection dbc = null;
        try {
            DBDelete ddel = new DBDelete(PendingPacket.getFactory());
            DBWhere dwh = ddel.createDBWhere();
            ddel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("deviceID", (Object)devId), queueTime > 0L ? dwh.LE(FLD_queueTime, queueTime) : null)));
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(ddel.toString());
        }
        catch (SQLException sqe) {
            try {
                throw new DBException("PendingPacket deletion", (Throwable)sqe);
            }
            catch (Throwable throwable) {
                DBConnection.release(dbc);
                throw throwable;
            }
        }
        DBConnection.release((DBConnection)dbc);
    }

    public static PendingPacket[] getPendingPackets(String acctId, String devId) throws DBException {
        return PendingPacket.getPendingPackets(acctId, devId, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PendingPacket[] getPendingPackets(String acctId, String devId, long limit) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)devId)) {
            return null;
        }
        DBSelect dsel = new DBSelect(PendingPacket.getFactory());
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("deviceID", (Object)devId))));
        dsel.setOrderByFields(new String[]{FLD_queueTime, FLD_sequence});
        dsel.setLimit(limit);
        PendingPacket[] pp = null;
        try {
            DBProvider.lockTables((String[])new String[]{PendingPacket.TABLE_NAME()}, null);
            pp = (PendingPacket[])DBRecord.select((DBSelect)dsel);
        }
        finally {
            DBProvider.unlockTables();
        }
        if (pp == null) {
            return null;
        }
        if (limit > 0L && (long)pp.length > limit) {
            PendingPacket[] pp2 = new PendingPacket[(int)limit];
            System.arraycopy(pp, 0, pp2, 0, (int)limit);
            pp = pp2;
        }
        return pp;
    }

    public static Packet[] extractPackets(PendingPacket[] pp) throws PacketParseException {
        if (ListTools.isEmpty((Object[])pp)) {
            Print.logWarn((String)"No PendingPacket list specified", (Object[])new Object[0]);
            return null;
        }
        if (pp.length == 1) {
            return pp[0].getPackets();
        }
        Vector v = new Vector();
        for (int i = 0; i < pp.length; ++i) {
            Object[] p = pp[i].getPackets();
            ListTools.toList((Object[])p, v);
        }
        return v.toArray(new Packet[v.size()]);
    }

    public static boolean insertPackets(Device dev, Packet[] pkt) throws DBException {
        if (dev != null && !ListTools.isEmpty((Object[])pkt)) {
            String acctId = dev.getAccountID();
            String devId = dev.getDeviceID();
            return PendingPacket.insertPackets(acctId, devId, pkt);
        }
        return false;
    }

    public static boolean insertPackets(String acctId, String devId, Packet[] pkt) throws DBException {
        if (!(StringTools.isBlank((String)acctId) || StringTools.isBlank((String)devId) || ListTools.isEmpty((Object[])pkt))) {
            PendingPacket pp = new PendingPacket(PendingPacket._CreatePendingPacketKey(acctId, devId));
            pp.setPackets(pkt);
            pp.save();
            return true;
        }
        return false;
    }

    public static SetPropertyPacket createSetPropertyPacket(int propCode, String propDataStr) {
        try {
            return new SetPropertyPacket(propCode, propDataStr);
        }
        catch (PacketParseException ppe) {
            return null;
        }
    }

    public static boolean insertSetPropertyPacket(Device device, SetPropertyPacket setPropPacket) throws DBException {
        if (device == null || setPropPacket == null) {
            return false;
        }
        int code = setPropPacket.getCode();
        byte[] data = setPropPacket.getData();
        int dataLen = setPropPacket.getDataLength();
        return PendingPacket.insertSetPropertyPacket(device, code, data, dataLen);
    }

    public static boolean insertSetPropertyPacket(Device device, int propCode, String propDataStr) throws DBException {
        if (device == null) {
            return false;
        }
        Object[] propArgs = PropCodes.parsePropertyValue((int)propCode, (String)propDataStr);
        if (ListTools.isEmpty((Object[])propArgs)) {
            Print.logError((String)("Invalid property value(s) specified: " + propDataStr), (Object[])new Object[0]);
            return false;
        }
        byte[] propData = PropCodes.encodePropertyData((int)propCode, (Object[])propArgs);
        if (ListTools.isEmpty((byte[])propData)) {
            Print.logError((String)("Unable to encode property data: " + propDataStr), (Object[])new Object[0]);
            return false;
        }
        int pdLen = propData != null ? propData.length : 0;
        return PendingPacket.insertSetPropertyPacket(device, propCode, propData, pdLen);
    }

    public static boolean insertSetPropertyPacket(Device device, int propCode, byte[] propData, int propDataLen) throws DBException {
        if (device == null) {
            Print.logError((String)"Device is null", (Object[])new Object[0]);
            return false;
        }
        String acctId = device.getAccountID();
        String devId = device.getDeviceID();
        if (acctId.equals("") || devId.equals("")) {
            Print.logError((String)"Account/Device is empty/null", (Object[])new Object[0]);
            return false;
        }
        PendingPacket[] ppa = PendingPacket.getPendingPackets(acctId, devId, -1L);
        if (!ListTools.isEmpty((Object[])ppa)) {
            for (int i = 0; i < ppa.length; ++i) {
                try {
                    Object[] pkt = PendingPacket.extractPackets(new PendingPacket[]{ppa[i]});
                    if (!ListTools.isEmpty((Object[])pkt)) {
                        for (int p = 0; p < pkt.length; ++p) {
                            int pktPropCode;
                            if (!pkt[p].isBasicPacketHeader() || pkt[p].getPacketType() != 177 || (pktPropCode = (int)pkt[p].getPayload(true).readULong(2, 0L)) != propCode) continue;
                            if (pkt.length == 1) {
                                try {
                                    Print.logInfo((String)("Deleting existing SetProperty for Code: 0x" + StringTools.toHexString((long)propCode, (int)16)), (Object[])new Object[0]);
                                    Key key = (Key)ppa[i].getRecordKey();
                                    key.delete(true);
                                    continue;
                                }
                                catch (DBException dbe) {
                                    Print.logException((String)"Unable to delete existing PendingPacket", (Throwable)dbe);
                                    return false;
                                }
                            }
                            Print.logError((String)"A SetProperty for this code already exists!", (Object[])new Object[0]);
                            return false;
                        }
                        continue;
                    }
                    Print.logWarn((String)("PendingPacket found which does not contain any Packets: " + (Object)((Object)ppa[i])), (Object[])new Object[0]);
                    continue;
                }
                catch (PacketParseException ppe) {
                    long qt = ppa[i].getQueueTime();
                    int seq = ppa[i].getSequence();
                    Print.logError((String)("Error parsing packets: queueTime=" + qt + ", sequence=" + seq), (Object[])new Object[0]);
                }
            }
        }
        PendingPacket pp = new PendingPacket(PendingPacket._CreatePendingPacketKey(acctId, devId));
        Packet propsPkt = Packet.createServerSetPropertyPacket((int)propCode, (byte[])propData, (int)propDataLen);
        Print.logInfo((String)("[" + acctId + "/" + devId + "] Inserting " + propsPkt), (Object[])new Object[0]);
        pp.setPackets(new Packet[]{propsPkt});
        pp.save();
        return true;
    }

    public static boolean insertGetPropertyPacket(Device device, int propCode, byte[] propData, int propDataLen) throws DBException {
        if (device != null) {
            String acctId = device.getAccountID();
            String devId = device.getDeviceID();
            if (!acctId.equals("") && !devId.equals("")) {
                PendingPacket pp = new PendingPacket(PendingPacket._CreatePendingPacketKey(acctId, devId));
                Packet propsPkt = Packet.createServerGetPropertyPacket((int)propCode, (byte[])propData, (int)propDataLen);
                Print.logInfo((String)("Inserting " + propsPkt), (Object[])new Object[0]);
                pp.setPackets(new Packet[]{propsPkt});
                pp.save();
            }
        }
        return false;
    }

    public static boolean insertGetGpsDiagnostic(Device device) throws DBException {
        if (device != null) {
            String acctId = device.getAccountID();
            String devId = device.getDeviceID();
            if (!acctId.equals("") && !devId.equals("")) {
                PendingPacket pp = new PendingPacket(PendingPacket._CreatePendingPacketKey(acctId, devId));
                Packet propsPkt = Packet.createServerGetPropertyPacket((int)61732, null, (int)0);
                Print.logInfo((String)("Inserting " + propsPkt), (Object[])new Object[0]);
                pp.setPackets(new Packet[]{propsPkt});
                pp.save();
            }
        }
        return false;
    }

    public static boolean insertUploadFilePacket(Device device, String uplFileName, long uplFileSize) throws DBException {
        if (device != null && uplFileName != null && uplFileSize >= 0L) {
            String acctId = device.getAccountID();
            String devId = device.getDeviceID();
            if (!acctId.equals("") && !devId.equals("")) {
                PendingPacket pp = new PendingPacket(PendingPacket._CreatePendingPacketKey(acctId, devId));
                Packet propsPkt = Packet.createServerGetFilePacket((String)uplFileName, (long)uplFileSize);
                Print.logInfo((String)("Inserting " + propsPkt), (Object[])new Object[0]);
                pp.setPackets(new Packet[]{propsPkt});
                pp.save();
            }
        }
        return false;
    }

    public static Packet[] createGeozoneUploadPackets(String acctId, String version) {
        Geozone[] gz = Geozone.getClientUploadZones(acctId);
        if (gz == null) {
            return null;
        }
        Vector<Packet> packets = new Vector<Packet>();
        Payload p = new Payload();
        p.clear();
        p.writeULong(62786L, 2);
        p.writeULong(32L, 1);
        packets.add(Packet.createServerPacket((int)177, (byte[])p.getBytes()));
        int gzNdx = 0;
        while (gzNdx < gz.length) {
            p.clear();
            p.writeULong(62786L, 2);
            p.writeULong(16L, 1);
            while (gzNdx < gz.length && gz[gzNdx].encodeDMTPZone(p, 2, false)) {
                ++gzNdx;
            }
            packets.add(Packet.createServerPacket((int)177, (byte[])p.getBytes()));
        }
        p.clear();
        p.writeULong(62786L, 2);
        p.writeULong(48L, 1);
        packets.add(Packet.createServerPacket((int)177, (byte[])p.getBytes()));
        p.clear();
        p.writeULong(62792L, 2);
        p.writeString(version != null ? version : "", 16);
        packets.add(Packet.createServerPacket((int)177, (byte[])p.getBytes()));
        return packets.toArray(new Packet[packets.size()]);
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + PendingPacket.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>           Acount ID which owns the specified Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>            Device ID to apply pending packets", (Object[])new Object[0]);
        Print.logInfo((String)"  -setprop=<key>:<data>   Set the specified property key to this value", (Object[])new Object[0]);
        Print.logInfo((String)"  -getprop=<key>[:<arg>]  Get the value of the specified property key", (Object[])new Object[0]);
        Print.logInfo((String)"  -geoz[=<version>]       Upload all client geozones for this device", (Object[])new Object[0]);
        Print.logInfo((String)"  -list                   List all pending packets for Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete=<time>          Delete all pending packets for Device up to specified time (-1 for ALL)", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        int propCode;
        String propDataStr;
        String propCodeStr;
        int p;
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (StringTools.isBlank((String)acctID)) {
            Print.sysPrintln((String)"ERROR: Account-ID not specified.", (Object[])new Object[0]);
            PendingPacket.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(acctID);
            if (account == null) {
                Print.sysPrintln((String)("ERROR: Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                PendingPacket.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (StringTools.isBlank((String)devID)) {
            Print.sysPrintln((String)"ERROR: Device-ID not specified.", (Object[])new Object[0]);
            PendingPacket.usage();
        }
        Device device = null;
        try {
            device = Device.getDevice(account, devID, false);
            if (device == null) {
                Print.sysPrintln((String)("ERROR: Device-ID does not exist: " + devID), (Object[])new Object[0]);
                PendingPacket.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Device: " + devID), (Throwable)dbe);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.hasProperty((String[])ARG_GETPROP)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            String getprop = RTConfig.getString((String[])ARG_GETPROP, (String)"");
            p = getprop.indexOf(58);
            propCodeStr = p >= 0 ? getprop.substring(0, p) : getprop;
            propDataStr = p >= 0 ? getprop.substring(p + 1) : null;
            propCode = StringTools.parseHexInt((String)propCodeStr, (int)0);
            if (!PropCodes.isValidPropertyCode((int)propCode)) {
                Print.logError((String)("Invalid property code specified: " + propCodeStr + " [" + propCode + "]"), (Object[])new Object[0]);
                PendingPacket.usage();
            }
            byte[] propData = null;
            if (propDataStr != null && !propDataStr.equals("")) {
                Object[] propArgs = PropCodes.parsePropertyValue((int)propCode, (String)propDataStr);
                if (propArgs == null || propArgs.length == 0) {
                    Print.logError((String)"Invalid property value(s) specified", (Object[])new Object[0]);
                    PendingPacket.usage();
                }
                if ((propData = PropCodes.encodePropertyData((int)propCode, (Object[])propArgs)) == null || propData.length == 0) {
                    Print.logError((String)"Unable to encode property data", (Object[])new Object[0]);
                    PendingPacket.usage();
                }
            }
            try {
                int pdLen = propData != null ? propData.length : 0;
                PendingPacket.insertGetPropertyPacket(device, propCode, propData, pdLen);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error while inserting pending packet", (Throwable)dbe);
                System.exit(1);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_SETPROP)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            String setprop = RTConfig.getString((String[])ARG_SETPROP, (String)"");
            p = setprop.indexOf(58);
            propCodeStr = p >= 0 ? setprop.substring(0, p) : "";
            propDataStr = p >= 0 ? setprop.substring(p + 1) : "";
            propCode = StringTools.parseHexInt((String)propCodeStr, (int)0);
            if (!PropCodes.isValidPropertyCode((int)propCode)) {
                Print.logError((String)("Invalid property code specified: " + propCodeStr), (Object[])new Object[0]);
                PendingPacket.usage();
            }
            try {
                Print.sysPrintln((String)("Inserting SetProperty for Code: " + PropCodes.getPropertyDescription((int)propCode)), (Object[])new Object[0]);
                if (!PendingPacket.insertSetPropertyPacket(device, propCode, propDataStr)) {
                    PendingPacket.usage();
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Error while inserting pending packet", (Throwable)dbe);
                System.exit(1);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_GETGPS)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            try {
                PendingPacket.insertGetGpsDiagnostic(device);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error while inserting GPS diagnostic request", (Throwable)dbe);
                System.exit(1);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_UPLOAD)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            String uplFile = RTConfig.getString((String[])ARG_UPLOAD, (String)"");
            if (uplFile.equals("")) {
                Print.logError((String)"Invalid upload file specified", (Object[])new Object[0]);
                PendingPacket.usage();
            }
            try {
                PendingPacket.insertUploadFilePacket(device, uplFile, 0L);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error while inserting upload packet", (Throwable)dbe);
                System.exit(1);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_REBOOT)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            String reboot = RTConfig.getString((String[])ARG_REBOOT, (String)"");
            if (reboot != null && !reboot.equals("")) {
                try {
                    byte[] rebootArg = reboot.getBytes();
                    byte[] propData = new byte[1 + rebootArg.length];
                    propData[0] = 0;
                    System.arraycopy(rebootArg, 0, propData, 1, rebootArg.length);
                    PendingPacket.insertSetPropertyPacket(device, 61695, propData, propData.length);
                }
                catch (DBException dbe) {
                    Print.logException((String)"Error while inserting pending packet", (Throwable)dbe);
                    System.exit(1);
                }
            } else {
                Print.logError((String)"Missing 'reboot' argument", (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_GEOZ)) {
            ++opts;
            String version = RTConfig.getString((String[])ARG_GEOZ, (String)"GEOZONE_1.0");
            Packet[] pkt = PendingPacket.createGeozoneUploadPackets(acctID, version);
            if (pkt != null && pkt.length > 0) {
                for (int i = 0; i < pkt.length; ++i) {
                    Print.sysPrintln((String)(" Upload: " + pkt[i]), (Object[])new Object[0]);
                }
                try {
                    PendingPacket.insertPackets(device, pkt);
                }
                catch (DBException dbe) {
                    Print.logException((String)"Unable to insert pending Geozone-Upload packets", (Throwable)dbe);
                    System.exit(1);
                }
            } else {
                Print.logInfo((String)"No Geozones defined", (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            block55: {
                ++opts;
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                try {
                    PendingPacket[] pp = PendingPacket.getPendingPackets(acctID, devID, -1L);
                    if (!ListTools.isEmpty((Object[])pp)) {
                        for (int i = 0; i < pp.length; ++i) {
                            long qt = pp[i].getQueueTime();
                            int sq = pp[i].getSequence();
                            long sz = pp[i].getPacketBytes().length;
                            Print.sysPrintln((String)(i + ") PendingPacket " + qt + ":" + sq + " (" + sz + " bytes):"), (Object[])new Object[0]);
                            try {
                                Packet[] pkt = PendingPacket.extractPackets(new PendingPacket[]{pp[i]});
                                if (pkt != null && pkt.length > 0) {
                                    for (int p2 = 0; p2 < pkt.length; ++p2) {
                                        Print.sysPrintln((String)("   Packet: " + pkt[p2]), (Object[])new Object[0]);
                                    }
                                }
                            }
                            catch (PacketParseException ppe) {
                                Print.logError((String)("Error parsing packets at QueueTime " + qt), (Object[])new Object[0]);
                            }
                            Print.logInfo((String)"", (Object[])new Object[0]);
                        }
                        break block55;
                    }
                    Print.logInfo((String)"No pending packets for this account/device", (Object[])new Object[0]);
                }
                catch (Throwable th) {
                    Print.logException((String)"Error while getting packets for account/device", (Throwable)th);
                    System.exit(1);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_DELETE)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            long queTime = RTConfig.getLong((String[])ARG_DELETE, (long)-2L);
            if (queTime == -1L || queTime > 0L) {
                try {
                    PendingPacket.deletePendingPackets(acctID, devID, queTime);
                    if (queTime == -1L) {
                        Print.sysPrintln((String)"Deleted all pending packets", (Object[])new Object[0]);
                    } else {
                        Print.sysPrintln((String)("Deleted pending packets up to, and including " + queTime), (Object[])new Object[0]);
                    }
                }
                catch (Throwable th) {
                    Print.logException((String)"Error while deleting packets for account/device", (Throwable)th);
                    System.exit(1);
                }
                System.exit(0);
            } else {
                Print.logError((String)("Invalid time specified: " + RTConfig.getString((String[])ARG_DELETE, (String)"")), (Object[])new Object[0]);
                PendingPacket.usage();
            }
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            PendingPacket.usage();
        }
    }

    public static class SetPropertyPacket {
        private int propCode = 0;
        private byte[] propData = null;

        public SetPropertyPacket(int code, String dataStr) throws PacketParseException {
            this.propCode = code;
            Object[] propArgs = PropCodes.parsePropertyValue((int)code, (String)dataStr);
            if (ListTools.isEmpty((Object[])propArgs)) {
                Print.logError((String)("Invalid property value(s) specified: " + dataStr), (Object[])new Object[0]);
                throw new PacketParseException(61716);
            }
            this.propData = PropCodes.encodePropertyData((int)code, (Object[])propArgs);
            if (ListTools.isEmpty((byte[])this.propData)) {
                Print.logError((String)("Unable to encode property data: " + dataStr), (Object[])new Object[0]);
                throw new PacketParseException(61716);
            }
        }

        public SetPropertyPacket(int code, byte[] data) {
            this.propCode = code;
            this.propData = data;
        }

        public int getCode() {
            return this.propCode;
        }

        public byte[] getData() {
            return this.propData;
        }

        public int getDataLength() {
            return this.propData != null ? this.propData.length : 0;
        }

        public Packet getPacket() {
            return Packet.createServerSetPropertyPacket((int)this.getCode(), (byte[])this.getData(), (int)this.getDataLength());
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<PendingPacket> {
        public Key() {
        }

        public Key(String acctId, String devId, long queueTime, int seq) {
            super.setFieldValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setFieldValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setFieldValue(PendingPacket.FLD_queueTime, queueTime);
            super.setFieldValue(PendingPacket.FLD_sequence, seq);
        }

        public DBFactory<PendingPacket> getFactory() {
            return PendingPacket.getFactory();
        }
    }
}

