/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.dmtp;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.opendmtp.server.db.PayloadTemplate;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtypes.DTTemplate;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class EventTemplate
extends DeviceRecord<EventTemplate> {
    private static Map fieldMap = ListTools.toMap((String)"getCode", (Object[])new FieldType[]{new FieldType(1, "statuscode"), new FieldType(2, "timestamp"), new FieldType(3, "index"), new FieldType(4, "sequence"), new FieldType(6, "gps.point"), new FieldType(7, "gps.age"), new FieldType(8, "speed"), new FieldType(9, "heading"), new FieldType(10, "altitude"), new FieldType(11, "distance"), new FieldType(12, "odometer"), new FieldType(14, "geofence"), new FieldType(15, "speed.top"), new FieldType(16, "brake.gforce"), new FieldType(17, "string"), new FieldType(18, "string.pad"), new FieldType(21, "entity"), new FieldType(22, "entity.pad"), new FieldType(26, "binary"), new FieldType(33, "inputID"), new FieldType(34, "inputState"), new FieldType(36, "output.id"), new FieldType(37, "output.state"), new FieldType(39, "elapsed.time"), new FieldType(40, "counter"), new FieldType(49, "sensor32.low"), new FieldType(50, "sensor32.high"), new FieldType(51, "sensor32.aver"), new FieldType(58, "temperature.low"), new FieldType(59, "temperature.high"), new FieldType(60, "temperature.aver"), new FieldType(65, "gps.dgps.update"), new FieldType(66, "gps.accuracy.horz"), new FieldType(67, "gps.accuracy.vert"), new FieldType(68, "gps.satellites"), new FieldType(69, "gps.magvariation"), new FieldType(70, "gps.quality"), new FieldType(71, "gps.type"), new FieldType(72, "gps.geoid.height"), new FieldType(73, "gps.pdop"), new FieldType(74, "gps.hdop"), new FieldType(75, "gps.vdop"), new FieldType(80, "obc.value"), new FieldType(81, "obc.generic"), new FieldType(82, "obc.j1708fault"), new FieldType(84, "obc.distance"), new FieldType(87, "obc.engine.hours"), new FieldType(88, "obc.engine.rpm"), new FieldType(89, "obc.coolant.temp"), new FieldType(90, "obc.coolant.level"), new FieldType(91, "obc.oil.level"), new FieldType(92, "obc.oil.pressure"), new FieldType(93, "obc.fuel.level"), new FieldType(94, "obc.fuel.economy"), new FieldType(95, "obc.fuel.total"), new FieldType(96, "obc.fuel.idle")});
    public static final String _TABLE_NAME = "EventTemplate";
    public static final String FLD_customType = "customType";
    public static final String FLD_repeatLast = "repeatLast";
    public static final String FLD_template = "template";
    private static DBField[] FieldInfo = new DBField[]{EventTemplate.newField_accountID(true), EventTemplate.newField_deviceID(true), new DBField("customType", Integer.TYPE, "UINT8", "Custom Type", "key=true format=X1"), new DBField("repeatLast", Boolean.TYPE, "BOOLEAN", "Repeat Last", null), new DBField("template", DTTemplate.class, "TEXT", "Template", "editor=eventTemplate")};
    private static DBFactory<EventTemplate> factory = null;
    private static Map<Integer, PayloadTemplate> PayloadTemplateMap = new HashMap<Integer, PayloadTemplate>();
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_LOAD = new String[]{"load"};

    public static FieldType getFieldType(int code) {
        return (FieldType)fieldMap.get(new Integer(code));
    }

    public static String getFieldTypeDescription(int code) {
        FieldType ft = EventTemplate.getFieldType(code);
        return ft != null ? ft.getDescription() : null;
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<EventTemplate> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)EventTemplate.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, EventTemplate.class, Key.class, (boolean)false, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public EventTemplate() {
    }

    public EventTemplate(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(EventTemplate.class, (Locale)loc);
        return i18n.getString("EventTemplate.description", "This table contains DMTP event packet 'template's (Custom Event Packet Negotiation parse templates) which have been received from client devices.");
    }

    public static PayloadTemplate GetPayloadTemplate(String acctId, String devId, int custType) {
        String key;
        String customTemplate;
        DCServerConfig dcs;
        Key tmpKey = new Key(acctId, devId, custType);
        EventTemplate et = (EventTemplate)tmpKey.getDBRecord();
        if (et.reload() != null) {
            return et.createPayloadTemplate();
        }
        Integer custTypeInt = new Integer(custType);
        PayloadTemplate pt = PayloadTemplateMap.get(custTypeInt);
        if (pt == null && (dcs = DCServerFactory.getServerConfig("gtsdmtp")) != null && !StringTools.isBlank((String)(customTemplate = dcs.getStringProperty(key = "gtsdmtp.customEvent." + StringTools.toHexString((long)custType, (int)8), null)))) {
            String[] fldStr = StringTools.split((String)customTemplate, (char)' ');
            pt = new PayloadTemplate(custType, fldStr, true);
            PayloadTemplateMap.put(custTypeInt, pt);
        }
        return pt;
    }

    public static boolean SetPayloadTemplate(String acctId, String devId, PayloadTemplate pt) {
        if (pt != null) {
            Key etKey = new Key(acctId, devId, pt.getPacketType());
            EventTemplate et = (EventTemplate)etKey.getDBRecord();
            et.initFromPayloadTemplate(pt);
            try {
                et.save();
                return true;
            }
            catch (DBException dbe) {
                return false;
            }
        }
        return false;
    }

    public int getCustomType() {
        Integer v = (Integer)this.getFieldValue(FLD_customType);
        return v != null ? v : 0;
    }

    public void setCustomType(int v) {
        this.setFieldValue(FLD_customType, v);
    }

    public boolean getRepeatLast() {
        Boolean v = (Boolean)this.getFieldValue(FLD_repeatLast);
        return v != null ? v : false;
    }

    public void setRepeatLast(boolean v) {
        this.setFieldValue(FLD_repeatLast, v);
    }

    public DTTemplate getTemplate() {
        DTTemplate v = (DTTemplate)((Object)this.getFieldValue(FLD_template));
        return v != null ? v : null;
    }

    public void setTemplate(DTTemplate v) {
        this.setFieldValue(FLD_template, (Object)v);
    }

    public void setTemplate(String v) {
        this.setTemplate(new DTTemplate(v));
    }

    public void initFromPayloadTemplate(PayloadTemplate pt) {
        if (pt != null) {
            this.setFieldValue(FLD_repeatLast, pt.getRepeatLast());
            PayloadTemplate.Field[] flds = pt.getFields();
            DTTemplate template = this.getTemplate();
            if (template == null) {
                template = new DTTemplate();
            }
            template.clearFields();
            for (int i = 0; i < flds.length; ++i) {
                int type = flds[i].getType();
                boolean isHi = flds[i].isHiRes();
                int ndx = flds[i].getIndex();
                int len = flds[i].getLength();
                DTTemplate.Field dtf = new DTTemplate.Field(type, isHi, ndx, len);
                template.setField(i, dtf);
            }
            this.setFieldValue(FLD_template, (Object)template);
        }
    }

    public PayloadTemplate createPayloadTemplate() {
        Vector<PayloadTemplate.Field> pfl = new Vector<PayloadTemplate.Field>();
        DTTemplate t = this.getTemplate();
        if (t != null) {
            DTTemplate.Field tf;
            int i = 0;
            while ((tf = t.getField(i)) != null) {
                int type = tf.getType();
                boolean isHi = tf.isHiRes();
                int ndx = tf.getIndex();
                int len = tf.getLength();
                PayloadTemplate.Field pf = new PayloadTemplate.Field(type, isHi, ndx, len);
                pfl.add(pf);
                ++i;
            }
        }
        PayloadTemplate.Field[] pfa = pfl.toArray(new PayloadTemplate.Field[pfl.size()]);
        return new PayloadTemplate(this.getCustomType(), pfa, this.getRepeatLast());
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + EventTemplate.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>           Acount ID which owns the specified Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>            Device ID to apply event templates", (Object[])new Object[0]);
        Print.logInfo((String)"  -load=<template>        An XML file containing an event template", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (acctID == null || acctID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            EventTemplate.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(acctID);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                EventTemplate.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (devID == null || devID.equals("")) {
            Print.logError((String)"Device-ID not specified.", (Object[])new Object[0]);
            EventTemplate.usage();
        }
        Device device = null;
        try {
            device = Device.getDevice(account, devID, false);
            if (device == null) {
                Print.logError((String)("Device-ID does not exist: " + devID), (Object[])new Object[0]);
                EventTemplate.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Device: " + devID), (Throwable)dbe);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.hasProperty((String[])ARG_LOAD)) {
            RTProperties tp;
            int customType;
            ++opts;
            Print.logInfo((String)"", (Object[])new Object[0]);
            File file = RTConfig.getFile((String[])ARG_LOAD, null);
            if (file == null || !file.exists()) {
                Print.logError((String)("File does not exist: " + file), (Object[])new Object[0]);
                System.exit(99);
            }
            if (((customType = (tp = new RTProperties(file)).getInt("EventTemplate.customType", 0)) & 0xFFFFFF00) != 0) {
                if (customType >> 8 != 224) {
                    Print.logError((String)("Invalid custom packet header: 0x" + StringTools.toHexString((long)customType, (int)16)), (Object[])new Object[0]);
                    System.exit(99);
                }
                customType &= 0xFF;
            }
            if (customType < 112 || customType > 127) {
                Print.logError((String)("Invalid custom packet type: 0x" + StringTools.toHexString((long)customType, (int)8)), (Object[])new Object[0]);
                System.exit(99);
            }
            boolean repeatLast = tp.getBoolean("EventTemplate.repeatLast", true);
            StringBuffer fields = new StringBuffer();
            int length = 0;
            for (int i = 0; i < 99; ++i) {
                DTTemplate.Field f;
                String k = "EventTemplate.template." + i;
                if (!tp.hasProperty((Object)k)) {
                    if (fields.length() != 0) break;
                    Print.logError((String)"No fields defined", (Object[])new Object[0]);
                    System.exit(99);
                }
                if (!(f = new DTTemplate.Field(tp.getString(k, ""))).isValid()) {
                    Print.logError((String)("Field error: " + k + " - " + tp.getString(k, "")), (Object[])new Object[0]);
                    System.exit(99);
                }
                if ((length += f.getLength()) > 255) {
                    Print.logError((String)("Maximum length exceeded: " + length), (Object[])new Object[0]);
                    System.exit(99);
                }
                fields.append(String.valueOf(i)).append("=").append(f.toString()).append(" ");
            }
            try {
                Print.sysPrintln((String)("AccountID  : " + acctID), (Object[])new Object[0]);
                Print.sysPrintln((String)("DeviceID   : " + devID), (Object[])new Object[0]);
                Print.sysPrintln((String)("Packet Type: 0x" + StringTools.toHexString((long)customType, (int)8)), (Object[])new Object[0]);
                Print.sysPrintln((String)("Fields     : " + fields), (Object[])new Object[0]);
                Key key = new Key(acctID, devID, customType);
                EventTemplate evt = (EventTemplate)key.getDBRecord();
                evt.setTemplate(fields.toString());
                evt.save();
            }
            catch (DBException dbe) {
                Print.logError((String)"", (Object[])new Object[0]);
                System.exit(99);
            }
            System.exit(0);
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<EventTemplate> {
        public Key() {
        }

        public Key(String acctId, String devId, int customType) {
            super.setFieldValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setFieldValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setFieldValue(EventTemplate.FLD_customType, customType);
        }

        public DBFactory<EventTemplate> getFactory() {
            return EventTemplate.getFactory();
        }
    }

    public static class FieldType {
        private Integer code = null;
        private String desc = "";

        public FieldType(int code, String desc) {
            this.code = new Integer(code);
            this.desc = desc;
        }

        public Integer getCode() {
            return this.code;
        }

        public int getCodeInt() {
            return this.code;
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

