/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.dmtp;

import java.util.Locale;
import java.util.TimeZone;
import org.opengts.db.DeviceRecord;
import org.opengts.db.dmtp.ClientDiagnostics;
import org.opengts.db.dmtp.ClientErrors;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class Diagnostic
extends DeviceRecord<Diagnostic> {
    public static final String _TABLE_NAME = "Diagnostic";
    public static final String FLD_isError = "isError";
    public static final String FLD_codeKey = "codeKey";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_binaryValue = "binaryValue";
    private static DBField[] FieldInfo = new DBField[]{Diagnostic.newField_accountID(true), Diagnostic.newField_deviceID(true), new DBField("isError", Boolean.TYPE, "BOOLEAN", "Is Error", "key=true"), new DBField("codeKey", Integer.TYPE, "UINT32", "Code Key", "key=true"), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", "key=true"), new DBField("binaryValue", byte[].class, "BLOB", "Binary Value", null)};
    private static DBFactory<Diagnostic> factory = null;

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Diagnostic> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Diagnostic.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Diagnostic.class, Key.class, (boolean)false, (boolean)false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public Diagnostic() {
    }

    public Diagnostic(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Diagnostic.class, (Locale)loc);
        return i18n.getString("Diagnostic.description", "This table contains Device specific diagnostic information collected from client devices.");
    }

    public boolean getIsError() {
        Boolean v = (Boolean)this.getFieldValue(FLD_isError);
        return v != null ? v : false;
    }

    public void setIsError(boolean v) {
        this.setFieldValue(FLD_isError, v);
    }

    public boolean isError() {
        return this.getIsError();
    }

    public int getCodeKey() {
        Integer v = (Integer)this.getFieldValue(FLD_codeKey);
        return v != null ? v : 0;
    }

    public String getCodeKeyHex() {
        return StringTools.toHexString((long)this.getCodeKey(), (int)16);
    }

    public void setCodeKey(int v) {
        this.setFieldValue(FLD_codeKey, v);
    }

    public long getTimestamp() {
        Long v = (Long)this.getFieldValue(FLD_timestamp);
        return v != null ? v : 0L;
    }

    public void setTimestamp(long v) {
        this.setFieldValue(FLD_timestamp, v);
    }

    public byte[] getBinaryValue() {
        byte[] v = (byte[])this.getFieldValue(FLD_binaryValue);
        return v != null ? v : new byte[]{};
    }

    private void setBinaryValue(byte[] v) {
        this.setFieldValue(FLD_binaryValue, v != null ? v : new byte[]{});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAccountID()).append("/").append(this.getDeviceID()).append("/");
        sb.append(this.isError() ? "E:" : "D:");
        sb.append(StringTools.toHexString((long)this.getCodeKey(), (int)16));
        return sb.toString();
    }

    public String getDescription() {
        if (this.isError()) {
            return ClientErrors.getDescription(this.getCodeKey());
        }
        return ClientDiagnostics.getDescription(this.getCodeKey());
    }

    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    public String getValueAsString(TimeZone tz) {
        if (this.isError()) {
            return ClientErrors.getStringValue(this.getCodeKey(), this.getBinaryValue(), tz);
        }
        return ClientDiagnostics.getStringValue(this.getCodeKey(), this.getBinaryValue());
    }

    public static boolean saveDiagnostic(Device device, int codeKey, byte[] codeVal) throws DBException {
        if (device != null) {
            String acctID = device.getAccountID();
            String devID = device.getDeviceID();
            return Diagnostic.saveDiagnostic(acctID, devID, codeKey, codeVal);
        }
        Print.logError((String)"Diagnostic 'Device' is null", (Object[])new Object[0]);
        return false;
    }

    public static boolean saveDiagnostic(String acctID, String devID, int codeKey, byte[] codeVal) throws DBException {
        if (acctID == null || acctID.equals("") || devID == null || devID.equals("")) {
            Print.logError((String)"Diagnostic 'AccountID'/'DeviceID' is null", (Object[])new Object[0]);
            return false;
        }
        if (codeKey <= 0 || codeVal == null) {
            Print.logError((String)"Diagnostic code/data is null", (Object[])new Object[0]);
            return false;
        }
        Key key = new Key(acctID, devID, false, codeKey, DateTime.getCurrentTimeSec());
        Diagnostic diag = new Diagnostic(key);
        diag.setBinaryValue(codeVal);
        diag.save();
        Print.logInfo((String)"Saved Diagnostic code", (Object[])new Object[0]);
        return true;
    }

    public static boolean saveError(Device device, int codeKey, byte[] codeVal) throws DBException {
        if (device != null) {
            String acctID = device.getAccountID();
            String devID = device.getDeviceID();
            return Diagnostic.saveError(acctID, devID, codeKey, codeVal);
        }
        Print.logError((String)"Error 'Device' is null", (Object[])new Object[0]);
        return false;
    }

    public static boolean saveError(String acctID, String devID, int codeKey, byte[] codeVal) throws DBException {
        if (acctID == null || acctID.equals("") || devID == null || devID.equals("")) {
            Print.logError((String)"Error 'AccountID'/'DeviceID' is null", (Object[])new Object[0]);
            return false;
        }
        if (codeKey <= 0 || codeVal == null) {
            Print.logError((String)"Error code/data is null", (Object[])new Object[0]);
            return false;
        }
        Key key = new Key(acctID, devID, true, codeKey, DateTime.getCurrentTimeSec());
        Diagnostic diag = new Diagnostic(key);
        diag.setBinaryValue(codeVal);
        diag.save();
        Print.logInfo((String)"Saved Error code", (Object[])new Object[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Diagnostic[] getDiagnostics(String acctId, String devId, long timeStart, long timeEnd) throws DBException {
        if (acctId == null || acctId.equals("")) {
            return null;
        }
        if (devId == null || devId.equals("")) {
            return null;
        }
        DBSelect dsel = new DBSelect(Diagnostic.getFactory());
        DBWhere dwh = dsel.createDBWhere();
        dwh.append(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("deviceID", (Object)devId)));
        if (timeStart >= 0L) {
            dwh.append(dwh.AND_(dwh.GE(FLD_timestamp, timeStart)));
        }
        if (timeEnd >= 0L && timeEnd >= timeStart) {
            dwh.append(dwh.AND_(dwh.LE(FLD_timestamp, timeEnd)));
        }
        dsel.setWhere(dwh.WHERE(dwh.toString()));
        dsel.setOrderByFields(new String[]{FLD_isError, FLD_codeKey});
        dsel.setLimit(-1L);
        Diagnostic[] d = null;
        try {
            DBProvider.lockTables((String[])new String[]{Diagnostic.TABLE_NAME()}, null);
            d = (Diagnostic[])DBRecord.select((DBSelect)dsel);
        }
        finally {
            DBProvider.unlockTables();
        }
        if (d == null) {
            return null;
        }
        return d;
    }

    public static class Key
    extends DeviceRecord.DeviceKey<Diagnostic> {
        public Key() {
        }

        public Key(String acctId, String devId, boolean isError, int codeKey, long timestamp) {
            super.setFieldValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setFieldValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setFieldValue(Diagnostic.FLD_isError, isError);
            super.setFieldValue(Diagnostic.FLD_codeKey, codeKey);
            super.setFieldValue(Diagnostic.FLD_timestamp, timestamp);
        }

        public DBFactory<Diagnostic> getFactory() {
            return Diagnostic.getFactory();
        }
    }
}

