/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.dmtp;

import java.util.TimeZone;
import org.opengts.util.DateTime;
import org.opengts.util.Payload;
import org.opengts.util.StringTools;

public class ClientErrors
implements org.opendmtp.codes.ClientErrors {
    public static String getDescription(int errCode) {
        return ClientErrors.getStringValue(errCode, true, null, null);
    }

    public static String getStringValue(int errCode, byte[] errData) {
        return ClientErrors.getStringValue(errCode, false, errData, null);
    }

    public static String getStringValue(int errCode, byte[] errData, TimeZone tz) {
        return ClientErrors.getStringValue(errCode, false, errData, tz);
    }

    public static String getStringValue(int errCode, boolean inclDesc, byte[] errData) {
        return ClientErrors.getStringValue(errCode, inclDesc, errData, null);
    }

    public static String getStringValue(int errCode, boolean inclDesc, byte[] errData, TimeZone tz) {
        Payload payload = errData != null && errData.length > 0 ? new Payload(errData) : null;
        StringBuffer sb = new StringBuffer();
        switch (errCode) {
            case 61713: {
                if (inclDesc) {
                    sb.append("Invalid packet header");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String h = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    String t = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    sb.append("0x" + h + t);
                }
                return sb.toString();
            }
            case 61714: {
                if (inclDesc) {
                    sb.append("Invalid packet type");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String h = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    String t = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    sb.append("0x" + h + t);
                }
                return sb.toString();
            }
            case 61715: {
                if (inclDesc) {
                    sb.append("Invalid packet length");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String h = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    String t = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    sb.append("0x" + h + t);
                }
                return sb.toString();
            }
            case 61716: {
                if (inclDesc) {
                    sb.append("Unsupported packet encoding");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String h = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    String t = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    sb.append("0x" + h + t);
                }
                return sb.toString();
            }
            case 61717: {
                if (inclDesc) {
                    sb.append("Invalid packet payload");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String h = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    String t = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    sb.append("0x" + h + t);
                }
                return sb.toString();
            }
            case 61718: {
                if (inclDesc) {
                    sb.append("Invalid checksum");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String h = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    String t = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    sb.append("0x" + h + t);
                }
                return sb.toString();
            }
            case 61719: {
                if (inclDesc) {
                    sb.append("Invalid ACL sequence");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String h = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    String t = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    sb.append("0x" + h + t);
                }
                return sb.toString();
            }
            case 61729: {
                if (inclDesc) {
                    sb.append("Protocol error");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String h = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    String t = StringTools.toHexString((long)payload.readLong(1, 0L), (int)8);
                    sb.append("0x" + h + t);
                }
                return sb.toString();
            }
            case 61953: {
                if (inclDesc) {
                    sb.append("Property is read-only");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String p = StringTools.toHexString((long)payload.readLong(2, 0L), (int)16);
                    sb.append("0x" + p);
                }
                return sb.toString();
            }
            case 61954: {
                if (inclDesc) {
                    sb.append("Property is write-only");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String p = StringTools.toHexString((long)payload.readLong(2, 0L), (int)16);
                    sb.append("0x" + p);
                }
                return sb.toString();
            }
            case 61969: {
                if (inclDesc) {
                    sb.append("Invalid/Unrecognized property key");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String p = StringTools.toHexString((long)payload.readLong(2, 0L), (int)16);
                    sb.append("0x" + p);
                }
                return sb.toString();
            }
            case 61970: {
                if (inclDesc) {
                    sb.append("Invalid property value");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String p = StringTools.toHexString((long)payload.readLong(2, 0L), (int)16);
                    sb.append("0x" + p);
                }
                return sb.toString();
            }
            case 61971: {
                if (inclDesc) {
                    sb.append("Unknown property error");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String p = StringTools.toHexString((long)payload.readLong(2, 0L), (int)16);
                    sb.append("0x" + p);
                }
                return sb.toString();
            }
            case 62225: {
                if (inclDesc) {
                    sb.append("Invalid/Unsupported command");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String c = StringTools.toHexString((long)payload.readLong(2, 0L), (int)16);
                    sb.append("0x" + c);
                }
                return sb.toString();
            }
            case 62241: {
                if (inclDesc) {
                    sb.append("Command error");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    String c = StringTools.toHexString((long)payload.readLong(2, 0L), (int)16);
                    String e = StringTools.toHexString((long)payload.readLong(2, 0L), (int)16);
                    sb.append("cmd=0x" + c + ", err=0x" + e);
                    int dlen = payload.getAvailableReadLength();
                    if (dlen > 0) {
                        String d = StringTools.toHexString((byte[])payload.readBytes(dlen));
                        sb.append(", data=0x" + d);
                    }
                }
                return sb.toString();
            }
            case 62465: {
                if (inclDesc) {
                    sb.append("Invalid upload type");
                }
                return sb.toString();
            }
            case 62469: {
                if (inclDesc) {
                    sb.append("Invalid upload packet");
                }
                return sb.toString();
            }
            case 62481: {
                if (inclDesc) {
                    sb.append("Invalid upload length");
                }
                return sb.toString();
            }
            case 62482: {
                if (inclDesc) {
                    sb.append("Upload offset overlap");
                }
                return sb.toString();
            }
            case 62483: {
                if (inclDesc) {
                    sb.append("Upload offset gap");
                }
                return sb.toString();
            }
            case 62484: {
                if (inclDesc) {
                    sb.append("Upload offset overflow");
                }
                return sb.toString();
            }
            case 62497: {
                if (inclDesc) {
                    sb.append("Invalid uploaded filename");
                }
                return sb.toString();
            }
            case 62513: {
                if (inclDesc) {
                    sb.append("Invalid uploaded checksum");
                }
                return sb.toString();
            }
            case 62529: {
                if (inclDesc) {
                    sb.append("Unable to save uploaded file");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    int dlen = payload.getAvailableReadLength();
                    String d = StringTools.toHexString((byte[])payload.readBytes(dlen));
                    sb.append("0x" + d);
                }
                return sb.toString();
            }
            case 62545: {
                if (inclDesc) {
                    sb.append("Invalid/unspecified upload host:port");
                }
                return sb.toString();
            }
            case 62561: {
                if (inclDesc) {
                    sb.append("Server indicated upload error");
                }
                return sb.toString();
            }
            case 63761: {
                if (inclDesc) {
                    sb.append("GPS Expired");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    long lastFix = payload.readLong(4, 0L);
                    sb.append("lastFix=");
                    if (lastFix <= 0L) {
                        sb.append("never");
                    } else if (tz != null) {
                        DateTime dt = new DateTime(lastFix, tz);
                        sb.append(dt.format("yyyy/MM/dd,HH:mm:ss"));
                    } else {
                        sb.append(lastFix);
                    }
                }
                return sb.toString();
            }
            case 63762: {
                if (inclDesc) {
                    sb.append("GPS Failure");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    long lastFix = payload.readLong(4, 0L);
                    sb.append("lastFix=");
                    if (lastFix <= 0L) {
                        sb.append("never");
                    } else if (tz != null) {
                        DateTime dt = new DateTime(lastFix, tz);
                        sb.append(dt.format("yyyy/MM/dd,HH:mm:ss"));
                    } else {
                        sb.append(lastFix);
                    }
                    int dlen = payload.getAvailableReadLength();
                    if (dlen > 0) {
                        String d = StringTools.toHexString((byte[])payload.readBytes(dlen));
                        sb.append(" data=0x" + d);
                    }
                }
                return sb.toString();
            }
            case 65024: {
                if (inclDesc) {
                    sb.append("Out-Of-Memory error");
                }
                return sb.toString();
            }
        }
        if (errCode >= 65248 && errCode <= 65263) {
            if (inclDesc) {
                sb.append("Internal error");
                if (payload != null) {
                    sb.append(": ");
                }
            }
            if (payload != null) {
                int dlen = payload.getAvailableReadLength();
                String d = StringTools.toHexString((byte[])payload.readBytes(dlen));
                sb.append("0x" + d);
            }
            return sb.toString();
        }
        if (inclDesc) {
            sb.append("Unknown[0x").append(StringTools.toHexString((long)errCode, (int)16)).append("]");
            if (payload != null) {
                sb.append(": ");
            }
        }
        if (payload != null) {
            int dlen = payload.getAvailableReadLength();
            String d = StringTools.toHexString((byte[])payload.readBytes(dlen));
            sb.append("0x" + d);
        }
        return sb.toString();
    }

    private ClientErrors() {
    }
}

