/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db.dmtp;

import java.util.TimeZone;
import org.opengts.util.Payload;
import org.opengts.util.StringTools;

public class ClientDiagnostics
implements org.opendmtp.codes.ClientDiagnostics {
    public static String getDescription(int diagCode) {
        return ClientDiagnostics.getStringValue(diagCode, true, null, null);
    }

    public static String getStringValue(int diagCode, byte[] diagData) {
        return ClientDiagnostics.getStringValue(diagCode, false, diagData, null);
    }

    public static String getStringValue(int diagCode, byte[] diagData, TimeZone tz) {
        return ClientDiagnostics.getStringValue(diagCode, false, diagData, tz);
    }

    public static String getStringValue(int diagCode, boolean inclDesc, byte[] diagData) {
        return ClientDiagnostics.getStringValue(diagCode, inclDesc, diagData, null);
    }

    public static String getStringValue(int diagCode, boolean inclDesc, byte[] diagData, TimeZone tz) {
        Payload payload = diagData != null && diagData.length > 0 ? new Payload(diagData) : null;
        StringBuffer sb = new StringBuffer();
        switch (diagCode) {
            case 61441: {
                if (inclDesc) {
                    sb.append("Upload Acknowledgement");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    sb.append("0x");
                    sb.append(StringTools.toHexString((long)payload.readLong(1, 0L), (int)8));
                }
                return sb.toString();
            }
            case 64529: {
                if (inclDesc) {
                    sb.append("J1708 Value");
                    if (payload != null) {
                        sb.append(": ");
                    }
                }
                if (payload != null) {
                    sb.append("mid=").append(payload.readLong(2, 0L)).append(", ");
                    sb.append("pid=").append(payload.readLong(2, 0L)).append(", ");
                    sb.append("val=0x");
                    sb.append(StringTools.toHexString((byte[])payload.readBytes(payload.getAvailableReadLength())));
                }
                return sb.toString();
            }
        }
        if (diagCode >= 57344 && diagCode <= 65535) {
            if (inclDesc) {
                sb.append("Internal diagnostic");
                if (payload != null) {
                    sb.append(": ");
                }
            }
            if (payload != null) {
                int dlen = payload.getAvailableReadLength();
                sb.append("0x").append(StringTools.toHexString((byte[])payload.readBytes(dlen)));
            }
            return sb.toString();
        }
        if (inclDesc) {
            sb.append("Unknown[0x").append(StringTools.toHexString((long)diagCode, (int)16)).append("]");
            if (payload != null) {
                sb.append(": ");
            }
        }
        if (payload != null) {
            int dlen = payload.getAvailableReadLength();
            sb.append("0x").append(StringTools.toHexString((byte[])payload.readBytes(dlen)));
        }
        return sb.toString();
    }

    private ClientDiagnostics() {
    }
}

