/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.util.TimeZone;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class WorkHours {
    public static final int DAYS_IN_WEEK = 7;
    public static final String DFT = "dft";
    public static final String SUN = "sun";
    public static final String MON = "mon";
    public static final String TUE = "tue";
    public static final String WED = "wed";
    public static final String THU = "thu";
    public static final String FRI = "fri";
    public static final String SAT = "sat";
    public static final String[] DOW_NAME = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    public static final String PROP_WorkHours_minuteInterval = "WorkHours.minuteInterval";
    public static final String PROP_WorkHours_includeHourMinuteSeparator = "WorkHours.includeHourMinuteSeparator";
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int DEFAULT_MINUTE_INTERVAL = 15;
    private static int MINUTE_INTERVAL = -1;
    public static final char TIMERANGE_SEPARATOR_CHAR = '-';
    public static final char HOUR_MINUTE_SEPARATOR_CHAR = ':';
    private static boolean INCLUDE_HOUR_MIN_SEPARATOR = false;
    private Day[] dowDay = new Day[7];
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_RTP = new String[]{"rtp"};
    private static final String[] ARG_TIME = new String[]{"time"};
    private static final String[] ARG_MODTEST = new String[]{"modtest"};
    private static final String[] ARG_DAYTEST = new String[]{"daytest"};
    private static final String[] ARG_START_TIME = new String[]{"startTime", "beginTime", "st"};
    private static final String[] ARG_STOP_TIME = new String[]{"stopTime", "endTime", "et"};

    private static int GetMinuteInterval() {
        if (MINUTE_INTERVAL <= 0) {
            int mi = RTConfig.getInt((String)PROP_WorkHours_minuteInterval, (int)15);
            MINUTE_INTERVAL = WorkHours.CalculateBestMinuteInterval(mi);
        }
        return MINUTE_INTERVAL;
    }

    private static int CalculateBestMinuteInterval(int interval) {
        if (interval <= 0) {
            return 15;
        }
        if (interval >= 60) {
            return 60;
        }
        if (60 % interval != 0) {
            while (60 % --interval != 0) {
            }
            return interval;
        }
        return interval;
    }

    private static int convertHourMinuteToTOD(String hhmm, boolean endTime) {
        String MM;
        String HH;
        if (StringTools.isBlank((String)hhmm)) {
            return endTime ? 1440 : 0;
        }
        if (StringTools.isInt((String)hhmm, (boolean)true)) {
            int L = hhmm.length();
            if (L >= 4) {
                HH = hhmm.substring(0, 2);
                MM = hhmm.substring(2, 4);
            } else if (L == 3) {
                HH = hhmm.substring(0, 2);
                MM = hhmm.substring(2, 3);
            } else {
                HH = hhmm;
                MM = "";
            }
        } else {
            int p = hhmm.indexOf(58);
            HH = p >= 0 ? hhmm.substring(0, p) : hhmm;
            MM = p >= 0 ? hhmm.substring(p + 1) : "";
        }
        int hh = StringTools.parseInt((String)HH, (int)(endTime ? 24 : 0));
        if (hh < 0) {
            hh = 0;
        } else if (hh > 24) {
            hh = 24;
        }
        int mm = StringTools.parseInt((String)MM, (int)0);
        if (mm < 0) {
            mm = 0;
        } else if (mm > 59) {
            mm = 59;
        }
        int tod = hh * 60 + mm;
        if (tod <= 0) {
            return endTime ? 1440 : 0;
        }
        if (tod >= 1440) {
            return endTime ? 1440 : 0;
        }
        return tod;
    }

    public static String formatTOD(int tod, boolean inclSep) {
        return WorkHours.formatTOD(tod, inclSep, new StringBuffer()).toString();
    }

    private static StringBuffer formatTOD(int tod, boolean inclSep, StringBuffer sb) {
        if (tod >= 0) {
            int H = tod / 60;
            int M = tod % 60;
            sb.append(StringTools.format((int)H, (String)"00"));
            if (inclSep) {
                sb.append(':');
            }
            sb.append(StringTools.format((int)M, (String)"00"));
        }
        return sb;
    }

    public WorkHours(Day[] day) {
        Day last = !ListTools.isEmpty((Object[])day) ? day[day.length - 1] : null;
        int dlen = !ListTools.isEmpty((Object[])day) ? day.length : 0;
        for (int i = 0; i < 7; ++i) {
            this.dowDay[i] = new Day(i < dlen ? day[i] : last);
        }
    }

    public WorkHours(RTConfig.PropertyGetter dayRTP) {
        this(dayRTP, null);
    }

    public WorkHours(RTConfig.PropertyGetter dayRTP, String keyPrefix) {
        keyPrefix = StringTools.trim((String)keyPrefix);
        if (dayRTP == null) {
            dayRTP = RTConfig.getPropertyGetter();
        }
        String dftTR = StringTools.trim((Object)dayRTP.getProperty((Object)(keyPrefix + DFT), (Object)""));
        for (int i = 0; i < 7; ++i) {
            String dowKey = keyPrefix + DOW_NAME[i];
            String TR = StringTools.trim((Object)dayRTP.getProperty((Object)dowKey, (Object)dftTR));
            if (!StringTools.isBlank((String)TR)) {
                int p = TR.indexOf(45);
                String frTm = p >= 0 ? TR.substring(0, p) : TR;
                String toTm = p >= 0 ? TR.substring(p + 1) : "";
                int frTod = WorkHours.convertHourMinuteToTOD(frTm, false);
                int toTod = WorkHours.convertHourMinuteToTOD(toTm, true);
                this.dowDay[i] = new Day(frTod, toTod);
                continue;
            }
            this.dowDay[i] = new Day();
        }
    }

    @Deprecated
    public WorkHours(String keyPrefix) {
        this(RTConfig.getPropertyGetter(), keyPrefix);
    }

    public Day getDay(int dow) {
        if (dow < 0 || dow >= 7) {
            return null;
        }
        return this.dowDay[dow];
    }

    public Day getDay(DateTime dateTime) {
        return this.getDay(dateTime, null);
    }

    public Day getDay(DateTime dateTime, TimeZone tz) {
        if (dateTime == null) {
            return null;
        }
        int dow = dateTime.getDayOfWeek(tz);
        return this.getDay(dow);
    }

    public Day getDay(long timestamp, TimeZone tz) {
        if (timestamp <= 0L) {
            return null;
        }
        int dow = new DateTime(timestamp, tz).getDayOfWeek(tz);
        return this.getDay(dow);
    }

    public boolean isMatch(DateTime dateTime) {
        return this.isMatch(dateTime, null);
    }

    public boolean isMatch(DateTime dateTime, TimeZone tz) {
        if (dateTime != null) {
            int dow = dateTime.getDayOfWeek(tz);
            Day day = this.dowDay[dow];
            int tod = dateTime.getHour24(tz) * 60 + dateTime.getMinute(tz);
            return day.isMatch(tod);
        }
        return false;
    }

    public boolean isMatch(long timestamp, TimeZone tz) {
        if (timestamp > 0L) {
            return this.isMatch(new DateTime(timestamp, tz), tz);
        }
        return false;
    }

    public boolean isMatch(int dow, int tod) {
        if (dow >= 0 && dow < this.dowDay.length) {
            Day day = this.dowDay[dow];
            return day.isMatch(tod);
        }
        return false;
    }

    public double countWorkHours(DateTime startDT, DateTime stopDT, TimeZone tz) {
        Day day;
        if (startDT == null) {
            Print.logWarn((String)"Start date is null", (Object[])new Object[0]);
            return 0.0;
        }
        if (stopDT == null) {
            Print.logWarn((String)"Stop date is null", (Object[])new Object[0]);
            return 0.0;
        }
        if (startDT.isAfter(stopDT, true)) {
            Print.logWarn((String)"Start date is after stop date", (Object[])new Object[0]);
            Print.logInfo((String)("Start date: " + startDT), (Object[])new Object[0]);
            Print.logInfo((String)("Stop  date: " + stopDT), (Object[])new Object[0]);
            return 0.0;
        }
        if (tz == null) {
            tz = startDT.getTimeZone();
        }
        long startSec = startDT.getTimeSec();
        long startDS = startDT.getDayStart(tz);
        long startDE = startDT.getDayEnd(tz);
        int startMOD = startDT.getSecondOfDay(tz) / 60;
        int startDOW = startDT.getDayOfWeek(tz);
        Day startDay = this.getDay(startDOW);
        long stopSec = stopDT.getTimeSec();
        long stopDS = stopDT.getDayStart(tz);
        long stopDE = stopDT.getDayEnd(tz);
        int stopMOD = (stopDT.getSecondOfDay(tz) + 59) / 60;
        if (startDE >= stopSec) {
            return (double)startDay.countWorkMinutes(startMOD, stopMOD) / 60.0;
        }
        long accumMin = 0L;
        long timeSec = startDS + DateTime.DaySeconds((long)1L);
        while (true) {
            day = this.getDay(timeSec, tz);
            long DE = timeSec + DateTime.DaySeconds((long)1L) - 1L;
            if (DE >= stopSec) break;
            accumMin += (long)day.countWorkMinutes(0, 1440);
            timeSec += DateTime.DaySeconds((long)1L);
        }
        return (double)(accumMin += (long)day.countWorkMinutes(0, stopMOD)) / 60.0;
    }

    public RTProperties getProperties() {
        RTProperties rtp = new RTProperties();
        for (int i = 0; i < 7; ++i) {
            String dow = i < 7 ? DOW_NAME[i] : "x";
            String tmr = this.dowDay[i].getTimeRange();
            rtp.setString(dow, tmr);
        }
        return rtp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("0   1   2   3   4   5   6   7   8   9   10  11  12  13  14  15  16  17  18  19  20  21  22  23  \n");
        sb.append("---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+\n");
        for (int i = 0; i < 7; ++i) {
            sb.append(this.dowDay[i].toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        DateTime dt;
        RTConfig.setCommandLineArgs((String[])argv);
        WorkHours wh = new WorkHours(RTConfig.getPropertyGetter(), "rule.workHours.");
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            Print.sysPrintln((String)wh.toString(), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_RTP)) {
            Print.sysPrintln((String)wh.getProperties().toString(), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_MODTEST)) {
            for (int i = 0; i <= 60; ++i) {
                Print.sysPrintln((String)(i + " ==> " + WorkHours.CalculateBestMinuteInterval(i)), (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_DAYTEST)) {
            TimeZone pstTZ = DateTime.getTimeZone((String)"US/Pacific");
            dt = new DateTime(pstTZ);
            int dow = RTConfig.getInt((String[])ARG_DAYTEST, (int)dt.getDayOfWeek());
            int lastMatch = -1;
            Print.sysPrintln((String)("DayOfWeek: " + DateTime.getDayName((int)dow, (int)0)), (Object[])new Object[0]);
            for (int todMin = 0; todMin <= 1441; ++todMin) {
                boolean match = wh.isMatch(dow, todMin);
                if (lastMatch >= 0 && lastMatch == 1 == match) continue;
                Print.sysPrintln((String)(" " + WorkHours.formatTOD(todMin, true) + " ==> " + match), (Object[])new Object[0]);
                lastMatch = match ? 1 : 0;
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_TIME)) {
            String time = RTConfig.getString((String[])ARG_TIME, (String)"");
            try {
                dt = !StringTools.isBlank((String)time) ? DateTime.parseArgumentDate((String)RTConfig.getString((String[])ARG_TIME, (String)""), null, (boolean)false) : new DateTime();
                Print.sysPrintln((String)("Time     : " + dt.toString()), (Object[])new Object[0]);
                Print.sysPrintln((String)("IsMatch  : " + wh.isMatch(dt)), (Object[])new Object[0]);
                Print.sysPrintln((String)"WorkHours:", (Object[])new Object[0]);
                Print.sysPrintln((String)wh.toString(), (Object[])new Object[0]);
            }
            catch (DateTime.DateParseException dpe) {
                Print.sysPrintln((String)("Error: Unable to parse time - " + time), (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_START_TIME)) {
            try {
                DateTime startDT = DateTime.parseArgumentDate((String)RTConfig.getString((String[])ARG_START_TIME, (String)""), null, (boolean)false);
                DateTime stopDT = DateTime.parseArgumentDate((String)RTConfig.getString((String[])ARG_STOP_TIME, (String)""), null, (boolean)false);
                double hrs = wh.countWorkHours(startDT, stopDT, null);
                Print.sysPrintln((String)("Start Date/Time  : " + startDT), (Object[])new Object[0]);
                Print.sysPrintln((String)("Stop Date/Time   : " + stopDT), (Object[])new Object[0]);
                Print.sysPrintln((String)("Counted WorkHours: " + hrs), (Object[])new Object[0]);
                System.exit(0);
            }
            catch (DateTime.DateParseException dpe) {
                Print.logException((String)"Invalid Date format", (Throwable)dpe);
                System.exit(99);
            }
        }
    }

    static /* synthetic */ int access$000() {
        return WorkHours.GetMinuteInterval();
    }

    public static class Day {
        private int minuteInterval = WorkHours.access$000();
        private byte[] todSeg = new byte[1440 / this.minuteInterval];

        public Day() {
            for (int i = 0; i < this.todSeg.length; ++i) {
                this.todSeg[i] = 0;
            }
        }

        public Day(int todStartMin, int todEndMin) {
            this();
            if (todStartMin == todEndMin) {
                for (int i = 0; i < this.todSeg.length; ++i) {
                    this.todSeg[i] = 1;
                }
            } else if (todEndMin >= todStartMin) {
                int i;
                int tsNdx = this.getIntervalIndex(todStartMin);
                int teNdx = this.getIntervalIndex(todEndMin - 1);
                for (i = 0; i < tsNdx; ++i) {
                    this.todSeg[i] = 0;
                }
                for (i = tsNdx; i <= teNdx; ++i) {
                    this.todSeg[i] = 1;
                }
                for (i = teNdx + 1; i < this.todSeg.length; ++i) {
                    this.todSeg[i] = 0;
                }
            } else {
                int i;
                int tsNdx = this.getIntervalIndex(todStartMin);
                int teNdx = this.getIntervalIndex(todEndMin - 1);
                for (i = 0; i <= teNdx; ++i) {
                    this.todSeg[i] = 1;
                }
                for (i = teNdx + 1; i < tsNdx; ++i) {
                    this.todSeg[i] = 0;
                }
                for (i = tsNdx; i < this.todSeg.length; ++i) {
                    this.todSeg[i] = 1;
                }
            }
        }

        public Day(Day day) {
            this();
            if (day != null) {
                System.arraycopy(day.todSeg, 0, this.todSeg, 0, this.todSeg.length);
            }
        }

        private int getMinuteInterval() {
            return this.minuteInterval;
        }

        private int getIntervalIndex(int todMin) {
            int ndx = todMin / this.getMinuteInterval();
            if (ndx < 0) {
                return 0;
            }
            if (ndx >= this.todSeg.length) {
                return this.todSeg.length - 1;
            }
            return ndx;
        }

        public boolean isMatch(int todMin) {
            int todNdx = this.getIntervalIndex(todMin);
            return this.todSeg[todNdx] != 0;
        }

        public int getNextMatch(int todMin, boolean working) {
            int todNdx;
            for (int i = todNdx = this.getIntervalIndex(todMin); i < this.todSeg.length; ++i) {
                boolean match;
                boolean bl = match = this.todSeg[todNdx] != 0;
                if (working != match) continue;
                int newTodNdx = i * this.getMinuteInterval();
                return newTodNdx > todNdx ? newTodNdx : todNdx;
            }
            return -1;
        }

        public int countWorkMinutes(int todStartMin, int todEndMin) {
            int startNdx;
            if (todStartMin < 0) {
                todStartMin = 0;
            }
            if (todEndMin > 1440) {
                todEndMin = 1440;
            }
            if (todEndMin < todStartMin) {
                return 0;
            }
            int accumMin = 0;
            for (int N = startNdx = this.getIntervalIndex(todStartMin); N < this.todSeg.length; ++N) {
                if (this.todSeg[N] == 0) continue;
                int todS = N * this.getMinuteInterval();
                int todE = todS + this.getMinuteInterval();
                if (todE > 1440) {
                    todE = 1440;
                }
                if (todS < todStartMin) {
                    todS = todStartMin;
                }
                if (todE >= todEndMin) {
                    accumMin += todEndMin - todS;
                    break;
                }
                accumMin += todE - todS;
            }
            return accumMin;
        }

        public String getTimeRange() {
            boolean inclHourMinSep = RTConfig.getBoolean((String)WorkHours.PROP_WorkHours_includeHourMinuteSeparator, (boolean)INCLUDE_HOUR_MIN_SEPARATOR);
            int i = 0;
            if (this.todSeg[i] == 0 || this.todSeg[this.todSeg.length - 1] == 0) {
                int startTOD = -1;
                while (i < this.todSeg.length) {
                    if (this.todSeg[i] != 0) {
                        startTOD = i * this.getMinuteInterval();
                        break;
                    }
                    ++i;
                }
                int endTOD = -1;
                while (i < this.todSeg.length) {
                    if (this.todSeg[i] == 0) {
                        endTOD = i * this.getMinuteInterval();
                        break;
                    }
                    ++i;
                }
                if (startTOD < 0) {
                    return "";
                }
                StringBuffer sb = new StringBuffer();
                WorkHours.formatTOD(startTOD, inclHourMinSep, sb);
                sb.append('-');
                if (endTOD >= startTOD) {
                    WorkHours.formatTOD(endTOD, inclHourMinSep, sb);
                } else {
                    WorkHours.formatTOD(1440, inclHourMinSep, sb);
                }
                return sb.toString();
            }
            int endTOD = -1;
            while (i < this.todSeg.length) {
                if (this.todSeg[i] == 0) {
                    endTOD = i * this.getMinuteInterval();
                    break;
                }
                ++i;
            }
            int startTOD = -1;
            while (i < this.todSeg.length) {
                if (this.todSeg[i] != 0) {
                    startTOD = i * this.getMinuteInterval();
                    break;
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            if (endTOD < 0) {
                WorkHours.formatTOD(0, inclHourMinSep, sb);
                sb.append('-');
                WorkHours.formatTOD(1440, inclHourMinSep, sb);
            } else {
                if (startTOD >= 0) {
                    WorkHours.formatTOD(startTOD, inclHourMinSep, sb);
                } else {
                    WorkHours.formatTOD(0, inclHourMinSep, sb);
                }
                sb.append('-');
                WorkHours.formatTOD(endTOD, inclHourMinSep, sb);
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.todSeg.length; ++i) {
                sb.append(this.todSeg[i] != 0 ? "1" : "-");
            }
            return sb.toString();
        }
    }
}

