/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import org.opengts.db.AccountRecord;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.Print;

public class UserRecord<RT extends DBRecord>
extends AccountRecord<RT> {
    public static final String FLD_userID = "userID";
    private User user = null;
    private String userDesc = null;

    protected static DBField newField_userID(boolean key) {
        return new DBField(FLD_userID, String.class, DBField.TYPE_USER_ID(), "User ID", key ? "key=true" : "edit=2");
    }

    public UserRecord() {
    }

    public UserRecord(UserKey<RT> key) {
        super(key);
    }

    public String getUserID() {
        String v = (String)this.getKeyValue(FLD_userID);
        return v != null ? v : "";
    }

    private void setUserID(String v) {
        this.setKeyValue(FLD_userID, v != null ? v : "");
    }

    public final User getUser() {
        if (this.user == null) {
            String userID = this.getUserID();
            Print.logDebug((String)("[Optimize] Retrieving User record: " + userID), (Object[])new Object[0]);
            try {
                this.user = User.getUser(this.getAccount(), userID);
            }
            catch (DBException dbe) {
                Print.logError((String)("User not found: " + this.getAccountID() + "/" + userID), (Object[])new Object[0]);
                this.user = null;
            }
        }
        return this.user;
    }

    public final void setUser(User user) {
        if (user != null && user.getAccountID().equals(this.getAccountID()) && user.getUserID().equals(this.getUserID())) {
            this.setAccount(user.getAccount());
            this.user = user;
        } else {
            this.user = null;
        }
    }

    public final String getUserDescription() {
        if (this.userDesc == null) {
            User user = this.getUser();
            this.userDesc = user != null ? user.getDescription() : this.getUserID();
        }
        return this.userDesc;
    }

    public static abstract class UserKey<RT extends DBRecord>
    extends AccountRecord.AccountKey<RT> {
    }
}

