/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TimeZone;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class TrackStick {
    private static boolean DEBUG_MODE = true;
    private static boolean PrintAllEvents = false;
    private static final String COMMENT_TIMEZONE = "TimeZone";
    private static final String COMMENT_STATUSCODE = "StatusCode";
    public static final String PROP_defaultTimeZone = "trackStick.defaultTimeZone";
    public static final String PROP_minimumSpeedKPH = "trackStick.minimumSpeedKPH";
    public static final String PROP_minimumHeadingChange = "trackStick.minimumHeadingChange";
    public static final String PROP_minimumDormantSeconds = "trackStick.minimumDormantSeconds";
    public static final String PROP_minimumMovingSeconds = "trackStick.minimumMovingSeconds";
    public static final String PROP_estimateOdometer = "trackStick.estimateOdometer";
    public static final String PROP_addIgnitionState = "trackStick.addIgnitionState";
    public static final String PROP_preClearEvents = "trackStick.preClearEvents";
    public static final String PROP_reverseGeocode = "trackStick.reverseGeocode";
    private static String DFT_TIMEZONE = "GMT";
    private static double MIN_SPEEDKPH = 0.0;
    private static double MIN_HEADING_CHANGE = 15.0;
    private static long MIN_DORMANT_SEC = DateTime.MinuteSeconds((long)30L);
    private static long MIN_MOVING_SEC = DateTime.MinuteSeconds((long)2L);
    private static boolean ESTIMATE_ODOMETER = true;
    private static boolean ADD_IGNITION_STATE = false;
    private static long MIN_IGNITION_STOP_TIME = DateTime.MinuteSeconds((long)6L);
    private static boolean PRE_CLEAR_EVENTS = false;
    private static boolean PRE_CLEAR_ONLY = false;
    private static boolean REVERSE_GEOCODE = false;
    private Account account = null;
    private Device device = null;
    private TimeZone displayTimeZone = null;
    private int eventTotalCount = 0;
    private String dftTimeZone = DFT_TIMEZONE;
    private double minSpeedKPH = MIN_SPEEDKPH;
    private double minHeadingChange = MIN_HEADING_CHANGE;
    private long minDormantSec = MIN_DORMANT_SEC;
    private long minMovingSec = MIN_MOVING_SEC;
    private boolean estimateOdometer = ESTIMATE_ODOMETER;
    private boolean addIgnitionState = ADD_IGNITION_STATE;
    private boolean preClearEvents = PRE_CLEAR_EVENTS;
    private boolean reverseGeocode = REVERSE_GEOCODE;
    private static final int STATE_UNDEFINED = 0;
    private static final int STATE_STOPPED = 1;
    private static final int STATE_MOVING = 2;
    private static String[] ARG_HELP = new String[]{"help", "h"};
    private static String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    private static String[] ARG_DEVICE = new String[]{"device", "dev", "d"};
    private static String[] ARG_CSV_FILE = new String[]{"csvFile", "csv"};
    private static String[] ARG_CSV_TMZ = new String[]{"timezone", "tmz", "cvsTmz", "tz"};
    private static String[] ARG_DISP_TMZ = new String[]{"dispTmz"};
    private static String[] ARG_SAVEODOM = new String[]{"saveOdom", "estOdom"};
    private static String[] ARG_IGNITION = new String[]{"addIgn", "ign"};
    private static String[] ARG_SHOWALL = new String[]{"printAll", "showAll"};
    private static String[] ARG_NOSAVE = new String[]{"nosave"};
    private static String[] ARG_PRECLEAR = new String[]{"preClear", "clear", "preClearOnly"};
    private static String[] ARG_PRECLEAR_ONLY = new String[]{"preClearOnly"};
    private static String[] ARG_REVGEO = new String[]{"revgeo"};

    private static double temp_C2F(double C) {
        return C * 9.0 / 5.0 + 32.0;
    }

    private static double temp_F2C(double F) {
        return (F - 32.0) * 5.0 / 9.0;
    }

    public TrackStick(Account acct, Device dev) {
        this.device = dev;
        this.account = acct != null ? acct : (dev != null ? dev.getAccount() : null);
        this.dftTimeZone = RTConfig.getString((String)PROP_defaultTimeZone, (String)DFT_TIMEZONE);
        this.minSpeedKPH = RTConfig.getDouble((String)PROP_minimumSpeedKPH, (double)MIN_SPEEDKPH);
        this.minHeadingChange = RTConfig.getDouble((String)PROP_minimumHeadingChange, (double)MIN_HEADING_CHANGE);
        this.minDormantSec = RTConfig.getLong((String)PROP_minimumDormantSeconds, (long)MIN_DORMANT_SEC);
        this.minMovingSec = RTConfig.getLong((String)PROP_minimumMovingSeconds, (long)MIN_MOVING_SEC);
        this.estimateOdometer = RTConfig.getBoolean((String)PROP_estimateOdometer, (boolean)ESTIMATE_ODOMETER);
        this.addIgnitionState = RTConfig.getBoolean((String)PROP_addIgnitionState, (boolean)ADD_IGNITION_STATE);
        this.preClearEvents = RTConfig.getBoolean((String)PROP_preClearEvents, (boolean)PRE_CLEAR_EVENTS);
        this.reverseGeocode = RTConfig.getBoolean((String)PROP_reverseGeocode, (boolean)REVERSE_GEOCODE);
    }

    public Account getAccount() {
        return this.account;
    }

    public String getAccountID() {
        return this.account != null ? this.account.getAccountID() : "";
    }

    public Device getDevice() {
        return this.device;
    }

    public String getDeviceID() {
        return this.device != null ? this.device.getDeviceID() : "";
    }

    public void setDisplayTimeZone(TimeZone dispTmz) {
        this.displayTimeZone = dispTmz;
    }

    private TimeZone getDefaultTimeZone() {
        TimeZone tmz = Account.getTimeZone(this.account, null);
        if (tmz == null && (tmz = DateTime.getTimeZone((String)this.dftTimeZone, null)) == null) {
            tmz = DateTime.getGMTTimeZone();
        }
        return tmz;
    }

    public void printHeader() {
        Print.logInfo((String)"---------------------------------------------", (Object[])new Object[0]);
        Print.logInfo((String)("Account           : " + this.getAccountID()), (Object[])new Object[0]);
        Print.logInfo((String)("Device            : " + this.getDeviceID()), (Object[])new Object[0]);
        Print.logInfo((String)("Debug Mode        : " + DEBUG_MODE), (Object[])new Object[0]);
        Print.logInfo((String)("Default Timezone  : " + this.dftTimeZone), (Object[])new Object[0]);
        Print.logInfo((String)("Pre-Clear Events  : " + this.preClearEvents), (Object[])new Object[0]);
        Print.logInfo((String)("Min Speed Km/H    : " + this.minSpeedKPH), (Object[])new Object[0]);
        Print.logInfo((String)("Min Heading Chg   : " + this.minHeadingChange), (Object[])new Object[0]);
        Print.logInfo((String)("Min Moving Sec    : " + this.minMovingSec), (Object[])new Object[0]);
        Print.logInfo((String)("Min Dormant Sec   : " + this.minDormantSec), (Object[])new Object[0]);
        Print.logInfo((String)("Estimate Odometer : " + this.estimateOdometer), (Object[])new Object[0]);
        Print.logInfo((String)("Add Ignition State: " + this.addIgnitionState), (Object[])new Object[0]);
        Print.logInfo((String)("Reverse-Geocoding : " + Device.GetAllowSlowReverseGeocoding()), (Object[])new Object[0]);
        Print.logInfo((String)"---------------------------------------------", (Object[])new Object[0]);
        Print.logInfo((String)"", (Object[])new Object[0]);
    }

    private static long parseDateTime(String date, String time, TimeZone tmz) {
        String[] t;
        int p;
        if (StringTools.isBlank((String)time) && (p = date.indexOf(":")) >= 2) {
            time = date.substring(p - 2).trim();
            date = date.substring(0, p - 2).trim();
        }
        int YEAR = 0;
        int MON1 = 0;
        int DAY = 0;
        int HOUR = 0;
        int MIN = 0;
        int SEC = 0;
        if (!StringTools.isBlank((String)date)) {
            String[] d;
            if (date.indexOf("/") >= 0) {
                d = StringTools.split((String)date, (char)'/');
                if (d.length >= 3) {
                    YEAR = StringTools.parseInt((String)d[2], (int)0);
                    if (YEAR < 100) {
                        YEAR += 2000;
                    }
                    MON1 = StringTools.parseInt((String)d[0], (int)0);
                    DAY = StringTools.parseInt((String)d[1], (int)0);
                }
            } else if (date.indexOf("-") >= 0) {
                d = StringTools.split((String)date, (char)'-');
                if (d.length >= 3) {
                    YEAR = StringTools.parseInt((String)d[2], (int)0);
                    if (YEAR < 100) {
                        YEAR += 2000;
                    }
                    MON1 = DateTime.getMonthIndex1((String)d[1], (int)0);
                    DAY = StringTools.parseInt((String)d[0], (int)0);
                }
            } else if (date.indexOf(" ") >= 0 && (d = StringTools.split((String)date, (char)',')).length >= 3) {
                int m;
                YEAR = StringTools.parseInt((String)d[2], (int)0);
                if (YEAR < 100) {
                    YEAR += 2000;
                }
                String mmStr = (m = d[1].indexOf(" ")) >= 0 ? d[1].substring(0, m).trim() : "";
                String ddStr = m >= 0 ? d[1].substring(m + 1).trim() : "";
                MON1 = DateTime.getMonthIndex1((String)mmStr, (int)0);
                DAY = StringTools.parseInt((String)ddStr, (int)0);
            }
        }
        if (YEAR > 2000 && !StringTools.isBlank((String)time) && (t = StringTools.split((String)time, (char)':')).length >= 3) {
            HOUR = StringTools.parseInt((String)t[0], (int)0);
            MIN = StringTools.parseInt((String)t[1], (int)0);
            SEC = StringTools.parseInt((String)t[2], (int)0);
            String apm = t[2].toLowerCase();
            if (apm.endsWith("am")) {
                if (HOUR == 12) {
                    HOUR = 0;
                }
            } else if (apm.endsWith("pm") && HOUR < 12) {
                HOUR += 12;
            }
        }
        DateTime dt = new DateTime(tmz, YEAR, MON1, DAY, HOUR, MIN, SEC);
        long timestamp = dt.getTimeSec();
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseFile(File csvFile, TimeZone csvTMZ) throws IOException {
        if (this.device == null) {
            Print.logError((String)"No Device specified", (Object[])new Object[0]);
            return false;
        }
        if (csvFile == null) {
            Print.logError((String)"CSV File not specified", (Object[])new Object[0]);
            System.exit(99);
        } else if (!csvFile.isFile()) {
            Print.logError((String)("CSV File does not exist - " + csvFile), (Object[])new Object[0]);
            System.exit(99);
        }
        boolean ok = false;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(csvFile);
            ok = this.parseStream(fis, csvTMZ);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseStream(InputStream csvStream, TimeZone csvTMZ) throws IOException {
        if (this.device == null) {
            Print.logError((String)"No Device specified", (Object[])new Object[0]);
            return false;
        }
        String accountID = this.device.getAccountID();
        String deviceID = this.device.getDeviceID();
        double startOdomKM = this.device.getLastOdometerKM();
        BasicPrivateLabel privLabel = Account.getPrivateLabel(this.getAccount());
        if (csvStream == null) {
            Print.logError((String)"No CSV stream specified", (Object[])new Object[0]);
            return false;
        }
        if (csvTMZ == null) {
            csvTMZ = this.getDefaultTimeZone();
        }
        String[] header = null;
        int lineCount = 0;
        int totalCount = 0;
        int saveCount = 0;
        long lastKeepTime = 0L;
        double lastKeepHeading = 0.0;
        int lastStatusCode = 0;
        int lastMotionState = 0;
        GeoPoint lastValidPoint = null;
        double lastOdometerKM = startOdomKM;
        boolean checkedReload = false;
        boolean isReload = false;
        boolean isIgnitionOn = false;
        long stoppedTimeSec = 0L;
        boolean isFirstEvent = true;
        int extStatusCode = 0;
        long timeOffsetSec = 0L;
        int r = 0;
        while (true) {
            String line = null;
            try {
                line = FileTools.readLine((InputStream)csvStream);
                if (line == null) {
                }
            }
            catch (EOFException eof) {}
            break;
            ++lineCount;
            if (!StringTools.isBlank((String)line)) {
                if ((line = line.trim()).startsWith("#")) {
                    Object[] cFld = StringTools.split((String)line.substring(1).trim(), (char)',');
                    if (ListTools.size((Object[])cFld) > 0) {
                        if (((String)cFld[0]).equalsIgnoreCase(COMMENT_TIMEZONE)) {
                            if (cFld.length >= 2) {
                                TimeZone tz = DateTime.getTimeZone((String)((String)cFld[1]).toUpperCase(), null);
                                if (tz != null) {
                                    csvTMZ = tz;
                                }
                                if (cFld.length >= 3) {
                                    int HH = StringTools.parseInt((String)cFld[2], (int)0);
                                    timeOffsetSec = DateTime.HourSeconds((long)HH);
                                }
                            }
                        } else if (((String)cFld[0]).equalsIgnoreCase(COMMENT_STATUSCODE) && cFld.length >= 2) {
                            extStatusCode = StatusCodes.ParseCode((String)cFld[1], privLabel, 0);
                        }
                    }
                } else {
                    String[] fld = StringTools.split((String)line, (char)',');
                    if (fld.length < 10) {
                        Print.logError((String)("[" + lineCount + "] " + line), (Object[])new Object[0]);
                        Print.logError((String)("Invalid number of data fields: " + fld.length), (Object[])new Object[0]);
                    } else if (header == null && fld[0].equalsIgnoreCase("Record")) {
                        header = fld;
                        for (int h = 0; h < header.length; ++h) {
                            header[h] = header[h].toLowerCase();
                        }
                    } else {
                        String date = null;
                        String time = null;
                        long timestamp = 0L;
                        double latitude = 0.0;
                        double longitude = 0.0;
                        double altitudeM = 0.0;
                        double tempC = 0.0;
                        double speedKPH = 0.0;
                        double headingDeg = 0.0;
                        int statusCode = 61472;
                        boolean validGPS = false;
                        int satCount = 0;
                        double odomKM = 0.0;
                        int motionState = lastMotionState;
                        boolean saveEvent = false;
                        String saveReason = "";
                        for (int i = 0; i < header.length; ++i) {
                            if (i >= fld.length) continue;
                            String H = header[i];
                            String F = fld[i].toLowerCase();
                            if (H.equalsIgnoreCase("Record")) continue;
                            if (H.equalsIgnoreCase("Date")) {
                                date = F;
                                continue;
                            }
                            if (H.equalsIgnoreCase("Time")) {
                                time = F;
                                continue;
                            }
                            if (H.equalsIgnoreCase("Latitude")) {
                                latitude = GeoPoint.parseLatitude((String)F, (double)0.0);
                                continue;
                            }
                            if (H.equalsIgnoreCase("Longitude")) {
                                longitude = GeoPoint.parseLongitude((String)F, (double)0.0);
                                continue;
                            }
                            if (H.equalsIgnoreCase("Altitude")) {
                                altitudeM = StringTools.parseDouble((String)F, (double)0.0);
                                continue;
                            }
                            if (H.equalsIgnoreCase("Temp")) {
                                tempC = StringTools.parseDouble((String)F, (double)0.0);
                                continue;
                            }
                            if (H.equalsIgnoreCase("Status")) {
                                if (F.equalsIgnoreCase("Power On")) {
                                    statusCode = 64793;
                                    motionState = 0;
                                    saveEvent = true;
                                    saveReason = "Power On Event";
                                    continue;
                                }
                                if (F.equalsIgnoreCase("Power Off")) {
                                    if (motionState == 2) {
                                        // empty if block
                                    }
                                    statusCode = 64791;
                                    motionState = 0;
                                    saveEvent = true;
                                    saveReason = "Power Off Event";
                                    continue;
                                }
                                if (StringTools.startsWithIgnoreCase((String)F, (String)"Stopped")) {
                                    if (motionState != 1) {
                                        statusCode = 61715;
                                        motionState = 1;
                                        saveEvent = true;
                                        saveReason = "Stopped Event";
                                    } else {
                                        statusCode = 61716;
                                    }
                                    String stopTimeStr = F.substring("Stopped".length()).trim();
                                    if (lastStatusCode == 64793) {
                                        stoppedTimeSec = 0L;
                                        continue;
                                    }
                                    long stopTime = StringTools.parseLong((String)stopTimeStr, (long)0L);
                                    if (StringTools.endsWithIgnoreCase((String)stopTimeStr, (String)"min")) {
                                        stoppedTimeSec = stopTime * 60L;
                                        continue;
                                    }
                                    if (StringTools.endsWithIgnoreCase((String)stopTimeStr, (String)"sec")) {
                                        stoppedTimeSec = stopTime;
                                        continue;
                                    }
                                    Print.logWarn((String)("Unable to determine amount of stopped time: " + F), (Object[])new Object[0]);
                                    stoppedTimeSec = 0L;
                                    continue;
                                }
                                if (StringTools.endsWithIgnoreCase((String)F, (String)"kph")) {
                                    speedKPH = StringTools.parseDouble((String)F, (double)0.0);
                                    if (motionState != 2) {
                                        statusCode = 61713;
                                        motionState = 2;
                                        saveEvent = true;
                                        saveReason = "Start Event (kph)";
                                        continue;
                                    }
                                    statusCode = 61714;
                                    continue;
                                }
                                if (StringTools.endsWithIgnoreCase((String)F, (String)"mph")) {
                                    speedKPH = StringTools.parseDouble((String)F, (double)0.0) * 1.609344;
                                    if (motionState != 2) {
                                        statusCode = 61713;
                                        motionState = 2;
                                        saveEvent = true;
                                        saveReason = "Start Event (mph)";
                                        continue;
                                    }
                                    statusCode = 61714;
                                    continue;
                                }
                                if (StringTools.endsWithIgnoreCase((String)F, (String)"kts")) {
                                    speedKPH = StringTools.parseDouble((String)F, (double)0.0) * 1.852;
                                    if (motionState != 2) {
                                        statusCode = 61713;
                                        motionState = 2;
                                        saveEvent = true;
                                        saveReason = "Start Event (kts)";
                                        continue;
                                    }
                                    statusCode = 61714;
                                    continue;
                                }
                                statusCode = 61472;
                                continue;
                            }
                            if (H.equalsIgnoreCase("Course")) {
                                if (F.equalsIgnoreCase("N")) {
                                    headingDeg = 0.0;
                                    continue;
                                }
                                if (F.equalsIgnoreCase("NE")) {
                                    headingDeg = 45.0;
                                    continue;
                                }
                                if (F.equalsIgnoreCase("E")) {
                                    headingDeg = 90.0;
                                    continue;
                                }
                                if (F.equalsIgnoreCase("SE")) {
                                    headingDeg = 135.0;
                                    continue;
                                }
                                if (F.equalsIgnoreCase("S")) {
                                    headingDeg = 180.0;
                                    continue;
                                }
                                if (F.equalsIgnoreCase("SW")) {
                                    headingDeg = 225.0;
                                    continue;
                                }
                                if (F.equalsIgnoreCase("W")) {
                                    headingDeg = 270.0;
                                    continue;
                                }
                                if (F.equalsIgnoreCase("NW")) {
                                    headingDeg = 315.0;
                                    continue;
                                }
                                headingDeg = StringTools.parseDouble((String)F, (double)0.0);
                                continue;
                            }
                            if (H.equalsIgnoreCase("GPS Fix")) {
                                validGPS = F.equalsIgnoreCase("Y");
                                continue;
                            }
                            if (H.equalsIgnoreCase("Signal")) {
                                satCount = StringTools.parseInt((String)F, (int)0);
                                continue;
                            }
                            if (!H.equalsIgnoreCase("MapLink") && !H.equalsIgnoreCase("Name") && !H.equalsIgnoreCase("DeviceName")) continue;
                        }
                        timestamp = TrackStick.parseDateTime(date, time, csvTMZ) + timeOffsetSec;
                        if (timestamp <= 0L) {
                            Print.logError((String)("[" + lineCount + "] " + line), (Object[])new Object[0]);
                            Print.logError((String)("Skipping record with invalid timestamp: " + timestamp), (Object[])new Object[0]);
                        } else {
                            if (isFirstEvent) {
                                try {
                                    EventData prevEv = EventData.getPreviousEventData(accountID, deviceID, timestamp, null, true);
                                    if (prevEv != null) {
                                        lastOdometerKM = prevEv.getOdometerKM();
                                        this.device.setLastOdometerKM(prevEv.getOdometerKM());
                                        this.device.setLastValidLatitude(prevEv.getLatitude());
                                        this.device.setLastValidLongitude(prevEv.getLongitude());
                                        this.device.setLastValidHeading(prevEv.getHeading());
                                        this.device.setLastGPSTimestamp(prevEv.getTimestamp());
                                    }
                                }
                                catch (DBException dbe) {
                                    Print.logException((String)("Unable obtain previous event: " + accountID + "/" + deviceID), (Throwable)dbe);
                                }
                                if (!DEBUG_MODE && this.preClearEvents) {
                                    Print.logInfo((String)"Pre-Clearing Events ...", (Object[])new Object[0]);
                                    try {
                                        long delCount = EventData.deleteEventsAfterTimestamp(accountID, deviceID, timestamp, true);
                                        if (delCount > 0L) {
                                            isReload = true;
                                            Print.logWarn((String)("Found/Deleted " + delCount + " existing events from '" + new DateTime(timestamp) + "' [" + timestamp + "]"), (Object[])new Object[0]);
                                        }
                                        if (PRE_CLEAR_ONLY) {
                                            Print.logInfo((String)"Exiting due to 'PreClearOnly' ...", (Object[])new Object[0]);
                                            System.exit(0);
                                        }
                                    }
                                    catch (DBException dbe) {
                                        Print.logException((String)("Unable delete existing events: " + accountID + "/" + deviceID), (Throwable)dbe);
                                    }
                                }
                                isFirstEvent = false;
                            }
                            GeoPoint geoPoint = null;
                            if (validGPS && GeoPoint.isValid((double)latitude, (double)longitude)) {
                                geoPoint = new GeoPoint(latitude, longitude);
                            } else if (lastValidPoint != null && statusCode == 64791) {
                                validGPS = true;
                                geoPoint = lastValidPoint;
                                latitude = lastValidPoint.getLatitude();
                                longitude = lastValidPoint.getLongitude();
                            } else {
                                validGPS = false;
                                geoPoint = GeoPoint.INVALID_GEOPOINT;
                                latitude = 0.0;
                                longitude = 0.0;
                            }
                            if (speedKPH < this.minSpeedKPH) {
                                speedKPH = 0.0;
                                headingDeg = 0.0;
                            }
                            odomKM = lastOdometerKM;
                            if (validGPS && lastValidPoint != null) {
                                double deltaKM = lastValidPoint.kilometersToPoint(geoPoint);
                                odomKM += deltaKM;
                            }
                            ++totalCount;
                            long deltaKeepTimeSec = timestamp - lastKeepTime;
                            double deltaKeepHeading = Math.abs(headingDeg - lastKeepHeading);
                            if (deltaKeepHeading > 180.0) {
                                deltaKeepHeading = 360.0 - deltaKeepHeading;
                            }
                            boolean keepEvent = false;
                            String keepReason = "";
                            if (saveEvent) {
                                keepEvent = true;
                                keepReason = saveReason;
                            } else if (lastMotionState != motionState) {
                                keepEvent = true;
                                keepReason = "Moving state change Event";
                            } else if (motionState == 1 && deltaKeepTimeSec >= this.minDormantSec) {
                                keepEvent = true;
                                keepReason = "Periodic Dormant Event";
                            } else if (motionState == 2 && deltaKeepTimeSec >= this.minMovingSec) {
                                keepEvent = true;
                                keepReason = "Periodic Moving Event";
                            } else if (motionState == 2 && deltaKeepHeading > this.minHeadingChange) {
                                keepEvent = true;
                                keepReason = "Heading Change Event";
                            } else {
                                keepEvent = false;
                            }
                            if (keepEvent) {
                                if (!checkedReload) {
                                    EventData ed = null;
                                    try {
                                        ed = EventData.getEventData(accountID, deviceID, timestamp, statusCode);
                                        if (ed != null) {
                                            isReload = true;
                                            Print.logWarn((String)("Possible CSV 'reload' detected!!! : " + ed), (Object[])new Object[0]);
                                            Print.logWarn((String)"(Using previous event odometer starting value)", (Object[])new Object[0]);
                                            odomKM = ed.getOdometerKM();
                                        }
                                    }
                                    catch (DBException dbe) {
                                        Print.logError((String)("Unable to read EventData record: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                                    }
                                    checkedReload = true;
                                }
                                ++saveCount;
                            }
                            if (PrintAllEvents || keepEvent) {
                                TimeZone dtz = this.displayTimeZone != null ? this.displayTimeZone : csvTMZ;
                                Print.logInfo((String)"---------------------------------------------", (Object[])new Object[0]);
                                Print.logInfo((String)("Include Event: " + (keepEvent ? "true" : "false") + " - " + keepReason), (Object[])new Object[0]);
                                Print.logInfo((String)("Count        : " + totalCount + (keepEvent ? " (" + saveCount + ")" : "")), (Object[])new Object[0]);
                                Print.logInfo((String)("Timestamp    : [" + timestamp + "] " + new DateTime(timestamp, dtz)), (Object[])new Object[0]);
                                Print.logInfo((String)("Status       : " + StatusCodes.GetDescription(statusCode, null)), (Object[])new Object[0]);
                                Print.logInfo((String)("GeoPoint     : " + geoPoint), (Object[])new Object[0]);
                                Print.logInfo((String)("Altitude     : " + StringTools.format((double)altitudeM, (String)"0.0") + " meters" + " (" + StringTools.format((double)(altitudeM * 3.280839895013123), (String)"0.0") + " feet)"), (Object[])new Object[0]);
                                Print.logInfo((String)("Speed        : " + StringTools.format((double)speedKPH, (String)"0.0") + " km/h" + " (" + StringTools.format((double)(speedKPH * 0.621371192237334), (String)"0.0") + " mph)" + " heading " + headingDeg + " (" + GeoPoint.GetHeadingDescription((double)headingDeg, null) + ")"), (Object[])new Object[0]);
                                Print.logInfo((String)("Temp         : " + StringTools.format((double)tempC, (String)"0.0") + " C" + " (" + StringTools.format((double)TrackStick.temp_C2F(tempC), (String)"0.0") + " F)"), (Object[])new Object[0]);
                                Print.logInfo((String)("Odometer     : " + StringTools.format((double)odomKM, (String)"0.0") + " km" + " (" + StringTools.format((double)(odomKM * 0.621371192237334), (String)"0.0") + " miles) " + ""), (Object[])new Object[0]);
                            }
                            lastStatusCode = statusCode;
                            lastMotionState = motionState;
                            if (validGPS) {
                                lastValidPoint = geoPoint;
                            }
                            lastOdometerKM = odomKM;
                            if (keepEvent) {
                                int sc;
                                lastKeepTime = timestamp;
                                lastKeepHeading = headingDeg;
                                if (this.addIgnitionState && !isIgnitionOn && statusCode == 61713) {
                                    long ts = timestamp - 1L;
                                    sc = 62465;
                                    this.insertEventRecord(this.device, ts, sc, null, geoPoint, 0L, 0.0, satCount, speedKPH, headingDeg, altitudeM, odomKM, tempC);
                                    isIgnitionOn = true;
                                }
                                if (statusCode != 0 && statusCode != -1) {
                                    this.insertEventRecord(this.device, timestamp, statusCode, null, geoPoint, 0L, 0.0, satCount, speedKPH, headingDeg, altitudeM, odomKM, tempC);
                                }
                                if (extStatusCode != 0 && extStatusCode != -1 && extStatusCode != statusCode) {
                                    this.insertEventRecord(this.device, timestamp, extStatusCode, null, geoPoint, 0L, 0.0, satCount, speedKPH, headingDeg, altitudeM, odomKM, tempC);
                                }
                                if (this.addIgnitionState && isIgnitionOn && statusCode == 61715 && (stoppedTimeSec <= 0L || stoppedTimeSec > MIN_IGNITION_STOP_TIME)) {
                                    long ts = timestamp + 1L;
                                    sc = 62467;
                                    this.insertEventRecord(this.device, ts, sc, null, geoPoint, 0L, 0.0, satCount, speedKPH, headingDeg, altitudeM, odomKM, tempC);
                                    isIgnitionOn = false;
                                }
                            }
                        }
                    }
                }
            }
            ++r;
        }
        if (!DEBUG_MODE && this.device != null) {
            try {
                this.device.updateChangedEventFields();
            }
            catch (DBException dbe) {
                Print.logException((String)("Unable to update Device: " + accountID + "/" + deviceID), (Throwable)dbe);
            }
        }
        Print.logInfo((String)"---------------------------------------------", (Object[])new Object[0]);
        Print.logInfo((String)"", (Object[])new Object[0]);
        Print.logInfo((String)"Event Counts:", (Object[])new Object[0]);
        Print.logInfo((String)("  Total    = " + totalCount), (Object[])new Object[0]);
        Print.logInfo((String)("  Omitted  = " + (totalCount - saveCount)), (Object[])new Object[0]);
        Print.logInfo((String)("  Included = " + saveCount), (Object[])new Object[0]);
        Print.logInfo((String)("  Stored   = " + this.eventTotalCount), (Object[])new Object[0]);
        Print.logInfo((String)"", (Object[])new Object[0]);
        return saveCount > 0;
    }

    private EventData createEventRecord(Device device, long timestamp, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitude, double odomKM, double tempC) {
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        EventData.Key evKey = new EventData.Key(accountID, deviceID, timestamp, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeozone(geozone);
        evdb.setGeoPoint(geoPoint);
        evdb.setGpsAge(gpsAge);
        evdb.setHDOP(HDOP);
        evdb.setSatelliteCount(numSats);
        evdb.setSpeedKPH(speedKPH);
        evdb.setHeading(heading);
        evdb.setAltitude(altitude);
        evdb.setOdometerKM(odomKM);
        evdb.setThermoAverage0(tempC);
        return evdb;
    }

    private void insertEventRecord(Device device, long timestamp, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitude, double odomKM, double tempC) {
        if (device == null) {
            return;
        }
        if (DEBUG_MODE) {
            Print.logInfo((String)("Non-stored Event : [0x" + StringTools.toHexString((long)statusCode, (int)16) + "] " + StatusCodes.GetDescription(statusCode, null)), (Object[])new Object[0]);
            return;
        }
        if (!this.estimateOdometer) {
            odomKM = 0.0;
        }
        EventData evdb = this.createEventRecord(device, timestamp, statusCode, geozone, geoPoint, gpsAge, HDOP, numSats, speedKPH, heading, altitude, odomKM, tempC);
        device.insertEventData(evdb);
        ++this.eventTotalCount;
        Print.logInfo((String)("Stored Event : [0x" + StringTools.toHexString((long)statusCode, (int)16) + "] " + StatusCodes.GetDescription(statusCode, null)), (Object[])new Object[0]);
    }

    private static void usage(int exit) {
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + TrackStick.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>    Acount ID which owns Device", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -device=<id>     Device ID to which parsed events will be inserted", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -tmz=<timeZone>  The TimeZone of the times represented in the CSV file", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -csv=<file>      The CSV file to parse", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -estOdom         Include GPS-based estimated odometer in events", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -noSave          Do not save events, nor update Device record", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -preClear        Delete any existing events after the starting timestamp", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -help            Display this help", (Object[])new Object[0]);
        Print.sysPrintln((String)"Notes:", (Object[])new Object[0]);
        Print.sysPrintln((String)" * Input file must be in CSV format from a TrackStick device", (Object[])new Object[0]);
        Print.sysPrintln((String)" * The first CSV record must be the column header information", (Object[])new Object[0]);
        Print.sysPrintln((String)" * Altitude is expected to be in meters", (Object[])new Object[0]);
        Print.sysPrintln((String)" * Temperature is expected to be in Celsius", (Object[])new Object[0]);
        Print.sysPrintln((String)" * Loading a CSV file more than once may skew the estimated odometer value", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        System.exit(exit);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        if (RTConfig.getBoolean((String[])ARG_HELP, (boolean)false)) {
            TrackStick.usage(0);
            System.exit(0);
        }
        DEBUG_MODE = RTConfig.isDebugMode() || RTConfig.getBoolean((String[])ARG_NOSAVE, (boolean)false);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, null);
        String deviceID = RTConfig.getString((String[])ARG_DEVICE, null);
        File csvFile = RTConfig.getFile((String[])ARG_CSV_FILE, null);
        String tmzStr = RTConfig.getString((String[])ARG_CSV_TMZ, null);
        String dispTmzStr = RTConfig.getString((String[])ARG_DISP_TMZ, (String)tmzStr);
        PrintAllEvents = RTConfig.getBoolean((String[])ARG_SHOWALL, (boolean)false);
        if (RTConfig.hasProperty((String[])ARG_SAVEODOM)) {
            boolean saveOdom = RTConfig.getBoolean((String[])ARG_SAVEODOM, (boolean)false);
            RTConfig.setBoolean((String)PROP_estimateOdometer, (boolean)saveOdom);
        }
        if (RTConfig.hasProperty((String[])ARG_IGNITION)) {
            boolean addIgn = RTConfig.getBoolean((String[])ARG_IGNITION, (boolean)false);
            RTConfig.setBoolean((String)PROP_addIgnitionState, (boolean)addIgn);
        }
        if (RTConfig.hasProperty((String[])ARG_PRECLEAR)) {
            boolean preClear = RTConfig.getBoolean((String[])ARG_PRECLEAR, (boolean)false);
            RTConfig.setBoolean((String)PROP_preClearEvents, (boolean)preClear);
            if (RTConfig.getBoolean((String[])ARG_PRECLEAR_ONLY, (boolean)false)) {
                PRE_CLEAR_ONLY = true;
            }
        }
        if (RTConfig.hasProperty((String[])ARG_REVGEO)) {
            boolean revGeo = RTConfig.getBoolean((String[])ARG_REVGEO, (boolean)false);
            RTConfig.setBoolean((String)PROP_reverseGeocode, (boolean)revGeo);
        }
        Account account = null;
        Device device = null;
        try {
            account = Account.getAccount(accountID);
            if (account == null) {
                Print.logError((String)("Account not found: " + accountID), (Object[])new Object[0]);
                TrackStick.usage(99);
                System.exit(99);
            }
            if ((device = Device.getDevice(account, deviceID)) == null) {
                Print.logError((String)("Device not found: " + deviceID), (Object[])new Object[0]);
                TrackStick.usage(99);
                System.exit(99);
            }
        }
        catch (DBException dbe) {
            Print.sysPrintln((String)"Unable to load Account/Device", (Object[])new Object[0]);
            Print.sysPrintln((String)("AccountID : " + accountID), (Object[])new Object[0]);
            Print.sysPrintln((String)("DeviceID  : " + deviceID), (Object[])new Object[0]);
            Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
            dbe.printStackTrace();
            Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
            System.exit(99);
        }
        TimeZone csvTmz = null;
        if (!StringTools.isBlank((String)tmzStr) && (csvTmz = DateTime.getTimeZone((String)tmzStr, null)) == null) {
            Print.sysPrintln((String)("Invalid CSV TimeZone: " + tmzStr), (Object[])new Object[0]);
            TrackStick.usage(99);
            System.exit(99);
        }
        TimeZone dspTmz = null;
        if (!StringTools.isBlank((String)dispTmzStr) && (dspTmz = DateTime.getTimeZone((String)dispTmzStr, null)) == null) {
            Print.sysPrintln((String)("Invalid Display TimeZone: " + tmzStr), (Object[])new Object[0]);
            TrackStick.usage(99);
            System.exit(99);
        }
        if (csvFile == null) {
            Print.sysPrintln((String)"ERROR: CSV File not specified", (Object[])new Object[0]);
            TrackStick.usage(99);
            System.exit(99);
        } else if (!csvFile.isFile()) {
            Print.sysPrintln((String)("ERROR: CSV File does not exist - " + csvFile), (Object[])new Object[0]);
            TrackStick.usage(99);
            System.exit(99);
        }
        Device.SetAllowSlowReverseGeocoding(RTConfig.getBoolean((String[])ARG_REVGEO, (boolean)REVERSE_GEOCODE));
        try {
            TrackStick ts = new TrackStick(account, device);
            ts.printHeader();
            ts.setDisplayTimeZone(dspTmz);
            ts.parseFile(csvFile, csvTmz);
        }
        catch (IOException ioe) {
            Print.logException((String)"IO Error", (Throwable)ioe);
            System.exit(99);
        }
    }
}

