/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.util.HTMLTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public abstract class SMSOutboundGateway {
    private static final String PROP_SmsGatewayHandler_ = "SmsGatewayHandler.";
    public static final String PROP_defaultName = "SmsGatewayHandler.defaultName";
    public static final String GW_emailBody = "emailBody";
    public static final String PROP_emailBody_smsEmailAddress = "SmsGatewayHandler.emailBody.smsEmailAddress";
    public static final String PROP_emailBody_maxMessageLength = "SmsGatewayHandler.emailBody.maxMessageLength";
    public static final String GW_emailSubject = "emailSubject";
    public static final String PROP_emailSubject_smsEmailAddress = "SmsGatewayHandler.emailSubject.smsEmailAddress";
    public static final String PROP_emailSubject_maxMessageLength = "SmsGatewayHandler.emailSubject.maxMessageLength";
    public static final String GW_httpURL = "httpURL";
    public static final String PROP_httpURL_url = "SmsGatewayHandler.httpURL.url";
    public static final String PROP_httpURL_maxMessageLength = "SmsGatewayHandler.httpURL.maxMessageLength";
    public static final String GW_clickatell = "clickatell";
    public static final String PROP_clickatell_smsEmailAddress = "SmsGatewayHandler.clickatell.smsEmailAddress";
    public static final String PROP_clickatell_user = "SmsGatewayHandler.clickatell.user";
    public static final String PROP_clickatell_password = "SmsGatewayHandler.clickatell.password";
    public static final String PROP_clickatell_api_id = "SmsGatewayHandler.clickatell.api_id";
    public static final String PROP_clickatell_maxMessageLength = "SmsGatewayHandler.clickatell.maxMessageLength";
    public static final String GW_mail2txt = "mail2txt";
    public static final String PROP_mail2txt_smsEmailAddress = "SmsGatewayHandler.mail2txt.smsEmailAddress";
    public static final String PROP_mail2txt_maxMessageLength = "SmsGatewayHandler.mail2txt.maxMessageLength";
    public static final String GW_mail2txt160 = "mail2txt160";
    public static final String PROP_mail2txt160_smsEmailAddress = "SmsGatewayHandler.mail2txt160.smsEmailAddress";
    public static final String PROP_mail2txt160_maxMessageLength = "SmsGatewayHandler.mail2txt160.maxMessageLength";
    public static final String GW_mail2txtid = "mail2txtid";
    public static final String PROP_mail2txtid_smsEmailAddress = "SmsGatewayHandler.mail2txtid.smsEmailAddress";
    public static final String PROP_mail2txtid_from = "SmsGatewayHandler.mail2txtid.from";
    public static final String PROP_mail2txtid_maxMessageLength = "SmsGatewayHandler.mail2txtid.maxMessageLength";
    public static final String GW_mail2txt160id = "mail2txt160id";
    public static final String PROP_mail2txt160id_smsEmailAddress = "SmsGatewayHandler.mail2txt160id.smsEmailAddress";
    public static final String PROP_mail2txt160id_from = "SmsGatewayHandler.mail2txt160id.from";
    public static final String PROP_mail2txt160id_maxMessageLength = "SmsGatewayHandler.mail2txt160id.maxMessageLength";
    public static final String GW_ozekisms = "ozekisms";
    public static final String PROP_ozekisms_hostPort = "SmsGatewayHandler.ozekisms.hostPort";
    public static final String PROP_ozekisms_originator = "SmsGatewayHandler.ozekisms.originator";
    public static final String PROP_ozekisms_user = "SmsGatewayHandler.ozekisms.user";
    public static final String PROP_ozekisms_password = "SmsGatewayHandler.ozekisms.password";
    public static final String PROP_ozekisms_maxMessageLength = "SmsGatewayHandler.ozekisms.maxMessageLength";
    public static final int MAX_TEXT_LENGTH = 160;
    public static final String SMS_Prefix = "SMS:";
    public static final String[] REPL_mobile = new String[]{"%{mobile}", "{MOBILE}", "${mobile}"};
    public static final String[] REPL_sender = new String[]{"%{sender}", "{SENDER}", "${sender}"};
    public static final String[] REPL_dataKey = new String[]{"%{dataKey}", "{DATAKEY}", "${dataKey}"};
    public static final String[] REPL_uniqueID = new String[]{"%{uniqueID}", "{UNIQUEID}", "${uniqueID}"};
    public static final String[] REPL_modemID = new String[]{"%{modemID}", "{MODEMID}", "${modemID}"};
    public static final String[] REPL_simID = new String[]{"%{simID}", "{SIMID}", "${simID}"};
    public static final String[] REPL_imei = new String[]{"%{imei}", "{IMEI}", "${imei}"};
    public static final String[] REPL_serial = new String[]{"%{serial}", "{SERIAL}", "${serial}"};
    public static final String[] REPL_user = new String[]{"%{user}", "{USER}", "${user}"};
    public static final String[] REPL_password = new String[]{"%{password}", "{PASSWORD}", "${password}"};
    public static final String[] REPL_authID = new String[]{"%{authID}", "{AUTHID}", "${authID}"};
    public static final String[] REPL_message = new String[]{"%{message}", "{MESSAGE}", "${message}"};
    private static Map<String, SMSOutboundGateway> SmsGatewayHandlerMap = null;
    public String gwName = "";
    private static final String[] ARG_ACCOUNT = new String[]{"account", "a"};
    private static final String[] ARG_DEVICE = new String[]{"device", "d"};
    private static final String[] ARG_PHONE = new String[]{"phone", "p"};
    private static final String[] ARG_URL = new String[]{"url", "u"};
    private static final String[] ARG_MESSAGE = new String[]{"message", "m", "msg"};

    public static String GetDefaultGatewayName() {
        return RTConfig.getString((String)PROP_defaultName, (String)GW_emailBody);
    }

    public static boolean StartsWithSMS(String val) {
        return StringTools.startsWithIgnoreCase((String)val, (String)SMS_Prefix);
    }

    public static String RemovePrefixSMS(String val) {
        if (SMSOutboundGateway.StartsWithSMS(val = StringTools.trim((String)val))) {
            return val.substring(SMS_Prefix.length()).trim();
        }
        return val;
    }

    public static int getMaximumTextMessageLength() {
        return 160;
    }

    public static String truncateTextMessageToMaximumLength(String msg) {
        if (StringTools.isBlank((String)(msg = StringTools.trim((String)msg)))) {
            return "";
        }
        if (msg.length() > SMSOutboundGateway.getMaximumTextMessageLength()) {
            msg = msg.substring(0, SMSOutboundGateway.getMaximumTextMessageLength()).trim();
            return msg;
        }
        return msg;
    }

    public static String truncateMessage(String message, int length) {
        int len;
        if (message == null) {
            return "";
        }
        message = message.trim();
        int n = len = length > 0 ? Math.min(length, 160) : 160;
        if (message.length() > len) {
            return message.substring(0, len);
        }
        return message;
    }

    public static boolean isDeviceAuthorized(Device device) {
        if (device == null) {
            return false;
        }
        Account account = device.getAccount();
        if (account == null) {
            return false;
        }
        return account.getSmsEnabled();
    }

    public static String REPLACE(String s, String[] r, String m) {
        for (int i = 0; i < r.length; ++i) {
            s = StringTools.replace((String)s, (String)r[i], (String)m);
        }
        return s;
    }

    public static String REPLACE(String s, RTProperties rtp) {
        return StringTools.insertKeyValues((String)s, (String)"%{", (String)"}", (String)"=", (StringTools.KeyValueMap)rtp);
    }

    private static void AddUrlRtpArgs(RTProperties urlRTP, RTProperties otherRTP) {
        if (otherRTP != null) {
            Set keys = otherRTP.getPropertyKeys();
            for (Object K : keys) {
                Object V = otherRTP.getProperty(K, null);
                if (!(K instanceof String) || !(V instanceof String) || StringTools.isBlank((String)((String)V))) continue;
                String key = (String)K;
                String val = (String)V;
                SMSOutboundGateway.AddUrlRtpArg(urlRTP, key, val);
            }
        }
    }

    private static void AddUrlRtpArg(RTProperties urlRTP, String key, String val) {
        if (!StringTools.isBlank((String)val)) {
            urlRTP.setString(key, URIArg.encodeArg((String)val));
        }
    }

    private static String EncodeUrlReplacementVars(Account account, Device device, String smsPhone, String httpURL, String messageStr, int maxMsgLen) {
        RTProperties urlRTP = new RTProperties();
        if (account == null && device == null) {
            return httpURL;
        }
        if (account == null) {
            account = device.getAccount();
        }
        String sender = null;
        String user = null;
        String password = null;
        String authID = null;
        if (account != null) {
            RTProperties smsRTP = account.getSmsRTProperties();
            sender = smsRTP.getString("sender", "");
            user = smsRTP.getString("user", "");
            password = smsRTP.getString("password", "");
            authID = smsRTP.getString("authID", "");
            SMSOutboundGateway.AddUrlRtpArgs(urlRTP, smsRTP);
        }
        String mobile = null;
        String mobile_1 = null;
        String dataKey = null;
        String uniqueID = null;
        String modemID = null;
        String simID = null;
        String imeiNum = null;
        String serial = null;
        if (device != null) {
            mobile = device.getSimPhoneNumber();
            mobile_1 = mobile.startsWith("1") || mobile.length() != 10 ? mobile : "1" + mobile;
            dataKey = device.getDataKey();
            uniqueID = device.getUniqueID();
            modemID = device.getModemID();
            simID = device.getSimID();
            imeiNum = device.getImeiNumber();
            serial = device.getSerialNumber();
        } else {
            mobile = StringTools.trim((String)smsPhone);
            mobile_1 = mobile.startsWith("1") || mobile.length() != 10 ? mobile : "1" + mobile;
        }
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "mobile", mobile);
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "1mobile", mobile_1);
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "dataKey", dataKey);
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "uniqueID", uniqueID);
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "modemID", modemID);
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "simID", simID);
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "imei", imeiNum);
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "serial", serial);
        String message = StringTools.trim((String)messageStr);
        message = StringTools.insertKeyValues((String)message, (String)"%{", (String)"}", (String)"=", (StringTools.KeyValueMap)urlRTP);
        if (StringTools.length((String)message) > maxMsgLen) {
            Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
            message = SMSOutboundGateway.truncateMessage(message, maxMsgLen);
        }
        SMSOutboundGateway.AddUrlRtpArg(urlRTP, "message", message);
        httpURL = StringTools.insertKeyValues((String)httpURL, (String)"%{", (String)"}", (String)"=", (StringTools.KeyValueMap)urlRTP);
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_mobile, URIArg.encodeArg((String)mobile));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_message, URIArg.encodeArg((String)message));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_sender, URIArg.encodeArg((String)sender));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_user, URIArg.encodeArg((String)user));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_password, URIArg.encodeArg((String)password));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_authID, URIArg.encodeArg((String)authID));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_dataKey, URIArg.encodeArg((String)dataKey));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_uniqueID, URIArg.encodeArg((String)uniqueID));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_modemID, URIArg.encodeArg((String)modemID));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_simID, URIArg.encodeArg((String)simID));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_imei, URIArg.encodeArg((String)imeiNum));
        httpURL = SMSOutboundGateway.REPLACE(httpURL, REPL_serial, URIArg.encodeArg((String)serial));
        return httpURL;
    }

    public static void AddSMSGateway(String name, SMSOutboundGateway smsGW) {
        if (StringTools.isBlank((String)name)) {
            Print.logWarn((String)"SMS Gateway name is blank", (Object[])new Object[0]);
            return;
        }
        if (smsGW == null) {
            Print.logWarn((String)"SMS Gateway handler is null", (Object[])new Object[0]);
            return;
        }
        smsGW.setName(name);
        if (SmsGatewayHandlerMap == null) {
            SmsGatewayHandlerMap = new HashMap<String, SMSOutboundGateway>();
        }
        SmsGatewayHandlerMap.put(name.toLowerCase(), smsGW);
        Print.logDebug((String)("Added SMS Gateway Handler: " + name), (Object[])new Object[0]);
    }

    public static SMSOutboundGateway GetSMSGateway(String name) {
        if (StringTools.isBlank((String)name)) {
            return null;
        }
        if (name.equalsIgnoreCase("body")) {
            name = GW_emailBody;
        } else if (name.equalsIgnoreCase("subject")) {
            name = GW_emailSubject;
        }
        return SmsGatewayHandlerMap.get(name.toLowerCase());
    }

    public static void _startupInit() {
        Print.logDebug((String)"SMSOutboundGateway initializing ...", (Object[])new Object[0]);
        if (SmsGatewayHandlerMap != null) {
            return;
        }
        SMSOutboundGateway.AddSMSGateway(GW_emailBody, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!1.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String frEmail = this.getFromEmailAddress(device);
                String toEmail = this.getSmsEmailAddress(device);
                if (StringTools.isBlank((String)toEmail)) {
                    String smsPhone = device.getSimPhoneNumber();
                    String smsEmail = this.getStringProperty(device, SMSOutboundGateway.PROP_emailBody_smsEmailAddress, "");
                    toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 1.REPLACE(smsEmail, REPL_mobile, smsPhone);
                }
                String message = commandStr;
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_emailBody_maxMessageLength, (int)160);
                if (StringTools.length((String)message) > maxLen) {
                    Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
                }
                return this.sendEmail(frEmail, toEmail, "", message);
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String frEmail = this.getFromEmailAddress(account);
                String smsEmail = RTConfig.getString((String)SMSOutboundGateway.PROP_emailBody_smsEmailAddress, (String)"");
                String toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 1.REPLACE(smsEmail, REPL_mobile, smsPhone);
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_emailBody_maxMessageLength, (int)160);
                String message = SMSOutboundGateway.truncateMessage(smsMessage, maxLen);
                return this.sendEmail(frEmail, toEmail, "", message);
            }
        });
        SMSOutboundGateway.AddSMSGateway(GW_emailSubject, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!2.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String frEmail = this.getFromEmailAddress(device);
                String toEmail = this.getSmsEmailAddress(device);
                if (StringTools.isBlank((String)toEmail)) {
                    String smsPhone = device.getSimPhoneNumber();
                    String smsEmail = this.getStringProperty(device, SMSOutboundGateway.PROP_emailSubject_smsEmailAddress, "");
                    toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 2.REPLACE(smsEmail, REPL_mobile, smsPhone);
                }
                String message = commandStr;
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_emailSubject_maxMessageLength, (int)160);
                if (StringTools.length((String)message) > maxLen) {
                    Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
                }
                return this.sendEmail(frEmail, toEmail, message, "");
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String frEmail = this.getFromEmailAddress(account);
                String smsEmail = RTConfig.getString((String)SMSOutboundGateway.PROP_emailSubject_smsEmailAddress, (String)"");
                String toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 2.REPLACE(smsEmail, REPL_mobile, smsPhone);
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_emailSubject_maxMessageLength, (int)160);
                String message = SMSOutboundGateway.truncateMessage(smsMessage, maxLen);
                return this.sendEmail(frEmail, toEmail, message, "");
            }
        });
        SMSOutboundGateway.AddSMSGateway(GW_httpURL, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!3.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String httpURL = this.getStringProperty(device, SMSOutboundGateway.PROP_httpURL_url, "");
                if (StringTools.isBlank((String)httpURL)) {
                    Print.logWarn((String)"'SmsGatewayHandler.httpURL.url' not specified", (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                httpURL = SMSOutboundGateway.EncodeUrlReplacementVars(null, device, null, httpURL, commandStr, RTConfig.getInt((String)SMSOutboundGateway.PROP_httpURL_maxMessageLength, (int)160));
                return this._sendSMS(httpURL);
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String httpURL = RTConfig.getString((String)SMSOutboundGateway.PROP_httpURL_url, (String)"");
                if (StringTools.isBlank((String)httpURL)) {
                    Print.logWarn((String)"'SmsGatewayHandler.httpURL.url' not specified", (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                httpURL = SMSOutboundGateway.EncodeUrlReplacementVars(account, null, smsPhone, httpURL, smsMessage, RTConfig.getInt((String)SMSOutboundGateway.PROP_httpURL_maxMessageLength, (int)160));
                return this._sendSMS(httpURL);
            }

            private DCServerFactory.ResultCode _sendSMS(String httpURL) {
                try {
                    Print.logInfo((String)("SMS Gateway URL: " + httpURL), (Object[])new Object[0]);
                    byte[] response = HTMLTools.readPage_GET((String)httpURL, (int)10000);
                    String resp = StringTools.toStringValue((byte[])response);
                    int maxRespLen = 60;
                    if (resp.length() <= maxRespLen) {
                        Print.logInfo((String)("SMS Gateway response (httpURL): " + resp), (Object[])new Object[0]);
                    } else {
                        String R = resp.substring(0, maxRespLen);
                        Print.logInfo((String)("SMS Gateway response (httpURL): " + R + " ..."), (Object[])new Object[0]);
                    }
                    if (httpURL.indexOf("clickatell.com") > 0) {
                        if (resp.startsWith("ID:")) {
                            return DCServerFactory.ResultCode.SUCCESS;
                        }
                        if (resp.indexOf("Authentication") > 0) {
                            Print.logError((String)"SMS Gateway 'clickatell' Authentication Failure", (Object[])new Object[0]);
                            return DCServerFactory.ResultCode.GATEWAY_AUTH;
                        }
                        Print.logError((String)"SMS Gateway 'clickatell' General Error", (Object[])new Object[0]);
                        return DCServerFactory.ResultCode.GATEWAY_ERROR;
                    }
                    if ((resp = resp.toUpperCase()).indexOf("ERROR") >= 0) {
                        Print.logError((String)"SMS Gateway 'ERROR' found", (Object[])new Object[0]);
                        return DCServerFactory.ResultCode.GATEWAY_ERROR;
                    }
                    if (resp.indexOf("FAIL") >= 0) {
                        Print.logError((String)"SMS Gateway 'FAIL' found", (Object[])new Object[0]);
                        return DCServerFactory.ResultCode.GATEWAY_ERROR;
                    }
                    return DCServerFactory.ResultCode.SUCCESS;
                }
                catch (UnsupportedEncodingException uee) {
                    Print.logError((String)("URL Encoding: " + uee), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.TRANSMIT_FAIL;
                }
                catch (NoRouteToHostException nrthe) {
                    Print.logError((String)("Unreachable Host: " + httpURL), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.UNKNOWN_HOST;
                }
                catch (UnknownHostException uhe) {
                    Print.logError((String)("Unknown Host: " + httpURL), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.UNKNOWN_HOST;
                }
                catch (FileNotFoundException fnfe) {
                    Print.logError((String)("Invalid URL (not found): " + httpURL), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                catch (MalformedURLException mue) {
                    Print.logError((String)("Invalid URL (malformed): " + httpURL), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                catch (Throwable th) {
                    Print.logError((String)("HTML SMS error: " + th), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.TRANSMIT_FAIL;
                }
            }
        });
        SMSOutboundGateway.AddSMSGateway(GW_clickatell, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!4.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String frEmail = this.getFromEmailAddress(device);
                String toEmail = this.getStringProperty(device, SMSOutboundGateway.PROP_clickatell_smsEmailAddress, "");
                String user = this.getStringProperty(device, SMSOutboundGateway.PROP_clickatell_user, "");
                String password = this.getStringProperty(device, SMSOutboundGateway.PROP_clickatell_password, "");
                String api_id = this.getStringProperty(device, SMSOutboundGateway.PROP_clickatell_api_id, "");
                String to = device.getSimPhoneNumber();
                String from = "";
                String message = commandStr;
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_clickatell_maxMessageLength, (int)160);
                if (StringTools.length((String)message) > maxLen) {
                    Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("user:" + user).append("\n");
                sb.append("password:" + password).append("\n");
                sb.append("api_id:" + api_id).append("\n");
                sb.append("text:" + message).append("\n");
                sb.append("to:" + to).append("\n");
                return this.sendEmail(frEmail, toEmail, "", sb.toString());
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String frEmail = this.getFromEmailAddress(account);
                String toEmail = RTConfig.getString((String)SMSOutboundGateway.PROP_clickatell_smsEmailAddress, (String)"");
                String user = RTConfig.getString((String)SMSOutboundGateway.PROP_clickatell_user, (String)"");
                String password = RTConfig.getString((String)SMSOutboundGateway.PROP_clickatell_password, (String)"");
                String api_id = RTConfig.getString((String)SMSOutboundGateway.PROP_clickatell_api_id, (String)"");
                String to = smsPhone;
                String from = "";
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_clickatell_maxMessageLength, (int)160);
                String message = SMSOutboundGateway.truncateMessage(smsMessage, maxLen);
                StringBuffer sb = new StringBuffer();
                sb.append("user:" + user).append("\n");
                sb.append("password:" + password).append("\n");
                sb.append("api_id:" + api_id).append("\n");
                sb.append("text:" + message).append("\n");
                sb.append("to:" + to).append("\n");
                return this.sendEmail(frEmail, toEmail, "", sb.toString());
            }
        });
        SMSOutboundGateway.AddSMSGateway(GW_mail2txt, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!5.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String smsPhone = this.getSmsPhoneNumber(device);
                String smsEmail = this.getStringProperty(device, SMSOutboundGateway.PROP_mail2txt_smsEmailAddress, "@mail2txt.net");
                String frEmail = this.getFromEmailAddress(device);
                String toEmail = this.getSmsEmailAddress(device);
                if (StringTools.isBlank((String)toEmail)) {
                    toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 5.REPLACE(smsEmail, REPL_mobile, smsPhone);
                } else if (!toEmail.endsWith(smsEmail)) {
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                String message = commandStr;
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_mail2txt_maxMessageLength, (int)160);
                if (StringTools.length((String)message) > maxLen) {
                    Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
                }
                return this.sendEmail(frEmail, toEmail, message, "$$");
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                String toEmail;
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String smsEmail = RTConfig.getString((String)SMSOutboundGateway.PROP_mail2txt_smsEmailAddress, (String)"@mail2txt.net");
                String frEmail = this.getFromEmailAddress(account);
                String string = toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 5.REPLACE(smsEmail, REPL_mobile, smsPhone);
                if (!toEmail.endsWith(smsEmail)) {
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_mail2txt_maxMessageLength, (int)160);
                String message = SMSOutboundGateway.truncateMessage(smsMessage, maxLen);
                return this.sendEmail(frEmail, toEmail, message, "$$");
            }
        });
        SMSOutboundGateway.AddSMSGateway(GW_mail2txt160, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!6.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String smsPhone = this.getSmsPhoneNumber(device);
                String smsEmail = this.getStringProperty(device, SMSOutboundGateway.PROP_mail2txt160_smsEmailAddress, "@mail2txt160.net");
                String frEmail = this.getFromEmailAddress(device);
                String toEmail = this.getSmsEmailAddress(device);
                if (StringTools.isBlank((String)toEmail)) {
                    toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 6.REPLACE(smsEmail, REPL_mobile, smsPhone);
                } else if (!toEmail.endsWith(smsEmail)) {
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                String message = commandStr;
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_mail2txt160_maxMessageLength, (int)160);
                if (StringTools.length((String)message) > maxLen) {
                    Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
                }
                return this.sendEmail(frEmail, toEmail, message, "$$");
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                String toEmail;
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String smsEmail = RTConfig.getString((String)SMSOutboundGateway.PROP_mail2txt160_smsEmailAddress, (String)"@mail2txt160.net");
                String frEmail = this.getFromEmailAddress(account);
                String string = toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 6.REPLACE(smsEmail, REPL_mobile, smsPhone);
                if (!toEmail.endsWith(smsEmail)) {
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_mail2txt160_maxMessageLength, (int)160);
                String message = SMSOutboundGateway.truncateMessage(smsMessage, maxLen);
                return this.sendEmail(frEmail, toEmail, message, "$$");
            }
        });
        SMSOutboundGateway.AddSMSGateway(GW_mail2txtid, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!7.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String smsPhone = this.getSmsPhoneNumber(device);
                String smsEmail = this.getStringProperty(device, SMSOutboundGateway.PROP_mail2txtid_smsEmailAddress, "@mail2txtid.net");
                String fromNum = this.getStringProperty(device, SMSOutboundGateway.PROP_mail2txtid_from, "");
                String frEmail = this.getFromEmailAddress(device);
                String toEmail = this.getSmsEmailAddress(device);
                if (StringTools.isBlank((String)toEmail)) {
                    toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 7.REPLACE(smsEmail, REPL_mobile, smsPhone);
                } else if (!toEmail.endsWith(smsEmail)) {
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                String message = commandStr + "$$";
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_mail2txtid_maxMessageLength, (int)160);
                if (StringTools.length((String)message) > maxLen) {
                    Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
                }
                return this.sendEmail(frEmail, toEmail, fromNum, message);
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                String toEmail;
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String smsEmail = RTConfig.getString((String)SMSOutboundGateway.PROP_mail2txtid_smsEmailAddress, (String)"@mail2txtid.net");
                String fromNum = RTConfig.getString((String)SMSOutboundGateway.PROP_mail2txtid_from, (String)"");
                String frEmail = this.getFromEmailAddress(account);
                String string = toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 7.REPLACE(smsEmail, REPL_mobile, smsPhone);
                if (!toEmail.endsWith(smsEmail)) {
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_mail2txtid_maxMessageLength, (int)160);
                String message = SMSOutboundGateway.truncateMessage(smsMessage, maxLen) + "$$";
                return this.sendEmail(frEmail, toEmail, fromNum, message);
            }
        });
        SMSOutboundGateway.AddSMSGateway(GW_mail2txt160id, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!8.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String smsPhone = this.getSmsPhoneNumber(device);
                String smsEmail = this.getStringProperty(device, SMSOutboundGateway.PROP_mail2txt160id_smsEmailAddress, "@mail2txt160id.net");
                String fromNum = this.getStringProperty(device, SMSOutboundGateway.PROP_mail2txt160id_from, "");
                String frEmail = this.getFromEmailAddress(device);
                String toEmail = this.getSmsEmailAddress(device);
                if (StringTools.isBlank((String)toEmail)) {
                    toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 8.REPLACE(smsEmail, REPL_mobile, smsPhone);
                } else if (!toEmail.endsWith(smsEmail)) {
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                String message = commandStr + "$$";
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_mail2txt160id_maxMessageLength, (int)160);
                if (StringTools.length((String)message) > maxLen) {
                    Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
                }
                return this.sendEmail(frEmail, toEmail, fromNum, message);
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                String toEmail;
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String smsEmail = RTConfig.getString((String)SMSOutboundGateway.PROP_mail2txt160id_smsEmailAddress, (String)"@mail2txt160id.net");
                String fromNum = RTConfig.getString((String)SMSOutboundGateway.PROP_mail2txt160id_from, (String)"");
                String frEmail = this.getFromEmailAddress(account);
                String string = toEmail = smsEmail.startsWith("@") ? smsPhone + smsEmail : 8.REPLACE(smsEmail, REPL_mobile, smsPhone);
                if (!toEmail.endsWith(smsEmail)) {
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_mail2txt160id_maxMessageLength, (int)160);
                String message = SMSOutboundGateway.truncateMessage(smsMessage, maxLen) + "$$";
                return this.sendEmail(frEmail, toEmail, fromNum, message);
            }
        });
        SMSOutboundGateway.AddSMSGateway(GW_ozekisms, new SMSOutboundGateway(){

            @Override
            public DCServerFactory.ResultCode sendSMSCommand(Device device, String commandStr) {
                if (device == null) {
                    return DCServerFactory.ResultCode.INVALID_DEVICE;
                }
                if (!9.isDeviceAuthorized(device)) {
                    return DCServerFactory.ResultCode.NOT_AUTHORIZED;
                }
                String hostPort = this.getStringProperty(device, SMSOutboundGateway.PROP_ozekisms_hostPort, "localhost:9501");
                String originator = this.getStringProperty(device, SMSOutboundGateway.PROP_ozekisms_originator, "1234567890");
                String recipient = device.getSimPhoneNumber();
                String username = this.getStringProperty(device, SMSOutboundGateway.PROP_ozekisms_user, "");
                String password = this.getStringProperty(device, SMSOutboundGateway.PROP_ozekisms_password, "");
                String message = commandStr;
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_ozekisms_maxMessageLength, (int)160);
                if (StringTools.length((String)message) > maxLen) {
                    Print.logWarn((String)("Invalid SMS text command length: " + StringTools.length((String)message)), (Object[])new Object[0]);
                }
                StringBuffer smsURL = new StringBuffer();
                try {
                    smsURL.append("http://").append(hostPort).append("/api?action=sendmessage");
                    smsURL.append("&username=").append(URLEncoder.encode(username, "UTF-8"));
                    smsURL.append("&password=").append(URLEncoder.encode(password, "UTF-8"));
                    smsURL.append("&recipient=").append(URLEncoder.encode(recipient, "UTF-8"));
                    smsURL.append("&messagetype=SMS:TEXT");
                    smsURL.append("&messagedata=").append(URLEncoder.encode(message, "UTF-8"));
                    smsURL.append("&originator=").append(URLEncoder.encode(originator, "UTF-8"));
                    smsURL.append("&serviceprovider=GSMModem1");
                    smsURL.append("&responseformat=html");
                    byte[] response = HTMLTools.readPage_GET((String)smsURL.toString(), (int)10000);
                    return DCServerFactory.ResultCode.SUCCESS;
                }
                catch (UnsupportedEncodingException uee) {
                    Print.logError((String)("URL Encoding: " + uee), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.TRANSMIT_FAIL;
                }
                catch (NoRouteToHostException nrthe) {
                    Print.logError((String)("Unreachable Host: " + hostPort), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.UNKNOWN_HOST;
                }
                catch (UnknownHostException uhe) {
                    Print.logError((String)("Unknown Host: " + hostPort), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.UNKNOWN_HOST;
                }
                catch (FileNotFoundException fnfe) {
                    Print.logError((String)("Invalid URL (not found): " + smsURL), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                catch (MalformedURLException mue) {
                    Print.logError((String)("Invalid URL (malformed): " + smsURL), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                catch (Throwable th) {
                    Print.logError((String)("HTML SMS error: " + th), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.TRANSMIT_FAIL;
                }
            }

            @Override
            public DCServerFactory.ResultCode sendSMSMessage(Account account, String smsMessage, String smsPhone) {
                if (account == null) {
                    return DCServerFactory.ResultCode.INVALID_ACCOUNT;
                }
                String recipient = smsPhone;
                String hostPort = RTConfig.getString((String)SMSOutboundGateway.PROP_ozekisms_hostPort, (String)"localhost:9501");
                String originator = RTConfig.getString((String)SMSOutboundGateway.PROP_ozekisms_originator, (String)"1234567890");
                String username = RTConfig.getString((String)SMSOutboundGateway.PROP_ozekisms_user, (String)"");
                String password = RTConfig.getString((String)SMSOutboundGateway.PROP_ozekisms_password, (String)"");
                int maxLen = RTConfig.getInt((String)SMSOutboundGateway.PROP_ozekisms_maxMessageLength, (int)160);
                String message = SMSOutboundGateway.truncateMessage(smsMessage, maxLen);
                StringBuffer smsURL = new StringBuffer();
                try {
                    smsURL.append("http://").append(hostPort).append("/api?action=sendmessage");
                    smsURL.append("&username=").append(URLEncoder.encode(username, "UTF-8"));
                    smsURL.append("&password=").append(URLEncoder.encode(password, "UTF-8"));
                    smsURL.append("&recipient=").append(URLEncoder.encode(recipient, "UTF-8"));
                    smsURL.append("&messagetype=SMS:TEXT");
                    smsURL.append("&messagedata=").append(URLEncoder.encode(message, "UTF-8"));
                    smsURL.append("&originator=").append(URLEncoder.encode(originator, "UTF-8"));
                    smsURL.append("&serviceprovider=GSMModem1");
                    smsURL.append("&responseformat=html");
                    byte[] response = HTMLTools.readPage_GET((String)smsURL.toString(), (int)10000);
                    return DCServerFactory.ResultCode.SUCCESS;
                }
                catch (UnsupportedEncodingException uee) {
                    Print.logError((String)("URL Encoding: " + uee), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.TRANSMIT_FAIL;
                }
                catch (NoRouteToHostException nrthe) {
                    Print.logError((String)("Unreachable Host: " + hostPort), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.UNKNOWN_HOST;
                }
                catch (UnknownHostException uhe) {
                    Print.logError((String)("Unknown Host: " + hostPort), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.UNKNOWN_HOST;
                }
                catch (FileNotFoundException fnfe) {
                    Print.logError((String)("Invalid URL (not found): " + smsURL), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                catch (MalformedURLException mue) {
                    Print.logError((String)("Invalid URL (malformed): " + smsURL), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.INVALID_SMS;
                }
                catch (Throwable th) {
                    Print.logError((String)("HTML SMS error: " + th), (Object[])new Object[0]);
                    return DCServerFactory.ResultCode.TRANSMIT_FAIL;
                }
            }
        });
    }

    public void setName(String n) {
        this.gwName = StringTools.trim((String)n);
    }

    public String getName() {
        return this.gwName;
    }

    public String toString() {
        return "SMSGateway: " + this.getName();
    }

    public abstract DCServerFactory.ResultCode sendSMSCommand(Device var1, String var2);

    public abstract DCServerFactory.ResultCode sendSMSMessage(Account var1, String var2, String var3);

    protected String getFromEmailAddress(Device device) {
        if (device == null) {
            return null;
        }
        return CommandPacketHandler.getFromEmailCommand(device.getAccount());
    }

    protected String getFromEmailAddress(Account account) {
        if (account == null) {
            return null;
        }
        return CommandPacketHandler.getFromEmailCommand(account);
    }

    protected String getSmsEmailAddress(Device device) {
        if (device == null) {
            return null;
        }
        String toEmail = device.getSmsEmail();
        return toEmail;
    }

    protected String getSmsPhoneNumber(Device device) {
        if (device == null) {
            return null;
        }
        String smsPhone = device.getSimPhoneNumber();
        return smsPhone;
    }

    protected String getStringProperty(Device device, String key, String dft) {
        DCServerConfig dcs;
        String prop;
        Account account = device != null ? device.getAccount() : null;
        BasicPrivateLabel bpl = Account.getPrivateLabel(account);
        if (bpl != null && (prop = bpl.getStringProperty(key, null)) != null) {
            return prop;
        }
        DCServerConfig dCServerConfig = dcs = device != null ? DCServerFactory.getServerConfig(device.getDeviceCode()) : null;
        if (dcs != null) {
            String prop2 = dcs.getStringProperty(key, dft);
            Print.logInfo((String)("DCServerConfig property '" + key + "' ==> " + prop2), (Object[])new Object[0]);
            if (StringTools.isBlank((String)prop2) && RTConfig.hasProperty((String)key)) {
                Print.logInfo((String)("(RTConfig property '" + key + "' ==> " + RTConfig.getString((String)key, (String)"") + ")"), (Object[])new Object[0]);
            }
            return prop2;
        }
        String prop3 = RTConfig.getString((String)key, (String)dft);
        Print.logInfo((String)("RTConfig property '" + key + "' ==> " + prop3), (Object[])new Object[0]);
        return prop3;
    }

    protected DCServerFactory.ResultCode sendEmail(String frEmail, String toEmail, String subj, String body) {
        if (StringTools.isBlank((String)frEmail)) {
            Print.logError((String)"'From' SMS Email address not specified", (Object[])new Object[0]);
            return DCServerFactory.ResultCode.INVALID_EMAIL_FR;
        }
        if (StringTools.isBlank((String)toEmail) || !CommandPacketHandler.validateAddress(toEmail)) {
            Print.logError((String)"'To' SMS Email address invalid, or not specified", (Object[])new Object[0]);
            return DCServerFactory.ResultCode.INVALID_EMAIL_TO;
        }
        if (StringTools.isBlank((String)subj) && StringTools.isBlank((String)body)) {
            Print.logError((String)"SMS Subject/Body string not specified", (Object[])new Object[0]);
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        try {
            Print.logInfo((String)("SMS email: From <" + frEmail + ">, To <" + toEmail + ">"), (Object[])new Object[0]);
            Print.logDebug((String)("  From   : " + frEmail), (Object[])new Object[0]);
            Print.logDebug((String)("  To     : " + toEmail), (Object[])new Object[0]);
            Print.logDebug((String)("  Subject: " + subj), (Object[])new Object[0]);
            Print.logDebug((String)("  Message: " + body), (Object[])new Object[0]);
            SendMail.SmtpProperties smtpProps = null;
            SendMail.send((String)frEmail, (String)toEmail, null, null, (String)subj, (String)body, null, smtpProps);
            return DCServerFactory.ResultCode.SUCCESS;
        }
        catch (Throwable t) {
            Print.logWarn((String)("SendMail error: " + t), (Object[])new Object[0]);
            return DCServerFactory.ResultCode.TRANSMIT_FAIL;
        }
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, null);
        String deviceID = RTConfig.getString((String[])ARG_DEVICE, null);
        String smsPhone = RTConfig.getString((String[])ARG_PHONE, null);
        String httpURL = RTConfig.getString((String[])ARG_URL, (String)"");
        String message = RTConfig.getString((String[])ARG_MESSAGE, (String)"");
        Account account = null;
        if (!StringTools.isBlank((String)accountID)) {
            try {
                account = Account.getAccount(accountID);
                if (account == null) {
                    Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                    System.exit(99);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
                System.exit(99);
            }
        }
        Device device = null;
        if (!StringTools.isBlank((String)deviceID)) {
            try {
                device = Device.getDevice(account, deviceID);
                if (device == null) {
                    Print.logError((String)("Device-ID does not exist: " + deviceID), (Object[])new Object[0]);
                    System.exit(99);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Error loading Device: " + deviceID), (Throwable)dbe);
                System.exit(99);
            }
        }
        if (account != null && !StringTools.isBlank((String)httpURL)) {
            String newURL = SMSOutboundGateway.EncodeUrlReplacementVars(account, device, smsPhone, httpURL, message, 160);
            Print.sysPrintln((String)("Encoded URL: " + newURL), (Object[])new Object[0]);
        }
    }
}

