/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.RuleFactory;
import org.opengts.db.RuleFactoryAdapter;
import org.opengts.db.SMSOutboundGateway;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class RuleFactoryExample
extends RuleFactoryAdapter {
    private static String RF_NAME = "RuleExample";
    private static String VERSION = "0.0.3";
    private static boolean SEND_NOTIFICATION = false;
    private static String SEL_IS_STOPPED = "isStopped";
    private static String SEL_OVER_100_KPH = "over100kph";
    private static String SEL_OVER_SPEED = "overSpeed";
    private static String SEL_PANIC = "panic";
    private static String SEL_CODE = "code";
    private static String[] RULE_FUNCTIONS = new String[]{SEL_IS_STOPPED, SEL_OVER_100_KPH, SEL_OVER_SPEED, SEL_PANIC, SEL_CODE};
    private static char[] ARG_BEGIN_CHAR = new char[]{'(', ':'};
    private static String ARG_END = ")";
    private Map<String, RuleFunction> ftnMap = new HashMap<String, RuleFunction>();

    public static void DebugSetSendNotification(boolean send) {
        SEND_NOTIFICATION = send;
    }

    private static int indexOfArgSeparator(String s) {
        if (s != null) {
            for (int i = 0; i < ARG_BEGIN_CHAR.length; ++i) {
                int p = s.indexOf(ARG_BEGIN_CHAR[i]);
                if (p < 0) continue;
                return p;
            }
        }
        return -1;
    }

    public RuleFactoryExample() {
        this.ftnMap.put(SEL_PANIC, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                return ev.getStatusCode() == 63553;
            }

            @Override
            public String usage() {
                return SEL_PANIC;
            }

            @Override
            public String description() {
                return "True if Event status code is STATUS_PANIC_ON";
            }
        });
        this.ftnMap.put(SEL_CODE, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                int code = StringTools.parseInt((String)arg, (int)0);
                return ev.getStatusCode() == code;
            }

            @Override
            public String usage() {
                return SEL_CODE;
            }

            @Override
            public String description() {
                return "True if Event status code matches specified code";
            }
        });
        this.ftnMap.put(SEL_OVER_100_KPH, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                return new Boolean(ev.getSpeedKPH() > 100.0);
            }

            @Override
            public String usage() {
                return SEL_OVER_100_KPH;
            }

            @Override
            public String description() {
                return "True if Event speed is over 100 km/h";
            }
        });
        this.ftnMap.put(SEL_IS_STOPPED, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                return new Boolean(ev.getSpeedKPH() <= 0.0);
            }

            @Override
            public String usage() {
                return SEL_IS_STOPPED;
            }

            @Override
            public String description() {
                return "True if Event speed is 0.0";
            }
        });
        this.ftnMap.put(SEL_OVER_SPEED, new RuleFunction(){

            @Override
            public Object evaluate(EventData ev, String arg) {
                double maxSpeed = StringTools.parseDouble((String)arg, (double)99999.9);
                return new Boolean(ev.getSpeedKPH() > maxSpeed);
            }

            @Override
            public String usage() {
                return SEL_OVER_SPEED;
            }

            @Override
            public String description() {
                return "True if Event speed is over specified limit";
            }
        });
    }

    @Override
    public String getName() {
        return RF_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public boolean checkRuntime() {
        return true;
    }

    @Override
    public List<String> getIdentifierNames() {
        return new Vector<String>();
    }

    @Override
    public String getIdentifierDescription(String idName) {
        return null;
    }

    @Override
    public List<String> getFunctionNames() {
        return ListTools.toList((Object[])RULE_FUNCTIONS);
    }

    @Override
    public String getFunctionUsage(String ftnName) {
        RuleFunction ruleFtn = this.getFunction(ftnName);
        return ruleFtn != null ? ruleFtn.usage() : "";
    }

    @Override
    public String getFunctionDescription(String ftnName) {
        RuleFunction ruleFtn = this.getFunction(ftnName);
        return ruleFtn != null ? ruleFtn.description() : "";
    }

    private RuleFunction getFunction(String selector) {
        if (StringTools.isBlank((String)selector)) {
            return null;
        }
        int p = RuleFactoryExample.indexOfArgSeparator(selector);
        String sel = p >= 0 ? selector.substring(0, p) : selector;
        String arg = p >= 0 ? selector.substring(p + 1) : null;
        RuleFunction ftn = this.ftnMap.get(sel);
        if (ftn == null) {
            Print.logWarn((String)("Function for selector not found: " + selector), (Object[])new Object[0]);
        }
        return ftn;
    }

    private String getArgument(String selector) {
        if (StringTools.isBlank((String)selector)) {
            return null;
        }
        int p = RuleFactoryExample.indexOfArgSeparator(selector);
        if (p < 0) {
            return null;
        }
        String a = selector.substring(p + 1);
        if (a.endsWith(ARG_END)) {
            a = a.substring(0, a.length() - 1);
        }
        return a;
    }

    @Override
    public String[] getRuleIDs(Account account) {
        return null;
    }

    @Override
    public String getRuleSelector(Account account, String ruleID) {
        return null;
    }

    @Override
    public String getRuleNotifyEmail(Account account, String ruleID) {
        return null;
    }

    @Override
    public boolean checkSelectorSyntax(String selector) {
        if (StringTools.isBlank((String)selector)) {
            return true;
        }
        String[] selList = StringTools.split((String)selector, (char)',');
        for (int r = 0; r < selList.length; ++r) {
            RuleFunction rf = this.getFunction(selList[r]);
            if (rf != null) continue;
            return false;
        }
        return true;
    }

    public boolean isSelectorMatch(String selector, Account account) {
        return false;
    }

    @Override
    public boolean isSelectorMatch(String selector, EventData event) {
        if (event != null && !StringTools.isBlank((String)selector)) {
            String[] selList = StringTools.split((String)selector, (char)',');
            for (int i = 0; i < selList.length; ++i) {
                if (!this._isSelectorMatch(selList[i], event)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isSelectorMatch(String selector, EventData event) {
        if (StringTools.isBlank((String)selector)) {
            return false;
        }
        RuleFunction ftn = this.getFunction(selector);
        if (ftn == null) {
            return false;
        }
        String arg = this.getArgument(selector);
        Object eval = ftn.evaluate(event, arg);
        if (eval == null) {
            return false;
        }
        if (eval instanceof Boolean) {
            return (Boolean)eval;
        }
        if (eval instanceof Number) {
            return ((Number)eval).longValue() != 0L;
        }
        return true;
    }

    @Override
    public Object evaluateSelector(String selector, Account account) {
        return Boolean.FALSE;
    }

    @Override
    public Object evaluateSelector(String selector, EventData event) {
        String[] selList = StringTools.split((String)selector, (char)',');
        Object eval = null;
        for (int i = 0; i < selList.length; ++i) {
            eval = this._evaluateSelector(selList[i], event);
            if (eval instanceof Boolean && ((Boolean)eval).booleanValue()) {
                return eval;
            }
            if (!(eval instanceof Number) || ((Number)eval).longValue() == 0L) continue;
            return eval;
        }
        return eval;
    }

    private Object _evaluateSelector(String selector, EventData event) {
        RuleFunction ftn = this.getFunction(selector);
        if (ftn == null) {
            return null;
        }
        String arg = this.getArgument(selector);
        return ftn.evaluate(event, arg);
    }

    @Override
    public int executeSelector(String selector, EventData event) {
        if (this.isSelectorMatch(selector, event)) {
            Print.logInfo((String)("Selector matched: " + selector), (Object[])new Object[0]);
            int actionMask = 263;
            return actionMask;
        }
        Print.logDebug((String)("Selector match returned false: " + selector), (Object[])new Object[0]);
        return -1;
    }

    @Override
    public int executeRules(EventData event) {
        if (event == null) {
            return -1;
        }
        String accountID = event.getAccountID();
        Device device = event.getDevice();
        if (device == null) {
            Print.logError((String)("EventData Device not found: " + accountID + "/" + event.getDeviceID()), (Object[])new Object[0]);
            return -1;
        }
        String notifySel = device.getNotifySelector();
        if (this.isSelectorMatch(notifySel, event)) {
            int actionMask = device.getNotifyAction();
            RuleFactoryExample._sendNotification(event, actionMask);
            return actionMask;
        }
        return -1;
    }

    @Override
    public int executeRule(String ruleID, EventData event) {
        return -1;
    }

    protected static boolean _sendNotification(EventData evdb, int actionMask) {
        String frEmail;
        String[] dest;
        if (actionMask == 0) {
            actionMask = 263;
        }
        Account account = evdb.getAccount();
        Device device = evdb.getDevice();
        if (account == null || device == null) {
            return false;
        }
        BasicPrivateLabel privLabel = account.getPrivateLabel();
        if (privLabel == null) {
            Print.logWarn((String)"No PrivateLabel found for Account", (Object[])new Object[0]);
        }
        OrderedSet smsTo = new OrderedSet();
        OrderedSet emailTo = new OrderedSet();
        if ((actionMask & 1) != 0) {
            for (String to : dest = StringTools.split((String)account.getNotifyEmail(), (char)',')) {
                if (StringTools.isBlank((String)to)) continue;
                if (SMSOutboundGateway.StartsWithSMS(to)) {
                    smsTo.add(to);
                    continue;
                }
                emailTo.add(to);
            }
        }
        if ((actionMask & 2) != 0) {
            for (String to : dest = StringTools.split((String)device.getNotifyEmail(false, true), (char)',')) {
                if (StringTools.isBlank((String)to)) continue;
                if (SMSOutboundGateway.StartsWithSMS(to)) {
                    smsTo.add(to);
                    continue;
                }
                emailTo.add(to);
            }
        }
        StringBuffer toEmailSB = new StringBuffer();
        for (String to : emailTo) {
            if (toEmailSB.length() > 0) {
                toEmailSB.append(",");
            }
            toEmailSB.append(to);
        }
        String toEmail = toEmailSB.toString();
        StringBuffer toSmsSB = new StringBuffer();
        for (String to : smsTo) {
            if (toSmsSB.length() > 0) {
                toSmsSB.append(",");
            }
            toSmsSB.append(to);
        }
        String toSMS = toSmsSB.toString();
        String string = frEmail = privLabel != null ? privLabel.getEventNotificationFrom() : null;
        if (frEmail == null || frEmail.equals("")) {
            String string2 = frEmail = privLabel != null ? privLabel.getEMailAddress("notify") : null;
            if (frEmail == null || frEmail.equals("")) {
                frEmail = account.getContactEmail();
            }
        }
        String subj = "Vehicle " + evdb.getDeviceID() + ": Code = " + evdb.getStatusCode();
        String body = "Account   : " + evdb.getAccountID() + "\n" + "Tractor   : " + evdb.getDeviceID() + "\n" + "Date/Time : " + evdb.getTimestamp() + "\n" + "Status    : " + evdb.getStatusCode() + "\n" + "Location  : " + evdb.getGeoPoint() + "\n" + "Speed     : " + evdb.getSpeedKPH() + " KPH  " + evdb.getHeading() + "\n";
        if (evdb.hasAddress()) {
            body = body + "Address   : " + evdb.getAddress() + "\n";
        }
        body = body + "\n";
        String smsm = null;
        Print.logInfo((String)("From   : " + frEmail), (Object[])new Object[0]);
        Print.logInfo((String)("To     : " + toEmail), (Object[])new Object[0]);
        Print.logInfo((String)("Subject: " + subj), (Object[])new Object[0]);
        Print.logInfo((String)("Body   :\n" + body), (Object[])new Object[0]);
        if (!StringTools.isBlank(smsm)) {
            Print.logInfo((String)("SMS    : " + smsm), (Object[])new Object[0]);
        }
        boolean success = true;
        if (!SEND_NOTIFICATION) {
            Print.logWarn((String)"Debug mode enabled, email will not be sent ...", (Object[])new Object[0]);
            return success;
        }
        if ((actionMask & 0x100) != 0) {
            if (StringTools.isBlank((String)toEmail) && StringTools.isBlank((String)toSMS)) {
                Print.logWarn((String)"EMail/SMS requested, but no recipients specified", (Object[])new Object[0]);
                success = false;
            } else {
                if (!StringTools.isBlank((String)toEmail)) {
                    if (StringTools.isBlank((String)frEmail)) {
                        Print.logWarn((String)"Cannot determine 'From' email address!!!", (Object[])new Object[0]);
                        success = false;
                    } else {
                        try {
                            Print.logInfo((String)"Sending notification email ...", (Object[])new Object[0]);
                            SendMail.SmtpProperties smtpProps = privLabel.getSmtpProperties();
                            SendMail.send((String)frEmail, (String)toEmail, null, null, (String)subj, (String)body, null, (SendMail.SmtpProperties)smtpProps);
                        }
                        catch (Throwable t) {
                            Print.logWarn((String)("SendMail error: " + t), (Object[])new Object[0]);
                            success = false;
                        }
                    }
                }
                if (!StringTools.isBlank((String)toSMS)) {
                    if (account.getSmsEnabled()) {
                        String smsMessage = !StringTools.isBlank(smsm) ? smsm.trim().replace('\n', ' ') : (subj + " " + body).trim().replace('\n', ' ');
                        smsMessage = SMSOutboundGateway.truncateTextMessageToMaximumLength(smsMessage);
                        String smsGatewayName = SMSOutboundGateway.GetDefaultGatewayName();
                        SMSOutboundGateway smsGW = SMSOutboundGateway.GetSMSGateway(smsGatewayName);
                        if (smsGW != null) {
                            String[] smsPhoneList;
                            Print.logInfo((String)("Sending SMS via gateway: " + smsGatewayName), (Object[])new Object[0]);
                            for (String smsPhone : smsPhoneList = StringTools.split((String)toSMS, (char)',')) {
                                if (StringTools.isBlank((String)(smsPhone = SMSOutboundGateway.RemovePrefixSMS(smsPhone)))) continue;
                                Print.logInfo((String)("SMS: " + smsPhone + " --> " + smsMessage), (Object[])new Object[0]);
                                DCServerFactory.ResultCode result = smsGW.sendSMSMessage(account, smsMessage, smsPhone);
                                if (result.isSuccess()) continue;
                                Print.logWarn((String)("SMS error: " + (Object)((Object)result)), (Object[])new Object[0]);
                                success = false;
                            }
                        } else {
                            Print.logWarn((String)("SMS Gateway not found: " + smsGatewayName), (Object[])new Object[0]);
                        }
                    } else {
                        Print.logWarn((String)("SMS notification disabled for account: " + account.getAccountID()), (Object[])new Object[0]);
                    }
                }
            }
        }
        if ((actionMask & 0x400) != 0) {
            // empty if block
        }
        if ((actionMask & 0x200) != 0) {
            // empty if block
        }
        return success;
    }

    private static void printMatch(RuleFactory ruleFact, EventData event, String sel) {
        Print.logInfo((String)("Match: " + sel + " ==> " + ruleFact.isSelectorMatch(sel, event)), (Object[])new Object[0]);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        RuleFactoryExample ruleFact = new RuleFactoryExample();
        EventData.Key evKey = new EventData.Key("demo", "demo", DateTime.getCurrentTimeSec(), 61472);
        EventData evRcd = (EventData)evKey.getDBRecord();
        evRcd.setAddress("1234 Somewhere Ln, Somewhere CA, 98765");
        evRcd.setGeoPoint(new GeoPoint(35.12345, -142.12345));
        evRcd.setSpeedKPH(105.0);
        evRcd.setHeading(123.0);
        evRcd.setAltitude(457.0);
        evRcd.setOdometerKM(123456.0);
        evRcd.setDistanceKM(3456.0);
        RuleFactoryExample.printMatch(ruleFact, evRcd, SEL_PANIC);
        RuleFactoryExample.printMatch(ruleFact, evRcd, SEL_OVER_100_KPH);
        RuleFactoryExample.printMatch(ruleFact, evRcd, SEL_IS_STOPPED);
        RuleFactoryExample.printMatch(ruleFact, evRcd, SEL_OVER_SPEED + ":" + 99.0);
        RuleFactoryExample.printMatch(ruleFact, evRcd, SEL_OVER_SPEED + ":" + 106.0);
    }

    private static interface RuleFunction {
        public Object evaluate(EventData var1, String var2);

        public String usage();

        public String description();
    }
}

