/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import org.opengts.db.AccountRecord;
import org.opengts.db.tables.Role;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class RoleRecord<RT extends DBRecord>
extends AccountRecord<RT> {
    public static final String SYSTEM_ROLE_PREFIX = "!";
    public static final String FLD_roleID = "roleID";
    private Role role = null;
    private String roleDesc = null;

    protected static DBField newField_roleID(boolean key) {
        return new DBField(FLD_roleID, String.class, DBField.TYPE_ROLE_ID(), "Role ID", key ? "key=true" : "edit=2");
    }

    public RoleRecord() {
    }

    public RoleRecord(RoleKey<RT> key) {
        super(key);
    }

    public String getRoleID() {
        String v = (String)this.getKeyValue(FLD_roleID);
        return v != null ? v : "";
    }

    private void setRoleID(String v) {
        this.setKeyValue(FLD_roleID, v != null ? v : "");
    }

    public static boolean isSystemAdminRoleID(String roleID) {
        if (StringTools.isBlank((String)roleID)) {
            return false;
        }
        return roleID.startsWith(SYSTEM_ROLE_PREFIX);
    }

    public static String getDisplayRoleID(String roleID) {
        if (StringTools.isBlank((String)roleID)) {
            return "";
        }
        if (roleID.startsWith(SYSTEM_ROLE_PREFIX)) {
            return roleID.substring(SYSTEM_ROLE_PREFIX.length()) + " *";
        }
        return roleID;
    }

    public final Role getRole() {
        if (this.role == null) {
            String roleID = this.getRoleID();
            Print.logDebug((String)("[Optimize] Retrieving Role record: " + roleID), (Object[])new Object[0]);
            try {
                this.role = Role.getRole(this.getAccount(), roleID);
            }
            catch (DBException dbe) {
                Print.logError((String)("Role not found: " + this.getAccountID() + "/" + roleID), (Object[])new Object[0]);
                this.role = null;
            }
        }
        return this.role;
    }

    public final void setRole(Role role) {
        if (role != null && role.getAccountID().equals(this.getAccountID()) && role.getRoleID().equals(this.getRoleID())) {
            this.setAccount(role.getAccount());
            this.role = role;
        } else {
            this.role = null;
        }
    }

    public final String getRoleDescription() {
        if (this.roleDesc == null) {
            Role role = this.getRole();
            this.roleDesc = role != null ? role.getDescription() : this.getRoleID();
        }
        return this.roleDesc;
    }

    public static abstract class RoleKey<RT extends DBRecord>
    extends AccountRecord.AccountKey<RT> {
    }
}

