/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.util.Map;
import java.util.TimeZone;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.util.EnumTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class ReportURL {
    public static final String RPTARG_ACCOUNT = "account";
    public static final String RPTARG_USER = "user";
    public static final String RPTARG_ENCPASS = "encpass";
    public static final String RPTARG_DEVICE = "device";
    public static final String RPTARG_GROUP = "group";
    public static final String[] RPTARG_DATE_FR = new String[]{"date_fr", "fr"};
    public static final String[] RPTARG_DATE_TO = new String[]{"date_to", "to"};
    public static final String[] RPTARG_DATE_TZ = new String[]{"date_tz", "tz"};
    public static final String[] RPTARG_REPORT = new String[]{"r_report", "rpt"};
    public static final String[] RPTARG_LIMIT = new String[]{"r_limit", "lim"};
    public static final String[] RPTARG_LIMIT_TYPE = new String[]{"r_limType", "ltp"};
    public static final String[] RPTARG_FORMAT = new String[]{"r_format", "fmt"};
    public static final String[] RPTARG_EMAIL = new String[]{"r_emailAddr", "email"};
    public static final String URLARG_RTP = "rtp_";
    public static final String FORMAT_HTML = "html";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_CSV = "csv";
    public static final String FORMAT_PDF = "pdf";
    public static final String FORMAT_XLS = "xls";
    public static final String FORMAT_XLSX = "xlsx";
    public static final String FORMAT_TXT = "txt";
    public static final String FORMAT_SOAPXML = "soapxml";
    public static final String FORMAT_EHTML = "ehtml";
    public static final String FORMAT_CUSTOM = "custom";
    public static final String FORMAT_SCHEDULE = "sched";
    public static final String FORMAT_URL = "url";
    public static final String FORMAT_EMAIL = "email";
    public static final String FORMAT_CALLBACK = "callback";
    public static final String PARM_PAGE = "page";
    public static final String PAGE_REPORT_SHOW = "report.show";

    public static URIArg createEventDetailReportURL(String userID, boolean inclPass, Device dev, long timestamp, String baseURL) {
        if (dev == null) {
            return null;
        }
        String deviceID = dev.getDeviceID();
        String groupID = null;
        String accountID = dev.getAccountID();
        Account account = dev.getAccount();
        TimeZone acctTZ = account.getTimeZone(null);
        User user = null;
        try {
            if (StringTools.isBlank((String)userID)) {
                String uid = account.getDefaultUser();
                userID = !StringTools.isBlank((String)uid) ? uid : User.getAdminUserID();
            }
            user = User.getUser(account, userID);
        }
        catch (DBException dbe) {
            Print.logException((String)("Reading User: " + accountID + "/" + userID), (Throwable)dbe);
            user = null;
        }
        TimeZone TZ = user != null ? user.getTimeZone(acctTZ) : acctTZ;
        String encPass = null;
        if (inclPass) {
            encPass = !StringTools.isBlank((String)userID) && user != null ? user.getDecodedPassword(null) : account.getDecodedPassword(null);
        }
        String date_tz = "";
        String date_fr = null;
        String date_to = null;
        if (timestamp > 0L) {
            date_fr = String.valueOf(timestamp - 2L);
            date_to = String.valueOf(timestamp + 2L);
        } else {
            date_fr = "last";
            date_to = "from";
        }
        String r_report = "";
        String r_limit = "";
        String r_limType = "";
        String r_format = "";
        boolean rtpEncode = true;
        return ReportURL.createReportURL(baseURL, rtpEncode, accountID, userID, encPass, deviceID, groupID, date_fr, date_to, date_tz, r_report, r_limit, r_limType, r_format);
    }

    public static URIArg createReportURL(URIArg rptURL, boolean rtpEncode) {
        if (rptURL == null) {
            return null;
        }
        String baseURL = rptURL.getURI();
        RTProperties rtp = rptURL.getArgProperties();
        String accountID = rtp.getString(RPTARG_ACCOUNT, "");
        String userID = rtp.getString(RPTARG_USER, "");
        String encPass = rtp.getString(RPTARG_ENCPASS, "");
        String deviceID = rtp.getString(RPTARG_DEVICE, "");
        String groupID = rtp.getString(RPTARG_GROUP, "");
        String date_fr = rtp.getString(RPTARG_DATE_FR, "");
        String date_to = rtp.getString(RPTARG_DATE_TO, "");
        String date_tz = rtp.getString(RPTARG_DATE_TZ, "");
        String r_report = rtp.getString(RPTARG_REPORT, "");
        String r_limit = rtp.getString(RPTARG_LIMIT, "");
        String r_limType = rtp.getString(RPTARG_LIMIT_TYPE, "");
        String r_format = rtp.getString(RPTARG_FORMAT, "");
        return ReportURL.createReportURL(baseURL, rtpEncode, accountID, userID, encPass, deviceID, groupID, date_fr, date_to, date_tz, r_report, r_limit, r_limType, r_format);
    }

    public static URIArg createReportURL(String baseURL, boolean rtpEncode, String accountID, String userID, String encPass, String deviceID, String groupID, String date_fr, String date_to, String date_tz, String r_report, String r_limit, String r_limType, String r_format) {
        URIArg url = new URIArg(baseURL);
        if (!StringTools.isBlank((String)accountID)) {
            url.addArg(RPTARG_ACCOUNT, accountID);
        }
        if (!StringTools.isBlank((String)userID)) {
            url.addArg(RPTARG_USER, userID);
        }
        if (!StringTools.isBlank((String)encPass) && !encPass.equals("*blank*")) {
            url.addArg(RPTARG_ENCPASS, encPass);
        }
        RTProperties rtp = new RTProperties();
        rtp.setString(PARM_PAGE, PAGE_REPORT_SHOW);
        if (!StringTools.isBlank((String)deviceID)) {
            rtp.removeProperties((Object)RPTARG_DEVICE);
            rtp.setString(RPTARG_DEVICE, deviceID);
        }
        if (!StringTools.isBlank((String)groupID)) {
            rtp.removeProperties((Object)RPTARG_GROUP);
            rtp.setString(RPTARG_GROUP, groupID);
        }
        if (!StringTools.isBlank((String)date_fr)) {
            rtp.removeProperties(RPTARG_DATE_FR);
            rtp.setString(RPTARG_DATE_FR[1], date_fr);
        }
        if (!StringTools.isBlank((String)date_to)) {
            rtp.removeProperties(RPTARG_DATE_TO);
            rtp.setString(RPTARG_DATE_TO[1], date_to);
        }
        if (!StringTools.isBlank((String)date_tz)) {
            rtp.removeProperties(RPTARG_DATE_TO);
            rtp.setString(RPTARG_DATE_TZ[1], date_tz);
        }
        if (!StringTools.isBlank((String)r_report)) {
            rtp.removeProperties(RPTARG_REPORT);
            rtp.setString(RPTARG_REPORT[1], r_report);
        }
        if (!StringTools.isBlank((String)r_limit)) {
            rtp.removeProperties(RPTARG_LIMIT);
            rtp.setString(RPTARG_LIMIT[1], r_limit);
        }
        if (!StringTools.isBlank((String)r_limType)) {
            rtp.removeProperties(RPTARG_LIMIT_TYPE);
            rtp.setString(RPTARG_LIMIT_TYPE[1], r_limType);
        }
        if (!StringTools.isBlank((String)r_format)) {
            rtp.removeProperties(RPTARG_FORMAT);
            rtp.setString(RPTARG_FORMAT[1], r_format);
        }
        Print.logInfo((String)("Report RPT: " + rtp), (Object[])new Object[0]);
        if (rtpEncode) {
            url.addArg(URLARG_RTP, rtp);
        } else {
            Map props = rtp.getProperties();
            for (Object rtk : props.keySet()) {
                Object rtv = props.get(rtk);
                url.addArg((String)rtk, StringTools.trim(rtv));
            }
        }
        return url;
    }

    public static void main(String[] args) {
        RTConfig.setCommandLineArgs((String[])args);
        if (RTConfig.hasProperty((String)"urld")) {
            String urld = RTConfig.getString((String)"urld", (String)"");
            URIArg rtpUrl = new URIArg(urld);
            URIArg decUrl = rtpUrl.rtpDecode(URLARG_RTP);
            Print.sysPrintln((String)("Decoded URL: " + decUrl.toString()), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String)"urle")) {
            String urle = RTConfig.getString((String)"urle", (String)"");
            URIArg decUrl = new URIArg(urle);
            URIArg rtpUrl = decUrl.rtpEncode(URLARG_RTP, new String[]{RPTARG_ACCOUNT, RPTARG_USER});
            Print.sysPrintln((String)("Encoded URL: " + rtpUrl.toString()), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String)"rpturl")) {
            String baseURL = StringTools.blankDefault((String)RTConfig.getString((String)"rpturl", null), (String)".");
            String accountID = RTConfig.getString((String)RPTARG_ACCOUNT, (String)"demo");
            String userID = RTConfig.getString((String)RPTARG_USER, null);
            String deviceID = RTConfig.getString((String)RPTARG_DEVICE, (String)"demo");
            Account account = null;
            Device device = null;
            try {
                account = Account.getAccount(accountID);
                device = Device.getDevice(account, deviceID, false);
                if (device == null) {
                    Print.logError((String)("Account/Device does not exist: " + accountID + "/" + deviceID), (Object[])new Object[0]);
                    System.exit(99);
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Error getting Device: " + accountID + "/" + deviceID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            URIArg url = ReportURL.createEventDetailReportURL(userID, true, device, 0L, baseURL);
            Print.sysPrintln((String)("Report URL : " + url), (Object[])new Object[0]);
            URIArg decUrl = url.rtpDecode(URLARG_RTP);
            Print.sysPrintln((String)("Decoded URL: " + decUrl.toString()), (Object[])new Object[0]);
            System.exit(0);
        }
        String url = RTConfig.getString((String)FORMAT_URL, (String)"");
        String account = RTConfig.getString((String)RPTARG_ACCOUNT, (String)"");
        String user = RTConfig.getString((String)RPTARG_USER, (String)"");
        String encPass = RTConfig.getString((String)RPTARG_ENCPASS, (String)"");
        String device = RTConfig.getString((String)RPTARG_DEVICE, (String)"");
        String group = RTConfig.getString((String)RPTARG_GROUP, (String)"");
        String date_fr = RTConfig.getString((String[])RPTARG_DATE_FR, (String)"");
        String date_to = RTConfig.getString((String[])RPTARG_DATE_TO, (String)"");
        String date_tz = RTConfig.getString((String[])RPTARG_DATE_TZ, (String)"");
        String r_report = RTConfig.getString((String[])RPTARG_REPORT, (String)"");
        String r_limit = RTConfig.getString((String[])RPTARG_LIMIT, (String)"");
        String r_limType = RTConfig.getString((String[])RPTARG_LIMIT_TYPE, (String)"");
        String format = RTConfig.getString((String[])RPTARG_FORMAT, (String)"");
        URIArg rptURL = ReportURL.createReportURL(url, false, account, user, "", device, group, date_fr, date_to, date_tz, r_report, r_limit, r_limType, format);
        Print.logInfo((String)("URL: " + rptURL), (Object[])new Object[0]);
    }

    public static enum Format implements EnumTools.IntValue,
    EnumTools.StringValue
    {
        HTML(0, "html"),
        XML(1, "xml"),
        CSV(2, "csv"),
        XLS(3, "xls"),
        XLSX(4, "xlsx"),
        TXT(5, "txt"),
        SOAP(6, "soapxml"),
        EHTML(7, "ehtml"),
        CUSTOM(8, "custom"),
        SCHEDULE(9, "sched"),
        URL(10, "url"),
        EMAIL(11, "email"),
        CALLBACK(12, "callback"),
        PDF(13, "pdf");

        private int vv = 0;
        private String aa = null;

        private Format(int v, String a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String getStringValue() {
            return this.toString();
        }

        public String toString() {
            return this.aa;
        }
    }
}

