/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opengts.db.DCServerFactory;
import org.opengts.db.GeoEvent;
import org.opengts.db.ParseEvent;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParseEventsXML
implements ParseEvent.ParseEventHandler,
GeoEvent.GeoEventHandler {
    public static boolean DEBUG_MODE = false;
    private static final String TAG_gpx = "gpx";
    private static final String TAG_name = "name";
    private static final String TAG_desc = "desc";
    private static final String TAG_number = "number";
    private static final String TAG_trk = "trk";
    private static final String TAG_trkseg = "trkseg";
    private static final String TAG_trkpt = "trkpt";
    private static final String TAG_ele = "ele";
    private static final String TAG_time = "time";
    private static final String ATTR_version = "version";
    private static final String ATTR_creator = "creator";
    private static final String ATTR_lat = "lat";
    private static final String ATTR_lon = "lon";
    private String accountID = null;
    private String deviceID = null;
    private Account account = null;
    private Device device = null;
    private String[] uniquePrefix = new String[]{"gpx_"};
    private double minSpeedKPH = 0.0;
    private boolean estimateOdom = false;
    private boolean simGeozones = false;
    private double minMovedMeters = 0.0;
    public static String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    public static String[] ARG_DEVICE = new String[]{"device", "dev", "d"};

    public ParseEventsXML() {
    }

    public ParseEventsXML(String accountID, String deviceID) {
        this.setAccountDevice(accountID, deviceID);
    }

    public void setAccountDevice(String accountID, String deviceID) {
        if (!StringTools.isBlank((String)accountID) && !StringTools.isBlank((String)deviceID)) {
            this.accountID = StringTools.trim((String)accountID);
            this.deviceID = StringTools.trim((String)deviceID);
        } else {
            this.accountID = null;
            this.deviceID = null;
        }
        this.account = null;
        this.device = null;
    }

    public boolean hasAccountDevice() {
        return !StringTools.isBlank((String)this.accountID) && !StringTools.isBlank((String)this.deviceID);
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    @Override
    public boolean parseStream(InputStream xmlStream, GeoEvent.GeoEventHandler gevHandler) throws IOException {
        Document xmlDoc = XMLTools.getDocument((InputStream)xmlStream, (boolean)false);
        if (xmlDoc == null) {
            return false;
        }
        Element topElem = xmlDoc.getDocumentElement();
        String topLevelTagName = topElem.getTagName();
        if (topElem.getTagName().equalsIgnoreCase(TAG_gpx)) {
            return this._parse_gpx(topElem, gevHandler);
        }
        Print.logError((String)("XML format not supported: " + topLevelTagName), (Object[])new Object[0]);
        return false;
    }

    public boolean _parse_gpx(Element topElem, GeoEvent.GeoEventHandler gevHandler) {
        String version = XMLTools.getAttribute((Element)topElem, (String)ATTR_version, (String)"");
        String creator = XMLTools.getAttribute((Element)topElem, (String)ATTR_creator, (String)"");
        NodeList trkNodes = XMLTools.getChildElements((Node)topElem, (String)TAG_trk);
        for (int trk = 0; trk < trkNodes.getLength(); ++trk) {
            Element trkTag = (Element)trkNodes.item(trk);
            Element nameTag = XMLTools.getChildElement((Node)trkTag, (String)TAG_name);
            String name = nameTag != null ? XMLTools.getNodeText((Node)nameTag, (String)"") : "";
            Print.logInfo((String)("Track Name: " + name), (Object[])new Object[0]);
            Element descTag = XMLTools.getChildElement((Node)trkTag, (String)TAG_desc);
            String desc = descTag != null ? XMLTools.getNodeText((Node)descTag, (String)"") : "";
            Print.logInfo((String)("Track Descrption: " + desc), (Object[])new Object[0]);
            Element numberTag = XMLTools.getChildElement((Node)trkTag, (String)TAG_number);
            int number = numberTag != null ? StringTools.parseInt((String)XMLTools.getNodeText((Node)numberTag, (String)""), (int)0) : 0;
            Print.logInfo((String)("Track Number: " + number), (Object[])new Object[0]);
            NodeList trksegNodes = XMLTools.getChildElements((Node)trkTag, (String)TAG_trkseg);
            for (int seg = 0; seg < trksegNodes.getLength(); ++seg) {
                Print.logInfo((String)"Parsing Track Segment ...", (Object[])new Object[0]);
                Element trksegTag = (Element)trksegNodes.item(seg);
                NodeList trkptNodes = XMLTools.getChildElements((Node)trksegTag, (String)TAG_trkpt);
                for (int pt = 0; pt < trkptNodes.getLength(); ++pt) {
                    Element trkptTag = (Element)trkptNodes.item(pt);
                    double latitude = XMLTools.getAttributeDouble((Element)trkptTag, (String)ATTR_lat, (double)0.0);
                    double longitude = XMLTools.getAttributeDouble((Element)trkptTag, (String)ATTR_lon, (double)0.0);
                    Element eleTag = XMLTools.getChildElement((Node)trkptTag, (String)TAG_ele);
                    double altitudeM = eleTag != null ? StringTools.parseDouble((String)XMLTools.getNodeText((Node)eleTag, (String)""), (double)0.0) : 0.0;
                    Element timeTag = XMLTools.getChildElement((Node)trkptTag, (String)TAG_time);
                    long timestamp = timeTag != null ? this._parseTime(XMLTools.getNodeText((Node)timeTag, (String)"")) : 0L;
                    this._handleEvent(gevHandler, timestamp, 61472, latitude, longitude, altitudeM);
                }
            }
        }
        return true;
    }

    protected long _parseTime(String timeStr) {
        try {
            DateTime dt = DateTime.parseArgumentDate((String)timeStr);
            return dt.getTimeSec();
        }
        catch (DateTime.DateParseException dpe) {
            Print.logError((String)("Date/Time parsing format error: " + timeStr), (Object[])new Object[0]);
            return 0L;
        }
    }

    protected void _handleEvent(GeoEvent.GeoEventHandler gevHandler, long timestamp, int statusCode, double latitude, double longitude, double altitudeM) {
        if (gevHandler != null) {
            GeoEvent gev = new GeoEvent();
            gev.setAccountID(this.getAccountID());
            gev.setDeviceID(this.getDeviceID());
            gev.setTimestamp(timestamp);
            gev.setStatusCode(statusCode);
            gev.setLatitude(latitude);
            gev.setLongitude(longitude);
            gev.setAltitudeMeters(altitudeM);
            gevHandler.handleGeoEvent(gev);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("[" + new DateTime(timestamp) + "] ");
            sb.append(StringTools.format((double)latitude, (String)"0.00000"));
            sb.append("/");
            sb.append(StringTools.format((double)longitude, (String)"0.00000"));
            sb.append("  ");
            sb.append(StringTools.format((double)altitudeM, (String)"0") + " m");
            Print.logInfo((String)("Point: " + sb), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleGeoEvent(GeoEvent gev) {
        List<Device.GeozoneTransition> zone;
        double odometerKM;
        int statusCode;
        boolean validateMobileID;
        String mobileID;
        String gevDevID;
        String gevAcctID;
        int eventCount;
        block52: {
            eventCount = 0;
            if (gev.hasAccountID() != gev.hasDeviceID()) {
                Print.logError((String)"Missing either Account or Device ID", (Object[])new Object[0]);
                return eventCount;
            }
            if (gev.hasAccountID()) {
                if (!StringTools.isBlank((String)this.accountID) && !this.accountID.equals(gev.getAccountID())) {
                    Print.logError((String)"Mismatched AccountID!", (Object[])new Object[0]);
                    return eventCount;
                }
            } else if (!StringTools.isBlank((String)this.accountID)) {
                gev.setAccountID(this.accountID);
            }
            gevAcctID = gev.getAccountID();
            if (gev.hasDeviceID()) {
                if (!StringTools.isBlank((String)this.deviceID) && !this.deviceID.equals(gev.getDeviceID())) {
                    Print.logError((String)"Mismatched DeviceID!", (Object[])new Object[0]);
                    return eventCount;
                }
            } else if (!StringTools.isBlank((String)this.deviceID)) {
                gev.setDeviceID(this.deviceID);
            }
            gevDevID = gev.getDeviceID();
            mobileID = gev.getMobileID();
            validateMobileID = true;
            if (this.device == null) {
                if (!StringTools.isBlank((String)gevDevID)) {
                    if (this.account == null) {
                        try {
                            this.account = Account.getAccount(gevAcctID);
                            if (this.account == null) {
                                Print.logError((String)("Account-ID does not exist: " + gevAcctID), (Object[])new Object[0]);
                                return eventCount;
                            }
                        }
                        catch (DBException dbe) {
                            Print.logException((String)("Error loading Account: " + gevAcctID), (Throwable)dbe);
                            return eventCount;
                        }
                    }
                    try {
                        this.device = Device.getDevice(this.account, gevDevID, false);
                        if (this.device == null) {
                            Print.logError((String)("Device-ID does not exist: " + gevAcctID + "/" + gevDevID), (Object[])new Object[0]);
                            return eventCount;
                        }
                        break block52;
                    }
                    catch (DBException dbe) {
                        Print.logException((String)("Error loading Device: " + gevAcctID + "/" + gevDevID), (Throwable)dbe);
                        return eventCount;
                    }
                }
                if (!StringTools.isBlank((String)mobileID)) {
                    this.device = DCServerFactory._loadDeviceByPrefixedModemID(this.uniquePrefix, mobileID);
                    if (this.device == null) {
                        return eventCount;
                    }
                    if (this.account == null) {
                        this.account = this.device.getAccount();
                    } else if (this.account.getAccountID().equals(this.device.getAccountID())) {
                        this.device.setAccount(this.account);
                    } else {
                        Print.logError((String)("Device AccountID does not match defined Account: " + this.device.getAccountID()), (Object[])new Object[0]);
                        return eventCount;
                    }
                    validateMobileID = false;
                } else {
                    Print.logError((String)"No Device/Mobile ID defined", (Object[])new Object[0]);
                    return eventCount;
                }
            }
        }
        if (validateMobileID && !StringTools.isBlank((String)mobileID)) {
            boolean match = false;
            String uniqueID = this.device.getUniqueID();
            if (!StringTools.isBlank((String)uniqueID)) {
                for (String pfx : this.uniquePrefix) {
                    if (!uniqueID.equals(pfx + mobileID)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                Print.logError((String)("Unique-ID does not match Device: " + uniqueID), (Object[])new Object[0]);
                return eventCount;
            }
        }
        if (this.account == null) {
            this.account = this.device.getAccount();
        } else if (this.account.getAccountID().equals(this.device.getAccountID())) {
            this.device.setAccount(this.account);
        } else {
            Print.logError((String)("Device AccountID does not match defined Account: " + this.device.getAccountID()), (Object[])new Object[0]);
            return eventCount;
        }
        gev.setAccount(this.account);
        gev.setDevice(this.device);
        long timestamp = gev.getTimestamp();
        if (timestamp <= 0L) {
            Print.logInfo((String)"No valid Timestamp!", (Object[])new Object[0]);
            return eventCount;
        }
        GeoPoint geoPoint = gev.getGeoPoint();
        boolean validGPS = gev.isGeoPointValid();
        if (!gev.hasStatusCode()) {
            statusCode = 61472;
            gev.setStatusCode(statusCode);
        } else {
            statusCode = gev.getStatusCode();
            if (statusCode <= 0) {
                Print.logInfo((String)"No valid StatusCode!", (Object[])new Object[0]);
                return eventCount;
            }
        }
        if (!validGPS || gev.getSpeedKPH() < this.minSpeedKPH) {
            gev.setSpeedKPH(0.0);
            gev.setHeading(0.0);
        }
        double d = odometerKM = gev.hasOdometerKM() ? gev.getOdometerKM() : 0.0;
        if (this.device != null) {
            odometerKM = odometerKM <= 0.0 ? (this.estimateOdom && validGPS ? this.device.getNextOdometerKM(geoPoint) : this.device.getLastOdometerKM()) : this.device.adjustOdometerKM(odometerKM);
            gev.setOdometerKM(odometerKM);
        }
        if (this.simGeozones && validGPS && this.device != null && (zone = this.device.checkGeozoneTransitions(timestamp, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                GeoEvent zoneEv = new GeoEvent(gev);
                zoneEv.setTimestamp(z.getTimestamp());
                zoneEv.setStatusCode(z.getStatusCode());
                zoneEv.setGeozoneID(z.getGeozoneID());
                zoneEv.setGeozone(z.getGeozone());
                if (this.insertEventRecord(zoneEv)) {
                    ++eventCount;
                }
                Print.logInfo((String)("Geozone    : " + z), (Object[])new Object[0]);
            }
        }
        if (statusCode != 61472 || !validGPS) {
            if (this.insertEventRecord(gev)) {
                ++eventCount;
            }
        } else if ((this.device == null || !this.device.isNearLastValidLocation(geoPoint, this.minMovedMeters)) && this.insertEventRecord(gev)) {
            ++eventCount;
        }
        if (!DEBUG_MODE) {
            try {
                if (this.device != null) {
                    this.device.updateChangedEventFields();
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Unable to update Device: " + gevAcctID + "/" + gevDevID), (Throwable)dbe);
            }
        }
        return eventCount;
    }

    protected boolean insertEventRecord(GeoEvent gev) {
        Print.logInfo((String)("GeoEvent: " + gev), (Object[])new Object[0]);
        if (DEBUG_MODE) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ParseEventsXML gevHandler;
        ParseEventsXML pgx;
        RTConfig.setCommandLineArgs((String[])args);
        File xmlFile = RTConfig.getFile((String)"file", null);
        if (xmlFile == null) {
            Print.sysPrintln((String)"Missing '-file' specification", (Object[])new Object[0]);
            System.exit(1);
        }
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, null);
        String devID = RTConfig.getString((String[])ARG_DEVICE, null);
        if (!StringTools.isBlank((String)acctID) && !StringTools.isBlank((String)devID)) {
            gevHandler = pgx = new ParseEventsXML(acctID, devID);
        } else {
            pgx = new ParseEventsXML();
            gevHandler = null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(xmlFile);
            pgx.parseStream(fis, gevHandler);
        }
        catch (IOException ioe) {
            Print.logException((String)"IO Error", (Throwable)ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
        }
    }
}

