/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.GeoEvent;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBAdmin;
import org.opengts.dbtools.DBException;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class ParseEvent
implements GeoEvent.GeoEventHandler {
    public static boolean DEBUG_MODE = false;
    private ParseEventHandler parseHandler = null;
    private String accountID = null;
    private String deviceID = null;
    private DCServerConfig dcserver = null;
    private String[] uniquePrefix = new String[]{""};
    private double minSpeedKPH = 0.0;
    private boolean estimateOdom = false;
    private boolean simGeozones = false;
    private double minMovedMeters = 0.0;
    private Account account = null;
    private Device device = null;
    private static String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    private static String[] ARG_DEVICE = new String[]{"device", "dev", "d"};
    private static String[] ARG_FORMAT = new String[]{"format", "fmt"};
    private static String[] ARG_DCS = new String[]{"dcserver", "dcs"};
    private static String[] ARG_FILE = new String[]{"file"};

    public ParseEvent(DCServerConfig dcserver, ParseEventHandler parseHandler, String accountID, String deviceID) {
        this.parseHandler = parseHandler;
        this.accountID = accountID;
        this.account = null;
        this.deviceID = !StringTools.isBlank((String)this.accountID) ? deviceID : null;
        this.device = null;
        this.dcserver = dcserver;
        if (this.dcserver != null) {
            this.uniquePrefix = this.dcserver.getUniquePrefix();
            this.minSpeedKPH = this.dcserver.getMinimumSpeedKPH(0.0);
            this.estimateOdom = this.dcserver.getEstimateOdometer(false);
            this.simGeozones = this.dcserver.getSimulateGeozones(false);
            this.minMovedMeters = this.dcserver.getMinimumMovedMeters(0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(File parseFile) {
        if (this.parseHandler == null) {
            return false;
        }
        if (parseFile != null) {
            boolean rtn = false;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(parseFile);
                rtn = this.parseHandler.parseStream(fis, this);
            }
            catch (IOException ioe) {
                Print.logException((String)"IO Error", (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable th) {}
                }
            }
            return rtn;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleGeoEvent(GeoEvent gev) {
        List<Device.GeozoneTransition> zone;
        double odometerKM;
        int statusCode;
        boolean validateMobileID;
        String mobileID;
        String gevDevID;
        String gevAcctID;
        int eventCount;
        block52: {
            eventCount = 0;
            if (gev.hasAccountID() != gev.hasDeviceID()) {
                Print.logError((String)"Missing either Account or Device ID", (Object[])new Object[0]);
                return eventCount;
            }
            if (gev.hasAccountID()) {
                if (!StringTools.isBlank((String)this.accountID) && !this.accountID.equals(gev.getAccountID())) {
                    Print.logError((String)"Mismatched AccountID!", (Object[])new Object[0]);
                    return eventCount;
                }
            } else if (!StringTools.isBlank((String)this.accountID)) {
                gev.setAccountID(this.accountID);
            }
            gevAcctID = gev.getAccountID();
            if (gev.hasDeviceID()) {
                if (!StringTools.isBlank((String)this.deviceID) && !this.deviceID.equals(gev.getDeviceID())) {
                    Print.logError((String)"Mismatched DeviceID!", (Object[])new Object[0]);
                    return eventCount;
                }
            } else if (!StringTools.isBlank((String)this.deviceID)) {
                gev.setDeviceID(this.deviceID);
            }
            gevDevID = gev.getDeviceID();
            mobileID = gev.getMobileID();
            validateMobileID = true;
            if (this.device == null) {
                if (!StringTools.isBlank((String)gevDevID)) {
                    if (this.account == null) {
                        try {
                            this.account = Account.getAccount(gevAcctID);
                            if (this.account == null) {
                                Print.logError((String)("Account-ID does not exist: " + gevAcctID), (Object[])new Object[0]);
                                return eventCount;
                            }
                        }
                        catch (DBException dbe) {
                            Print.logException((String)("Error loading Account: " + gevAcctID), (Throwable)dbe);
                            return eventCount;
                        }
                    }
                    try {
                        this.device = Device.getDevice(this.account, gevDevID, false);
                        if (this.device == null) {
                            Print.logError((String)("Device-ID does not exist: " + gevAcctID + "/" + gevDevID), (Object[])new Object[0]);
                            return eventCount;
                        }
                        break block52;
                    }
                    catch (DBException dbe) {
                        Print.logException((String)("Error loading Device: " + gevAcctID + "/" + gevDevID), (Throwable)dbe);
                        return eventCount;
                    }
                }
                if (!StringTools.isBlank((String)mobileID)) {
                    this.device = DCServerFactory._loadDeviceByPrefixedModemID(this.uniquePrefix, mobileID);
                    if (this.device == null) {
                        return eventCount;
                    }
                    if (this.account == null) {
                        this.account = this.device.getAccount();
                    } else if (this.account.getAccountID().equals(this.device.getAccountID())) {
                        this.device.setAccount(this.account);
                    } else {
                        Print.logError((String)("Device AccountID does not match defined Account: " + this.device.getAccountID()), (Object[])new Object[0]);
                        return eventCount;
                    }
                    validateMobileID = false;
                } else {
                    Print.logError((String)"No Device/Mobile ID defined", (Object[])new Object[0]);
                    return eventCount;
                }
            }
        }
        if (validateMobileID && !StringTools.isBlank((String)mobileID)) {
            boolean match = false;
            String uniqueID = this.device.getUniqueID();
            if (!StringTools.isBlank((String)uniqueID)) {
                for (String pfx : this.uniquePrefix) {
                    if (!uniqueID.equals(pfx + mobileID)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                Print.logError((String)("Unique-ID does not match Device: " + uniqueID), (Object[])new Object[0]);
                return eventCount;
            }
        }
        if (this.account == null) {
            this.account = this.device.getAccount();
        } else if (this.account.getAccountID().equals(this.device.getAccountID())) {
            this.device.setAccount(this.account);
        } else {
            Print.logError((String)("Device AccountID does not match defined Account: " + this.device.getAccountID()), (Object[])new Object[0]);
            return eventCount;
        }
        gev.setAccount(this.account);
        gev.setDevice(this.device);
        long timestamp = gev.getTimestamp();
        if (timestamp <= 0L) {
            Print.logInfo((String)"No valid Timestamp!", (Object[])new Object[0]);
            return eventCount;
        }
        GeoPoint geoPoint = gev.getGeoPoint();
        boolean validGPS = gev.isGeoPointValid();
        if (!gev.hasStatusCode()) {
            statusCode = 61472;
            gev.setStatusCode(statusCode);
        } else {
            statusCode = gev.getStatusCode();
            if (statusCode <= 0) {
                Print.logInfo((String)"No valid StatusCode!", (Object[])new Object[0]);
                return eventCount;
            }
        }
        if (!validGPS || gev.getSpeedKPH() < this.minSpeedKPH) {
            gev.setSpeedKPH(0.0);
            gev.setHeading(0.0);
        }
        double d = odometerKM = gev.hasOdometerKM() ? gev.getOdometerKM() : 0.0;
        if (this.device != null) {
            odometerKM = odometerKM <= 0.0 ? (this.estimateOdom && validGPS ? this.device.getNextOdometerKM(geoPoint) : this.device.getLastOdometerKM()) : this.device.adjustOdometerKM(odometerKM);
            gev.setOdometerKM(odometerKM);
        }
        if (this.simGeozones && validGPS && this.device != null && (zone = this.device.checkGeozoneTransitions(timestamp, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                GeoEvent zoneEv = new GeoEvent(gev);
                zoneEv.setTimestamp(z.getTimestamp());
                zoneEv.setStatusCode(z.getStatusCode());
                zoneEv.setGeozoneID(z.getGeozoneID());
                zoneEv.setGeozone(z.getGeozone());
                if (this.insertEventRecord(zoneEv)) {
                    ++eventCount;
                }
                Print.logInfo((String)("Geozone    : " + z), (Object[])new Object[0]);
            }
        }
        if (statusCode != 61472 || !validGPS) {
            if (this.insertEventRecord(gev)) {
                ++eventCount;
            }
        } else if ((this.device == null || !this.device.isNearLastValidLocation(geoPoint, this.minMovedMeters)) && this.insertEventRecord(gev)) {
            ++eventCount;
        }
        if (!DEBUG_MODE) {
            try {
                if (this.device != null) {
                    this.device.updateChangedEventFields();
                }
            }
            catch (DBException dbe) {
                Print.logException((String)("Unable to update Device: " + gevAcctID + "/" + gevDevID), (Throwable)dbe);
            }
        }
        return eventCount;
    }

    protected boolean insertEventRecord(GeoEvent gev) {
        Print.logInfo((String)("GeoEvent: " + gev), (Object[])new Object[0]);
        if (DEBUG_MODE) {
            return false;
        }
        return false;
    }

    private static void usage() {
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + ParseEvent.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>   Acount ID which owns Device", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -device=<id>    Device ID to which parsed events will be inserted", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -format=<class> The format handler class", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -dcs=<name>     The format handler class", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -file=<file>    The file to parse", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, null);
        String deviceID = RTConfig.getString((String[])ARG_DEVICE, null);
        Class fmtClass = RTConfig.getClass((String[])ARG_FORMAT, null);
        File parseFile = RTConfig.getFile((String[])ARG_FILE, null);
        String dcsName = RTConfig.getString((String[])ARG_DCS, null);
        DCServerConfig dcsc = null;
        if (!StringTools.isBlank((String)dcsName) && (dcsc = DCServerFactory.getServerConfig(dcsName)) == null) {
            Print.logError((String)("Specified DCServerConfig not found: " + dcsName), (Object[])new Object[0]);
            System.exit(99);
        }
        if (fmtClass == null) {
            Print.sysPrintln((String)("ERROR: Format class not specified or not found: " + RTConfig.getString((String[])ARG_FORMAT, null)), (Object[])new Object[0]);
            System.exit(99);
        }
        ParseEventHandler parseHandler = null;
        try {
            parseHandler = (ParseEventHandler)fmtClass.newInstance();
        }
        catch (Throwable th) {
            Print.sysPrintln((String)("ERROR: Unable to create a new instance: " + th), (Object[])new Object[0]);
            System.exit(99);
        }
        if (parseFile == null) {
            Print.sysPrintln((String)"ERROR: File not specified", (Object[])new Object[0]);
            System.exit(99);
        } else if (!parseFile.isFile()) {
            Print.sysPrintln((String)("ERROR: File does not exist - " + parseFile), (Object[])new Object[0]);
            System.exit(99);
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.sysPrintln((String)"ERROR: MySQL database has not yet been properly initialized", (Object[])new Object[0]);
            System.exit(99);
        }
        ParseEvent pf = new ParseEvent(dcsc, parseHandler, accountID, deviceID);
        pf.parse(parseFile);
    }

    public static interface ParseEventHandler {
        public boolean parseStream(InputStream var1, GeoEvent.GeoEventHandler var2) throws IOException;
    }
}

