/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.sql.ResultSet;
import java.sql.Statement;
import org.opengts.db.AccountRecord;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.StringTools;
import org.opengts.util.TreeNode;

public abstract class HierarchyRecord<RT extends DBRecord>
extends AccountRecord<RT> {
    public static final String HIERARCHY_SEPARATOR = "/";
    public static final char HIERARCHY_SEPARATOR_CHAR = '/';
    public static final String TYPE_HIER_KEY = DBField.TYPE_STRING((int)250);
    public static final String TYPE_ITEM_ID = DBField.TYPE_STRING((int)32);
    public static final String FLD_hierarchyKey = "hierarchyKey";
    public static final String FLD_level = "level";

    protected static DBField newField_hierarchyKey(boolean key) {
        return HierarchyRecord.newField_hierarchyKey(key, null);
    }

    protected static DBField newField_hierarchyKey(boolean key, String xAttr) {
        String attr = (key ? "key=true" : "edit=2") + (StringTools.isBlank((String)xAttr) ? "" : " " + xAttr);
        return new DBField(FLD_hierarchyKey, String.class, TYPE_HIER_KEY, "Hierarchy Key", attr);
    }

    public HierarchyRecord() {
    }

    public HierarchyRecord(HierarchyKey<RT> key) {
        super(key);
    }

    public String getHierarchyKey() {
        String v = (String)this.getKeyValue(FLD_hierarchyKey);
        return v != null ? v : "";
    }

    public void setHierarchyKey(String v) {
        this.setKeyValue(FLD_hierarchyKey, v != null ? v : "");
    }

    public String[] getHierarchy() {
        String hk = this.getHierarchyKey();
        return StringTools.split((String)hk, (char)'/');
    }

    public void setHierarchy(String[] h) {
        String hk = StringTools.join((String[])h, (char)'/');
        this.setHierarchyKey(hk);
    }

    public int getLevel() {
        Integer v = (Integer)this.getFieldValue(FLD_level);
        return v != null ? v : 0;
    }

    public void setLevel(int v) {
        this.setFieldValue(FLD_level, v);
    }

    public abstract String getItemID();

    public abstract void setItemID(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <RT extends HierarchyRecord> TreeNode readHiearchy(DBFactory<RT> dbFact, Account acct) throws DBException {
        if (acct == null) {
            return null;
        }
        String acctID = acct.getAccountID();
        final TreeNode parent = new TreeNode(acctID);
        DBRecordHandler hierRH = new DBRecordHandler<RT>(){

            public int handleDBRecord(RT rcd) throws DBException {
                String itemID;
                Object hr = rcd;
                String hierKey = ((HierarchyRecord)((Object)hr)).getHierarchyKey();
                TreeNode itemParent = parent;
                if (!StringTools.isBlank((String)hierKey)) {
                    String[] hier = StringTools.split((String)hierKey, (char)'/');
                    itemParent = TreeNode.createTreePath((TreeNode)itemParent, (String[])hier);
                    itemParent.setDescription(hr.getDescription());
                }
                if (!StringTools.isBlank((String)(itemID = ((HierarchyRecord)((Object)hr)).getItemID()))) {
                    TreeNode leaf = new TreeNode(itemID);
                    leaf.setDescription(hr.getDescription());
                    leaf.setObject(hr);
                    itemParent.addChild(leaf);
                }
                return 1;
            }
        };
        DBSelect hsel = new DBSelect(dbFact);
        DBWhere hwh = hsel.createDBWhere();
        hsel.setWhere(hwh.WHERE(hwh.EQ("accountID", (Object)acctID)));
        hsel.setOrderByFields(new String[]{FLD_hierarchyKey});
        Statement stmt = null;
        ResultSet rs = null;
        try {
            DBRecord.select((DBSelect)hsel, (DBRecordHandler)hierRH);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
        }
        return parent;
    }

    public static abstract class HierarchyKey<RT extends DBRecord>
    extends AccountRecord.AccountKey<RT> {
    }
}

