/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import org.opengts.db.AccountRecord;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class GroupRecord<RT extends DBRecord>
extends AccountRecord<RT> {
    public static final String FLD_groupID = "groupID";
    private DeviceGroup group = null;
    private String groupDesc = null;

    public static DBField newField_groupID(boolean key) {
        return GroupRecord.newField_groupID(key, "Device Group ID");
    }

    public static DBField newField_groupID(boolean key, String title) {
        return new DBField(FLD_groupID, String.class, DBField.TYPE_GROUP_ID(), title, key ? "key=true" : "edit=2");
    }

    public GroupRecord() {
    }

    public GroupRecord(GroupKey<RT> key) {
        super(key);
    }

    public final String getGroupID() {
        String v = (String)this.getKeyValue(FLD_groupID);
        return StringTools.trim((String)v);
    }

    public void setGroupID(String v) {
        this.setKeyValue(FLD_groupID, StringTools.trim((String)v));
    }

    public final boolean hasGroup() {
        return this.group != null;
    }

    public final DeviceGroup getDeviceGroup() {
        if (this.group == null) {
            String groupID = this.getGroupID();
            Print.logDebug((String)("[Optimize] Retrieving Device Group record: " + groupID), (Object[])new Object[0]);
            try {
                this.group = DeviceGroup.getDeviceGroup(this.getAccount(), groupID);
            }
            catch (DBException dbe) {
                Print.logError((String)("Group not found: " + this.getAccountID() + "/" + groupID), (Object[])new Object[0]);
                this.group = null;
            }
        }
        return this.group;
    }

    public final void setDeviceGroup(DeviceGroup grp) {
        if (grp != null && grp.getAccountID().equals(this.getAccountID()) && grp.getGroupID().equals(this.getGroupID())) {
            this.setAccount(grp.getAccount());
            this.group = grp;
        } else {
            this.group = null;
        }
    }

    public final String getGroupDescription() {
        if (this.groupDesc == null) {
            DeviceGroup grp = this.getDeviceGroup();
            this.groupDesc = grp != null ? grp.getDescription() : this.getGroupID();
        }
        return this.groupDesc;
    }

    public static abstract class GroupKey<RT extends DBRecord>
    extends AccountRecord.AccountKey<RT> {
    }
}

