/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class GoogleKML {
    public static final String PROP_GoogleKML_lastPushpinID = "googleKML.lastPushpinID";
    private static final String STYLE_LAST = "StyleLast";
    private static final String STYLE_DEFAULT = "StyleDefault";
    private static final String STYLE_MOVING = "StyleMoving";
    private static final String STYLE_MOVING_LAST = "StyleMovingLast";
    private static final String STYLE_STOPPED = "StyleStopped";
    private static final String STYLE_STOPPED_LAST = "StyleStoppedLast";
    private static final String STYLE_SLOW = "StyleSlow";
    private static final String STYLE_SLOW_LAST = "StyleSlowLast";
    private static final String GOOGLE_ICON_URL = GoogleKML.GooglePushpinBase();
    private static final GooglePP PUSHPIN_BLACK = new GooglePP("black", GOOGLE_ICON_URL, "mm_20_black.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_BROWN = new GooglePP("brown", GOOGLE_ICON_URL, "mm_20_brown.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_RED = new GooglePP("red", GOOGLE_ICON_URL, "mm_20_red.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_ORANGE = new GooglePP("orange", GOOGLE_ICON_URL, "mm_20_orange.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_YELLOW = new GooglePP("yellow", GOOGLE_ICON_URL, "mm_20_yellow.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_GREEN = new GooglePP("green", GOOGLE_ICON_URL, "mm_20_green.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_BLUE = new GooglePP("blue", GOOGLE_ICON_URL, "mm_20_blue.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_PURPLE = new GooglePP("purple", GOOGLE_ICON_URL, "mm_20_purple.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_GRAY = new GooglePP("gray", GOOGLE_ICON_URL, "mm_20_gray.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_WHITE = new GooglePP("white", GOOGLE_ICON_URL, "mm_20_white.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_BLACK_LAST = new GooglePP("black.last", GOOGLE_ICON_URL, "mm_20_black.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_BROWN_LAST = new GooglePP("brown.last", GOOGLE_ICON_URL, "mm_20_brown.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_RED_LAST = new GooglePP("red.last", GOOGLE_ICON_URL, "mm_20_red.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_ORANGE_LAST = new GooglePP("orange.last", GOOGLE_ICON_URL, "mm_20_orange.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_YELLOW_LAST = new GooglePP("yellow.last", GOOGLE_ICON_URL, "mm_20_yellow.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_GREEN_LAST = new GooglePP("green.last", GOOGLE_ICON_URL, "mm_20_green.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_BLUE_LAST = new GooglePP("blue.last", GOOGLE_ICON_URL, "mm_20_blue.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_PURPLE_LAST = new GooglePP("purple.last", GOOGLE_ICON_URL, "mm_20_purple.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_GRAY_LAST = new GooglePP("gray.last", GOOGLE_ICON_URL, "mm_20_gray.png", 0.8, 6, 20);
    private static final GooglePP PUSHPIN_WHITE_LAST = new GooglePP("white.last", GOOGLE_ICON_URL, "mm_20_white.png", 0.8, 6, 20);
    private static final GooglePP[] GooglePushpins = new GooglePP[]{PUSHPIN_BLACK, PUSHPIN_BROWN, PUSHPIN_RED, PUSHPIN_ORANGE, PUSHPIN_YELLOW, PUSHPIN_GREEN, PUSHPIN_BLUE, PUSHPIN_PURPLE, PUSHPIN_GRAY, PUSHPIN_WHITE, PUSHPIN_BLACK_LAST, PUSHPIN_BROWN_LAST, PUSHPIN_RED_LAST, PUSHPIN_ORANGE_LAST, PUSHPIN_YELLOW_LAST, PUSHPIN_GREEN_LAST, PUSHPIN_BLUE_LAST, PUSHPIN_PURPLE_LAST, PUSHPIN_GRAY_LAST, PUSHPIN_WHITE_LAST};
    private static final Map<String, GooglePP> GooglePushpinMap = new HashMap<String, GooglePP>();
    private static final String XML_Header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.0\">\n<Document>\n";
    private static final String XML_Footer = "</Document>\n</kml>\n";
    private static final String XML_RouteStyle = "<Style id=\"StyleRoute\">\n  <LineStyle id=\"StyleRouteLine\">\n    <color>880000FF</color>\n    <width>4</width>\n  </LineStyle>\n  <PolyStyle id=\"StyleRoutePoly\">\n    <color>880000FF</color>\n  </PolyStyle>\n</Style>\n";
    private static final String XML_IconStyle = "<Style id=\"${styleName}\">\n  <BalloonStyle id=\"${styleName}Balloon\">\n    <text><![CDATA[<b>$[name]</b><br/><br/>$[description]]]></text>\n  </BalloonStyle>\n  <IconStyle id=\"${styleName}Icon\">\n    <color>FFFFFFFF</color>\n    <scale>${iconScale}</scale>\n    <Icon><href>${iconURL}</href></Icon>\n    <hotSpot x=\"${iconOfsX}\" y=\"${iconOfsY}\" xunits=\"pixels\" yunits=\"insetPixels\"/>\n  </IconStyle>\n  <LabelStyle id=\"${styleName}Label\">\n    <color>FFFFFFFF</color>\n    <scale>0.80</scale>\n  </LabelStyle>\n</Style>\n";
    private static GoogleKML instance;

    private static double MPH(double kph) {
        return kph * 0.621371192237334;
    }

    public static String GooglePushpinBase() {
        return RTConfig.getString((String)"GoogleKML.pushpinBaseURL", (String)"http://labs.google.com/ridefinder/images/");
    }

    public static GooglePP getGooglePushpin(String name) {
        GooglePP gpp = GooglePushpinMap.get(name);
        return gpp != null ? gpp : PUSHPIN_GREEN;
    }

    public static GoogleKML getInstance() {
        if (instance == null) {
            instance = new GoogleKML();
        }
        return instance;
    }

    private GoogleKML() {
    }

    private String _createStyle(final String name, final GooglePP icon) {
        return StringTools.replaceKeys((String)XML_IconStyle, (StringTools.KeyValueMap)new StringTools.KeyValueMap(){

            public String getKeyValue(String key, String arg, String dft) {
                if (key.equalsIgnoreCase("styleName")) {
                    return name;
                }
                return icon.getKeyValue(key, arg, dft);
            }
        });
    }

    private void _writeRoute(PrintWriter out, I18N i18n, BasicPrivateLabel privLabel, String deviceDesc, List<String> route, int indent) throws IOException {
        String tab = StringTools.replicateString((String)" ", (int)indent);
        out.write(tab + "<Placemark>\n");
        out.write(tab + "   <name>Route</name>\n");
        out.write(tab + "   <description><![CDATA[" + deviceDesc + "]]></description>\n");
        out.write(tab + "   <styleUrl>#StyleRoute</styleUrl>\n");
        out.write(tab + "   <LineString>\n");
        out.write(tab + "      <!-- <extrude>1</extrude> -->\n");
        out.write(tab + "      <!-- <tessellate>1</tessellate> -->\n");
        out.write(tab + "      <!-- <altitudeMode>absolute</altitudeMode> -->\n");
        out.write(tab + "      <coordinates>\n");
        for (String c : route) {
            out.write(tab + "         " + c + "\n");
        }
        out.write(tab + "      </coordinates>\n");
        out.write(tab + "   </LineString>\n");
        out.write(tab + "</Placemark>\n");
    }

    private String _writePlacemark(PrintWriter out, I18N i18n, BasicPrivateLabel privLabel, EventData ev, boolean isLast, boolean useLastPP, int indent) throws IOException {
        Account account = ev.getAccount();
        Device device = ev.getDevice();
        TimeZone tz = account.getTimeZone(null);
        String tab = StringTools.replicateString((String)" ", (int)indent);
        Locale locale = i18n.getLocale();
        String datStr = ev.getTimestampString(privLabel);
        int code = ev.getStatusCode();
        String codStr = ev.getStatusCodeDescription(privLabel);
        GeoPoint gp = ev.getGeoPoint();
        String deviceID = ev.getDeviceID();
        String address = ev.getAddress();
        String latStr = gp.getLatitudeString("5", null);
        String lonStr = gp.getLongitudeString("5", null);
        double odomKM = ev.getOdometerWithOffsetKM();
        String odomStr = account.getDistanceString(odomKM, true, locale);
        double speedKPH = ev.getSpeedKPH();
        String spdStr = account.getSpeedString(speedKPH, "#0.0", true, locale);
        double heading = ev.getHeading();
        String headStr = GeoPoint.GetHeadingString((double)heading, (Locale)locale);
        double altM = ev.getAltitude();
        String altStr = Account.getDistanceUnits(account).equals((Object)Account.DistanceUnits.MILES) ? Math.round(altM * 3.280839895013123) + " Feet" : Math.round(altM) + " Meters";
        out.write(tab + "<Placemark>\n");
        out.write(tab + "  <name>" + deviceID + "</name>\n");
        out.write(tab + "  <description><![CDATA[");
        out.write("Status : <strong>" + codStr + "</strong><br>");
        out.write("Date : <strong>" + datStr + "</strong><br>");
        if (!StringTools.isBlank((String)address)) {
            out.write("Address : <strong>" + address + "</strong><br>");
        }
        out.write("Speed : <strong>" + spdStr + " " + headStr + "</strong><br>");
        out.write("GPS : <strong>" + latStr + " " + lonStr + "</strong><br>");
        out.write("Altitude : <strong>" + altStr + "</strong><br>");
        if (odomKM > 0.0) {
            out.write("Odometer : <strong>" + odomStr + "</strong>");
        }
        out.write("]]></description>\n");
        String style = STYLE_DEFAULT;
        if (isLast && useLastPP) {
            style = STYLE_LAST;
        } else {
            switch (code) {
                case 61713: 
                case 61714: 
                case 61715: 
                case 61724: {
                    if (GoogleKML.MPH(speedKPH) > 20.0) {
                        style = isLast ? STYLE_MOVING_LAST : STYLE_MOVING;
                        break;
                    }
                    if (GoogleKML.MPH(speedKPH) > 5.0) {
                        style = isLast ? STYLE_SLOW_LAST : STYLE_SLOW;
                        break;
                    }
                    style = isLast ? STYLE_STOPPED_LAST : STYLE_STOPPED;
                    break;
                }
                default: {
                    style = STYLE_DEFAULT;
                }
            }
        }
        out.write(tab + "  <styleUrl>#" + style + "</styleUrl>\n");
        String gpsPoint = lonStr + "," + latStr + "," + Math.round(altM);
        out.write(tab + "  <Point><coordinates>" + gpsPoint + "</coordinates></Point>\n");
        out.write(tab + "</Placemark>\n");
        return gpsPoint;
    }

    public boolean writeEvents(PrintWriter out, Account account, Collection<Device> devList, BasicPrivateLabel privLabel) throws IOException {
        String lastPP;
        if (account == null) {
            return false;
        }
        String accountID = account.getAccountID();
        TimeZone tz = account.getTimeZone(null);
        I18N i18n = privLabel != null ? privLabel.getI18N(GoogleKML.class) : I18N.getI18N(GoogleKML.class, null);
        out.write(XML_Header);
        out.write(XML_RouteStyle);
        out.write(this._createStyle(STYLE_DEFAULT, GoogleKML.getGooglePushpin("green")));
        out.write(this._createStyle(STYLE_MOVING, GoogleKML.getGooglePushpin("green")));
        out.write(this._createStyle(STYLE_MOVING_LAST, GoogleKML.getGooglePushpin("green.last")));
        out.write(this._createStyle(STYLE_STOPPED, GoogleKML.getGooglePushpin("red")));
        out.write(this._createStyle(STYLE_STOPPED_LAST, GoogleKML.getGooglePushpin("red.last")));
        out.write(this._createStyle(STYLE_SLOW, GoogleKML.getGooglePushpin("yellow")));
        out.write(this._createStyle(STYLE_SLOW_LAST, GoogleKML.getGooglePushpin("yellow.last")));
        boolean useLastPP = false;
        String string = lastPP = privLabel != null ? privLabel.getStringProperty(PROP_GoogleKML_lastPushpinID, null) : null;
        if (!StringTools.isBlank((String)lastPP) && GooglePushpinMap.containsKey(lastPP)) {
            out.write(this._createStyle(STYLE_LAST, GoogleKML.getGooglePushpin(lastPP)));
            useLastPP = true;
        }
        if (!ListTools.isEmpty(devList)) {
            Vector<String> routeList = new Vector<String>();
            for (Device dev : devList) {
                String deviceID = dev.getDeviceID();
                routeList.clear();
                if (!dev.getAccountID().equals(accountID)) continue;
                Object[] evList = dev.getSavedRangeEvents();
                if (!ListTools.isEmpty((Object[])evList)) {
                    for (int e = 0; e < evList.length; ++e) {
                        boolean isLast;
                        Object ev = evList[e];
                        boolean bl = isLast = e == evList.length - 1;
                        if (!((AccountRecord)((Object)ev)).getAccountID().equals(accountID)) continue;
                        ((AccountRecord)((Object)ev)).setAccount(account);
                        String pc = this._writePlacemark(out, i18n, privLabel, (EventData)ev, isLast, useLastPP, 4);
                        routeList.add(pc);
                    }
                }
                if (routeList.size() <= 1) continue;
                this._writeRoute(out, i18n, privLabel, deviceID, routeList, 4);
            }
        }
        out.write(XML_Footer);
        out.flush();
        return true;
    }

    static {
        for (GooglePP gpp : GooglePushpins) {
            GooglePushpinMap.put(gpp.getName(), gpp);
        }
        instance = null;
        GoogleKML.getInstance();
    }

    private static class GooglePP
    implements StringTools.KeyValueMap {
        private String name = null;
        private String url = null;
        private double scale = 1.0;
        private int xOfs = 0;
        private int yOfs = 0;

        public GooglePP(String name, String baseURL, String url, double scale, int xOfs, int yOfs) {
            this.name = name;
            this.url = baseURL + url;
            this.scale = scale;
            this.xOfs = xOfs;
            this.yOfs = yOfs;
        }

        public String getName() {
            return this.name;
        }

        public String getURL() {
            return !StringTools.isBlank((String)this.url) ? this.url : GOOGLE_ICON_URL;
        }

        public double getScale() {
            return this.scale;
        }

        public int getOffset_X() {
            return this.xOfs;
        }

        public int getOffset_Y() {
            return this.yOfs;
        }

        public String getKeyValue(String key, String arg, String dft) {
            if (key.equalsIgnoreCase("iconOfsX")) {
                return String.valueOf(this.getOffset_X());
            }
            if (key.equalsIgnoreCase("iconOfsY")) {
                return String.valueOf(this.getOffset_Y());
            }
            if (key.equalsIgnoreCase("iconScale")) {
                return String.valueOf(this.getScale());
            }
            if (key.equalsIgnoreCase("iconURL")) {
                return this.getURL();
            }
            return dft;
        }
    }
}

