/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Geozone;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.StringTools;

public class GeoEvent
implements Cloneable,
GeoPointProvider {
    public static final String KEY_mobileID = "mobileID";
    public static final String KEY_accountID = "accountID";
    public static final String KEY_account = "account";
    public static final String KEY_deviceID = "deviceID";
    public static final String KEY_device = "device";
    public static final String KEY_geozoneID = "geozoneID";
    public static final String KEY_geozone = "geozone";
    public static final String KEY_timestamp = "timestamp";
    public static final String KEY_statusCode = "statusCode";
    public static final String KEY_latitude = "latitude";
    public static final String KEY_longitude = "longitude";
    public static final String KEY_geoPoint = "geoPoint";
    public static final String KEY_speedKPH = "speedKPH";
    public static final String KEY_heading = "heading";
    public static final String KEY_altitude = "altitude";
    public static final String KEY_odometerKM = "odometerKM";
    private Map<String, Object> fieldValues = new HashMap<String, Object>();

    public GeoEvent() {
    }

    public GeoEvent(GeoEvent other) {
        this();
        if (other != null) {
            this.fieldValues.putAll(other.getFieldValues());
        }
    }

    public Object clone() {
        return new GeoEvent(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[" + new DateTime(this.getTimestamp()) + "] ");
        sb.append(StringTools.format((double)this.getLatitude(), (String)"0.00000"));
        sb.append("/");
        sb.append(StringTools.format((double)this.getLongitude(), (String)"0.00000"));
        sb.append("  ");
        sb.append(StringTools.format((double)this.getAltitudeMeters(), (String)"0") + " m");
        return sb.toString();
    }

    public Set<String> getFieldKeys() {
        return this.fieldValues.keySet();
    }

    public Map<String, Object> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValue(String key, Object val) {
        if (!StringTools.isBlank((String)key)) {
            Map<String, Object> fv = this.getFieldValues();
            if (val != null) {
                fv.put(key, val);
            } else {
                fv.remove(key);
            }
        }
    }

    public Object getFieldValue(String key, Object dft) {
        Object fv;
        Object object = fv = key != null ? this.getFieldValues().get(key) : null;
        if (fv != null) {
            return dft instanceof String ? fv.toString() : fv;
        }
        return dft;
    }

    public boolean hasFieldValue(String key) {
        return this.fieldValues.containsKey(key);
    }

    public void setFieldValue(String key, int val) {
        this.setFieldValue(key, new Integer(val));
    }

    public int getFieldValue(String key, int dft) {
        Object fv = this.getFieldValue(key, null);
        return fv instanceof Number ? ((Number)fv).intValue() : dft;
    }

    public void setFieldValue(String key, long val) {
        this.setFieldValue(key, new Long(val));
    }

    public long getFieldValue(String key, long dft) {
        Object fv = this.getFieldValue(key, null);
        return fv instanceof Number ? ((Number)fv).longValue() : dft;
    }

    public void setFieldValue(String key, double val) {
        this.setFieldValue(key, new Double(val));
    }

    public double getFieldValue(String key, double dft) {
        Object fv = this.getFieldValue(key, null);
        return fv instanceof Number ? ((Number)fv).doubleValue() : dft;
    }

    public void setMobileID(String mobileID) {
        this.setFieldValue(KEY_mobileID, mobileID);
    }

    public String getMobileID() {
        return (String)this.getFieldValue(KEY_mobileID, null);
    }

    public boolean hasMobileID() {
        return this.hasFieldValue(KEY_mobileID);
    }

    public void setAccountID(String accountID) {
        this.setFieldValue(KEY_accountID, accountID);
        if (StringTools.isBlank((String)accountID)) {
            this.setAccount(null);
            this.setDevice(null);
            this.setGeozone(null);
        } else {
            Account acct = this.getAccount();
            if (acct != null && !accountID.equals(acct.getAccountID())) {
                this.setAccount(null);
                this.setDevice(null);
                this.setGeozone(null);
            }
        }
    }

    public String getAccountID() {
        return (String)this.getFieldValue(KEY_accountID, null);
    }

    public boolean hasAccountID() {
        return this.hasFieldValue(KEY_accountID);
    }

    public void setAccount(Account account) {
        this.setFieldValue(KEY_account, account);
        if (account != null) {
            this.setFieldValue(KEY_accountID, account.getAccountID());
        }
    }

    public Account getAccount() {
        return (Account)this.getFieldValue(KEY_account, null);
    }

    public boolean hasAccount() {
        return this.hasFieldValue(KEY_account);
    }

    public void setDeviceID(String deviceID) {
        this.setFieldValue(KEY_deviceID, deviceID);
        if (StringTools.isBlank((String)deviceID)) {
            this.setDevice(null);
        } else {
            Device dev = this.getDevice();
            if (dev != null && !deviceID.equals(dev.getDeviceID())) {
                this.setDevice(null);
            }
        }
    }

    public String getDeviceID() {
        return (String)this.getFieldValue(KEY_deviceID, null);
    }

    public boolean hasDeviceID() {
        return this.hasFieldValue(KEY_deviceID);
    }

    public void setDevice(Device device) {
        this.setFieldValue(KEY_device, device);
        if (device != null) {
            this.setFieldValue(KEY_accountID, device.getAccountID());
            this.setFieldValue(KEY_deviceID, device.getDeviceID());
        }
    }

    public Device getDevice() {
        return (Device)this.getFieldValue(KEY_device, null);
    }

    public boolean hasDevice() {
        return this.hasFieldValue(KEY_device);
    }

    public void setGeozoneID(String geozoneID) {
        this.setFieldValue(KEY_geozoneID, geozoneID);
        if (StringTools.isBlank((String)geozoneID)) {
            this.setGeozone(null);
        } else {
            Geozone geoz = this.getGeozone();
            if (geoz != null && !geozoneID.equals(geoz.getGeozoneID())) {
                this.setGeozone(null);
            }
        }
    }

    public String getGeozoneID() {
        return (String)this.getFieldValue(KEY_geozoneID, null);
    }

    public boolean hasGeozoneID() {
        return this.hasFieldValue(KEY_geozoneID);
    }

    public void setGeozone(Geozone geozone) {
        this.setFieldValue(KEY_geozone, (Object)geozone);
        if (geozone != null) {
            this.setFieldValue(KEY_geozoneID, geozone.getGeozoneID());
        }
    }

    public Geozone getGeozone() {
        return (Geozone)((Object)this.getFieldValue(KEY_geozone, null));
    }

    public boolean hasGeozone() {
        return this.hasFieldValue(KEY_geozone);
    }

    public void setTimestamp(long ts) {
        this.setFieldValue(KEY_timestamp, ts > 0L ? ts : 0L);
    }

    public long getTimestamp() {
        return this.getFieldValue(KEY_timestamp, 0L);
    }

    public boolean hasTimestamp() {
        return this.hasFieldValue(KEY_timestamp);
    }

    public void setStatusCode(int sc) {
        this.setFieldValue(KEY_statusCode, sc > 0 ? sc : 0);
    }

    public int getStatusCode() {
        return this.getFieldValue(KEY_statusCode, 0);
    }

    public boolean hasStatusCode() {
        return this.hasFieldValue(KEY_statusCode);
    }

    public void setGeoPoint(double lat, double lon) {
        this.setFieldValue(KEY_latitude, lat);
        this.setFieldValue(KEY_longitude, lon);
        this.setFieldValue(KEY_geoPoint, null);
    }

    public void setGeoPoint(GeoPoint gp) {
        if (gp != null) {
            this.setFieldValue(KEY_latitude, gp.getLatitude());
            this.setFieldValue(KEY_longitude, gp.getLongitude());
            this.setFieldValue(KEY_geoPoint, gp);
        } else {
            this.setFieldValue(KEY_latitude, null);
            this.setFieldValue(KEY_longitude, null);
            this.setFieldValue(KEY_geoPoint, null);
        }
    }

    public boolean isGeoPointValid() {
        if (this.hasGeoPoint()) {
            return GeoPoint.isValid((double)this.getLatitude(), (double)this.getLongitude());
        }
        return false;
    }

    public void setLatitude(double lat) {
        this.setFieldValue(KEY_latitude, lat);
        this.setFieldValue(KEY_geoPoint, null);
    }

    public double getLatitude() {
        return this.getFieldValue(KEY_latitude, 0.0);
    }

    public boolean hasLatitude() {
        return this.hasFieldValue(KEY_latitude);
    }

    public void setLongitude(double lon) {
        this.setFieldValue(KEY_longitude, lon);
        this.setFieldValue(KEY_geoPoint, null);
    }

    public double getLongitude() {
        return this.getFieldValue(KEY_longitude, 0.0);
    }

    public boolean hasLongitude() {
        return this.hasFieldValue(KEY_longitude);
    }

    public GeoPoint getGeoPoint() {
        GeoPoint gp = (GeoPoint)this.getFieldValue(KEY_geoPoint, null);
        if (gp == null) {
            gp = new GeoPoint(this.getLatitude(), this.getLongitude());
            this.setFieldValue(KEY_geoPoint, gp);
        }
        return gp;
    }

    public boolean hasGeoPoint() {
        return this.hasLatitude() && this.hasLongitude();
    }

    public void setSpeedKPH(double kph) {
        this.setFieldValue(KEY_speedKPH, kph >= 0.0 ? kph : 0.0);
    }

    public double getSpeedKPH() {
        return this.getFieldValue(KEY_speedKPH, 0.0);
    }

    public boolean hasSpeedKPH() {
        return this.hasFieldValue(KEY_speedKPH);
    }

    public void setHeading(double deg) {
        this.setFieldValue(KEY_heading, deg >= 0.0 ? deg : 0.0);
    }

    public double getHeading() {
        return this.getFieldValue(KEY_heading, 0.0);
    }

    public boolean hasHeading() {
        return this.hasFieldValue(KEY_heading);
    }

    public void setAltitudeMeters(double altM) {
        this.setFieldValue(KEY_altitude, altM);
    }

    public double getAltitudeMeters() {
        return this.getFieldValue(KEY_altitude, 0.0);
    }

    public boolean hasAltitudeMeters() {
        return this.hasFieldValue(KEY_altitude);
    }

    public void setOdometerKM(double km) {
        this.setFieldValue(KEY_odometerKM, km);
    }

    public double getOdometerKM() {
        return this.getFieldValue(KEY_odometerKM, 0.0);
    }

    public boolean hasOdometerKM() {
        return this.hasFieldValue(KEY_odometerKM);
    }

    public static interface GeoEventHandler {
        public int handleGeoEvent(GeoEvent var1);
    }
}

