/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.opengts.db.PasswordHandler;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class GeneralPasswordHandler
implements PasswordHandler {
    public static final String PROP_debugCheckPassword = "debugCheckPassword";
    public static final String PROP_passwordEncoding = "passwordEncoding";
    public static final String PROP_minimumPasswordLength = "minimumPasswordLength";
    public static final String PROP_maximumPasswordAgeSeconds = "maximumPasswordAgeSeconds";
    public static final String PROP_specialCharacters = "specialCharacters";
    public static final String PROP_minimumLowerAlphaChars = "minimumLowerAlphaChars";
    public static final String PROP_minimumUpperAlphaChars = "minimumUpperAlphaChars";
    public static final String PROP_minimumAlphaChars = "minimumAlphaChars";
    public static final String PROP_minimumDigitChars = "minimumDigitChars";
    public static final String PROP_minimumSpecialChars = "minimumSpecialChars";
    public static final String PROP_minimumNonAlphaChars = "minimumNonAlphaChars";
    public static final String PROP_minimumCategories = "minimumCategories";
    public static final String PROP_passwordFormatDescription = "passwordFormatDescription";
    private static final RTKey.Entry[] PROP_Entry = new RTKey.Entry[]{new RTKey.Entry("passwordEncoding", (Object)"plain", "Password Encoding"), new RTKey.Entry("minimumPasswordLength", 1, "Minimum Password Length"), new RTKey.Entry("maximumPasswordAgeSeconds", 0L, "Maximum Password Age (seconds)"), new RTKey.Entry("specialCharacters", (Object)"!@#$%^&*()_+-:;.?/", "Special Characters"), new RTKey.Entry("minimumLowerAlphaChars", 0, "Minimum Lower-Case Alpha Characters"), new RTKey.Entry("minimumUpperAlphaChars", 0, "Minimum Upper-Case Alpha Characters"), new RTKey.Entry("minimumAlphaChars", 0, "Minimum Alpha Characters"), new RTKey.Entry("minimumDigitChars", 0, "Minimum Digit Characters"), new RTKey.Entry("minimumSpecialChars", 0, "Minimum Special Characters"), new RTKey.Entry("minimumNonAlphaChars", 0, "Minimum Non-Alpha Characters"), new RTKey.Entry("minimumCategories", 0, "Minimum Number of Categories"), new RTKey.Entry("debugCheckPassword", false, "Debug 'checkPassword'"), new RTKey.Entry("passwordFormatDescription", (Object)"", "Password Format Error Message")};
    private static RTProperties DefaultProps = null;
    public static final int MD5_HASH_LEN = 32;
    public static final String ENC_MD5 = "md5";
    public static final String ENC_PLAIN = "plain";
    public static final String ENC_MD5PLAIN = "md5plain";
    private String name = null;
    private RTProperties rtProps = null;
    private String encoding = null;
    private boolean checkPlain = false;
    private boolean debugCheckPass = false;
    public static final String[] ARG_PASSWORD;
    public static final String[] ARG_ENCODING;
    public static final String[] ARG_MINLEN;
    public static final String[] ARG_MINLOWER;
    public static final String[] ARG_MINUPPER;
    public static final String[] ARG_MINALPHA;
    public static final String[] ARG_MINDIGIT;
    public static final String[] ARG_MINSPEC;
    public static final String[] ARG_TBLPASS;

    public GeneralPasswordHandler() throws PasswordEncodingException {
        this(null, null);
    }

    public GeneralPasswordHandler(RTProperties rtp) throws PasswordEncodingException {
        this(null, rtp);
    }

    public GeneralPasswordHandler(String name, RTProperties rtp) throws PasswordEncodingException {
        this.rtProps = rtp != null ? rtp : new RTProperties();
        this.name = !StringTools.isBlank((String)name) ? name : null;
        String encType = this.getString(PROP_passwordEncoding, "");
        if (encType.equalsIgnoreCase(ENC_MD5)) {
            this.encoding = ENC_MD5;
            this.checkPlain = false;
        } else if (encType.equalsIgnoreCase("hash")) {
            this.encoding = ENC_MD5;
            this.checkPlain = false;
        } else if (encType.equalsIgnoreCase(ENC_MD5PLAIN)) {
            this.encoding = ENC_MD5;
            this.checkPlain = true;
        } else if (encType.equalsIgnoreCase("hashplain")) {
            this.encoding = ENC_MD5;
            this.checkPlain = true;
        } else if (encType.equalsIgnoreCase(ENC_PLAIN)) {
            this.encoding = ENC_PLAIN;
            this.checkPlain = true;
        } else if (encType.equalsIgnoreCase("none")) {
            this.encoding = ENC_PLAIN;
            this.checkPlain = true;
        } else if (StringTools.isBlank((String)encType)) {
            this.encoding = ENC_PLAIN;
            this.checkPlain = true;
        } else {
            throw new PasswordEncodingException("Invalid Encoding: " + encType);
        }
    }

    @Override
    public String getName() {
        return !StringTools.isBlank((String)this.name) ? this.name : this.encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private boolean isEncoding(String enc) {
        return this.encoding.equalsIgnoreCase(enc);
    }

    public String getEncodingString() {
        if (this.isEncoding(ENC_MD5) && this.checkPlain()) {
            return ENC_MD5PLAIN;
        }
        return this.getEncoding();
    }

    public boolean checkPlain() {
        return this.checkPlain;
    }

    protected Object getProperty(String key, Object dft) {
        if (this.rtProps.hasProperty((Object)key)) {
            return this.rtProps.getProperty((Object)key, dft);
        }
        return DefaultProps.getProperty((Object)key, dft);
    }

    protected boolean hasProperty(String key) {
        return this.rtProps.hasProperty((Object)key) || DefaultProps.hasProperty((Object)key);
    }

    protected String getString(String key, String dft) {
        if (this.rtProps.hasProperty((Object)key)) {
            return this.rtProps.getString(key, dft);
        }
        return DefaultProps.getString(key, dft);
    }

    protected long getLong(String key, long dft) {
        if (this.rtProps.hasProperty((Object)key)) {
            return this.rtProps.getLong(key, dft);
        }
        return DefaultProps.getLong(key, dft);
    }

    protected int getInt(String key, int dft) {
        if (this.rtProps.hasProperty((Object)key)) {
            return this.rtProps.getInt(key, dft);
        }
        return DefaultProps.getInt(key, dft);
    }

    protected boolean getBoolean(String key, boolean dft) {
        if (this.rtProps.hasProperty((Object)key)) {
            return this.rtProps.getBoolean(key, dft);
        }
        return DefaultProps.getBoolean(key, dft);
    }

    @Override
    public String encodePassword(String pass) {
        if (pass == null || pass.equals("")) {
            return pass;
        }
        if (this.isEncoding(ENC_MD5)) {
            try {
                MessageDigest md5Digest = MessageDigest.getInstance("MD5");
                md5Digest.update(pass.getBytes(), 0, pass.length());
                String md5Pass = new BigInteger(1, md5Digest.digest()).toString(16);
                return md5Pass;
            }
            catch (NoSuchAlgorithmException nsae) {
                Print.logException((String)"MD5 Algorithm not found", (Throwable)nsae);
                return null;
            }
        }
        if (this.isEncoding(ENC_PLAIN)) {
            return pass;
        }
        Print.logStackTrace((String)("Invalid password encoding: " + this.encoding));
        return pass;
    }

    @Override
    public String decodePassword(String pass) {
        if (pass == null || pass.equals("")) {
            return pass;
        }
        if (this.isEncoding(ENC_MD5)) {
            return null;
        }
        if (this.isEncoding(ENC_PLAIN)) {
            return pass;
        }
        Print.logStackTrace((String)("Invalid password encoding: " + this.encoding));
        return pass;
    }

    public void setDebugCheckPassword(boolean debugLog) {
        this.rtProps.setBoolean(PROP_debugCheckPassword, debugLog);
    }

    public boolean getDebugCheckPassword() {
        return this.getBoolean(PROP_debugCheckPassword, false);
    }

    @Override
    public boolean checkPassword(String enteredPass, String tablePass) {
        boolean LOG = this.getDebugCheckPassword();
        if (LOG) {
            Print.logInfo((String)("[DEBUG] PasswordHandler=" + this + ", enteredPass=" + enteredPass + ", tablePass=" + tablePass), (Object[])new Object[0]);
        }
        if (StringTools.isBlank((String)tablePass)) {
            if (LOG) {
                Print.logInfo((String)"[DEBUG] Login Failed: No table password", (Object[])new Object[0]);
            }
            return false;
        }
        if (enteredPass == null) {
            if (tablePass.equals("*blank*")) {
                if (LOG) {
                    Print.logInfo((String)"[DEBUG] Login OK: null password", (Object[])new Object[0]);
                }
                return true;
            }
            if (LOG) {
                Print.logInfo((String)"[DEBUG] Login Failed: No entered password", (Object[])new Object[0]);
            }
            return false;
        }
        if (enteredPass.equals("") && tablePass.equals("*blank*")) {
            if (LOG) {
                Print.logInfo((String)"[DEBUG] Login OK: blank password", (Object[])new Object[0]);
            }
            return true;
        }
        if (tablePass.equals(this.encodePassword(enteredPass))) {
            if (LOG) {
                Print.logInfo((String)"[DEBUG] Login OK: Entered password matches encoded table password", (Object[])new Object[0]);
            }
            return true;
        }
        if (this.isEncoding(ENC_MD5) && tablePass.length() != 32 && this.checkPlain()) {
            if (tablePass.equals(enteredPass)) {
                if (LOG) {
                    Print.logInfo((String)"[DEBUG] Login OK: MD5/Plain match", (Object[])new Object[0]);
                }
                return true;
            }
            if (LOG) {
                Print.logInfo((String)"[DEBUG] Login Failed: MD5/Plain did not match", (Object[])new Object[0]);
            }
            return false;
        }
        if (LOG) {
            Print.logInfo((String)"[DEBUG] Login Failed: No match", (Object[])new Object[0]);
        }
        return false;
    }

    private boolean isSpecialChar(char ch) {
        String specChars = this.getString(PROP_specialCharacters, "");
        return specChars.indexOf(ch) >= 0;
    }

    private boolean checkCharCount(String key, int count) {
        int min = this.getInt(key, 0);
        return min <= 0 || count >= min;
    }

    @Override
    public boolean validateNewPassword(String newPass) {
        if (newPass == null) {
            return false;
        }
        if (newPass.equals("")) {
            return false;
        }
        int minLen = this.getInt(PROP_minimumPasswordLength, 0);
        if (StringTools.length((String)newPass) < minLen) {
            return false;
        }
        int lowerCount = 0;
        int upperCount = 0;
        int alphaCount = 0;
        int digitCount = 0;
        int specialCount = 0;
        int nonAlphaCount = 0;
        for (int i = 0; i < newPass.length(); ++i) {
            char ch = newPass.charAt(i);
            if (Character.isLowerCase(ch)) {
                ++lowerCount;
                ++alphaCount;
                continue;
            }
            if (Character.isUpperCase(ch)) {
                ++upperCount;
                ++alphaCount;
                continue;
            }
            if (Character.isDigit(ch)) {
                ++digitCount;
                ++nonAlphaCount;
                continue;
            }
            if (this.isSpecialChar(ch)) {
                ++specialCount;
                ++nonAlphaCount;
                continue;
            }
            return false;
        }
        if (!this.checkCharCount(PROP_minimumLowerAlphaChars, lowerCount)) {
            return false;
        }
        if (!this.checkCharCount(PROP_minimumUpperAlphaChars, upperCount)) {
            return false;
        }
        if (!this.checkCharCount(PROP_minimumAlphaChars, alphaCount)) {
            return false;
        }
        if (!this.checkCharCount(PROP_minimumDigitChars, digitCount)) {
            return false;
        }
        if (!this.checkCharCount(PROP_minimumSpecialChars, specialCount)) {
            return false;
        }
        if (!this.checkCharCount(PROP_minimumNonAlphaChars, nonAlphaCount)) {
            return false;
        }
        int minCategories = this.getInt(PROP_minimumCategories, 0);
        if (minCategories > 0) {
            int minCat;
            int catCnt = 0;
            if (lowerCount > 0) {
                ++catCnt;
            }
            if (upperCount > 0) {
                ++catCnt;
            }
            if (digitCount > 0) {
                ++catCnt;
            }
            if (specialCount > 0) {
                ++catCnt;
            }
            int n = minCat = minCategories <= 4 ? minCategories : 4;
            if (catCnt < minCat) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getPasswordFormatDescription(Locale locale) {
        int minCategories;
        int minNonAlpha;
        int minSpec;
        int minDigit;
        int minAlpha;
        int minUpper;
        int minLower;
        String specChars;
        String desc;
        I18N i18n = I18N.getI18N(GeneralPasswordHandler.class, (Locale)locale);
        Object fmtDesc = this.getProperty(PROP_passwordFormatDescription, null);
        if (fmtDesc instanceof I18N.Text ? !StringTools.isBlank((String)(desc = ((I18N.Text)fmtDesc).toString(i18n))) : fmtDesc instanceof String && !StringTools.isBlank((String)(desc = (String)fmtDesc))) {
            return desc;
        }
        StringBuffer sb = new StringBuffer();
        int minLen = this.getInt(PROP_minimumPasswordLength, 0);
        if (minLen > 0) {
            sb.append(i18n.getString("GeneralPasswordHandler.format.minimumLength", "- At least {0} characters in length", (Object)String.valueOf(minLen)));
            sb.append("\n");
        }
        if (!StringTools.isBlank((String)(specChars = this.getString(PROP_specialCharacters, "")))) {
            sb.append(i18n.getString("GeneralPasswordHandler.format.specialChars", "- May contain special characters \"{0}\"", (Object)specChars));
            sb.append("\n");
        }
        if ((minLower = this.getInt(PROP_minimumLowerAlphaChars, 0)) > 0) {
            sb.append(i18n.getString("GeneralPasswordHandler.format.lowerAlphaCount", "- At least {0} lower-case characters", (Object)String.valueOf(minLower)));
            sb.append("\n");
        }
        if ((minUpper = this.getInt(PROP_minimumUpperAlphaChars, 0)) > 0) {
            sb.append(i18n.getString("GeneralPasswordHandler.format.upperAlphaCount", "- At least {0} upper-case characters", (Object)String.valueOf(minUpper)));
            sb.append("\n");
        }
        if ((minAlpha = this.getInt(PROP_minimumAlphaChars, 0)) > 0) {
            sb.append(i18n.getString("GeneralPasswordHandler.format.alphaCount", "- At least {0} alpha characters", (Object)String.valueOf(minAlpha)));
            sb.append("\n");
        }
        if ((minDigit = this.getInt(PROP_minimumDigitChars, 0)) > 0) {
            sb.append(i18n.getString("GeneralPasswordHandler.format.digitCount", "- At least {0} numeric digits", (Object)String.valueOf(minDigit)));
            sb.append("\n");
        }
        if ((minSpec = this.getInt(PROP_minimumSpecialChars, 0)) > 0) {
            sb.append(i18n.getString("GeneralPasswordHandler.format.specialCount", "- At least {0} special characters", (Object)String.valueOf(minSpec)));
            sb.append("\n");
        }
        if ((minNonAlpha = this.getInt(PROP_minimumNonAlphaChars, 0)) > 0) {
            sb.append(i18n.getString("GeneralPasswordHandler.format.nonAlphaCount", "- At least {0} non-alpha characters", (Object)String.valueOf(minNonAlpha)));
            sb.append("\n");
        }
        if ((minCategories = this.getInt(PROP_minimumCategories, 0)) > 0) {
            int minCat = minCategories <= 4 ? minCategories : 4;
            sb.append(i18n.getString("GeneralPasswordHandler.format.categoryCount", "- At least {0} of the 4 categories (lower/upper/digit/special)", (Object)String.valueOf(minCat)));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean hasPasswordExpired(long lastChangedTime) {
        long maxAgeSec = this.getLong(PROP_maximumPasswordAgeSeconds, 0L);
        if (maxAgeSec <= 0L) {
            return false;
        }
        if (lastChangedTime <= 0L) {
            return false;
        }
        long ageSec = DateTime.getCurrentTimeSec() - lastChangedTime;
        if (ageSec < 0L) {
            return false;
        }
        return ageSec > maxAgeSec;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[GeneralPasswordHandler]\n");
        sb.append("  Encoding String = ").append(this.getEncodingString()).append("\n");
        for (RTKey.Entry pe : PROP_Entry) {
            String pk = pe.getKey();
            String ph = pe.getHelp();
            if (!this.hasProperty(pk)) continue;
            sb.append("  ").append(pk).append(" = ");
            sb.append(this.getProperty(pk, ""));
            sb.append("  (").append(ph).append(")");
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        String passwd = RTConfig.getString((String[])ARG_PASSWORD, (String)"");
        String tblPass = RTConfig.getString((String[])ARG_TBLPASS, (String)"");
        RTProperties rtp = new RTProperties();
        rtp.setString(PROP_passwordEncoding, RTConfig.getString((String[])ARG_ENCODING, (String)ENC_PLAIN));
        rtp.setInt(PROP_minimumPasswordLength, RTConfig.getInt((String[])ARG_MINLEN, (int)1));
        rtp.setInt(PROP_minimumLowerAlphaChars, RTConfig.getInt((String[])ARG_MINLOWER, (int)0));
        rtp.setInt(PROP_minimumUpperAlphaChars, RTConfig.getInt((String[])ARG_MINUPPER, (int)0));
        rtp.setInt(PROP_minimumAlphaChars, RTConfig.getInt((String[])ARG_MINALPHA, (int)0));
        rtp.setInt(PROP_minimumDigitChars, RTConfig.getInt((String[])ARG_MINDIGIT, (int)0));
        rtp.setInt(PROP_minimumSpecialChars, RTConfig.getInt((String[])ARG_MINSPEC, (int)0));
        GeneralPasswordHandler gph = null;
        try {
            gph = new GeneralPasswordHandler(rtp);
            Print.sysPrintln((String)gph.toString(), (Object[])new Object[0]);
            Print.sysPrintln((String)gph.getPasswordFormatDescription(null), (Object[])new Object[0]);
        }
        catch (PasswordEncodingException pe) {
            Print.sysPrintln((String)("ERROR: " + pe), (Object[])new Object[0]);
            System.exit(1);
        }
        Print.sysPrintln((String)("Password: entered=" + passwd + ", table=" + tblPass), (Object[])new Object[0]);
        Print.sysPrintln((String)("Valid   : " + gph.validateNewPassword(passwd)), (Object[])new Object[0]);
        Print.sysPrintln((String)("Encoded : " + gph.encodePassword(passwd)), (Object[])new Object[0]);
        Print.sysPrintln((String)("Match   : " + gph.checkPassword(passwd, tblPass)), (Object[])new Object[0]);
    }

    static {
        DefaultProps = new RTProperties();
        for (int i = 0; i < PROP_Entry.length; ++i) {
            String rtKey = PROP_Entry[i].getKey();
            Object rtVal = PROP_Entry[i].getDefault();
            DefaultProps.setProperty((Object)rtKey, rtVal);
        }
        ARG_PASSWORD = new String[]{"password", "passwd", "pass", "pwd"};
        ARG_ENCODING = new String[]{"encoding", "enc"};
        ARG_MINLEN = new String[]{"minlen", "length", "len"};
        ARG_MINLOWER = new String[]{"minLower", "lower"};
        ARG_MINUPPER = new String[]{"minUpper", "upper"};
        ARG_MINALPHA = new String[]{"minAlpha", "alpha"};
        ARG_MINDIGIT = new String[]{"minDigit", "digit"};
        ARG_MINSPEC = new String[]{"minSpec", "special", "spec"};
        ARG_TBLPASS = new String[]{"tblPass", "table"};
    }

    public static class PasswordEncodingException
    extends RuntimeException {
        public PasswordEncodingException(String msg) {
            super(msg);
        }
    }
}

