/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.Version;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.EventDataProvider;
import org.opengts.db.EventDataProviderAdapter;
import org.opengts.db.GoogleKML;
import org.opengts.db.PoiProvider;
import org.opengts.db.StatusCodeProvider;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.SlowOperationException;
import org.opengts.util.AccumulatorLong;
import org.opengts.util.Base64;
import org.opengts.util.DateTime;
import org.opengts.util.GeoBounds;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.JSON;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;

public class EventUtil {
    public static final long MAX_PUSHPIN_LIMIT = 1000L;
    private static final long DFT_CSV_LIMIT = 30L;
    public static final String MAP_ESCAPE_HTML = "$HTML:";
    public static final String MAP_ESCAPE_B64 = "$B64:";
    public static final int MAPDATA_DEFAULT = 0;
    public static final int MAPDATA_XML = 1;
    public static final int MAPDATA_JSON = 2;
    private static int DefaultMapDataFormat = 1;
    private static final int OPT_MAX_FIELDS = 3;
    private static OptionalEventFields optionalEventFieldHandler = null;
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_CSV = 1;
    public static final int FORMAT_KML = 2;
    public static final int FORMAT_XML = 3;
    public static final int FORMAT_XMLOLD = 4;
    public static final int FORMAT_TXT = 5;
    public static final int FORMAT_GPX = 6;
    public static final int FORMAT_JSON = 7;
    public static final int FORMAT_JSONX = 8;
    public static final int FORMAT_BML = 9;
    public static final int FORMAT_AEMP = 10;
    private static EventUtil instance = null;
    public static final boolean SEPARATE_DATASET_PER_DEVICE = false;
    public static final String TAG_MapData = "MapData";
    public static final String TAG_LastEvent = "LastEvent";
    public static final String TAG_Time = "Time";
    public static final String TAG_DataColumns = "DataColumns";
    public static final String TAG_DataSet = "DataSet";
    public static final String TAG_Point = "P";
    public static final String TAG_Shape = "Shape";
    public static final String TAG_Action = "Action";
    public static final String JSON_Error = "Error";
    public static final String JSON_Command = "Command";
    public static final String JSON_Account = "Account";
    public static final String JSON_User = "User";
    public static final String JSON_Version = "Version";
    public static final String JSON_JMapData = "JMapData";
    public static final String JSON_Time = "Time";
    public static final String JSON_LastEvent = "LastEvent";
    public static final String JSON_DataColumns = "DataColumns";
    public static final String JSON_Data = "Data";
    public static final String JSON_Shapes = "Shapes";
    public static final String JSON_DataSets = "DataSets";
    public static final String JSON_Points = "Points";
    public static final String JSON_Actions = "Actions";
    public static final String JSON_YMD = "YMD";
    public static final String JSON_year = "YYYY";
    public static final String JSON_month = "MM";
    public static final String JSON_day = "DD";
    public static final String JSON_date = "date";
    public static final String JSON_time = "time";
    public static final String JSON_cmd = "cmd";
    public static final String JSON_arg = "arg";
    public static final String JSON_type = "type";
    public static final String JSON_radius = "radius";
    public static final String JSON_color = "color";
    public static final String JSON_route = "route";
    public static final String JSON_routeColor = "routeColor";
    public static final String JSON_textColor = "textColor";
    public static final String JSON_id = "id";
    public static final String ATTR_isFleet = "isFleet";
    public static final String ATTR_type = "type";
    public static final String ATTR_id = "id";
    public static final String ATTR_route = "route";
    public static final String ATTR_routeColor = "routeColor";
    public static final String ATTR_textColor = "textColor";
    public static final String ATTR_timestamp = "timestamp";
    public static final String ATTR_timezone = "timezone";
    public static final String ATTR_device = "device";
    public static final String ATTR_year = "year";
    public static final String ATTR_month = "month";
    public static final String ATTR_day = "day";
    public static final String ATTR_color = "color";
    public static final String ATTR_radius = "radius";
    public static final String ATTR_battery = "battery";
    public static final String ATTR_signal = "signal";
    public static final String ATTR_command = "command";
    public static final String DSTYPE_device = "device";
    public static final String DSTYPE_group = "group";
    public static final String DSTYPE_poi = "poi";
    public static final char CSV_SEPARATOR_CHAR = '|';
    public static final String TAG_Account = "Account";
    public static final String TAG_Device = "Device";
    public static final String TAG_EventData = "EventData";
    public static final String TAG_Description = "Description";
    public static final String TAG_Event = "Event";
    public static final String TAG_Timestamp = "Timestamp";
    public static final String TAG_StatusCode = "StatusCode";
    public static final String TAG_GPSPoint = "GPSPoint";
    public static final String TAG_Speed = "Speed";
    public static final String TAG_Heading = "Heading";
    public static final String TAG_Altitude = "Altitude";
    public static final String TAG_Odometer = "Odometer";
    public static final String TAG_Geozone = "Geozone";
    public static final String TAG_Address = "Address";
    public static final String TAG_City = "City";
    public static final String TAG_PostalCode = "PostalCode";
    public static final String TAG_DigitalInputMask = "DigitalInputMask";
    public static final String TAG_DriverID = "DriverID";
    public static final String TAG_DriverMessage = "DriverMessage";
    public static final String TAG_EngineRPM = "EngineRPM";
    public static final String TAG_EngineHours = "EngineHours";
    public static final String TAG_VehicleBatteryVolts = "VehicleBatteryVolts";
    public static final String TAG_EngineCoolantLevel = "EngineCoolantLevel";
    public static final String TAG_EngineCoolantTemperature = "EngineCoolantTemperature";
    public static final String TAG_EngineFuelUsed = "EngineFuelUsed";
    public static final String ATTR_account = "account";
    public static final String ATTR_epoch = "epoch";
    public static final String ATTR_age = "age";
    public static final String ATTR_units = "units";
    public static final String ATTR_limit = "limit";
    public static final String ATTR_index = "index";
    public static final String ATTR_code = "code";
    private static String JSON_INDENT;
    private static final String[] ARG_ACCOUNT;
    private static final String[] ARG_DEVICE;
    private static final String[] ARG_EVENTS;
    private static final String[] ARG_OUTPUT;
    private static final String[] ARG_FORMAT;
    private static final String[] ARG_GEOZONE;
    private static final String[] ARG_GEOCODE;
    private static final String[] ARG_UPDATE;

    public static void SetDefaultMapDataFormat(int dftDataFmt) {
        DefaultMapDataFormat = dftDataFmt;
    }

    public static int GetDefaultMapDataFormat() {
        return DefaultMapDataFormat;
    }

    public static boolean IsXMLMapDataFormat(int mdf) {
        return mdf != 2;
    }

    public static void setOptionalEventFieldHandler(OptionalEventFields oef) {
        optionalEventFieldHandler = oef;
    }

    public static OptionalEventFields getOptionalEventFieldHandler() {
        return optionalEventFieldHandler;
    }

    public static boolean hasOptionalEventFieldHandler() {
        return optionalEventFieldHandler != null;
    }

    public static int parseOutputFormat(String fmt, int dftFmt) {
        if (fmt == null) {
            return dftFmt;
        }
        if (fmt.equalsIgnoreCase("csv")) {
            return 1;
        }
        if (fmt.equalsIgnoreCase("kml")) {
            return 2;
        }
        if (fmt.equalsIgnoreCase("xml")) {
            return 3;
        }
        if (fmt.equalsIgnoreCase("txt")) {
            return 5;
        }
        if (fmt.equalsIgnoreCase("gpx")) {
            return 6;
        }
        if (fmt.equalsIgnoreCase("json")) {
            return 7;
        }
        if (fmt.equalsIgnoreCase("jsonx")) {
            return 8;
        }
        if (fmt.equalsIgnoreCase("bml")) {
            return 9;
        }
        if (fmt.equalsIgnoreCase("aemp")) {
            return 10;
        }
        return dftFmt;
    }

    public static EventUtil getInstance() {
        if (instance == null) {
            instance = new EventUtil();
        }
        return instance;
    }

    private EventUtil() {
    }

    private void write(PrintWriter pwout, String s) throws IOException {
        if (s != null) {
            if (pwout != null) {
                pwout.write(s);
            } else {
                Print.sysPrint((String)s, (Object[])new Object[0]);
            }
        }
    }

    private void flush(PrintWriter pwout) {
        if (pwout != null) {
            pwout.flush();
        }
    }

    private void print(PrintStream psout, String s) {
        if (s != null) {
            if (psout != null) {
                psout.print(s);
            } else {
                Print.sysPrint((String)s, (Object[])new Object[0]);
            }
        }
    }

    private void println(PrintStream psout, String s) {
        if (s != null) {
            if (psout != null) {
                psout.println(s);
            } else {
                Print.sysPrintln((String)s, (Object[])new Object[0]);
            }
        }
    }

    private boolean writeEvents_CSV(PrintWriter pwout, Account account, Collection<Device> devList, boolean allTags, TimeZone dispTmz, char csvSep, boolean inclHeader, BasicPrivateLabel privLabel) throws IOException {
        String[] evFields = null;
        evFields = allTags ? new String[]{"deviceID", ATTR_timestamp, "statusCode", "latitude", "longitude", "speedKPH", "heading", "altitude", "address", "gpsAge", "satelliteCount", "inputMask", "odometerKM", "geozoneID", "driverID", "driverMessage", "fuelTotal", "engineRpm", "engineHours", "vBatteryVolts", "coolantLevel", "coolantTemp"} : new String[]{"deviceID", ATTR_timestamp, "statusCode", "latitude", "longitude", "speedKPH", "heading", "altitude", "address"};
        return this.writeEvents_CSV_fields(pwout, account, devList, evFields, dispTmz, csvSep, inclHeader, privLabel);
    }

    private boolean writeEvents_CSV_fields(PrintWriter pwout, Account account, Collection<Device> devList, String[] evFields, TimeZone dispTmz, char csvSep, boolean inclHeader, BasicPrivateLabel privLabel) throws IOException {
        if (account == null) {
            return false;
        }
        String accountID = account.getAccountID();
        if (inclHeader) {
            String hdr = this.formatHeader_CSV(evFields, csvSep) + "\n";
            this.write(pwout, hdr);
        }
        String dateFmt = account.getDateFormat();
        String timeFmt = account.getTimeFormat();
        TimeZone acctTmz = account.getTimeZone(null);
        if (dispTmz == null) {
            dispTmz = acctTmz;
        }
        if (!ListTools.isEmpty(devList)) {
            for (Device dev : devList) {
                Object[] evList;
                if (!dev.getAccountID().equals(accountID) || ListTools.isEmpty((Object[])(evList = dev.getSavedRangeEvents()))) continue;
                for (Object ev : evList) {
                    if (!((AccountRecord)((Object)ev)).getAccountID().equals(accountID)) continue;
                    ((AccountRecord)((Object)ev)).setAccount(account);
                    String rcd = this.formatEventData_CSV((EventData)ev, evFields, dispTmz, dateFmt, timeFmt, csvSep) + "\n";
                    this.write(pwout, rcd);
                }
            }
        }
        this.flush(pwout);
        return true;
    }

    private String formatHeader_CSV(String[] f, char csvSep) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < f.length; ++i) {
            if (sb.length() > 0) {
                sb.append(csvSep);
            }
            if (f[i].equals("$deviceDesc")) {
                sb.append("DeviceDesc");
                continue;
            }
            if (f[i].equals("deviceID")) {
                sb.append("DeviceID");
                continue;
            }
            if (f[i].equals(ATTR_timestamp)) {
                sb.append("Date").append(csvSep).append("Time");
                continue;
            }
            if (f[i].equals("statusCode")) {
                sb.append("Code");
                continue;
            }
            if (f[i].equals("latitude")) {
                sb.append("Latitude");
                continue;
            }
            if (f[i].equals("longitude")) {
                sb.append("Longitude");
                continue;
            }
            if (f[i].equals("speedKPH")) {
                sb.append(TAG_Speed);
                continue;
            }
            if (f[i].equals("heading")) {
                sb.append(TAG_Heading);
                continue;
            }
            if (f[i].equals("altitude")) {
                sb.append(TAG_Altitude);
                continue;
            }
            if (f[i].equals("address")) {
                sb.append(TAG_Address);
                continue;
            }
            if (!EventData.getFactory().hasField(f[i])) continue;
            sb.append(f[i]);
        }
        return sb.toString();
    }

    private String formatEventData_CSV(EventData evdata, String[] fields, TimeZone dispTmz, String dateFmt, String timeFmt, char csvSep) {
        StringBuffer sb = new StringBuffer();
        if (evdata != null && fields != null) {
            Account account = evdata.getAccount();
            BasicPrivateLabel privLabel = account.getPrivateLabel();
            for (int i = 0; i < fields.length; ++i) {
                Object val;
                if (fields[i].startsWith("$")) {
                    if (!fields[i].equals("$deviceDesc")) continue;
                    if (sb.length() > 0) {
                        sb.append(csvSep);
                    }
                    sb.append(evdata.getDeviceDescription());
                    continue;
                }
                DBField dbFld = evdata.getRecordKey().getField(fields[i]);
                Object object = val = dbFld != null ? evdata.getFieldValue(fields[i]) : null;
                if (val == null) continue;
                if (sb.length() > 0) {
                    sb.append(csvSep);
                }
                Class typeClass = dbFld.getTypeClass();
                if (fields[i].equals(ATTR_timestamp)) {
                    long time = (Long)val;
                    DateTime dt = new DateTime(time);
                    String fmt = dateFmt + csvSep + timeFmt;
                    if (dispTmz == null) {
                        sb.append(dt.gmtFormat(fmt));
                        continue;
                    }
                    sb.append(dt.format(fmt, dispTmz));
                    continue;
                }
                if (fields[i].equals("statusCode")) {
                    String scd = evdata.getStatusCodeDescription(privLabel);
                    sb.append(scd);
                    continue;
                }
                if (typeClass == Float.class || typeClass == Float.TYPE) {
                    float d = ((Float)val).floatValue();
                    String fmt = dbFld.getFormat();
                    if (fmt != null && !fmt.equals("")) {
                        sb.append(StringTools.format((double)d, (String)fmt));
                        continue;
                    }
                    sb.append(String.valueOf(d));
                    continue;
                }
                if (typeClass == Double.class || typeClass == Double.TYPE) {
                    double d = (Double)val;
                    String fmt = dbFld.getFormat();
                    if (fmt != null && !fmt.equals("")) {
                        sb.append(StringTools.format((double)d, (String)fmt));
                        continue;
                    }
                    sb.append(String.valueOf(d));
                    continue;
                }
                if (typeClass == Long.class || typeClass == Long.TYPE) {
                    sb.append(val.toString());
                    continue;
                }
                if (typeClass == Integer.class || typeClass == Integer.TYPE) {
                    sb.append(val.toString());
                    continue;
                }
                if (fields[i].equals("address")) {
                    String v = val.toString().replace(csvSep, ' ');
                    sb.append(StringTools.quoteString((String)v));
                    continue;
                }
                String v = val.toString().replace(csvSep, ' ');
                if (v.indexOf(" ") >= 0 || v.indexOf(34) >= 0) {
                    sb.append(StringTools.quoteString((String)v));
                    continue;
                }
                sb.append(v);
            }
        }
        return sb.toString();
    }

    public String getParseMapEventJS(boolean isFleet, Locale locale) {
        return this.getParseMapEventJS(isFleet, locale, '|');
    }

    public String getParseMapEventJS(boolean isFleet, Locale locale, char csvSep) {
        int optFieldCount;
        StringBuffer js = new StringBuffer();
        js.append("// (generated by 'EventUtil.getParseMapEventJS')\n");
        js.append("function MapEventRecord(csvRcd) {\n");
        js.append("    var fld        = csvRcd.split('" + csvSep + "');\n");
        js.append("    this.index     = 0;\n");
        js.append("    this.lastEv    = null;\n");
        js.append("    this.nextEv    = null;\n");
        js.append("    this.valid     = (fld.length > 9);\n");
        js.append("    this.devVIN    = (fld.length > 0)? decodeUnicode(fld[ 0]) : '';\n");
        js.append("    this.device    = (fld.length > 1)? decodeUnicode(fld[ 1]) : '';\n");
        js.append("    this.timestamp = (fld.length > 2)? parseInt(fld[ 2]) : 0;\n");
        js.append("    this.dateFmt   = (fld.length > 3)? fld[ 3] : '';\n");
        js.append("    this.timeFmt   = (fld.length > 4)? fld[ 4] : '';\n");
        js.append("    this.timeZone  = (fld.length > 5)? fld[ 5] : '';\n");
        js.append("    this.code      = (fld.length > 6)? decodeUnicode(fld[ 6]) : '';\n");
        js.append("    if (this.code.startsWith('$HTML:')) { this.code = decodeBase64(this.code.substring(" + MAP_ESCAPE_HTML.length() + ")); }\n");
        js.append("    this.iconNdx   = (fld.length > 7)? fld[ 7] : '';\n");
        js.append("    this.isCellLoc = false;\n");
        js.append("    this.latitude  = numParseFloat(((fld.length >  8)? fld[ 8] : '0'), 0);\n");
        js.append("    this.longitude = numParseFloat(((fld.length >  9)? fld[ 9] : '0'), 0);\n");
        js.append("    this.gpsAge    = numParseFloat(((fld.length > 10)? fld[10] : '0'), 0);\n");
        js.append("    this.createAge = numParseFloat(((fld.length > 11)? fld[11] : '0'), 0);\n");
        js.append("    this.accuracy  = numParseFloat(((fld.length > 12)? fld[12] : '0'), 0);\n");
        js.append("    if (this.accuracy < 0) { this.accuracy = 0; }\n");
        js.append("    this.validGPS  = ((this.latitude != 0) || (this.longitude != 0))? true : false;\n");
        js.append("    this.satCount  = (fld.length > 13)? fld[13] : '0';\n");
        js.append("    if (this.satCount < 0) { this.isCellLoc = true; this.satCount = 0; }\n");
        js.append("    this.speedKPH  = numParseFloat(((fld.length > 14)? fld[14] : '0'), 0);\n");
        js.append("    this.speedMPH  = this.speedKPH * 0.621371192237334;\n");
        js.append("    this.heading   = numParseFloat(((fld.length > 15)? fld[15] : '0'), 0);\n");
        js.append("    this.compass   = HEADING[Math.round(this.heading / 45.0) % 8];\n");
        js.append("    this.altitude  = numParseFloat(((fld.length > 16)? fld[16] : '0'), 0); // meters\n");
        js.append("    this.odomKM    = numParseFloat(((fld.length > 17)? fld[17] : '0'), 0);\n");
        js.append("    this.stopped   = (fld.length > 18)? parseInt(fld[18]) : 0;\n");
        js.append("    this.stopSec   = 0;\n");
        js.append("    this.gpioInput = numParseInt(((fld.length > 19)? fld[19] : '0'), 0);\n");
        js.append("    this.address   = (fld.length > 20)? decodeUnicode(fld[20].trim()) : '';\n");
        js.append("    if (this.address.startsWith('\\\"')) { this.address = this.address.substring(1); }\n");
        js.append("    if (this.address.endsWith('\\\"')  ) { this.address = this.address.substring(0, this.address.length - 1); }\n");
        js.append("    if (fld.length > 21) {\n");
        js.append("        this.optDesc = new Array();\n");
        js.append("        for (var i = 21; i < fld.length; i++) {\n");
        js.append("            var v = decodeUnicode(fld[i]);\n");
        js.append("            if (v.startsWith('$B64:')) { v = decodeBase64(v.substring(" + MAP_ESCAPE_B64.length() + ")); }\n");
        js.append("            if (v.startsWith('$HTML:')) { v = decodeBase64(v.substring(" + MAP_ESCAPE_HTML.length() + ")); }\n");
        js.append("            this.optDesc.push(v);\n");
        js.append("        }\n");
        js.append("    }\n");
        js.append("};\n");
        js.append("function OptionalEventFieldCount() {\n");
        js.append("    return " + (optionalEventFieldHandler != null ? optionalEventFieldHandler.getOptionalEventFieldCount(isFleet) : 0) + ";\n");
        js.append("};\n");
        js.append("function OptionalEventFieldTitle(ndx) {\n");
        if (optionalEventFieldHandler != null && (optFieldCount = optionalEventFieldHandler.getOptionalEventFieldCount(isFleet)) > 0) {
            js.append("    switch (ndx) {\n");
            for (int i = 0; i < optFieldCount; ++i) {
                String t = optionalEventFieldHandler.getOptionalEventFieldTitle(i, isFleet, locale);
                js.append("        case " + i + ": return \"" + t + "\";\n");
            }
            js.append("    }\n");
        }
        js.append("    return '';\n");
        js.append("};\n");
        return js.toString();
    }

    public String formatMapEvent(BasicPrivateLabel privLabel, EventDataProvider edp, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, int stoppedState, TimeZone tmz, String dateFmt, String timeFmt) {
        char cvsSep = '|';
        return this.formatMapEvent(privLabel, edp, iconSelector, iconKeys, isFleet, stoppedState, tmz, dateFmt, timeFmt, cvsSep);
    }

    public String formatMapEvent(BasicPrivateLabel privLabel, EventDataProvider edp, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, int stoppedState, TimeZone tmz, String dateFmt, String timeFmt, char csvSep) {
        if (edp == null) {
            return "";
        }
        Locale locale = privLabel != null ? privLabel.getLocale() : null;
        StringBuffer sb = new StringBuffer();
        sb.append(EventUtil._encUnicode(edp.getDeviceVIN(), csvSep));
        sb.append(csvSep);
        sb.append(EventUtil._encUnicode(edp.getDeviceDescription(), csvSep));
        sb.append(csvSep);
        long time = edp.getTimestamp();
        sb.append(time);
        sb.append(csvSep);
        DateTime dt = null;
        if (dateFmt != null) {
            dt = new DateTime(time, tmz);
            String dtfmt = dateFmt + csvSep + timeFmt;
            sb.append(dt.format(dtfmt));
        } else {
            sb.append(csvSep);
        }
        sb.append(csvSep);
        if (dt != null) {
            sb.append(dt.format("zzz", tmz));
        }
        sb.append(csvSep);
        boolean MAP_INCL_SC_COLOR = privLabel.getBooleanProperty("trackMap.includeStatusCodeColor", false);
        if (MAP_INCL_SC_COLOR) {
            String scd;
            StatusCodeProvider scp = edp.getStatusCodeProvider(privLabel);
            if (scp == null) {
                scd = edp.getStatusCodeDescription(privLabel);
                sb.append(EventUtil._encUnicode(scd, csvSep));
            } else if (!scp.hasStyle()) {
                scd = scp.getDescription(privLabel.getLocale());
                sb.append(EventUtil._encUnicode(scd, csvSep));
            } else {
                scd = scp.getDescription(privLabel.getLocale());
                StringBuffer sbHtml = new StringBuffer();
                sbHtml.append("<span style=\"").append(scp.getStyleString()).append("\">");
                sbHtml.append(StringTools.htmlFilterText((Object)scd));
                sbHtml.append("</span>");
                String scdHtml = MAP_ESCAPE_HTML + Base64.encode((String)sbHtml.toString());
                sb.append(scdHtml);
            }
        } else {
            String scd = edp.getStatusCodeDescription(privLabel);
            sb.append(EventUtil._encUnicode(scd, csvSep));
        }
        sb.append(csvSep);
        sb.append(edp.getPushpinIconIndex(iconSelector, iconKeys, isFleet, privLabel));
        sb.append(csvSep);
        boolean isGPSLocation = edp.isValidGeoPoint();
        GeoPoint bestGP = isGPSLocation ? edp.getGeoPoint() : edp.getBestGeoPoint();
        sb.append(StringTools.format((double)bestGP.getLatitude(), (String)"0.000000"));
        sb.append(csvSep);
        sb.append(StringTools.format((double)bestGP.getLongitude(), (String)"0.000000"));
        sb.append(csvSep);
        long gpsAge = edp.getGpsAge();
        sb.append(gpsAge);
        sb.append(csvSep);
        long createAge = edp.getCreationAge();
        sb.append(createAge);
        sb.append(csvSep);
        double bestAcc = isGPSLocation ? edp.getHorzAccuracy() : edp.getBestAccuracy();
        sb.append(StringTools.format((double)bestAcc, (String)"0.0"));
        sb.append(csvSep);
        int satCount = isGPSLocation ? edp.getSatelliteCount() : -1;
        sb.append(String.valueOf(satCount));
        sb.append(csvSep);
        sb.append(StringTools.format((double)edp.getSpeedKPH(), (String)"0.0"));
        sb.append(csvSep);
        sb.append(StringTools.format((double)edp.getHeading(), (String)"0.0"));
        sb.append(csvSep);
        sb.append(StringTools.format((double)edp.getAltitude(), (String)"0"));
        sb.append(csvSep);
        sb.append(StringTools.format((double)edp.getOdometerKM(), (String)"0.0"));
        sb.append(csvSep);
        sb.append(stoppedState);
        sb.append(csvSep);
        sb.append(edp.getInputMask());
        sb.append(csvSep);
        sb.append("\"" + EventUtil._encUnicode(edp.getAddress(), csvSep) + "\"");
        if (optionalEventFieldHandler != null) {
            int optFieldCount = optionalEventFieldHandler.getOptionalEventFieldCount(isFleet);
            for (int i = 0; i < optFieldCount; ++i) {
                String v = StringTools.trim((String)optionalEventFieldHandler.getOptionalEventFieldValue(i, isFleet, locale, edp));
                sb.append(csvSep);
                if (v.startsWith(MAP_ESCAPE_HTML)) {
                    String b64 = MAP_ESCAPE_HTML + Base64.encode((String)v.substring(MAP_ESCAPE_HTML.length()));
                    sb.append(b64);
                    continue;
                }
                sb.append(EventUtil._encUnicode(v, csvSep));
            }
        }
        String csv = sb.toString();
        return csv;
    }

    private static String _encUnicode(String str, char csvSep) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < ' ' || ch == '\"' || ch == '\'') continue;
            if (ch == csvSep) {
                sb.append(' ');
                continue;
            }
            if (Character.isDigit(ch)) {
                sb.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch) || Character.isSpaceChar(ch)) {
                sb.append(' ');
                continue;
            }
            if (ch == '\\' || ch == '/') {
                sb.append('/');
                continue;
            }
            if (ch == '<') {
                sb.append('(');
                continue;
            }
            if (ch == '>') {
                sb.append(')');
                continue;
            }
            if (ch == '%') {
                sb.append('%');
                continue;
            }
            if ("!#$()*+,-.:;=[]^_{}?~@/".indexOf(ch) >= 0) {
                sb.append(ch);
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                sb.append(ch);
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                sb.append(ch);
                continue;
            }
            if (ch <= '~') continue;
            sb.append("\\u");
            sb.append(StringTools.hexNybble((int)(ch >> 12 & 0xF)));
            sb.append(StringTools.hexNybble((int)(ch >> 8 & 0xF)));
            sb.append(StringTools.hexNybble((int)(ch >> 4 & 0xF)));
            sb.append(StringTools.hexNybble((int)(ch & 0xF)));
        }
        return sb.toString();
    }

    private PoiProvider[] _getPOI(String accountID, BasicPrivateLabel privLabel) {
        List<PoiProvider> poiList = privLabel.getPointsOfInterest();
        if (!ListTools.isEmpty(poiList)) {
            return poiList.toArray(new PoiProvider[poiList.size()]);
        }
        return null;
    }

    public boolean writeMapEvents(int dataFmt, int indentLevel, PrintWriter pwout, boolean isSoapRequest, boolean isTopLevelTag, BasicPrivateLabel privLabel, EventDataProvider[] edp, boolean includeShapes, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, boolean fleetRoute, String selID, TimeZone tmz, Account acct, User user, DateTime latestTime, double lastBattery, double lastSignal, double minProximityM) throws IOException {
        if (dataFmt == 1) {
            return this.writeMapEvents_xml(indentLevel, pwout, isSoapRequest, isTopLevelTag, privLabel, edp, includeShapes, iconSelector, iconKeys, isFleet, fleetRoute, selID, tmz, acct, user, latestTime, lastBattery, lastSignal, minProximityM, '|');
        }
        return this.writeMapEvents_json(pwout, isSoapRequest, isTopLevelTag, privLabel, edp, includeShapes, iconSelector, iconKeys, isFleet, fleetRoute, selID, tmz, acct, user, latestTime, lastBattery, lastSignal, minProximityM, '|');
    }

    public boolean writeMapEvents_xml(int indentLevel, PrintWriter pwout, boolean isSoapRequest, boolean isTopLevelTag, BasicPrivateLabel privLabel, EventDataProvider[] edp, boolean includeShapes, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, boolean fleetRoute, String selID, TimeZone tmz, Account acct, User user, DateTime latestTime, double lastBattery, double lastSignal, double minProximityM) throws IOException {
        return this.writeMapEvents_xml(indentLevel, pwout, isSoapRequest, isTopLevelTag, privLabel, edp, includeShapes, iconSelector, iconKeys, isFleet, fleetRoute, selID, tmz, acct, user, latestTime, lastBattery, lastSignal, minProximityM, '|');
    }

    private boolean writeMapEvents_xml(int indentLevel, PrintWriter pwout, boolean isSoapRequest, boolean isTopLevelTag, BasicPrivateLabel privLabel, EventDataProvider[] edp, boolean includeShapes, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, boolean fleetRoute, String selID, TimeZone tmz, Account acct, User user, DateTime latestTime, double lastBattery, double lastSignal, double minProximityM, char csvSep) throws IOException {
        String PFX2;
        String timeFmt;
        String accountID = acct != null ? acct.getAccountID() : "?";
        String dateFmt = acct != null ? acct.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String string = timeFmt = acct != null ? acct.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        if (acct != null && tmz == null) {
            tmz = acct.getTimeZone(null);
        }
        String tmzStr = null;
        String PFX1 = indentLevel > 0 ? XMLTools.PREFIX((boolean)isSoapRequest, (int)(indentLevel * 3)) : "";
        String string2 = PFX2 = indentLevel > 0 ? XMLTools.PREFIX((boolean)isSoapRequest, (int)((indentLevel + 1) * 3)) : "";
        if (!isSoapRequest && isTopLevelTag) {
            this.write(pwout, PFX1);
            this.write(pwout, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        this.write(pwout, PFX1);
        this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_MapData, (String)XMLTools.ATTR((String)ATTR_isFleet, (boolean)isFleet), (boolean)false, (boolean)true));
        DateTime today = new DateTime(tmz);
        String todayTmzFmt = tmzStr != null ? tmzStr : today.format("zzz", tmz);
        this.write(pwout, PFX2);
        this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)"Time", (String)(XMLTools.ATTR((String)ATTR_timestamp, (long)today.getTimeSec()) + XMLTools.ATTR((String)ATTR_timezone, (String)todayTmzFmt) + XMLTools.ATTR((String)ATTR_year, (int)today.getYear(tmz)) + XMLTools.ATTR((String)ATTR_month, (int)today.getMonth1(tmz)) + XMLTools.ATTR((String)ATTR_day, (int)today.getDayOfMonth(tmz))), (boolean)false, (boolean)false));
        this.write(pwout, today.format(dateFmt, tmz) + csvSep + today.format(timeFmt, tmz));
        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)"Time", (boolean)true));
        if (!isFleet && latestTime != null) {
            String lastTmzFmt = tmzStr != null ? tmzStr : latestTime.format("zzz", tmz);
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)"LastEvent", (String)(XMLTools.ATTR((String)"device", (String)selID) + XMLTools.ATTR((String)ATTR_timestamp, (long)latestTime.getTimeSec()) + XMLTools.ATTR((String)ATTR_timezone, (String)lastTmzFmt) + XMLTools.ATTR((String)ATTR_year, (int)latestTime.getYear(tmz)) + XMLTools.ATTR((String)ATTR_month, (int)latestTime.getMonth1(tmz)) + XMLTools.ATTR((String)ATTR_day, (int)latestTime.getDayOfMonth(tmz)) + XMLTools.ATTR((String)ATTR_battery, (Object)lastBattery) + XMLTools.ATTR((String)ATTR_signal, (Object)lastSignal)), (boolean)false, (boolean)false));
            this.write(pwout, latestTime.format(dateFmt, tmz) + csvSep + latestTime.format(timeFmt, tmz));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)"LastEvent", (boolean)true));
        }
        boolean includeParkedGeofence = includeShapes;
        if (!includeShapes && !includeParkedGeofence) {
            Print.logDebug((String)"(XML) Geozone shapes are not included", (Object[])new Object[0]);
        } else if (edp != null && acct != null) {
            String nearbyGzRadM = StringTools.trim((String)privLabel.getStringProperty("trackMap.showNearbyGeozones", ""));
            double NEARBY_GEOZONE_RADIUS = 0.0;
            if (StringTools.isBlank((String)nearbyGzRadM) || nearbyGzRadM.equalsIgnoreCase("false")) {
                NEARBY_GEOZONE_RADIUS = 0.0;
            } else if (nearbyGzRadM.equalsIgnoreCase("true")) {
                NEARBY_GEOZONE_RADIUS = 1000.0;
            } else {
                NEARBY_GEOZONE_RADIUS = StringTools.parseDouble((String)nearbyGzRadM, (double)0.0);
                if (NEARBY_GEOZONE_RADIUS > 10000.0) {
                    NEARBY_GEOZONE_RADIUS = 10000.0;
                }
            }
            boolean GET_ALL_CONTAINED_GEOZONES = privLabel.getBooleanProperty("trackMap.showAllContainedGeozones", true);
            if (NEARBY_GEOZONE_RADIUS > 0.0) {
                Print.logDebug((String)("(XML) [" + accountID + "] Including all nearby Geozone shapes found [" + NEARBY_GEOZONE_RADIUS + "]"), (Object[])new Object[0]);
            } else if (GET_ALL_CONTAINED_GEOZONES) {
                Print.logDebug((String)("(XML) [" + accountID + "] Including all contained Geozone shapes found"), (Object[])new Object[0]);
            } else {
                Print.logDebug((String)("(XML) [" + accountID + "] Including only 'geozoneID' Geozone shapes found"), (Object[])new Object[0]);
            }
            if (includeParkedGeofence && !isFleet && !ListTools.isEmpty((Object[])edp) && edp[0] instanceof EventData) {
                double pRad;
                Device dev = ((EventData)edp[0]).getDevice();
                String devID = dev != null ? dev.getDeviceID() : "?";
                double pLat = dev != null ? dev.getParkedLatitude() : 0.0;
                double pLon = dev != null ? dev.getParkedLongitude() : 0.0;
                double d = pRad = dev != null ? dev.getParkedRadius() : 0.0;
                if (pRad > 0.0 && GeoPoint.isValid((double)pLat, (double)pLon)) {
                    Print.logDebug((String)("(XML) [" + accountID + "/" + devID + "] Found parked location: " + pLat + "/" + pLon + " radius=" + pRad), (Object[])new Object[0]);
                    this.write(pwout, PFX2);
                    this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Shape, (String)(XMLTools.ATTR((String)"type", (String)"circle") + XMLTools.ATTR((String)"radius", (Object)pRad) + XMLTools.ATTR((String)"color", (String)"#0000FF")), (boolean)false, (boolean)false));
                    this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)(pLat + "/" + pLon)));
                    this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Shape, (boolean)true));
                }
            }
            GeoBounds gzgb = new GeoBounds();
            HashSet<String> zoneShapes = null;
            for (EventDataProvider e : edp) {
                String devID = e.getDeviceID();
                GeoPoint egp = e.getGeoPoint();
                gzgb.extendByPoint((GeoPointProvider)egp);
                String zid = e.getGeozoneID();
                if (!GET_ALL_CONTAINED_GEOZONES && StringTools.isBlank((String)zid)) continue;
                if (zoneShapes == null) {
                    zoneShapes = new HashSet<String>();
                }
                if (zoneShapes.contains(zid)) continue;
                Geozone[] zone = null;
                try {
                    zone = GET_ALL_CONTAINED_GEOZONES ? Geozone.getGeozones(acct.getAccountID(), egp) : Geozone.getGeozone(acct, zid);
                }
                catch (DBException dbe) {
                    zone = null;
                }
                if (ListTools.size((Object[])zone) > 0) {
                    block15: for (int iz = zone.length - 1; iz >= 0; --iz) {
                        Geozone z = zone[iz];
                        String zoneID = z.getGeozoneID();
                        if (zoneShapes.contains(zoneID)) continue;
                        zoneShapes.add(zoneID);
                        Print.logDebug((String)("(XML) [" + accountID + "/" + devID + "] Found Geozone: " + zoneID), (Object[])new Object[0]);
                        String type = "circle";
                        switch (Geozone.getGeozoneType(z)) {
                            case POINT_RADIUS: {
                                type = "circle";
                                break;
                            }
                            case BOUNDED_RECT: {
                                type = "rectangle";
                                break;
                            }
                            case POLYGON: {
                                type = "polygon";
                                break;
                            }
                            default: {
                                continue block15;
                            }
                        }
                        int radiusM = z.getRadius();
                        String color = z.getShapeColor("#00FF00");
                        Object[] gp = z.getGeoPoints();
                        this.write(pwout, PFX2);
                        this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Shape, (String)(XMLTools.ATTR((String)"type", (String)type) + XMLTools.ATTR((String)"radius", (int)radiusM) + XMLTools.ATTR((String)"color", (String)color)), (boolean)false, (boolean)false));
                        this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)StringTools.join((Object[])gp, (String)",")));
                        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Shape, (boolean)true));
                    }
                    continue;
                }
                if (StringTools.isBlank((String)zid)) continue;
                zoneShapes.add(zid);
            }
            if (NEARBY_GEOZONE_RADIUS > 0.0) {
                gzgb.extendByRadius(NEARBY_GEOZONE_RADIUS);
                Geozone[] zone = null;
                try {
                    zone = Geozone.getGeozones(acct.getAccountID(), gzgb);
                }
                catch (DBException dbe) {
                    zone = null;
                }
                if (ListTools.size((Object[])zone) > 0) {
                    block16: for (int iz = zone.length - 1; iz >= 0; --iz) {
                        Geozone z = zone[iz];
                        String zoneID = z.getGeozoneID();
                        if (zoneShapes.contains(zoneID)) continue;
                        zoneShapes.add(zoneID);
                        Print.logDebug((String)("(XML) [" + accountID + "] Found Nearby Geozone: " + zoneID), (Object[])new Object[0]);
                        String type = "circle";
                        switch (Geozone.getGeozoneType(z)) {
                            case POINT_RADIUS: {
                                type = "circle";
                                break;
                            }
                            case BOUNDED_RECT: {
                                type = "rectangle";
                                break;
                            }
                            case POLYGON: {
                                type = "polygon";
                                break;
                            }
                            default: {
                                continue block16;
                            }
                        }
                        int radiusM = z.getRadius();
                        String color = z.getShapeColor("#00FF00");
                        Object[] gp = z.getGeoPoints();
                        this.write(pwout, PFX2);
                        this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Shape, (String)(XMLTools.ATTR((String)"type", (String)type) + XMLTools.ATTR((String)"radius", (int)radiusM) + XMLTools.ATTR((String)"color", (String)color)), (boolean)false, (boolean)false));
                        this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)StringTools.join((Object[])gp, (String)",")));
                        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Shape, (boolean)true));
                    }
                }
            }
        }
        this.write(pwout, PFX2);
        this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)"DataColumns", (String)"", (boolean)false, (boolean)false));
        this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)"id|desc|epoch|date|time|tmz|status|icon|lat|lon|acc|sats|kph|heading|alt|odomkm|addr|"));
        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)"DataColumns", (boolean)true));
        this._writeMapPoi_xml(indentLevel > 0 ? indentLevel + 1 : 0, pwout, isSoapRequest, privLabel, this._getPOI(acct != null ? acct.getAccountID() : null, privLabel), iconKeys, csvSep);
        boolean rtn = this._writeMapEvents_xml(indentLevel > 0 ? indentLevel + 1 : 0, pwout, isSoapRequest, privLabel, edp, iconSelector, iconKeys, isFleet, fleetRoute, selID, tmz, dateFmt, timeFmt, csvSep, minProximityM);
        this.write(pwout, PFX1);
        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_MapData, (boolean)true));
        this.flush(pwout);
        return rtn;
    }

    private boolean _writeMapPoi_xml(int indentLevel, PrintWriter pwout, boolean isSoapRequest, BasicPrivateLabel privLabel, PoiProvider[] poip, OrderedSet<String> iconKeys, char csvSep) throws IOException {
        if (ListTools.isEmpty((Object[])poip)) {
            return false;
        }
        String PFX1 = indentLevel > 0 ? XMLTools.PREFIX((boolean)isSoapRequest, (int)(indentLevel * 3)) : "";
        String PFX2 = indentLevel > 0 ? XMLTools.PREFIX((boolean)isSoapRequest, (int)((indentLevel + 1) * 3)) : "";
        String type = DSTYPE_poi;
        this.write(pwout, PFX1);
        this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_DataSet, (String)(XMLTools.ATTR((String)"type", (String)type) + XMLTools.ATTR((String)"route", (boolean)false)), (boolean)false, (boolean)true));
        for (int i = 0; i < poip.length; ++i) {
            final PoiProvider pp = poip[i];
            EventDataProviderAdapter edp = new EventDataProviderAdapter(){

                @Override
                public String getAccountID() {
                    return pp.getAccountID();
                }

                @Override
                public String getDeviceID() {
                    return pp.getPoiID();
                }

                @Override
                public String getDeviceDescription() {
                    return pp.getPoiDescription();
                }

                @Override
                public double getLatitude() {
                    return pp.getLatitude();
                }

                @Override
                public double getLongitude() {
                    return pp.getLongitude();
                }

                @Override
                public String getAddress() {
                    return pp.getAddress();
                }

                @Override
                public int getPushpinIconIndex(String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, BasicPrivateLabel bpl) {
                    return pp.getPushpinIconIndex(iconKeys, bpl);
                }
            };
            Print.logDebug((String)("(XML) Found POI: " + edp.getGeoPoint()), (Object[])new Object[0]);
            String rcd = this.formatMapEvent(privLabel, edp, null, iconKeys, false, 1, null, null, null, csvSep);
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Point, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)rcd));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Point, (boolean)true));
        }
        this.write(pwout, PFX1);
        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_DataSet, (boolean)true));
        this.flush(pwout);
        return true;
    }

    private boolean _writeMapEvents_xml(int indentLevel, PrintWriter pwout, boolean isSoapRequest, BasicPrivateLabel privLabel, EventDataProvider[] edp, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, boolean fleetRoute, String selID, TimeZone tmz, String dateFmt, String timeFmt, char csvSep, double minProximityM) throws IOException {
        if (ListTools.isEmpty((Object[])edp)) {
            return false;
        }
        boolean useRouteDisplayColor = privLabel != null ? privLabel.getBooleanProperty("trackMap.useRouteDisplayColor", true) : true;
        String PFX1 = indentLevel > 0 ? XMLTools.PREFIX((boolean)isSoapRequest, (int)(indentLevel * 3)) : "";
        String PFX2 = indentLevel > 0 ? XMLTools.PREFIX((boolean)isSoapRequest, (int)((indentLevel + 1) * 3)) : "";
        boolean isDeviceData = !isFleet;
        boolean didStartSet = false;
        GeoPoint lastGP = null;
        String lastDevID = "";
        String routeColor = "";
        String textColor = "";
        int evNdx = 0;
        boolean startStopOK = false;
        int stoppedState = -1;
        for (int i = 0; i < edp.length; ++i) {
            String sfi;
            double lon;
            double lat;
            EventData ev = edp[i] instanceof EventData ? (EventData)edp[i] : null;
            String thisDevID = edp[i].getDeviceID();
            if (!thisDevID.equals(lastDevID)) {
                Device dev = ((EventData)edp[i]).getDevice();
                if (isFleet) {
                    if (didStartSet) {
                        this.write(pwout, PFX1);
                        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_DataSet, (boolean)true));
                        didStartSet = false;
                    }
                    isDeviceData = true;
                    selID = thisDevID;
                }
                lastDevID = thisDevID;
                lastGP = null;
                textColor = "";
                routeColor = "";
                boolean bl = startStopOK = dev != null && dev.getStartStopSupported();
                if (edp[i] instanceof EventData && (isFleet || useRouteDisplayColor) && dev != null && dev.hasDisplayColor()) {
                    if (isFleet) {
                        textColor = dev.getDisplayColor();
                    }
                    if (useRouteDisplayColor) {
                        routeColor = dev.getDisplayColor();
                    }
                }
            }
            edp[i].setEventIndex(evNdx++);
            if (ev == null) {
                stoppedState = edp[i].getSpeedKPH() <= 0.0 ? 1 : 0;
            } else if (!startStopOK) {
                stoppedState = edp[i].getSpeedKPH() <= 0.0 ? 1 : 0;
                ev.setStopped(stoppedState == 1);
            } else {
                if (stoppedState < 0) {
                    int n = stoppedState = edp[i].getSpeedKPH() <= 0.0 ? -1 : 0;
                }
                if (stoppedState >= 0) {
                    if (stoppedState > 0) {
                        if (ev == null) {
                            stoppedState = edp[i].getSpeedKPH() <= 0.0 ? 1 : 0;
                        } else if (ev.isStartEvent(true)) {
                            stoppedState = 0;
                            ev.setStopped(false);
                        } else {
                            stoppedState = 1;
                            ev.setStopped(true);
                        }
                    } else if (ev == null) {
                        stoppedState = edp[i].getSpeedKPH() <= 0.0 ? 1 : 0;
                    } else if (ev.isStopEvent(true)) {
                        stoppedState = 2;
                        ev.setStopped(true);
                    } else {
                        stoppedState = 0;
                        ev.setStopped(false);
                    }
                }
            }
            if (i + 1 >= edp.length) {
                edp[i].setIsLastEvent(true);
            } else {
                String nextDevID = edp[i + 1].getDeviceID();
                if (!thisDevID.equals(nextDevID)) {
                    edp[i].setIsLastEvent(true);
                    evNdx = 0;
                }
            }
            if (minProximityM > 0.0 && GeoPoint.isValid((double)(lat = edp[i].getLatitude()), (double)(lon = edp[i].getLongitude()))) {
                GeoPoint thisGP = new GeoPoint(lat, lon);
                if (lastGP == null) {
                    lastGP = thisGP;
                } else {
                    if (!(thisGP.metersToPoint(lastGP) >= minProximityM)) continue;
                    lastGP = thisGP;
                }
            }
            if (!didStartSet) {
                String type = isDeviceData ? "device" : DSTYPE_group;
                this.write(pwout, PFX1);
                this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_DataSet, (String)(XMLTools.ATTR((String)"type", (String)type) + XMLTools.ATTR((String)"id", (String)selID) + XMLTools.ATTR((String)"route", (boolean)isDeviceData) + XMLTools.ATTR((String)"routeColor", (String)routeColor) + XMLTools.ATTR((String)"textColor", (String)textColor)), (boolean)false, (boolean)true));
                didStartSet = true;
            }
            boolean showFleetIcon = !isFleet ? false : (StringTools.isBlank((String)(sfi = privLabel.getStringProperty("trackMap.showFleetMapDevicePushpin", ""))) || sfi.equalsIgnoreCase("default") ? (!fleetRoute ? true : edp[i].getIsLastEvent()) : StringTools.parseBoolean((String)sfi, (boolean)false));
            String rcd = this.formatMapEvent(privLabel, edp[i], iconSelector, iconKeys, showFleetIcon, stoppedState, tmz, dateFmt, timeFmt, csvSep);
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Point, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)rcd));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Point, (boolean)true));
        }
        if (didStartSet) {
            this.write(pwout, PFX1);
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_DataSet, (boolean)true));
        }
        return true;
    }

    private boolean writeMapEvents_json(PrintWriter pwout, boolean isSoapRequest, boolean isTopLevelTag, BasicPrivateLabel privLabel, EventDataProvider[] edp, boolean includeShapes, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, boolean fleetRoute, String selID, TimeZone tmz, Account acct, User user, DateTime latestTime, double lastBattery, double lastSignal, double minProximityM) throws IOException {
        return this.writeMapEvents_json(pwout, isSoapRequest, isTopLevelTag, privLabel, edp, includeShapes, iconSelector, iconKeys, isFleet, fleetRoute, selID, tmz, acct, user, latestTime, lastBattery, lastSignal, minProximityM, '|');
    }

    private boolean writeMapEvents_json(PrintWriter pwout, boolean isSoapRequest, boolean isTopLevelTag, BasicPrivateLabel privLabel, EventDataProvider[] edp, boolean includeShapes, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, boolean fleetRoute, String selID, TimeZone tmz, Account acct, User user, DateTime latestTime, double lastBattery, double lastSignal, double minProximityM, char csvSep) throws IOException {
        JSON._Object JMapData = this.getJMapData_JSON(privLabel, edp, includeShapes, iconSelector, iconKeys, isFleet, fleetRoute, selID, tmz, acct, user, latestTime, lastBattery, lastSignal, minProximityM, null, csvSep);
        JSON._Object jsonObj = new JSON._Object();
        jsonObj.addKeyValue(JSON_JMapData, JMapData);
        String jsonStr = jsonObj.toString(false);
        this.write(pwout, jsonStr);
        this.flush(pwout);
        return true;
    }

    public JSON._Object getJMapData_JSON(BasicPrivateLabel privLabel, EventDataProvider[] edp, boolean includeShapes, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, boolean fleetRoute, String selID, TimeZone tmz, Account acct, User user, DateTime latestTime, double lastBattery, double lastSignal, double minProximityM, Collection<String> actions, char csvSep) {
        String timeFmt;
        String accountID = acct != null ? acct.getAccountID() : "?";
        String dateFmt = acct != null ? acct.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String string = timeFmt = acct != null ? acct.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        if (acct != null && tmz == null) {
            tmz = acct.getTimeZone(null);
        }
        String tmzStr = null;
        JSON._Object jMapDataObj = new JSON._Object();
        jMapDataObj.addKeyValue(ATTR_isFleet, isFleet);
        DateTime today = new DateTime(tmz);
        String todayTmzFmt = tmzStr != null ? tmzStr : today.format("zzz", tmz);
        JSON._Object timeObj = new JSON._Object();
        timeObj.addKeyValue(ATTR_timestamp, today.getTimeSec());
        timeObj.addKeyValue(ATTR_timezone, todayTmzFmt);
        JSON._Object ymdObj = new JSON._Object();
        ymdObj.addKeyValue(JSON_year, today.getYear(tmz));
        ymdObj.addKeyValue(JSON_month, today.getMonth1(tmz));
        ymdObj.addKeyValue(JSON_day, today.getDayOfMonth(tmz));
        timeObj.addKeyValue(JSON_YMD, ymdObj);
        timeObj.addKeyValue(JSON_date, today.format(dateFmt, tmz));
        timeObj.addKeyValue(JSON_time, today.format(timeFmt, tmz));
        jMapDataObj.addKeyValue("Time", timeObj);
        if (!isFleet && latestTime != null) {
            String lastTmzFmt = tmzStr != null ? tmzStr : latestTime.format("zzz", tmz);
            JSON._Object lastEventObj = new JSON._Object();
            lastEventObj.addKeyValue("device", selID);
            lastEventObj.addKeyValue(ATTR_timestamp, latestTime.getTimeSec());
            lastEventObj.addKeyValue(ATTR_timezone, lastTmzFmt);
            JSON._Object ymdObj2 = new JSON._Object();
            ymdObj2.addKeyValue(JSON_year, latestTime.getYear(tmz));
            ymdObj2.addKeyValue(JSON_month, latestTime.getMonth1(tmz));
            ymdObj2.addKeyValue(JSON_day, latestTime.getDayOfMonth(tmz));
            lastEventObj.addKeyValue(JSON_YMD, ymdObj2);
            lastEventObj.addKeyValue(JSON_date, latestTime.format(dateFmt, tmz));
            lastEventObj.addKeyValue(JSON_time, latestTime.format(timeFmt, tmz));
            lastEventObj.addKeyValue(ATTR_battery, lastBattery);
            lastEventObj.addKeyValue(ATTR_signal, lastSignal);
            jMapDataObj.addKeyValue("LastEvent", lastEventObj);
        }
        boolean includeParkedGeofence = includeShapes;
        if (!includeShapes && !includeParkedGeofence) {
            Print.logDebug((String)("(JSON) [" + accountID + "] Geozone shapes are not included"), (Object[])new Object[0]);
        } else if (edp != null && acct != null) {
            JSON._Array pointArray;
            JSON._Object shapeObj;
            JSON._Array shapeArray = new JSON._Array();
            String nearbyGzRadM = StringTools.trim((String)privLabel.getStringProperty("trackMap.showNearbyGeozones", ""));
            double NEARBY_GEOZONE_RADIUS = 0.0;
            if (StringTools.isBlank((String)nearbyGzRadM) || nearbyGzRadM.equalsIgnoreCase("false")) {
                NEARBY_GEOZONE_RADIUS = 0.0;
            } else if (nearbyGzRadM.equalsIgnoreCase("true")) {
                NEARBY_GEOZONE_RADIUS = 1000.0;
            } else {
                NEARBY_GEOZONE_RADIUS = StringTools.parseDouble((String)nearbyGzRadM, (double)0.0);
                if (NEARBY_GEOZONE_RADIUS > 10000.0) {
                    NEARBY_GEOZONE_RADIUS = 10000.0;
                }
            }
            boolean GET_ALL_CONTAINED_GEOZONES = privLabel.getBooleanProperty("trackMap.showAllContainedGeozones", true);
            if (NEARBY_GEOZONE_RADIUS > 0.0) {
                Print.logDebug((String)("(JSON) [" + accountID + "] Including all nearby Geozone shapes found [" + NEARBY_GEOZONE_RADIUS + "]"), (Object[])new Object[0]);
            } else if (GET_ALL_CONTAINED_GEOZONES) {
                Print.logDebug((String)("(JSON) [" + accountID + "] Including all contained Geozone shapes found"), (Object[])new Object[0]);
            } else {
                Print.logDebug((String)("(JSON) [" + accountID + "] Including only 'geozoneID' Geozone shapes found"), (Object[])new Object[0]);
            }
            if (includeParkedGeofence && !isFleet && !ListTools.isEmpty((Object[])edp) && edp[0] instanceof EventData) {
                double pRad;
                Device dev = ((EventData)edp[0]).getDevice();
                String devID = dev != null ? dev.getDeviceID() : "?";
                double pLat = dev != null ? dev.getParkedLatitude() : 0.0;
                double pLon = dev != null ? dev.getParkedLongitude() : 0.0;
                double d = pRad = dev != null ? dev.getParkedRadius() : 0.0;
                if (pRad > 0.0 && GeoPoint.isValid((double)pLat, (double)pLon)) {
                    Print.logDebug((String)("(JSON) [" + accountID + "/" + devID + "] Found parked location: " + pLat + "/" + pLon + " radius=" + pRad), (Object[])new Object[0]);
                    shapeObj = new JSON._Object();
                    shapeObj.addKeyValue("type", "circle");
                    shapeObj.addKeyValue("radius", pRad);
                    shapeObj.addKeyValue("color", "#0000FF");
                    pointArray = new JSON._Array();
                    pointArray.addValue(pLat + "/" + pLon);
                    shapeObj.addKeyValue(JSON_Points, pointArray);
                    shapeArray.addValue(shapeObj);
                }
            }
            GeoBounds gzgb = new GeoBounds();
            HashSet<String> zoneShapes = null;
            for (EventDataProvider e : edp) {
                String devID = e.getDeviceID();
                GeoPoint egp = e.getGeoPoint();
                gzgb.extendByPoint((GeoPointProvider)egp);
                String zid = e.getGeozoneID();
                if (!GET_ALL_CONTAINED_GEOZONES && StringTools.isBlank((String)zid)) continue;
                if (zoneShapes == null) {
                    zoneShapes = new HashSet<String>();
                }
                if (zoneShapes.contains(zid)) continue;
                Geozone[] zone = null;
                try {
                    zone = GET_ALL_CONTAINED_GEOZONES ? Geozone.getGeozones(acct.getAccountID(), egp) : Geozone.getGeozone(acct, zid);
                }
                catch (DBException dbe) {
                    zone = null;
                }
                if (ListTools.size((Object[])zone) > 0) {
                    block15: for (int iz = zone.length - 1; iz >= 0; --iz) {
                        Geozone z = zone[iz];
                        String zoneID = z.getGeozoneID();
                        if (zoneShapes.contains(zoneID)) continue;
                        zoneShapes.add(zoneID);
                        Print.logDebug((String)("(JSON) [" + accountID + "/" + devID + "] Found Geozone: " + zoneID), (Object[])new Object[0]);
                        String type = "circle";
                        switch (Geozone.getGeozoneType(z)) {
                            case POINT_RADIUS: {
                                type = "circle";
                                break;
                            }
                            case BOUNDED_RECT: {
                                type = "rectangle";
                                break;
                            }
                            case POLYGON: {
                                type = "polygon";
                                break;
                            }
                            default: {
                                continue block15;
                            }
                        }
                        GeoPoint[] gpList = z.getGeoPoints();
                        JSON._Object shapeObj2 = new JSON._Object();
                        shapeObj2.addKeyValue("type", type);
                        shapeObj2.addKeyValue("radius", z.getRadius());
                        shapeObj2.addKeyValue("color", z.getShapeColor("#00FF00"));
                        JSON._Array pointArray2 = new JSON._Array();
                        for (GeoPoint gp : z.getGeoPoints()) {
                            pointArray2.addValue(gp.toString());
                        }
                        shapeObj2.addKeyValue(JSON_Points, pointArray2);
                        shapeArray.addValue(shapeObj2);
                    }
                    continue;
                }
                if (StringTools.isBlank((String)zid)) continue;
                zoneShapes.add(zid);
            }
            if (NEARBY_GEOZONE_RADIUS > 0.0) {
                gzgb.extendByRadius(NEARBY_GEOZONE_RADIUS);
                Geozone[] zone = null;
                try {
                    zone = Geozone.getGeozones(acct.getAccountID(), gzgb);
                }
                catch (DBException dbe) {
                    zone = null;
                }
                if (ListTools.size((Object[])zone) > 0) {
                    block17: for (int iz = zone.length - 1; iz >= 0; --iz) {
                        Geozone z = zone[iz];
                        String zoneID = z.getGeozoneID();
                        if (zoneShapes.contains(zoneID)) continue;
                        zoneShapes.add(zoneID);
                        Print.logDebug((String)("(JSON) [" + accountID + "] Found Nearby Geozone: " + zoneID), (Object[])new Object[0]);
                        String type = "circle";
                        switch (Geozone.getGeozoneType(z)) {
                            case POINT_RADIUS: {
                                type = "circle";
                                break;
                            }
                            case BOUNDED_RECT: {
                                type = "rectangle";
                                break;
                            }
                            case POLYGON: {
                                type = "polygon";
                                break;
                            }
                            default: {
                                continue block17;
                            }
                        }
                        GeoPoint[] gpList = z.getGeoPoints();
                        shapeObj = new JSON._Object();
                        shapeObj.addKeyValue("type", type);
                        shapeObj.addKeyValue("radius", z.getRadius());
                        shapeObj.addKeyValue("color", z.getShapeColor("#00FF00"));
                        pointArray = new JSON._Array();
                        for (GeoPoint gp : z.getGeoPoints()) {
                            pointArray.addValue(gp.toString());
                        }
                        shapeObj.addKeyValue(JSON_Points, pointArray);
                        shapeArray.addValue(shapeObj);
                    }
                }
            }
            if (!shapeArray.isEmpty()) {
                jMapDataObj.addKeyValue(JSON_Shapes, shapeArray);
            }
        }
        jMapDataObj.addKeyValue("DataColumns", "Desc|Epoch|Date|Time|Tmz|Stat|Icon|Lat|Lon|#Sats|kph|Heading|Alt|Addr");
        JSON._Array dataSetArray = new JSON._Array();
        this._getMapPoi_json(dataSetArray, privLabel, this._getPOI(acct != null ? acct.getAccountID() : null, privLabel), iconKeys, csvSep);
        boolean rtn = this._addDataSet_json(dataSetArray, privLabel, edp, iconSelector, iconKeys, isFleet, fleetRoute, selID, tmz, dateFmt, timeFmt, csvSep, minProximityM);
        jMapDataObj.addKeyValue(JSON_DataSets, dataSetArray);
        if (!ListTools.isEmpty(actions)) {
            JSON._Array actionArray = new JSON._Array();
            for (String a : actions) {
                String arg;
                int p = a.indexOf("|");
                String command = p >= 0 ? a.substring(0, p) : a;
                String string2 = arg = p >= 0 ? a.substring(p + 1) : "";
                if (StringTools.isBlank((String)command)) continue;
                JSON._Object act = new JSON._Object();
                act.addKeyValue(JSON_cmd, command);
                act.addKeyValue(JSON_arg, arg);
                actionArray.addValue(act);
            }
            if (!actionArray.isEmpty()) {
                jMapDataObj.addKeyValue(JSON_Actions, actionArray);
            }
        }
        return jMapDataObj;
    }

    private boolean _getMapPoi_json(JSON._Array dataSetArray, BasicPrivateLabel privLabel, PoiProvider[] poip, OrderedSet<String> iconKeys, char csvSep) {
        if (ListTools.isEmpty((Object[])poip)) {
            return false;
        }
        JSON._Object poiObj = new JSON._Object();
        poiObj.addKeyValue("type", DSTYPE_poi);
        poiObj.addKeyValue("route", false);
        JSON._Array pointArray = new JSON._Array();
        poiObj.addKeyValue(JSON_Points, pointArray);
        dataSetArray.addValue(poiObj);
        for (int i = 0; i < poip.length; ++i) {
            final PoiProvider pp = poip[i];
            EventDataProviderAdapter edp = new EventDataProviderAdapter(){

                @Override
                public String getAccountID() {
                    return pp.getAccountID();
                }

                @Override
                public String getDeviceID() {
                    return pp.getPoiID();
                }

                @Override
                public String getDeviceDescription() {
                    return pp.getPoiDescription();
                }

                @Override
                public double getLatitude() {
                    return pp.getLatitude();
                }

                @Override
                public double getLongitude() {
                    return pp.getLongitude();
                }

                @Override
                public String getAddress() {
                    return pp.getAddress();
                }

                @Override
                public int getPushpinIconIndex(String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, BasicPrivateLabel bpl) {
                    return pp.getPushpinIconIndex(iconKeys, bpl);
                }
            };
            Print.logDebug((String)("(JSON) Found POI: " + edp.getGeoPoint()), (Object[])new Object[0]);
            String rcd = this.formatMapEvent(privLabel, edp, null, iconKeys, false, 1, null, null, null, csvSep);
            pointArray.addValue(rcd);
        }
        return true;
    }

    private boolean _addDataSet_json(JSON._Array dataSetArray, BasicPrivateLabel privLabel, EventDataProvider[] edp, String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, boolean fleetRoute, String selID, TimeZone tmz, String dateFmt, String timeFmt, char csvSep, double minProximityM) {
        if (ListTools.isEmpty((Object[])edp)) {
            return false;
        }
        boolean useRouteDisplayColor = privLabel != null ? privLabel.getBooleanProperty("trackMap.useRouteDisplayColor", true) : true;
        JSON._Array pointArray = null;
        boolean isDeviceData = !isFleet;
        boolean didStartSet = false;
        GeoPoint lastGP = null;
        String lastDevID = "";
        String routeColor = "";
        String textColor = "";
        int evNdx = 0;
        boolean startStopOK = false;
        int stoppedState = -1;
        for (int i = 0; i < edp.length; ++i) {
            String sfi;
            double lon;
            double lat;
            EventData ev = edp[i] instanceof EventData ? (EventData)edp[i] : null;
            String thisDevID = edp[i].getDeviceID();
            if (!thisDevID.equals(lastDevID)) {
                Device dev = ((EventData)edp[i]).getDevice();
                if (isFleet) {
                    if (didStartSet) {
                        didStartSet = false;
                    }
                    isDeviceData = true;
                    selID = thisDevID;
                }
                lastDevID = thisDevID;
                lastGP = null;
                textColor = "";
                routeColor = "";
                boolean bl = startStopOK = dev != null && dev.getStartStopSupported();
                if (edp[i] instanceof EventData && (isFleet || useRouteDisplayColor) && dev != null && dev.hasDisplayColor()) {
                    if (isFleet) {
                        textColor = dev.getDisplayColor();
                    }
                    if (useRouteDisplayColor) {
                        routeColor = dev.getDisplayColor();
                    }
                }
            }
            edp[i].setEventIndex(evNdx++);
            if (ev == null) {
                stoppedState = edp[i].getSpeedKPH() <= 0.0 ? 1 : 0;
            } else if (!startStopOK) {
                stoppedState = edp[i].getSpeedKPH() <= 0.0 ? 1 : 0;
                ev.setStopped(stoppedState == 1);
            } else {
                if (stoppedState < 0) {
                    int n = stoppedState = edp[i].getSpeedKPH() <= 0.0 ? -1 : 0;
                }
                if (stoppedState >= 0) {
                    if (stoppedState > 0) {
                        if (ev == null) {
                            stoppedState = edp[i].getSpeedKPH() <= 0.0 ? 1 : 0;
                        } else if (ev.isStartEvent(true)) {
                            stoppedState = 0;
                            ev.setStopped(false);
                        } else {
                            stoppedState = 1;
                            ev.setStopped(true);
                        }
                    } else if (ev == null) {
                        stoppedState = edp[i].getSpeedKPH() <= 0.0 ? 1 : 0;
                    } else if (ev.isStopEvent(true)) {
                        stoppedState = 2;
                        ev.setStopped(true);
                    } else {
                        stoppedState = 0;
                        ev.setStopped(false);
                    }
                }
            }
            if (i + 1 >= edp.length) {
                edp[i].setIsLastEvent(true);
            } else {
                String nextDevID = edp[i + 1].getDeviceID();
                if (!thisDevID.equals(nextDevID)) {
                    edp[i].setIsLastEvent(true);
                    evNdx = 0;
                }
            }
            if (minProximityM > 0.0 && GeoPoint.isValid((double)(lat = edp[i].getLatitude()), (double)(lon = edp[i].getLongitude()))) {
                GeoPoint thisGP = new GeoPoint(lat, lon);
                if (lastGP == null) {
                    lastGP = thisGP;
                } else {
                    if (!(thisGP.metersToPoint(lastGP) >= minProximityM)) continue;
                    lastGP = thisGP;
                }
            }
            if (!didStartSet) {
                String type = isDeviceData ? "device" : DSTYPE_group;
                JSON._Object dataSetObj = new JSON._Object();
                dataSetObj.addKeyValue("type", type);
                dataSetObj.addKeyValue("id", selID);
                dataSetObj.addKeyValue("route", isDeviceData);
                dataSetObj.addKeyValue("routeColor", routeColor);
                dataSetObj.addKeyValue("textColor", textColor);
                pointArray = new JSON._Array();
                dataSetObj.addKeyValue(JSON_Points, pointArray);
                dataSetArray.addValue(dataSetObj);
                didStartSet = true;
            }
            boolean showFleetIcon = !isFleet ? false : (StringTools.isBlank((String)(sfi = privLabel.getStringProperty("trackMap.showFleetMapDevicePushpin", ""))) || sfi.equalsIgnoreCase("default") ? (!fleetRoute ? true : edp[i].getIsLastEvent()) : StringTools.parseBoolean((String)sfi, (boolean)false));
            String rcd = this.formatMapEvent(privLabel, edp[i], iconSelector, iconKeys, showFleetIcon, stoppedState, tmz, dateFmt, timeFmt, csvSep);
            pointArray.addValue(rcd);
        }
        if (didStartSet) {
            didStartSet = false;
        }
        return true;
    }

    private void writeEvents_XML_Event(PrintWriter pwout, Device dev, EventData ev, int indent, boolean allTags, BasicPrivateLabel privLabel, boolean oldFormat) throws IOException {
        boolean isSoapRequest = false;
        Account account = ev.getAccount();
        Device device = ev.getDevice();
        Locale locale = privLabel.getLocale();
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)indent);
        String PFX2 = XMLTools.PREFIX((boolean)isSoapRequest, (int)(indent + 1));
        String eventTag = oldFormat ? TAG_Event : TAG_EventData;
        this.write(pwout, PFX1);
        this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)eventTag, (String)XMLTools.ATTR((String)"device", (String)ev.getDeviceID()), (boolean)false, (boolean)true));
        long timestamp = ev.getTimestamp();
        if (allTags || timestamp > 0L) {
            TimeZone dispTmz = account.getTimeZone(null);
            DateTime ts = new DateTime(timestamp);
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Timestamp, (String)XMLTools.ATTR((String)ATTR_epoch, (long)timestamp), (boolean)false, (boolean)false));
            this.write(pwout, ts.format("yyyy/MM/dd HH:mm:ss zzz", dispTmz));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Timestamp, (boolean)true));
        }
        int statusCode = ev.getStatusCode();
        String code = "0x" + StringTools.toHexString((long)statusCode, (int)16);
        String desc = ev.getStatusCodeDescription(privLabel);
        this.write(pwout, PFX2);
        this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_StatusCode, (String)XMLTools.ATTR((String)ATTR_code, (String)code), (boolean)false, (boolean)false));
        this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)desc));
        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_StatusCode, (boolean)true));
        GeoPoint geoPoint = ev.getGeoPoint();
        if (allTags || geoPoint.isValid()) {
            long age = ev.getGpsAge();
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_GPSPoint, (String)(allTags || age > 0L ? XMLTools.ATTR((String)ATTR_age, (long)age) : ""), (boolean)false, (boolean)false));
            this.write(pwout, geoPoint.toString(','));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_GPSPoint, (boolean)true));
        }
        double speedKPH = ev.getSpeedKPH();
        if (allTags || speedKPH >= 0.0) {
            Account.SpeedUnits speedUnits = Account.getSpeedUnits(account);
            double speed = speedUnits.convertFromKPH(speedKPH);
            String units = speedUnits.toString(locale);
            double speedLimKPH = ev.getSpeedLimitKPH();
            double limit = speedLimKPH > 0.0 ? speedUnits.convertFromKPH(speedLimKPH) : 0.0;
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Speed, (String)(XMLTools.ATTR((String)ATTR_units, (String)units) + (limit > 0.0 ? XMLTools.ATTR((String)ATTR_limit, (String)StringTools.format((double)limit, (String)"0.0")) : "")), (boolean)false, (boolean)false));
            this.write(pwout, StringTools.format((double)speed, (String)"0.0"));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Speed, (boolean)true));
        }
        if (allTags || speedKPH > 0.0) {
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Heading, (String)XMLTools.ATTR((String)"degrees", (String)StringTools.format((double)ev.getHeading(), (String)"0.0")), (boolean)false, (boolean)false));
            this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)GeoPoint.GetHeadingString((double)ev.getHeading(), (Locale)locale)));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Heading, (boolean)true));
        }
        double altitudeM = ev.getAltitude();
        if (allTags || altitudeM > 0.0) {
            Account.AltitudeUnits altUnits = Account.getAltitudeUnits(account);
            int alt = (int)Math.round(altUnits.convertFromMeters(altitudeM));
            String units = altUnits.toString(locale);
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Altitude, (String)XMLTools.ATTR((String)ATTR_units, (String)units), (boolean)false, (boolean)false));
            this.write(pwout, String.valueOf(alt));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Altitude, (boolean)true));
        }
        double odomKM = ev.getOdometerWithOffsetKM();
        if (allTags || odomKM > 0.0) {
            Account.DistanceUnits distUnits = Account.getDistanceUnits(account);
            double odometer = distUnits.convertFromKM(odomKM);
            String units = distUnits.toString(locale);
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Odometer, (String)XMLTools.ATTR((String)ATTR_units, (String)units), (boolean)false, (boolean)false));
            this.write(pwout, StringTools.format((double)odometer, (String)"#0.0"));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Odometer, (boolean)true));
        }
        String geozoneID = ev.getGeozoneID();
        long geozoneNdx = ev.getGeozoneIndex();
        if (allTags || !geozoneID.equals("") || geozoneNdx > 0L) {
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Geozone, (String)XMLTools.ATTR((String)ATTR_index, (long)geozoneNdx), (boolean)false, (boolean)false));
            this.write(pwout, geozoneID);
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Geozone, (boolean)true));
        }
        String address = ev.getAddress();
        if (allTags || !address.equals("")) {
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Address, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)address));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Address, (boolean)true));
        }
        String city = ev.getCity();
        if (allTags || !city.equals("")) {
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_City, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)city));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_City, (boolean)true));
        }
        String postalCode = ev.getPostalCode();
        if (allTags || !postalCode.equals("")) {
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_PostalCode, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)postalCode));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_PostalCode, (boolean)true));
        }
        long inputMask = ev.getInputMask();
        if (allTags || inputMask != 0L) {
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_DigitalInputMask, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, "0x" + StringTools.toHexString((long)inputMask));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_DigitalInputMask, (boolean)true));
        }
        if (allTags && EventData.getFactory().hasField("driverID")) {
            String driverID = ev.getDriverID();
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_DriverID, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)driverID));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_DriverID, (boolean)true));
        }
        if (allTags && EventData.getFactory().hasField("driverMessage")) {
            String driverMsg = ev.getDriverMessage();
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_DriverMessage, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)driverMsg));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_DriverMessage, (boolean)true));
        }
        if (allTags && EventData.getFactory().hasField("engineRpm")) {
            long engineRpm = ev.getEngineRpm();
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_EngineRPM, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, String.valueOf(engineRpm));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_EngineRPM, (boolean)true));
        }
        if (allTags && EventData.getFactory().hasField("engineHours")) {
            double engineHours = ev.getEngineHours() + device.getEngineHoursOffset();
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_EngineHours, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, StringTools.format((double)engineHours, (String)"#0.0"));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_EngineHours, (boolean)true));
        }
        if (allTags && EventData.getFactory().hasField("vBatteryVolts")) {
            double battVolts = ev.getVBatteryVolts();
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_VehicleBatteryVolts, (String)"", (boolean)false, (boolean)false));
            this.write(pwout, StringTools.format((double)battVolts, (String)"#0.0"));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_VehicleBatteryVolts, (boolean)true));
        }
        if (allTags && EventData.getFactory().hasField("coolantLevel")) {
            double pct100 = ev.getCoolantLevel() * 100.0;
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_EngineCoolantLevel, (String)XMLTools.ATTR((String)ATTR_units, (String)"percent"), (boolean)false, (boolean)false));
            this.write(pwout, StringTools.format((double)pct100, (String)"#0.0"));
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_EngineCoolantLevel, (boolean)true));
        }
        if (allTags && EventData.getFactory().hasField("coolantTemp")) {
            Account.TemperatureUnits tempUnits = Account.getTemperatureUnits(account);
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_EngineCoolantTemperature, (String)XMLTools.ATTR((String)ATTR_units, (String)tempUnits.toString()), (boolean)false, (boolean)false));
            double tempC = ev.getCoolantTemp();
            if (tempC > 0.0) {
                double temp = tempUnits.convertFromC(tempC);
                this.write(pwout, StringTools.format((double)temp, (String)"#0.0"));
            }
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_EngineCoolantTemperature, (boolean)true));
        }
        if (allTags && EventData.getFactory().hasField("fuelTotal")) {
            Account.VolumeUnits volUnits = Account.getVolumeUnits(account);
            this.write(pwout, PFX2);
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_EngineFuelUsed, (String)XMLTools.ATTR((String)ATTR_units, (String)volUnits.toString()), (boolean)false, (boolean)false));
            double fuelL = ev.getFuelTotal();
            if (fuelL > 0.0) {
                double fuel = volUnits.convertFromLiters(fuelL);
                this.write(pwout, StringTools.format((double)fuel, (String)"#0.0"));
            }
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_EngineFuelUsed, (boolean)true));
        }
        this.write(pwout, PFX1);
        this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)eventTag, (boolean)true));
    }

    private void writeEvents_XML_TopTag(PrintWriter pwout, Account account, String tz, boolean startTag, boolean oldFormat) throws IOException {
        String topTag;
        boolean isSoapRequest = false;
        String string = topTag = oldFormat ? TAG_EventData : "Account";
        if (startTag) {
            this.write(pwout, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            String accountID = account != null ? account.getAccountID() : null;
            this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)topTag, (String)(XMLTools.ATTR((String)ATTR_account, (String)accountID) + XMLTools.ATTR((String)ATTR_timezone, (String)tz)), (boolean)false, (boolean)true));
            if (account != null) {
                this.write(pwout, XMLTools.PREFIX((boolean)isSoapRequest, (int)1));
                this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Description, null, (boolean)false, (boolean)false));
                this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)account.getDescription()));
                this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Description, (boolean)true));
            }
        } else {
            this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)topTag, (boolean)true));
        }
    }

    private boolean writeEvents_XML(PrintWriter pwout, Account account, Collection<Device> devList, boolean allTags, TimeZone dispTmz, BasicPrivateLabel privLabel, boolean oldFormat) throws IOException {
        boolean isSoapRequest = false;
        if (account == null) {
            return false;
        }
        String accountID = account.getAccountID();
        String tzStr = account.getTimeZone();
        if (StringTools.isBlank((String)tzStr)) {
            tzStr = "GMT";
        }
        this.writeEvents_XML_TopTag(pwout, account, tzStr, true, oldFormat);
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)1);
        String PFX2 = XMLTools.PREFIX((boolean)isSoapRequest, (int)2);
        if (!ListTools.isEmpty(devList)) {
            for (Device dev : devList) {
                Object[] evList;
                String deviceID = dev.getDeviceID();
                if (!dev.getAccountID().equals(accountID) || ListTools.isEmpty((Object[])(evList = dev.getSavedRangeEvents()))) continue;
                if (!oldFormat) {
                    this.write(pwout, PFX1);
                    this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Device, (String)XMLTools.ATTR((String)"id", (String)deviceID), (boolean)false, (boolean)true));
                    this.write(pwout, PFX2);
                    this.write(pwout, XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Description, null, (boolean)false, (boolean)false));
                    this.write(pwout, XMLTools.CDATA((boolean)isSoapRequest, (String)dev.getDescription()));
                    this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Description, (boolean)true));
                }
                for (int i = 0; i < evList.length; ++i) {
                    Object ev = evList[i];
                    if (!((AccountRecord)((Object)ev)).getAccountID().equals(accountID)) continue;
                    ((AccountRecord)((Object)ev)).setAccount(account);
                    this.writeEvents_XML_Event(pwout, dev, (EventData)ev, 2, allTags, privLabel, oldFormat);
                }
                if (oldFormat) continue;
                this.write(pwout, PFX1);
                this.write(pwout, XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Device, (boolean)true));
            }
        }
        this.writeEvents_XML_TopTag(pwout, null, null, false, oldFormat);
        this.flush(pwout);
        return true;
    }

    private boolean writeEvents_GPX(PrintWriter pwout, Account account, Collection<Device> devList, BasicPrivateLabel privLabel) throws IOException {
        String dateFmt = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        if (account == null) {
            return false;
        }
        String accountID = account.getAccountID();
        TimeZone tz = DateTime.getGMTTimeZone();
        this.write(pwout, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write(pwout, "<gpx version=\"1.0\"\n");
        this.write(pwout, "    creator=\"OpenGTS " + Version.getVersion() + " - http://www.opengts.org\"\n");
        this.write(pwout, "    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        this.write(pwout, "    xsi:schemaLocation=\"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd\">\n");
        this.write(pwout, "  <time>" + new DateTime(tz).format(dateFmt) + "</time>\n");
        if (!ListTools.isEmpty(devList)) {
            for (Device dev : devList) {
                String deviceID = dev.getDeviceID();
                if (!dev.getAccountID().equals(accountID)) continue;
                this.write(pwout, "  <trk>\n");
                this.write(pwout, "  <name><![CDATA[" + deviceID + "]]></name>\n");
                this.write(pwout, "  <desc><![CDATA[" + dev.getDescription() + "]]></desc>\n");
                this.write(pwout, "  <trkseg>\n");
                Object[] evList = dev.getSavedRangeEvents();
                if (!ListTools.isEmpty((Object[])evList)) {
                    for (Object ev : evList) {
                        this.write(pwout, "    <trkpt lat=\"" + ((EventData)ev).getLatitude() + "\" lon=\"" + ((EventData)ev).getLongitude() + "\">\n");
                        this.write(pwout, "      <time>" + new DateTime(((EventData)ev).getTimestamp(), tz).format(dateFmt) + "</time>\n");
                        this.write(pwout, "      <ele>" + ((EventData)ev).getAltitude() + "</ele>\n");
                        this.write(pwout, "    </trkpt>\n");
                    }
                }
                this.write(pwout, "  </trkseg>\n");
                this.write(pwout, "  </trk>\n");
            }
        }
        this.write(pwout, "</gpx>\n");
        return true;
    }

    public boolean writeEvents_JSON(PrintWriter pwout, Account account, Collection<Device> devList, boolean allTags, TimeZone dispTmz, BasicPrivateLabel privLabel) throws IOException {
        if (account == null) {
            return false;
        }
        String accountID = account.getAccountID();
        String acctDesc = account.getDescription();
        String tzStr = account.getTimeZone();
        if (StringTools.isBlank((String)tzStr)) {
            tzStr = "GMT";
        }
        String PFX0 = "";
        String PFX1 = StringTools.replicateString((String)JSON_INDENT, (int)1);
        String PFX2 = StringTools.replicateString((String)JSON_INDENT, (int)2);
        String PFX3 = StringTools.replicateString((String)JSON_INDENT, (int)3);
        this.writeKeyValue_JSON(pwout, PFX0, "{", null, true);
        this.writeKeyValue_JSON(pwout, PFX1, "Account", accountID, false);
        this.writeKeyValue_JSON(pwout, PFX1, "Account_desc", acctDesc, false);
        this.writeKeyValue_JSON(pwout, PFX1, "TimeZone", tzStr, false);
        this.writeKeyValue_JSON(pwout, PFX1, "DeviceList", "[", true);
        if (!ListTools.isEmpty(devList)) {
            int d = 0;
            int lastDevNdx = devList.size() - 1;
            for (Device dev : devList) {
                boolean isLastDev;
                boolean bl = isLastDev = d++ == lastDevNdx;
                if (!dev.getAccountID().equals(accountID)) continue;
                String deviceID = dev.getDeviceID();
                String deviceDesc = dev.getDescription();
                this.writeKeyValue_JSON(pwout, PFX2, "{", null, true);
                this.writeKeyValue_JSON(pwout, PFX3, TAG_Device, deviceID, false);
                EventData[] evList = dev.getSavedRangeEvents();
                if (evList != null) {
                    this.writeKeyValue_JSON(pwout, PFX3, "Device_desc", deviceDesc, false);
                    this.writeKeyValue_JSON(pwout, PFX3, TAG_EventData, "[", true);
                    int lastEventNdx = evList.length - 1;
                    for (int e = 0; e <= lastEventNdx; ++e) {
                        boolean isLastEvent;
                        EventData ev = evList[e];
                        boolean bl2 = isLastEvent = e == lastEventNdx;
                        if (!ev.getAccountID().equals(accountID)) continue;
                        ev.setAccount(account);
                        this.writeEvents_JSON_Event(pwout, e, ev, isLastEvent, 4, allTags, privLabel);
                    }
                    this.writeKeyValue_JSON(pwout, PFX3, "]", null, true);
                } else {
                    this.writeKeyValue_JSON(pwout, PFX3, "Device_desc", deviceDesc, true);
                }
                this.writeKeyValue_JSON(pwout, PFX2, "}", null, isLastDev);
            }
        }
        this.writeKeyValue_JSON(pwout, PFX1, "]", null, true);
        this.writeKeyValue_JSON(pwout, PFX0, "}", null, true);
        this.flush(pwout);
        return true;
    }

    private void writeEvents_JSON_Event(PrintWriter pwout, int index, EventData ev, boolean isLast, int indent, boolean allTags, BasicPrivateLabel privLabel) throws IOException {
        String units;
        boolean isSoapRequest = false;
        Account account = ev.getAccount();
        Device device = ev.getDevice();
        Locale locale = privLabel.getLocale();
        String PFX1 = StringTools.replicateString((String)JSON_INDENT, (int)indent);
        String PFX2 = StringTools.replicateString((String)JSON_INDENT, (int)(indent + 1));
        this.writeKeyValue_JSON(pwout, PFX1, "{", null, true);
        this.writeKeyValue_JSON(pwout, PFX2, TAG_Device, ev.getDeviceID(), false);
        long timestamp = ev.getTimestamp();
        if (allTags || timestamp > 0L) {
            TimeZone tz = account.getTimeZone(null);
            DateTime ts = new DateTime(timestamp);
            this.writeKeyValue_JSON(pwout, PFX2, TAG_Timestamp, timestamp, false);
            this.writeKeyValue_JSON(pwout, PFX2, "Timestamp_date", ts.format("yyyy/MM/dd", tz), false);
            this.writeKeyValue_JSON(pwout, PFX2, "Timestamp_time", ts.format("HH:mm:ss", tz), false);
        }
        int statusCode = ev.getStatusCode();
        String hexCode = "0x" + StringTools.toHexString((long)statusCode, (int)16);
        String desc = ev.getStatusCodeDescription(privLabel);
        this.writeKeyValue_JSON(pwout, PFX2, TAG_StatusCode, statusCode, false);
        this.writeKeyValue_JSON(pwout, PFX2, "StatusCode_hex", hexCode, false);
        this.writeKeyValue_JSON(pwout, PFX2, "StatusCode_desc", desc, false);
        GeoPoint geoPoint = ev.getBestGeoPoint();
        if (allTags || geoPoint.isValid()) {
            long gpsAge = ev.getGpsAge();
            int accuracy = (int)Math.round(ev.getBestAccuracy());
            this.writeKeyValue_JSON(pwout, PFX2, TAG_GPSPoint, geoPoint.toString(','), false);
            this._writeKeyValue_JSON(pwout, PFX2, "GPSPoint_lat", geoPoint.getLatitudeString(null, null), false);
            this._writeKeyValue_JSON(pwout, PFX2, "GPSPoint_lon", geoPoint.getLongitudeString(null, null), false);
            if (gpsAge > 0L) {
                this.writeKeyValue_JSON(pwout, PFX2, "GPSPoint_age", gpsAge, false);
            }
            if (accuracy > 0) {
                this.writeKeyValue_JSON(pwout, PFX2, "GPSPoint_accuracy", accuracy, false);
            }
        }
        double speedKPH = ev.getSpeedKPH();
        if (allTags || speedKPH >= 0.0) {
            Account.SpeedUnits speedUnits = Account.getSpeedUnits(account);
            double speed = speedUnits.convertFromKPH(speedKPH);
            String units2 = speedUnits.toString(locale);
            double speedLimKPH = ev.getSpeedLimitKPH();
            double limit = speedLimKPH > 0.0 ? speedUnits.convertFromKPH(speedLimKPH) : 0.0;
            this._writeKeyValue_JSON(pwout, PFX2, TAG_Speed, StringTools.format((double)speed, (String)"0.0"), false);
            this.writeKeyValue_JSON(pwout, PFX2, "Speed_units", units2, false);
            if (limit > 0.0) {
                this._writeKeyValue_JSON(pwout, PFX2, "Speed_limit", StringTools.format((double)limit, (String)"0.0"), false);
            }
        }
        if (allTags || speedKPH > 0.0) {
            double heading = ev.getHeading();
            String headingDesc = GeoPoint.GetHeadingString((double)heading, (Locale)locale);
            this._writeKeyValue_JSON(pwout, PFX2, TAG_Heading, StringTools.format((double)heading, (String)"0.0"), false);
            this.writeKeyValue_JSON(pwout, PFX2, "Heading_desc", headingDesc, false);
        }
        double altitudeM = ev.getAltitude();
        if (allTags || altitudeM > 0.0) {
            Account.AltitudeUnits altUnits = Account.getAltitudeUnits(account);
            int alt = (int)Math.round(altUnits.convertFromMeters(altitudeM));
            String units3 = altUnits.toString(locale);
            this.writeKeyValue_JSON(pwout, PFX2, TAG_Altitude, alt, false);
            this.writeKeyValue_JSON(pwout, PFX2, "Altitude_units", units3, false);
        }
        double odomKM = ev.getOdometerWithOffsetKM();
        if (allTags || odomKM > 0.0) {
            Account.DistanceUnits distUnits = Account.getDistanceUnits(account);
            double odometer = distUnits.convertFromKM(odomKM);
            String units4 = distUnits.toString(locale);
            this._writeKeyValue_JSON(pwout, PFX2, TAG_Odometer, StringTools.format((double)odometer, (String)"0.000"), false);
            this.writeKeyValue_JSON(pwout, PFX2, "Odometer_units", units4, false);
        }
        String geozoneID = ev.getGeozoneID();
        long geozoneNdx = ev.getGeozoneIndex();
        if (allTags || !geozoneID.equals("") || geozoneNdx > 0L) {
            this.writeKeyValue_JSON(pwout, PFX2, TAG_Geozone, geozoneID, false);
            this.writeKeyValue_JSON(pwout, PFX2, "Geozone_index", geozoneNdx, false);
        }
        String address = ev.getAddress();
        if (allTags || !address.equals("")) {
            String addrStr = StringTools.replace((String)address, (String)"\"", (String)"'");
            this.writeKeyValue_JSON(pwout, PFX2, TAG_Address, addrStr, false);
        }
        String city = ev.getCity();
        if (allTags || !city.equals("")) {
            String cityStr = StringTools.replace((String)city, (String)"\"", (String)"'");
            this.writeKeyValue_JSON(pwout, PFX2, TAG_City, cityStr, false);
        }
        String postalCode = ev.getPostalCode();
        if (allTags || !postalCode.equals("")) {
            this.writeKeyValue_JSON(pwout, PFX2, TAG_PostalCode, postalCode, false);
        }
        long inputMask = ev.getInputMask();
        if (allTags || inputMask != 0L) {
            String hexInpStr = "0x" + StringTools.toHexString((long)inputMask, (int)0);
            this.writeKeyValue_JSON(pwout, PFX2, TAG_DigitalInputMask, inputMask, false);
            this.writeKeyValue_JSON(pwout, PFX2, "DigitalInputMask_hex", hexInpStr, false);
        }
        if (allTags && EventData.getFactory().hasField("driverID")) {
            String driverID = ev.getDriverID();
            this.writeKeyValue_JSON(pwout, PFX2, TAG_DriverID, driverID, false);
        }
        if (allTags && EventData.getFactory().hasField("driverMessage")) {
            String driverMsg = StringTools.replace((String)ev.getDriverMessage(), (String)"\"", (String)"'");
            this.writeKeyValue_JSON(pwout, PFX2, TAG_DriverMessage, driverMsg, false);
        }
        if (allTags && EventData.getFactory().hasField("engineRpm")) {
            long engineRpm = ev.getEngineRpm();
            this.writeKeyValue_JSON(pwout, PFX2, TAG_EngineRPM, engineRpm, false);
        }
        if (allTags && EventData.getFactory().hasField("engineHours")) {
            double engineHours = ev.getEngineHours() + device.getEngineHoursOffset();
            this._writeKeyValue_JSON(pwout, PFX2, TAG_EngineHours, StringTools.format((double)engineHours, (String)"0.00"), false);
        }
        if (allTags && EventData.getFactory().hasField("vBatteryVolts")) {
            double battVolts = ev.getVBatteryVolts();
            this._writeKeyValue_JSON(pwout, PFX2, TAG_VehicleBatteryVolts, StringTools.format((double)battVolts, (String)"0.0"), false);
        }
        if (allTags && EventData.getFactory().hasField("coolantLevel")) {
            double pct100 = ev.getCoolantLevel() * 100.0;
            String units5 = "percent";
            this._writeKeyValue_JSON(pwout, PFX2, TAG_EngineCoolantLevel, StringTools.format((double)pct100, (String)"0.0"), false);
            this.writeKeyValue_JSON(pwout, PFX2, "EngineCoolantLevel_units", units5, false);
        }
        if (allTags && EventData.getFactory().hasField("coolantTemp")) {
            Account.TemperatureUnits tempUnits = Account.getTemperatureUnits(account);
            double tempC = ev.getCoolantTemp();
            double temp = tempUnits.convertFromC(tempC);
            units = tempUnits.toString();
            this._writeKeyValue_JSON(pwout, PFX2, TAG_EngineCoolantTemperature, StringTools.format((double)temp, (String)"0.0"), false);
            this.writeKeyValue_JSON(pwout, PFX2, "EngineCoolantTemperature_units", units, false);
        }
        if (allTags && EventData.getFactory().hasField("fuelTotal")) {
            Account.VolumeUnits volUnits = Account.getVolumeUnits(account);
            double fuelL = ev.getFuelTotal();
            double fuel = volUnits.convertFromLiters(fuelL);
            units = volUnits.toString();
            this._writeKeyValue_JSON(pwout, PFX2, TAG_EngineFuelUsed, StringTools.format((double)fuel, (String)"0.0"), false);
            this.writeKeyValue_JSON(pwout, PFX2, "EngineFuelUsed_units", units, false);
        }
        this.writeKeyValue_JSON(pwout, PFX2, "Index", index, true);
        this.writeKeyValue_JSON(pwout, PFX1, "}", null, isLast);
    }

    private void writeKeyValue_JSON(PrintWriter pwout, String pfx, String key, int value, boolean isLast) throws IOException {
        String val = String.valueOf(value);
        this._writeKeyValue_JSON(pwout, pfx, key, val, isLast);
    }

    private void writeKeyValue_JSON(PrintWriter pwout, String pfx, String key, long value, boolean isLast) throws IOException {
        String val = String.valueOf(value);
        this._writeKeyValue_JSON(pwout, pfx, key, val, isLast);
    }

    private void writeKeyValue_JSON(PrintWriter pwout, String pfx, String key, double value, boolean isLast) throws IOException {
        String val = String.valueOf(value);
        this._writeKeyValue_JSON(pwout, pfx, key, val, isLast);
    }

    private void writeKeyValue_JSON(PrintWriter pwout, String pfx, String key, String value, boolean isLast) throws IOException {
        String val = StringTools.isBlank((String)value) ? "\"\"" : (value.equals("[") ? "[" : "\"" + StringTools.escapeJSON((String)value) + "\"");
        this._writeKeyValue_JSON(pwout, pfx, key, val, isLast);
    }

    private void _writeKeyValue_JSON(PrintWriter pwout, String pfx, String key, String value, boolean isLast) throws IOException {
        if ("{".equals(key)) {
            this.write(pwout, pfx + "{\n");
        } else if ("}".equals(key)) {
            if (isLast) {
                this.write(pwout, pfx + "}\n");
            } else {
                this.write(pwout, pfx + "},\n");
            }
        } else if ("[".equals(value)) {
            this.write(pwout, pfx + "\"" + key + "\": [\n");
        } else if ("]".equals(key)) {
            this.write(pwout, pfx + "]\n");
        } else {
            this.write(pwout, pfx + "\"" + key + "\": " + value);
            if (isLast) {
                this.write(pwout, "\n");
            } else {
                this.write(pwout, ",\n");
            }
        }
    }

    private boolean writeEvents_BML(PrintWriter pwout, Account account, Collection<Device> devList, BasicPrivateLabel privLabel) throws IOException {
        if (account == null) {
            return false;
        }
        String accountID = account.getAccountID();
        pwout.write("<lbs>\n");
        if (!ListTools.isEmpty(devList)) {
            for (Device dev : devList) {
                Object[] evList;
                String deviceID = dev.getDeviceID();
                if (!dev.getAccountID().equals(accountID) || ListTools.isEmpty((Object[])(evList = dev.getSavedRangeEvents()))) continue;
                for (Object ev : evList) {
                    if (!((AccountRecord)((Object)ev)).getAccountID().equals(accountID)) continue;
                    ((AccountRecord)((Object)ev)).setAccount(account);
                    pwout.write("<location lon=\"" + ((EventData)ev).getLongitude() + "\" lat=\"" + ((EventData)ev).getLatitude() + "\"");
                    pwout.write(" label=\"" + ((DeviceRecord)((Object)ev)).getDeviceID() + "\"");
                    pwout.write(" description=\"" + ((EventData)ev).getAddress() + "\"");
                    pwout.write("/>\n");
                }
            }
        }
        pwout.write("</lbs>\n");
        return true;
    }

    private boolean writeEvents_AEMP(PrintWriter pwout, Account account, Collection<Device> devList, BasicPrivateLabel privLabel) throws IOException {
        if (account == null) {
            return false;
        }
        String accountID = account.getAccountID();
        if (!ListTools.isEmpty(devList)) {
            // empty if block
        }
        return false;
    }

    public boolean writeEvents(OutputStream out, Account account, Collection<Device> devList, int formatEnum, boolean allTags, TimeZone tmz, BasicPrivateLabel privLabel) throws IOException {
        PrintWriter pwout = out != null ? new PrintWriter(out) : null;
        return this.writeEvents(pwout, account, devList, formatEnum, allTags, tmz, privLabel);
    }

    public boolean writeEvents(PrintWriter pwout, Account account, Collection<Device> devList, int formatEnum, boolean allTags, TimeZone dispTmz, BasicPrivateLabel privLabel) throws IOException {
        if (devList != null) {
            switch (formatEnum) {
                case 1: 
                case 5: {
                    return this.writeEvents_CSV(pwout, account, devList, allTags, dispTmz, ',', true, privLabel);
                }
                case 2: {
                    return GoogleKML.getInstance().writeEvents(pwout, account, devList, privLabel);
                }
                case 3: 
                case 4: {
                    return this.writeEvents_XML(pwout, account, devList, allTags, dispTmz, privLabel, formatEnum == 4);
                }
                case 6: {
                    return this.writeEvents_GPX(pwout, account, devList, privLabel);
                }
                case 7: 
                case 8: {
                    return this.writeEvents_JSON(pwout, account, devList, allTags, dispTmz, privLabel);
                }
                case 9: {
                    return this.writeEvents_BML(pwout, account, devList, privLabel);
                }
                case 10: {
                    return this.writeEvents_AEMP(pwout, account, devList, privLabel);
                }
            }
            Print.logError((String)("Unrecognized data format: " + formatEnum), (Object[])new Object[0]);
            return false;
        }
        return false;
    }

    public static OutputStream openFileOutputStream(String outFile) {
        try {
            if (StringTools.isBlank((String)outFile) || outFile.equalsIgnoreCase("stdout")) {
                return System.out;
            }
            if (outFile.equalsIgnoreCase("stderr")) {
                return System.err;
            }
            return new FileOutputStream(outFile, false);
        }
        catch (IOException ioe) {
            Print.logException((String)("Unable to open output file: " + outFile), (Throwable)ioe);
            return null;
        }
    }

    public static void closeOutputStream(OutputStream out) {
        if (out != null && out != System.out && out != System.err) {
            try {
                out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static long[] parseArgDateRange(String range, TimeZone tz) {
        String[] rangeFlds = StringTools.parseStringArray((String)range, (String)"|,");
        long startTime = -1L;
        if (rangeFlds.length >= 1) {
            if (rangeFlds[0].indexOf("/") >= 0) {
                try {
                    DateTime startDT = DateTime.parseArgumentDate((String)rangeFlds[0], (TimeZone)tz, (boolean)false);
                    Print.logInfo((String)("Start Date: " + startDT), (Object[])new Object[0]);
                    startTime = startDT != null ? startDT.getTimeSec() : -1L;
                }
                catch (DateTime.DateParseException dtpe) {
                    Print.logError((String)("Invalid Start Date: " + rangeFlds[0] + " [" + dtpe.getMessage() + "]"), (Object[])new Object[0]);
                    startTime = -1L;
                }
            } else {
                startTime = StringTools.parseLong((String)rangeFlds[0], (long)-1L);
            }
        }
        long endTime = -1L;
        if (rangeFlds.length >= 2) {
            if (rangeFlds[1].indexOf("/") >= 0) {
                try {
                    DateTime endDT = DateTime.parseArgumentDate((String)rangeFlds[1], (TimeZone)tz, (boolean)true);
                    Print.logInfo((String)("End Date: " + endDT), (Object[])new Object[0]);
                    endTime = endDT != null ? endDT.getTimeSec() : -1L;
                }
                catch (DateTime.DateParseException dtpe) {
                    Print.logError((String)("Invalid End Date: " + rangeFlds[1] + " [" + dtpe.getMessage() + "]"), (Object[])new Object[0]);
                    endTime = -1L;
                }
            } else {
                endTime = StringTools.parseLong((String)rangeFlds[1], (long)-1L);
            }
        }
        long limit = -1L;
        if (rangeFlds.length >= 3) {
            limit = StringTools.parseLong((String)rangeFlds[2], (long)-1L);
        }
        if (startTime <= 0L && endTime <= 0L) {
            return null;
        }
        return new long[]{startTime, endTime, limit};
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + EventUtil.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>                  Acount ID which owns Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>                   Device ID to create/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -events=<count>                Write last <count> events to output file", (Object[])new Object[0]);
        Print.logInfo((String)"  -events=<from>,<to>[,<limit>]  Write events in specified range to output file", (Object[])new Object[0]);
        Print.logInfo((String)"  -format=[csv|kml]              Event output format", (Object[])new Object[0]);
        Print.logInfo((String)"  -output=<file>                 Event output file", (Object[])new Object[0]);
        Print.logInfo((String)"  -geozone=<from>,<to> [-update] Look for matching geozones for account/device", (Object[])new Object[0]);
        Print.logInfo((String)"  -geocode=<from>,<to> [-update] Apply reverse-geocode to addresses", (Object[])new Object[0]);
        Print.logInfo((String)"  -update                        Update matching geozone/address", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        long endTime;
        long[] rangeTime;
        DBConfig.cmdLineInit(argv, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (acctID == null || acctID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            EventUtil.usage();
        } else if (devID == null || devID.equals("")) {
            Print.logError((String)"Device-ID not specified.", (Object[])new Object[0]);
            EventUtil.usage();
        }
        Account acct = null;
        try {
            acct = Account.getAccount(acctID);
            if (acct == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                EventUtil.usage();
            }
        }
        catch (DBException dbe) {
            Print.logError((String)("Error loading Account: " + acctID), (Object[])new Object[0]);
            dbe.printException();
            System.exit(99);
        }
        TimeZone timeZone = DateTime.getTimeZone((String)acct.getTimeZone());
        BasicPrivateLabel privLabel = acct.getPrivateLabel();
        boolean allTags = true;
        Device[] devList = null;
        try {
            if (devID.equals("*") || devID.equals("ALL")) {
                OrderedSet<String> devIdList = Device.getDeviceIDsForAccount(acctID, null, true);
                if (devIdList.size() <= 0) {
                    Print.logError((String)("Account does not contain any Devices: " + acctID), (Object[])new Object[0]);
                    EventUtil.usage();
                }
                devList = new Device[devIdList.size()];
                for (int i = 0; i < devIdList.size(); ++i) {
                    Device dev = Device.getDevice(acct, (String)devIdList.get(i));
                    if (dev == null) {
                        Print.logError((String)("Device-ID does not exist: " + acctID + "," + (String)devIdList.get(i)), (Object[])new Object[0]);
                        EventUtil.usage();
                    }
                    devList[i] = dev;
                }
            } else {
                Device dev = Device.getDevice(acct, devID);
                if (dev == null) {
                    Print.logError((String)("Device-ID does not exist: " + acctID + "," + devID), (Object[])new Object[0]);
                    EventUtil.usage();
                }
                devList = new Device[]{dev};
            }
        }
        catch (DBException dbe) {
            Print.logError((String)("Error loading Device: " + acctID + "," + devID), (Object[])new Object[0]);
            dbe.printException();
            System.exit(99);
        }
        if (RTConfig.hasProperty((String[])ARG_EVENTS)) {
            String evFile;
            OutputStream fos;
            long startTime = -1L;
            long endTime2 = -1L;
            long limit = 30L;
            long[] rangeTime2 = EventUtil.parseArgDateRange(RTConfig.getString((String[])ARG_EVENTS, (String)""), timeZone);
            if (rangeTime2 != null) {
                startTime = rangeTime2[0];
                endTime2 = rangeTime2[1];
                long l = limit = rangeTime2[2] > 0L ? rangeTime2[2] : 30L;
            }
            if ((fos = EventUtil.openFileOutputStream(evFile = RTConfig.getString((String[])ARG_OUTPUT, (String)""))) == null) {
                System.exit(1);
            }
            try {
                EventData[] evList = null;
                evList = startTime <= 0L && endTime2 <= 0L ? devList[0].getLatestEvents(limit, false) : devList[0].getRangeEvents(startTime, endTime2, false, EventData.LimitType.FIRST, limit);
                devList[0].setSavedRangeEvents(evList);
            }
            catch (DBException dbe) {
                dbe.printException();
                System.exit(99);
            }
            int outFmt = EventUtil.parseOutputFormat(RTConfig.getString((String[])ARG_FORMAT, null), 1);
            EventUtil evUtil = new EventUtil();
            try {
                Vector<Device> devVector = new Vector<Device>();
                devVector.add(devList[0]);
                evUtil.writeEvents(fos, acct, devVector, outFmt, allTags, null, privLabel);
            }
            catch (IOException t) {
                Print.logException((String)"Error writing events", (Throwable)t);
                System.exit(1);
            }
            EventUtil.closeOutputStream(fos);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_GEOZONE)) {
            rangeTime = EventUtil.parseArgDateRange(RTConfig.getString((String[])ARG_GEOZONE, (String)""), timeZone);
            if (rangeTime == null) {
                Print.logError((String)"Date range not specified...", (Object[])new Object[0]);
                System.exit(99);
            }
            long startTime = rangeTime[0];
            endTime = rangeTime[1];
            try {
                final Account rhAccount = acct;
                final boolean rhUpdate = RTConfig.getBoolean((String[])ARG_UPDATE, (boolean)false);
                final String[] rhUpdateFields = new String[]{"geozoneID", "address"};
                EventData.getRangeEvents(devList[0].getAccountID(), devList[0].getDeviceID(), startTime, endTime, null, true, EventData.LimitType.FIRST, -1L, true, null, new DBRecordHandler<EventData>(){

                    public int handleDBRecord(EventData rcd) throws DBException {
                        EventData ev = rcd;
                        GeoPoint gp = ev.getGeoPoint();
                        Geozone gz = Geozone.getGeozone(rhAccount, null, gp, true);
                        if (gz != null) {
                            if (rhUpdate) {
                                Print.logInfo((String)("Updating Geozone: [" + gz.getGeozoneID() + "] " + gz.getDescription()), (Object[])new Object[0]);
                                ev.setGeozoneID(gz.getGeozoneID());
                                ev.setAddress(gz.getDescription());
                                ev.update(rhUpdateFields);
                            } else {
                                Print.logInfo((String)("Found Geozone: [" + gz.getGeozoneID() + "] " + gz.getDescription()), (Object[])new Object[0]);
                            }
                        }
                        return 1;
                    }
                });
            }
            catch (DBException dbe) {
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_GEOCODE)) {
            ReverseGeocodeProvider rgp;
            rangeTime = EventUtil.parseArgDateRange(RTConfig.getString((String[])ARG_GEOCODE, (String)""), timeZone);
            if (rangeTime == null) {
                Print.logError((String)"Date range not specified...", (Object[])new Object[0]);
                System.exit(99);
            }
            long startTime = rangeTime[0];
            endTime = rangeTime[1];
            Print.sysPrintln((String)"Reverse-geocoding events in range:", (Object[])new Object[0]);
            Print.sysPrintln((String)("   Start - " + new DateTime(startTime)), (Object[])new Object[0]);
            Print.sysPrintln((String)("   End   - " + new DateTime(endTime)), (Object[])new Object[0]);
            Account.GeocoderMode geocoderMode = Account.getGeocoderMode(acct);
            if (geocoderMode.isNone()) {
                Print.logError((String)("GeocoderMode is set to NONE for this account: " + acct.getAccountID()), (Object[])new Object[0]);
                System.exit(99);
            }
            if (geocoderMode.okPartial() && (rgp = acct.getPrivateLabel().getReverseGeocodeProvider()) == null) {
                Print.logError((String)("No ReverseGeocodeProvider for this account: " + acct.getAccountID()), (Object[])new Object[0]);
                System.exit(99);
            }
            for (int d = 0; d < devList.length; ++d) {
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                Print.sysPrintln((String)("--- Reverse-Gecoding Events: " + devList[d].getAccountID() + "," + devList[d].getDeviceID()), (Object[])new Object[0]);
                try {
                    final Account rhAccount = acct;
                    final Device rhDevice = devList[d];
                    final boolean rhUpdate = RTConfig.getBoolean((String[])ARG_UPDATE, (boolean)false);
                    boolean rhForceUpdate = false;
                    final AccumulatorLong accum = new AccumulatorLong(0L);
                    EventData.getRangeEvents(devList[d].getAccountID(), devList[d].getDeviceID(), startTime, endTime, null, true, EventData.LimitType.FIRST, -1L, true, null, new DBRecordHandler<EventData>(){

                        public int handleDBRecord(EventData rcd) throws DBException {
                            EventData ev = rcd;
                            ev.setAccount(rhAccount);
                            ev.setDevice(rhDevice);
                            accum.increment();
                            String dt = new DateTime(ev.getTimestamp()).shortFormat(null);
                            try {
                                Set<String> updf = ev.updateAddress(false, false);
                                if (!ListTools.isEmpty(updf)) {
                                    if (rhUpdate) {
                                        Print.logInfo((String)("Update: [" + dt + "] " + ev.getAddress()), (Object[])new Object[0]);
                                        ev.update(updf);
                                    } else {
                                        Print.logWarn((String)("Found : [" + dt + "] " + ev.getAddress() + " [NOT UPDATED]"), (Object[])new Object[0]);
                                    }
                                }
                            }
                            catch (SlowOperationException soe) {
                                // empty catch block
                            }
                            return 1;
                        }
                    });
                    continue;
                }
                catch (DBException dbe) {
                    dbe.printException();
                    System.exit(99);
                }
            }
            System.exit(0);
        }
        EventUtil.usage();
    }

    static {
        EventUtil.getInstance();
        JSON_INDENT = "   ";
        ARG_ACCOUNT = new String[]{"acct", ATTR_account};
        ARG_DEVICE = new String[]{"dev", "device"};
        ARG_EVENTS = new String[]{"events"};
        ARG_OUTPUT = new String[]{"out", "output"};
        ARG_FORMAT = new String[]{"fmt", "format"};
        ARG_GEOZONE = new String[]{"geozone"};
        ARG_GEOCODE = new String[]{"rg", "geocode"};
        ARG_UPDATE = new String[]{"update", "upd"};
    }

    public static interface OptionalEventFields {
        public int getOptionalEventFieldCount(boolean var1);

        public String getOptionalEventFieldTitle(int var1, boolean var2, Locale var3);

        public String getOptionalEventFieldValue(int var1, boolean var2, Locale var3, EventDataProvider var4);
    }
}

