/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.util.Locale;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.StringTools;

public abstract class EntityManager {
    public static EntityType getDefaultEntityType() {
        return (EntityType)EnumTools.getDefault(EntityType.class);
    }

    public static EntityType getEntityType(EntityType et) {
        return et != null ? et : EntityManager.getDefaultEntityType();
    }

    public static EntityType getEntityTypeFromName(String etn) {
        EntityType et = EntityManager.getEntityTypeFromName(etn, null);
        return et != null ? et : EntityManager.getDefaultEntityType();
    }

    public static EntityType getEntityTypeFromCode(long etc, EntityType dft) {
        return (EntityType)EnumTools.getValueOf(EntityType.class, (int)((int)etc), (Enum)dft);
    }

    public static EntityType getEntityTypeFromName(String etn, EntityType dft) {
        if (!StringTools.isBlank((String)etn)) {
            if (etn.equalsIgnoreCase("TRAILER")) {
                return EntityType.TRAILER;
            }
            if (etn.equalsIgnoreCase("DRIVER")) {
                return EntityType.DRIVER;
            }
            if (etn.equalsIgnoreCase("PERSON")) {
                return EntityType.PERSON;
            }
            if (etn.equalsIgnoreCase("ANIMAL")) {
                return EntityType.ANIMAL;
            }
            if (etn.equalsIgnoreCase("CONTAINER")) {
                return EntityType.CONTAINER;
            }
            if (etn.equalsIgnoreCase("PACKAGE")) {
                return EntityType.PACKAGE;
            }
            if (etn.equalsIgnoreCase("TOOL")) {
                return EntityType.TOOL;
            }
            if (etn.equalsIgnoreCase("EQUIPMENT")) {
                return EntityType.EQUIPMENT;
            }
            if (etn.equalsIgnoreCase("EQUIP")) {
                return EntityType.EQUIPMENT;
            }
            if (etn.equalsIgnoreCase("RFID")) {
                return EntityType.RFID_00;
            }
            if (etn.equalsIgnoreCase("RFID_00")) {
                return EntityType.RFID_00;
            }
            if (etn.equalsIgnoreCase("RFID_0")) {
                return EntityType.RFID_00;
            }
            if (etn.equalsIgnoreCase("RFID_01")) {
                return EntityType.RFID_01;
            }
            if (etn.equalsIgnoreCase("RFID_1")) {
                return EntityType.RFID_01;
            }
            if (etn.equalsIgnoreCase("RFID_02")) {
                return EntityType.RFID_02;
            }
            if (etn.equalsIgnoreCase("RFID_2")) {
                return EntityType.RFID_02;
            }
            if (etn.equalsIgnoreCase("RFID_03")) {
                return EntityType.RFID_03;
            }
            if (etn.equalsIgnoreCase("RFID_3")) {
                return EntityType.RFID_03;
            }
            if (etn.equalsIgnoreCase("RFID_04")) {
                return EntityType.RFID_04;
            }
            if (etn.equalsIgnoreCase("RFID_4")) {
                return EntityType.RFID_04;
            }
        }
        return dft;
    }

    public static int[] getStatusCodesForEntityType(EntityType etype) {
        EntityType et = EntityManager.getEntityType(etype);
        switch (et) {
            case TRAILER: {
                return new int[]{63525, 63526};
            }
            case DRIVER: {
                return new int[]{63505, 63506};
            }
            case PERSON: {
                return new int[]{63532, 63533};
            }
            case RFID_00: 
            case RFID_01: 
            case RFID_02: 
            case RFID_03: 
            case RFID_04: {
                return new int[]{63529, 63530};
            }
        }
        return new int[]{63521, 63522};
    }

    public static EntityType getEntityTypeForStatusCode(int sc, EntityType dft) {
        switch (sc) {
            case 63505: 
            case 63506: {
                return EntityType.DRIVER;
            }
            case 63524: 
            case 63525: 
            case 63526: 
            case 63527: {
                return EntityType.TRAILER;
            }
            case 63528: 
            case 63529: 
            case 63530: 
            case 63531: {
                return EntityType.RFID_00;
            }
            case 63532: 
            case 63533: 
            case 63534: 
            case 63535: {
                return EntityType.PERSON;
            }
        }
        return dft;
    }

    public abstract boolean insertEntityChange(EventData var1);

    public abstract String[] getAttachedEntityIDs(String var1, String var2, long var3) throws DBException;

    public abstract String[] getAttachedEntityDescriptions(String var1, String var2, long var3) throws DBException;

    public abstract String getEntityDescription(String var1, String var2, long var3);

    public abstract boolean isEntityAttached(String var1, String var2, String var3, long var4);

    public static enum EntityType implements EnumTools.StringLocale,
    EnumTools.IntValue
    {
        GENERAL(0, "GENERAL", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.general", (String)"General")),
        TRAILER(1, "TRAILER", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.trailer", (String)"Trailer")),
        DRIVER(100, "DRIVER", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.driver", (String)"Driver")),
        PERSON(200, "PERSON", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.person", (String)"Person")),
        ANIMAL(300, "ANIMAL", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.animal", (String)"Animal")),
        CONTAINER(400, "CONTAINER", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.container", (String)"Container")),
        PACKAGE(500, "PACKAGE", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.package", (String)"Package")),
        TOOL(600, "TOOL", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.tool", (String)"Tool")),
        EQUIPMENT(700, "EQUIPMENT", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.equipment", (String)"Equipment")),
        RFID_00(900, "RFID_00", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.rfid_0", (String)"RFID Type 0")),
        RFID_01(901, "RFID_01", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.rfid_1", (String)"RFID Type 1")),
        RFID_02(902, "RFID_02", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.rfid_2", (String)"RFID Type 2")),
        RFID_03(903, "RFID_03", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.rfid_3", (String)"RFID Type 3")),
        RFID_04(904, "RFID_04", I18N.getString(EntityManager.class, (String)"EntityManager.EntityType.rfid_4", (String)"RFID Type 4"));

        private int vv = 0;
        private String nn = "";
        private I18N.Text aa = null;

        private EntityType(int v, String n2, I18N.Text a) {
            this.vv = v;
            this.nn = n2;
            this.aa = a;
        }

        public String getName() {
            return this.nn;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean isTrailer() {
            return this.equals((Object)TRAILER);
        }

        public boolean isDriver() {
            return this.equals((Object)DRIVER);
        }

        public boolean isPerson() {
            return this.equals((Object)PERSON);
        }

        public boolean isRFID() {
            return this.equals((Object)RFID_00) || this.equals((Object)RFID_01) || this.equals((Object)RFID_02) || this.equals((Object)RFID_03) || this.equals((Object)RFID_04);
        }

        public boolean isType(int type) {
            return this.getIntValue() == type;
        }
    }
}

