/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import org.opengts.db.AccountRecord;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DeviceRecord<RT extends DBRecord>
extends AccountRecord<RT> {
    public static final String FLD_deviceID = "deviceID";
    private Device device = null;
    private String deviceDesc = null;
    private String deviceVIN = null;

    public static DBField newField_deviceID(boolean priKey) {
        return DeviceRecord.newField_deviceID(priKey, null, (I18N.Text)null);
    }

    public static DBField newField_deviceID(boolean priKey, String xAttr) {
        return DeviceRecord.newField_deviceID(priKey, xAttr, (I18N.Text)null);
    }

    public static DBField newField_deviceID(boolean priKey, String xAttr, I18N.Text title) {
        if (title == null) {
            title = I18N.getString(DeviceRecord.class, (String)"DeviceRecord.fld.deviceID", (String)"Device/Asset ID");
        }
        String attr = (priKey ? "key=true" : "edit=2") + (StringTools.isBlank((String)xAttr) ? "" : " " + xAttr);
        return new DBField(FLD_deviceID, String.class, DBField.TYPE_DEV_ID(), title, attr);
    }

    public static DBField newField_deviceID(boolean priKey, String xAttr, String title) {
        if (StringTools.isBlank((String)title)) {
            return DeviceRecord.newField_deviceID(priKey, xAttr, (I18N.Text)null);
        }
        String attr = (priKey ? "key=true" : "edit=2") + (StringTools.isBlank((String)xAttr) ? "" : " " + xAttr);
        return new DBField(FLD_deviceID, String.class, DBField.TYPE_DEV_ID(), title, attr);
    }

    public DeviceRecord() {
    }

    public DeviceRecord(DeviceKey<RT> key) {
        super(key);
    }

    public final String getDeviceID() {
        String v = (String)this.getKeyValue(FLD_deviceID);
        return v != null ? v : "";
    }

    public void setDeviceID(String v) {
        this.setKeyValue(FLD_deviceID, v != null ? v : "");
    }

    public final boolean hasDevice() {
        return this.device != null;
    }

    public final Device getDevice() {
        if (this.device == null) {
            String deviceID = this.getDeviceID();
            Print.logInfo((String)("[Optimize] Retrieving Device record: " + this.getAccountID() + "/" + deviceID), (Object[])new Object[0]);
            try {
                this.device = Device.getDevice(this.getAccount(), deviceID);
                if (this.device == null) {
                    Print.logError((String)("Device not found: " + this.getAccountID() + "/" + deviceID), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Device not found: " + this.getAccountID() + "/" + deviceID), (Object[])new Object[0]);
                this.device = null;
            }
        }
        return this.device;
    }

    public final void setDevice(Device dev) {
        if (this instanceof Device) {
            if (this != dev) {
                Print.logError((String)("'this' is already an Device: " + this.getAccountID() + "/" + this.getDeviceID()), (Object[])new Object[0]);
            }
        } else if (dev == null) {
            this.device = null;
        } else if (!this.getAccountID().equals(dev.getAccountID()) || !this.getDeviceID().equals(dev.getDeviceID())) {
            Print.logError((String)("Account/Device IDs do not match: " + this.getAccountID() + "/" + this.getDeviceID()), (Object[])new Object[0]);
            this.device = null;
        } else {
            this.setAccount(dev.getAccount());
            this.device = dev;
        }
    }

    public final String getDeviceDescription() {
        if (this.deviceDesc == null) {
            Device dev = this.getDevice();
            this.deviceDesc = dev != null ? dev.getDescription() : this.getDeviceID();
        }
        return this.deviceDesc;
    }

    public final String getDeviceVIN() {
        if (this.deviceVIN == null) {
            Device dev = this.getDevice();
            if (dev != null) {
                this.deviceVIN = StringTools.blankDefault((String)dev.getDisplayName(), (String)dev.getVehicleID());
            }
            if (StringTools.isBlank((String)this.deviceVIN)) {
                this.deviceVIN = this.getDeviceID();
            }
        }
        return this.deviceVIN;
    }

    public static abstract class DeviceKey<RT extends DBRecord>
    extends AccountRecord.AccountKey<RT> {
    }
}

